// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef NAMING_DATABASE_H
#define NAMING_DATABASE_H

//
// This class reads or writes the contents of a NamingContext to or from
// a persistent store.
//
class NamingDatabase OB_COLON_RECURSIVE_MUTEX
{
    CORBA_ORB_var orb_; // The ORB.

    CORBA_String_var host_; /// The host.
    CORBA_UShort port_; // The port.

    CORBA_String_var logFile_; // The name of the logfile.
    CORBA_String_var logFileNew_; // The name of the new logfile.
    CORBA_String_var logFileBack_; // The name of the backup logfile.

    NamingContextSet* ncs_; // The current set of naming contexts.
    FILE* os_; // A FILE* to the database.

    bool noUpdates_; // No automatic updates.
    bool initializing_; // Are we restoring the naming contexts?
    bool update_; // Do we need an journal update?
    bool noflush_; // Do we want to flush on each update?

    void dumpContext(CosNaming_NamingContext_ptr nc);

    void writeAny(const CORBA_Any& any);
    
    bool doRename(const char*, const char*);
    bool exists(const char*);
    void openLog(bool);

public:

    NamingDatabase(CORBA_BOA_ptr, CORBA_ORB_ptr, const char*,
		   NamingContextSet*, bool, bool&, bool = false);
    ~NamingDatabase();
    
    //
    // Dump the full journal
    //
    void updateJournal();

    //
    // Create journal entries
    //
    void create(CosNaming_NamingContext_ptr, long);
    void destroy(CosNaming_NamingContext_ptr nc);
    void bind(CosNaming_NamingContext_ptr, const CosNaming_Name&,
              const CosNaming_OBNamingContext::NcOrObj&, long, bool);
    void unbind(CosNaming_NamingContext_ptr,
                const CosNaming_Name&);
    void info();
};

#endif
