// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <assert.h>
#include <stdlib.h>
#include <string.h>

#include <OB/CORBA.h>
#include <OB/Util.h>

#include <OB/CosNaming.h>

#include "TestMacro.h"


//
// Test CosNaming_NamingContextExt::to_string()
//
void
TestToString(CORBA_ORB_ptr orb, CosNaming_NamingContextExt_ptr root)
{
    CosNaming_Name name;
    CosNaming_NamingContextExt::StringName_var str;

    //
    // Test name components with both ID and Kind field
    //
    name.length(2);
    name[0].id = CORBA_string_dup("first");
    name[0].kind = CORBA_string_dup("node");
    name[1].id = CORBA_string_dup("second");
    name[1].kind = CORBA_string_dup("node");
    SUCCEED(str = root -> to_string(name));
    assert(strcmp(str, "first.node/second.node") == 0);

    //
    // Test name components with missing Kind field
    //
    name.length(2);
    name[0].id = CORBA_string_dup("first");
    name[0].kind = CORBA_string_dup("node");
    name[1].id = CORBA_string_dup("second");
    name[1].kind = CORBA_string_dup("");
    SUCCEED(str = root -> to_string(name));
    assert(strcmp(str, "first.node/second") == 0);

    //
    // Test name components with missing ID field
    //
    name.length(2);
    name[0].id = CORBA_string_dup("first");
    name[0].kind = CORBA_string_dup("node");
    name[1].id = CORBA_string_dup("");
    name[1].kind = CORBA_string_dup("kind");
    SUCCEED(str = root -> to_string(name));
    assert(strcmp(str, "first.node/.kind") == 0);

    //
    // Test node with empty ID and Kind field
    //
    name.length(3);
    name[0].id = CORBA_string_dup("first");
    name[0].kind = CORBA_string_dup("node");
    name[1].id = CORBA_string_dup("");
    name[1].kind = CORBA_string_dup("");
    name[2].id = CORBA_string_dup("third");
    name[2].kind = CORBA_string_dup("node");
    SUCCEED(str = root -> to_string(name));
    assert(strcmp(str, "first.node//third.node") == 0);

    //
    // Test nodes with characters that have to be escaped
    //
    name.length(3);
    name[0].id = CORBA_string_dup("first");
    name[0].kind = CORBA_string_dup("node.bla");
    name[1].id = CORBA_string_dup("second/bla");
    name[1].kind = CORBA_string_dup("node");
    name[2].id = CORBA_string_dup("third");
    name[2].kind = CORBA_string_dup("\\node");
    SUCCEED(str = root -> to_string(name));
    assert(strcmp(str,
		  "first.node\\.bla/second\\/bla.node/third.\\\\node") == 0);

    //
    // Test empty name
    //
    name.length(0);
    SUCCEED(str = root -> to_string(name));
    assert(strlen(str) == 0);
}
