// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/NTService.h>

#include <HelloWorldService.h>

#ifndef HAVE_JTC
#   error This demo only supports ORBacus with JThreads/C++ support
#endif

static void
usage(const char* progName)
{
    cerr << "Usage:\n";
    cerr << progName << " [options]\n"
	"\n"
	"Options:\n"
	"-h, --help             Show this message.\n"
	"-i, --install          Install the service.\n"
	"-u, --uninstall        Uninstall the service.\n"
        "-d, --debug            Run in console mode.\n"
	;
}

int
main(int argc, char* argv[])
{
    HelloWorldService service;

    //
    // Next parse the command line.
    //
    CORBA_Long i;
    for(i = 1 ; i < argc && *argv[i] == '-' ; i++)
    {
        if(strcmp(argv[i], "--help") == 0 ||
           strcmp(argv[i], "-h") == 0)
        {
            usage(argv[0]);
            return 0;
        }
        else if(strcmp(argv[i], "--install") == 0 ||
                strcmp(argv[i], "-i") == 0)
        {
            service.install();
            return 0;
        }
        else if(strcmp(argv[i], "--uninstall") == 0 ||
                strcmp(argv[i], "-u") == 0)
        {
            service.uninstall();
            return 0;
        }
        else if(strcmp(argv[i], "--debug") == 0 ||
                strcmp(argv[i], "-d") == 0)
        {
	    service.setDebug();
        }
        else if(strncmp(argv[i], "-OA", 3) != 0 &&
		strncmp(argv[i], "-ORB", 4) != 0)
        {
            cerr << argv[0] << ": unknown option `"
                 << argv[i] << "'\n" << endl;
            usage(argv[0]);
            return 1;
        }
    }
    
    service.run(argc, argv);

    return 0;
}
