# **********************************************************************
#
# Copyright (c) 1999
# Object Oriented Concepts, Inc.
# Billerica, MA, USA
#
# All Rights Reserved
#
# **********************************************************************

top_srcdir	= ..\..

SERVER_NAME	= server.exe

TARGETS		= $(SERVER_NAME) \
		  Receiver_skel.obj \
		  ReceiverBase_impl.obj

!include $(top_srcdir)\config\Make.rules.mak

COMMON_OBJS	= Receiver.obj \
		  Broadcaster.obj

SERVER_OBJS	= Server.obj \
		  Broadcaster_skel.obj \
		  Broadcaster_impl.obj

CLIENT_OBJS	= Client.obj \
		  Receiver_skel.obj \
		  ReceiverBase_impl.obj \
		  Receiver_impl.obj

ALL_CXXFLAGS	= $(CXXFLAGS)
ALL_CPPFLAGS	= /I. $(OB_CPPFLAGS) $(CPPFLAGS)
ALL_LIBS	= $(OB_LIBS) $(LIBS)

$(SERVER_NAME): $(COMMON_OBJS) $(SERVER_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(SERVER_OBJS) $(ALL_LIBS)

Receiver.cpp Receiver.h: Receiver.idl
	del /q Receiver.cpp Receiver.h
	del /q Receiver_skel.cpp Receiver_skel.h
	$(IDL) -I. --no-type-codes Receiver.idl

Receiver_skel.cpp Receiver_skel.h: Receiver.cpp

Broadcaster.cpp Broadcaster.h: Broadcaster.idl
	del /q Broadcaster.cpp Broadcaster.h
	del /q Broadcaster_skel.cpp Broadcaster_skel.h
	$(IDL) -I. --no-type-codes Broadcaster.idl

Broadcaster_skel.cpp Broadcaster_skel.h: Broadcaster.cpp

!if "$(WITH_JTC)" != "yes" # WinClient.mak doesn't work with JThreads/C++

all depend clean::
	@cmd /c "cd Windows & $(MAKE) /f WinClient.mak $@"

!endif

!include .windep
