// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef RECEIVER_BASE_H
#define RECEIVER_BASE_H

#include <Broadcaster.h>
#include <Receiver_skel.h>

class ReceiverBase_impl : public Receiver_skel
{
protected:

    //
    // My ID, host and nickname
    //
    CORBA_String_var id_;
    CORBA_String_var host_;
    CORBA_String_var nick_;

    //
    // The server object reference
    //
    Broadcaster_var server_;

    //
    // Handle common errors
    //
    void registerAgain(const CORBA_COMM_FAILURE&);
    void unknownNick(const char*);
    void nickExists(const char*);

    //
    // Register with the server
    //
    virtual void _register();

public:

    ReceiverBase_impl(Broadcaster_ptr);

    //
    // Parse input
    //
    virtual void parse(const char*);

    //
    // Execute command
    //
    virtual void execute(const char*);

    //
    // Execute specific receiver commands
    //
    virtual void cmdAbout();
    virtual void cmdHelp();
    virtual void cmdQuit();
    virtual void cmdMsg(const char*, const char*);
    virtual void cmdNick(const char*);
    virtual void cmdWho();
    virtual void cmdWhois(const char*);

    //
    // Print `about' and `help' text
    //
    virtual void about();
    virtual void help();

    //
    // Quit program
    //
    virtual void quit();

    //
    // Functions from the .idl file
    //
    virtual void print(const char*);
};

#endif
