// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>
#include <OB/OCI.h>
#include <OB/OCI_IIOP.h>
#include <Broadcaster_impl.h>

#include <stdlib.h>
#include <time.h>

int
main(int argc, char* argv[], char*[])
{
    try
    {
	//
	// Create ORB and BOA
	//
	CORBA_ORB_var orb = CORBA_ORB_init(argc, argv);
	CORBA_BOA_var boa = orb -> BOA_init(argc, argv);
	
	//
	// Create implementation object
	//
	Broadcaster_var p = new Broadcaster_impl;
	orb -> connect(p, "Chat-Server");
	
	//
	// Print "server started" message
	//
	time_t t;
	char* d;
	t = time(0);
	d = asctime(localtime(&t));
	assert(d && strlen(d) > 0);
	d[strlen(d) - 1] = '\0';
	cout << "*** Server started at " << d << endl;
	
	//
	// Display the host and port
	//
	OCI_AccRegistry_var registry = boa -> get_acc_registry();
	OCI_AcceptorSeq_var acceptors = registry -> get_acceptors();
	
	for(CORBA_ULong i = 0 ; i < acceptors -> length() ; i++)
	{
	    OCI_AcceptorInfo_var info = acceptors[i] -> get_info();
	    OCI_IIOP_AcceptorInfo_var iiopInfo =
		OCI_IIOP_AcceptorInfo::_narrow(info);
	    
	    if(!CORBA_is_nil(iiopInfo))
	    {
		CORBA_String_var host = iiopInfo -> host();
		CORBA_UShort port = iiopInfo -> port();
		
		cout << "*** Running on host `" << host
		     << "', port number " << port << endl;
	    }
	}
	
	//
	// Run implementation
	//
	boa -> impl_is_ready(CORBA_ImplementationDef::_nil());
    }
    catch(CORBA_SystemException& ex)
    {
	OBPrintException(ex);
	return 1;
    }

    return 0;
}
