// WinClientDlg.cpp : implementation file
//

#include "stdafx.h"

#include "WinClient.h"

#include <OB/CORBA.h>
#include <OB/Util.h>

#include <ReceiverBase_impl.h>

#include "WinClientDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWinClientDlg dialog

CWinClientDlg::CWinClientDlg(Broadcaster_ptr p, CWnd* pParent /*=NULL*/)
    : CDialog(CWinClientDlg::IDD, pParent),
      ReceiverBase_impl(p)
{
	//{{AFX_DATA_INIT(CWinClientDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWinClientDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWinClientDlg)
	DDX_Control(pDX, IDC_EDIT_OUTPUT, m_EditOutput);
	DDX_Control(pDX, IDC_EDIT_INPUT, m_EditInput);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWinClientDlg, CDialog)
	//{{AFX_MSG_MAP(CWinClientDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_EN_CHANGE(IDC_EDIT_INPUT, OnChangeEditInput)
	ON_BN_CLICKED(IDC_BUTTON_ABOUT, OnButtonAbout)
	ON_BN_CLICKED(IDC_BUTTON_HELP, OnButtonHelp)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinClientDlg message handlers

BOOL CWinClientDlg::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // Set the icon for this dialog.  The framework does this automatically
    //  when the application's main window is not a dialog
    SetIcon(m_hIcon, TRUE);			// Set big icon
    SetIcon(m_hIcon, FALSE);		// Set small icon
    
    // TODO: Add extra initialization here
    
    //
    // Register with the server
    //
    _register();
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWinClientDlg::OnPaint() 
{
    if (IsIconic())
    {
	CPaintDC dc(this); // device context for painting
	
	SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);
	
	// Center icon in client rectangle
	int cxIcon = GetSystemMetrics(SM_CXICON);
	int cyIcon = GetSystemMetrics(SM_CYICON);
	CRect rect;
	GetClientRect(&rect);
	int x = (rect.Width() - cxIcon + 1) / 2;
	int y = (rect.Height() - cyIcon + 1) / 2;
	
	// Draw the icon
	dc.DrawIcon(x, y, m_hIcon);
    }
    else
    {
	CDialog::OnPaint();
    }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWinClientDlg::OnQueryDragIcon()
{
    return (HCURSOR) m_hIcon;
}

void CWinClientDlg::OnChangeEditInput() 
{
    CString str;
    m_EditInput.GetWindowText(str);

    if(str.GetLength() > 0)
    {
	TCHAR c = str[str.GetLength() - 1];
	if(c == '\n')
	{
	    m_EditInput.SetWindowText(CString());
	
	    if(str.GetLength() > 2)
	    {
		str = str.Left(str.GetLength() - 2);
		parse(str);
	    }
	}
    }
}	

void CWinClientDlg::OnButtonAbout() 
{
    cmdAbout();
}

void CWinClientDlg::OnButtonHelp() 
{
    cmdHelp();
}

void CWinClientDlg::OnDestroy() 
{
    quit();
}

void
CWinClientDlg::cmdQuit()
{
    ReceiverBase_impl::cmdQuit();
    EndDialog(IDOK);
}

void
CWinClientDlg::print(const char* text)
{
    CString str;
    m_EditOutput.GetWindowText(str);
    str += "\r\n";
    str += text;
    
    int len = 1;
    for(int i = 0 ; i < str.GetLength() ; i++)
	if(str[i] == '\n')
	    len++;
    
    while(len > 200)
    {
	int pos = str.Find('\n');
	str = str.Right(str.GetLength() - pos - 1);
	len--;
    }	
    
    m_EditOutput.SetWindowText(str);
    m_EditOutput.LineScroll(len);
}
