// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>

#include <X11/Intrinsic.h>
#include <Xm/Protocols.h>
#include <OB/X11.h>

#include <Receiver_impl.h>

#include <stdlib.h>

int
main(int argc, char* argv[], char*[])
{
    //
    // Get host and port
    //
    char host[1024];
    char port[256];
    cout << "Host name? " << flush;
    cin >> host;
    cout << "Port number? " << flush;
    cin >> port;
    
    CORBA_UShort portNum = atoi(port);

    cout << "Using object `Chat-Server' from host `" << host
	 << "' on port " << portNum << "..." << endl;

    char c;
    cin.read(&c, 1);
    
    //
    // Initialize application
    //
    static String fallbackResources[] =
    {
	"*sgiMode: true",    // This is only for SGI, but it doesn't
	"*useSchemes: all",  // hurt to have it also on non-SGI computer
	"*fileMenuButton.labelString: File",
        "*quitButton.labelString: Quit",
	"*helpMenuButton.labelString: Help",
	"*aboutButton.labelString: About X11-Chat...",
	"*commandButton.labelString: Commands...",
        "*textOutput.height: 400",
        "*textOutput.width: 600",
	0
    };
    
    XtAppContext appContext;
    Widget topLevel = XtAppInitialize(&appContext,
				      "X11-Chat",
				      0,
				      0,
				      &argc,
				      argv,
				      fallbackResources,
				      0,
				      0);
    
    XtVaSetValues(topLevel,
		  XmNdeleteResponse, XmDO_NOTHING,
		  0);
    
    try
    {
	//
	// Initialize the ORBacus library for use with X11
	//
	OBX11Init(appContext);
	
	//
	// Create ORB and BOA
	//
	CORBA_ORB_var orb = CORBA_ORB_init(argc, argv);
	CORBA_BOA_var boa = orb -> BOA_init(argc, argv);
	
	//
	// Set the concurrency model
	//
	orb -> conc_model(CORBA_ORB::ConcModelReactive);
	boa -> conc_model(CORBA_BOA::ConcModelReactive);
	
	//
	// Get "server" object
	//
	CORBA_Object_var obj =
	    orb -> get_inet_object(host, portNum, "Chat-Server");
	assert(!CORBA_is_nil(obj));
	
	Broadcaster_var server = Broadcaster::_narrow(obj);
	assert(!CORBA_is_nil(server));
	
	//
	// Initialize the servers so that incoming requests are
	// handled from this point on
	//
	boa -> init_servers();
	
	//
	// Create client object
	//
	Receiver_var client = new Receiver_impl(topLevel, server);
	
	//
	// Run implementation
	//
	boa -> impl_is_ready(CORBA_ImplementationDef::_nil());
    }
    catch(CORBA_SystemException& ex)
    {
	OBPrintException(ex);
	return 1;
    }

    return 0;
}
