// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef RECEIVER_IMPL_H
#define RECEIVER_IMPL_H

#include <Broadcaster.h>
#include <ReceiverBase_impl.h>

class Receiver_impl : public ReceiverBase_impl
{
    //
    // Some widgets
    //
    Widget parent_;
    Widget textOutput_;

    //
    // Set window title
    //
    void setTitle();

    //
    // Create action area
    //
    Widget createActionArea(Widget);

    //
    // Register with the server
    //
    void _register();

public:

    Receiver_impl(Widget, Broadcaster_ptr);

    //
    // Callbacks
    //
    void textInput(Widget);

    //
    // Functions from the .idl file
    //
    virtual void print(const char*);
};

#endif
