// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef Database_h
#define Database_h

//
// This structure represents the data in a database object.
//
struct DBRecordData
{
    CORBA_String_var data;
    long key;
};

//
// A sequence of the data.
//
typedef OBFixSeq<DBRecordData*> DBRecordDataPtrSeq;

//
// This represents the persistent database of DBRecord data.
// Note that this is only for demonstration purposes.
//
class Database
{
    DBRecordDataPtrSeq records_; // Set of records in the database.

public:
    ~Database();

    //
    // Destroy the record specified by `key'.
    //
    bool destroy(long key);

    //
    // Add a record specified by `key'.
    //
    DBRecordData* add(long key);

    //
    // Find the record specified by `key'.
    //
    DBRecordData* find(long key);

    //
    // Return the record at position i.
    //
    DBRecordData* recordAt(CORBA_ULong i);

    //
    // Return the number of records in database.
    //
    CORBA_ULong size();
};

#endif // Database_h
