// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef Reaper_h
#define Reaper_h

//
// We need to reap the set of active objects.  At regular intervals
// we scan the set of active database objects and remove any that
// have not been accessed in more than `expire' seconds.
//
// The reaper and the DBFactory objects maintain a list of active
// database record objects in memory.
//
class DBReaper : public OBTimer
{
    struct timeval interval_; // Scan at this interval.
    long expire_; // Remove records that are `expire' seconds old.
    DBRecordImplPtrSeq& records_; // The shared set of database records.
    CORBA_ORB_var orb_;
public:
    DBReaper(CORBA_ORB_ptr orb, long expire, DBRecordImplPtrSeq& records);

    virtual void notify();
};

#endif // Reaper_h
