// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************


#include <OB/CORBA.h>
#include <Nested_impl.h>

I_impl::I_impl()
    : level_(-1)
{
}

I_impl::I_impl(I_ptr peer, int level)
    : peer_(I::_duplicate(peer)), level_(level)
{
}

void
I_impl::connect(I_ptr peer)
{
    peer_ = I::_duplicate(peer);

    //
    // If the peer is using a thread-pool force the pool to be
    // initialized.
    //
    CORBA_Boolean exists = !(peer_ -> _non_existent());
    assert(exists);
}

void
I_impl::f()
{
    if(level_ == -1 || --level_ > 0)
	peer_ -> f();
}
