// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>

#include <Random.h>

#include <stdlib.h>
#include <errno.h>

#ifdef HAVE_FSTREAM
#   include <fstream>
#else
#   include <fstream.h>
#endif

int
main(int argc, char* argv[], char*[])
{
    try
    {
	//
	// Create ORB
	//
	CORBA_ORB_var orb = CORBA_ORB_init(argc, argv);
	
	//
	// We are connecting to an Orbix server. Note that we can either use
	// the generated IOR, or the get_inet_object form. The object key
	// for get_inet_object was extracted by using iordump.
	//
	/*
	const char* randomIOR = "IOR:000000000000000f49444c3a52616e646f6d3a312e3000000000000100000000000000500001000000000016706c616e7874792e6473672e63732e7463642e69650006220000002c3a5c706c616e7874792e6473672e63732e7463642e69653a52616e646f6d3a303a3a49523a52616e646f6d00";
	
	CORBA_Object_var obj = orb -> string_to_object(randomIOR);
	*/
	CORBA_Object_var obj =
		orb -> get_inet_object("planxty.dsg.cs.tcd.ie", 1570,
				":\\planxty.dsg.cs.tcd.ie:Random:0::IR:Random",
				"IDL:Random:1.0");
	assert(!CORBA_is_nil(obj));

	
	Random_var random = Random::_narrow(obj);
	assert(!CORBA_is_nil(random));

	//
	// Main loop
	//
	cout << "Enter 'r' for a random number, or 'x' for exit:\n";
	char c;
	do
	{
	    cout << "> ";
	    cin >> c;
	    if(c == 'r')
	    {
		CORBA_ULong l = random -> lrand48();
		cout << l << endl;
	    }
	}
	while(c != 'x');
    }
    catch(CORBA_SystemException& ex)
    {
	OBPrintException(ex);
	return 1;
    }

    return 0;
}

