// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_CONTEXT_H
#define OB_CONTEXT_H

//
// The Context class
//
class CORBA_Context;
typedef CORBA_Context* CORBA_Context_ptr;
typedef CORBA_Context_ptr ContextRef;
void OBDuplicate(CORBA_Context_ptr);
void OBRelease(CORBA_Context_ptr);
typedef OBObjVar< CORBA_Context > CORBA_Context_var;

class CORBA_Context : public OBRefCount
{
    CORBA_String_var name_;
    CORBA_Context_var parent_;
    OBSeqVar< OBStrSeq > values_;

    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_Context(const CORBA_Context&);
    void operator=(const CORBA_Context&);

protected:

    CORBA_Context(const char*);
    CORBA_Context(const char*, CORBA_Context_ptr);
    friend class CORBA_ORB; // ORBs may create Contexts
    
public:

    //
    // Standard IDL to C++ Mapping
    //
    static inline CORBA_Context_ptr _duplicate(CORBA_Context_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline CORBA_Context_ptr _nil()
    { return 0; }

    const char* context_name() const { return name_; }
    CORBA_Context_ptr parent() const { return parent_; }

    CORBA_Status create_child(const char*, CORBA_Context_ptr&);

    CORBA_Status set_one_value(const char*, const CORBA_Any&);
    CORBA_Status set_values(CORBA_NVList_ptr);
    CORBA_Status delete_values(const char*);
    CORBA_Status get_values(const char*, CORBA_Flags, const char*,
			    CORBA_NVList_ptr&);

    //
    // ORBacus internal functions
    // Application programs must not use these functions directly
    //
    CORBA_Status _OB_getValues(const char*, CORBA_Flags, const char*,
			       OBStrSeq&);
    static CORBA_Context* _OB_create(OBStrSeq*);
};

inline void
CORBA_release(CORBA_Context_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline CORBA_Boolean
CORBA_is_nil(CORBA_Context_ptr p)
{
    return p == 0;
}

#endif
