// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_NAMED_VALUE_H
#define OB_NAMED_VALUE_H

//
// The NamedValue class
//
class CORBA_NamedValue;
typedef CORBA_NamedValue* CORBA_NamedValue_ptr;
typedef CORBA_NamedValue_ptr NamedValueRef;
void OBDuplicate(CORBA_NamedValue_ptr);
void OBRelease(CORBA_NamedValue_ptr);
typedef OBObjVar< CORBA_NamedValue > CORBA_NamedValue_var;

class CORBA_NamedValue : public OBRefCount
{
    CORBA_String_var name_;
    mutable CORBA_Any_var value_;
    CORBA_Flags flags_;

    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_NamedValue(const CORBA_NamedValue&);
    void operator=(const CORBA_NamedValue&);

protected:

    CORBA_NamedValue();
    CORBA_NamedValue(char*, CORBA_Any*, CORBA_Flags);

    friend class CORBA_NVList;  // NVLists may create NamedValues
    friend class CORBA_Request; // Requests may create NamedValues
    friend class CORBA_ORB;     // ORBs may create NamedValues

public:

    static inline CORBA_NamedValue_ptr _duplicate(CORBA_NamedValue_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline CORBA_NamedValue_ptr _nil()
    { return 0; }

    const char* name() const;
    CORBA_Any* value() const;
    CORBA_Flags flags() const;
};

inline void
CORBA_release(CORBA_NamedValue_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline CORBA_Boolean
CORBA_is_nil(CORBA_NamedValue_ptr p)
{
    return p == 0;
}

//
// The NVList class
//
class CORBA_NVList;
typedef CORBA_NVList* CORBA_NVList_ptr;
typedef CORBA_NVList_ptr NVListRef;
void OBDuplicate(CORBA_NVList_ptr);
void OBRelease(CORBA_NVList_ptr);
typedef OBObjVar< CORBA_NVList > CORBA_NVList_var;

class CORBA_NVList : public OBRefCount
{
    OBObjSeq<CORBA_NamedValue> namedValueSeq_;
    
    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_NVList(const CORBA_NVList&);
    void operator=(const CORBA_NVList&);

protected:

    CORBA_NVList() { };
    CORBA_NVList(CORBA_ULong);

    friend class CORBA_Context; // Contexts may create NVLists
    friend class CORBA_Request; // Requests may create NVLists
    friend class CORBA_ORB;     // ORBs create NVLists

public:

    static inline CORBA_NVList_ptr _duplicate(CORBA_NVList_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline CORBA_NVList_ptr _nil()
    { return 0; }

    CORBA_ULong count() const;

    CORBA_NamedValue_ptr add(CORBA_Flags);
    CORBA_NamedValue_ptr add_item(const char*, CORBA_Flags);
    CORBA_NamedValue_ptr add_value(const char*, const CORBA_Any&, CORBA_Flags);

    CORBA_NamedValue_ptr add_item_consume(char*, CORBA_Flags);
    CORBA_NamedValue_ptr add_value_consume(char*, CORBA_Any*, CORBA_Flags);

    CORBA_NamedValue_ptr item(CORBA_ULong);

    CORBA_Status remove(CORBA_ULong);
};

inline void
CORBA_release(CORBA_NVList_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline CORBA_Boolean
CORBA_is_nil(CORBA_NVList_ptr p)
{
    return p == 0;
}

#endif
