// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_PRINCIPAL_H
#define OB_PRINCIPAL_H

//
// The Principal class
//
class CORBA_Principal;
typedef CORBA_Principal* CORBA_Principal_ptr;
typedef CORBA_Principal_ptr PrincipalRef;
void OBDuplicate(CORBA_Principal_ptr);
void OBRelease(CORBA_Principal_ptr);
typedef OBObjVar< CORBA_Principal > CORBA_Principal_var;

class CORBA_Principal : public OBRefCount
{
    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_Principal(const CORBA_Principal&);
    void operator=(const CORBA_Principal&);

protected:

    CORBA_Principal() { };

public:

    //
    // Standard IDL to C++ Mapping
    //
    static inline CORBA_Principal_ptr _duplicate(CORBA_Principal_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline CORBA_Principal_ptr _nil()
    { return 0; }

    //
    // CDR
    //
    friend void OBMarshal(CORBA_Principal_ptr, CORBA_Octet*&);
    friend void OBMarshalCount(CORBA_Principal_ptr, CORBA_ULong&);
    friend void OBUnmarshal(CORBA_Principal_ptr&, const CORBA_Octet*&, bool);
};

inline void
CORBA_release(CORBA_Principal_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline CORBA_Boolean
CORBA_is_nil(CORBA_Principal_ptr p)
{
    return p == 0;
}

//
// CDR
//
void OBMarshal(const OBObjSeq< CORBA_Principal >&, CORBA_Octet*&);
void OBMarshalCount(const OBObjSeq< CORBA_Principal >&, CORBA_ULong&);
void OBUnmarshal(OBObjSeq< CORBA_Principal >&, const CORBA_Octet*&, bool);

#endif
