// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_PROPERTIES_H
#define OB_PROPERTIES_H

class OBProperties
{
    //
    // Hide copy-constructor and asignment operator
    //
    OBProperties(const OBProperties&);
    void operator=(const OBProperties&);

protected:

    //
    // The Properties singleton
    //
    static OB_IMPORT OBProperties* instance_;
    friend class OBPropertiesDestroyer;

    //
    // Properties data
    //
    OBStrSeq props_;
    
    //
    // Load the properties from a file
    //
    void load(const char*);

#ifdef WIN32
    //
    // Load the properties from the registry.
    //
    void load(HKEY, const char*, const char*);
#endif

    OBProperties();

public:

    ~OBProperties();
    
    typedef OBStrSeq KeySeq;

    //
    // Set a property
    //
    void setProperty(const char*, const char*);

    //
    // Get property
    //
    const char* getProperty(const char*) const;

    //
    // Get all property keys starting with prefix
    //
    KeySeq getKeys(const char* prefix) const;

    //
    // Get all property keys
    //
    KeySeq getKeys() const;

    //
    // Get the properties singleton (which may be null, if the
    // properties have not yet been initialized)
    //
    static OBProperties* instance();

    //
    // Initialize the properties
    //
#ifdef WIN32
    static OBProperties* init(int&, char**, bool = true);
#else
    static OBProperties* init(int&, char**);
#endif
};

#endif
