// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_UTIL_H
#define OB_UTIL_H

//
// The message viewer class
//
class OBMessageViewer
{
    //
    // Hide copy-constructor and asignment operator
    //
    OBMessageViewer(const OBMessageViewer&);
    void operator=(const OBMessageViewer&);

protected:

    //
    // The message viewer singleton
    //
    static OB_IMPORT OBMessageViewer* instance_;
    friend class OBMessageViewerDestroyer;

    //
    // The message viewer trace level
    //
    static int traceLevel_;

    OBMessageViewer() { }
    virtual ~OBMessageViewer() { }

public:

    //
    // Get the message viewer singleton
    //
    static OBMessageViewer* instance();

    //
    // Set and get the viewers trace level
    //
    static int getTraceLevel();
    static void setTraceLevel(int);

    //
    // Print messages
    //
    virtual void message(const char*);
    virtual void error(const char*);
    virtual void warning(const char*);
    virtual void nca(const char*);
    virtual void trace(int, const char*);
};

//
// Forward declarations
//
struct IOP_IOR;
class CORBA_Object;
typedef CORBA_Object* CORBA_Object_ptr;

//
// Print system exception
// Get stringified system exception
//
void OBPrintException(const CORBA_SystemException&);
char* OBExceptionToString(const CORBA_SystemException&);

//
// Print octets for debug reasons
//
void OBPrintOctets(ostream&, const CORBA_Octet*, CORBA_ULong);

//
// Print object reference
//
void OBPrintObjref(ostream&, CORBA_Object_ptr);
void OBPrintObjref(ostream&, const char*);
void OBPrintObjref(ostream&, const IOP_IOR&);

#endif
