// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/Basic.h>
#include <OB/Except.h>
#include <OB/Template.h>
#include <OB/TemplateI.h>
#include <OB/Declarations.h>
#include <OB/Any.h>
#include <OB/IOP.h>
#include <OB/Object.h>
#include <OB/IntRepMember.h>
#include <OB/ORB.h>
#include <OB/ImplRep.h>
#include <OB/BOA.h>
#include <OB/OCI.h>
#include <OB/GIOP.h>
#include <OB/Reactor.h>

#include <GIOPServer.h>
#include <GIOPServerStarter.h>
#include <GIOPServerWorker.h>

// ----------------------------------------------------------------------
// OBGIOPServer constructor and destructor
// ----------------------------------------------------------------------

OBGIOPServer::OBGIOPServer(OCI_Acceptor_ptr acceptor)
    : acceptor_(OCI_Acceptor::_duplicate(acceptor)),
      starter_(OBGIOPServerStarter::_nil()), enabled_(true)
{
    //cout << "OBGIOPServer" << endl;
}

OBGIOPServer::~OBGIOPServer()
{
    //cout << "~OBGIOPServer" << endl;

    //
    // If starter_ is not nil, destroy() was not called
    //
    assert(CORBA_is_nil(starter_));
}

// ----------------------------------------------------------------------
// OBGIOPServer public member implementation
// ----------------------------------------------------------------------

void
OBGIOPServer::destroy()
{
    if(!CORBA_is_nil(starter_))
    {
	starter_ -> destroy();
	starter_ = OBGIOPServerStarter::_nil();
    }
}

OCI_Acceptor_ptr
OBGIOPServer::acceptor()
{
    return OCI_Acceptor::_duplicate(acceptor_);
}

bool
OBGIOPServer::run()
{
    bool done = false;
    
    switch(CORBA_BOA::conc_model())
    {
    case CORBA_BOA::ConcModelBlocking:
    {
	if(!starter_.in())
	    starter_ = new OBGIOPServerStarterBlocking(acceptor_, enabled_);
	break;
    }
	
    case CORBA_BOA::ConcModelReactive:
    {
	if(!starter_.in())
	    starter_ = new OBGIOPServerStarterReactive(acceptor_, enabled_);
	break;
    }
	
#ifdef HAVE_JTC
    case CORBA_BOA::ConcModelThreaded:
    case CORBA_BOA::ConcModelThreadPerClient:
    case CORBA_BOA::ConcModelThreadPerRequest:
    case CORBA_BOA::ConcModelThreadPool:
    {
	if(!starter_.in())
	    starter_ = new OBGIOPServerStarterThreaded(acceptor_, enabled_);
	break;
    }
#endif
    }

    if(enabled_)
	done = starter_ -> startWorker();

    return done;
}

void
OBGIOPServer::disable()
{
    assert(CORBA_is_nil(starter_));
    enabled_ = false;
}
