// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_GIOP_SERVER_H
#define OB_GIOP_SERVER_H

//
// Declare OBGIOPServerStarter as a class
//
class OBGIOPServerStarter;
typedef OBGIOPServerStarter* OBGIOPServerStarter_ptr;
void OBDuplicate(OBGIOPServerStarter_ptr);
void OBRelease(OBGIOPServerStarter_ptr);
typedef OBObjVar< OBGIOPServerStarter > OBGIOPServerStarter_var;

//
// The OBGIOPServer class
//
class OBGIOPServer : public OBServer
{
    //
    // Hide copy-constructor and asignment operator
    //
    OBGIOPServer(const OBGIOPServer&);
    void operator=(const OBGIOPServer&);

protected:

    OCI_Acceptor_var acceptor_; // The acceptor
    OBGIOPServerStarter_var starter_; // The server starter
    bool enabled_; // Is this server enabled?
    
public:
    
    OBGIOPServer(OCI_Acceptor_ptr);
    virtual ~OBGIOPServer();

    //
    // Destroy the server
    //
    virtual void destroy();

    //
    // Get the OCI acceptor
    //
    virtual OCI_Acceptor_ptr acceptor();

    //
    // Run the server
    //
    virtual bool run();

    //
    // Disable the server
    //
    virtual void disable();
};

#endif
