// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/Basic.h>
#include <OB/Template.h>

#include <OB/Hashers.h>

CORBA_ULong
OBHash(const char* key)
{
    CORBA_ULong h = 0;
    CORBA_ULong offset = 0;
    CORBA_Long len = (CORBA_Long)strlen(key);

    if(len < 16)
    {
        for(CORBA_Long i = len ; i > 0 ; i--)
            h = (h * 37) + key[offset++];
    }
    else
    {
        CORBA_Long skip = len / 8;
        for(CORBA_Long i = len ; i > 0 ; i -= skip, offset += skip)
            h = (h * 39) + key[offset];
    }

    return h;
}

bool
OBHashCompare(const char* k1, const char* k2)
{
    return strcmp(k1, k2) == 0;
}

CORBA_ULong
OBHash(const OBFixSeq<CORBA_Octet>& key)
{
    CORBA_ULong h = 0;
    CORBA_ULong offset = 0;
    CORBA_Long len = (CORBA_Long)key.length();

    if(len < 16)
    {
        for(CORBA_Long i = len ; i > 0 ; i--)
            h = (h * 37) + (int)key[offset++];
    }
    else
    {
        CORBA_ULong skip = len / 8;
        for(CORBA_Long i = len ; i > 0 ; i -= skip, offset += skip)
            h = (h * 39) + (int)key[offset];
    }

    return h;
}

bool
OBHashCompare(const OBFixSeq<CORBA_Octet>& k1,
              const OBFixSeq<CORBA_Octet>& k2)
{
    return ((k1.length() == k2.length()) &&
            (memcmp(k1.data(), k2.data(), k1.length()) == 0));
}
