// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/Basic.h>
#include <OB/Except.h>
#include <OB/Template.h>
#include <OB/Declarations.h>
#include <OB/IOP.h>
#include <OB/Object.h>
#include <OB/Policy.h>
#include <OB/OBPolicies.h>

#include <OBPolicies_impl.h>

// ----------------------------------------------------------------------
// OB_ProtocolPolicy_impl constructor and destructor
// ----------------------------------------------------------------------

OB_ProtocolPolicy_impl::OB_ProtocolPolicy_impl(IOP_ProfileId value)
    : value_(value)
{
}

OB_ProtocolPolicy_impl::~OB_ProtocolPolicy_impl()
{
}

// ----------------------------------------------------------------------
// OB_ProtocolPolicy_impl public member implementation
// ----------------------------------------------------------------------

IOP_ProfileId
OB_ProtocolPolicy_impl::value()
{
    return value_;
}

CORBA_PolicyType
OB_ProtocolPolicy_impl::policy_type()
{
    return OB_PROTOCOL_POLICY;
}

CORBA_Policy_ptr
OB_ProtocolPolicy_impl::copy()
{
    return CORBA_Policy::_duplicate(this);
}

void
OB_ProtocolPolicy_impl::destroy()
{
}

// ----------------------------------------------------------------------
// OB_ConnectionReusePolicy_impl constructor and destructor
// ----------------------------------------------------------------------

OB_ConnectionReusePolicy_impl::OB_ConnectionReusePolicy_impl(CORBA_Boolean r)
    : value_(r)
{
}

OB_ConnectionReusePolicy_impl::~OB_ConnectionReusePolicy_impl()
{
}

// ----------------------------------------------------------------------
// OB_ConnectionReusePolicy_impl public member implementation
// ----------------------------------------------------------------------

CORBA_Boolean
OB_ConnectionReusePolicy_impl::value()
{
    return value_;
}

CORBA_PolicyType
OB_ConnectionReusePolicy_impl::policy_type()
{
    return OB_CONNECTION_REUSE_POLICY;
}

CORBA_Policy_ptr
OB_ConnectionReusePolicy_impl::copy()
{
    //
    // This policy is immutable, so this is a fair implementation.
    //
    return CORBA_Policy::_duplicate(this);
}

void
OB_ConnectionReusePolicy_impl::destroy()
{
}

// ----------------------------------------------------------------------
// OB_ReconnectPolicy_impl constructor and destructor
// ----------------------------------------------------------------------

OB_ReconnectPolicy_impl::OB_ReconnectPolicy_impl(CORBA_Boolean r)
    : value_(r)
{
}

OB_ReconnectPolicy_impl::~OB_ReconnectPolicy_impl()
{
}

// ----------------------------------------------------------------------
// OB_ReconnectPolicy_impl public member implementation
// ----------------------------------------------------------------------

CORBA_Boolean
OB_ReconnectPolicy_impl::value()
{
    return value_;
}

CORBA_PolicyType
OB_ReconnectPolicy_impl::policy_type()
{
    return OB_RECONNECT_POLICY;
}

CORBA_Policy_ptr
OB_ReconnectPolicy_impl::copy()
{
    //
    // This policy is immutable, so this is a fair implementation.
    //
    return CORBA_Policy::_duplicate(this);
}

void
OB_ReconnectPolicy_impl::destroy()
{
}

// ----------------------------------------------------------------------
// OB_TimeoutPolicy_impl constructor and destructor
// ----------------------------------------------------------------------

OB_TimeoutPolicy_impl::OB_TimeoutPolicy_impl(CORBA_ULong t)
{
    if(t > 0x7fffffff)
        throw CORBA_IMP_LIMIT();
    value_ = t;
}

OB_TimeoutPolicy_impl::~OB_TimeoutPolicy_impl()
{
}

// ----------------------------------------------------------------------
// OB_TimeoutPolicy_impl public member implementation
// ----------------------------------------------------------------------

CORBA_ULong
OB_TimeoutPolicy_impl::value()
{
    return value_;
}

CORBA_PolicyType
OB_TimeoutPolicy_impl::policy_type()
{
    return OB_TIMEOUT_POLICY;
}

CORBA_Policy_ptr
OB_TimeoutPolicy_impl::copy()
{
    //
    // This policy is immutable, so this is a fair implementation.
    //
    return CORBA_Policy::_duplicate(this);
}

void
OB_TimeoutPolicy_impl::destroy()
{
}


