// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_POLICIES_IMPL_H
#define OB_POLICIES_IMPL_H

class OB_ProtocolPolicy_impl : public OB_ProtocolPolicy
{
    //
    // Hide copy-constructor and assignment operator
    //
    OB_ProtocolPolicy_impl(const OB_ProtocolPolicy_impl&);
    void operator=(const OB_ProtocolPolicy_impl&);

    IOP_ProfileId value_;
public:

    OB_ProtocolPolicy_impl(IOP_ProfileId);
    ~OB_ProtocolPolicy_impl();

    virtual IOP_ProfileId value();

    virtual CORBA_PolicyType policy_type();
    virtual CORBA_Policy_ptr copy();
    virtual void destroy();
};

class OB_ConnectionReusePolicy_impl : public OB_ConnectionReusePolicy
{
    //
    // Hide copy-constructor and assignment operator
    //
    OB_ConnectionReusePolicy_impl(const OB_ConnectionReusePolicy_impl&);
    void operator=(const OB_ConnectionReusePolicy_impl&);

    CORBA_Boolean value_;

public:

    OB_ConnectionReusePolicy_impl(CORBA_Boolean);
    ~OB_ConnectionReusePolicy_impl();

    virtual CORBA_Boolean value();

    virtual CORBA_PolicyType policy_type();
    virtual CORBA_Policy_ptr copy();
    virtual void destroy();
};

class OB_ReconnectPolicy_impl : public OB_ReconnectPolicy
{
        //
    // Hide copy-constructor and assignment operator
    //
    OB_ReconnectPolicy_impl(const OB_ReconnectPolicy_impl&);
    void operator=(const OB_ReconnectPolicy_impl&);

    CORBA_Boolean value_;

public:

    OB_ReconnectPolicy_impl(CORBA_Boolean);
    ~OB_ReconnectPolicy_impl();

    virtual CORBA_Boolean value();

    virtual CORBA_PolicyType policy_type();
    virtual CORBA_Policy_ptr copy();
    virtual void destroy();
};

class OB_TimeoutPolicy_impl : public OB_TimeoutPolicy
{
    //
    // Hide copy-constructor and assignment operator
    //
    OB_TimeoutPolicy_impl(const OB_TimeoutPolicy_impl&);
    void operator=(const OB_TimeoutPolicy_impl&);

    CORBA_ULong value_;

public:

    OB_TimeoutPolicy_impl(CORBA_ULong timeout);
    ~OB_TimeoutPolicy_impl();

    virtual CORBA_ULong value();

    virtual CORBA_PolicyType policy_type();
    virtual CORBA_Policy_ptr copy();
    virtual void destroy();
};
#endif
