// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/Basic.h>
#include <OB/Except.h>
#include <OB/Template.h>
#include <OB/TemplateI.h>
#include <OB/OCIBuffer.h>

// ----------------------------------------------------------------------
// External, non-inline duplicate/release for templates
// ----------------------------------------------------------------------

void
OBDuplicate(OCI_Buffer_ptr p)
{
    if(p)
	p -> _OB_incRef();
}

void
OBRelease(OCI_Buffer_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

// ----------------------------------------------------------------------
// Template instantiations
// ----------------------------------------------------------------------

#ifndef HAVE_NO_EXPLICIT_TEMPLATES
template class OBObjVar< OCI_Buffer >;
template class OBObjForSeq< OCI_Buffer >;
template class OBObjSeq< OCI_Buffer >;
template class OBSeqVar< OBObjSeq< OCI_Buffer > >;
#else
#ifdef HAVE_PRAGMA_DEFINE
#pragma define(OBObjVar< OCI_Buffer >)
#pragma define(OBObjForSeq< OCI_Buffer >)
#pragma define(OBObjSeq< OCI_Buffer >)
#pragma define(OBSeqVar< OBObjSeq< OCI_Buffer > >)
#endif
#endif
