// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/Basic.h>
#include <OB/Except.h>
#include <OB/Template.h>
#include <OB/Declarations.h>
#include <OB/IOP.h>
#include <OB/Object.h>
#include <OB/Object.h>
#include <OB/Policy.h>
#include <OB/PolicyManager.h>
#include <OB/OBPolicies.h>

#include <PolicyValidator.h>

void
PolicyValidator::validatePolicies(const CORBA_PolicyList& l)
{
    //
    // We need to verify that the set of policies is valid.  Currently
    // this means that we may not have ProtocolPolicy and
    // ConnectionPolicy set at the same time.
    //
    CORBA_UShort hasConnectionPolicy = 0;
    CORBA_UShort hasProtocolPolicy = 0;
    OBFixSeq< CORBA_UShort > indices;

    for(CORBA_UShort i = 0; i < l.length(); ++i)
    {
        CORBA_PolicyType policyType = l[i] -> policy_type();
        if(policyType == SSL_CONNECT_POLICY)
        {
            ++hasConnectionPolicy;
            indices.append(i);
        }
        else if(policyType == OB_PROTOCOL_POLICY)
        {
            ++hasProtocolPolicy;
            indices.append(i);
        }
    }

    if(hasConnectionPolicy != 0 && hasProtocolPolicy != 0)
    {
        throw CORBA_PolicyManager::InvalidPolicies(indices);
    }
}
