// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/Basic.h>
#include <OB/Template.h>
#include <OB/TemplateI.h>
#include <OB/Principal.h>

// ----------------------------------------------------------------------
// External, non-inline duplicate/release for templates
// ----------------------------------------------------------------------

void
OBDuplicate(CORBA_Principal_ptr p)
{
    if(p)
	p -> _OB_incRef();
}

void
OBRelease(CORBA_Principal_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

// ----------------------------------------------------------------------
// Template instantiations
// ----------------------------------------------------------------------

#ifndef HAVE_NO_EXPLICIT_TEMPLATES
template class OBObjVar< CORBA_Principal >;
template class OBObjForSeq< CORBA_Principal >;
template class OBObjSeq< CORBA_Principal >;
template class OBSeqVar< OBObjSeq< CORBA_Principal> >;
#else
#ifdef HAVE_PRAGMA_DEFINE
#pragma define(OBObjVar< CORBA_Principal >)
#pragma define(OBObjForSeq< CORBA_Principal >)
#pragma define(OBObjSeq< CORBA_Principal >)
#pragma define(OBSeqVar< OBObjSeq< CORBA_Principal> >)
#endif
#endif

// ----------------------------------------------------------------------
// Principal public member implementation
// ----------------------------------------------------------------------

/*
 * Nothing defined yet
 */

// ----------------------------------------------------------------------
// CDR functions
// ----------------------------------------------------------------------

void
OBMarshal(CORBA_Principal_ptr, CORBA_Octet*& oct)
{
    OBFixSeq<CORBA_Octet> seq;
    OBMarshal(seq, oct);
}

void
OBMarshalCount(CORBA_Principal_ptr, CORBA_ULong& count)
{
    OBFixSeq<CORBA_Octet> seq;
    OBMarshalCount(seq, count);
}

void
OBUnmarshal(CORBA_Principal_ptr&, const CORBA_Octet*& oct, bool swap)
{
    OBFixSeq<CORBA_Octet> seq;
    OBUnmarshal(seq, oct, swap);
}

void
OBMarshal(const OBObjSeq< CORBA_Principal >& seq, CORBA_Octet*& oct)
{
    OBMarshal(seq.length(), oct);
    for(CORBA_ULong i = 0 ; i < seq.length() ; i++)
        OBMarshal(seq[i], oct);
}
void
OBMarshalCount(const OBObjSeq< CORBA_Principal >& seq, CORBA_ULong& count)
{
    OBMarshalCount(seq.length(), count);
    for(CORBA_ULong i = 0 ; i < seq.length() ; i++)
        OBMarshalCount(seq[i], count);
}
void
OBUnmarshal(OBObjSeq< CORBA_Principal >& seq, const CORBA_Octet*& oct,
	    bool swap)
{
    CORBA_ULong len;
    OBUnmarshal(len, oct, swap);
    seq.length(len);
    for(CORBA_ULong i = 0 ; i < len ; i++)
        OBUnmarshal(seq[i].inout(), oct, swap);
}

