// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_SELECT_REACTOR_H
#define OB_SELECT_REACTOR_H

//
// The OBSelectReactor class
//
class OBSelectReactor : public OBReactor
{
    //
    // Hide copy-constructor and asignment operator
    //
    OBSelectReactor(const OBSelectReactor&);
    void operator=(const OBSelectReactor&);

    //
    // If set to true, event dispatching must be stopped
    //
    bool stop_;

    //
    // Struct for an event handler info
    //
    struct HandlerInfo
    {
	OBEventHandler* handler;
	OBMask mask;
	OBHandle handle;
	HandlerInfo* next;
    };

    //
    // Head of the list with all event handler infos
    //
    HandlerInfo* handlerInfoList_;

    //
    // Counter which keeps track of how often the list with event
    // handler infos is currently in use
    //
    CORBA_ULong handlerInfoListUsageCount_;

    //
    // Reap the list of event handler infos
    //
    void reapHandlerInfoList();

    //
    // Set file descriptor sets
    //
    int setFdSets(fd_set&, fd_set&) const;

    //
    // Evaluate file descriptor sets
    //
    void evalFdSets(fd_set&, fd_set&);

protected: // Make the constructor and destructor protected to avoid
           // stupid warning messages from some compilers
    OBSelectReactor();
    virtual ~OBSelectReactor();

public:

    //
    // Get the reactor singleton
    //
    static OBReactor* instance();

    //
    // Register and unregister event handler
    //
    virtual void registerHandler(OBEventHandler*, OBMask, OBHandle);
    virtual void unregisterHandler(OBEventHandler*);

    //
    // Dispatch events
    //
    virtual void dispatch();
    virtual bool dispatchOneEvent(CORBA_Long);

    //
    // Stop event dispatching
    //
    virtual void stop() { stop_ = true; }
};

#endif
