// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_WIN_REACTOR_H
#define OB_WIN_REACTOR_H

//
// The OBWinReactor class
//
class OBWinReactor : public OBReactor
{
    //
    // Hide copy-constructor and asignment operator
    //
    OBWinReactor(const OBWinReactor&);
    void operator=(const OBWinReactor&);

    //
    // If set to true, event dispatching must be stopped
    //
    bool stop_;

    //
    // The window used for message notifications
    //
    HWND hWnd_;

    //
    // Struct for an event handler info
    //
    struct HandlerInfo
    {
	OBEventHandler* handler;
	OBMask mask;
	OBHandle handle;
	HandlerInfo* next;
    };

    //
    // Head of the list with all event handler infos
    //
    HandlerInfo* handlerInfoList_;

    OBWinReactor(HINSTANCE);
    virtual ~OBWinReactor();

public:

    //
    // Get the reactor singleton
    //
    static OBReactor* instance(HINSTANCE);

    //
    // Register and unregister event handler
    //
    virtual void registerHandler(OBEventHandler*, OBMask, OBHandle);
    virtual void unregisterHandler(OBEventHandler*);

    //
    // Dispatch events
    //
    virtual void dispatch();
    virtual bool dispatchOneEvent(CORBA_Long);

    //
    // Stop event dispatching
    //
    virtual void stop() { stop_ = true; }

    //
    // Windows message processing function
    //
    LRESULT wndProc(HWND, UINT, WPARAM, LPARAM);
};

//
// The windows message viewer class
//
class OBWinViewer : public OBMessageViewer
{
    //
    // Hide copy-constructor and asignment operator
    //
    OBWinViewer(const OBWinViewer&);
    void operator=(const OBWinViewer&);

protected:

    OBWinViewer() { }
    virtual ~OBWinViewer() { }

public:

    //
    // Get the message viewer singleton
    //
    static OBMessageViewer* instance();

    //
    // Print messages
    //
    virtual void message(const char*);
};

#endif
