// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_X11_REACTOR_H
#define OB_X11_REACTOR_H

//
// The OBX11Reactor class
//
class OBX11Reactor : public OBReactor
{
    //
    // Hide copy-constructor and asignment operator
    //
    OBX11Reactor(const OBX11Reactor&);
    void operator=(const OBX11Reactor&);

    //
    // If set to true, event dispatching must be stopped
    //
    bool stop_;

    //
    // The application context
    //
    XtAppContext context_;

    //
    // Struct for an event handler info
    //
    struct HandlerInfo
    {
	OBEventHandler* handler;
	OBMask mask;
	OBHandle handle;
	XtInputId readId;
	XtInputId writeId;
	HandlerInfo* next;
    };

    //
    // Head of the list with all event handler infos
    //
    HandlerInfo* handlerInfoList_;

protected: // Make the constructor and destructor protected to avoid
           // stupid warning messages from some compilers
    OBX11Reactor(XtAppContext);
    virtual ~OBX11Reactor();

public:

    //
    // Get the reactor singleton
    //
    static OBReactor* instance(XtAppContext);

    //
    // Register and unregister event handler
    //
    virtual void registerHandler(OBEventHandler*, OBMask, OBHandle);
    virtual void unregisterHandler(OBEventHandler*);

    //
    // Dispatch events
    //
    virtual void dispatch();
    virtual bool dispatchOneEvent(CORBA_Long);

    //
    // Stop event dispatching
    //
    virtual void stop() { stop_ = true; }
};

#endif
