// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef GEN_HTML_H
#define GEN_HTML_H

//
// The HTML code generator class
//
class IdlHTMLGenerator
{
    //
    // Special HTML "Pretty-Print" class
    //
    class PrettyPrint : public IdlPrettyPrint
    {
	CORBA_String_var path_;
	ofstream out_;

    public:

	PrettyPrint(const char*, const char*, const char*, unsigned int = 4);
	virtual ~PrettyPrint();

	const char* path() const { return path_; }
	int good() { return out_.good(); }
	virtual void printString(const char*);
    };

    //
    // The keywords
    //
    static const char* keyException_;
    static const char* keyMember_;
    static const char* keyParam_;
    static const char* keyReturn_;
    static const char* keySee_;
    static const char* keySince_;
    static const char* keyAuthor_;
    static const char* keyVersion_;

    //
    // The top-level file name (without ".html")
    //
    static const char* top_;

    //
    // The program name
    //
    const char* prog_;

    //
    // The repository
    //
    CORBA_Repository_var repository_;

    //
    // Comments from IDL file
    //
    IdlCommentSeq commentSeq_;

    //
    // Keyword list
    //
    IdlStringSeq keywordSeq_;

    //
    // If true, don't sort symbols
    //
    bool noSort_;

    //
    // If true, ignore case when sorting
    //
    bool ignoreCase_;

    //
    // If set, write .html files to this path
    //
    const char* outDir_;

    //
    // Cache for absolute names
    //
    IdlStringSeq absSeq_;

    //
    // Cache for links
    //
    IdlStringSeq linkSeq_;

    //
    // Print comment
    //
    void comment(const char*, IdlPrettyPrint&);

    //
    // Print intro
    //
    void intro(const char*, const char*, IdlPrettyPrint&);

    //
    // Create type string
    //
    enum GetType
    {
	GetTypeNormal,  // Normal type string
	GetTypeIn,      // Type string for use as in parameter
	GetTypeOut,     // Type string for use as out parameter
	GetTypeInOut    // Type string for use as inout parameter
    };
    
    char* getTypeString(const char*, CORBA_TypeCode_ptr,
			GetType = GetTypeNormal,
			const char* = 0);

    //
    // Get absolute name
    //
    char* getAbsolute(CORBA_Contained_ptr);
    char* getAbsolute(const char*);
   
    //
    // Fix absolute path name, i.e. replace "::" by "."
    //
    char* fixAbsolute(const char*);

    //
    // Get link
    //
    char* getLink(const char*);

    //
    // Get scope
    //
    void getScope(CORBA_Container_ptr, char*&);

    //
    // Print union labels
    //
    void printUnionLabels(const IdlUnionMemberInfo&, IdlPrettyPrint&,
			  CORBA_TypeCode_ptr);

    //
    // Generate code for the header file, general part
    //
    int genHTML(CORBA_Container_ptr, IdlPrettyPrint&);

    //
    // Tokenize
    //
    char *tokenize(char*);

    //
    // Check for keyword
    //
    bool isKeyword(const char*);

public:

    IdlHTMLGenerator(const char*, CORBA_Repository_ptr,
		  const IdlCommentSeq&, const char*, bool, bool);

    //
    // Generate HTML code
    //
    int gen();
};

#endif
