// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef FEED_UTIL_H
#define FEED_UTIL_H

//
// Find a scoped name
//
CORBA_IRObject_ptr IdlFindScopedName(CORBA_Container_ptr, const char*);

//
// Find an enum member
//
CORBA_Long IdlFindEnumMember(CORBA_Container_ptr, CORBA_EnumDef_ptr,
			     const char*);

//
// Output errors and warnings
//
void IdlError(const char*);
void IdlWarning(const char*);

//
// Parse line number and file name
//
void IdlParseLineAndFile(const char*);

//
// Parse pragma
//
bool IdlParsePragma(const char*);

//
// Parse C-style comment (i.e. comment within /**/)
//
void IdlParseComment(const char*);

//
// Get repository id
//
char* IdlGetRepositoryId(const char*, const char* = "1.0");

//
// Print CORBA_INTF_REPOS exception as error message
//
void IdlPrintException(CORBA_ULong, const char*, const char*);

//
// Add ID to IdlTopFileContent and IdlComments
//
void IdlAddID(const char*);

#endif
