// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <Types.h>
#include <IntRep_impl.h>

OB_MAKE_NARROW_IMPL_1(CORBA_IRObject_impl, CORBA_IRObject_skel)
OB_MAKE_NARROW_IMPL_2(CORBA_IDLType_impl, CORBA_IDLType_skel,
		      CORBA_IRObject_impl)

// ----------------------------------------------------------------------

CORBA_IRObject_impl::CORBA_IRObject_impl(CORBA_ORB_ptr orb)
{
    orb_ = CORBA_ORB::_duplicate(orb);
}

CORBA_IRObject_impl::~CORBA_IRObject_impl()
{
}

void
CORBA_IRObject_impl::releaseInternal()
{
}

void
CORBA_IRObject_impl::destroy()
{
    releaseInternal();
    CORBA_IRObject_var self = _this();
    orb_ -> disconnect(this);
}

// ----------------------------------------------------------------------

CORBA_IDLType_impl::CORBA_IDLType_impl(CORBA_ORB_ptr orb)
    : CORBA_IRObject_impl(orb)
{
}

CORBA_IDLType_impl::~CORBA_IDLType_impl()
{
}

// ----------------------------------------------------------------------
