// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef INT_REP_MEMBER_IMPL_H
#define INT_REP_MEMBER_IMPL_H

#include <OB/Narrow_impl.h>

#include <OB/IntRepMember_skel.h>

// ----------------------------------------------------------------------

class CORBA_IRObject_impl : public virtual CORBA_IRObject_skel
{
protected:

    CORBA_ORB_var orb_;

public:

    CORBA_IRObject_impl(CORBA_ORB_ptr);
    virtual ~CORBA_IRObject_impl();

    virtual void releaseInternal();

    virtual CORBA_DefinitionKind def_kind() = 0;
    virtual void destroy();

    OB_MAKE_NARROW_IMPL(CORBA_IRObject_impl)
};

// ----------------------------------------------------------------------

class CORBA_IDLType_impl : public virtual CORBA_IDLType_skel,
			   public virtual CORBA_IRObject_impl
{
public:

    CORBA_IDLType_impl(CORBA_ORB_ptr);
    virtual ~CORBA_IDLType_impl();

    virtual CORBA_TypeCode_ptr type() = 0;

    OB_MAKE_NARROW_IMPL(CORBA_IDLType_impl)
};

// ----------------------------------------------------------------------

#endif
