# **********************************************************************
#
# Copyright (c) 1999
# Object Oriented Concepts, Inc.
# Billerica, MA, USA
#
# All Rights Reserved
#
# **********************************************************************

top_srcdir	= ..

LIB_NAME	= $(top_srcdir)\lib\obtest.lib
LIB_PDB_NAME   	= $(top_srcdir)\lib\obtest.pdb
SERVER_NAME	= server.exe
CLIENT_NAME	= client.exe

!ifndef BUILD_UTILS

PDB_FLAGS       = /Fd$(LIB_PDB_NAME)
TARGETS		= $(LIB_NAME) 

!else

TARGETS		= $(SERVER_NAME) \
		  $(CLIENT_NAME)

!endif

!include $(top_srcdir)\config\Make.rules.mak

LIB_OBJS	= Test1.obj \
		  Test2.obj \
		  Test1_skel.obj \
		  Test2_skel.obj \
		  Test_impl.obj \
		  TestDSI_impl.obj \
		  TestConst.obj \
		  TestTypeCode.obj \
		  TestAny.obj \
		  TestUnion.obj \
		  TestStub.obj \
		  TestStubContext.obj \
		  TestStubException.obj \
		  TestStubTimeout.obj \
		  TestDII.obj \
		  TestDIIException.obj \
		  TestDIIContext.obj \
		  Server.obj \
		  Client.obj

SERVER_OBJS	= ServerMain.obj

CLIENT_OBJS	= ClientMain.obj

ALL_CXXFLAGS	= $(CXXFLAGS) $(PDB_FLAGS)

ALL_CPPFLAGS	= /I. $(OB_CPPFLAGS) $(CPPFLAGS)
ALL_LIBS	= $(LIB_NAME) $(OB_LIBS) $(LIBS)

$(LIB_NAME): $(LIB_OBJS)
	$(AR) $(ARFLAGS) /out:$@ $(LIB_OBJS)

$(SERVER_NAME): $(SERVER_OBJS) $(LIB_NAME)
	$(LINK) $(LINKFLAGS) /out:$@ $(SERVER_OBJS) $(ALL_LIBS)

$(CLIENT_NAME): $(CLIENT_OBJS) $(LIB_NAME)
	$(LINK) $(LINKFLAGS) /out:$@ $(CLIENT_OBJS) $(ALL_LIBS)

Test1.cpp Test1.h: Test1.idl
	del /q Test1.cpp Test1.h
	$(IDL) --tie Test1.idl

Test1_skel.cpp Test1_skel.h Test1_skel_tie.h: Test1.cpp

Test2.cpp Test2.h: Test2.idl
	del /q Test2.cpp Test2.h
	$(IDL) --tie -I. Test2.idl

Test2_skel.cpp Test2_skel.h Test2_skel_tie.h: Test2.cpp

!ifndef BUILD_UTILS

install:: all

install all test clean::
	$(MAKE) /f Makefile.mak BUILD_UTILS=1 $@	

!else

install:: all
	copy $(LIB_NAME) $(libdir)
	copy $(LIB_PDB_NAME) $(libdir)

!endif

!include .windep
