// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>
#include <Test_impl.h>
#include <Test2_skel_tie.h>
#include <TestDSI_impl.h>

#include <errno.h>

#ifdef HAVE_UNISTD_H
#   include <unistd.h>
#endif

#ifdef HAVE_IO_H
#   include <io.h>
#endif

#ifdef HAVE_FSTREAM
#   include <fstream>
#else
#   include <fstream.h>
#endif

// egcs 1.0.1 and gcc 2.8.0 crash with internal error
#if !(__GNUC__ == 2 && __GNUC_MINOR__ > 7)

#ifndef HAVE_NO_EXPLICIT_TEMPLATES
template class TestInterfaceTimeout_skel_tie< TestInterfaceTimeout_impl >;
#else
#ifdef HAVE_PRAGMA_DEFINE
#pragma define(TestInterfaceTimeout_skel_tie< TestInterfaceTimeout_impl >)
#endif
#endif

#endif

int
ServerRun(CORBA_ORB_ptr orb, CORBA_BOA_ptr boa, int argc, char* argv[])
{
    //
    // Create implementation object
    //
    TestInterfaceTimeout_impl* i = new TestInterfaceTimeout_impl;
    TestInterfaceTimeout_var p = i;
    orb -> connect(p, "test");
    CORBA_String_var impl = orb -> object_to_string(p);

    TestInterfaceExDSI_impl* iDSI = new TestInterfaceExDSI_impl(p, orb);
    CORBA_Object_var pDSI = iDSI;
    orb -> connect(pDSI, "testDSI");
    CORBA_String_var implDSI = orb -> object_to_string(pDSI);

// egcs 1.0.1 and gcc 2.8.0 crash with internal error
#if !(__GNUC__ == 2 && __GNUC_MINOR__ > 7)
    TestInterfaceTimeout_var pTie =
	new TestInterfaceTimeout_skel_tie< TestInterfaceTimeout_impl >
	(i, CORBA_FALSE);
    orb -> connect(pTie, "testTie");
    CORBA_String_var implTie = orb -> object_to_string(pTie);
#endif

    const char* refFile = "TestInterface.ref";
    ofstream out(refFile);
    if(out.fail())
    {
	cerr << argv[0] << ": can't open `" << refFile << "': "
	     << strerror(errno) << endl;
	return 1;
    }
    
    out << impl << endl;
    out << implDSI << endl;
// egcs 1.0.1 and gcc 2.8.0 crash with internal error
#if !(__GNUC__ == 2 && __GNUC_MINOR__ > 7)
    out << implTie << endl;
#endif
    out.close();
    
    boa -> impl_is_ready(CORBA_ImplementationDef::_nil());
    i -> releaseInternal();
    iDSI -> releaseInternal();
	
#ifdef HAVE__UNLINK
    _unlink(refFile);
#else
    unlink(refFile);
#endif

    return 0;
}
