// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <Test1.h>
#include <Test2.h>
#include <TestMacro.h>

void
TestDIIException(CORBA_Object_ptr ti)
{
    CORBA_Request_var request;

    {
	request = ti -> _request("opVoidEx");
	request -> invoke();
	CORBA_Exception* ex = request -> env() -> exception();
	TEST(CORBA_UNKNOWN::_narrow(ex));

	request = ti -> _request("opVoidEx");
	request -> exceptions() -> add(TestInterfaceEx::_tc_ExVoid);
	request -> invoke();
	ex = request -> env() -> exception();
	CORBA_UnknownUserException* uex;
	TEST(uex = CORBA_UnknownUserException::_narrow(ex));
	TestInterfaceEx::ExVoid* iex;
	TEST(uex -> exception() >>= iex);
    }

    {
	request = ti -> _request("opShortEx");
	request -> exceptions() -> add(TestInterfaceEx::_tc_ExShort);
	request -> add_in_arg() <<= (CORBA_Short)10;
	CORBA_Any& inOutAny = request -> add_inout_arg();
	inOutAny <<= (CORBA_Short)20;
	CORBA_Any& outAny = request -> add_out_arg();
	outAny.replace(CORBA__tc_short, 0);
	request -> set_return_type(CORBA__tc_short);
	request -> invoke();
	CORBA_Exception* ex = request -> env() -> exception();
	CORBA_UnknownUserException* uex;
	TEST(uex = CORBA_UnknownUserException::_narrow(ex));
	TestInterfaceEx::ExShort* iex;
	TEST(uex -> exception() >>= iex);
	TEST(iex -> value == 30);
    }

    {
	request = ti -> _request("opDoubleEx");
	request -> exceptions() -> add(TestInterfaceEx::_tc_ExDouble);
	request -> add_in_arg() <<= 10.0;
	CORBA_Any& inOutAny = request -> add_inout_arg();
	inOutAny <<= 20.0;
	CORBA_Any& outAny = request -> add_out_arg();
	outAny.replace(CORBA__tc_double, 0);
	request -> set_return_type(CORBA__tc_double);
	request -> invoke();
	CORBA_Exception* ex = request -> env() -> exception();
	CORBA_UnknownUserException* uex;
	TEST(uex = CORBA_UnknownUserException::_narrow(ex));
	TestInterfaceEx::ExDouble* iex;
	TEST(uex -> exception() >>= iex);
	TEST(iex -> value == 30);
    }

    {
	TestInterfaceEx::StringSequence in;
	in.length(3);
	in[0] = CORBA_string_dup("!!!");
	in[1] = CORBA_string_dup("@@@");
	in[2] = CORBA_string_dup("###");
	TestInterfaceEx::StringSequence inOut;
	inOut.length(2);
	inOut[0] = CORBA_string_dup("%");
	inOut[1] = CORBA_string_dup("^^");
	request = ti -> _request("opStringSequenceEx");
	request -> exceptions() -> add(TestInterfaceEx::_tc_ExStringSequence);
	request -> add_in_arg() <<= in;
	CORBA_Any& inOutAny = request -> add_inout_arg();
	inOutAny <<= inOut;
	CORBA_Any& outAny = request -> add_out_arg();
	outAny.replace(TestInterfaceEx::_tc_StringSequence, 0);
	request -> set_return_type(TestInterfaceEx::_tc_StringSequence);
	request -> invoke();
	CORBA_Exception* ex = request -> env() -> exception();
	CORBA_UnknownUserException* uex;
	TEST(uex = CORBA_UnknownUserException::_narrow(ex));
	TestInterfaceEx::ExStringSequence* iex;
	TEST(uex -> exception() >>= iex);
	TEST(iex -> value.length() == 5);
	TEST(strcmp(iex -> value[0], "!!!") == 0);
	TEST(strcmp(iex -> value[1], "@@@") == 0);
	TEST(strcmp(iex -> value[2], "###") == 0);
	TEST(strcmp(iex -> value[3], "%") == 0);
	TEST(strcmp(iex -> value[4], "^^") == 0);
    }
}
