// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <TestDSI_impl.h>

TestInterfaceExDSI_impl::TestInterfaceExDSI_impl(TestInterfaceTimeout_ptr ti,
						 CORBA_ORB_ptr orb)
    : ti_(TestInterfaceTimeout::_duplicate(ti)),
      orb_(CORBA_ORB::_duplicate(orb))
{
}

CORBA_Boolean
TestInterfaceExDSI_impl::_is_a(const char* name)
{
    if(strcmp(name, "IDL:TestInterface:1.0") == 0 ||
       strcmp(name, "IDL:TestInterfaceEx:1.0") == 0)
    {
	return true;
    }
    else
    {
	return CORBA_Object::_is_a(name);
    }
}

void
TestInterfaceExDSI_impl::invoke(CORBA_ServerRequest_ptr request) throw()
{
    CORBA_String_var name = request -> op_name();

    bool ex;
    if(strlen(name) > 2 &&
       strcmp((const char*)name + strlen(name) - 2, "Ex") == 0)
    {
	name[strlen(name) - 2] = '\0';
	ex = true;
    }
    else
	ex = false;

    if(strcmp(name, "opVoid") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExVoid();
	    request -> exception(any);
	}

	return;
    }

    if(strcmp(name, "opContext") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_string, 0);
	request -> params(list);
	CORBA_Context_ptr ctx = request -> ctx();

	any = list -> item(0) -> value();
	char* pattern;
	*any >>= pattern;

	try
	{
	    TestInterface::StringSequence* ret =
		ti_ -> opContext(pattern, ctx);

	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}
	catch(const CORBA_BAD_CONTEXT& ex)
	{
	    any = new CORBA_Any;
	    *any <<= ex;
	    request -> exception(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrShort") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	CORBA_Short ret = ti_ -> attrShort();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrShort") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value() -> replace(CORBA__tc_short, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Short arg;
	*any >>= arg;

	ti_ -> attrShort(arg);

	return;
    }

    if(strcmp(name, "opShort") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_short, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(CORBA__tc_short, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Short arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	CORBA_Short arg1;
	*any >>= arg1;

	CORBA_Short arg2;

	CORBA_Short ret = ti_ -> opShort(arg0, arg1, arg2);

	any = list -> item(1) -> value();
	*any <<= arg1;
	
	any = list -> item(2) -> value();
	*any <<= arg2;
	
	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExShort(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrUShort") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	CORBA_UShort ret = ti_ -> attrUShort();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrUShort") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_ushort, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_UShort arg;
	*any >>= arg;

	ti_ -> attrUShort(arg);

	return;
    }

    if(strcmp(name, "opUShort") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_ushort, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(CORBA__tc_ushort, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_UShort arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	CORBA_UShort arg1;
	*any >>= arg1;

	CORBA_UShort arg2;

	CORBA_UShort ret = ti_ -> opUShort(arg0, arg1, arg2);

	any = list -> item(1) -> value();
	*any <<= arg1;

	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExUShort(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrLong") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	CORBA_Long ret = ti_ -> attrLong();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrLong") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_long, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Long arg;
	*any >>= arg;

	ti_ -> attrLong(arg);

	return;
    }

    if(strcmp(name, "opLong") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_long, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(CORBA__tc_long, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Long arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	CORBA_Long arg1;
	*any >>= arg1;

	CORBA_Long arg2;

	CORBA_Long ret = ti_ -> opLong(arg0, arg1, arg2);

	any = list -> item(1) -> value();
	*any <<= arg1;

	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExLong(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrULong") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	CORBA_ULong ret = ti_ -> attrULong();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrULong") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_ulong, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_ULong arg;
	*any >>= arg;

	ti_ -> attrULong(arg);

	return;
    }

    if(strcmp(name, "opULong") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_ulong, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(CORBA__tc_ulong, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_ULong arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	CORBA_ULong arg1;
	*any >>= arg1;

	CORBA_ULong arg2;

	CORBA_ULong ret = ti_ -> opULong(arg0, arg1, arg2);

	any = list -> item(1) -> value();
	*any <<= arg1;

	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExULong(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrFloat") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	CORBA_Float ret = ti_ -> attrFloat();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrFloat") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_float, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Float arg;
	*any >>= arg;

	ti_ -> attrFloat(arg);

	return;
    }

    if(strcmp(name, "opFloat") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_float, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(CORBA__tc_float, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Float arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	CORBA_Float arg1;
	*any >>= arg1;

	CORBA_Float arg2;

	CORBA_Float ret = ti_ -> opFloat(arg0, arg1, arg2);

	any = list -> item(1) -> value();
	*any <<= arg1;

	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExFloat(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrDouble") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	CORBA_Double ret = ti_ -> attrDouble();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrDouble") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_double, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Double arg;
	*any >>= arg;

	ti_ -> attrDouble(arg);

	return;
    }

    if(strcmp(name, "opDouble") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_double, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(CORBA__tc_double, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Double arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	CORBA_Double arg1;
	*any >>= arg1;

	CORBA_Double arg2;

	CORBA_Double ret = ti_ -> opDouble(arg0, arg1, arg2);

	any = list -> item(1) -> value();
	*any <<= arg1;

	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExDouble(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrBoolean") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	CORBA_Boolean ret = ti_ -> attrBoolean();

	any = new CORBA_Any;
	*any <<= CORBA_Any::from_boolean(ret);
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrBoolean") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value() -> replace(CORBA__tc_boolean, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Boolean arg;
	*any >>= CORBA_Any::to_boolean(arg);

	ti_ -> attrBoolean(arg);

	return;
    }

    if(strcmp(name, "opBoolean") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_boolean, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(CORBA__tc_boolean, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Boolean arg0;
	*any >>= CORBA_Any::to_boolean(arg0);

	any = list -> item(1) -> value();
	CORBA_Boolean arg1;
	*any >>= CORBA_Any::to_boolean(arg1);

	CORBA_Boolean arg2;

	CORBA_Boolean ret = ti_ -> opBoolean(arg0, arg1, arg2);

	any = list -> item(1) -> value();
	*any <<= CORBA_Any::from_boolean(arg1);

	any = list -> item(2) -> value();
	*any <<= CORBA_Any::from_boolean(arg2);

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExBoolean(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= CORBA_Any::from_boolean(ret);
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrChar") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	CORBA_Char ret = ti_ -> attrChar();

	any = new CORBA_Any;
	*any <<= CORBA_Any::from_char(ret);
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrChar") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value() -> replace(CORBA__tc_char, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Char arg;
	*any >>= CORBA_Any::to_char(arg);

	ti_ -> attrChar(arg);

	return;
    }

    if(strcmp(name, "opChar") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_char, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(CORBA__tc_char, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Char arg0;
	*any >>= CORBA_Any::to_char(arg0);

	any = list -> item(1) -> value();
	CORBA_Char arg1;
	*any >>= CORBA_Any::to_char(arg1);

	CORBA_Char arg2;

	CORBA_Char ret = ti_ -> opChar(arg0, arg1, arg2);

	any = list -> item(1) -> value();
	*any <<= CORBA_Any::from_char(arg1);

	any = list -> item(2) -> value();
	*any <<= CORBA_Any::from_char(arg2);

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExChar(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= CORBA_Any::from_char(ret);
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrOctet") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	CORBA_Octet ret = ti_ -> attrOctet();

	any = new CORBA_Any;
	*any <<= CORBA_Any::from_octet(ret);
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrOctet") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value() -> replace(CORBA__tc_octet, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Octet arg;
	*any >>= CORBA_Any::to_octet(arg);

	ti_ -> attrOctet(arg);

	return;
    }

    if(strcmp(name, "opOctet") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_octet, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(CORBA__tc_octet, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Octet arg0;
	*any >>= CORBA_Any::to_octet(arg0);

	any = list -> item(1) -> value();
	CORBA_Octet arg1;
	*any >>= CORBA_Any::to_octet(arg1);

	CORBA_Octet arg2;

	CORBA_Octet ret = ti_ -> opOctet(arg0, arg1, arg2);

	any = list -> item(1) -> value();
	*any <<= CORBA_Any::from_octet(arg1);

	any = list -> item(2) -> value();
	*any <<= CORBA_Any::from_octet(arg2);

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExOctet(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= CORBA_Any::from_octet(ret);
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrString") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	CORBA_String_var ret = ti_ -> attrString();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrString") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value() -> replace(CORBA__tc_string, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	char* arg;
	*any >>= arg;

	ti_ -> attrString(arg);

	return;
    }

    if(strcmp(name, "opString") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_string, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(CORBA__tc_string, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	char* arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	char* tmpArg1;
	*any >>= tmpArg1;

	CORBA_String_var arg1 = CORBA_string_dup(tmpArg1);
	CORBA_String_var arg2;

	CORBA_String_var ret = ti_ -> opString(arg0, arg1.inout(), arg2.out());

	any = list -> item(1) -> value();
	*any <<= arg1;

	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExString(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrAny") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	CORBA_Any* ret = ti_ -> attrAny();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrAny") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value() -> replace(CORBA__tc_any, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Any* arg;
	*any >>= arg;

	ti_ -> attrAny(*arg);

	return;
    }

    if(strcmp(name, "opAny") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(CORBA__tc_any, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(CORBA__tc_any, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	CORBA_Any* arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	CORBA_Any* arg1;
	*any >>= arg1;
	
	CORBA_Any* arg2;

	CORBA_Any* ret = ti_ -> opAny(*arg0, *arg1, arg2);

	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExAny(*ret);
	    delete ret;
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrTestEnum") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	TestInterface::TestEnum ret = ti_ -> attrTestEnum();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrTestEnum") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_TestEnum, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::TestEnum arg;
	*any >>= arg;

	ti_ -> attrTestEnum(arg);

	return;
    }

    if(strcmp(name, "opTestEnum") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_TestEnum, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(TestInterface::_tc_TestEnum, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::TestEnum arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	TestInterface::TestEnum arg1;
	*any >>= arg1;

	TestInterface::TestEnum arg2;

	TestInterface::TestEnum ret = ti_ -> opTestEnum(arg0, arg1, arg2);

	any = list -> item(1) -> value();
	*any <<= arg1;

	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExTestEnum(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrTestInterface") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any = aTestInterface;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrTestInterface") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(_tc_TestInterface, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	aTestInterface = *any;

	return;
    }

    if(strcmp(name, "opTestInterface") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(_tc_TestInterface, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(_tc_TestInterface, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	aTestInterface = *any;

	any = list -> item(1) -> value();
	*any = aTestInterface;

	any = list -> item(2) -> value();
	*any = aTestInterface;

	any = new CORBA_Any;
	*any = aTestInterface;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_get_attrFixedStruct") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	TestInterface::FixedStruct ret = ti_ -> attrFixedStruct();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrFixedStruct") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_FixedStruct, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::FixedStruct* arg;
	*any >>= arg;

	ti_ -> attrFixedStruct(*arg);

	return;
    }

    if(strcmp(name, "opFixedStruct") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_FixedStruct, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(TestInterface::_tc_FixedStruct, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::FixedStruct* arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	TestInterface::FixedStruct* arg1;
	*any >>= arg1;

	TestInterface::FixedStruct arg2;

	TestInterface::FixedStruct ret =
	    ti_ -> opFixedStruct(*arg0, *arg1, arg2);


	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExFixedStruct(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrVariableStruct") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	TestInterface::VariableStruct* ret = ti_ -> attrVariableStruct();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrVariableStruct") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_VariableStruct, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::VariableStruct* arg;
	*any >>= arg;

	ti_ -> attrVariableStruct(*arg);

	return;
    }

    if(strcmp(name, "opVariableStruct") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_VariableStruct, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(TestInterface::_tc_VariableStruct, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::VariableStruct* arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	TestInterface::VariableStruct* arg1;
	*any >>= arg1;

	TestInterface::VariableStruct* arg2;

	TestInterface::VariableStruct* ret =
	    ti_ -> opVariableStruct(*arg0, *arg1, arg2);


	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExVariableStruct(*ret);
	    delete ret;
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrFixedUnion") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	TestInterface::FixedUnion ret = ti_ -> attrFixedUnion();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrFixedUnion") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_FixedUnion, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::FixedUnion* arg;
	*any >>= arg;

	ti_ -> attrFixedUnion(*arg);

	return;
    }

    if(strcmp(name, "opFixedUnion") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_FixedUnion, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(TestInterface::_tc_FixedUnion, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::FixedUnion* arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	TestInterface::FixedUnion* arg1;
	*any >>= arg1;

	TestInterface::FixedUnion arg2;

	TestInterface::FixedUnion ret =
	    ti_ -> opFixedUnion(*arg0, *arg1, arg2);

	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExFixedUnion(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrVariableUnion") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any = aVariableUnion;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrVariableUnion") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_VariableUnion, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	aVariableUnion = *any;

	return;
    }

    if(strcmp(name, "opVariableUnion") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_VariableUnion, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(TestInterface::_tc_VariableUnion, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	aVariableUnion = *any;

	any = list -> item(1) -> value();
	*any = aVariableUnion;

	any = list -> item(2) -> value();
	*any = aVariableUnion;

	any = new CORBA_Any;
	*any = aVariableUnion;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_get_attrStringSequence") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	TestInterface::StringSequence* ret = ti_ -> attrStringSequence();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrStringSequence") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_StringSequence, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::StringSequence* arg;
	*any >>= arg;

	ti_ -> attrStringSequence(*arg);

	return;
    }

    if(strcmp(name, "opStringSequence") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_StringSequence, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(TestInterface::_tc_StringSequence, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::StringSequence* arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	TestInterface::StringSequence* arg1;
	*any >>= arg1;

	TestInterface::StringSequence* arg2;

	TestInterface::StringSequence* ret =
	    ti_ -> opStringSequence(*arg0, *arg1, arg2);

	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExStringSequence(*ret);
	    delete ret;
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrFixedArray") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	TestInterface::FixedArray_slice* ret = ti_ -> attrFixedArray();

	any = new CORBA_Any;
	*any <<= TestInterface::FixedArray_forany(ret, true);
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrFixedArray") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_FixedArray, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::FixedArray_forany arg;
	*any >>= arg;

	ti_ -> attrFixedArray(arg);

	return;
    }

    if(strcmp(name, "opFixedArray") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_FixedArray, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(TestInterface::_tc_FixedArray, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::FixedArray_forany arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	TestInterface::FixedArray_forany arg1;
	*any >>= arg1;

	TestInterface::FixedArray arg2;

	TestInterface::FixedArray_slice* ret =
	    ti_ -> opFixedArray(arg0, arg1.inout(), arg2);
	
	any = list -> item(2) -> value();
	*any <<= TestInterface::FixedArray_forany(arg2, false);

	if(ex)
	{
	    any = new CORBA_Any;
#ifdef HAVE_VCPLUSPLUS_BUGS
	    *any <<= new TestInterfaceEx::ExFixedArray(
		(const TestInterface::FixedArray_slice*)ret);
#else
	    *any <<= new TestInterfaceEx::ExFixedArray(ret);
#endif
	    TestInterface::FixedArray_free(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= TestInterface::FixedArray_forany(ret, true);
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrVariableArray") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	TestInterface::VariableArray_slice* ret = ti_ -> attrVariableArray();

	any = new CORBA_Any;
	*any <<= TestInterface::VariableArray_forany(ret, true);
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrVariableArray") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_VariableArray, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::VariableArray_forany arg;
	*any >>= arg;

	ti_ -> attrVariableArray(arg);

	return;
    }

    if(strcmp(name, "opVariableArray") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_VariableArray, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(TestInterface::_tc_VariableArray, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::VariableArray_forany arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	TestInterface::VariableArray_forany arg1;
	*any >>= arg1;

	TestInterface::VariableArray_slice* arg2;

	TestInterface::VariableArray_slice* ret =
	    ti_ -> opVariableArray(arg0, arg1.inout(), arg2);
	
	any = list -> item(2) -> value();
	*any <<= TestInterface::VariableArray_forany(arg2, true);

	if(ex)
	{
	    any = new CORBA_Any;
#ifdef HAVE_VCPLUSPLUS_BUGS
	    *any <<= new TestInterfaceEx::ExVariableArray(
		(const TestInterface::VariableArray_slice*)ret);
#else
	    *any <<= new TestInterfaceEx::ExVariableArray(ret);
#endif
	    TestInterface::VariableArray_free(ret);
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= TestInterface::VariableArray_forany(ret, true);
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrFixedArraySequence") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	TestInterface::FixedArraySequence* ret =
	    ti_ -> attrFixedArraySequence();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrFixedArraySequence") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_FixedArraySequence, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::FixedArraySequence* arg;
	*any >>= arg;

	ti_ -> attrFixedArraySequence(*arg);

	return;
    }

    if(strcmp(name, "opFixedArraySequence") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_FixedArraySequence, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(TestInterface::_tc_FixedArraySequence, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::FixedArraySequence* arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	TestInterface::FixedArraySequence* arg1;
	*any >>= arg1;

	TestInterface::FixedArraySequence* arg2;

	TestInterface::FixedArraySequence* ret =
	    ti_ -> opFixedArraySequence(*arg0, *arg1, arg2);

	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExFixedArraySequence(*ret);
	    delete ret;
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "_get_attrVariableArraySequence") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	request -> params(list);

	TestInterface::VariableArraySequence* ret =
	    ti_ -> attrVariableArraySequence();

	any = new CORBA_Any;
	*any <<= ret;
	request -> result(any);

	return;
    }

    if(strcmp(name, "_set_attrVariableArraySequence") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_VariableArraySequence, 0);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::VariableArraySequence* arg;
	*any >>= arg;

	ti_ -> attrVariableArraySequence(*arg);

	return;
    }

    if(strcmp(name, "opVariableArraySequence") == 0)
    {
	CORBA_NVList_ptr list;
	CORBA_Any* any;

	orb_ -> create_list(0, list);
	list -> add(CORBA_ARG_IN) -> value()
	    -> replace(TestInterface::_tc_VariableArraySequence, 0);
	list -> add(CORBA_ARG_INOUT) -> value()
	    -> replace(TestInterface::_tc_VariableArraySequence, 0);
	list -> add(CORBA_ARG_OUT);
	request -> params(list);

	any = list -> item(0) -> value();
	TestInterface::VariableArraySequence* arg0;
	*any >>= arg0;

	any = list -> item(1) -> value();
	TestInterface::VariableArraySequence* arg1;
	*any >>= arg1;

	TestInterface::VariableArraySequence* arg2;

	TestInterface::VariableArraySequence* ret =
	    ti_ -> opVariableArraySequence(*arg0, *arg1, arg2);

	any = list -> item(2) -> value();
	*any <<= arg2;

	if(ex)
	{
	    any = new CORBA_Any;
	    *any <<= new TestInterfaceEx::ExVariableArraySequence(*ret);
	    delete ret;
	    request -> exception(any);
	}
	else
	{
	    any = new CORBA_Any;
	    *any <<= ret;
	    request -> result(any);
	}

	return;
    }

    if(strcmp(name, "op_UNKNOWN_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_UNKNOWN(1, CORBA_COMPLETED_YES);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_BAD_PARAM_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_BAD_PARAM(2, CORBA_COMPLETED_NO);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_NO_MEMORY_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_NO_MEMORY(3, CORBA_COMPLETED_MAYBE);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_IMP_LIMIT_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_IMP_LIMIT(4, CORBA_COMPLETED_YES);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_COMM_FAILURE_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_COMM_FAILURE(5, CORBA_COMPLETED_NO);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_INV_OBJREF_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_INV_OBJREF(6, CORBA_COMPLETED_MAYBE);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_NO_PERMISSION_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_NO_PERMISSION(7, CORBA_COMPLETED_YES);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_INTERNAL_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_INTERNAL(8, CORBA_COMPLETED_NO);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_MARSHAL_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_MARSHAL(9, CORBA_COMPLETED_MAYBE);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_INITIALIZE_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_INITIALIZE(10, CORBA_COMPLETED_YES);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_NO_IMPLEMENT_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_NO_IMPLEMENT(11, CORBA_COMPLETED_NO);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_BAD_TYPECODE_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_BAD_TYPECODE(12, CORBA_COMPLETED_MAYBE);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_BAD_OPERATION_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_BAD_OPERATION(13, CORBA_COMPLETED_YES);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_NO_RESOURCES_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_NO_RESOURCES(14, CORBA_COMPLETED_NO);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_NO_RESPONSE_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_NO_RESPONSE(15, CORBA_COMPLETED_MAYBE);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_PERSIST_STORE_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_PERSIST_STORE(16, CORBA_COMPLETED_YES);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_BAD_INV_ORDER_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_BAD_INV_ORDER(17, CORBA_COMPLETED_NO);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_TRANSIENT_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_TRANSIENT(18, CORBA_COMPLETED_MAYBE);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_FREE_MEM_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_FREE_MEM(19, CORBA_COMPLETED_YES);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_INV_IDENT_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_INV_IDENT(20, CORBA_COMPLETED_NO);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_INV_FLAG_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_INV_FLAG(21, CORBA_COMPLETED_MAYBE);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_INTF_REPOS_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_INTF_REPOS(22, CORBA_COMPLETED_YES);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_BAD_CONTEXT_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_BAD_CONTEXT(23, CORBA_COMPLETED_NO);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_OBJ_ADAPTER_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_OBJ_ADAPTER(24, CORBA_COMPLETED_MAYBE);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_DATA_CONVERSION_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_DATA_CONVERSION(25, CORBA_COMPLETED_YES);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_OBJECT_NOT_EXIST_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_OBJECT_NOT_EXIST(26, CORBA_COMPLETED_NO);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_TRANSACTION_REQUIRED_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_TRANSACTION_REQUIRED(27, CORBA_COMPLETED_NO);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_TRANSACTION_ROLLEDBACK_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_TRANSACTION_ROLLEDBACK(28, CORBA_COMPLETED_NO);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_INVALID_TRANSACTION_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_INVALID_TRANSACTION(29, CORBA_COMPLETED_NO);
	request -> exception(any);

	return;
    }

    if(strcmp(name, "op_INV_POLICY_") == 0)
    {
	assert(ex);

	CORBA_NVList_ptr list;
	CORBA_Any* any;
	
	orb_ -> create_list(0, list);
	request -> params(list);

	any = new CORBA_Any;
	*any <<= new CORBA_INV_POLICY(30, CORBA_COMPLETED_NO);
	request -> exception(any);

	return;
    }

    cerr << "DSI implementation: unknown operation: " << name << endl;

    CORBA_NVList_ptr list;
    CORBA_Any* any;
    
    orb_ -> create_list(0, list);
    request -> params(list);
    
    any = new CORBA_Any;
    *any <<= new CORBA_BAD_OPERATION();
    request -> exception(any);
}

void
TestInterfaceExDSI_impl::releaseInternal()
{
    //
    // Avoid cyclic object dependencies
    //
    CORBA_Any dummy;
    aTestInterface = dummy;
    aVariableUnion = dummy;
}
