// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <Test1.h>
#include <Test2.h>
#include <TestMacro.h>

void
TestUnion()
{
    TestUnion1 u;
    u.l(123);
    TEST(u.l() == 123);
    TEST(u._d() == -1);
    
    u.tc(_tc_TestUnion1);
    u._d(-6);
    TEST(u._d() == -6);
    u._d(4);
    TEST(u._d() == 4);
    u._d(999);
    TEST(u.tc() -> exactly_equal(_tc_TestUnion1));

    CORBA_Double arr[10][20][30];
    arr[2][2][2] = 3.14;
    arr[0][0][0] = 1234;
    arr[9][19][29] = 1.23E23;
    
    u.a(arr);
    DoubleArray_slice* sl = u.a();
    TEST(sl[2][2][2] == 3.14);
    TEST(sl[0][0][0] == 1234);
    TEST(sl[9][19][29] == 1.23E23);
    TEST(u._d() == -2);
    
    TestUnion1 u2 = u;
    sl = u2.a();
    TEST(sl[2][2][2] == 3.14);
    TEST(sl[0][0][0] == 1234);
    TEST(sl[9][19][29] == 1.23E23);
    TEST(u2._d() == -2);
    
    u.s(CORBA_string_dup("Hello!"));
    TEST(strcmp(u.s(), "Hello!") == 0);
    TEST(u._d() == -3);
    
    CORBA_String_var str = CORBA_string_dup("abc");
    u.s(str);
    TEST(strcmp(u.s(), "abc") == 0);
    TEST(u._d() == -3);
    
    u.s((const char*)"def");
    TEST(strcmp(u.s(), "def") == 0);
    TEST(u._d() == -3);
    
    u2 = u;
    TEST(strcmp(u2.s(), "def") == 0);
    TEST(u2._d() == -3);
    
    TestStruct2 ts;
    ts.s.s = -32768;
    ts.s.l = 2147483647;
    ts.s.d = 1E200;
    ts.s.b = true;
    ts.s.c = 'x';
    ts.s.o = 0xff;
    ts.s.str = (const char*)"abc";
    ts.a <<= u2;
    ts.da[0][0][0] = 1.23;
    ts.da[2][3][4] = -1.11;
    ts.sa[50] = CORBA_string_dup("Hi!");
    u.str(ts);
    u._d(0);
    TEST(u._d() == 0);
    u._d(1);
    TEST(u._d() == 1);
    u._d(2);
    TEST(u._d() == 2);
    u._d(3);
    TEST(u._d() == 3);
    u._d(-4);
    TEST(u._d() == -4);
    u._d(-5);
    TEST(u._d() == -5);
    TEST(u.str().s.s == -32768);
    TEST(u.str().s.l == 2147483647);
    TEST(u.str().s.d == 1E200);
    TEST(u.str().s.b == CORBA_TRUE);
    TEST(u.str().s.c == 'x');
    TEST(u.str().s.o == 0xff);
    TEST(strcmp(u.str().s.str, "abc") == 0);
    TestUnion1* u3p;
    TEST(u.str().a >>= u3p);
    TEST(strcmp(u3p -> s(), "def") == 0);
    TEST(u3p -> _d() == -3);
    TEST(u.str().da[0][0][0] == 1.23);
    TEST(u.str().da[2][3][4] == -1.11);
    TEST(strcmp(u.str().sa[50], "Hi!") == 0);

    TestUnion2 u4;
    u4.un(u);
    TEST(u4._d() == C);
    TEST(u4.un()._d() == -5);
    TEST(u4.un().str().s.s == -32768);
    TEST(u4.un().str().s.l == 2147483647);
    TEST(u4.un().str().s.d == 1E200);
    TEST(u4.un().str().s.b == CORBA_TRUE);
    TEST(u4.un().str().s.c == 'x');
    TEST(u4.un().str().s.o == 0xff);
    TEST(strcmp(u4.un().str().s.str,"abc") == 0);
    TEST(u4.un().str().a >>= u3p);
    TEST(strcmp(u3p -> s(), "def") == 0);
    TEST(u3p -> _d() == -3);
    TEST(u4.un().str().da[0][0][0] == 1.23);
    TEST(u4.un().str().da[2][3][4] == -1.11);
    TEST(strcmp(u4.un().str().sa[50], "Hi!") == 0);

    TestUnion3 u5;
    u5._default();
    u5._d('e');
    TEST(u5._d() == 'e');
    u5._d('f');
    TEST(u5._d() == 'f');
    u5._d(0);
    TEST(u5._d() == 0);
    u5.c('1');
    u5._d('a');
    TEST(u5._d() == 'a');
    u5._d('b');
    TEST(u5._d() == 'b');
    TEST(u5.c() == '1');
}

