// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef COS_PROPERTY_IMPL_H
#define COS_PROPERTY_IMPL_H

#include <OB/CosProperty_skel.h>

class CosPropertyService_PropertySetDef_impl
    : virtual public CosPropertyService_PropertySetDef_skel
{
    //
    // The ORB
    //
    CORBA_ORB_var orb_;

    //
    // My PropertyDefs
    //
    CosPropertyService_PropertyDefs propertySeq_;

    //
    // List of allowed TypeCodes
    //
    CosPropertyService_PropertyTypes allowedTypes_;

    //
    // List of allowed properties
    //
    CosPropertyService_PropertyDefs allowedProperties_;

    //
    // Check name, type and property
    //
    void check(const char*, const CORBA_Any&,
	       CosPropertyService_PropertyModeType);

    //
    // Find property by name
    //
    CosPropertyService_PropertyDef* get(const char*, CORBA_ULong* = 0);

public:

    CosPropertyService_PropertySetDef_impl(CORBA_ORB_ptr);
    CosPropertyService_PropertySetDef_impl(
	CORBA_ORB_ptr,
	const CosPropertyService_PropertyTypes&,
	const CosPropertyService_PropertyDefs&);
    CosPropertyService_PropertySetDef_impl(
	CORBA_ORB_ptr,
	const CosPropertyService_PropertyDefs&);

    virtual void define_property(const char*, const CORBA_Any&);

    virtual void define_properties(const CosPropertyService_Properties&);

    virtual CORBA_ULong get_number_of_properties();

    virtual void get_all_property_names(
	CORBA_ULong,
	CosPropertyService_PropertyNames*&,
	CosPropertyService_PropertyNamesIterator_ptr&);

    virtual CORBA_Any* get_property_value(const char*);

    virtual CORBA_Boolean get_properties(
	const CosPropertyService_PropertyNames&,
	CosPropertyService_Properties*&);

    virtual void get_all_properties(
	CORBA_ULong,
	CosPropertyService_Properties*&,
	CosPropertyService_PropertiesIterator_ptr&);

    virtual void delete_property(const char*);

    virtual void delete_properties(const CosPropertyService_PropertyNames&);

    virtual CORBA_Boolean delete_all_properties();

    virtual CORBA_Boolean is_property_defined(const char*);

    virtual void get_allowed_property_types(
	CosPropertyService_PropertyTypes*&);

    virtual void get_allowed_properties(CosPropertyService_PropertyDefs*&);

    virtual void define_property_with_mode(
	const char*, const CORBA_Any&,
	CosPropertyService_PropertyModeType);

    virtual void define_properties_with_modes(
	const CosPropertyService_PropertyDefs&);

    virtual CosPropertyService_PropertyModeType get_property_mode(const char*);

    virtual CORBA_Boolean get_property_modes(
	const CosPropertyService_PropertyNames&,
	CosPropertyService_PropertyModes*&);

    virtual void set_property_mode(const char*,
                                   CosPropertyService_PropertyModeType);

    virtual void set_property_modes(const CosPropertyService_PropertyModes&);
};

class CosPropertyService_PropertyNamesIterator_impl
    : virtual public CosPropertyService_PropertyNamesIterator_skel
{
    CORBA_ORB_var orb_;
    CORBA_ULong idx_;
    CosPropertyService_PropertyNames names_;

public:

    CosPropertyService_PropertyNamesIterator_impl(
	CORBA_ORB_ptr,
	const CosPropertyService_PropertyNames&);

    virtual void reset();

    virtual CORBA_Boolean next_one(CosPropertyService_PropertyName&);
    virtual CORBA_Boolean next_n(CORBA_ULong,
				 CosPropertyService_PropertyNames*&);

    virtual void destroy();
};

class CosPropertyService_PropertiesIterator_impl
    : virtual public CosPropertyService_PropertiesIterator_skel
{
    CORBA_ORB_var orb_;
    CORBA_ULong idx_;
    CosPropertyService_PropertyDefs properties_;

public:

    CosPropertyService_PropertiesIterator_impl(
	CORBA_ORB_ptr,
	const CosPropertyService_PropertyDefs&);

    virtual void reset();

    virtual CORBA_Boolean next_one(CosPropertyService_Property*&);
    virtual CORBA_Boolean next_n(CORBA_ULong, CosPropertyService_Properties*&);

    virtual void destroy();
};

class CosPropertyService_PropertySetFactory_impl
    : virtual public CosPropertyService_PropertySetFactory_skel
{
    CORBA_ORB_var orb_;

public:

    CosPropertyService_PropertySetFactory_impl(CORBA_ORB_ptr orb)
	: orb_(CORBA_ORB::_duplicate(orb)) { }

    virtual CosPropertyService_PropertySet_ptr create_propertyset();

    virtual CosPropertyService_PropertySet_ptr
    create_constrained_propertyset(const CosPropertyService_PropertyTypes&,
				   const CosPropertyService_Properties&);

    virtual CosPropertyService_PropertySet_ptr
    create_initial_propertyset(const CosPropertyService_Properties&);
};

class CosPropertyService_PropertySetDefFactory_impl
    : virtual public CosPropertyService_PropertySetDefFactory_skel
{
    CORBA_ORB_var orb_;

public:

    CosPropertyService_PropertySetDefFactory_impl(CORBA_ORB_ptr orb)
	: orb_(CORBA_ORB::_duplicate(orb)) { }

    virtual CosPropertyService_PropertySetDef_ptr create_propertysetdef();

    virtual CosPropertyService_PropertySetDef_ptr
    create_constrained_propertysetdef(const CosPropertyService_PropertyTypes&,
				      const CosPropertyService_PropertyDefs&);

    virtual CosPropertyService_PropertySetDef_ptr
    create_initial_propertysetdef(const CosPropertyService_PropertyDefs&);
};

#endif
