 /* **  FACILITY:	MMK  **- **  ABSTRACT:	Routines for performing builds.  ** **  MODULE DESCRIPTION:  **< **  	This module contains routines that are used to seek out> **  dependencies, determine if targets need to be updated, and% **  actually carry out those updates.  ** **  AUTHOR: 	    M. Madison L **  	    	    COPYRIGHT  1992-1997, MADGOAT SOFTWARE.  ALL RIGHTS RESERVED. ** **  CREATION DATE:  21-AUG-1992  ** **  MODIFICATION HISTORY:  **1 **  	21-AUG-1992 V1.0    Madison 	Initial coding. + **  	27-AUG-1992 V1.1    Madison 	Comments. F **  	29-SEP-1992 V1.2    Madison 	Add support for /FORCE, /FROM, /OUT.E **  	12-OCT-1992 V1.2-1  Madison 	Handle generic sources case better. ; **  	02-APR-1993 V1.3    Madison 	Handle ignore error flag. + **  	09-APR-1993 V1.3-1  Madison 	Comments. ; **  	29-APR-1993 V1.3-2  Madison 	Fix SYS$OUTPUT conflicts. 5 **  	04-JUN-1993 V1.4    Madison 	Add IGNORE support. > **  	07-JUN-1993 V1.5    Madison 	Provide changed-source list.D **  	21-AUG-1993 V1.6    Madison 	Don't assume first source is main.K **  	24-SEP-1993 V1.6-1  Madison 	Set have_rdt on built targets when /FROM. H **  	17-OCT-1993 V1.7    Madison 	Eliminate need for permanent libfiles.9 **  	20-OCT-1993 V1.8    Madison 	Add ctrl-T AST support. I **  	22-OCT-1993 V1.8-1  Madison 	Improve handling of intermediate files. F **  	22-NOV-1993 V1.8-2  Madison 	Have Build_Target use Parse_Objects,0 **  	    	    	    	    	    fix trgobj setting.L **  	01-DEC-1993 V1.8-3  Madison 	Have built-in rules honor /IGNORE setting.F **  	02-DEC-1993 V1.8-4  Madison 	Backout intermediate-deletion stuff.F **  	09-DEC-1993 V1.8-5  Madison 	Remove extraneous extract_name call.; **  	12-DEC-1993 V1.9    Madison 	Support for $(MMS) macro. D **  	14-APR-1994 V1.9-1  Madison 	Fix build of changed-sources list.I **  	06-MAY-1994 V1.9-2  Madison 	Output @-prefixed command on /NOACTION. 6 **  	27-JUN-1994 V1.9-3  Madison 	Fix misplaced break.2 **  	01-JUL-1994 V2.0    Madison 	Add CMS support.B **  	11-JUL-1994 V2.0-1  Madison 	Fix the way .DEFAULT is handled.C **  	12-JUL-1994 V2.1    Madison 	Fix some other MMS discrepancies. C **  	14-JUL-1994 V2.2    Madison 	Add prefixing on inference rules. I **  	22-JUL-1994 V2.2-1  Madison 	Let prefixed rules inherit actions from % **  	    	    	    	    	   generics. H **  	22-AUG-1994 V2.2-2  Madison 	Edit out the KILL_INTERMEDIATES stuff.B **  	28-DEC-1994 V2.3    Madison 	Allow for cmdqptr == 0 case; let@ **  	    	    	    	    	  generic targets have no action lists.C **  	10-JAN-1995 V2.3-1  Madison 	Handle command echoing specially. < **  	12-JAN-1995 V2.3-2  Madison 	Handle line splits better.8 **  	21-JUN-1995 V2.4    Madison 	Support /SKIP, /CHECK.0 **  	21-JUL-1995 V2.4-1  Madison 	Fix for /SKIP.E **  	06-NOV-1995 V2.4-2  Madison 	Fix use of generic inference rules. C **  	23-DEC-1996 V2.5    Madison 	Support forced commands on rules. I **  	23-MAR-1997 V2.5-1  Madison 	Set symbol MMS$STATUS to action status.  **-- */
 #ifdef __DECC $ #pragma module BUILD_TARGET "V2.5-1" #else  #ifndef __GNUC__ #module BUILD_TARGET "V2.5-1"  #endif #endif #include "mmk.h" #pragma nostandard #include "mmk_msg.h" #pragma standard #include "globals.h" #ifdef __GNUC__  #include <vms/rmsdef.h>  #include <vms/libclidef.h> #else  #include <rmsdef.h>  #include <libclidef.h> #endif   /* ** Forward declarations  */     void Build_Target(char *);9     struct DEPEND *find_dependency(struct OBJECT *, int); >     static int needs_updating(struct DEPEND *, struct RULE **,4     	    	    	    	struct OBJREF **, struct QUE *);.     static int do_build(struct OBJECT *, int);>     static void perform_update(struct DEPEND *, struct RULE *,3     	    	    	    	struct OBJREF *, struct QUE *);       void close_subprocess(void);#     static unsigned int echo_ast(); G     static unsigned int send_cmd_and_wait(unsigned int *, char *, int); F     static void execute_command(unsigned int *, struct CMD *, char *);   /* ** External references */D     extern struct DEPEND *mem_get_depend(void);	    /* module MEM */D     extern struct OBJECT *mem_get_object(void);	    /* module MEM */D     extern struct OBJREF *mem_get_objref(void);	    /* module MEM */A     extern struct CMD *mem_get_cmd(void);   	    /* module MEM */ D     extern void mem_free_object(struct OBJECT *);   /* module MEM */D     extern void mem_free_objref(struct OBJREF *);   /* module MEM */E     extern struct RULE *find_rule(char *, char *);  /* module MISC */ R     extern struct RULE *find_rule_with_prefixes(struct OBJECT *, struct OBJECT *);C     extern struct RULE *scan_rule_list(struct RULE *, char *, int); E     extern int extract_filetype(char *, char *);    /* module MISC */ E     extern int extract_filename(char *, char *);    /* module MISC */ E     extern int extract_name(char *, char *);   	    /* module MISC */ B     extern int prefix_match(char *, char *);	    /* module MISC */B     extern struct SFX *find_suffix(char *); 	    /* module MISC */?     extern void upcase(char *);	    	    	    /* module MISC */ K     extern int make_object_name(char *, struct OBJECT *); /* module MISC */ S     extern void set_ctrlt_ast(unsigned int (*)(), unsigned int);  /* module MISC */ A     extern void clear_ctrlt_ast(void);	    	    /* module MISC */ C     extern unsigned int file_exists();	    	    /* module FILEIO */ H     extern unsigned int get_rdt(struct OBJECT *);   /* module GET_RDT */H     extern void lbr_flush(void);                    /* module GET_RDT */G     extern unsigned int sp_open(), sp_close(), sp_send(), sp_receive(); G                                                     /* module SP_MGR */ -     extern unsigned int sp_show_subprocess(); A     extern int Resolve_Symbols(char *, int, char **, int *, int); L                                                         /* module SYMBOLS */F     extern void Create_Local_Symbols(struct DEPEND *, struct OBJREF *,<     	    	    	    	    struct QUE *);  /* module SYMBOLS */L     extern void Clear_Local_Symbols(void);              /* module SYMBOLS */N     extern unsigned int put_output(struct dsc$descriptor *); /* module MAIN */O     extern unsigned int put_command(struct dsc$descriptor *); /* module MAIN */ L     extern struct OBJECT *Find_Object(struct OBJECT *); /* module OBJECTS */L     extern void Insert_Object(struct OBJECT *);         /* module OBJECTS */Y     extern void Parse_Objects(char *, int, struct QUE *, int); /* module PARSE_OBJECTS */    /*4 ** Statics used with the subprocess and SP_MGR stuff */C     static unsigned int spctx = 0, static_status, command_complete; K     static $DESCRIPTOR(ini_dsc1, "MMK___OPEN = \"OPEN\" !'F$VERIFY(0,0)'"); J     static $DESCRIPTOR(ini_dsc2, "MMK___SET  = \"SET\" !'F$VERIFY(0,0)'");3     static $DESCRIPTOR(ini_dsc3, "MMK___SET NOON"); N     static $DESCRIPTOR(ini_dsc4, "MMK___OPEN/WRITE MMK___OUTPUT SYS$OUTPUT:");! #define EOM_TEXT "MMK____status="  #define EOM_LEN  14 F #define EOM_CMD1 "MMK____status = F$INTEGER($STATUS) !'F$VERIFY(0,0)'"* #define EOM_CMD2 "MMK___WRITE = \"WRITE\""L #define EOM_CMD3 "MMK___WRITE MMK___OUTPUT \"MMK____status=\",MMK____status"   /* **++ **  ROUTINE:	Build_Target  ** **  FUNCTIONAL DESCRIPTION:  **= **  	Builds a target specified by name.  If the name is null, : **  we just build the first target in the dependency list. **' **  RETURNS:	void (errors are signaled)  ** **  PROTOTYPE: ** **  	Build_Target(char *name)  **1 **  name:   ASCIZ_string, read only, by reference  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */ void Build_Target(char *name) {        struct DEPEND *dep;        if (*name == '\0') {     	dep = dependencies.flink;      	if (dep == &dependencies) {'     	    lib$signal(MMK__NOTARGETS, 0);      	    return;     	})     	make_object_name(name, dep->target);      	do_build(dep->target, 0);     } else {     	struct QUE objque;      	struct OBJECT *obj, *obj2;      	char *cp;  )     	objque.head = objque.tail = &objque;   3     	Parse_Objects(name, strlen(name), &objque, 1); "     	if (objque.head == &objque) {-     	    lib$signal(MMK__NOSUCHTRG, 1, name);      	    return;     	}%     	queue_remove(objque.head, &obj); #     	dep = find_dependency(obj, 1); &     	if (dep == (struct DEPEND *) 0) {-     	    lib$signal(MMK__NOSUCHTRG, 1, name);      	    return;     	})     	make_object_name(name, dep->target);      	do_build(dep->target, 0);     }  } /* Build_Target */   /* **++ **  ROUTINE:	find_dependency ** **  FUNCTIONAL DESCRIPTION:  **? **  	Locates a dependency rule for a particular object.  If one B **  doesn't exist, we use the suffixes list and build rules to try, **  and fake one based on the target suffix. ** **  RETURNS:	struct DEPEND * ** **  PROTOTYPE: **5 **  	find_dependency(struct OBJECT *xobj, int fakeit)  **5 **  xobj:   OBJECT structure, read only, by reference  **/ **  IMPLICIT INPUTS:	dependencies, dep_internal  **2 **  IMPLICIT OUTPUTS:	dep_internal may be updated. ** **  COMPLETION CODES:  **  	0:	no dependency found - **  non-0:  	pointer to found dependency rule  ** **  SIDE EFFECTS:   	None. ** **-- */A struct DEPEND *find_dependency(struct OBJECT *xobj, int fakeit) {        struct DEPEND *dep;      struct SFX *s;     struct RULE *r, *xr;     struct CMD *cmd;     struct OBJECT *obj, *obj2;     struct OBJREF *or;H     char fspec[MMK_S_FILE], *cp, ftype[MMK_S_SFX], basename[MMK_S_FILE];     int bnlen;   /** ** First search the real dependencies list */L     for (dep = dependencies.flink; dep != &dependencies; dep = dep->flink) {+     	if (xobj->type == dep->target->type) { :     	    if (strcmp(dep->target->name, xobj->name) == 0) {/     	    	if (xobj->type == MMK_K_OBJ_LIBMOD) { -     	    	    if (strcmp(xobj->libfile->name, 7     	    	    	    	dep->target->libfile->name) == 0) {      	    	    	return dep;     	    	    }      	    	} else return dep;
     	    }     	}     }    /*C **  If we're not supposed to fake one up, don't bother checking the @ **  internal dependency list, and don't try to fake one, either. */       if (!fakeit) return 0;   /*L ** Now search the internal list, which we built ourselves during description& ** parsing time (for library modules). */L     for (dep = dep_internal.flink; dep != &dep_internal; dep = dep->flink) {+     	if (xobj->type == dep->target->type) { :     	    if (strcmp(dep->target->name, xobj->name) == 0) {/     	    	if (xobj->type == MMK_K_OBJ_LIBMOD) { -     	    	    if (strcmp(xobj->libfile->name, 7     	    	    	    	dep->target->libfile->name) == 0) {      	    	    	return dep;     	    	    }      	    	} else return dep;
     	    }     	}     }    /*3 ** Nothing in our lists; see if we can fake one up.  */(     extract_filetype(ftype, xobj->name);  4     s = (ftype[0] == '\0') ? 0 : find_suffix(ftype);       if (s != 0) {   7     	for (s = s->flink; s != &suffixes; s = s->flink) {      	    int check_cms, slen;  /*5 **  Don't use the CMS suffixes if we're not using CMS  */!     	    slen = strlen(s->value); -     	    check_cms = s->value[slen-1] == '~'; -     	    if (check_cms && !use_cms) continue;   )     	    xr = find_rule(ftype, s->value);      	    if (xr != 0) { 0     	    	r = scan_rule_list(xr, xobj->name, 0);       	    	if (r != 0) { %     	    	    dep = mem_get_depend(); "     	    	    cmd = mem_get_cmd();;     	    	    dep->cmdqptr = cmd->flink = cmd->blink = cmd; %     	    	    obj = mem_get_object();       	    	    dep->target = obj;)     	    	    obj->type = MMK_K_OBJ_FILE; ,     	    	    strcpy(obj->name, xobj->name);&     	    	    strcpy(obj->sfx, ftype);6     	    	    if ((obj2 = Find_Object(obj)) == NULL) {"     	    	    	Insert_Object(obj);     	    	    } else {$     	    	    	mem_free_object(obj);     	    	    	obj = obj2;     	    	    }       	    	    dep->target = obj;%     	    	    obj = mem_get_object(); I     	    	    obj->type = check_cms ? MMK_K_OBJ_CMSFILE : MMK_K_OBJ_FILE; )     	    	    strcpy(obj->sfx, s->value); ;     	    	    if (r->srcpfxlen == 0 && r->trgpfxlen == 0) { :     	    	    	bnlen = extract_name(basename, xobj->name);     	    	    } else {>     	    	    	bnlen = extract_filename(basename, xobj->name);:     	    	    	memcpy(obj->name, r->srcpfx, r->srcpfxlen);     	    	    } >     	    	    memcpy(obj->name+r->srcpfxlen, basename, bnlen);=     	    	    strcpy(obj->name+(r->srcpfxlen+bnlen), r->src); 6     	    	    if ((obj2 = Find_Object(obj)) == NULL) {"     	    	    	Insert_Object(obj);     	    	    } else {$     	    	    	mem_free_object(obj);     	    	    	obj = obj2;     	    	    } $     	    	    or = mem_get_objref();     	    	    or->obj = obj;3     	    	    queue_insert(or, dep->sources.blink); 4     	    	    queue_insert(dep, dep_internal.blink);     	    	    return dep;      	    	} /* if (r) */     	    } /* if (r) */      	} /* for */     } /* if (s) */       if (default_rule) {      	dep = mem_get_depend();     	cmd = mem_get_cmd(); 2     	dep->cmdqptr = cmd->flink = cmd->blink = cmd;     	obj = mem_get_object();     	dep->target = xobj;     	return dep;     }        return (struct DEPEND *) 0;    } /* find_dependency */    /* **++ **  ROUTINE:	needs_updating  ** **  FUNCTIONAL DESCRIPTION:  **< **  	Determines if a target needs to be updated, and locatesA **  a build rule for the target if the dependency doesn't include + **  any commands for performing the update.  ** **  RETURNS:	int ** **  PROTOTYPE: **< **  	needs_updating(struct DEPEND *dep, struct RULE **rule); **4 **  dep:    DEPEND structure, read only, by refernce? **  rule:   pointer to RULE structure, write only, by reference  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  **  	0: no update needed **  	1: update needed  ** **  SIDE EFFECTS:   	None. ** **-- */A static int needs_updating(struct DEPEND *dep, struct RULE **rule, A     	    	    	    	struct OBJREF **srcref, struct QUE *chgque) {   !     struct OBJECT *tobj, *trgobj;      struct OBJREF *obj, *obj2;     struct RULE *r;      struct SFX *sfx;     TIME junktime;0     char srcnam[40], tmp[256], target_name[256];&     int doit, target_noexist, set_rdt;     unsigned int status;       if (do_log) { 0     	make_object_name(target_name, dep->target);/     	lib$signal(MMK__CHECKUPD, 1, target_name);      }    /*B ** /FORCE causes unconditional build.  /FROM_SOURCES does too, butF ** we use the have_rdt flag to indicate that a target has already been	 ** built.  */     doit = force;      if (from_sources) { !     	if (dep->target->have_rdt) {      	    return 0;
     	} else {      	    doit = 1;     	}     }    /*% ** Generic targets are always updated  */?     if (!doit) doit = (dep->target->type == MMK_K_OBJ_GENERIC);    /*@ ** Special handling for library modules; the file name we use is ** the library's filename. */J     tobj = (dep->target->type == MMK_K_OBJ_LIBMOD ? dep->target->libfile :     	    	dep->target);    /*C ** For non-generic targets, we get the revision date/time (RDT) for L ** the target.  If the RDT lookup fails, we assume we should build (probablyG ** because the target doesn't exist).  The get_rdt routine handles both  ** files and library modules.  **D ** If the file is locked, we don't try and build, to try and emulate ** some real weirdiness in MMS.  */     trgobj = dep->target;        if (!doit) {     	status = get_rdt(trgobj);0     	doit = !OK(status) && (status != RMS$_FLK);     	target_noexist = doit;      	if (do_log) {     	    if (doit) {;     	    	lib$signal(MMK__TRGLKUF, 1, target_name, status);      	    } else { @     	    	lib$signal(MMK__TRGRDT, 2, target_name, &trgobj->rdt);
     	    }     	}     } else target_noexist = 1;   /*H ** Now we recursively descend the list of dependencies, making sure thatH ** all the sources we depend upon are also up-to-date (unless /FORCE was ** specified). */L     for (obj = dep->sources.flink; obj != &dep->sources; obj = obj->flink) {     	char source_name[256];      	if (!force) {     	    int i;      	    struct OBJREF *o;  +     	    if (obj->obj->build_in_progress) {M     	    	char tmp[256];*     	    	make_object_name(tmp, obj->obj);+     	    	lib$signal(MMK__CIRCDEP, 1, tmp);      	    	return -2;
     	    }   /*J **  For /SKIP_INTERMEDIATES, non-existent sources inherit the RDT of their **  targets. */     	    set_rdt = 0; "     	    if (skip_intermediates) {D     	    	if (!target_noexist && obj->obj->type != MMK_K_OBJ_GENERIC4     	    	    	    	    && !OK(get_rdt(obj->obj))) {*     	    	    obj->obj->rdt = trgobj->rdt;B     	    	    obj->obj->have_rdt = 3; /* flag for later removal */     	    	    set_rdt = 1;     	    	}o
     	    }  #     	    i = do_build(obj->obj, 1);d     	    if (i == -2) return i; >     	    if ((i < 0) && (set_rdt || !OK(get_rdt(obj->obj)))) {D     	    	while (queue_remove(chgque->head, &o)) mem_free_objref(o);>     	    	lib$signal(MMK__CANTUPD, 2, strlen(obj->obj->name), $     	    	    	    	obj->obj->name);     	    	return -1;
     	    }     	}   /*L ** If we still haven't decided to do the update yet, we compare the source's ** RDT with the target's.. **@ ** No matter what we still look up the RDT's so we can build the6 ** changed-sources queue (to define MMS$CHANGED_LIST). */-     	make_object_name(source_name, obj->obj);A      	status = get_rdt(obj->obj);     	if (!OK(status)) {d?     	    if (noaction || obj->obj->type == MMK_K_OBJ_GENERIC) {a     	    	doit = 1;a=     	    } else if (!doit && obj->obj->libmodobj != trgobj) { :     	    	lib$signal(MMK__SRCERR, 1, source_name, status);
     	    }
     	} else {E     	    int xdoit;n     	    if (!doit && do_log) {tB     	    	lib$signal(MMK__SRCRDT, 2, source_name, &obj->obj->rdt);
     	    }      	    xdoit = target_noexist;     	    if (!xdoit) {;     	    	if (!(obj->obj->rdt.long1 == trgobj->rdt.long1 &&c<     	    	      obj->obj->rdt.long2 == trgobj->rdt.long2) &&T     	    	    OK(lib$sub_times(&obj->obj->rdt, &trgobj->rdt, &junktime))) xdoit = 1;
     	    }     	    if (xdoit) { E     	    	for (obj2 = chgque->head; obj2 != (struct OBJREF *) chgque;d2     	    	    	    	    	    obj2 = obj2->flink) {/     	    	    if (obj2->obj == obj->obj) break;M     	    	}r1     	    	if (obj2 == (struct OBJREF *) chgque) {-&     	    	    obj2 = mem_get_objref();#     	    	    obj2->obj = obj->obj; /     	    	    queue_insert(obj2, chgque->tail);	     	    	}K     	    	if (!doit) doit = 1;
     	    }     	} /*N **  If we faked the source's RDT due to /SKIP_INTERMEDIATES processing, removeH **  that setting now, so if the file is a non-intermediate in some other" **  dependency, it will get built. */D     	if (set_rdt && obj->obj->have_rdt == 3) obj->obj->have_rdt = 0;       	if (doit && do_log) {2     	    lib$signal(MMK__TRGNUPD, 1, target_name);     	}     }V   /*@ ** If we have to perform the update, but we haven't any commandsF ** to do it with, we search the build rules list, and return the first ** one we find.  */     if (!doit) return doit;s     *rule = (struct RULE *) 0;"     *srcref = (struct OBJREF *) 0;!     sfx = find_suffix(tobj->sfx);U     if (sfx) {     	struct OBJREF *o;E     	for (o = dep->sources.flink; o != &dep->sources; o = o->flink) {a0     	    if (o->obj->type == MMK_K_OBJ_LIBMOD) {=     	    	r = find_rule_with_prefixes(tobj, o->obj->libfile);ef     	    	if (r != 0 && r->cmdque.flink == &r->cmdque) r = find_rule(tobj->sfx, o->obj->libfile->sfx);5     	    } else if (o->obj->type == MMK_K_OBJ_FILE ||E5     	    	       o->obj->type == MMK_K_OBJ_CMSFILE) {N4     	    	r = find_rule_with_prefixes(tobj, o->obj);]     	    	if (r != 0 && r->cmdque.flink == &r->cmdque) r = find_rule(tobj->sfx, o->obj->sfx);p     	    } else continue;t     	    if (r) {	     	    	*srcref = o;     	    	*rule = r;     	    	break;
     	    }     	}     }s       return doit;   } /* needs_updating */ e /* **++ **  ROUTINE:	do_buildh ** **  FUNCTIONAL DESCRIPTION:c **. **  	Performs a build on the specified object. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **4 **  	do_build(struct OBJECT *obj, int intermediate); **5 **  obj:    OBJECT structure, read only, by referenceb* **  intermediate: int, read only, by value ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.e ** **  COMPLETION CODES:	None.J ** **  SIDE EFFECTS:   	None. ** **-- */; static int do_build(struct OBJECT *obj, int intermediate) {n       struct DEPEND *dep;r     struct RULE *rule;     struct QUE chgque;     struct OBJREF *or, *srcref;(     int doit, really_doit;  "     dep = find_dependency(obj, 1);.     if (dep == (struct DEPEND *) 0) return -1;     really_doit = 0;   /*, **  Loop to handle double-colon dependencies */     while (dep != 0) {  (     	dep->target->build_in_progress = 1; /*9 ** Even if /FORCE is specified, we call on needs_updating & ** to look up any rules we might need. */)     	chgque.head = chgque.tail = &chgque; 9     	doit = needs_updating(dep, &rule, &srcref, &chgque);i0     	if ((doit > 0) || ((doit == 0) && force)) {     	    really_doit = 1;t     	    if (check_status) {     	    	did_an_update = 1;     	    } else {s5     	    	perform_update(dep, rule, srcref, &chgque); 
     	    }     	} else if (doit == -2) {      	    char tmp[256]; ,     	    make_object_name(tmp, dep->target);,     	    lib$signal(MMK__CONNEXION, 1, tmp);     	}@     	while (queue_remove(chgque.head, &or)) mem_free_objref(or);(     	dep->target->build_in_progress = 0;     	if (doit == -2) return -2;      	dep = dep->dc_flink;e     }p       return really_doit;    } /* do_build */   /* **++ **  ROUTINE:	perform_update  ** **  FUNCTIONAL DESCRIPTION:o **< **  	Executes the commands to perform an update on a target. **( **  RETURNS:	void  (errors are signaled) ** **  PROTOTYPE: **; **  	perform_update(struct DEPEND *dep, struct RULE *rule);c **5 **  dep:    DEPEND structure, read only, by referencet3 **  rule:   RULE structure, read only, by reference_ ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.n ** **  COMPLETION CODES:	None.s ** **  SIDE EFFECTS:   	None. ** **-- */B static void perform_update(struct DEPEND *dep, struct RULE *xrule,?     	    	    	    struct OBJREF *srcref, struct QUE *chgque) {d       struct RULE *rule;     struct CMD *cmd;     char target_name[256];     unsigned int status;     int did_one;   /*5 ** If no commands and no build rule, what can we do??* */  /     rule = (xrule == 0) ? default_rule : xrule;R  /     make_object_name(target_name, dep->target);iE     if ((dep->cmdqptr == 0 || dep->cmdqptr->flink == dep->cmdqptr) &&PB     	    ((rule == 0) || (rule->cmdque.flink == &rule->cmdque))) { /*B **  Allow generic targets to have null action lists -- just assumeF **  they have been updated.  But don't set the "did_an_update" flag --< **  let the updates of the generic's sources determine that. */2     	if (dep->target->type == MMK_K_OBJ_GENERIC) {#     	    dep->target->have_rdt = 1;()     	    sys$gettim(&(dep->target->rdt));R     	    return;     	}/     	lib$signal(MMK__NOACTION, 1, target_name);_     	return;     }+  9     if (do_log) lib$signal(MMK__PERFUPD, 1, target_name);        did_one = 0;   /*= ** Close any libraries that were opened by the GET_RDT moduleh */     lbr_flush();   /*F ** Create the subprocess if it doesn't exist, and pass it the commands/ ** from the .FIRST directive, if there was one.  */     if (spctx == 0) {o6     	status = sp_open(&spctx, &ini_dsc1, echo_ast, 0);)     	if (!OK(status)) lib$signal(status);E)     	status = sp_send(&spctx, &ini_dsc2); )     	if (!OK(status)) lib$signal(status);r)     	status = sp_send(&spctx, &ini_dsc3); )     	if (!OK(status)) lib$signal(status);c)     	status = sp_send(&spctx, &ini_dsc4);{)     	if (!OK(status)) lib$signal(status); E     	for (cmd = do_first.flink; cmd != &do_first; cmd = cmd->flink) { 3     	    execute_command(&spctx, cmd, target_name);c     	}     }  /*O ** Create the local symbols for this dependency (MMS$SOURCE, MMS$TARGET, etc.),&K ** then pass the command strings (with symbols resolved) to the subprocess.j */.     Create_Local_Symbols(dep, srcref, chgque); /*E **  Check to see if there are any forced setup commands from the rule, **  (or its parent)f */     did_one = 0;     if (rule != 0) {M     	for (cmd = rule->cmdque.flink; cmd != &rule->cmdque; cmd = cmd->flink) {r:     	    if (!(cmd->flags & CMD_M_FORCED_FIRST)) continue;     	    did_one = 1;e3     	    execute_command(&spctx, cmd, target_name);*     	}     }_  5     if (!did_one && rule != 0 && rule->parent != 0) {c]     	for (cmd = rule->parent->cmdque.flink; cmd != &rule->parent->cmdque; cmd = cmd->flink) {s:     	    if (!(cmd->flags & CMD_M_FORCED_FIRST)) continue;3     	    execute_command(&spctx, cmd, target_name);      	}     }      did_one = 0;   /*- **  Execute the dependency's commands, if anyj */     if (dep->cmdqptr != 0) {M     	for (cmd = dep->cmdqptr->flink; cmd != dep->cmdqptr; cmd = cmd->flink) {L     	    did_one = 1;n3     	    execute_command(&spctx, cmd, target_name);0     	}     }    /*M ** If we haven't executed a command yet, but there is a build rule available,. ** execute those commands. */      if (!did_one && rule != 0) {M     	for (cmd = rule->cmdque.flink; cmd != &rule->cmdque; cmd = cmd->flink) {LK     	    if (cmd->flags & (CMD_M_FORCED_FIRST|CMD_M_FORCED_LAST)) continue;O3     	    execute_command(&spctx, cmd, target_name);K     	}     }m   /*G **  Check to see if there are any forced cleanup commands from the rulet **  (or its parent)d */     did_one = 0;     if (rule != 0) {M     	for (cmd = rule->cmdque.flink; cmd != &rule->cmdque; cmd = cmd->flink) {r9     	    if (!(cmd->flags & CMD_M_FORCED_LAST)) continue;o     	    did_one = 1;I3     	    execute_command(&spctx, cmd, target_name);e     	}     }   5     if (!did_one && rule != 0 && rule->parent != 0) { ]     	for (cmd = rule->parent->cmdque.flink; cmd != &rule->parent->cmdque; cmd = cmd->flink) {*9     	    if (!(cmd->flags & CMD_M_FORCED_LAST)) continue;e3     	    execute_command(&spctx, cmd, target_name);r     	}     }e /*J ** Clean up after ourselves, and flag the fact that we've actually updatedI ** something.  Also flush the revision date/time status, since the targetm ** may actually have changed.p */     Clear_Local_Symbols();     did_an_update = 1;   /*C **  Used to do this only if NOACTION or FROM_SOURCES was specified,t< **  but it may make sense to do it the way MMS does instead. **G **  Let's check to see if the target object was actually updated first.  */>     if (!noaction && dep->target->type != MMK_K_OBJ_GENERIC) {     	TIME old_rdt;:     	memcpy(&old_rdt, &dep->target->rdt, sizeof(old_rdt));     	dep->target->have_rdt = 0;t     	get_rdt(dep->target);5     	if ((old_rdt.long1 == dep->target->rdt.long1) && 7     	    	 (old_rdt.long2 == dep->target->rdt.long2)) {f3     	    lib$signal(MMK__ACTNOUPD, 1, target_name);s     	}     }      dep->target->have_rdt = 1;$     sys$gettim(&(dep->target->rdt));   } /* perform_update */   /* **++ **  ROUTINE:	close_subprocess  ** **  FUNCTIONAL DESCRIPTION:= **8 **  	If we have created a subprocess, this closes it up. ** **  RETURNS:	voidp ** **  PROTOTYPE: ** **  	close_subprocess(void)  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.d ** **  SIDE EFFECTS:   	None. ** **-- */ void close_subprocess() {d       struct CMD *cmd;!     struct dsc$descriptor tmpdsc;b     unsigned int status;     char *tmp;     int tmplen;b   /*D ** If we actually created a subprocess, close it down by sending outA ** the commands from the .LAST directive (if there was one), thend' ** use sp_close to have it logged out. I */       if (spctx) {     	lbr_flush(); C     	for (cmd = do_last.flink; cmd != &do_last; cmd = cmd->flink) { G     	    Resolve_Symbols(cmd->cmd, strlen(cmd->cmd), &tmp, &tmplen, 0);eD     	    if (verify && (noaction || !(cmd->flags & CMD_M_NOECHO))) {*     	    	INIT_SDESC(tmpdsc, tmplen, tmp);     	    	put_command(&tmpdsc); 
     	    }     	    if (noaction) {     	    	status = SS$_NORMAL;     	    } else {a:     	    	status = send_cmd_and_wait(&spctx, tmp, tmplen);
     	    }     	    free(tmp);o      	    if (!OK(status)) break;     	}     	if (!noaction) {l     	    sp_close(&spctx);     	}     }y     return;> } /* close_subprocess */   /* **++ **  ROUTINE:	echo_ast- ** **  FUNCTIONAL DESCRIPTION:  **E **  	Write-attention AST routine for the subprocess's output mailbox.bC **  Keeps reading the output and echoing it until it gets the magicj **  end-of-command text. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **, **  	echo_ast(void)  (called from AST level) ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  **1 **  COMPLETION CODES:	SS$_NORMAL always returned.} ** **  SIDE EFFECTS:   	None. ** **-- */  static unsigned int echo_ast() {  !     struct dsc$descriptor rcvstr;c%     $DESCRIPTOR(end_marker,EOM_TEXT);        INIT_DYNDESC(rcvstr);m0     while (OK(sp_receive(&spctx, &rcvstr, 0))) {)     	if (rcvstr.dsc$w_length > EOM_LEN &&e=     	    	strncmp(rcvstr.dsc$a_pointer, EOM_TEXT, 14) == 0) {  /*M ** Fetch the command's exit status value from the end-of-command-marker text.r */1     	    lib$cvt_dtb(rcvstr.dsc$w_length-EOM_LEN, <     	    	    rcvstr.dsc$a_pointer+EOM_LEN, &static_status);     	    str$free1_dx(&rcvstr);      	    command_complete = 1;     	    sys$wake(0,0);*     	    break;t     	}     	put_output(&rcvstr);      	str$free1_dx(&rcvstr);E     }c     return SS$_NORMAL; } /* echo_ast */ n /* **++ **  ROUTINE:	send_cmd_and_wait ** **  FUNCTIONAL DESCRIPTION:N **: **  	Issues a command to the subprocess and waits until it **  completes. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **C **  	send_cmd_and_wait(unsigned int *spctxp, char *cmd, int cmdlen)  **B **  spctxp: 	context, longword (unsigned), read only, by reference2 **  cmd:    	ASCIZ_string, read only, by referenceD **  cmdlen: 	signed_longword, longword (signed), read only, by value ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.n **M **  COMPLETION CODES:	Any status from the command executed in the subprocess.n ** **  SIDE EFFECTS:   	None. ** **-- */T static unsigned int send_cmd_and_wait(unsigned int *spctxp, char *cmd, int cmdlen) {  %     struct dsc$descriptor sdsc, hdsc;      char *cp, ch, hexbuf[32];h      int i, inquotes, last_quote;+     static $DESCRIPTOR(eom_cmd1, EOM_CMD1);s+     static $DESCRIPTOR(eom_cmd2, EOM_CMD2); +     static $DESCRIPTOR(eom_cmd3, EOM_CMD3); (     static $DESCRIPTOR(hexfao, "%X!XL");1     static $DESCRIPTOR(mms$status, "MMS$STATUS");d4     static unsigned int gsym = LIB$K_CLI_GLOBAL_SYM;       static_status = SS$_NORMAL;o     command_complete = 0; /     set_ctrlt_ast(sp_show_subprocess, *spctxp);e  
     cp = cmd;=     while (cmdlen > 240) {     	inquotes = 0;      	for (i = 0; i < 240; i++) {     	    if (cp[i] == '"') {     	    	inquotes = !inquotes;      	    	last_quote = i;l
     	    }     	}%     	i = inquotes ? last_quote : 240;e     	ch = *(cp+i);     	*(cp+i) = '-';r     	INIT_SDESC(sdsc, i+1, cp);d     	sp_send(spctxp, &sdsc);     	*(cp+i) = ch;
     	cp += i;d     	cmdlen -= i;e     } !     INIT_SDESC(sdsc, cmdlen, cp);/     sp_send(spctxp, &sdsc); G     sp_send(spctxp, &eom_cmd1);  /* end-of-command marker command #1 */sG     sp_send(spctxp, &eom_cmd2);  /* end-of-command marker command #2 */)G     sp_send(spctxp, &eom_cmd3);  /* end-of-command marker command #3 */m       do {     	sys$hiber();       } while (!command_complete);       clear_ctrlt_ast();   /*A **  Set the symbol MMS$STATUS to match the returned status of thew **  command  */-     INIT_SDESC(hdsc, sizeof(hexbuf), hexbuf); I     if (OK(sys$fao(&hexfao, &hdsc.dsc$w_length, &hdsc, static_status))) {*/     	lib$set_symbol(&mms$status, &hdsc, &gsym);n     }!       return static_status;l   } /* send_cmd_and_wait */[ ] /* **++ **  ROUTINE:	execute_command ** **  FUNCTIONAL DESCRIPTION:  **3 **  	Handles execution of a command stored in a CMDr **  structure. ** **  RETURNS:	voidt ** **  PROTOTYPE: **; **  	execute_command(unsigned int *spctxP, struct CMD *cmd)  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.. ** **  SIDE EFFECTS:   	None. ** **-- */X static void execute_command (unsigned int *spctxP, struct CMD *cmd, char *target_name) {       int is_MMS_command, tmplen;r     unsigned int status, s;      char *tmp;!     struct dsc$descriptor tmpdsc;o  S     is_MMS_command = Resolve_Symbols(cmd->cmd, strlen(cmd->cmd), &tmp, &tmplen, 0);o?     if (verify && (noaction || !(cmd->flags & CMD_M_NOECHO))) { %     	INIT_SDESC(tmpdsc, tmplen, tmp);      	put_command(&tmpdsc);     }o&     if (!noaction || is_MMS_command) {5     	status = send_cmd_and_wait(&spctx, tmp, tmplen);i7     	if (!OK(status) && !(cmd->flags & CMD_M_IGNERR)) {	*     	    s = $VMS_STATUS_SEVERITY(status);A     	    if (ignore == 0 || (ignore == 2 && s == STS$K_SEVERE) ||oG     	    	    (ignore == 1 && (s == STS$K_SEVERE || s == STS$K_ERROR))) :     	    	lib$signal(MMK__ERRUPD, 2, status, target_name);     	}     }d     free(tmp);   } /* execute_command */.