 /* **++ **  FACILITY:	MMK  **" **  ABSTRACT:	MadGoat Make Utility ** **  MODULE DESCRIPTION:  **& **  	This is the main routine for MMK. ** **  AUTHOR: 	    M. Madison M **  	    	    COPYRIGHT  1992-1997,  MADGOAT SOFTWARE.  ALL RIGHTS RESERVED.  ** **  CREATION DATE:  20-AUG-1992  ** **  MODIFICATION HISTORY:  **1 **  	20-AUG-1992 V1.0    Madison 	Initial coding. 2 **  	27-AUG-1992 V1.1    Madison 	Spruce up a bit.E **  	29-SEP-1992 V1.2    Madison 	Add /FORCE, /FROM, /IDENT, /OUTPUT. < **  	12-OCT-1992 V1.2-1  Madison 	Fix some parsing problems.E **  	23-DEC-1992 V1.2-2  Madison 	Change MMS$xxx file refs to MMK_xxx = **  	12-JAN-1993 V1.2-3  Madison 	Fix a couple of minor bugs. D **  	08-MAR-1993 V1.2-4  Madison 	Fix library module reference bugs.G **  	02-APR-1993 V1.3    Madison 	Add support for "-" on command lines. 8 **  	23-APR-1993 V1.3-1  Madison 	Fix suffix processing.> **  	29-APR-1993 V1.3-2  Madison 	Fix dependency rule parsing.D **  	30-APR-1993 V1.4    Madison 	Default rules are now compiled-in.G **  	04-JUN-1993 V1.5    Madison 	Add support for some more directives. 7 **  	07-JUN-1993 V1.6    Madison 	Add MMS$CHANGED_LIST. @ **	21-AUG-1993 V1.7    Madison 	Main source fix, build-rule fix.= **  	28-SEP-1993 V2.0    Madison 	Fix up for general release. > **  	24-SEP-1993 V2.0-1  Madison 	Fixed /FROM_SOURCES problem.H **  	27-SEP-1993 V2.0-2  Madison 	Fixed a couple more MMS discrepancies.I **  	27-SEP-1993 V2.0-3  Madison 	Changed file_get_rdt to do shared open. N **  	27-SEP-1993 V2.0-4  Madison 	Retracted the -2 and -3 shared-open changes.G **  	17-OCT-1993 V2.1    Madison 	Allow substitution rules in var refs. ? **  	17-OCT-1993 V2.2    Madison 	Delete intermediate libfiles. 5 **  	20-OCT-1993 V2.3    Madison 	Add CTRL/T support. F **  	22-OCT-1993 V2.3-1  Madison 	Fix lines w/just blanks, deletion of@ **  	    	    	    	    	    intermediates for multiple libmods.- **  	28-OCT-1993 V2.3-2  Madison 	More fixes. J **  	22-NOV-1993 V2.3-3  Madison 	Fix parsing of target from command line.Q **  	01-DEC-1993 V2.3-4  Madison 	Fix /IGNORE getting ignored for built-in rules. G **  	02-DEC-1993 V2.3-5  Madison 	Allow symbol refs inside symbol refs. 3 **  	09-DEC-1993 V2.3-6  Madison 	extract_name fix. F **  	12-DEC-1993 V2.4    Madison 	Add MMS, MMSQUAL macros, support for? **  	    	    	    	    	    multiple dependencies for targets. > **  	02-MAR-1994 V2.4-1  Madison 	Fix non-resolvable specials.I **  	03-MAR-1994 V2.4-2  Madison 	Fix description parsing symbol problem. D **  	04-APR-1994 V2.4-3  Madison 	Fixed a couple of symbol problems.@ **  	04-APR-1994 V2.4-4  Madison 	Another symbol problem.  Argh!J **  	08-APR-1994 V2.4-5  Madison 	Fix space-sep lists on lhs of dep rules.I **  	11-APR-1994 V2.4-6  Madison 	Make default rules more MMS-compatible. 4 **  	14-APR-1994 V2.4-7  Madison 	More random fixes.G **  	06-MAY-1994 V2.4-8  Madison 	Output @-prefixed commands on /NOACT. I **  	14-JUN-1994 V2.5    Madison 	Support for multiple targets on command ; **  	    	    	    	    	line, courtesy of Richard Levitte. M **  	29-JUN-1994 V2.6    Madison 	TEX, library module, and source list fixes. 2 **  	01-JUL-1994 V3.0    Madison 	Support for CMS.8 **  	06-JUL-1994 V3.0-1  Madison 	A couple of bug fixes.M **  	12-JUL-1994 V3.1    Madison 	Add :: support, circular-dependency checks. H **  	14-JUL-1994 V3.2    Madison 	Add prefix support in inference rules.F **  	17-AUG-1994 V3.2-1  Madison 	Upcase sfx list; fix MMS definition.K **  	22-AUG-1994 V3.2-2  Madison 	Fix LIBMOD bypass in dependecny creation. E **  	18-OCT-1994 V3.2-3  Madison 	Fix PARSE_DESCRIP error-signal bug. J **  	02-DEC-1994 V3.3    Madison 	Add /GENERATION qualifier for specifyingM **                                         default CMS generation on fetches. N **  	10-JAN-1995 V3.3-1  Madison 	Prefix commands with $ if /OUTPUT specified.R **      13-JAN-1995 V3.3-1  Madison 	Add /NOACTION to $(MMS) symbol when noaction.C **  	16-MAR-1995 V3.3-2  Madison 	Turn off verify of CMS libraries. 8 **  	30-APR-1995 V3.3-3  Madison 	Fix lib mod prefixing.Q **  	07-JUN-1995 V3.3-4  Madison 	Use default CMS generation in CMS RDT compares. B **  	19-JUN-1995 V3.3-5  Madison 	Fix for Fill_In_Missing_Sources.L **  	21-JUN-1995 V3.4    Madison 	Support /MACRO=fspec, /SKIP_INTERMEDIATES,6 **  	    	    	    	    	    /OVERRIDE, /CHECK_STATUS.G **  	27-JUN-1995 V3.4-1  Madison 	Fix CMS fetches of description files. B **  	12-JUL-1995 V3.4-2  Madison 	Clean up after RMS search lists.P **  	17-JUL-1995 V3.4-3  Madison 	Wasn't setting have_rdt flag when getting RDT.0 **  	21-JUL-1995 V3.4-4  Madison 	Fix for /SKIP.E **  	03-OCT-1995 V3.4-5  Madison 	Handle parsing of target file specs > **  	    	    	    	    	with names longer than 32 characters.N **  	05-OCT-1995 V3.4-6  Madison 	Fixed error paths causing ACCVIOs in SP_MGR.J **  	09-OCT-1995 V3.4-7  Madison 	Another case of incorrect use of free().D **  	06-NOV-1995 V3.4-8  Madison 	Fix library problem, rule problem.2 **  	21-FEB-1996 V3.4-9  Madison 	Fix in READDESC.D **  	29-MAY-1996 V3.4-10 Madison 	Special hack for macros with dots.= **  	22-AUG-1996 V3.5    Madison 	Add /CMS_LIBRARY qualifier. ; **  	22-DEC-1996 X3.6    Madison 	Add FIRST and LAST rules. < **  	15-FEB-1997 V3.6    Madison 	Define MMS$CMS_GEN always.B **  	23-MAR-1997 V3.6-1  Madison 	Set MMS$STATUS to action status.O **  	20-JUN-1997 V3.6-2  Madison 	Make null-object parsing compatible with MMS.  **-- */ #define MMK_VERSION 	"V3.6-2" V #define MMK_COPYRIGHT	"Copyright  1992-1997, MadGoat Software.  All Rights Reserved."  
 #ifdef __DECC  #pragma module MMK MMK_VERSION #else  #ifndef __GNUC__ #module MMK MMK_VERSION  #endif #endif  
 #ifdef __DECC  #pragma extern_model save % #pragma extern_model common_block shr  #endif(     char $$$Copyright[] = MMK_COPYRIGHT;
 #ifdef __DECC  #pragma extern_model restore #endif   #include "mmk.h" #pragma nostandard #include "mmk_msg.h" #pragma standard #include "clidefs.h" #ifdef __GNUC__  #include <vms/libclidef.h> #else  #include <libclidef.h> #endif /* ** Forward declarations  */     unsigned int main(void);'     static void add_to_mmsqual(char *); $     unsigned int put_output(void *);6     unsigned int put_command(struct dsc$descriptor *);;     static unsigned int cli_get_value(char *, char *, int); ,     static unsigned int cli_present(char *);"     static void Dump_It_All(void);2     static void dump_dependency(struct DEPEND *d);   /*& ** Globals used throughout the program */   #pragma nostandard+     GLOBAL struct SYMTABLE  global_symbols; *     GLOBAL struct SYMTABLE  local_symbols;,     GLOBAL struct SYMTABLE  cmdline_symbols;,     GLOBAL struct SYMTABLE  builtin_symbols;"     GLOBAL struct RULE      rules;-     GLOBAL struct RULE	    *default_rule = 0; )     GLOBAL struct DEPEND    dependencies; )     GLOBAL struct DEPEND    dep_internal; )     GLOBAL struct DEPEND    dep_deferred; %     GLOBAL struct SFX       suffixes; %     GLOBAL struct CMD       do_first; $     GLOBAL struct CMD       do_last;K     GLOBAL int  	    verify, do_log, did_an_update, noaction, check_status; Q     GLOBAL int	    	    from_sources, force, ignore, use_cms, skip_intermediates; J     GLOBAL int	    	    override_silent, override_ignore, symbol_override;(     GLOBAL unsigned int	    exit_status;&     GLOBAL char	    	    cms$lib[256];5     GLOBAL char	    	    cms_default_generation[256];  #pragma standard   /* ** Local statics */  %     static unsigned int out_unit = 0;      static char mmsqual[4096];   /* ** External references */ extern int mmk_cld(); ( #define MMK_CLD ((unsigned int) mmk_cld)  L     extern void Read_Description(char *, char *, int); /* module READDESC */P     extern void Build_Target(char *);                  /* module BUILD_TARGET */Q     extern void Define_Symbol(SYMTYPE, char *, char *, int); /* module SYMBOLS */ H     extern int logical_present(char *);                /* module MISC */P     extern void close_subprocess(void);                /* module BUILD_TARGET */D     extern unsigned int file_create(char *, unsigned int *, char *);8     	    	    	    	    	    	       /* module FILEIO */>     extern unsigned int file_write(unsigned int, char *, int);8     	    	    	    	    	    	       /* module FILEIO */Q     extern unsigned int file_open(char *, unsigned int *, char *, char *, int *); D     extern unsigned int file_read(unsigned int, char *, int, int *);1     extern unsigned int file_close(unsigned int); N     extern void Map_Default_Rules(void);    	       /* module DEFAULT_RULES */H     extern int get_logical(char *, char *, int);       /* module MISC */K     extern int make_object_name(char *, struct OBJECT *); /* module MISC */    /* **++ **  ROUTINE:	main  ** **  FUNCTIONAL DESCRIPTION:  **> **  	Main program.  Fetches the command from the command line,B **  uses CLI$ routines to parse it, then starts the build process. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **	 **  	main  **; **  IMPLICIT INPUTS:	See global definitions at module head.  **< **  IMPLICIT OUTPUTS:	See global definitions at module head. ** **  COMPLETION CODES:  **; **  	SS$_NORMAL, MMK__ALLOK : normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int main() {        DESCRIP cmdstr; 1     char target[256], descripfile[256], tmp[256]; !     $DESCRIPTOR(cmdname, "MMK ");      unsigned int status;!     int did1macro, doing_file, i;    /* ** Initialize the globals  *//     for (i = 0; i < MMK_K_SYMTABLE_SIZE; i++) { +     	INIT_QUEUE(global_symbols.symlist[i]); *     	INIT_QUEUE(local_symbols.symlist[i]);,     	INIT_QUEUE(cmdline_symbols.symlist[i]);,     	INIT_QUEUE(builtin_symbols.symlist[i]);     }      INIT_QUEUE(rules);     INIT_QUEUE(dependencies);      INIT_QUEUE(dep_internal);      INIT_QUEUE(dep_deferred);      INIT_QUEUE(suffixes);      INIT_QUEUE(do_first);      INIT_QUEUE(do_last);     exit_status = SS$_NORMAL; E     ignore = override_silent = override_ignore = symbol_override = 0;      skip_intermediates = 0;    /*! ** Fetch and parse command string  */     INIT_DYNDESC(cmdstr); &     status = lib$get_foreign(&cmdstr);"     str$prefix(&cmdstr, &cmdname);K     status = cli$dcl_parse(&cmdstr, MMK_CLD, lib$get_input, lib$get_input); 7     if (!OK(status)) return (status | STS$M_INHIB_MSG);    /* ** Check for /IDENT  */8     if (cli_present("IDENTIFICATION") == CLI$_PRESENT) {N     	lib$signal(MMK__IDENT, 1, MMK_VERSION, MMK__COPYRIGHT, 1, MMK_COPYRIGHT);     	return SS$_NORMAL;      }    /*, ** Get the command parameters and qualifiers */3     descripfile[0] = target[0] = mmsqual[0] = '\0'; J     (void) cli_get_value("DESCRIPTION", descripfile, sizeof(descripfile));     if (descripfile[0]) { %     	add_to_mmsqual("/DESCRIPTION="); !     	add_to_mmsqual(descripfile);      } #     status = cli_present("VERIFY"); &     verify = (status != CLI$_NEGATED);-     if (!verify) add_to_mmsqual("/NOVERIFY"); .     override_silent = (status != CLI$_ABSENT);=     if (override_silent && verify) add_to_mmsqual("/VERIFY"); 2     do_log = (cli_present("LOG") == CLI$_PRESENT);'     if (do_log) add_to_mmsqual("/LOG"); @     symbol_override = (cli_present("OVERRIDE") == CLI$_PRESENT);5     if (symbol_override) add_to_mmsqual("/OVERRIDE"); M     skip_intermediates = (cli_present("SKIP_INTERMEDIATES") == CLI$_PRESENT); B     if (skip_intermediates) add_to_mmsqual("/SKIP_INTERMEDIATES");5     noaction = cli_present("ACTION") == CLI$_NEGATED; .     if (noaction) add_to_mmsqual("/NOACTION");1     force = cli_present("FORCE") == CLI$_PRESENT; (     if (force) add_to_mmsqual("/FORCE");?     from_sources = cli_present("FROM_SOURCES") == CLI$_PRESENT;      if (from_sources) { %     	add_to_mmsqual("/FROM_SOURCES");      	skip_intermediates = 0;     } A     check_status = (cli_present("CHECK_STATUS") == CLI$_PRESENT);      if (check_status) { %     	add_to_mmsqual("/CHECK_STATUS");      	noaction = 1;     }   E     if (OK(cli_get_value("CMS_LIBRARY", cms$lib, sizeof(cms$lib)))) { %     	add_to_mmsqual("/CMS_LIBRARY=");      	add_to_mmsqual(cms$lib);      } else {6     	get_logical("CMS$LIB", cms$lib, sizeof(cms$lib));     }   1     use_cms = cli_present("CMS") == CLI$_PRESENT;      if (use_cms) {     	add_to_mmsqual("/CMS");)     	if (cms$lib[0] == '\0') use_cms = 0;      }      if (use_cms) {A     	if (!OK(cli_get_value("GENERATION", cms_default_generation,  6     	    	    	    sizeof(cms_default_generation)))) {.     	    strcpy(cms_default_generation, "1+");     	}(     	status = cli_present("GENERATION");"     	if (status == CLI$_PRESENT) {(     	    add_to_mmsqual("/GENERATION=");0     	    add_to_mmsqual(cms_default_generation);     	}     } #     status = cli_present("IGNORE"); !     if (status == CLI$_PRESENT) {      	override_ignore = 1; 9     	if (OK(cli_get_value("IGNORE", tmp, sizeof(tmp)))) { :     	    ignore = *tmp == 'F' ? 3 : (*tmp == 'E' ? 2 : 1);$     	    add_to_mmsqual("/IGNORE=");     	    add_to_mmsqual(tmp); 
     	} else {      	    ignore = 3;#     	    add_to_mmsqual("/IGNORE");      	}(     } else if (status == CLI$_NEGATED) {     	override_ignore = 1; !     	add_to_mmsqual("/NOIGNORE");      } 0     if (cli_present("OUTPUT") == CLI$_PRESENT) {/     	cli_get_value("OUTPUT", tmp, sizeof(tmp)); 2     	status = file_create(tmp, &out_unit, ".LOG");     	if (!OK(status)) { 2     	    lib$signal(MMK__OPENOUT, 1, tmp, status);/     	    return (MMK__OPENOUT|STS$M_INHIB_MSG);      	}+     	add_to_mmsqual("/OUTPUT=SYS$OUTPUT:");      }    /*% ** Command-line definition of symbols  */I     if (cli_present("MACRO") == CLI$_PRESENT) add_to_mmsqual("/MACRO=(");      did1macro = 0;     doing_file = 0;      while (1) {      	char *ep, *vp, *sp;     	char macro_file[256];     	unsigned int munit;     	int slew, len;        	if (doing_file) {;     	    status = file_read(munit, tmp, sizeof(tmp), &len);      	    if (!OK(status)) {      	    	file_close(munit);     	    	doing_file = 0;      	    	continue; 
     	    }     	    slew += 1;      	    tmp[len] = '\0'; 
     	} else { ;     	    status = cli_get_value("MACRO", tmp, sizeof(tmp));       	    if (!OK(status)) break;     	}   /*C **  Trim leading blanks from macro name.  If it's a null line, just  **  ignore it. */(     	for (sp = tmp; isspace(*sp); sp++);     	if (*sp == '\0') continue;    /*J **  Locate the "=".  If there is none present and we're doing command-line9 **  macros, check to see if this is a file specification.  */     	ep = strchr(sp,'='); "     	if (!doing_file && ep == 0) {J     	    status = file_open(sp, &munit, "SYS$DISK:[].MMS", macro_file, 0);     	    if (OK(status)) {     	    	doing_file = 1; -     	    	if (did1macro) add_to_mmsqual(",");      	    	add_to_mmsqual(sp);      	    	did1macro = 1;     	    	slew = 0;      	    	continue; 
     	    } /*J **  For compatibility with previous versions of MMK, we allow ":" in place- **  of "=" (but only in command-line macros).  */     	    ep = strchr(sp, ':');     	}       	if (ep != 0) {      	    vp = ep + 1; #     	    while (isspace(*vp)) vp++; '     	    while (isspace(*(ep-1))) ep--;      	    *ep = 0; >     	    Define_Symbol(MMK_K_SYM_CMDLINE, sp, vp, strlen(vp));     	    if (!doing_file) { -     	    	if (did1macro) add_to_mmsqual(",");      	    	add_to_mmsqual(tmp);      	    	add_to_mmsqual("=\"");     	    	add_to_mmsqual(vp);      	    	add_to_mmsqual("\"");      	    	did1macro = 1;
     	    }     	} else if (!doing_file) { /*M **  For compatibility with previous versions, we allow MACRO to be equivalent 2 **  to MACRO=1 (but only for command-line macros). */7     	    Define_Symbol(MMK_K_SYM_CMDLINE, tmp, "1", 1); ,     	    if (did1macro) add_to_mmsqual(",");     	    add_to_mmsqual(tmp); 
     	} else { <     	    lib$signal(MMK__MACFILSYNTAX, 2, slew, macro_file);     	}       }   B     if (cli_present("MACRO") == CLI$_PRESENT) add_to_mmsqual(")");     did_an_update = 0;   /*" ** Rules processing is as follows: **= **  1.  The default rules are mapped in, having been compiled & **  	by the description file compiler. **9 **  2.	Unless /NOLOCAL_RULES is specified, the rules file+8 **  	located through the logical name MMK_LOCAL_RULES is> **  	processed.  Use this logical to point to files containing **  	system-wide build rules.  **; **  3.	If the /RULES=(file[,...]) qualifier is present, theT9 **  	specified rules files are read in.  If it is absent,G9 **  	a personal rules file is located by the logical name26 **  	MMK_PERSONAL_RULES.  If /NORULES is specified, no3 **  	per-build or personal rules files are read in.  */  '     status = cli_present("RULES_FILE"); !     if (status != CLI$_NEGATED) {	     	Map_Default_Rules(); @     	if (!OK(exit_status)) return exit_status | STS$M_INHIB_MSG;     }*  5     if (cli_present("LOCAL_RULES") != CLI$_NEGATED) {s.     	if (logical_present("MMK_LOCAL_RULES")) {C     	    Read_Description("MMK_LOCAL_RULES", "SYS$DISK:[].MMS", 1);r     	},     } else add_to_mmsqual("/NOLOCAL_RULES");  =     if (status == CLI$_PRESENT || status == CLI$_DEFAULTED) {n     	did1macro = 0; A     	if (status == CLI$_PRESENT) add_to_mmsqual("/RULES_FILE=(");o@     	while (OK(cli_get_value("RULES_FILE", tmp, sizeof(tmp)))) {5     	    Read_Description(tmp, "SYS$DISK:[].MMS", 1);d&     	    if (status == CLI$_PRESENT) {-     	    	if (did1macro) add_to_mmsqual(",");      	    	add_to_mmsqual(tmp);     	    	did1macro = 1;
     	    }     	}5     	if (status == CLI$_PRESENT) add_to_mmsqual(")");2(     } else if (status != CLI$_NEGATED) {1     	if (logical_present("MMK_PERSONAL_RULES")) {ME     	    Read_Description("MMK_PERSONAL_RULES","SYS$DISK:[].MMS", 1);-     	}+     } else add_to_mmsqual("/NORULES_FILE");e   /*F **  We've parsed all the qualifiers, so create the MMSQUALIFIERS macro **  (and MMS macro, too).d */P     Define_Symbol(MMK_K_SYM_BUILTIN, "MMSQUALIFIERS", mmsqual, strlen(mmsqual));   /*/ **  Now read in and parse the description file.u */?     Read_Description(descripfile, "SYS$DISK:[]DESCRIP.MMS", 0);r   /*$ **  Dump our brains if we're told to */;     if (cli_present("DUMP") == CLI$_PRESENT) Dump_It_All();s   /*F **  Now define the MMS symbol (left undefined while we were parsing soF **  we can identify $(MMS) references in action lines and execute them# **  even if /NOACTION is specified.s */$     Define_Symbol(MMK_K_SYM_DESCRIP,8     	    	   "MMS", (noaction ? "MMK/NOACTION" : "MMK"),;                           (noaction ? 12             : 3));l   /*B ** Now that all the dependencies are defined, we can do the build. */#     status = cli_present("TARGET");VP     if (status == CLI$_PRESENT) cli_get_value("TARGET", target, sizeof(target));     else target[0] = '\0';       do {     	did_an_update = 0;.     	Build_Target(target);  B     	if ($VMS_STATUS_SEVERITY(exit_status) == STS$K_SEVERE) break;   /*' ** If everything is up-to-date, say so.  */     	if (check_status) {6     	    static $DESCRIPTOR(mms$status, "MMS$STATUS");&     	    static $DESCRIPTOR(one, "1");'     	    static $DESCRIPTOR(zero, "0");o9     	    static unsigned int gsym = LIB$K_CLI_GLOBAL_SYM;uJ     	    lib$set_symbol(&mms$status, did_an_update ? &zero : &one, &gsym);     	    if (did_an_update) {V/     	    	lib$signal(MMK__NEEDSUPD, 1, target);i     	    } else {-1     	    	lib$signal(MMK__TRGCURRENT, 1, target);-
     	    }
     	} else {      	    if (!did_an_update) {/     	    	lib$signal(MMK__NOUPDATE, 1, target);dE     	    	if (exit_status == SS$_NORMAL) exit_status = MMK__NOUPDATE;t
     	    }     	}  B     } while (OK(cli_get_value("TARGET", target, sizeof(target)))); /*F ** If we did have to execute some commands, there will be a subprocess& ** hanging around that we should kill. */     close_subprocess();l  )     return exit_status | STS$M_INHIB_MSG;    } /* main */ e /* **++ **  ROUTINE:	add_to_mmsqual  ** **  FUNCTIONAL DESCRIPTION:g **+ **  	Adds a string to the mmsqual variable.M ** **  RETURNS:	void  ** **  PROTOTYPE: ** **  	add_to_mmsqual(char *)3 ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.1 ** **  COMPLETION CODES:	None.o ** **  SIDE EFFECTS:   	None. ** **-- */' static void add_to_mmsqual(char *str) {        static char *qp  = mmsqual;s     static int  qlen = 0; 
     int i;       i = strlen(str);       if (i == 0) return;i-     if (qlen + i > sizeof(mmsqual)-1) return;        if (i == 1) {C     	*qp++ = *str;     	*qp = '\0';     } else {     	strcpy(qp, str);E
     	qp += i;      }-     qlen += i;   } /* add_to_mmsqual */ r /* **++ **  ROUTINE:	cli_get_value ** **  FUNCTIONAL DESCRIPTION:a **" **  	C Interface to CLI$GET_VALUE. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **0 **  	cli_get_value (char *argname, DESCRIP *arg) **1 ** argname: ASCIZ_string, read only, by referencew< ** arg:	    char_string, write only, by descriptor (dynamic) ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.C ** **  COMPLETION CODES:t **2 **  	All those from CLI$PRESENT and CLI$GET_VALUE. ** **  SIDE EFFECTS:   	None. ** **-- */J static unsigned int cli_get_value(char *argname, char *arg, int argsize) {     DESCRIP argnamd, argd;     unsigned short arglen;     int status;   2     INIT_SDESC(argnamd, strlen(argname), argname);%     INIT_SDESC(argd, argsize-1, arg);T#     status = cli$present(&argnamd);d&     if ($VMS_STATUS_SUCCESS(status)) {6     	status = cli$get_value(&argnamd, &argd, &arglen);*     	if (OK(status)) *(arg+arglen) = '\0';     }b     return status; }  h /* **++ **  ROUTINE:	put_outputO ** **  FUNCTIONAL DESCRIPTION:H **: **  	LIB$PUT_OUTPUT replacement that directs things either6 **  to SYS$OUTPUT or to the file specified in /OUTPUT. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	put_output(void *dsc) ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None._ ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */% unsigned int put_output(void *xdsc) {m       struct dsc$descriptor *dsc;e       dsc = xdsc;fR     return (out_unit ? file_write(out_unit, dsc->dsc$a_pointer, dsc->dsc$w_length)&     	    	     : lib$put_output(dsc)); } /* put_output */   /* **++ **  ROUTINE:	put_command ** **  FUNCTIONAL DESCRIPTION:d **: **  	LIB$PUT_OUTPUT replacement that directs things eitherE **  to SYS$OUTPUT or to the file specified in /OUTPUT (for commands).u **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **, **  	put_command(struct dsc$descriptor *dsc) ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.r ** **  COMPLETION CODES:s ** ** **  SIDE EFFECTS:   	None. ** **-- */7 unsigned int put_command(struct dsc$descriptor *xdsc) {r  (     static $DESCRIPTOR(ctrstr, "$ !AS");     struct dsc$descriptor dsc;     unsigned int status;
     int i;  3     if (out_unit == 0) return lib$put_output(xdsc);L  .     for (i = 0; i < xdsc->dsc$w_length; i++) {3     	if (isspace(xdsc->dsc$a_pointer[i])) continue; )     	if (xdsc->dsc$a_pointer[i] == '$') {oN     	    return file_write(out_unit, xdsc->dsc$a_pointer, xdsc->dsc$w_length);     	} else break;     }n     INIT_DYNDESC(dsc);1     status = lib$sys_fao(&ctrstr, 0, &dsc, xdsc);cW     if (OK(status)) status = file_write(out_unit, dsc.dsc$a_pointer, dsc.dsc$w_length);l     str$free1_dx(&dsc);s     return status;   } /* put_command */	   /* **++ **  ROUTINE:	cli_present ** **  FUNCTIONAL DESCRIPTION:5! **                               c  **  	C Interface to CLI$PRESENT. **A **  RETURNS:	cond_value, intword (unsigned), write only, by valuea ** **  PROTOTYPE: **  **  	cli_present (char *argname) **1 ** argname: ASCIZ_string, read only, by referencep ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  **  **  	All those from CLI$PRESENT. ** **  SIDE EFFECTS:   	None. ** **-- */0 static unsigned int cli_present(char *argname) {     DESCRIP argnamd;  2     INIT_SDESC(argnamd, strlen(argname), argname);!     return cli$present(&argnamd);  }    o /* **++ **  ROUTINE:	Dump_It_All ** **  FUNCTIONAL DESCRIPTION:i **@ **  	Prints out the contents of the suffix, global symbol, rule, **  and dependency lists.e **H **  	Mainly for use in debugging MMK, or in debugging description files. ** **  RETURNS:	void/ ** **  PROTOTYPE: ** **  	Dump_It_All ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.n ** **  COMPLETION CODES:h ** ** **  SIDE EFFECTS:   	None. ** **-- */ static void Dump_It_All(void) {v       struct SYMBOL *sym;;     struct RULE *xr, *r;     struct CMD *c;     struct OBJREF *o;a     struct DEPEND *d;      struct SFX *sfx;$     struct dsc$descriptor dsc, sdsc;     char nam[MMK_S_FILE];      int len, i, j;  *     static struct SYMTABLE *symtable[] = {8     	&builtin_symbols, &global_symbols, &cmdline_symbols     };$     static char *symtable_name[] = {&     	"MMK built-in macro definitions",<         "Rules-file and description-file macro definitions",%     	"Command-line macro definitions"*     };  -     static $DESCRIPTOR(slhdr, ".SUFFIXES :"); 1     static $DESCRIPTOR(ctrcmd, "    !AD!AD !AZ");b*     static $DESCRIPTOR(first, ".FIRST :");(     static $DESCRIPTOR(last, ".LAST :");+     static $DESCRIPTOR(dflt, ".DEFAULT :");*I     static $DESCRIPTOR(internal, "! Internally-generated dependencies:");I"     static $DESCRIPTOR(blank, "");$     static $DESCRIPTOR(comma, ", ");'     static $DESCRIPTOR(comhyp, ",-  ");t+     static $DESCRIPTOR(leader, "        "); @     static $DESCRIPTOR(end_tag, "! --- end of description ---");*     static $DESCRIPTOR(symhdr, "!! !AZ:");.     static $DESCRIPTOR(symctr, "  !AZ = !AZ");       INIT_DYNDESC(dsc);@     for (i = 0; i < sizeof(symtable)/sizeof(symtable[0]); i++) {5     	lib$sys_fao(&symhdr, 0, &dsc, symtable_name[i]);      	put_output(&dsc);     	put_output(&blank);0     	for (j = 0; j < MMK_K_SYMTABLE_SIZE; j++) {1     	    for (sym = symtable[i]->symlist[j].head; @     	    	    sym != (struct SYMBOL *) &symtable[i]->symlist[j];!     	    	    sym = sym->flink) {=?     	    	lib$sys_fao(&symctr, 0, &dsc, sym->name, sym->value);t     	    	put_output(&dsc); 
     	    }     	}     	put_output(&blank);     }f       str$copy_dx(&dsc, &slhdr);D     for (sfx = suffixes.flink; sfx != &suffixes; sfx = sfx->flink) {"     	static $DESCRIPTOR(spc, " ");+     	static $DESCRIPTOR(spcs, "         ");)#     	static $DESCRIPTOR(hyp, " -");      	str$append(&dsc, &spc);	O6     	INIT_SDESC(sdsc, strlen(sfx->value), sfx->value);     	str$append(&dsc, &sdsc);M<     	if (dsc.dsc$w_length > 70 && sfx->flink != &suffixes) {      	    str$append(&dsc, &hyp);     	    put_output(&dsc);"     	    str$copy_dx(&dsc, &spcs);     	}     }g     put_output(&dsc);         if (rules.flink != &rules) {     	put_output(&blank);;     	for (xr = rules.flink; xr != &rules; xr = xr->flink) {(;     	    static $DESCRIPTOR(ctrpfx, "{!AZ}!AZ{!AZ}!AZ : "); .     	    static $DESCRIPTOR(ctr, "!AZ!AZ : ");,     	    for (r = xr; r != 0; r = r->next) {-     	    	if (r->trgpfx[0] || r->srcpfx[0]) {f>     	    	    lib$sys_fao(&ctrpfx, 0, &dsc, r->srcpfx, r->src,&     	    	    	    r->trgpfx, r->trg);     	    	} else {9     	    	    lib$sys_fao(&ctr, 0, &dsc, r->src, r->trg);e     	    	})     	    	put_output(&dsc);yD     	    	for (c = r->cmdque.flink; c != &r->cmdque; c = c->flink) {,     	    	    lib$sys_fao(&ctrcmd, 0, &dsc, 7     	    	    	(c->flags & CMD_M_IGNERR ? 1 : 0), "-", I?     	    	    	(c->flags & CMD_M_NOECHO ? 1 : 0), "@", c->cmd);N     	    	    put_output(&dsc);o     	    	}A
     	    }     	}     }r       if (default_rule != 0) {     	put_output(&blank);     	put_output(&dflt);mE     	for (c = default_rule->cmdque.flink; c != &default_rule->cmdque;s6     	    	    	    	    	    	    	    c = c->flink) {'     	    lib$sys_fao(&ctrcmd, 0, &dsc, c6     	    	    (c->flags & CMD_M_IGNERR ? 1 : 0), "-", >     	    	    (c->flags & CMD_M_NOECHO ? 1 : 0), "@", c->cmd);     	    put_output(&dsc);     	}     }(  &     if (do_first.flink != &do_first) {     	put_output(&blank);     	put_output(&first);=     	for (c = do_first.flink; c != &do_first; c = c->flink) {t'     	    lib$sys_fao(&ctrcmd, 0, &dsc, i6     	    	    (c->flags & CMD_M_IGNERR ? 1 : 0), "-", >     	    	    (c->flags & CMD_M_NOECHO ? 1 : 0), "@", c->cmd);     	    put_output(&dsc);     	}     }   $     if (do_last.flink != &do_last) {     	put_output(&blank);     	put_output(&last); ;     	for (c = do_last.flink; c != &do_last; c = c->flink) { '     	    lib$sys_fao(&ctrcmd, 0, &dsc, ;6     	    	    (c->flags & CMD_M_IGNERR ? 1 : 0), "-", >     	    	    (c->flags & CMD_M_NOECHO ? 1 : 0), "@", c->cmd);     	    put_output(&dsc);     	}     }l  .     if (dependencies.flink != &dependencies) {     	put_output(&blank);E     	for (d = dependencies.flink; d != &dependencies; d = d->flink) {l     	    struct DEPEND *d1;z     	    dump_dependency(d);=     	    for (d1 = d->dc_flink; d1 != 0; d1 = d1->dc_flink) {m     	    	dump_dependency(d1);
     	    }     	}     }e  .     if (dep_internal.flink != &dep_internal) {     	put_output(&blank);     	put_output(&internal);_  W     	for (d = dep_internal.flink; d != &dep_internal; d = d->flink) dump_dependency(d);(     }s       str$free1_dx(&dsc);N     put_output(&blank);"     put_output(&end_tag);      put_output(&blank);t   } /* Dump_It_All */"   /* **++ **  ROUTINE:	dump_dependency ** **  FUNCTIONAL DESCRIPTION:s **" **  	Prints out a dependency rule. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */0 static void dump_dependency (struct DEPEND *d) {  $     struct dsc$descriptor dsc, sdsc;     char nam[MMK_S_FILE];      struct OBJREF *o;      struct CMD *c;     int did1, len;  1     static $DESCRIPTOR(ctrcmd, "    !AD!AD !AZ"); #     static $DESCRIPTOR(sep, " : ");o%     static $DESCRIPTOR(dsep, " :: "); "     static $DESCRIPTOR(blank, "");$     static $DESCRIPTOR(comma, ", ");'     static $DESCRIPTOR(comhyp, ",-  ");,+     static $DESCRIPTOR(leader, "        ");)       INIT_DYNDESC(dsc);+     len = make_object_name(nam, d->target);'     INIT_SDESC(sdsc, len, nam);i     str$copy_dx(&dsc, &sdsc);p5     str$append(&dsc, d->double_colon ? &dsep : &sep);*  
     did1 = 0;"@     for (o = d->sources.flink; o != &d->sources; o = o->flink) {-     	if (did1 == 1) str$append(&dsc, &comma);i4     	else if (did1 == 2) str$copy_dx(&dsc, &leader);)     	len = make_object_name(nam, o->obj);o      	INIT_SDESC(sdsc, len, nam);     	str$append(&dsc, &sdsc);O<     	if (dsc.dsc$w_length > 70 && o->flink != &d->sources) {#     	    str$append(&dsc, &comhyp);	     	    put_output(&dsc);     	    did1 = 2;     	} else did1 = 1;      }	     put_output(&dsc);        if (d->cmdqptr != 0) {A     	for (c = d->cmdqptr->flink; c != d->cmdqptr; c = c->flink) {n'     	    lib$sys_fao(&ctrcmd, 0, &dsc,  7     	    	    	(c->flags & CMD_M_IGNERR ? 1 : 0), "-",  ?     	    	    	(c->flags & CMD_M_NOECHO ? 1 : 0), "@", c->cmd);      	    	    put_output(&dsc);      	}     }=   } /* dump_dependency */l