 /* **++ **  FACILITY:	MMK  **% **  ABSTRACT:	Description file reader  ** **  MODULE DESCRIPTION:  **> **  	This module contains the read_description routine and its **  supporting routines. ** **  AUTHOR: 	    M. Madison L **  	    	    COPYRIGHT  1992-1995, MADGOAT SOFTWARE.  ALL RIGHTS RESERVED. ** **  CREATION DATE:  20-AUG-1992  ** **  MODIFICATION HISTORY:  **1 **  	20-AUG-1992 V1.0    Madison 	Initial coding. + **  	01-SEP-1992 V1.1    Madison 	Comments. D **  	02-APR-1993 V1.2    Madison 	Don't strip comments off commands.= **  	04-JUN-1993 V1.3    Madison 	Support for .INCLUDE files. A **  	22-OCT-1993 V1.3-1  Madison 	Trim trailing blanks off lines. > **  	12-DEC-1993 V1.4    Madison 	Add Fill_In_Missing_Sources.2 **  	01-JUL-1994 V1.5    Madison 	Support for CMS.D **  	06-JUL-1994 V1.5-1  Madison 	Add filename to default filespecs.A **  	14-JUL-1994 V1.6    Madison 	Update for prefixed inferences. @ **  	15-JUL-1994 V1.6-1  Madison 	Fix broken CMS fallback logic.N **  	29-DEC-1994 V1.6-2  Madison 	Allow for comment lines with leading blanks.C **  	12-JAN-1995 V1.6-3  Madison 	Defer target-libmod dependencies. I **  	19-JAN-1995 V1.6-4  Madison 	Fill in missing sources only when there F **                                       are no explicit action lines.B **  	27-JUN-1995 V1.6-5  Madison 	CMS lib elements vs. file specs.? **  	21-JUL-1995 V1.6-6  Madison 	Fix negative index into xbuf. @ **  	03-OCT-1995 V1.6-7  Madison 	Fix handling of continuations!F **  	21-FEB-1996 V1.6-8  Madison 	Fix bound of loop in strip_comments. **-- */
 #ifdef __DECC   #pragma module READDESC "V1.6-8" #else  #ifndef __GNUC__ #module READDESC "V1.6-8"  #endif #endif #include <ctype.h> #include "mmk.h" #include "globals.h" #pragma nostandard #include "mmk_msg.h" #pragma standard #include <rmsdef.h>        struct IO {      	struct IO *flink, *blink;     	char *linebuf, *stripbuf;     	unsigned int unit;      	int maxlen, current_line;     	char filespec[256];     };   /* ** Forward declarations  *//     void Read_Description(char *, char *, int); /     static void strip_comments(char *, char *); 4     static void Process_Deferred_Dependencies(void);.     static void Fill_In_Missing_Sources(void);   /* ** External references */O     extern void parse_descrip(char *, int, unsigned int *, int *, int, char *); $     extern unsigned int file_open();$     extern unsigned int file_read();%     extern unsigned int file_close(); 4     extern unsigned int file_exists(char *, char *);,     extern unsigned int file_get_filespec();+     extern struct SFX *find_suffix(char *); 2     extern struct RULE *find_rule(char *, char *);C     extern struct RULE *scan_rule_list(struct RULE *, char *, int); @     extern struct DEPEND *find_dependency(struct OBJECT *, int);0     extern int extract_filename(char *, char *);0     extern int extract_nametype(char *, char *);/     extern struct OBJECT *mem_get_object(void); 1     extern void mem_free_object(struct OBJECT *); 1     extern void mem_free_depend(struct DEPEND *); 7     extern struct OBJECT *Find_Object(struct OBJECT *); /     extern void Insert_Object(struct OBJECT *); /     extern struct OBJREF *mem_get_objref(void); ,     extern int prefix_match(char *, char *);7     extern unsigned int cms_fetch_file(char *, char *);      /* **++ **  ROUTINE:	Read_Description  ** **  FUNCTIONAL DESCRIPTION:  **= **  	Reads in a description file and forms lines that will be @ **  parsed by parse_descrip.  Handles continuation lines, strips
 **  comments.  **= **  	Although rules files and description files use identical A **  syntax, the third argument is a flag to indicate that this is A **  a rules file, since error handling is different in that case.  **' **  RETURNS:	void (errors are signaled)  ** **  PROTOTYPE: **A **  	Read_Description(char *fspec, char *defspec, int rules_file)  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */C void Read_Description(char *fspec, char *defspec, int rules_file) {        struct QUE ioque;      struct IO *io;     char resspec[256];     char *buf, *xbuf; ,     unsigned int status, unit, bufsize, len;#     int continuation, maxlen, xlen;        while (1) {      	if (*fspec == '\0') {W     	    status = file_open("DESCRIP",&unit,"SYS$DISK:[]DESCRIP.MMS",resspec, &maxlen);      	    if (!OK(status)) { X     	    	status = file_open("MAKEFILE.",&unit,"SYS$DISK:[]MAKEFILE.",resspec, &maxlen);
     	    }
     	} else { E     	    status = file_open(fspec, &unit, defspec, resspec, &maxlen);      	}     	if (OK(status)) break; '     	if (rules_file || !use_cms) break;  /*- **  Description files can be fetched from CMS  */     	if (*fspec == '\0') {3     	    status = cms_fetch_file("DESCRIP.MMS", 0); B     	    if (!OK(status)) status = cms_fetch_file("MAKEFILE.", 0);
     	} else {      	    char element[256]; *     	    extract_nametype(element, fspec);1     	    status = cms_fetch_file(element, fspec);      	}     	if (!OK(status)) {      	    status = RMS$_FNF;      	    break;      	}     }        if (!OK(status)) {     	if (rules_file) {5     	    lib$signal(MMK__NOOPNRUL, 1, fspec, status); :     	    if (OK(exit_status)) exit_status = MMK__NOOPNRUL;
     	} else { 5     	    lib$signal(MMK__NOOPNDSC, 1, fspec, status);      	}     	return;     }        if (do_log) { J     	lib$signal((rules_file ? MMK__OPENRULE : MMK__OPENDESC), 1, resspec);     }   %     ioque.head = ioque.tail = &ioque; #     io = malloc(sizeof(struct IO));      io->unit = unit;     io->maxlen = maxlen;'     io->linebuf = malloc(io->maxlen+1); (     io->stripbuf = malloc(io->maxlen+1);     io->current_line = 0; "     strcpy(io->filespec, resspec);!     queue_insert(io, ioque.tail);      buf = (char *) 0;      bufsize = 0;
     unit = 0;   +     while (queue_remove(ioque.head, &io)) { G     	while (OK(file_read(io->unit, io->linebuf, io->maxlen+1, &len))) {      	    io->current_line++;>     	    while (len > 0 && isspace(io->linebuf[len-1])) len--;!     	    io->linebuf[len] = '\0'; 1 	    if (continuation && isspace(*io->linebuf)) {      	    	char *cp; E     	    	for (cp = io->linebuf; *cp; cp++) if (!isspace(*cp)) break; -     	    	strip_comments(io->stripbuf, cp-1);      	    	xbuf = io->stripbuf;,     	    } else if (isspace(*io->linebuf)) {     	    	char *cp; E     	    	for (cp = io->linebuf; *cp; cp++) if (!isspace(*cp)) break; <     	    	if (*cp == '!' || *cp == '#') *io->linebuf = '\0';     	    	xbuf = cp - 1;     	    } else { 4     	    	strip_comments(io->stripbuf, io->linebuf);     	    	xbuf = io->stripbuf;
     	    }       	    xlen = strlen(xbuf);      	    continuation = 0;       	    if (xlen > 0) {<     	    	if (xbuf[xlen-1] == '-' || xbuf[xlen-1] == '\\') {     	    	    continuation = 1; "     	    	    xbuf[xlen-1] = '\0';     	    	    xlen -= 1;     	    	}      	    	if (bufsize > 0) {/     	    	    buf = realloc(buf, bufsize+xlen); )     	    	    strcpy(buf+bufsize-1,xbuf);      	    	    bufsize += xlen;     	    	} else {!     	    	    bufsize = xlen + 1; $     	    	    buf = malloc(bufsize);      	    	    strcpy(buf, xbuf);     	    	} 
     	    },     	    if (!continuation && bufsize > 1) {X     	    	parse_descrip(buf, bufsize-1, &unit, &maxlen, io->current_line, io->filespec);     	    	free(buf);     	    	bufsize = 0;     	    	if (unit) { '     	    	    queue_insert(io, &ioque); -     	    	    io = malloc(sizeof(struct IO));      	    	    io->unit = unit;"     	    	    io->maxlen = maxlen;1     	    	    io->linebuf = malloc(io->maxlen+1); 2     	    	    io->stripbuf = malloc(io->maxlen+1);#     	    	    io->current_line = 0; J     	    	    file_get_filespec(unit, io->filespec, sizeof(io->filespec));     	    	    unit = 0;      	    	} 
     	    }     	}       	if (bufsize > 0) { W     	    parse_descrip(buf, bufsize-1, &unit, &maxlen, io->current_line, io->filespec);      	    free(buf);      	    if (unit) {     	    	struct IO *io;)     	    	io = malloc(sizeof(struct IO));      	    	io->unit = unit;     	    	io->maxlen = maxlen;-     	    	io->linebuf = malloc(io->maxlen+1); .     	    	io->stripbuf = malloc(io->maxlen+1);     	    	io->current_line = 0; F     	    	file_get_filespec(unit, io->filespec, sizeof(io->filespec));     	    	unit = 0; #     	    	queue_insert(io, &ioque); 
     	    }     	}       	file_close(io->unit);     	free(io->linebuf);      	free(io->stripbuf);     	free(io);     }   $     Process_Deferred_Dependencies();     Fill_In_Missing_Sources();   }    /* **++ **  ROUTINE:	strip_comments  ** **  FUNCTIONAL DESCRIPTION:  **@ **  	Strips comments from the end of a string.  A comment beginsE **  with either an exclamation point (!) or a pound sign (#).  Quoted ! **  strings are handled properly.  ** **  RETURNS:	void  ** **  PROTOTYPE: **- **  	strip_comments(char *dest, char *source)  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- *// void strip_comments(char *dest, char *source) {        int quote;(     register char *cp=source, *cp1=dest;       quote = 0;"     for (cp = source; *cp; cp++) {     	if (quote) { (     	    if (*cp == '"') quote = !quote;
     	} else { -     	    if (*cp == '!' || *cp == '#') break;      	}     	*cp1++ = *cp;     } 2     while (cp1 > dest && isspace(*(cp1-1))) cp1--;
     *cp1 = 0;  }    /* **++* **  ROUTINE:	Process_Deferred_Dependencies ** **  FUNCTIONAL DESCRIPTION:  **? **  	Looks for dependencies that we created for library modules E **  that are targets, and adds them to the main dependencies queue if C **  there aren't dependencies there already for them.  The deferred 4 **  dependencies list is created by Parse_Objects(). ** **  RETURNS:	void  ** **  PROTOTYPE: **$ **  	Process_Deferred_Dependencies() ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:   None.  ** **  SIDE EFFECTS:   	None. ** **-- */. static void Process_Deferred_Dependencies () {       struct DEPEND *dep;   4     while (queue_remove(dep_deferred.flink, &dep)) {  U     	if (find_dependency(dep->target, 0) == 0) queue_insert(dep, dependencies.blink);      	else mem_free_depend(dep);        }   % } /* Process_Deferred_Dependencies */    /* **++$ **  ROUTINE:	Fill_In_Missing_Sources ** **  FUNCTIONAL DESCRIPTION:  **: **  	Add implied sources to dependency rules missing them. ** **  RETURNS:	void  ** **  PROTOTYPE: ** **  	Fill_In_Missing_Sources() ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */+ static void Fill_In_Missing_Sources(void) {        struct DEPEND *dep;      struct OBJECT *obj, *obj2;     struct OBJREF *o;      struct RULE *r, *xr;     struct SFX *s;     char trgnam[MMK_S_FILE];%     int need_extra_source, trgnamlen;    /*C **  We only need to fill in sources when the target is a file _and_ : **  there are no explicit action lines for the dependency. */L     for (dep = dependencies.flink; dep != &dependencies; dep = dep->flink) {7     	if (dep->target->type != MMK_K_OBJ_FILE) continue; L     	if (dep->cmdqptr != 0 && dep->cmdqptr->flink != dep->cmdqptr) continue;'     	s = find_suffix(dep->target->sfx); 
     	if (s) {      	    need_extra_source = 1; I     	    for (o = dep->sources.flink; o != &dep->sources; o = o->flink) { 7     	    	if (o->obj->type != MMK_K_OBJ_FILE) continue; 9     	    	if (find_rule(dep->target->sfx, o->obj->sfx)) { $     	    	    need_extra_source = 0;     	    	    break;     	    	} 
     	    }!     	    if (need_extra_source) {   0     	    	for (; s != &suffixes; s = s->flink) {"     	    	    int check_cms, slen; /*5 **  Don't use the CMS suffixes if we're not using CMS  */&     	    	    slen = strlen(s->value);2     	    	    check_cms = s->value[slen-1] == '~';2     	    	    if (check_cms && !use_cms) continue;  9     	    	    xr = find_rule(dep->target->sfx, s->value);      	    	    if (xr != 0) {<     	    	    	r = scan_rule_list(xr, dep->target->name, 0);     	    	    	if (r != 0) {*     	    	    	    obj = mem_get_object();K     	    	    	    trgnamlen = extract_filename(trgnam, dep->target->name); >     	    	    	    memcpy(obj->name, r->srcpfx, r->srcpfxlen);E     	    	    	    memcpy(obj->name+r->srcpfxlen, trgnam, trgnamlen); H     	    	    	    strcpy(obj->name+(r->srcpfxlen+trgnamlen), s->value);.     	    	    	    strcpy(obj->sfx, s->value);.     	    	    	    obj->type = MMK_K_OBJ_FILE;;     	    	    	    if ((obj2 = Find_Object(obj)) == NULL) { '     	    	    	    	Insert_Object(obj);      	    	    	    } else { )     	    	    	    	mem_free_object(obj);      	    	    	    	obj = obj2;      	    	    	    }(     	    	    	    o = mem_get_objref();      	    	    	    o->obj = obj;2     	    	    	    queue_insert(o, &dep->sources);     	    	    	    break;      	    	    	}     	    	    }      	    	} 
     	    }     	}     }  } /* Fill_In_Missing_Sources */ 