/* DCDIR.C */
/* Y.L. Noyelle, Supelec, France 1994 */

#ifdef VMS
#pragma noinline (errMac, errMacCall, errMacDef, errName)
#pragma noinline (evalIfExp, freeMac, frstConcFrame, peepNxtMacTok)
#pragma noinline (popMacStk, pushMacStk, skipParams, storeEndTok)
#endif

#include <ctype.h>
#include <setjmp.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include "dcdir.h"
#include "dcdir.ph"
#include "dcblk.h"
#include "dcblk.ph"
#include "dcdecl.h"
#include "dcexp.h"
#include "dcext.h"
#include "dcmain.h"
#include "dcmain.ph"
#include "dcprag.h"
#include "dcprag.ph"
#include "dcrec.h"
#include "dcrec.ph"
#include "dcrecdir.ph"

#define CDfndHCode	0x3900A2
#define DefineHCode	0x25729
#define DefinedHCode	0xBB3F4
#define DispBegSto	(DispChain + 1)
#define DispChain	(TsTok)1
#define ElifHCode	0x1924
#define ElseHCode	0x1955
#define EndifHCode	0x7E69
#define ErrorHCode	0x81E5
#define Even		2
#define ExtentHCode	0x5B4956
#define FillSkipTo(x)	memcpy(x, &pMacSto, sizeof(TsTok *))
#define GetTokAdr(x)							       \
  x = (x == NULL)							       \
       ? &(headChainMacBlk->tokSto[0])					       \
       : ((Ttok)*x == ENDBLK)						       \
         ? GoNxtBlk(x)							       \
         : x
#define GoNxtBlk(x)							       \
  &(((TmacBlk * /*~OddCast*/)(x - *(x + 1)))->next->tokSto[0])
#define IfHCode		0x105
#define IfdefHCode	0x8431
#define IfndefHCode	0x299E2
#define InclNxtHCode	0xA2676C02
#define IncludeHCode	0xD4DCD
#define IncrMacParCtr	if (++macParCtr == 0) macParCtr = Even  /* to keep
								      parity. */
#define IncrPMacT	2  /* sizeof(storage for standard macro token) */
#define IndexHCode	0x12452F
#define IsMacroFrame(x) (x->pPrevMac!=NULL && x->tArg!=NULL)
#define LineChng	(1 << PosLineChng)
#define LineHCode	0x1C5C
#define LgtMacHdr	DispBegSto
#define MacActWNoPar	QuasiNULLval(const TsTok **)
#define MaxLineNb	32767
#define MemberHCode	0x5B78B6
#define MPosFlags	CHAR_BIT
#define MPosLineNb	(MPosFlags + CHAR_BIT - 1) /* -1 because of LSIGN_BIT */
#define MRPosAdjFl	0
#define MRPosIgnFl	(MRPosAdjFl + 1)
#define MRPosUsdFl	(MRPosIgnFl + 1)
#define MRPosSysFl	(MRPosUsdFl + 1)
#define ParBndary	(1 << PosParBnd)
#define PosLineChng	(PosParBnd + 1)
#define PosParBnd	(PosSysMac + 1)
#define PosSysMac	1  /* bit0 = stored value of sysMacro */
#define PragmaHCode	0x306B6
#define PseudoName	ConvTname("\0\0")  /* name for pseudo-macro holding
				token string corresponding to each parameter. */
#define SamTypeHCode	0x8F50D2C
#define SizOfCharBlkLgtFld 1
#define SizeMacroStorageChunk ((SizeMacroStorageBlk - Offset(struct _bid,      \
							bid))/sizeof(TsTok))
#define SkipRestOfLine	longjmp(*curErrRet, 1)
#define SkipTo(x)	memcpy(&x, x, sizeof(TsTok *))
#define SysMac		(1 << PosSysMac)
#define UndefHCode	0xA565

DefIsSameName

typedef struct _tCondStkElt TcondStkElt;
struct _tCondStkElt {
  TcondStkElt *prev;
  TindentChk savOldSpCnt;
  bool curIfArmActiv, trueIfPartSeen, elseSeen, activLvl:1, macroExpand:1;
};

/* (Arbitrary) bit positions for type TconcFl */
#define COpnd1	(CShield<< 1)
#define COpnd2	(COpnd1 << 1)
#define CParam	(COpnd2 << 1)
#define CQuote	(CParam << 1)
#define MaxCMsk	CQuote

typedef struct _tMacBlk TmacBlk;
struct _bid {  /* just to allow computation of SizeMacroStorageChunk */
  TmacBlk *bid1, *bid2;
  TsTok bid3, bid;
};
struct _tMacBlk {
  TmacBlk *next, *prec;  /* 'next' must be first field (cf 'storeMacChunk()') */
  TsTok headChain, tokSto[(TsTok)SizeMacroStorageChunk];
};
/*~zif (Offset(struct _bid, bid) != Offset(TmacBlk, tokSto))
					"struct _bid incoherent with TmacBlk" */
/*~zif (SizeMacroStorageBlk < sizeof(TmacBlk))
				 "incorrect organization for struct _tMacBlk" */

typedef enum {EndDir, EndPar} TsortEndTok;

#define lclArgColl	infoM.s11._lclArgColl
#define concFl		infoM.s11._concFl
#define insideMUMP	infoM.s11._insideMUMP
#define isFME		infoM.s11._isFME
#define macExpNb	infoM.s11._macExpNb
#define macExpnd	infoM.s11._macExpnd
#define SysMacFl	infoM.s11._sysMacFl
#define NbBitsConcFl	8
/*~zif MaxCMsk > (TconcFl)1<<(NbBitsConcFl - 1)
				"Bad field size for storing 'TconcFl' values" */
typedef union {
  struct {
    TmacExpNb _macExpNb:SmallestWdthInt;  /* field needed because of embedded
	 			macro calls (will run into problem in the
				(unreasonable) case where there are more than
				2**16-1 macro expansions in a given compilation
				unit). */
    TconcFl _concFl:NbBitsConcFl;  /* flags for '##' operator */
#undef NbBitsConcFl
    bool _isFME:1;
    bool _sysMacFl:1;
    bool _macExpnd:1;
    bool _lclArgColl:1;
    bool _insideMUMP:1;
  } s11;
  TallocUnit u11;  /* for good alignment of following fields */
} TinfoM;
typedef struct _tMacStkElt TmacStkElt;
struct _tMacStkElt {
  const TsTok *pMacTok;/* token pointer in previous level */
  const TsTok **tArg;  /* because of case "Mac(Mac(3))"; NULL for '##' frame */
  TdescrId *pPrevMac;  /* previous macro (for embedded macro calls); NULL
							 for parameter frame. */
  TinfoM infoM;
  TmacStkElt *prev;
};


/* Context of GetNxtTok() */
typedef struct _tSavTokCtx TsavTokCtx;
struct _tSavTokCtx {
  TsavTokCtx *prev;
  TdescrId *newPDCI;
  void (*newPGNT)(void);
  TmacExpNb newCMEN;
  TvalTok newCurTok;
  TmacLvl newMacLvl;
  TmacParCtr newMacParCtr;
  TindentChk newSpCnt, newOldSpCnt;
  bool newAdjMacro, newFrstChOfNb, newMacExpnd, newSysMacro, oldMacExpnd;
};

/* Functions profiles */
static void checkConc(void), checkDir(Tname), errMac(Terr, const TdescrId *),
  errMacCall(Terr, Tstring), errMacDef(Terr, Tstring)/*~NeverReturns*/,
  errName(Terr), exitMacroOrParam(void), freeMac(TdescrId *x),
  freeMacSto(TsTok *), getTokFromMac(void), otherDir(void), popCondStk(void),
  popMacStk(void), procCDefined(void), procDefined(void), pushMacStk(void),
  restoPeepedTok(void), skipParams(uint),
  skipRestOfLinePhase4(void) /*~NeverReturns*/, skipToEndStNu(void),
  storeChInFName(Tchar), storeEndTok(TdpNst, TsortEndTok), storeMacChar(char),
  storeMacChunk(Ttok, const TsTok *, size_t), storeTok(void);
static TcondStkElt *allocCondStkElt(void), *freeCondStkElt(TcondStkElt *);
static TmacStkElt *allocMacStkElt(void), *freeMacStkElt(TmacStkElt *);
static TsTok *createMacroHeader(Tname);
static bool evalIfExp(void), frstConcOpnd(void), macActive(bool);
static TmacStkElt *frstConcFrame(void);
static bool isMacPar(void);
static const TsTok *manageJmpTok(const TsTok * /*~ResultPtr*/);
static Ttok peepNxtMacTok(bool);

/* Global variables */
static bool activLvl = True;
static Tchar *bufInclFName = NULL;
static bool concArgSeen;  /* either argument of '##' operator generated */
static Tstring curFileN;
static bool curIfArmActiv = True;
static bool curMacIsFME;
static bool elseSeen;
static const TsTok *endCurCharSubBlk = NULL;
static bool gblArgCollect = False;  /* somewhere in the macro stack, there is
				    currently at least one macro in the process
				    of argument collecting. */
static bool gotOutOfBody;
static bool incldSysFile;
static bool inclNxt;
static bool lclArgCollect = False;  /* top macro is currently argument collecting */
static bool macIsSymb = False;
static bool nonPortFNSeen;
static TlineNb nLine;
static TdescrId psdMacDcsId = {NULL, NULL, NULL, 0, {MacActWNoPar /*~zif
				   !__member(_tabArg) "Bad initialization" */}},
		*pCurMac = &psdMacDcsId;
static TsTok *pLgtCharSubBlk;  /* pointer on length field of currently filled
				      character (sub-)block in macro storage. */
static uint peepedTokVal;
static TdescrId *pMacBeingDfnd;
static const TsTok *pMacTok = NULL;  /* 'source' pointer when exploring macro */
static const TdescrId *pNxtMac = NULL;  /* non-NULL => collecting arguments for
					indicated macro (may collect them from
					expansion of an upper-level macro). */
static size_t posInBufIFN, sizBufIFN = 0;
static TsTok *pseudoMacQuo;
static TcondStkElt *pTopCondStk;
static TmacStkElt *pTopMacStk = NULL;  /* pointer on top of macro stack */
static TsavTokCtx *pTopTokCtx = NULL;  /* pointer on top of peeped tokens
								       stack. */
static const TsTok *savPMTQuo = NULL;  /* not inside '#' operator */
static bool trueIfPartSeen;
/* Variables to manage macro storage space */
static TsTok *pMacSto = NULL, *endCurMacSto = NULL, *pHeadChain;
static TmacBlk *curMacBlk,
	       *freeMacBlk = NULL,  /* available free block (for efficiency) */
	       *headChainMacBlk;    /* head of macro storage chunks chain */

/* External variables */
bool adjMacro = False;
TmacExpNb begMacExpNb;
TconcFl concatFl = CNoBit;  /* flags for '##' operator */
uint ctrCSE = 0;  /* number of conditional directive stack elements */
bool insideDefine = False;
bool insideMultUsedMacPar = False;
TlineNb lastSCOLline;
TmacLvl macLvl = 0;
TmacParCtr macParCtr = Even;  /* non-zero because of 'lastPrimMacParCtr'
								   (dcexp.c). */
bool sysMacro = False;  /* flag to prevent warnings inside system macros */

/* Pseudo-local variables */
static bool cmpsgHdr;

void manageDir(void)
{
  static TlineNb begLineNb;
  static Tstring begFileName;
  volatile bool oldCIAA = curIfArmActiv, savMacroExpand = macroExpand;  /*
			macroExpand not always True here, because of possible
			directive line while collecting macro arguments. */
  jmp_buf localJmpBuf, *savErrRet = curErrRet;

  curErrRet = &localJmpBuf  /*~ LocalAdr */;
  if (setjmp(*curErrRet) != 0) {  /* skip to end of directive line */
    static const Ttok zEndDir[]= {NoSwallowTok, ENDDIR, EndSTok};

    heedDP = False;
    skipTok(zEndDir);}
  else {
    posInBufIFN = 0;  /* used also as '#include' flag */
    macroExpand = False;
    condDirSkip = False;  /* to de-inhibit error messages, and inhibit token
						     skipping in GetNxtTok(). */
    if (dpragNst != 0) {
      curTok.tok = WHITESPACE;  /* destroy possible ENDDIR left in curTok.tok */
      err0(NoDirInDPrag);
      skipRestOfLinePhase4();}  /* see 'slashF()' */
    if (NxtTok()!=IDENT && curTok.tok!=IF && curTok.tok!=ELSE) errPanic(
							    DirNameExptd, NULL);
    macroExpand = True;
    switch (curTok.hCod) {
      bool trueCond;

    case IfHCode: checkDir(ConvTname("\2\0if")); goto ifL;
    case IfdefHCode: checkDir(ConvTname("\5\0ifdef")); goto ifL;
    case IfndefHCode: checkDir(ConvTname("\6\0ifndef"));
ifL:
      {
        TcondStkElt *w;

        w = allocCondStkElt();
        w->curIfArmActiv = curIfArmActiv;
        w->trueIfPartSeen = trueIfPartSeen;
        w->elseSeen = elseSeen;
        w->activLvl = activLvl;
        w->savOldSpCnt = oldSpaceCount;
        w->macroExpand = savMacroExpand;
        w->prev = pTopCondStk;
        pTopCondStk = w;}
      {
        bool w1;

        if (! curIfArmActiv) activLvl = False;
        trueIfPartSeen = elseSeen = False;
        if (! activLvl) skipRestOfLinePhase4();
        if (curTok.hCod == IfHCode) w1 = evalIfExp();
        else {
          TresulExp savCExp = cExp;

          w1 = (curTok.hCod == IfndefHCode);
          macroExpand = False;
          w1 = (NxtTok() == IDENT)
		? (procDefined(), (bool /*~OddCast*/)cExp.uVal ^ w1)
		: (errName(MacNameExptd), False);
          macroExpand = True;
          cExp = savCExp;
          GetNxtTok();}
        curIfArmActiv = w1;}
      break;
    case ElifHCode:
      checkDir(ConvTname("\4\0elif"));
      if (pTopCondStk == NULL) err0(NoPrecIf);
      trueCond = evalIfExp();
      goto elseL;
    case ElseHCode:
      checkDir(ConvTname("\4\0else"));
      if (pTopCondStk == NULL) err0(NoPrecIf);
      if (elseSeen) err0(ElseAlrdSeen);
      elseSeen = True;
      GetNxtTok();
      trueCond = True;
elseL:
      if (!activLvl || pTopCondStk==NULL) break;
      trueIfPartSeen |= curIfArmActiv;
      curIfArmActiv = trueCond & !trueIfPartSeen;
      oldSpaceCount = pTopCondStk->savOldSpCnt;
      savMacroExpand = pTopCondStk->macroExpand;
      break;
    case EndifHCode:
      checkDir(ConvTname("\5\0endif"));
      if (pTopCondStk == NULL) err0(NoPrecIf);
      GetNxtTok();
      if (pTopCondStk != NULL) {savMacroExpand = pTopCondStk->macroExpand
								; popCondStk();}
      break;
    default:
      if (curIfArmActiv) otherDir();
      else skipRestOfLinePhase4();}
    if (curTok.tok != ENDDIR) errPanic(EndOfLineIgnd, NULL);}
  if (posInBufIFN != 0) manageInclude(bufInclFName, incldSysFile, cmpsgHdr,
		inclNxt); /* '#include' (taken into account here, so that all
				     possible errors shown on previous file). */
  condDirSkip = (! curIfArmActiv);  /* condDirSkip must be set only after all
						   errors have been detected. */
  if (condDirSkip) {
    if (oldCIAA) {begLineNb = lineNb + cumDeltaLineNb; begFileName =
								   curFileName;}
    savMacroExpand = False;}  /* to prevent macro-expansion while skipping */
  else if (!oldCIAA && !adjustFile && curFileName==begFileName
		 ) cumNbSkippedLines += lineNb - 1 + cumDeltaLineNb - begLineNb;
  ignoreErr = False;
  macroExpand = savMacroExpand;
  curErrRet = savErrRet;
}

static void otherDir(void)
{
  switch (curTok.hCod) {
  case DefineHCode : {
      uint paramCtr = 0;
      TlineNb oldLineNb;
      bool ignore;

      checkDir(ConvTname("\6\0define"));
      if (gblArgCollect) {errMacCall(DccCantProcDef | Warn3, NULL)
							      ; SkipRestOfLine;}
      macroExpand = False;
      heedDP = insideDefine = True;
      GetNxtTok();
      {
        bool masking = FoundDP(MASKING);

        ignore = (cUnitFName==NULL && FoundDP(IGNORE));  /* d.p. allowed only
							     in starter file. */
        if (curTok.tok != IDENT) {
/*          if (!IsKW ||    memcmp(curTok.IdName, Const, FullLgt(Const))!=0
                       && memcmp(curTok.IdName, Volatile, FullLgt(Volatile))!=0)
			  ignore possible redefinition of 'const'/'volatile'. */
          errName(MacNameExptd);
          SkipRestOfLine;}
        if (pDescTokId != NULL) {
          if (pDescTokId->nstLvl+1 < 0) {errMac(MacAlrdDef|Warn3|PossErr,
						   pDescTokId); SkipRestOfLine;}
          else if (!masking && (curTok.ptrSem==NULL || curTok.ptrSem->type!=
		      NULL)) errId(NameAlrdInUse|Warn3|PossErr, curTok.ptrSem,
						   curTok.IdName, NULL, NULL);}}
      enterBlock();		/* just to store parameter names */
      pMacBeingDfnd = enterSymTabHC1((Tname)createMacroHeader(curTok.IdName),
								   curTok.hCod);
      pMacBeingDfnd->nstLvl = IncplMacDef;  /* to remove immediately (in case of
	       erroneous macro definition) macro name from blocks name space. */
      if (nxtChFromTxt() == (TcharStream)'(') {  /* there is an (empty ?)
							      parameter list. */
        paramCtr++;	/* value 0 is for 'symbol' macro (no parenthesis
								 after name). */
        if (NxtTok() != RPAR) {
          do {
            TsemanElt *ptrParId;
            DefSem(defndMacPar, ParamMac, True);
            DefSem1(notUsdMacPar, ParamMac, False, True, False);

            if (curTok.tok != IDENT) {errName(ParNameExptd); errMacDef(NoErrMsg,
									 NULL);}
            if (paramCtr > UCHAR_MAX) errMacDef(TooManyMacPar, longToS((long)
								    UCHAR_MAX));
            if ((ptrParId = enterSymTabHC(storeName(curTok.IdName, ObjectSpace),
		     curTok.hCod)) == NULL) errMacDef(ParAlrdExist, nameToS(
								curTok.IdName));
            ptrParId->noPar = paramCtr++;  /* parameter number */
            ptrParId->defLineNb = lineNb;
            ptrParId->defFileName = curFileName;
            GetNxtTok();
#ifdef _AIX
            if (FoundDP(NOTUSED)) ptrParId->infoS = notUsdMacPar;
            else ptrParId->infoS = defndMacPar;
#else
            ptrParId->infoS = (FoundDP(NOTUSED))? notUsdMacPar : defndMacPar;
#endif
            if (FoundDP(SIDEFFOK)) ptrParId->usedMorThOnce = True;
          } while (Found(COMMA));}
        if (curTok.tok != RPAR) errMacDef(RParExptd, NULL);}
      else {
        backUp();
        if (curFileName!=starterFile && islower((char)*(curTok.IdName +
						  LgtHdrId))) macIsSymb = True;}
      pMacBeingDfnd->nstLvl =
        (long)(((((ulong)lineNb<<(MPosLineNb - MPosFlags - MRPosSysFl) |
		  (ulong)sysHdrFile) << (MRPosSysFl - MRPosIgnFl) |
		  (ulong)ignore)     << (MRPosIgnFl - MRPosAdjFl) |
		  (ulong)adjustFile) << (MRPosAdjFl + MPosFlags) |
		  paramCtr |
		  LSIGN_BIT);  /* save definition line number, various flags,
						    and number of parameters. */
      pMacBeingDfnd->dFileName = curFileName;  /* birth place */
      pMacBeingDfnd->tabArg = NULL;  /* marks macro not active */
      /* Store macro body, in token form (except for identifiers, strings
         and numbers, because they can't be exactly decompiled). */
      heedDP = False;
      oldLineNb = lineNb;
      if (NxtTok() != ENDDIR) {
        TsTok *pLastTok = NULL, *pLastNb = QuasiNULLval(TsTok *);
        bool lastTokIsConc = False, isNbAlone = (paramCtr == 0);

        do {
          if (lineNb != oldLineNb) {storeMacChunk(SUNDR, NULL, LineChng)
							  ; oldLineNb = lineNb;}
          if (curTok.tok == CONCATOP) {
            /* ## operator must be in prefix form */
            if (lastTokIsConc || pLastTok==NULL) {err0(MsngConcOpnd); continue;}
            lastTokIsConc = True;
            GetTokAdr(pLastTok);
            if (*pLastTok != (TsTok)IDSTNU) {  /* fixed length token => easy
					   to permute it with CONCATOP token. */
              curTok.tok = (Ttok)*pLastTok;
              curTok.val = (uint)*(pLastTok + 1);
              storeTok();
              *(pLastTok + 1) = (TsTok)WHITESPACE;}  /* "normal" CONCATOP */
            *pLastTok = (TsTok)CONCATOP;  /* in case last token was IDSTNU,
				      extension is different from WHITESPACE. */
            curTok.tok = ENDARG1CONC;}  /* end marker for 1st arg. of ## */
          else {
            lastTokIsConc = False;
            pLastTok = pMacSto;
            if (isNbAlone && (curTok.tok!=ADDOP || pLastNb!=QuasiNULLval(
								      TsTok *)))
              if (curTok.tok==CSTNU && pLastNb==QuasiNULLval(TsTok *)
							   ) pLastNb = pLastTok;
              else macIsSymb = isNbAlone = False;
            if (curTok.tok == QUOTEOP) {
              if (paramCtr != 0) {
                if (NxtTok()!=IDENT || !isMacPar()) {err0(NotMacParForQuo)
					     ; if (curTok.tok == ENDDIR) break;}
                else {curTok.val = curTok.ptrSem->noPar; curTok.ptrSem->used =
						   True; curTok.tok = QUOTEOP;}}
              else curTok.tok = QUOTEOP1;}}
          storeTok();
        } while (NxtTok() != ENDDIR);
        if (isNbAlone && pLastNb!=QuasiNULLval(TsTok *)) {GetTokAdr(pLastNb)
					      ; *(pLastNb + 1) = (TsTok)CSTNU1;}
        if (lastTokIsConc) {err0(ConcOprIlgLast); storeMacChunk(SCOL, NULL,
									 0-0);}}
      storeEndTok(0, EndDir);
      exitBlock();
      macIsSymb = insideDefine = False;}
    break;
  case ErrorHCode:
    checkDir(ConvTname("\5\0error"));
    err0(ErrorDir);
    skipRestOfLinePhase4();
  case InclNxtHCode:
    checkDir(ConvTname("\xC\0include_next"));
    inclNxt = True;
    goto mngInclL;
  case IncludeHCode:
    checkDir(ConvTname("\7\0include"));
    inclNxt = False;
mngInclL:
    macroExpand = nonPortFNSeen = False;
    incldSysFile = True;
    if (NxtTok()==ORDEROP && (TkCmp)curTok.val==LT) {  /* form '<' */
      Tchar c;

      while ((c = (Tchar)(*pNxtCh)()) != '>') {
        if (c=='\n' || c==EndCh && fileClosed) {errWS(UnFnshFileName, ">")
                                                             ; backUp(); break;}
        if (! IsVisibleChar(c)) errWS(NotVisiChar|Warn3|PossErr, charToHexS(c));
        storeChInFName(c);}}
    else {  /* try macro expansion */
      macroExpand = True;
      if (curTok.tok==IDENT && pDescTokId!=NULL && pDescTokId->nstLvl<0
								  ) expandMac();
      if (curTok.tok == CSTST) {incldSysFile = False; analStrCst(
							      &storeChInFName);}
      else if (curTok.tok==ORDEROP && (TkCmp)curTok.val==LT) {
        while (! (NxtTok()==ORDEROP && (TkCmp)curTok.val==GT)) {
          Tstring w;

          if (curTok.tok == ENDDIR) {errWS(UnFnshFileName, ">"); break;}
          if (InsideInterval(curTok.tok, CSTCH, CSTST)) goto ilgArgL;
          w = curTokTxt();
          while (*w != '\0') storeChInFName(*w++);
          if (CurTokNotAnalz()) analNumCst(&storeChInFName);}}
#ifdef VMS
      else if (curTok.tok==IDENT && sysHdrFile) {
        Tstring w = curTokTxt();

        while (*w != '\0') storeChInFName(*w++);
        storeChInFName('.'); storeChInFName('h');}
#endif
      else
ilgArgL:
      {
        err0(IlgInclArg);
        posInBufIFN = 0;
        SkipRestOfLine;}}
    storeChInFName('\0');
    macroExpand = True;
    if (curTok.tok != ENDDIR) GetNxtTok();
    cmpsgHdr = FoundDP(CMPSGHDR);
    break;
  case LineHCode:
    checkDir(ConvTname("\4\0line"));
    if (! InsideInterval(NxtTok(), CSTNU, CSTNU1)) err0(IntgrNbExptd);
    else {
      analNumCst(Convert);
      if (curTok.val & FltSeen || curTok.numVal==0 || curTok.numVal>MaxLineNb
							   ) err0(IntgrNbExptd);
      else if (! curTok.errorT) {
        TlineNb newLineNb = (TlineNb)curTok.numVal - 1;

        cumDeltaLineNb += lineNb - newLineNb;
        lineNb = newLineNb;}
      if (NxtTok() == CSTST) {
        Tchar *w;

        curFileName = w = allocPermSto(initGetStrLit(getLitString()));
        while ((*w++ = nxtStrLitChar()) != '\0') {}
        resetGetStrLit();
        exitBlock();}}  /* because of 'getLitString()' */
    break;
  case PragmaHCode:
    checkDir(ConvTname("\6\0pragma"));
    skipRestOfLinePhase4();  /* ignore line */
  case UndefHCode:
    checkDir(ConvTname("\5\0undef"));
    macroExpand = False;
    if (NxtTok() != IDENT) {errName(MacNameExptd); SkipRestOfLine;}
    if (pDescTokId==NULL || pDescTokId->nstLvl+1>=0) {if (!sysAdjHdrFile &&
		      lineNb!=0) errWN(UnknMacro|Warn2|PossErr, curTok.IdName);}
    else {
      static const struct _s {Tname name; ThCode hc;} permMac[] = {
		{(Tname)"\x8\0__LINE__", 0x59EB6C},
		{(Tname)"\x8\0__FILE__", 0x59A134},
		{(Tname)"\x8\0__DATE__", 0x59792A},
		{(Tname)"\x8\0__TIME__", 0x5A4C97},
		{(Tname)"\x8\0__STDC__", 0x5A56A6}};
      const struct _s *ptr;

      for (ptr = &permMac[0]; ptr < AdLastEltP1(permMac); ptr++)
        if (isSameName(curTok.hCod, curTok.IdName, ptr->hc, ptr->name)) {errWN(
				   NonUndfnblMac, curTok.IdName); goto noFreeL;}
      freeMac(pDescTokId);
noFreeL: ;}
    macroExpand = True;
    GetNxtTok();
    break;
  default: errPanic(IlgDirName|Warn3|PossErr, NULL);}
}
/*~Undef cmpsgHdr */

void expandMac(void)
{
  TdescrId *calledMac = pDescTokId;
  uint argNbP1;
  const TsTok **newTabArg;  /* pointer on created argument table */
  bool isFMEMac = (curTok.tok == FORCEMACEXP), sysMacroFl, oldSysMac;
  TindentChk savSpcCnt;

  if (calledMac->nstLvl & (1 << (MPosFlags + MRPosIgnFl))) {  /* pseudo-macro
							       to be ignored. */
    if (NxtTok() == LPAR) {skipParams(-1u); GetNxtTok();}
    return;}
  if (curTok.tok==NOMACEXP /* never expand NOMACEXP */ || calledMac->tabArg!=
						  NULL && macActive(isFMEMac)) {
    /* Avoid infinite recursion in macro expansion */
    if (gblArgCollect) {curTok.tok = NOMACEXP; return;}  /* "Non-replaced
		macro names are no longer available for further replacement". */
    goto identNotMacroL;}
  if (concatFl!=CNoBit && !(concatFl & CShield)) {
    if (concatFl==CQuote || concatFl&COpnd2 && !concArgSeen || frstConcOpnd()
	) goto identNotMacroL;  /* do not expand argument(s) of '#'/'##'
								    operator. */
    isFMEMac = False;}
  /* OK now for macro expansion */
  calledMac->nstLvl |= 1 << (MPosFlags + MRPosUsdFl);
  sysMacroFl = (calledMac->nstLvl >> (MPosFlags + MRPosSysFl)) & 1;
  oldSysMac = sysMacro;
  savSpcCnt = spaceCount;
  if ((argNbP1 = (uint)calledMac->nstLvl & ((1 << MPosFlags) - 1)) == 0)  /*
						      macro without argument. */
    newTabArg = MacActWNoPar;
  else {  /* macro with argument list */
    const TsTok **pNewTabArg;
    const TsTok *const *endTabArg;
    TdpNst oldDPnst;
    TsTok *adPsdHdr;
    TindentChk savOSpCnt = oldSpaceCount;
    TconcFl savConcFl = concatFl;
    bool savConcArgSeen = concArgSeen, oldGblArgColl, savME = macroExpand,
								  savLclArgColl;
    TlineNb oldLineNb;
    const TdescrId *oldPNM = pNxtMac;

    pNxtMac = calledMac;  /* must be set here (because of case where current
	   macro '#undef'ed on next line and next token only found after...). */
    gotOutOfBody = False;
    /* Check if really macro call ( '(' just after) */
    macroExpand = False;  /* "During collection, arguments are not macro-
								   expanded". */
    {
      TmacExpNb oldCurMacExpNb = curMacExpNb;
      bool exitFromParam = (pMacTok != NULL)? (peepNxtMacTok(False)==ENDDIR &&
		 (TsortEndTok)peepedTokVal!=EndDir /* => == EndPar */) : False,
				calledMacNotActiv, savCurMacIsFME = curMacIsFME;
      Ttok w;

      if (exitFromParam) calledMacNotActiv = (calledMac != pCurMac);
      heedDP = True;
      w = peepNxtTok();
      heedDP = False;
      if (w == LPAR) {
        if (! exitFromParam) goto expandOKL;
        /* Case where name of macro alone passed in parameter */
        if (calledMacNotActiv) {
          if (! gblArgCollect) isFMEMac = False;
          goto expandOKL;}}
      /* Macro not to be expanded */
      pNxtMac = oldPNM;
      if (pTopTokCtx->newCMEN <= oldCurMacExpNb) pTopTokCtx->newMacExpnd =
		macroExpand = savME;  /* no macro entered (and not exited)
							     in peepNxtTok(). */
      goto identNotMacroL;
expandOKL:
      if (pTopTokCtx->newCMEN < oldCurMacExpNb) {  /* macro exited in
								peepNxtTok(). */
        pTopTokCtx->newMacExpnd = macroExpand = False;
        isFMEMac |= savCurMacIsFME;}}
    nLine = lineNb;
    curFileN = curFileName;
    GetNxtTok();  /* skip LPAR */
    MyAlloc(pNewTabArg, argNbP1*sizeof(TsTok *));
    newTabArg = pNewTabArg;
    endTabArg = newTabArg + argNbP1;
    /* Simulate pseudo-macro body to store parameters (so as to free easily
       the space they use, at end of macro expansion). */
    adPsdHdr = createMacroHeader(PseudoName);
    *pNewTabArg++ = (gblArgCollect)? NULL : adPsdHdr;
    /* Argument collection */
    savLclArgColl = lclArgCollect;
    oldGblArgColl = gblArgCollect;
    gblArgCollect = lclArgCollect = True;
    oldLineNb = lineNb;
    oldDPnst = dpragNst;
    concatFl = CNoBit;  /* shield argument collection from possible '##'
							     active operator. */
    if (NxtTok() != RPAR) {
      uint parenCtr = 0;  /* 'nested parenthesis' counter */

endArgL:
      if (pNewTabArg == endTabArg) {
        errMacCall(TooManyMacArg, NULL);
        if (! InsideMacro) skipParams(parenCtr);  /* idem decCC, gcc */
        goto endArgCollL;}
      *pNewTabArg++ = pMacSto;
      if (sysMacro != sysMacroFl) storeMacChunk(SUNDR, NULL, SysMac |
							      (size_t)sysMacro);
      for (;; GetNxtTok()) {
        if (lineNb != oldLineNb) {storeMacChunk(SUNDR, NULL, LineChng)
							  ; oldLineNb = lineNb;}
        switch (curTok.tok) {
          case COMMA:
            if (parenCtr == 0) {  /* "comma not protected by nested
								parenthesis." */
              storeEndTok(oldDPnst, EndPar);
              if (pNewTabArg != endTabArg) {sysMacro = oldSysMac; GetNxtTok();}
              goto endArgL /*~ BackBranch */;}
            break;		  /* else normal token */
          case ENDPROG:
            errMacCall(UnFnshArgList, longToS((int)(pNewTabArg - newTabArg)-1));
            goto endArgCollL;
          case IDENT:
            if (   parenCtr==0  /* identifier can only at this level be
						   interpreted as macro name. */
                && pDescTokId!=NULL && pDescTokId->nstLvl+1<0  /* macro */
		&& (concatFl==CNoBit || concatFl&CShield))
              curTok.tok = (pDescTokId->tabArg==NULL || !macActive(isFMEMac))?
				FORCEMACEXP : NOMACEXP;  /* if macro, remember
						    its current active state. */
            break;
          case LPAR: parenCtr++; break;
          case RPAR:
            if (parenCtr == 0) goto endArgCollL;
            parenCtr--;
            break;
          case WHITESPACE:  /* incomplete parameter (may happen because of
							      '##' operator). */
            if (gotOutOfBody) {errMac(IncplPar, calledMac); goto endArgCollL;}
          /*~ NoDefault */}
        storeTok();}}
endArgCollL:
    storeEndTok(oldDPnst, EndPar);
    if (pNewTabArg != endTabArg) {
      if (pNewTabArg-newTabArg !=1 || argNbP1!=1+1) errMac(MsngMacArg,
		      calledMac); /* case of empty argument for one parameter */
      do {
        *pNewTabArg++ = pMacSto;
        storeEndTok(oldDPnst, EndPar);
      } while (pNewTabArg != endTabArg);}
    if (gblArgCollect = oldGblArgColl) FillSkipTo(adPsdHdr);
    oldSpaceCount = savOSpCnt;  /* may have been modified during argument
								  collection. */
    concatFl = savConcFl;
    concArgSeen = savConcArgSeen;
    lclArgCollect = savLclArgColl;
    macroExpand = savME;
    pNxtMac = oldPNM;}
  /* Enter macro */
  pushMacStk();
  macLvl++;
  {
    register TmacStkElt *pTMS = pTopMacStk;

    pTMS->macExpNb = curMacExpNb;
    pTMS->SysMacFl = oldSysMac;
    pTMS->isFME = curMacIsFME;
    pTMS->macExpnd = macroExpand;
    pTMS->lclArgColl = lclArgCollect;}
  if (curMacIsFME = isFMEMac) {  /* delayed expansion of macro, that should
		    have been performed before calling the other currently
		    called macros, or encountering current '##' operator). */
    /* Get out of reach of possible current '##' operator (but remember that
       inside it, to allow frstConcOpnd() to be called). */
    if (concatFl != CNoBit) concatFl |= CShield;}
  macroExpand = True;
  adjMacro = (calledMac->nstLvl >> (MPosFlags + MRPosAdjFl)) & 1;
  sysMacro = sysMacroFl;
  pCurMac = calledMac;  /* macro becomes current */
  calledMac->tabArg = newTabArg;  /* note address of created table of pointers
				   on macro arguments, and mark macro active. */
  pMacTok = (const TsTok *)calledMac->idName + FullLgt(calledMac->idName); /*
							     skip macro name. */
  if (! InsideMacro) {pCurGNT = &getTokFromMac; pNxtCh = &nxtChFromMac;}
  {
    static TmacExpNb ctrMacExp = 0;  /* number of macro expansions */

    curMacExpNb = ++ctrMacExp;}  /* one more macro expansion ... (deemed
			      useless to check for (very unlikely) overflow). */
  lclArgCollect = False;
  if (gblArgCollect && (concatFl==CNoBit || concatFl & CShield) && sysMacroFl!=
								    oldSysMac) {
    curTok.tok = SUNDR;
    curTok.val = (uint)sysMacroFl | SysMac;}
  else GetNxtTok();  /* get first token of macro */
  spaceCount = savSpcCnt;
  return;
identNotMacroL:
  {
    register TdescrId *pDescCurId;
    register Tname adBegName;
    ThCode hCode;

    curTok.IdName = adBegName = pDescTokId->idName;
    curTok.hCod = hCode = hCodFct(adBegName);
    SearchSym(adBegName, MacroNotVisible)
    if (pDescCurId == NULL) curTok.ptrSem = NULL;
    else {
      pDescTokId = pDescCurId;
      if (pDescCurId->nstLvl < 0) {curTok.tok = pDescCurId->noLex; return;}
      curTok.ptrSem = pDescCurId->pIdSeman;}
    curTok.tok = IDENT;}
}

static void getTokFromMac(void)
{
  getTokLvl++;
  spaceCount = SetInGetTokFrmMac;
  for (;;) {
    register const TsTok *pMacTokL = pMacTok;
    Ttok token;

    curTok.tok = token = (Ttok)*pMacTokL++;
    curTok.val = (uint)*pMacTokL++;
    /*~zif IncrPMacT != 2 "Pb"*/
    pMacTok = pMacTokL;
    if (token < BegSpeMacTok) break;
    switch (token) {
      case CONCATOP:  /* '##' operator */
        pushMacStk();
        pTopMacStk->tArg = NULL;  /* marks new frame as ## frame */
        concatFl = COpnd1;  /* ready for 1st argument of operator */
        concArgSeen = False;
        if (curTok.val != (uint)WHITESPACE) goto idStNuL;  /* if CONCATOP
						    condensed with IDENT etc. */
        continue;
      case DPRAG:
        if ((curTok = manageDPrag()).tok == WHITESPACE) continue;
        break;
      case ENDARG1CONC:
        concatFl = COpnd2;
        concArgSeen = False;
        continue;  /* get 2nd operand */
      case ENDBLK:
        pMacTokL -= IncrPMacT;
        pMacTok = GoNxtBlk(pMacTokL);
        continue;
      case ENDDIR: {  /* end of macro body or parameter */
          bool oldSysMac = sysMacro;

          exitMacroOrParam();
          if (concatFl!=CNoBit /* so does nothing if stack empty */ &&
			   pTopMacStk->tArg==NULL) {  /* back to a '##' frame */
            if (!concArgSeen || lclArgCollect && gotOutOfBody) { 
              /* No token generated by parameter/macro operand of a '##' opera-
                 tor; too late for concatenating previous token (if 1st operand)
                 => generate an empty token... Generate also an empty token for
                 2nd operand, for symmetry reasons, though should be able to
                 concatenate to next token. */
              errWS(EmptyConcArg|Warn2|PossErr, errTxt[(concatFl & COpnd1)?
								 Left : Right]);
              curTok.tok = WHITESPACE;
              break;}
            if (concatFl&COpnd2 && !(concatFl & (CParam | CShield))) popMacStk(
			);}  /* exiting from a '##' operator whose 2nd operand
					       was a parameter of length > 1. */
          /* Get next token */
          if (InsideMacro) {
            if (gblArgCollect && (concatFl==CNoBit || concatFl & CShield) &&
			((TsortEndTok)curTok.val!=EndDir /* => ==EndPar */ ||
							 sysMacro!=oldSysMac)) {
              curTok.tok = SUNDR;
              curTok.val = (SysMac | (uint)sysMacro) | (uint)(curTok.val !=
						     (uint)EndDir) << PosParBnd;
              break;}
            continue;}}
        pCurGNT = &getTokFromTxt;
        pNxtCh = &nxtChFromTxt;
        getTokLvl--;
        GetNxtTok();
        return;
      case IDSTNU:
idStNuL:
        switch (curTok.tok = (Ttok)curTok.val) {
        case CSTNU: case CSTNU1:
          curTok.val = 0;
          frstChOfNb = (bool)nxtChFromMac();  /* True */
          break;
        case WHITESPACE + 1:  /* wide-character string (cf storeTok()) */
          curTok.tok = CSTST;
          goto cststL;
        case CSTST:
          curTok.val = (uint)False;
cststL:
          frstChOfNb = True;
          break;
        case FORCEMACEXP: case NOMACEXP:
          memcpy(&pDescTokId, pMacTokL, sizeof(pDescTokId));
          pMacTok += sizeof(pDescTokId);
expandL:
          expandMac();
          if (curTok.tok!=IDENT || curTok.ptrSem==NULL) break;
tstUndefL:
          if (curTok.ptrSem->undef && !curTok.ptrSem->modifSJ && getTokLvl==
			     tokLvl0) errWN(UndfndId|Warn1|Rdbl, curTok.IdName);
          break;
        case IDENT: {
            register TdescrId *pDescCurId;
            register Tname adBegName;
            ThCode hCode;

            curTok.IdName = adBegName = (Tname)pMacTokL;
            pMacTok += FullLgt(adBegName);
            curTok.hCod = hCode = hCodFct(adBegName);
            SearchSym(adBegName, MacroVisible)
            if ((pDescTokId = pDescCurId) != NULL) {
              if (pDescCurId->nstLvl >= 0) {  /* identifier not macro */
                curTok.ptrSem = pDescCurId->pIdSeman;
                goto tstUndefL /*~BackBranch*/;}
              if (pDescCurId->nstLvl+1 == 0) {curTok.tok = pDescCurId->noLex
					 ; break;}  /* keyword (case '+zkwm') */
              if (macroExpand) goto expandL /*~BackBranch*/;}
            curTok.ptrSem = NULL;
            break;}
        /*~NoDefault*/}
        break;
      case MACPAR: case MACPAR1:
        macParCtr++;  /* cannot overflow (even before) */
        pushMacStk();
        macLvl++;
        pTopMacStk->insideMUMP = insideMultUsedMacPar;
        pTopMacStk->SysMacFl = sysMacro;
        pTopMacStk->pPrevMac = NULL;  /* mark new frame as parameter frame */
        insideMultUsedMacPar = (curTok.tok == MACPAR1);
        pMacTok = pCurMac->tabArg[curTok.val];  /* beginning of parameter
							    string of tokens. */
        if (gblArgCollect && (concatFl==CNoBit || concatFl & CShield)) {
          curTok.tok = SUNDR;
          curTok.val = ParBndary;
          break;}
        continue;
      case QUOTEOP: {
          /* Decode parameter tokens, and store generated string in string
             storage, pending better macro processing. */
          TconcFl savConcatFl = concatFl;
          void (*savPSCF)(char) = pStoreChFct;
          TsTok *pCrtdTok;

          concatFl = CQuote;  /* to prevent macro-expansion (including
								FORCEMACEXP). */
          {
            TsTok w;  /* not initialized, since value later overwritten */

            pseudoMacQuo = createMacroHeader(PseudoName);  /* pseudo-macro to
		hold generated string token (for memory reclaiming purposes). */
            storeMacChunk(IDSTNU, /*~Init w*/&w, SizOfCharBlkLgtFld);  /* so
		    that length of 1st sub-block in same macro storage block. */
            pLgtCharSubBlk = pMacSto - SizOfCharBlkLgtFld;
            pCrtdTok = pLgtCharSubBlk - IncrPMacT;
            *(pCrtdTok + 1) = (TsTok)CSTST;  /* fill IDSTNU created token */
          }
          pStoreChFct = &storeMacChar;  /* for storeTokSource() */
          for (pMacTok = pCurMac->tabArg[curTok.val];;) {
            pMacTok = manageJmpTok(pMacTok);
            if ((Ttok)*pMacTok == ENDDIR) break;  /* end of parameter reached */
            if (NxtTok() == DPRAG) dpragNst--;
            storeTokSource();
            if (CurTokNotAnalz()) {
              if (curTok.tok == CSTST) {analStrCst(&storeTokTxtRepr)
							   ; storeMacChar('"');}
              else analNumCst(pStoreChFct);}}
          pStoreChFct= savPSCF;
          *pLgtCharSubBlk = (TsTok)(pMacSto - pLgtCharSubBlk);  /* number
				    of characters (+1) in (ending) sub-block. */
          storeMacChunk((Ttok)0, NULL, 0); pMacSto--;  /* end marker = 0
						      (only one byte needed). */
          *pMacSto = *pMacTokL;  /* in case of 'peepNxtMacTok()' */
          if (gblArgCollect) {
            FillSkipTo(pseudoMacQuo);
            pseudoMacQuo = NULL;}
          concatFl = savConcatFl;
          savPMTQuo = pMacTokL;  /* also, flag to tell 'inside quoteOp' (if
								   non NULL). */
          pMacTok = pCrtdTok;
          continue;}  /* get created token */
      case SKIPTO: SkipTo(pMacTok); continue;
      case SUNDR:
        if (curTok.val & SysMac) {
          if (sysMacro==(bool)(curTok.val & 1) && !(curTok.val & (ParBndary |
					    LineChng))) continue;  /* useless */
          sysMacro = (bool)(curTok.val & 1);}
        if (gblArgCollect && concatFl==CNoBit) break;  /* to be kept uninter-
		 preted in case of argument collection (not inside '#'/'##'). */
        if (curTok.val == LineChng) lastSCOLline = 0;
        else if (curTok.val & ParBndary) macParCtr += Even;
        continue;
      /*~NoDefault*/}
    break;}
  if (concatFl != CNoBit) checkConc();  /* check if first operand of '##'
								    operator. */
  if (--getTokLvl == 0) storeTokSource();
}

static void checkConc(void)
{
  while (concatFl!=CNoBit && (concArgSeen = True, frstConcOpnd())) {  /* VERY
				 subtle (think of tests after 1st loop turn). */
    const TmacStkElt *ptrConcFrameBef = frstConcFrame();
    uint savTokVal;

    manageConc();
    /* Getting out of this '##' operator */
    /* First, exit of possible exhausted parameter/macro body (so then, '##'
       frame will be removed from stack, and call to 'frstConcFrame' for pos-
       sible next call to 'manageConc' will be correct). */
    savTokVal = curTok.val;
    while (concatFl & CParam) {
      if (peepNxtMacTok(False) != ENDDIR) {
        /* 2nd operand not yet exhausted: exiting reach of '##' operator done
           when 2nd operand get exhausted (see ENDPAR management in getTokFrom-
	   Mac() ). */
        const TmacStkElt *ptrCurConcFrame = frstConcFrame();

        if (ptrConcFrameBef != ptrCurConcFrame) {  /* concatenating at an
			outer level => remove inner '##' frame.
			See case "MZA(MZA(NT,), MZA(, NT))", with:
			#define MZA(x, y) MZ(x, y)
			#define MZ(x, y) x##V##y
			#define V 22 33
			#define NT */
          register TmacStkElt *w = pTopMacStk;

          while (w->prev != ptrCurConcFrame) w = w->prev;
          w->prev = freeMacStkElt(w->prev);}
        goto expandQML;}
      curTok.val = peepedTokVal;  /* for exitMacroOrParam() */
      exitMacroOrParam();}
    if (pTopMacStk->tArg != NULL) sysErr(ExCod3);  /* *doIt* remove */
    popMacStk();  /* remove '##' frame */
expandQML:
    curTok.val = savTokVal;
    if (   macroExpand
        && (ptrConcFrameBef->concFl==CNoBit || ptrConcFrameBef->concFl&
		    CShield) /* outside of a possible chain of '##' operators */
        && curTok.tok==IDENT && pDescTokId!=NULL && pDescTokId->nstLvl+1<0
								 ) expandMac();}
}

/******************************************************************************/
/*                                                                            */
/*                                  UTILITIES                                 */
/*                                                                            */
/******************************************************************************/

static AllocXElt(allocCondStkElt, TcondStkElt, ctrCSE, ;)
static AllocXElt(allocMacStkElt, TmacStkElt, ctrMSE, ;)

bool aloneInNoParMac(void)
{
  return    pCurMac->tabArg == MacActWNoPar  /* macro with no parameter */
         && !(pCurMac->nstLvl & 1<<(MPosFlags + MRPosSysFl))  /* non system
								       macro. */
         && pMacTok==manageJmpTok((const TsTok *)pCurMac->idName + FullLgt(
	   pCurMac->idName))+IncrPMacT /* current token at beginning of macro */
         && peepNxtMacTok(False)==ENDDIR
         && (TsortEndTok)peepedTokVal==EndDir;  /* and nothing after. */
}

void checkCondStkAndDeleteMacros(void)
{
  if (pTopCondStk != NULL) {
    err0(MsngEndif);
    do popCondStk(); while (pTopCondStk != NULL);}
  /* Free (possible) remaining macro zones */
  {
    TdescrId **w = &symTabHeads[0], *w1, *w2;

    do {
      for (w1 = *w++; w1 != NULL; w1 = w2) {
        w2 = w1->next;
        if ((w1->nstLvl)+1 < 0) freeMac(w1);}
    } while (w != &symTabHeads[SizeSymTab]);}
}

static void checkDir(Tname dirName)
{
  if (memcmp(curTok.IdName, dirName, FullLgt(dirName)) != 0) errPanic(
						IlgDirName|Warn3|PossErr, NULL);
}

bool checkSColAtEndMac(void)
{
  if (peepNxtMacTok(False)!=ENDDIR || (TsortEndTok)peepedTokVal!=EndDir
								 ) return False;
  errMac(ExtraSColAtEndMac, pCurMac);
  return True;
}

bool checkSpeFct(void)
{
  enum _index{BegTab, Defined = BegTab, Member, Extent, Index, SamType,
							      CDefined, EndTab};
  static const struct _s {ThCode fctHCode; Tname fctName; void (*fctPtr)(void);}
				     speFctTab[/*~ IndexType enum _index */] = {
	{DefinedHCode, (Tname)"\7\0defined", &procDefined}	/*~ zif
		  __index!=Defined "Array 'speFctTab': element out of order" */,
	{MemberHCode, (Tname)"\x8\0__member", &procMember1}/*~ zif
		   __index!=Member "Array 'speFctTab': element out of order" */,
	{ExtentHCode, (Tname)"\x8\0__extent", &procExtent}	/*~ zif
		   __index!=Extent "Array 'speFctTab': element out of order" */,
	{IndexHCode, (Tname)"\7\0__index", &procIndex}		/*~ zif
		    __index!=Index "Array 'speFctTab': element out of order" */,
	{SamTypeHCode, (Tname)"\xA\0__sametype", &procSameType}/*~ zif
		  __index!=SamType "Array 'speFctTab': element out of order" */,
	{CDfndHCode, (Tname)"\x8\0cdefined", &procCDefined}	/*~ zif
		 __index!=CDefined "Array 'speFctTab': element out of order" */
	/*~ zif __index != EndTab - 1
				 "Array 'speFctTab': not fully initialized" */};
  register const struct _s *ptrTab;

  for (ptrTab = &speFctTab[BegTab]; ptrTab <= &speFctTab[EndTab - 1];ptrTab++) {
    if (isSameName(curTok.hCod, curTok.IdName, ptrTab->fctHCode,
							     ptrTab->fctName)) {
      bool rParExptd, savME = macroExpand;

      if (ptrTab == &speFctTab[Defined]) macroExpand = False;
      else if (ptrTab == &speFctTab[CDefined]) {
        if (! adjustFile) return False;
        macroExpand = False;}
      else if (! zifExp) return False;
      if (rParExptd = (NxtTok() == LPAR)) GetNxtTok();
      if (ptrTab==&speFctTab[Index] || ptrTab==&speFctTab[SamType]) (
							     *ptrTab->fctPtr)();
      else if (ptrTab==&speFctTab[Member] && curTok.tok!=IDENT) procMember2();
      else {
        if (curTok.tok != IDENT) {
          if (ptrTab == &speFctTab[Defined]) errName(MacNameExptd);
          else err0(IdExptd);}
        else {
          (*ptrTab->fctPtr)();
          if (! rParExptd) macroExpand = savME;
          GetNxtTok();}}
      macroExpand = savME;
      if (rParExptd && !Found(RPAR)) err0(RParExptd);
      return True;}}
  return False;
}

static TsTok *createMacroHeader(Tname x)
/* Returns address of created macro header */
{
  TsTok */*~IndexType TsTok*/ resul;

  if (gblArgCollect) {  /* do not create macro header if currently storing para-
			meters, because parameter token string must be continu-
			ous. Used space will be freed at calling macro exit
			time. */
    storeMacChunk(SKIPTO, (const TsTok *)x, sizeof(void *));
    resul = pMacSto - sizeof(void *);}  /* remember position of address field
				of SKIPTO (to be able to fill it when known). */
  else {
    storeMacChunk((Ttok)0, (const TsTok *)x, FullLgt(x));  /* store macro
					header and name in a contiguous area. */
    /*~zif LgtMacHdr != IncrPMacT "We have a big problem here" */
    resul = pMacSto - FullLgt(x);  /* here because new block may have started */
    /* Chain new zone to zones already held in current macro block, in such a
       manner that higher address zones are found earlier in chain (cf
							      'freeMacSto()'. */
    *(resul - DispChain) = *pHeadChain;
    *(resul - DispBegSto) = *pHeadChain = (TsTok)(resul - &(curMacBlk->tokSto
									 [0]));}
  return resul;
}

Tstring curMacDFName(void)
{
  return pCurMac->dFileName;
}

bool dpHereOrAloneInMac(void)
{
  return    !InsideMacro
         || pMacTok==manageJmpTok((const TsTok *)pCurMac->idName + FullLgt(
			 pCurMac->idName))  /* d-pragma at beginning of macro */
           && peepNxtMacTok(False)==ENDDIR
           && (TsortEndTok)peepedTokVal==EndDir;  /* and nothing after. */
}

static void errMac(Terr n, const TdescrId *x)
{
  errWFName(n, (TlineNb)(((ulong)x->nstLvl^LSIGN_BIT) >> MPosLineNb),
					   x->dFileName, x->idName, NULL, NULL);
}

void errMacBefIncl(void)
{
  const TmacStkElt *wpStk = pTopMacStk;
  const TdescrId *pCMac;

  if (wpStk != NULL) {  /* because of possible call to peepNxtTok() */
    pCMac = pCurMac;
    while (wpStk->prev != NULL) {
      if (IsMacroFrame(wpStk)) pCMac = wpStk->pPrevMac;
      wpStk = wpStk->prev;}
    if (curFileName!=pCMac->dFileName && pCMac->tabArg==MacActWNoPar)  /* if
	   macro defined in current file/there exists parameters, fortuitous
			     error less probable. */ errMac(MacBefIncl, pCMac);}
}

static void errMacCall(Terr n, Tstring y)
{
  errWFName(n, nLine, curFileN, (pNxtMac == NULL)? NULL : pNxtMac->idName, y,
									  NULL);
}

static void errMacDef(Terr n, Tstring txt) /*~NeverReturns*/
/* Free storage used by the (aborted) macro name, and skip remaining of line */
{
  TnameBuf buf;

  bufNameToS(pMacBeingDfnd->idName, buf);  /* not errWNSS(), because of 'txt'
								   parameter. */
  errWSS(n, buf, txt);
  freeMac(pMacBeingDfnd);
  exitBlock();  /* may cause error messages */
  insideDefine = macIsSymb = False;
  SkipRestOfLine;  /* errPanic() not used, to get correct sequencing
							   of error messages. */
}

static void errName(Terr n)
{
  errWS(n, (IsKW)? errTxt[IfKW] : NULL);
}

static bool evalIfExp(void)
{
  TresulExp saveCExp = cExp, saveLExp = lExp;
  bool resul;
  Trchbl savNSR = nxtStmtRchbl;

  ifDirExp = True;
  GetNxtTok();
  resul = correctExprN(NULL, Bool, True, "#if", True) && cExp.uVal!=0;
  ifDirExp = False;
  cExp = saveCExp; lExp = saveLExp; nxtStmtRchbl = savNSR;
  return resul;
}

static void exitMacroOrParam(void)
{
  register TmacStkElt *pTMS = pTopMacStk;

  if ((TsortEndTok)curTok.val == EndDir) {
    register TdescrId *pCurMacR = pCurMac;

    if (lclArgCollect && pNxtMac!=NULL && !macroExpand && !gotOutOfBody) {
      errMacCall(ArgCollGetsOutMacBody | Warn3, nameToS(pCurMac->idName));
      gotOutOfBody = True;}
    if (pCurMacR->tabArg != MacActWNoPar) {  /* if macro with parameters, free
		      storage used by macro parameters, and parameters table. */
      freeMacSto((TsTok * /*~OddCast*/)pCurMacR->tabArg[0]);
      free(pCurMacR->tabArg);}
    pCurMacR->tabArg = NULL;  /* marks macro inactive */
    adjMacro = (pTMS->pPrevMac->nstLvl >> (MPosFlags + MRPosAdjFl)) & 1;
    pTMS->pPrevMac->tabArg = pTMS->tArg;
    pCurMac = pTMS->pPrevMac;
    curMacIsFME = pTMS->isFME;
    macroExpand = pTMS->macExpnd;
    lclArgCollect = pTMS->lclArgColl;
    curMacExpNb = pTMS->macExpNb;
    if (curMacExpNb < begMacExpNb) lastSCOLline = 0;}
  else {  /* EndPar */
    IncrMacParCtr;  /* so that uninterrupted run of tokens in parameter
								  detectable. */
    insideMultUsedMacPar = pTopMacStk->insideMUMP;}
  sysMacro = pTopMacStk->SysMacFl;
  macLvl--;
  popMacStk();
}

static FreeXElt(freeCondStkElt, TcondStkElt *, ctrCSE, ;, prev)

static void freeMac(TdescrId *x)
{
  if (pNxtMac != NULL)  /* cannot only test currently expanding macro, because
		      of macros passed as parameter, that store a pointer on a
		      DescrIdElt: e.g. // #define M(x) ... // #define M1 ... //
			      ... // M(M1 // #undef M // #undef M1 // ) // ...*/
    *((TnameNC/*~OddCast*/)x->idName + DispNSId) = (TnameAtom)DeltdMac;  /*
					then just render macro invisible to
					SearchSym; will be freed by checks(). */
  else {
    if (!(x->nstLvl & (1 << (MPosFlags + MRPosUsdFl))) && cUnitFName==
		x->dFileName && cUnitFName==curFileName && warnNUI) errMac(
							  UnusedMac | Warn1, x);
    /* Free storage used by macro body */
    freeMacSto((TsTok * /*~OddCast*/)x->idName);
    /* Remove macro element from symbol table chaining */
    x->prec->next = x->next;
    if (x->next != NULL) x->next->prec = x->prec;
    /* Free element */
    (void)freeDescrIdElt(x);}
}

static FreeXElt(freeMacStkElt, TmacStkElt *, ctrMSE, ;, prev)

static void freeMacSto(TsTok *macName)
{
  TmacBlk *firstBlk, *nxtBlk, *precBlk;
  register TmacBlk *curBlk;

  if (macName == NULL) return;
  firstBlk = (TmacBlk * /*~OddCast*/)((ubyte *)macName - *(macName - DispBegSto)
		 - Offset(TmacBlk, tokSto[0]));  /* compute address of block
					where macro begins ('initial' block). */
  *(macName - DispBegSto) = 0;  /* marks zone free */
  if (macName != &(firstBlk->tokSto[firstBlk->headChain])) return;  /* if
			    freed zone not last of block, nothing to be done. */
  for (curBlk = firstBlk->next; curBlk != NULL; curBlk = nxtBlk) {  /* find end
							       of freed zone. */
    TsTok w;

    for (w = curBlk->headChain; w != 0; w = curBlk->tokSto[w -
		     DispChain]) {  /* follow chain of macro headers in block */
      if (curBlk->tokSto[w - DispBegSto] != 0) {  /* found still used macro
							    in current block. */
        /* Patch chaining over all freed blocks */
        firstBlk->next = curBlk;
        curBlk->prec = firstBlk;
        return;}}
    /* Whole block is freeable; free it */
    nxtBlk = curBlk->next;
    if (freeMacBlk == NULL) freeMacBlk = curBlk;  /* keep one spare (for
								 efficiency). */
    else free(curBlk);
    ctrMSB--;}
  /* Freed zone includes last block, so reset pointers for storeMacChunk(),
     removing possible free blocks sitting before 'initial' one. */
  do {
    TsTok w, w1;

    for (w1 = firstBlk->headChain; w1 != 0; w1 = firstBlk->tokSto[w1 -
		     DispChain]) {  /* follow chain of macro headers in block */
      if (firstBlk->tokSto[w1 - DispBegSto] != 0) break;  /* found still
							   used macro header. */
      w = w1;}  /* keep position of end of current zone */
    if (w1!=0		/* found still used macro header, */
        || ((precBlk = firstBlk->prec)!=(TmacBlk * /*~OddCast*/)&headChainMacBlk
         && (precBlk->headChain==0  /* (if so, preceding zone can't be free) */
          || precBlk->tokSto[precBlk->headChain - DispBegSto]!=0  /* or
					       preceding zone not free. */ ))) {
      pMacSto = &(firstBlk->tokSto[w - LgtMacHdr]);
      firstBlk->headChain = w1;
      pHeadChain = &(firstBlk->headChain);
      curMacBlk = firstBlk;
      endCurMacSto = &(firstBlk->tokSto[(TsTok)SizeMacroStorageChunk -
								    IncrPMacT]);
      firstBlk->next = NULL;
      return;}
    free(firstBlk);
    ctrMSB--;
  } while ((firstBlk = precBlk) != (TmacBlk * /*~OddCast*/)&headChainMacBlk);
  pMacSto = endCurMacSto = NULL; /* return to initial state */
}

static TmacStkElt *frstConcFrame(void)
/* Returns address of first '##' frame found in stack (used to be able to
   manage cases such as a##x##b (with x => 'u v') => 'au' 'vb'. */
{
  register TmacStkElt *w = pTopMacStk;

  while (w->tArg != NULL) w = w->prev;
  return w;
}

static bool frstConcOpnd(void)
/* Answers True if current token is last token of first operand to a '##'
   operator (because cat(a b c, d e f) => a b cd e f). */
{
  if (! (concatFl & COpnd1)) return False;
  /* for case M(x##y), with x => a##b and y => c##d */
  {
    const TsTok *savPMacTok = pMacTok;
    register const TmacStkElt *w = pTopMacStk;
    bool firstTurn = True;
    Ttok nxtTok;

    while ((nxtTok = peepNxtMacTok(firstTurn)) == ENDDIR) {
      /* Go to caller */
      while (w->tArg == NULL) w = w->prev;  /* skip '##' frames */
      pMacTok = w->pMacTok;
      w = w->prev;
      firstTurn = False;}
    pMacTok = savPMacTok;
    return (nxtTok == ENDARG1CONC);}
}

void initDir(void)
{
}

static bool isMacPar(void)
{
  if (curTok.ptrSem == NULL) {  /* non-existant identifier, or macro name */
    TdescrId *pDescCurId;
    ThCode hCode;

    if (pDescTokId == NULL) return False;  /* non-existant identifier */
    hCode = curTok.hCod;
    SearchSym(curTok.IdName, MacroNotVisible);
    if (pDescCurId==NULL || pDescCurId->nstLvl+1==0) return False;
    curTok.ptrSem = pDescCurId->pIdSeman;}
  return curTok.ptrSem->kind == ParamMac;
}

static bool macActive(bool isFMEMac)
{
  /* See if irrelevant active status, due to expansion of macro parameter (that
     is itself a macro) after macro entering, though, in the direct text repla-
     cement scheme, it would have been expanded before entering. */
  register const TmacStkElt *wpStk = pTopMacStk;

  if (! isFMEMac) {
    if (pDescTokId == pCurMac) return True;
    if (curMacIsFME) return False;
    do {
      if (IsMacroFrame(wpStk)) {
        if (pDescTokId == wpStk->pPrevMac) {
          if (! wpStk->isFME) return True;}  /* macro really active */
        else if (wpStk->isFME) return False;}
    } while ((wpStk = wpStk->prev)->prev != NULL);
    return True;}
  {
    bool flg = False;

    do {
      if (IsMacroFrame(wpStk)) {
        if (pDescTokId==wpStk->pPrevMac && !wpStk->lclArgColl && flg) return flg;
						       /* macro really active */
        if (! wpStk->isFME) flg = True;}
    } while ((wpStk = wpStk->prev)->prev != NULL);
    return False;}
}

static const TsTok *manageJmpTok(register const TsTok *x /*~ResultPtr*/)
{
  for (;;) {
    switch ((Ttok)*x) {
      case DPRAG :
        if (!macroExpand || concatFl!=CNoBit) return x;
        x += IncrPMacT;
        for (;;) {
          x = manageJmpTok(x) + IncrPMacT;
          switch ((Ttok)*(x - IncrPMacT)) {
            case ENDDPRAG: goto exitL;
            case IDSTNU:
              switch ((Ttok)*(x - (IncrPMacT - 1))) {
                case FORCEMACEXP: case NOMACEXP: x += sizeof(pDescTokId); break;
                case IDENT: x += FullLgt((Tname)x); break;
                default: {
                    const TsTok *const savPMacTok = pMacTok;

                    pMacTok = x;
                    skipToEndStNu();
                    x = pMacTok;
                    pMacTok= savPMacTok;}}
            /*~NoDefault*/}}
exitL:
        continue;
      case ENDBLK: x = GoNxtBlk(x); continue;
      case SKIPTO: {const TsTok *w = x + IncrPMacT;;SkipTo(w); x = w; continue;}
      case SUNDR : x += IncrPMacT; continue;
      default: return x;}}
}

TcharStream nxtChFromMac(void)
{
  for (;;) {
    if (endCurCharSubBlk == NULL) {
      endCurCharSubBlk = pMacTok + *pMacTok;
      if (*pMacTok != 0 /* useful, but why ? */) pMacTok++;}
    if (pMacTok != endCurCharSubBlk) break;
    endCurCharSubBlk = NULL;
    if (*pMacTok != 0) pMacTok = GoNxtBlk(pMacTok);
    else {
      pMacTok++;  /* skip ending 0 */
      return -1;}}  /* end of character stream */
  return (TcharStream)*pMacTok++;
}

static Ttok peepNxtMacTok(bool mayBeInsideTok)
{
  const TsTok *const savPMacTok = pMacTok, *locPMtok;
  Ttok w;

  if (mayBeInsideTok && InsideInterval(curTok.tok, CSTST, CSTNU1) && pNxtCh==
						 &nxtChFromMac) skipToEndStNu();
  locPMtok = manageJmpTok(pMacTok);
  w = (Ttok)*locPMtok++;
  peepedTokVal = (uint)*locPMtok;
  pMacTok = savPMacTok;
  return w;
}

static TsavTokCtx dfltTokCtx;

Ttok peepNxtTok(void)
/* Peeps next token.
   Current token CANNOT be CSTNU(1) or CSTST (except if already analyzed). */
{
  TdescrId *oldPDCI = pDescTokId;
  bool oldFrstChOfNb = frstChOfNb;
  TvalTok oldCurTok;
  TindentChk oldOldSpCnt = oldSpaceCount, oldSpCnt = spaceCount;
  TmacExpNb oldCMEN = curMacExpNb;
  TmacLvl oldMacLvl = macLvl;
  TmacParCtr oldMacParCtr = macParCtr;
  bool oldSysMacro = sysMacro, oldAdjMacro = adjMacro, oldME = macroExpand;
  Ttok newCurTok;

  if (CurTokNotAnalz()) sysErr(ExCod6);
  if (curTok.tok == IDENT) curTok.IdName = storeName(curTok.IdName,ObjectSpace);
  oldCurTok = curTok;
  getTokLvl++;
  do {GetNxtTok();} while (curTok.tok == SUNDR);
  getTokLvl--;
  if ((newCurTok = curTok.tok) != WHITESPACE) {  /* cf management of ENDDIR (
			  function 'getTokFromMac') in case concatFl!=CNoBit. */
    TsavTokCtx *w;

    if (pTopTokCtx == NULL) w = &dfltTokCtx;  /* just for faster processing
					(most of the times, stack depth < 2). */
    else MyAlloc(w, sizeof(TsavTokCtx));
    w->newCurTok = curTok;
    w->oldMacExpnd = oldME;
    w->newMacExpnd = macroExpand;
    w->newPDCI = pDescTokId;
    w->newFrstChOfNb = frstChOfNb;
    w->newOldSpCnt = oldSpaceCount, w->newSpCnt = spaceCount;
    w->newCMEN = curMacExpNb;
    w->newMacLvl = macLvl;
    w->newMacParCtr = macParCtr;
    w->newSysMacro = sysMacro, w->newAdjMacro = adjMacro;
    w->newPGNT = pCurGNT;
    w->prev = pTopTokCtx;
    pTopTokCtx = w;
    pCurGNT = &restoPeepedTok;}
  curTok = oldCurTok;
  pDescTokId = oldPDCI;
  frstChOfNb = oldFrstChOfNb;
  oldSpaceCount = oldOldSpCnt; spaceCount = oldSpCnt;
  curMacExpNb = oldCMEN;
  macLvl = oldMacLvl;
  macParCtr = oldMacParCtr;
  sysMacro = oldSysMacro; adjMacro = oldAdjMacro;
  macroExpand = oldME;
  return newCurTok;
}

static void restoPeepedTok(void)
{
  TsavTokCtx *w = pTopTokCtx;
  bool oldMacExpnd, newMacExpnd;

  curTok = w->newCurTok;
  pDescTokId = w->newPDCI;
  frstChOfNb = w->newFrstChOfNb;
  oldSpaceCount = w->newOldSpCnt; spaceCount = w->newSpCnt;
  curMacExpNb = w->newCMEN;
  macLvl = w->newMacLvl;
  macParCtr = w->newMacParCtr;
  sysMacro = w->newSysMacro; adjMacro = w->newAdjMacro;
  pCurGNT = w->newPGNT;
  oldMacExpnd = w->oldMacExpnd;
  newMacExpnd = w->newMacExpnd;
  if ((pTopTokCtx = w->prev) != NULL) free(w);
  if (!oldMacExpnd && curTok.tok==IDENT && pDescTokId!=NULL && pDescTokId->
					  nstLvl<0 /* macro */ && macroExpand) {
    getTokLvl++;
    expandMac();
    if (--getTokLvl==tokLvl0 && curTok.tok==IDENT && curTok.ptrSem!=NULL &&
		      curTok.ptrSem->undef && !curTok.ptrSem->modifSJ) errWN(
					   UndfndId|Warn1|Rdbl, curTok.IdName);}
  else macroExpand = newMacExpnd;
  if (getTokLvl == 0) storeTokSource();
}

/*~Undef TsavTokCtx, dfltTokCtx, pTopTokCtx *//*~UndefTag _tSavTokCtx */

static void popCondStk(void)
{
  curIfArmActiv = pTopCondStk->curIfArmActiv;
  trueIfPartSeen = pTopCondStk->trueIfPartSeen;
  elseSeen = pTopCondStk->elseSeen;
  activLvl = pTopCondStk->activLvl;
  oldSpaceCount = pTopCondStk->savOldSpCnt;
  pTopCondStk = freeCondStkElt(pTopCondStk);
}

static void popMacStk(void)
{
  register TmacStkElt *pTMS = pTopMacStk;

  if (pTMS->tArg != NULL) pMacTok = pTMS->pMacTok;  /* not exiting from a '##'
								    operator. */
  concatFl = pTMS->concFl;
  pTopMacStk = freeMacStkElt(pTMS);
}  

static void procCDefined(void)
{
  cExp.uVal = (TcalcU)(searchSymTabHC(curTok.IdName, curTok.hCod)!=NULL ||
			searchSymTab(storeName(curTok.IdName, TagSpace))!=NULL);
  cExp.type = &boolCstTypeElt;
}

static void procDefined(void)
{
  cExp.uVal = (TcalcU)(pDescTokId!=NULL && pDescTokId->nstLvl+1<0);
  if ((bool)cExp.uVal) pDescTokId->nstLvl |= 1 << (MPosFlags + MRPosUsdFl);
  cExp.type = (sysHdrFile && ifDirExp)? &longCstTypeElt : &boolCstTypeElt;
}

static void pushMacStk(void)
{
  register TmacStkElt *w = allocMacStkElt();

  w->pPrevMac = pCurMac;
  w->tArg = pCurMac->tabArg;
  w->pMacTok = pMacTok;
  w->infoM.u11.bid2 = 0;  /* reset flags */
  w->concFl = concatFl;
  if (concatFl != CNoBit)
    if (! (concatFl & CParam)) concatFl |= CParam;
    else concatFl |= CShield;  /* out of reach of current '##' operator */
  w->prev = pTopMacStk;
  pTopMacStk = w;
}

/* restoPeepedTok(void) : see after peepNxtTok(void) */


void restoQuoState(void)
{
  if (savPMTQuo != NULL) {pMacTok = savPMTQuo; savPMTQuo = NULL; freeMacSto(
								 pseudoMacQuo);}
}

static void skipParams(uint parenCtr)
/* Skip (excess) arguments */
{
  for (;; GetNxtTok()) {
    switch (curTok.tok) {
      case ENDDPRAG: dpragNst--; continue;
      case ENDPROG: return;
      case LPAR: parenCtr++; continue;
      case RPAR:
        if (parenCtr == 0) return;
        parenCtr--;
        continue;
      case WHITESPACE:  /* incomplete parameter (may happen because of
							      '##' operator). */
        if (gotOutOfBody) return;
        continue;
      default:
        if (CurTokNotAnalz()) {
          if (curTok.tok == CSTST) analStrCst(NoConv);
          else analNumCst(NoConv);}}}
}

static void skipRestOfLinePhase4(void) /*~NeverReturns*/
{
  condDirSkip = True;  /* to prevent detection of syntax errors that are not
					       errors in preprocessor-tokens. */
  macroExpand = False;
  SkipRestOfLine;
}

static void skipToEndStNu(void)
{
  const TsTok *const savEndCCSB = endCurCharSubBlk;

  while (nxtChFromMac() >= 0) {}
  endCurCharSubBlk = savEndCCSB;
}

static void storeChInFName(Tchar x)
{
  if (isspace(x)) {
    if (chkPortbl && !nonPortFNSeen) {
      err0(NonPortFName|Warn1);
      nonPortFNSeen = True;}}
  else {
    if (posInBufIFN == sizBufIFN) {  /* buffer full */
      sizBufIFN += FILENAME_MAX;
      MyRealloc(bufInclFName, sizBufIFN);}
    bufInclFName[posInBufIFN++] = x;}
}

static void storeEndTok(TdpNst oldDPnst, TsortEndTok sort)
{
  if (dpragNst != oldDPnst) {err0(EndDPExptd); storeMacChunk(ENDDPRAG, NULL,
						     0-0); dpragNst = oldDPnst;}
  storeMacChunk(ENDDIR, NULL, (size_t)sort);
}

static void storeMacChar(char x)
{
  if (pMacSto == endCurMacSto) {
    *pLgtCharSubBlk = (TsTok)(pMacSto - pLgtCharSubBlk);  /* number of character
						    (+1) in filled sub-block. */
    storeMacChunk((Ttok)0, NULL, 0);  /* to get another macro storage block */
    pMacSto -= IncrPMacT - SizOfCharBlkLgtFld;  /* to remove fake 0s */
    pLgtCharSubBlk = pMacSto - SizOfCharBlkLgtFld;}
  *pMacSto++ = (TsTok)x;
}

static void storeMacChunk(Ttok tok, const TsTok *x, size_t size)
/* 'size' is the size of the information pointed by 'x'. Stores 'tok', 'size'
   as TsToks, followed by (if 'x' non NULL) 'size' TsToks. The whole chunk is
   stored contiguously. */
{
  register TsTok *ptr = pMacSto;

  if (((x == NULL)? ptr : ptr + size) + IncrPMacT > endCurMacSto) {  /* not
			enough space at end of current block (there must always
			stay at least one slot for eventual ENDBLK). */
    TmacBlk *nxtBlk;

    if (freeMacBlk != NULL) {nxtBlk = freeMacBlk; freeMacBlk = NULL;}
    else MyAlloc(nxtBlk, sizeof(TmacBlk));
    /*~ zif ((ptrdiff_t)SizeMacroStorageChunk < IncrPMacT + (LgtHdrId +
	MaxLgtId) + IncrPMacT) "SizeMacroStorageBlk too small" */ /* a macro
				storage chunk must be capable of holding at
				once: IDENT, identifier Tname, ENDBLK. */
    ctrMSB++;
    if (ptr == NULL) curMacBlk = (TmacBlk * /*~OddCast*/)&headChainMacBlk;
    /*~ zif Offset(TmacBlk, next) != 0
			    "field 'next' must be first of structure TmacBlk" */
    else {
      *ptr = (TsTok)ENDBLK;  /* marks end of used part of block */
      *(ptr + 1) = (TsTok)(ptr - (TsTok *)curMacBlk);}  /* displacement to
				    beginning of current macro storage block. */
    /*~zif (SizeMacroStorageBlk > (1 << sizeof(TsTok)*CHAR_BIT) + sizeof(TsTok))
					      "SizeMacroStorageBlk too large" */
    curMacBlk->next = nxtBlk;  /* chain new block */
    nxtBlk->prec = curMacBlk;
    nxtBlk->next = NULL;
    ptr = &(nxtBlk->tokSto[0]);
    endCurMacSto = &(nxtBlk->tokSto[(TsTok)SizeMacroStorageChunk - IncrPMacT]);
    curMacBlk = nxtBlk;
    pHeadChain = &(nxtBlk->headChain);
    *pHeadChain = 0;}  /* no macro header yet in new block */
  *ptr++ = (TsTok)tok;		/* store first cTok */
  *ptr++ = (TsTok)size;		/* 'size' used as second cTok */
  if (x != NULL) {memcpy(ptr, x, size); ptr += size;}
  pMacSto = ptr;
}

static void storeTok(void)
{
  Ttok currTok;

  switch (currTok = curTok.tok) {
    TsTok *oldPMS;

  case IDENT:
    if (isMacPar()) {  /* macro parameter */
      TsemanElt *pSem = curTok.ptrSem;

      storeMacChunk((!pSem->reallyUsed || pSem->usedMorThOnce || dpragNst!=0)?
					   MACPAR : MACPAR1, NULL, pSem->noPar);
      if (! pSem->defnd) {
        errWN(NotUsdPar|Warn1|Rdbl, curTok.IdName);
        if (! allErrFl) pSem->defnd = True;}
      else {
        if (dpragNst == 0) {
          if (pSem->reallyUsed) pSem->usedMorThOnce = True;
          else pSem->reallyUsed = True;}
        pSem->used = True;}
      return;}
    oldPMS = pMacSto;
    storeMacChunk(currTok, (const TsTok *)curTok.IdName,FullLgt(curTok.IdName));
    goto endCST;
  case CSTNU: if (sysHdrFile) currTok = CSTNU1;
    /*~NoBreak*/
  case CSTNU1: case CSTST: {
      TsTok w;

      if (macIsSymb) {errWN(NameSymbLoCase|Warn1|Rdbl, pMacBeingDfnd->idName)
							   ; macIsSymb = False;}
      oldPMS = pMacSto;
      storeMacChunk(currTok, /*~Init w*/&w, 1);  /* so that length of 1st
				   sub-block inside same macro storage block. */
      pLgtCharSubBlk = pMacSto - SizOfCharBlkLgtFld;
      if (currTok == CSTST) {
        analStrCst(&storeMacChar);
        if ((bool)curTok.val) currTok = WHITESPACE + 1;}  /* wide-character
								      string. */
      else analNumCst(&storeMacChar);
      *pLgtCharSubBlk = (TsTok)(pMacSto - pLgtCharSubBlk);  /* number of
					 characters (+1) in ending sub-block. */
      storeMacChunk((Ttok)0, NULL, 0); pMacSto--;  /* end marker = 0 (only one
								byte needed). */
      /*~zif ENDBLK == (Ttok)0 "ENDBLK must be non-zero" */
      goto endCST;}
  case FORCEMACEXP: case NOMACEXP:
    oldPMS = pMacSto;
    storeMacChunk(currTok, (TsTok *)&pDescTokId, sizeof(pDescTokId));
endCST:
    /* Find beginning of stored token and replace its code by IDSTNU (in anti-
       cipation of possible '##' operator). */
    GetTokAdr(oldPMS);
    *(oldPMS + 1) = (TsTok)currTok;  /* real token value as extension */
    *oldPMS = (TsTok)IDSTNU;
    break;
  case ENDDPRAG: dpragNst--; /*~NoBreak*/
  default: storeMacChunk(currTok, NULL, curTok.val);}
}

bool visibleFromMac(const TsemanElt *pTag)
{
  const TmacStkElt *w;

  if (isFNameVisible(pCurMac->dFileName, pTag)) return True;
  /* Find if possible calling macro(s) defined in visible file */
  for (w = pTopMacStk; w->prev != NULL; w = w->prev) if (IsMacroFrame(w) &&
		      isFNameVisible(w->pPrevMac->dFileName, pTag)) return True;
  return False;
}

/* End DCDIR.C */
