/* DCEXP.C */
/* Y.L. Noyelle, Supelec, France 1994 */

#if defined(__linux__) && !defined(_GNU_SOURCE)
#  define _GNU_SOURCE  /* pour LONG_LONG_MIN */
#endif
#include <string.h>
#include <ctype.h>
#include "dcexp.h"
#include "dcexp.ph"
#include "dcblk.h"
#include "dcdecl.h"
#include "dcdir.h"
#include "dcext.h"
#include "dcfmt.h"
#include "dcinst.h"
#include "dcinst.ph"
#include "dcprag.h"
#include "dcrec.h"
#include "dctxttok.h"

#ifdef VMS
#pragma noinline (arrToPtr, checkNumCstNamed, checkPureBool, errSinkType)
#pragma noinline (errCompoOf, errExp, errOvfl, errOvfl1, errUdfl, errWrngType)
#pragma noinline (finalizeCast, freeAlloc, freePrevCast, ignorableDP)
#pragma noinline (insertBool, manageLogOper, managePredefTypes, manageSetjmp)
#pragma noinline (modifPtdVal, transfOpnd, typeToS2NoQual, warnCstBool)
#pragma noinline (warnNotPureBool, warnOrErr)
#if defined(LONGLONG) || ULONG_MAX /* not _MAXC ! */>UINT_MAXC
#  pragma noinline (manageLeftBits)
#  endif
#endif

#define ArbitAdr	QuasiNULLval(char *)  /* arbitrary */
#define CheckSink(pExp, sinkType)					       \
  ((pExp)->rEvlbl && sinkType!=NULL && sinkType->litCsta)
#define DefLastPrimMacPar(x)						       \
  do {									       \
    lastPrimMacParCtrIM = 0;						       \
    lastPrimMacParCtr = x;						       \
    if (insideMultUsedMacPar) lastPrimMacParCtrIM = x;			       \
  } while (False)
#define IsDecl1(x)	InsideInterval(curTok.tok, x, EDecl - 1)
#define IsSideEffect(x)	InsideInterval(NakedTok(x.topOper), BSideEffTok,       \
							      ESideEffTok - 1)
#define IsWhoEnumNotChar(x)						       \
  (IsTypeSort(x, Who) || IsTypeSort(x, Enum) && x->tagId!=NULL)
#define NakedTok(x)	(x & ~(PARENSEEN | PRIMARY | SETJMPUSED))
#define NoResulTyp	QuasiNULLval(TpTypeElt)
#define PtrdiffTHCode	0x180904D
#define PtrdiffTName	"\x9\0ptrdiff_t"
#define PureUnsig(t)	(t->typeSort & UnsigWho)
#define SetInfoForCst							       \
  cExp.rEvlbl = True;							       \
  if (! evaluateFl) cExp.errEvl = True;  /* to prevent computation */
#define SizeTHCode	0x321B8
#define SetjmpHCode	0x31539
#define SetjmpTName	"\6\0setjmp"
#define SizeTName	"\6\0size_t"
#define SubOP		(ADDOP | NONASSOC)
#define TstAlwdInCstExp() if (cstExpAsked && evaluateFl) err0(OperIlgInCstExp)
#define WcharTHCode	0x102511
#define WcharTName	"\7\0wchar_t"
#define XAllocSeen	QuasiNULLval(TpcTypeElt)

DefIsSameName  /* define isSameName function */
DefRepresType  /* define represType function */

typedef enum {Composite = -1, NotMember, Member, SingleMember} Tmember;
typedef enum {WCHAR_T, SIZE_T, PTRDIFF_T} TpredefTypes;

/* Function profiles */
static TpcTypeElt arrToPtr(TpcTypeElt);
static void condExpr(void), primQualif(void),
  term0(void), term1(void), term2(void), term3(void), term4(void), term5(void),
  term6(void), term7(void), term8(void), term9(void), term10(void);
static void computeCond(TpcTypeElt), computeShortCircuit(TpcTypeElt),
  computeIor(TpcTypeElt), computeXor(TpcTypeElt), computeAnd(TpcTypeElt),
  computeCmp(TpcTypeElt), computeShi(TpcTypeElt), computeAdd(TpcTypeElt),
  computeSub(TpcTypeElt), computeMul(TpcTypeElt), computeDiv(TpcTypeElt),
  computeMod(TpcTypeElt);
static bool authzdType(TpcTypeElt, TtypeSort, bool *, Terr),
  compatNumType(void), errSinkType(Terr, Tstring) /*~PseudoVoid*/,
  errWrngType(TtypeSort) /*~PseudoVoid*/, frstMemberCompat(TpcTypeElt,
  TtypeSort), ignorableDP(TmacParCtr), isType(void), manageInitlzUsed(void)
  /*~PseudoVoid*/, manageTypCmbn(TkOpTC) /*~PseudoVoid*/, resulExp(TtypeSort,
  bool, void(*)(TpcTypeElt), TmacLvl, Ttok) /*~PseudoVoid*/;
static void castValue(TtypeSort), checkIncldFiles(const TsemanElt *),
  checkInfoLoss(TpcTypeElt), checkPureBool(void), createBoolResult(void),
  errCompoOf(bool), errExp(Terr, TpcTypeElt, Tstring),
  errOvfl(TpcTypeElt), errOvfl1(TpcTypeElt, Tstring), errUdfl(void),
  finalizeCast(TpcTypeElt /*~MayModify*/), freeAlloc(void), freePrevCast(void),
  indir(void), indirindex(const TresulExp * /*~MayModify*/), insertBool(
  TtypeSort), manageLogOper(void (*pf)(void), Ttok, bool, Tstring),
  manageNumCst(void), managePointers(TpcTypeElt), manageSetjmp(void),
  manageUsedForIncOp(void), modifPtdVal(Terr), resulIncOp(TkInc,TmacParCtr),
  resulUnOp(TtypeSort, Tstring), specialCaseOp(TkAdd),
  transfOpnd(const TresulExp * /*~MayModify*/, TresulExp *), valueNotUsed(void),
  verifCstOvfl(void), warnCstBool(Tstring),
  warnNotPureBool(TresulExp *, Tstring);
static TpcTypeElt advInTypeChain(TpcTypeElt), commonType(TtypeSort),
  managePredefTypes(TpredefTypes);
static TtypeSort computeCstType(TcalcS, TtypeSort, TtypeSort), computeTypeSort(
  TcalcS, TtypeSort, TtypeSort), computeLstType(TcalcS);
static TpTypeElt copyTypeEltNoOwn(TpcTypeElt /*~MayModify*/);
static Tmember isMember(const TresulExp *);
static size_t sizeOfTypeI(TpcTypeElt, bool, Terr, Tstring);
static Tstring typeToS2NoQual(TpcTypeElt);
static Terr warnOrErr(Terr);
#if defined(LONGLONG) || ULONG_MAX /* not _MAXC ! */>UINT_MAXC
static void manageLeftBits(void);
#endif

/* Global objects */
static TpcTypeElt allocType = NULL;  /* type of 'sizeof' argument for
					     ~SizeOfMemBlk function argument. */
static bool apsndOpnd = False;  /* True when inside operand of '&' operator */
static bool chkNumCst1 = True;
static Terr convToUnsgnd;
static bool cstExpAsked = False;
static bool errAsgn;
static bool evaluateFl = True;
static bool initDPFl = False;
static TsemanElt *lastCalledFct;
static TmacParCtr lastPrimMacParCtr, lastPrimMacParCtrIM;
static TtypeSort mskCmpat = NumEnumBool;  /* default value */
static TmacLvl pLCMacLvl;
static TpcTypeElt preLastCastType = NULL;  /* type before previous cast */
static TpcTypeElt sizeofOpndType = NULL;
static bool stddefIncldFl;  /* flag to output message only once */

/* External objects */
TpcTypeElt *limErroTypes;  /* to prevent multiple (same) errors in
							     initializations. */
TtypeSort mskBool;
Trchbl nxtStmtRchbl;  /* next statement reachable ? */


bool boolExp(Tstring operTxt)
/* Returns True if boolean expression correct and constant */
{
  TpcTypeElt eType = cExp.type;

  if (cExp.ValMltplDef) cExp.rEvlbl = False;
  checkInit();
  CheckNumCstNamed(cExp, eType);
  if (*operTxt != 'i') cleanExprThings();  /* test "if" (because of setjmp
								 management). */
  if (eType != NULL) {
    if (! IsTypeSort(eType, Bool)) {
      if (NakedTok(cExp.topOper) == ASGNOP) err0(MsngEqual | Warn3);
      else {
        Terr n = (IsScalar(eType))? BoolExptd | CWarn1 : BoolExptd;

        if (chkBool || !(n & WarnMsk)) errWSTT(n, operTxt, eType, NULL);}}
    else if (cExp.rEvlbl) warnCstBool(NULL);
    FreeExpType2(eType);}
  return cExp.rEvlbl;
}

bool correctExprN(TpcTypeElt exptdType, TtypeSort msk, bool cstExp, Tstring
						     operName, bool checkNumCst)
/* Gets a asgnExpr, and detects an error if type of gotten expression not com-
   patible with 'exptdType' and/or 'msk', or if 'cstExp' = True and expression
   not constant.
   Returns False if gotten expression incorrect, or if type mismatch (cExp.type
   == NULL in both cases).
   Frees expression type only if exptdType != NoFreeExpType.
   Does not exit via 'longjmp', either directly or indirectly.
   Can be called recursively (because of 'zif'). */
{
  bool resul, freeExpType = (exptdType != NoFreeExpType), savChkNumCst1 =
								     chkNumCst1;
  const Tstring savParamTxt = paramTxt;
  TpcTypeElt eType;
  TpTypeElt newElt;

  chkNumCst1 = checkNumCst;
  if (! alrdAnalzdExp) {
    bool savEvalFl = evaluateFl, savCstExpAskd = cstExpAsked;
    TsemanElt *savLCF = lastCalledFct;

    cstExpAsked = cstExp;
    evaluateFl = True;
    ignoreErr = False;
    asgnExpr();
    if (cExp.ValMltplDef) cExp.rEvlbl = False;
    cstExpAsked = savCstExpAskd;
    evaluateFl = savEvalFl;
    lastCalledFct = savLCF;}
  else alrdAnalzdExp = False;
  paramTxt = operName;  /* also for managePointers() */
  eType = cExp.type;
  if (msk != Void) {
    if (exptdType > NoFreeExpType) {
      newElt = allocTypeEltIC(exptdType, NoQualif);
      newElt->typeSort |= msk;}
    else {
      newElt = allocTypeEltID(msk, NoQualif);
      newElt->tagId = (eType!=NULL && IsTypeSort(eType, Enum))? eType->tagId
			      : GenericEnum;}  /* in case msk includes 'Enum' */
    newElt->noOwner = True;
    exptdType = newElt;}
  else newElt = NULL;
  CheckNumCstNamed(cExp, exptdType);
  lExp.ptrId = pIdInit;   /* for		*/
  lExp.type = exptdType;  /*     modifPtdVal(). */
  if (eType != NULL) {
    resul = True;
    if (exptdType != NULL) {
      if (! freeExpType) heedRootType = False;  /* for then msk!=Void */
      if (exptdType->typeSort >= DelType) { /* type expansion not needed */
        errQalTyp1 = NULL;
        if (! CompatType(exptdType, eType, Asgn)) resul = False;
        else if (errQalTyp1 != NULL) {  /* report only one of many possible
				 error messages due to bad 'const' qualifier. */
#define MaxNbRmbrdTypes		10
          static TpcTypeElt rmbrdErroTypes[MaxNbRmbrdTypes];
          const TpcTypeElt *ptrErroTypes;

          if (msk!=Void || limErroTypes==NULL) limErroTypes= &rmbrdErroTypes[0];
          else if (! allErrFl)
            for (ptrErroTypes = &rmbrdErroTypes[0]; ptrErroTypes !=
							       limErroTypes; ) {
              if (*ptrErroTypes++ == errQalTyp1) goto noErrL;}
          errWSSSS(ConstQalNotHeeded1|ConstWarn|PossErr, paramTxt,
	      typeToS2NoQual(errQalTyp1), typeToS1(errQalTyp2), (errQalTyp1 ==
					     exptdType)? NULL : errTxt[SubPre]);
          if (limErroTypes <= &rmbrdErroTypes[MaxNbRmbrdTypes - 1]
						 ) *limErroTypes++ = errQalTyp1;
#undef MaxNbRmbrdTypes
noErrL:;}}
      else if (! compatNumType()) resul = False;
      heedRootType = True;}
    if (! resul) {
      if (msk==Void && IsCmpsd(exptdType) && warnOrErr(NoErrMsg)==NoErrMsg
		) alrdAnalzdExp = True;  /* because of possible elided '{' in
						initialization list => retry. */
      else if (errSinkType((msk == Void)? BadForLftType|PossErr|CWarn :
		  NotExptdType|PossErr|CWarn, typeToS2NoQual(exptdType)) &&
					 ifDirExp && cExp.rEvlbl) resul = True;}
    else if (cstExp) {
      if (! cExp.rEvlbl) {
        err0(CstExpExptd);
        if (freeExpType) resul = False;
        cExp.errEvl = True;}
      else if (IsPtrArr(eType) && cExp.pseudoAttrib>=Auto) {err0(UncomputAd)
							      ; resul = False;}}
    managePointers(exptdType);
    if (! cExp.rEvlbl)
#if PtrGtLong
      cExp.pVal = NULL;
#else
      cExp.sVal = 0;
#endif
    if (resul && !freeExpType) {
      if (eType->generic) ((ModifType)(cExp.type = copyTypeEltNoOwn(eType)))->
		generic = False;}  /* for array bound (cf. index type
					   verification if of parallel type). */
    else if (! alrdAnalzdExp) {/* do not free expression that will be re-used */
      FreeExpType2(eType);
      if (! freeExpType) cExp.type = NULL;}}
  else resul = False;
  FreeExpType1(newElt);
  chkNumCst1 = savChkNumCst1;
  paramTxt = savParamTxt;
  return resul;
}

void commaExpr(void)
/* Does not exit via 'longjmp', either directly or indirectly */
{
  bool commaSeen = False;

  while (asgnExpr(), curTok.tok == COMMA) {
    checkSideEffect();
    if (! commaSeen) {
      TstAlwdInCstExp();
      commaSeen = True;}
    GetNxtTok();}
  if (commaSeen) cExp.lValFl = False;
}

void asgnExpr(void)
{
  TmacParCtr begAsgnMacParCtr = macParCtr;

  condExpr();
  if (curTok.tok == ASGNOP) {
    TkAsgn kindAsgn;
    TresulExp slExp;		/* left operand saving */
    register TsemanElt *ptrLId;
    TpcTypeElt lType, eType;
    TmacParCtr operMacParCtr = lastPrimMacParCtrIM;
    bool lclAdrSeen, ignorable;

    TstAlwdInCstExp();
    kindAsgn = (TkAsgn)curTok.val;
    if ((lType = cExp.type) != NULL) {  /* no type error seen in left operand */
      paramTxt = txtAsgnTok[kindAsgn];
      if (! cExp.lValFl) {errWSS(NotLVal, paramTxt, errTxt[Left]); cExp.ptrId
									= NULL;}
      else if (lType->typeSort==Void || IsArrFct(lType)) errWSTT(IlgLftType,
					     txtAsgnTok[kindAsgn], lType, NULL);
      else {
        bool isConst = False;

        if (lType->qualif & ConstQal) isConst = True;
        if (IsStrun(lType)) {
          if (BaseStrunType(lType)->SynthQualif & ConstQal) isConst = True;
          (void)sizeOfTypeI(lType, False, IncplStrunType, paramTxt);}
        if (isConst) errCompoOf(lType->qualif & ConstQal);
        else if (cExp.PointedByObj) modifPtdVal(WillM);}}
    CheckNumCstNamed(cExp, lType);
    valueNotUsed();
    slExp = cExp;
    GetNxtTok();
    asgnExpr();
    lExp = slExp;
    ptrLId = slExp.ptrId;
    CheckNumCstNamed(cExp, lType);
    if (NakedTok(cExp.topOper) == ASGNOP) valueNotUsed();  /* so that "i=j=1"
						      does not mark 'j' used. */
    paramTxt = txtAsgnTok[kindAsgn];
    if (lclAdrSeen = IsDP(LOCALADR)) ignorable = ignorableDP(begAsgnMacParCtr);
    if ((eType = cExp.type)!=NULL && lType!=NULL) {
      errAsgn = False;
      switch(kindAsgn) {
        case SimplAsgn:
          if (IsPtr(eType)) {
            if (cExp.lclAdr) {
              if (InsideInterval(lExp.pseudoAttrib, StatiL, Extrn)) {  /* non-
								local object. */
                if (! lclAdrSeen) err0(AsgnGblWLclAd|Warn2|PossErr);
                else lclAdrSeen = False;
                cExp.lclAdr = False;}
              else if (ptrLId != NULL) ptrLId->lclAd = True;}
            else if (condStmtLvl==0 && ptrLId!=NULL && ptrLId->lclAd &&
				     IsPtr(ptrLId->type)) ptrLId->lclAd = False;
            if (ignorable) lclAdrSeen = False;}
          if (compatNumType()) {
            if (eType->generic) {
              cleanExprThings();
              FreeExpType2(lType);  /* free left operand type (not right ope-
			  rand), to allow "int = unsigned short = float = 0". */
              if (cExp.rEvlbl) {lExp.rEvlbl = True; lExp.errEvl = cExp.errEvl;}
              goto exit1L;}}
          else if ((lType->typeSort==Ptr || IsStrun(lType)) && (errQalTyp1 =
					NULL, CompatType(lType, eType, Asgn))) {
            if (errQalTyp1 != NULL) errWSTTS(ConstQalNotHeeded1|ConstWarn|
		    PossErr, paramTxt, errQalTyp1, errQalTyp2, (errQalTyp1 ==
						lType)? NULL : errTxt[SubPre]);}
          else errAsgn = True;
          goto exitL;
        case AndAsgn:
          if (cExp.rEvlbl
#if defined(LONGLONG) || ULONG_MAX /* not _MAXC ! */>UINT_MAXC
                         ) manageLeftBits();
#else
			  && cExp.sVal<0) cExp.uVal = ~cExp.uVal;  /* for no
	 wrong overflow error detection (cf. "ushort INDIC &= ~0u ^ 0x8000;". */
#endif
          /*~NoBreak*/
        case XorAsgn:
          if (lType->typeSort == Bool) checkPureBool();
          goto commonBitOpL;
        case IorAsgn:
          if (lType->typeSort==Bool && cExp.notPureBool && ptrLId!=NULL &&
				!IsPtr(ptrLId->type)) ptrLId->notPureBoo = True;
          if (lExp.notPureBool) cExp.notPureBool = True; /* does also .lclAdr */
commonBitOpL:
          mskCmpat = WhoEnumBool;
          break;
        case LShAsgn:
        case RShAsgn:
          if (lType->typeSort==Void || IsArrFct(lType)) lExp.type = NULL;  /*
	       these IlgLftType checked earlier (BEWARE, lType still used !). */
          if (! IsTypeSort(lType, WhoEnum)) errWrngType(WhoEnum);
          else if (! IsWhoEnumNotChar(eType)) errExp((IsTypeSort(eType,WhoEnum)
			 )? IlgRhtType|Warn2|PossErr : IlgRhtType, eType, NULL);
          goto endCAsgnL;
        case AddAsgn:
        case SubAsgn:
          mskCmpat = NumEnum;
          goto commonArithOpL;
        case MulAsgn:
        case DivAsgn:
          mskCmpat = Num;
          goto commonMulOpL;
        case ModAsgn:
          mskCmpat = Who;
commonMulOpL:
          if (! eType->NxtIsTypId) ((ModifType)(cExp.type = copyTypeEltNoOwn(
		eType)))->generic = True;  /* because multiplication =
						       sequence of additions. */
commonArithOpL: {
            TpcTypeElt w;

            if (pHeadTCBLists!=NULL && (w = searchTC(AddTC + (kindAsgn -
		 AddAsgn)))!=QuasiNULLval(TpcTypeElt) && (w==NULL || w->typeId
					      ==lType->typeId)) goto endCAsgnL;}
          if (eType->typeSort==Enum && !IsPtr(lType)) goto errAsgnL;
          break;}
      if (! compatNumType()) 
        if (InsideInterval(kindAsgn, AddAsgn, SubAsgn)) specialCaseOp(
								    AddSubAsgn);
        else
errAsgnL: errAsgn = True;
endCAsgnL:
      mskCmpat = NumEnumBool;  /* back to default value */
      cExp.rEvlbl = False;
exitL:
      if (errAsgn && !(lType->typeSort==Void || IsArrFct(lType)) /* IlgLftType
							     checked earlier */)
        errSinkType(BadForLftType|PossErr|CWarn, typeToS2NoQual(lType));}
    managePointers(lType);
    FreeExpType(cExp); /* errExp() may have been called, so don't use 'eType' */
    cExp.type = lType;
exit1L:
    if (lclAdrSeen) errIlgDP(LOCALADR);
    cExp.ptrId = ptrLId;
    lExp.notPureBool = cExp.notPureBool;  /* keep that flag (also lclAdr) */
    cExp.Einfo = lExp.Einfo;
    /* Here so that done even if r/lType == NULL */
    if (kindAsgn == SimplAsgn) {
      cExp.hist = lExp.hist;
      if (ptrLId != NULL) {
        if (manageInitlzUsed()) {
          cExp.oldUsed = False;
          ptrLId->used = False;
          ptrLId->MsngConstQM = False;}
        if (setjmpBlkLvl != 0) {
          if (setjmpBlkLvl>0 || longjmpCondLvl==0 && condStmtLvl!=0
							      ) manageSetjmp();}
        else if (longjmpCondLvl!=0 && longjmpCondLvl==condStmtLvl &&
							   !lExp.PointedByObj) {
          ptrLId->modifSJ = True;
          ptrLId->undef = True;}}
      cExp.topOper = ASGNOP;}  /* top operator of the syntax tree */
    else manageUsedForIncOp();
    if (cExp.notPureBool && lType!=NULL && lType->typeSort==Bool && ptrLId!=
			  NULL && !IsPtr(ptrLId->type) && !ptrLId->notPureBoo) {
      if (ptrLId->pureBoolAskd && !cExp.inhibWaNPB) {errWSS(Outside01|Warn2|
		     PossErr, paramTxt, errTxt[Right]); cExp.inhibWaNPB = True;}
      ptrLId->notPureBoo = True;}
    if (operMacParCtr!=0 && lastPrimMacParCtrIM==operMacParCtr) err1(
						 SideEffInMacPar|Warn3|PossErr);
    cExp.lValFl= False;}  /* the value of an assignment is not an l-value */
}

static void condExpr(void)
{
  term0();
  if (curTok.tok == QMARK) {
    TresulExp expB, slExp, scExp;
    TmacLvl operMacLvl;
    Trchbl endFrstBrchRchbl;
    bool savEvalFl = evaluateFl, sideEffect;

    (void)boolExp("?");
    if (! (cExp.topOper & PARENSEEN)) err0(ShdBePrntzBool|CWarn1|Rdbl);
    expB = cExp;
    if (expB.rEvlbl && expB.uVal==0) evaluateFl = False;
    condStmtLvl++;
    GetNxtTok();
    commaExpr();
    operMacLvl = macLvl;
    if (! Found(COLON)) err0(ColExptd);
    endFrstBrchRchbl = nxtStmtRchbl;
    nxtStmtRchbl = Rchbl;
    slExp = cExp;
    evaluateFl = (expB.rEvlbl && expB.uVal!=0)? False : savEvalFl;
    condExpr();
    evaluateFl = savEvalFl;
    {
      bool lSideEffect = IsSideEffect(slExp), rSideEffect = IsSideEffect(cExp);

      if (expB.rEvlbl) {
        condStmtLvl--;
        if (expB.uVal != 0) {
          nxtStmtRchbl = endFrstBrchRchbl;
          transfOpnd(&slExp, &cExp);
          rSideEffect = True;}
        else {transfOpnd(&cExp, &slExp); lSideEffect = True;}}
      sideEffect = lSideEffect && rSideEffect;}
    lExp = slExp;
    paramTxt = ":";
    scExp = cExp;
    if (lExp.type == NULL) lExp.type = cExp.type;
    else if (cExp.type == NULL) cExp.type = lExp.type;
    if (! resulExp(NumEnumBool | PtrPoss | StrunPoss, False, &computeCond,
							   operMacLvl, QMARK)) {
      TpcTypeElt curLType = lExp.type, curRType = cExp.type;
      bool rhtHghrParal = False;

      if (!CompatType(curLType, curRType, LitString) && !(rhtHghrParal = True,
		      compatType(curRType, curLType, LitString))) errWrngType(
						 NumEnumBool|PtrPoss|StrunPoss);
      else {
        curLType = arrToPtr(curLType);  /* for string literal case */
        curRType = arrToPtr(curRType);  /* for string literal case */
        if (curLType != curRType) {
          TpcTypeElt wL, wR;

          if (IsPtr(curLType) && (wL = NxtTypElt(curLType))!=(wR = NxtTypElt(
								   curRType))) {
            /* Create a result type chain that inherits qualifiers from both
               arms of the conditional; if one arm is string litteral,
               result is pointer. */
            TpTypeElt resType, lastNewElt = NULL;

            cExp.ArtifType =
		(   wL!=NULL && wL->typeSort==Void && !(lExp.rEvlbl && lExp.
								      uVal==0)
		 || wR!=NULL && wR->typeSort==Void && !(cExp.rEvlbl && cExp.
								      uVal==0));
            /* Choose higher parallel type or non-generic 'void *' arm */
            if (rhtHghrParal) {
              TpcTypeElt w;;w = curRType; curRType = curLType; curLType = w;}
            do {
              TpTypeElt newElt;

              newElt = allocTypeEltIC(curLType, curRType->qualif);
              if (lastNewElt == NULL) {
                resType = newElt;
                resType->noOwner = True;}  /* for freeing purposes */
              else {
                lastNewElt->stopFreeing = False;  /* because full created
							   chain to be freed. */
                lastNewElt->nextTE = newElt;}
              lastNewElt = newElt;
            } while (!curLType->NxtIsTypId && (curLType = advInTypeChain(
			      curLType))!=NULL && (curRType = advInTypeChain(
					curRType))!=NULL && curLType!=curRType);
            FreeExpType1(curRType);
            cExp.type = resType;}
          else if (! rhtHghrParal) {
            cExp.type = curLType;
            curLType = curRType;}}}
      if (scExp.ptrId!=NULL && (cExp.ptrId==NULL || scExp.ptrId->type!=NULL &&
						  IsStrun(scExp.ptrId->type))) {
        cExp.ptrId = scExp.ptrId;
        cExp.hist = scExp.hist;
        cExp.PointingOnObj = scExp.PointingOnObj;}
      else cExp.PointedByObj = slExp.PointedByObj;
      if (slExp.ptrId != scExp.ptrId) {
        if (slExp.ptrId!=NULL && slExp.PointingOnObj) slExp.ptrId->used = True;
        if (scExp.ptrId!=NULL && scExp.PointingOnObj) scExp.ptrId->used = True;}
      if (! lExp.FctCallNoResTyp) cExp.FctCallNoResTyp = False;
      if (curLType != cExp.type) FreeExpType1(curLType);
      freePrevCast();}
    cExp.topOper = (sideEffect)? SIDEFF : QMARK;
    if (expB.rEvlbl)
      if (expB.errEvl) cExp.errEvl = True;
      else
        if (expB.uVal != 0) {
          cExp.ptrId = slExp.ptrId;
          cExp.PointedByObj = slExp.PointedByObj;}  /* other relevant fields
						   already set by 'resulExp'. */
        else {
          cExp.ptrId = scExp.ptrId;
          cExp.hist = scExp.hist;
          cExp.PointingOnObj = scExp.PointingOnObj;} 
    else {
      condStmtLvl--;
      cExp.ValMltplDef = True;
      if (lExp.notPureBool) cExp.notPureBool = True;  /* does also cExp.lclAdr
							      |= lExp.lclAdr. */
      if (lExp.inhibWaNPB) cExp.inhibWaNPB = True;
      if (lExp.FctCallSeen1) {
        cExp.FctCallSeen1 = True;
        if (lExp.FctCallSeen) cExp.FctCallSeen = True;}
      if (cExp.type == &boolCstTypeElt) cExp.type = &boolTypeElt;
      if (endFrstBrchRchbl == Rchbl) nxtStmtRchbl = Rchbl;}
    if (expB.litCst) {
      cExp.litCst = True;
      if (expB.LitCstOutsMac) cExp.LitCstOutsMac = True;}}
}

static void computeCond(TpcTypeElt x)
/* Keep greatest absolute value, without loosing possible sign... */
{
  if (IsTypeSort(x, SigAri | Enum)) {
    bool negSeen = (lExp.sVal < 0);
#define Abs(x) ((x >= 0)? x : -x)

    if (Abs(lExp.sVal) > Abs(cExp.sVal)) {
      if (cExp.sVal < 0) negSeen = True;
      cExp.sVal = lExp.sVal;}
    if (cExp.sVal>0 && negSeen) cExp.sVal = - cExp.sVal;}
#undef Abs
  else if (lExp.uVal > cExp.uVal) cExp.uVal = lExp.uVal;
}

static void term0(void)
{
  term1();
  while (curTok.tok == LOGOR) manageLogOper(&term1, curTok.tok, True, "||");
}

static void term1(void)
{
  term2();
  while (curTok.tok == LOGAND) manageLogOper(&term2, curTok.tok, False, "&&");
}

static void computeShortCircuit(TpcTypeElt x /*~NotUsed*/)
{
  if (cExp.uVal != 0) cExp.uVal = 1;
}

static void term2(void)
{
  term3();
  while (curTok.tok == IOR) {
    TresulExp slExp = cExp;		/* left operand saving */
    TmacLvl operMacLvl = macLvl;
    TtypeSort rExpTypeSort;

    GetNxtTok();
    term3();
    lExp = slExp;
    paramTxt = "|";
    if (cExp.type != NULL) rExpTypeSort = cExp.type->typeSort;
    resulExp(WhoEnumBool, False, &computeIor, operMacLvl, IOR);
    insertBool(rExpTypeSort);}
}

static void computeIor(TpcTypeElt x /*~NotUsed*/)
{
  cExp.uVal |= lExp.uVal;
}

static void term3(void)
{
  term4();
  while (curTok.tok == XOR) {
    TresulExp slExp = cExp;		/* left operand saving */
    TmacLvl operMacLvl = macLvl;
    TtypeSort rExpTypeSort;

    GetNxtTok();
    term4();
    lExp = slExp;
    paramTxt = "^";
    checkPureBool();
    if (cExp.type != NULL) rExpTypeSort = cExp.type->typeSort;
    resulExp(WhoEnumBool, False, &computeXor, operMacLvl, XOR);
    insertBool(rExpTypeSort);}
}

static void computeXor(TpcTypeElt x /*~NotUsed*/)
{
  cExp.uVal ^= lExp.uVal;
}

static TcalcU savCExpVal;

static void term4(void)
{
  term5();
  while (curTok.tok == APSAND) {
    TresulExp slExp = cExp;		/* left operand saving */
    TmacLvl operMacLvl = macLvl;
    TtypeSort rExpTypeSort;
    bool is01 = False;

    GetNxtTok();
    term5();
    lExp = slExp;
    paramTxt = "&";
    checkPureBool();
    if (cExp.type != NULL) rExpTypeSort = cExp.type->typeSort;
    if (cExp.rEvlbl)
      if ((savCExpVal = cExp.uVal) <= 1) is01 = True;
      else 
#if defined(LONGLONG) || ULONG_MAX /* not _MAXC ! */>UINT_MAXC
        manageLeftBits();
#else
        if (cExp.sVal < 0) cExp.uVal = ~cExp.uVal;  /* for no wrong overflow
			error detection (cf. "ushort INDIC &= ~0u ^ 0x8000;". */
#endif
    resulExp(WhoEnumBool, True, &computeAnd, operMacLvl, AND);
    insertBool(rExpTypeSort);
    if (is01) cExp.notPureBool = False;}
}

static void computeAnd(TpcTypeElt x /*~NotUsed*/)
{
  cExp.uVal = lExp.uVal & savCExpVal;
}

/*~Undef savCExpVal*/

static TkCmp operCmp;		/* limited extent */
static void checkCmpdTypes(void);  /* limited extent */
#pragma noinline (checkCmpdTypes)

static void term5(void)
{
  term6();
  while (curTok.tok == EQUALOP) {
    TkCmp oper;
    TresulExp slExp = cExp;		/* left operand saving */
    TmacLvl operMacLvl = macLvl;
    Ttok topOper = EQUALOP | NONASSOC;

    oper = (TkCmp)curTok.val;		/* operator in class EqualOp */
    GetNxtTok();
    term6();
    lExp = slExp;		/* left operand */
    operCmp = oper;
    paramTxt = txtCmpTok[oper];
    verifCstOvfl();
    if (cExp.rEvlbl)
      if (cExp.uVal!=0) {if (! cExp.errEvl) checkPureBool();}
      else if (lExp.SjVal) {topOper |= SETJMPUSED; longjmpTaken = (oper != EQ);}
    if (! resulExp(NumEnumBool | PtrPoss, True, &computeCmp, operMacLvl,
								     EQUALOP)) {
      checkCmpdTypes();
      if (cExp.rEvlbl) cExp.uVal = (TcalcU)((oper == EQ)? lExp.pVal ==
		     cExp.pVal : lExp.pVal != cExp.pVal);}  /* compute result */
    else if (cExp.type!=NULL && IsTypeSort(cExp.type, Flt) && !FoundDP(EXACTCMP)
						 ) err1(FltNotEq|Warn2|PossErr);
    createBoolResult();
    cExp.topOper = topOper;}
}

static void term6(void)
{
  term7();
  while (curTok.tok == ORDEROP) {
    TkCmp oper;
    TresulExp slExp = cExp;		/* left operand saving */
    TmacLvl operMacLvl = macLvl;

    oper = (TkCmp)curTok.val;		/* operator in class OrderOp */
    GetNxtTok();
    term7();
    lExp = slExp;		/* left operand */
    operCmp = oper;
    paramTxt = txtCmpTok[oper];
    verifCstOvfl();
    if (lExp.type!=NULL && PureUnsig(lExp.type) && cExp.rEvlbl && !cExp.errEvl
			  && cExp.uVal==0 && !lExp.unsigDiff && oper!=GT) err1(
						     UnsigNonNeg|Warn2|PossErr);
    if (! resulExp(NumEnumBool | PtrPoss, True, &computeCmp, operMacLvl,
								     ORDEROP)) {
      checkCmpdTypes();
      if (cExp.rEvlbl) {  /* compute result */
#if PtrGtLong
        switch (oper) {
          case GT: cExp.uVal = (TcalcU)(lExp.pVal > cExp.pVal); break;
          case GE: cExp.uVal = (TcalcU)(lExp.pVal >= cExp.pVal); break;
          case LE: cExp.uVal = (TcalcU)(lExp.pVal <= cExp.pVal); break;
          case LT: cExp.uVal = (TcalcU)(lExp.pVal < cExp.pVal); break;
          /*~NoDefault*/}
#else
        lExp.uVal = (TcalcU)lExp.pVal;
        cExp.uVal = (TcalcU)cExp.pVal;
        computeCmp(&natTyp[ULLongDpl]);
#endif
      }}
    else if (cExp.unsigDiff) err1(UnsigDiffNotNeg|Warn2|PossErr);
    createBoolResult();
    cExp.topOper = ORDEROP | NONASSOC;}
}

#pragma noinline (sConvToType, uConvToType)
static TcalcS sConvToType(const TresulExp *pExp, TpcTypeElt x)
{
  return (x->typeSort < Long)
          ? (TcalcS)(int)pExp->sVal
#ifdef LONGLONG
          : (x->typeSort < LLong)
            ? (TcalcS)(long)pExp->sVal
#endif
            : pExp->sVal;
}

static TcalcU uConvToType(const TresulExp *pExp, TpcTypeElt x)
{
  return (x->typeSort < Long)
          ? (TcalcU)(uint)pExp->uVal
#ifdef LONGLONG
          : (x->typeSort < LLong)
            ? (TcalcU)(ulong)pExp->uVal
#endif
            : pExp->uVal;
}

static void checkCmpdTypes(void)
{
  TpcTypeElt lType = (lExp.ArtifType)? &voidPtrTypeElt : lExp.type,
             rType = (cExp.ArtifType)? &voidPtrTypeElt : cExp.type;

  if (rType==NULL || lType->typeSort!=Ptr || rType->typeSort!=Ptr ||
					     !CompatType(lType, rType, Cmpar)) {
    errWrngType(NumEnumBool | PtrPoss);}
  else if (operCmp > NE) {
    TpcTypeElt type, nType;

    for (type = lType;; type = rType) {
      if ((nType = NxtTypElt(type))!=NULL && (nType->typeSort==Void || IsFct(
		   nType))) {errExp(NoOrderRel, lType, typeToS2(rType)); break;}
      if (type == rType) break;}}
  FreeExpType2(lExp.type);
  cExp.ptrId = NULL;
}

static void computeCmp(TpcTypeElt x)
{
#define LtBit	(TcmpBit)1
#define EqBit	(LtBit << 1)
#define GtBit	(EqBit << 1)
  typedef uint TcmpBit;
  TcmpBit cmpMsk;
  static TcmpBit cmpCod[/*~IndexType TkCmp*/] = {EqBit, LtBit|GtBit, GtBit,
					       GtBit|EqBit, LtBit|EqBit, LtBit};

  if (IsTypeSort(x, (SigWhoEnum | Flt))) {
    TcalcS sCmpOpd1 = sConvToType(&lExp, x), sCmpOpd2 = sConvToType(&cExp, x);

    cmpMsk = (sCmpOpd1 > sCmpOpd2)
              ? GtBit
              : (sCmpOpd1 == sCmpOpd2)
                ? EqBit
                : LtBit;}
  else {
    TcalcU uCmpOpd1 = uConvToType(&lExp, x), uCmpOpd2 = uConvToType(&cExp, x);

    cmpMsk = (uCmpOpd1 > uCmpOpd2)
              ? GtBit
              : (uCmpOpd1 == uCmpOpd2)
                ? EqBit
                : LtBit;}
  cExp.uVal = (cmpCod[operCmp] & cmpMsk)? 1 : 0;
  /* *doIt* float types */
#undef LtBit
#undef EqBit
#undef GtBit
}
/*~Undef operCmp, checkCmpdTypes */

static TkShi operShi;  /* temporary */

static void term7(void)
{
  term8();
  while (curTok.tok == SHIFTOP) {
    TkShi oper;
    TresulExp slExp = cExp;		/* left operand saving */
    TmacLvl operMacLvl = macLvl;

    oper = (TkShi)curTok.val;		/* operator in class ShiftOp */
    GetNxtTok();
    term8();
    lExp = slExp;
    paramTxt = txtShiTok[oper];
    operShi = oper;
    {
      TpcTypeElt lType;

      /* Start by eliminating erroneous cases (else, funny messages from
         resulExp() because rType==lType...). */
      if ((lType = lExp.type)!=NULL && !IsTypeSort(lType, WhoEnum)) {
        errWrngType(WhoEnum);
        FreeExpType2(lType);
        lExp.type = lType = NULL;}
      else if (cExp.type!=NULL && !IsWhoEnumNotChar(cExp.type)) errExp(
	    ((IsTypeSort(cExp.type, WhoEnum))? IlgRhtType|Warn2|PossErr :
						  IlgRhtType), cExp.type, NULL);
      else {
        if (cExp.rEvlbl && !cExp.errEvl && (cExp.sVal<0 || lType!=NULL && cExp.
	     sVal>=(TcalcS)lType->size * CHAR_BITC)) { /* *doIt*: portability */
          errWSSSS(UndefResul|Warn2|PossErr, paramTxt, longToS(cExp.sVal),
							 typeToS1(lType), NULL);
          cExp.errEvl = True;
          cExp.sVal = 0;}
        FreeExpType(cExp);}
      cExp.type = lType;}
    cExp.cstImpsd = lExp.cstImpsd;
    cExp.unsigDiff = False;
    resulExp(WhoEnum, False, &computeShi, operMacLvl, SHIFTOP);
    cExp.topOper = SHIFTOP | NONASSOC;}
}

static void computeShi(TpcTypeElt x)
{
  TtypeSort tsl = x->typeSort;

  if (operShi == LSh) {
    register TcalcS w;

    w = lExp.sVal << cExp.sVal;
    if ((lExp.sVal>=0 && w<0 || lExp.sVal<0 && w>=0) && tsl & SigWhoEnum ||
				    (TcalcU)w>>cExp.sVal!=lExp.uVal) errOvfl(x);
    cExp.sVal = w;}
  else if (cExp.uVal == 0) cExp.sVal = lExp.sVal;
  else {
    if (tsl & SigWhoEnum) cExp.sVal = lExp.sVal >> (cExp.uVal - 1);
    else cExp.uVal = lExp.uVal >> (cExp.uVal - 1);
    if (cExp.sVal==0 && lExp.sVal!=0) errUdfl();
    if (tsl & SigWhoEnum) cExp.sVal >>= 1;
    else cExp.uVal >>= 1;}
}
/*~Undef operShi */

static void term8(void)
{
  term9();
  while (curTok.tok == ADDOP) {
    TkAdd oper;
    TresulExp slExp = cExp;		/* left operand saving */
    TmacLvl operMacLvl = macLvl;
    bool foundTC = False;

    oper = (TkAdd)curTok.val;		/* operator in class AddOp */
    GetNxtTok();
    term9();
    lExp = slExp;		/* left operand */
    paramTxt = txtAddTok[oper];
    if (pHeadTCBLists != NULL) foundTC = manageTypCmbn(AddTC + (oper - Add));
    if (oper == Add) {
      if (! resulExp(Num | PtrPoss, False /* because of x0 + deltaX, x0 cst */,
					      &computeAdd, operMacLvl, ADDOP)) {
        specialCaseOp(oper);
        cExp.topOper = ADDOP;}}
    else {
      bool opnd2LE1 = cExp.rEvlbl && cExp.uVal<=1;

      if (! resulExp(NumEnum | PtrPoss, False, &computeSub, operMacLvl, ADDOP))
        specialCaseOp(oper);
      else if (! foundTC) {  /* see whether "distance" obtained */
        TpcTypeElt eType = cExp.type;

        if (eType!=NULL && eType->typeSort==Enum) {
          FreeExpType2(eType);
          cExp.type = &natTyp[IntDpl];}}
      if (cExp.type!=NULL && PureUnsig(cExp.type) && !cExp.rEvlbl /* because
	       either no problem or already warned on overflow. */ && !opnd2LE1)
        cExp.unsigDiff = True;
      cExp.topOper = SubOP;}}
}

static void computeAdd(TpcTypeElt x)
{
  if (x->typeSort & UnsigWho) {
    cExp.uVal += lExp.uVal;
    if (cExp.uVal < lExp.uVal) errOvfl(x);}
  else {  /* *doIt* float types */
    if (! computeSigAdd(lExp.sVal, cExp.sVal, &cExp.sVal)) errOvfl(x);}
}

static void computeSub(TpcTypeElt x)
{
  if (x->typeSort & UnsigWho) {
    if (cExp.uVal > lExp.uVal) errOvfl(x);
    cExp.uVal = lExp.uVal - cExp.uVal;}
  else {  /* *doIt* float types */
    TcalcS prevValCExp = cExp.sVal;

#if LONG_MINC + LONG_MAXC != 0
    if ((!computeSigAdd(lExp.sVal, -cExp.sVal, &cExp.sVal)
	|| prevValCExp==LONGLONG_MINC && lExp.sVal>=0) && cExp.sVal!=0
#else
    if (! computeSigAdd(lExp.sVal, -cExp.sVal, &cExp.sVal)
#endif
								  ) errOvfl(x);}
}

static void term9(void)
{
  term10();
  while (curTok.tok==STAR || curTok.tok==MULOP) {
    TkMul oper;
    TresulExp slExp = cExp;		/* left operand saving */
    TmacLvl operMacLvl = macLvl;

    oper = (curTok.tok == STAR)? Mul : (TkMul)curTok.val;
    GetNxtTok();
    term10();
    lExp = slExp;		/* left operand */
    paramTxt = txtMulTok[oper];
    if (pHeadTCBLists==NULL || !manageTypCmbn(MulTC + (oper - Mul))) {
      if (cExp.type != NULL)  /* coefficient ? */
        if (! cExp.type->NxtIsTypId) ((ModifType)(cExp.type = copyTypeEltNoOwn(
		cExp.type)))->generic = True;  /* because multiplication =
						       sequence of additions. */
        else if (oper==Mul && lExp.type!=NULL && !lExp.type->NxtIsTypId) ((
	  ModifType)(lExp.type = copyTypeEltNoOwn(lExp.type)))->generic = True;}
    if (oper == Mul) resulExp(Num, False, &computeMul, operMacLvl, MULOP);
    else {
      if (oper == Div) resulExp(Num, False, &computeDiv, operMacLvl, MULOP);
      else  /* Mod */  resulExp(Who, False, &computeMod, operMacLvl, MULOP);
      cExp.topOper = MULOP | NONASSOC;}}
}

static void computeMul(TpcTypeElt x)
{
  if (x->typeSort & UnsigWho) {
#define SqrtTwoPow32	65536L
    if (lExp.uVal<=SqrtTwoPow32-1 && cExp.uVal<=SqrtTwoPow32) cExp.uVal *=
								      lExp.uVal;
#undef SqrtTwoPow32
    else if (cExp.uVal != 0) {
      register TcalcU w;

      w = lExp.uVal * cExp.uVal;
      if (w/cExp.uVal != lExp.uVal) errOvfl(x);
      cExp.uVal = w;}}
  else {  /* *doIt* float types */
#define SqrtTwoPow31	46340L  /* 46340 = sqrt(2**31) */
    if ((TcalcU)(lExp.sVal+SqrtTwoPow31)<=SqrtTwoPow31+SqrtTwoPow31 && (TcalcU)
			    (cExp.sVal+SqrtTwoPow31)<=SqrtTwoPow31+SqrtTwoPow31)
      cExp.sVal *= lExp.sVal;
#undef SqrtTwoPow31
    else if (cExp.sVal != 0) {
      register TcalcS w;

      w = lExp.sVal * cExp.sVal;
      if (w/cExp.sVal != lExp.sVal) errOvfl(x);
      cExp.sVal = w;}}
}

static void computeDiv(TpcTypeElt x)
{
  if (cExp.sVal == 0) errOvfl(lExp.type);  /* divide by 0 */
  else {
    if (x->typeSort & UnsigWho) cExp.uVal = lExp.uVal / cExp.uVal;
    else cExp.sVal = lExp.sVal / cExp.sVal;  /* *doIt* float types */
    if (cExp.uVal==0 && lExp.uVal!=0) errUdfl();}
}

static void computeMod(TpcTypeElt x)
{
  if (cExp.sVal == 0) errOvfl(lExp.type);  /* divide by 0 */
  if (x->typeSort & UnsigWho) cExp.uVal = lExp.uVal % cExp.uVal;
  else cExp.sVal = lExp.sVal % cExp.sVal;
}

static void term10(void)
{
  Ttok topOper, oldTopOper = cExp.topOper;
  TmacLvl operMacLvl = macLvl;
  TmacParCtr operMacParCtr = macParCtr;

  cExp.topOper = topOper = curTok.tok;  /* 'curTok.tok' to be saved, because
						      of right associativity. */
  switch (curTok.tok) {
  case ADDOP: {
      TkAdd oper;
      static const Tstring txtUnAddTok[/*~ IndexType TkAdd */] = {"u+", "u-"};
      /*~ zif NbEltGen(txtUnAddTok, (TkAdd)0) != __extent(TkAdd)
					      "Array 'txtUnAddTok': bad size" */

      oper = (TkAdd)curTok.val;
      if (InsideInterval(NxtTok(), CSTNU, CSTNU1)) {  /* special case for
			   numeric constants, to be able to mark them signed. */
        curTok.val = (oper == Sub)? SignSeen | NegSeen : SignSeen;
        goto cstNuL;}
      term10();
      resulUnOp(Num, txtUnAddTok[oper]);
      if (cExp.rEvlbl) {
        TpcTypeElt rType;

        if ((rType = cExp.type) != NULL) {
          TtypeSort tsr = rType->typeSort;

          if (tsr & SigWhoEnum) {
            if (oper == Sub) {
              register TcalcS w;

              w = -cExp.sVal;
              if (((w<0 && cExp.sVal<0) || (w>0 && cExp.sVal>0))) errOvfl(rType);
              cExp.sVal = w;}}
          else if (tsr & UnsigWho) {
            if (oper == Sub) {
              topOper = SubOP;
#if defined(LONGLONG) || ULONG_MAX /* not _MAXC ! */>UINT_MAXC
              if (tsr < Long) cExp.uVal = (- cExp.uVal) & UINT_MAXC;
						 /* because -(1U) = UINT_MAXC */
#  ifdef LONGLONG
              else if (tsr < LLong) cExp.uVal = (- cExp.uVal) & ULONG_MAXC;
					       /* because -(1UL) = ULONG_MAXC */
#  endif
              else cExp.uVal = -cExp.uVal;
#else
              cExp.uVal = -cExp.uVal;
#endif
            }}}
        else cExp.sVal = - cExp.sVal;}
      goto defTopOperL;}
  case APSAND: {
      TpcTypeElt ptrAddendType = (GetNxtTok(), IsDP(INDEXTYPE))?
						      getINDEXTYPEtype() : NULL;
      bool savAO = apsndOpnd;

      apsndOpnd = True;
      term10();
      if (! cExp.lValFl) {paramTxt = "u&"; errExp(NotLVal, NULL, NULL); cExp.
								  ptrId = NULL;}
      else {
        TpTypeElt newElt = allocTypeEltID(Ptr, NoQualif);

        if (cExp.pseudoAttrib == Reg) {err0(RegAttribForAmp); cExp.
							   pseudoAttrib = Auto;}
        newElt->noOwner = True;
        if (cExp.type != NULL) newElt->stopFreeing = ! cExp.type->noOwner;
        newElt->size = PtrSiz;
        if (ptrAddendType != NULL) newElt->indexType = ptrAddendType;
        else {
          Ttok topOper = NakedTok(cExp.topOper);

          newElt->indexType = ((topOper==LSBR || topOper==STAR) && cExp.type!=
	    NULL)? lExp.type : (moreIndexTypeChk)? &defaultIndexTypeElt : NULL;}
        newElt->nextTE = cExp.type;
        newElt->generic = True;  /* to allow '&buf[...]' to be compatible with
				   any reachable descendant of 'Ptr/TbufElt'. */
        cExp.type = newElt;
        cExp.rEvlbl = cExp.lEvlbl;
        cExp.errEvl = False;
        if (! cExp.PointedByObj) {
          TsemanElt *ptrId = cExp.ptrId;

          if (ptrId!=NULL && ptrId->initlz /* because of UslObj */) ptrId->
		used = cExp.oldUsed;  /* taking address of object is not
							      (yet) using it. */
          cExp.PointingOnObj = True;}
        else PopHist(cExp.hist);
        cExp.lValFl = False;
        cExp.lclAdr = (cExp.pseudoAttrib == Auto);}
      apsndOpnd = savAO;
      goto defTopOperL;}
  case CSTCH: case CSTCH1: case CSTWCH: case CSTWCH1:  /* character constant */
    cExp.Einfo = 0;
    cExp.errEvl = (curTok.tok >= CSTCH1);
    cExp.sVal = (cExp.errEvl)? 0 : (TcalcS)(char) /* because of the rules for
					   sign of char constant. */ curTok.val;
    cExp.type = (curTok.tok==CSTCH || curTok.tok==CSTCH1)
                 ? (sysHdrFile && ifDirExp)
                   ? &longCstTypeElt
                   : &charCstTypeElt
                 : managePredefTypes(WCHAR_T);
    goto cstL1;
  case CSTNU: case CSTNU1:			/* numeric constant */
cstNuL:
    manageNumCst();
    if (   chkNumCst
        && !cExp.errEvl
        && (TcalcU)(cExp.sVal + 1)>1+1 /* *doIt* Flt */
        && curTok.tok!=CSTNU1
        && !sysAdjHdrFile
        && !((operMacLvl!=0 || ifDirExp) && NakedTok(oldTopOper)==LPAR &&
							  peepNxtTok()==RPAR)) {
      cExp.litCst = True;
      if (operMacLvl == 0) cExp.LitCstOutsMac = True;}
cstL1:
    cExp.ptrId = NULL;
cstL2:
    SetInfoForCst
    goto exitIdL;
  case CSTST: {			/* string constant */
      TpTypeElt newElt;
      uint initTok = curTok.val;

      cExp.Einfo = 0;  /* reset all flags */
      cExp.pVal = (const char *)ptrFreeIdSpace();
      /* Concatenate adjacent string litterals */
      do {
        analStrCst(&storeStrCh);
        if (curTok.errorT) cExp.errEvl = True;  /* do not reset cExp.pVal,
		since one may still want to use the erroneous string literal. */
        DefLastPrimMacPar(macParCtr);
      } while (NxtTok()==CSTST && curTok.val==initTok);
      storeStrCh('\0');	/* terminating byte */
      cExp.lValFl = True;
      cExp.lEvlbl = True;
      cExp.rEvlbl = True;  /* because "..." => &"..."[0] implicitely (which
						 is a compile-time constant). */
      cExp.pseudoAttrib = Stati;
      cExp.ptrId = NULL;
      if ((bool)initTok) {
        newElt = copyTypeEltNoOwn(&wstrCstTypeElt);
        newElt->stopFreeing = False;
        newElt->nextTE = copyTypeEltNoOwn(managePredefTypes(WCHAR_T));
        ((ModifType)newElt->nextTE)->qualif = ConstQal;}
      else newElt = copyTypeEltNoOwn(&strCstTypeElt);
      newElt->lim = newElt->size = initGetStrLit(NULL);
      cExp.type = newElt;
      goto tstQualif1L;}
  case DPTOK:
    if ((Tdprag)curTok.val == CASTTO) {
      TpcTypeElt castType = curTok.dpType, eType;

      GetNxtTok();
      term10();
      if (castType!=NULL && (eType = cExp.type)!=NULL && !compatType(
			  represType(castType), represType(eType), VerifCast)) {
        errWSTT(IlgCastTo|Warn2|PossErr, NULL, castType, eType);
        FreeExpType2(castType);}
      else {
        freePrevCast();
        if (compatType(castType, eType, VerifCastF) && !cExp.unsigDiff && !cExp.
		 cstImpsd) errWSTT(UslCastTo|Warn1|Rdbl, NULL, castType, eType);
        finalizeCast(castType);}
      goto defTopOperL;}
    if ((Tdprag)curTok.val == VOIDTOTHER) {
      TpcTypeElt w, eType;

      GetNxtTok();
      term10();
      if ((eType = cExp.type) != NULL) {
        if (IsPtr(eType)) {
          if ((w = NxtTypElt(eType)) == NULL) goto defTopOperL;
          if (w->typeSort == Void) {
            cExp.type = copyTypeEltNoOwn(eType);
            ((ModifType)cExp.type)->generic = True;  /* keep qualifiers */
            goto defTopOperL;}}
        errIlgDP(VOIDTOTHER);}
      goto defTopOperL;}
    goto defaultL;
  case EMARK:
    GetNxtTok();
    term10();
    resulUnOp(mskBool, "!");
    if (cExp.rEvlbl) cExp.uVal = (TcalcU)(! (bool)cExp.uVal);
    createBoolResult();
    goto defTopOperL;
  case IDENT: {
      TsemanElt *ptrId;

      cExp.type = NULL;
      cExp.Einfo = 0;  /* reset pseudoAttrib and all flags (rEvlbl etc.) */
      if ((ifDirExp || zifExp) && checkSpeFct()) {  /* special preprocessor/
								zif function. */
        topOper |= PRIMARY;
        cExp.ptrId = NULL;
        SetInfoForCst
        goto defTopOperL;}
      if (ifDirExp) {  /* 'any identifiers remaining after macro expansion
							 are replaced by 0L'. */
        if (evaluateFl) errWN(UndefId|Warn3|PossErr, curTok.IdName);
        cExp.type = &longCstTypeElt;
        cExp.sVal = 0;
        goto cstL1 /*~BackBranch*/;}
      if ((ptrId = curTok.ptrSem) == NULL) {  /* unknown identifier */
        DefSem1(artifDef, Obj, True /*defnd*/, True /*used*/, True /*initlz*/);

        errWN((peepNxtTok() == LPAR)
		 ? UndefFctId | CWarn3
                 : (isupper((char)*(curTok.IdName + LgtHdrId)))  /* symbol? =>
								    constant. */
		   ? (cExp.rEvlbl = True, cExp.errEvl = True, UndefId)
		   : UndefId, curTok.IdName);
        if ((ptrId = defineId(artifDef)) == NULL) goto exit1IdL;}
      if (ptrId->kind >= Type) {
        if (ptrId->kind == EnumCst) {
          if (ifDirExp) err0(IlgInIfExp);
          if (! ptrId->defnd) {
            errWN(NotUsdEnumCst|Warn1|Rdbl, curTok.IdName);
            if (! allErrFl) ptrId->defnd = True;}
          if (ptrId->type->tagId->listAlwdFiles != NULL) checkPrivVisible(
								   ptrId->type);
          cExp.ptrId = ptrId;
          cExp.type = ptrId->type;
          cExp.sVal = (TcalcS)ptrId->enumVal;
          ptrId->used = True;
          goto cstL2 /*~BackBranch*/;}
        errWN(IlgId, curTok.IdName);
        goto exit1IdL;}
      if ((cExp.type = ptrId->type)==NULL && isupper((char)*(curTok.IdName +
			   LgtHdrId))) {cExp.rEvlbl = True; cExp.errEvl = True;}
      if (ptrId->attribb == Extrn) {
        if (ptrId->declInInHdr) checkIncldFiles(ptrId);}
      else if (!ptrId->defnd && ptrId->type!=NULL && !IsFct(ptrId->type)) {
        errWN((ptrId->kind == Param)? NotUsdPar|Warn1|Rdbl : NotUsdObj|Warn1|
							   Rdbl, curTok.IdName);
        if (! allErrFl) ptrId->defnd = True;}
      cExp.pseudoAttrib = ptrId->attribb;
      cExp.oldUsed = ptrId->used;   /* save previous state of 'used' flag */
      if (!zifExp && (ptrId->nameb!=curFctName || ptrId->type==NULL || !IsFct(
		   ptrId->type)) /* recursion is not use */) ptrId->used = True;
      cExp.lclAdr = ptrId->lclAd;  /* in case type(ident) == Ptr  (or Bool:
			    does then "cExp.notPureBool = ptrId->notPureBoo;" */
exit1IdL:
      cExp.lValFl = True;
      cExp.lEvlbl = True;  /* because &(id) yields constant address */
      cExp.pVal = ArbitAdr;
      cExp.ptrId = ptrId;
      cExp.hist = H_EMPTY;}
exitIdL:
    DefLastPrimMacPar(macParCtr);
    GetNxtTok();
tstQualif1L:
    cExp.topOper = topOper | PRIMARY;
    goto tstQualifL;
  case INCOP: {
      TkInc oper= (TkInc)curTok.val;
      TmacParCtr operMacParCtr = macParCtr;

      GetNxtTok();
      term10();
      resulIncOp(oper, operMacParCtr);
      goto positMacLvlL;}
  case LPAR: {  /* cast/sub-expression */
      Ttok w;

      GetNxtTok();
      /* Decide whether cast or parenthetized expression */
      if (   IsDecl1(BQualif)
          || curTok.tok==IDENT
           && (   curTok.ptrSem!=NULL
                && curTok.ptrSem->kind==Type  /* type identifier */
               ||  curTok.ptrSem==NULL  /* undefined identifier */
                && !ifDirExp /* cast forbidden in '#if' */
             /* In an attempt to follow programmer idea, consider undefined pa-
                renthetized uppercase identifier as would-be type identifier. */
                && isupper((char)*(curTok.IdName + LgtHdrId))
                /* Beware of interaction of peepNxtTok() and macro-expansion
					    (case "...(defined <symbol> ...") */
                && ((w = peepNxtTok())==STAR || w==RPAR))) {  /* cast */
        TpcTypeElt castType, eType;
        bool macParMet = False, oddCSeen = False, portQMSeen, ignorable = False,
								      oldSysMac;

        castType = declType();
        oldSysMac = sysMacro;
        if (!(portQMSeen = FoundDP(PORTQM)) && IsDP(ODDCAST)) {
          ignorable = ignorableDP(operMacParCtr + 1);
          oddCSeen = True;}
        if (ifDirExp) err0(IlgInIfExp);
        if (! Found(RPAR)) err0(RParExptd);
        term10();
        if (lastPrimMacParCtr != operMacParCtr) macParMet = True;
        else ignorable = False;
        lastPrimMacParCtr = operMacParCtr;
        eType = cExp.type;
        paramTxt = "cast";
        freePrevCast();
        if (castType != NULL) {
          TtypeSort tsc = castType->typeSort;

          if (IsCmpsdSort(tsc)) {
            errWT((!compatType(castType, eType, VerifCastF) && eType!=NULL &&
		compatType(represType(castType), represType(eType), VerifCast)
				   )? IlgCastTarget1 : IlgCastTarget, castType);
            FreeExpType2(castType);
            castType = NULL;}
          else {
            if (tsc == Bool) cExp.notPureBool = !(oddCSeen || cExp.rEvlbl
					      && (cExp.errEvl || cExp.uVal<=1));
            if (eType != NULL) {
              TtypeSort tse = eType->typeSort;
              Terr errNo;
              bool savSysMac = sysMacro;

              sysMacro = oldSysMac;  /* for warnings management */
              if (IsFctSort(tse) || (tse==Void || IsStrunSort(tse)) && tsc!=
					      Void) errWT(IlgCastSource, eType);
              else if (tsc != Void) {
                if (tse==Array && eType->generic) tse = Ptr;  /* for cast
					     purpose, string constant => Ptr. */
                if (CompatType(castType, eType, VerifCastF)) {
                  TpcTypeElt w;

                  if (   !macParMet
		      && (castType==eType || castType->sysTpdf==eType->sysTpdf)
		      && !(tsc==Ptr && eType->generic && ((w = NxtTypElt(eType)
			)==NULL || w->typeSort==Void) && ((w = NxtTypElt(
			  castType))==NULL || w->typeSort!=Void))  /* (void *)
				generally to be cast to other pointer, so do not
				   complain if people try to do things right. */
		      && !cExp.cstImpsd
                      && !cExp.ArtifType) {errNo = UslCast|CWarn1|Rdbl; goto
								       stdErrL;}
                  goto noErrL;}
                else {
                  if (! (macParMet || sysMacro || tsc<tse)) {
                    preLastCastType = eType;
                    pLCMacLvl = macLvl;}
                  if (tsc < DelType) {  /* cast to NumEnumBool */
                    if (tsc == Bool) oddCSeen = False;
                    switch(tse) {
                    case Ptr:  /* Ptr => NumEnumBool */
                      if (allocType != NULL) freeAlloc();  /* inhibitates
							      'Xalloc' check. */
                      cExp.uVal = (TcalcU)cExp.pVal;/* because of big endians */
                      if (cExp.rEvlbl && cExp.pseudoAttrib==NoAttrib) {  /* ad-
								 dress known. */
                        if (!cExp.errEvl && computeLstType(cExp.sVal) >
				  ((tsc == Enum)? Int : tsc)) errOvfl(castType);
                        break;}  /* *doIt* break only if no overflow on any
								     machine. */
#if ! PtrGtLong
                      if (castType->sysTpdf && memcmp(castType->typeId->nameb,
			SizeTName, LitLen(SizeTName))==0 || castType->typeSort==
							    ULLong) goto noErrL;
#endif
                      errNo = PtrToNum|CWarn2|PossErr;
                      goto stdErrL;
                    case Array:  /* Array => NumEnumBool */
                      errNo = NotArrToNum|CWarn1|Rdbl;
                      goto stdErrL;
                    default:  /* NumEnumBool => NumEnumBool */
                      if (castType->litCsta!=eType->litCsta) CheckNumCstNamed(
								cExp, castType);
                      if (cExp.rEvlbl) {
                        checkInfoLoss(castType);
                        if (cExp.sVal<0 && IsTypeSort(castType, UnsigWho)
					     ) castValue(castType->typeSort);}}}
                  else {  /* cast to Ptr */
                    bool sameTypButQual;

                    errQalTyp1 = NULL;
                    sameTypButQual = compatType(castType, eType, CCheck1);
                    if (errQalTyp1 != NULL) {
                      if (! oddCSeen) errWSTT(HzrdConv1|CWarn2|PossErr, NULL,
							       eType, castType);
                      ignorable = True;}
                    if (! sameTypButQual) {
                      TpcTypeElt castTypw = castType;

                      for(;;) {
                        TpcTypeElt nxtCType, nxtEType;

                        if ((nxtCType = NxtTypElt(castTypw))==NULL || (nxtEType
			  = NxtTypElt(eType))==NULL && IsPtrArrSort(tse)) goto
									noErr1L;
                        switch(tse) {
                        case Array:  /* Array => Ptr */
                          if (castTypw == castType /* first turn around */
					) errWSTT(ArrToPtr|CWarn1|Rdbl, NULL,
							       eType, castTypw);
                          /*~NoBreak*/
                        case Ptr:  /* Ptr => Ptr */
                          if (IsFct(nxtCType) && IsFct(nxtEType)) goto hzdCastL;
                          if (castTypw == castType) { /* first turn around */
                            if (nxtEType->typeSort == Void) break;  /* because
					'void *' compatible with any pointer. */
                            if (nxtCType->typeSort == Void)
                              if (IsFct(nxtEType)) goto nonPortCastL;
                              else break;
                            if (nxtCType->typeSort == UByte) break;  /* raw
							     bytes container. */
                            if (IsFct(nxtCType)) {errWSTT(IncptblTypes,
					    paramTxt, castType, eType); break;}}
                          if ((uint)nxtCType->typeSort >= (uint)Fct) goto
					hzdCastL;  /* Fct, VFct, Struc, Union */
                          if ((uint)nxtCType->typeSort >= (uint)Ptr) {
                            /* Pointer on Ptr/Array : dereference and loop */
                            castTypw = nxtCType;
                            tsc = castTypw->typeSort;
                            if (IsPtrArr(nxtEType)) {
                              eType = nxtEType;
                              tse = eType->typeSort;
                              continue;}  /* dereferencing pointer chain */
                            goto hzdCastL;}
                          /* Here, casting type can only be pointer on num/
									 enum */
                          if ((uint)nxtEType->typeSort >= (uint)DelType)
                            if (IsStrun(nxtEType) && frstMemberCompat(nxtEType,
						     nxtCType->typeSort)) break;
                            else goto hzdCastL;
                          if (nxtCType->typeSort==Void || nxtEType->typeSort==
								    Void) break;
                          /* Cast to pointer on floating type never portable;
                             cast from floating type to integral type may be
                             portable (see, for example, dynarray.h). */
                          if (IsTypeSort(nxtCType, Flt)) goto nonPortCastL;
                          if (IsTypeSort(nxtEType, Flt)) goto nonPortCastQML;
                          if (nxtCType->algn != nxtEType->algn) {  /* nothing
					 to say if same alignment constraint. */
/*                              if (nxtCType->algn > nxtEType->algn) goto
				  nonPortCastQML;   because alignment cons-
				traint may have been respected by programmer. */
                            /* Cast to pointer on smaller integer sort a priori
                               never portable, because of big/little endians,
                               but see header management of dynamic arrays (
                               dynarray.h). */
                            goto nonPortCastQML;}
                          break;
                        default:  /* NumEnumBool => Ptr */
                          cExp.pseudoAttrib = NoAttrib;
                          if (cExp.sVal==0 && eType==&intCstTypeElt &&
			    InsideInterval(NakedTok(cExp.topOper), CSTNU,
				CSTNU1)) {  /* because plain 0 can be cast to
				     any pointer (idiom '&(struct *)0->...'). */
                            ((ModifType)castType)->generic = True;  /* NULL
								    generic ! */
                            break;}
                          {
                            TtypeSort w;

                            if (cExp.rEvlbl && !cExp.errEvl && (((w =
				computeCstType(cExp.sVal, tse, UnsigWho))<=
								UInt)? IntSiz :
#ifdef LONGLONG
				(w > ULong)? LongLongSiz :
#endif
				 ((void)w, LongSiz))>PtrSiz) errOvfl(castType);}
                          cExp.pVal = (char * /*~OddCast*/)cExp.uVal;  /*
						      because of big endians. */
                          if (eType->sysTpdf && memcmp(eType->typeId->nameb,
				      SizeTName, LitLen(SizeTName)) == 0) break;
                          goto nonPortCastQML;}
                        break;}}}}}  /* exit for(;;) loop */
              if (oddCSeen && !ignorable) errUslDP(ODDCAST);  /* no warning in
					macro if macro parameter met, because
					its type is a priori unknown. */
              goto noErrL;
hzdCastL:
              errNo = HzrdConv|CWarn2|PossErr;
stdErrL:
              if (!oddCSeen) errWSTT(errNo, NULL, cExp.type, castType);
noErrL:
              if (portQMSeen) errUslDP(PORTQM);
              goto noErr1L;
nonPortCastQML:
              /* Does not know whether really not portable */
              if (!oddCSeen && !portQMSeen && chkPortbl) errWSTT(
			     NonPortCastQM | CWarn1, NULL, cExp.type, castType);
              goto noErr1L;
nonPortCastL:
              if (!portQMSeen && chkPortbl) errWSTT(PortCastQM | CWarn1, NULL,
							   cExp.type, castType);
noErr1L:
              sysMacro = savSysMac;}}
          if (!macParMet || NakedTok(cExp.topOper)!=VFCTC) cExp.topOper = CAST; 
		  /* inside macro, pseudo-void function stays so through cast */
          if (! (tsc==Ptr && (cExp.type==NULL || IsPtrArr(cExp.type)))) cExp.
								lValFl = False;}
        cExp.FctCallNoResTyp = False;
        cExp.ArtifType = False;
        finalizeCast(castType);
        goto positMacLvlL;}
      /* Expression */
      commaExpr();
      if (! Found(RPAR)) err0(RParExptd);
      cExp.topOper |= PARENSEEN;  /* so that "(a=b)" => side-effect. */
      if (FoundDP(NONCONST)) cExp.rEvlbl = False;}
tstQualifL:
    cExp.macLvl = operMacLvl;
    if (InsideInterval(curTok.tok, LPAR, DOT)) primQualif();
    break;
  case SIZEOF: {
      bool parenFl = False, savEvalFl = evaluateFl;

      if (ifDirExp) err0(IlgInIfExp);
      GetNxtTok();
      DefLastPrimMacPar(macParCtr);
      evaluateFl = False;
      loopLvl++;  /* hack to prevent manageUsedForIncOp() from doing wrong */
      if (curTok.tok == LPAR) {		/* maybe type */
        parenFl = True;
        GetNxtTok();
        if (isType()) {cExp.type = declType(); cExp.topOper = WHITESPACE |
			       PRIMARY; cExp.ptrId = NULL; cExp.rEvlbl = False;}
        else {commaExpr(); valueNotUsed();}
        if (curTok.tok != RPAR) err0(RParExptd);}
      else {term10(); valueNotUsed();}
      loopLvl--;
      evaluateFl = savEvalFl;
      if ((cExp.uVal = (TcalcU)sizeOfTypeD(
		  cExp.type,
		  (cExp.ptrId!=NULL && cExp.ptrId->kind==Param && cExp.ptrId->
		        type!=NULL && IsArrFct(cExp.ptrId->type) && cExp.hist==
	 			  H_EMPTY)? UndefSize|Warn2|PossErr : UndefSize,
		  (Tname)"\6\0sizeof"))
				   == 0) cExp.errEvl = True;  /* illegal size */
      if (InsideInterval(NakedTok(cExp.topOper), FCTC, INCOP) || cExp.rEvlbl &&
       cExp.type!=NULL && !IsArr(cExp.type)) err0(SizeofDontEval|Warn3|PossErr);
      if (sizeofOpndType == XAllocSeen) sizeofOpndType = cExp.type;
      else {
        FreeExpType(cExp);
        if (sizeofOpndType != NULL) {FreeExpType2(sizeofOpndType)
						      ; sizeofOpndType = NULL;}}
      cExp.type = managePredefTypes(SIZE_T);
      {
        TREInfo savCEinfo;

        savCEinfo._eInfo = cExp.Einfo;
        cExp.Einfo = 0;  /* reset all flags */
        if (savCEinfo.s21._litCst) {
          cExp.litCst = True;
          if (savCEinfo.s21._litCstOutsMac) cExp.LitCstOutsMac = True;}}
      cExp.cstImpsd = True;
      cExp.rEvlbl = True;
      if (! evaluateFl) cExp.errEvl = True;  /* to prevent computation */
      cExp.ptrId = NULL;
      if (parenFl) GetNxtTok();  /* for good error position */
      goto tstQualif1L /*~BackBranch*/;}
  case STAR: {
      GetNxtTok();
      term10();
      paramTxt = "u*";
      indir();
      goto defTopOperL;}
  case TILDE:
    GetNxtTok();
    term10();
    resulUnOp(WhoEnum, "~");
    if (cExp.rEvlbl) {
      if (cExp.type == NULL) cExp.uVal = ~cExp.uVal;
      else if (cExp.type->typeSort & SigWhoEnum) cExp.sVal = ~cExp.sVal;
      else {
        cExp.uVal = ~cExp.uVal;
#if defined(LONGLONG) || ULONG_MAX /* not _MAXC ! */>UINT_MAXC
        if (cExp.type->typeSort < Long) cExp.uVal &= UINT_MAXC;
#  ifdef LONGLONG
        else if (cExp.type->typeSort < LLong) cExp.uVal &= ULONG_MAXC;
#  endif
#endif
      }}
defTopOperL:
    cExp.topOper = topOper;
    goto positMacLvlL;
  default:
defaultL:
    cExp.type = NULL;  /* because of FreeExpType in errExp() */
    errExp((oldTopOper == SCOL)? StmtExptd : MsngExp, NULL, NULL);
    cExp.Einfo = 0;  /* reset all flags */
    cExp.lValFl = True;
    cExp.lEvlbl = True;
    cExp.pVal = ArbitAdr;
    lastPrimMacParCtrIM = 0;
    cExp.ptrId = NULL;
positMacLvlL:
    cExp.macLvl = operMacLvl;}
  while (curTok.tok == INCOP) {
    DefLastPrimMacPar(operMacParCtr);
    resulIncOp((TkInc)curTok.val, macParCtr);
    cExp.macLvl = macLvl;
    GetNxtTok();}
}

static void finalizeCast(TpcTypeElt castType /*~MayModify*/)
{
  if (castType==NULL || castType->typeSort!=Void) checkInit();
  else cExp.ptrId = NULL;  /* for no checkInit */
  if (castType!=NULL && cExp.rEvlbl && castType->rootTyp)  /* mark constants
						      of root type 'generic'. */
    ((ModifType)(castType = copyTypeEltNoOwn(castType)))->generic = True;
  if (preLastCastType != cExp.type) FreeExpType(cExp);
  cExp.type = castType;
  cExp.cstImpsd = False;  /* to get 'type mismatch' error on
							 "schar = (short)3;". */
  cExp.unsigDiff = False;
}

static void manageNumCst(void)
{
  analNumCst(Convert);
  cExp.Einfo = 0;  /* reset all flags */
  cExp.errEvl = curTok.errorT;
  cExp.sVal = (curTok.val & NegSeen)? -curTok.numVal : curTok.numVal;
  if (curTok.val & FltSeen) {  /* floating constant */
    cExp.type = (curTok.val & FSeen)
			? &floatCstTypeElt
			: (curTok.val & LDSeen)
			  ? &longDblCstTypeElt
			  : (cExp.cstImpsd = True, &doubleCstTypeElt);}
  else {
    if (sysHdrFile && ifDirExp) curTok.val |= LSeen;
    if (curTok.numVal>=0 && !(curTok.val & (LSeen | LLSeen | USeen))
#if defined(LONGLONG) || ULONG_MAX /* not _MAXC ! */>UINT_MAXC
     && ((TcalcU)(cExp.sVal - INT_MINC) <= (TcalcU)((TcalcS)INT_MAXC -INT_MINC))
#endif
							   ) {
      cExp.type = &intCstTypeElt;  /* 'simple' integer constant */
      cExp.cstImpsd = True;}
    else {
      TpTypeElt newElt;
      TtypeSort cstSort;

      newElt = allocTypeEltID((TtypeSort)(0-0), NoQualif);
      newElt->noOwner = True; newElt->generic = True;
      if ((cstSort = computeLstType(cExp.sVal)) < Int) cstSort =
#if USHRT_MAXC == UINT_MAXC
						(cstSort == UShort)? UInt :
#endif
									    Int;
      if (!(curTok.val & SignSeen) && curTok.numVal<0) cstSort =
#if defined(LONGLONG) || ULONG_MAX>UINT_MAXC
					 ULLong;
#else
					 UInt | ULong;
#endif
      else if (cstSort < Long) cstSort |=
#if UINT_MAXC == ULONG_MAXC
				(cstSort == UInt)? ULong | LLong | ULLong :
#endif
					   UInt | Long | ULong | LLong | ULLong;
      else if (cstSort < LLong) cstSort |= ULong | LLong | ULLong;
      else cstSort |= ULLong;
      if (curTok.val & LSeen) cstSort &= Long | ULong;
#ifdef LONGLONG
      else if (curTok.val & LLSeen) cstSort &= LLong | ULLong;
#endif
      else cExp.cstImpsd = True;
      if (curTok.val & USeen) cstSort &= UInt | ULong | ULLong;
      else if (! (curTok.val & OctHex)) cstSort &= ~ UInt;  /* because the
							    standard says so. */
/*      if (cstSort == Void) {err0(WrngNb | Warn1); cExp.errEvl = True; cstSort =
									   Int;}*/
      /* Keep only least type sort */
      {
        TtypeSort w;
        int i = 0;
        static const size_t tabSize[] = {IntSiz, IntSiz, LongSiz, LongSiz
#ifdef LONGLONG
						   , LongLongSiz, LongLongSiz
#endif
									      };

        for (w = Int; ! (w & cstSort); w <<= 1) {i++;}
        newElt->typeSort = w;
        newElt->size = tabSize[i];}
      cExp.type = newElt;}}
}

static void primQualif(void)
{
  CheckNumCstNamed(cExp, cExp.type);
  for (;;) {
    TpcTypeElt initialType = cExp.type;

    switch (curTok.tok) {
    case ARROW:
      paramTxt = "->";
      {
        TpcTypeElt w;

        if (initialType!=NULL && (w = NxtTypElt(initialType))!=NULL &&
		!IsStrun(w)) errExp(IlgLftType, initialType, NULL);}  /* has to
			be done that way (cannot use test of DOT case), because
			indir() destroys head of type chain (field 'nextTE'). */
      indir();
      goto dotL;
    case DOT:
      paramTxt = ".";
      if (initialType!=NULL && !IsStrun(initialType)) errExp(IlgLftType,
							     initialType, NULL);
dotL:
      /* Structure/union member access */
      {
        const TdeclElt *member;
        TpcTypeElt eType;

        cExp.topOper = curTok.tok | PRIMARY;
        if ((eType = cExp.type) != NULL) {
          if (eType->tagId->listAlwdFiles != NULL) checkPrivVisible(eType);
          member = BaseStrunType(eType)->memberList;
          if (member == NULL) {
            (void)sizeOfTypeI(eType, False, IncplStrunType, paramTxt);/* type */
            errExp(NoErrMsg, NULL, NULL);}}		/* not yet completed. */
        if (NxtTok() != IDENT) {errExp(IdExptd, NULL, NULL); break;}
        if (cExp.type != NULL) {
          Tqualif qual = cExp.type->qualif;
          bool strucFl = (cExp.type->typeSort == Struc);

          do {
            if (isSameName(member->hCode, member->idName, curTok.hCod,
							       curTok.IdName)) {
              const TpcTypeElt mType = member->type;

              FreeExpType2(cExp.type);
              if (mType==NULL || !(qual & ~mType->qualif)) cExp.type = mType;
              else {  /* propagate qualifier */
                TpTypeElt newElt = copyTypeEltNoOwn(mType);

                newElt->qualif |= qual;
                cExp.type = newElt;}
              if (member->fldFl) cExp.pseudoAttrib = Reg;  /* to prevent taking
						  the address of a bit-field. */
              goto foundMember;}
            if (strucFl && member->type!=NULL) cExp.pVal += ((IsStrun(member->
		type))? BaseStrunType(member->type) : member->type)->size; /*
							     compute l-value. */
          } while ((member = member->cdr) != NULL);
          errExp(UnknMember, cExp.type, nameToS(curTok.IdName));}
foundMember:
        GetNxtTok();
        freePrevCast();  /* type of members are completely unrelated to
								  strun type. */
        PushHist(H_DOT);
        cExp.notPureBool = False;  /* struct/union fields independant */
        break;}  /* 'lValFl', 'pseudoAttrib' keep their preceding value (cf.
		    cast number to pointer "(.. *)0" ); 'cExp.ptrId' not reset,
		    to be able to take notice of possible initialization. */
    case LPAR: {		/* function call */
        const TdeclElt *formParList;
        bool exhstdParList = False;
        TREInfo savCEinfo;
        TpcTypeElt resulType = NoResulTyp;
        TresulExp slExp = cExp;
        Tname lastCalledFctName = decoratedName(&cExp);
        TsemanElt *finalPtrId = cExp.ptrId;
        TpcTypeElt locAllocType = allocType, saveSizeofOpndType= sizeofOpndType;
        int savIoFctNb = ioFctNb;

        ioFctNb = 0;  /* by default, not 'scanf'/'printf' family; BEWARE, used
							     by ScanFl macro. */
        TstAlwdInCstExp();
        sizeofOpndType = allocType = NULL;
        paramTxt = "()";
        if (macParCtr == lastPrimMacParCtrIM) errWN(IneffOrSideEff|
					      Warn2|PossErr, lastCalledFctName);
        if (initialType != NULL) {
          if (IsFct(initialType)) {
            if (initialType->typeSort==VFct && lastCalledFctName!=NULL) {
              static const Tname tabIOf[] = {PrintfFamily, ConvTname(""),
		      ScanfFamily};  /* 'printf' family must come first
		     (because more frequent; see also 'ioFctNb' computation). */
              const Tname *ptrTIOf;
              size_t lgtId = Lgt(lastCalledFctName);

              for (ptrTIOf = &tabIOf[0]; ptrTIOf < AdLastEltP1(tabIOf); ) {
                if (memcmp(lastCalledFctName, *ptrTIOf++, lgtId) == 0) {  /*
					       found xscanf/xprintf function. */
                  ioFctNb = (int)(ptrTIOf - &tabIOf[SizePrintfFamily + 1 /* 
							   because of '++' */]);
                  break;}}}
            else if (curTok.hCod==SetjmpHCode && memcmp(lastCalledFctName,
			SetjmpTName, LitLen(SetjmpTName))==0) cExp.SjVal = True;
            goto correctL;}
          {
            TpcTypeElt w;

            if (IsPtr(initialType) && (w = NxtTypElt(initialType))!=NULL &&
								     IsFct(w)) {
              errWSTT(IlgLftType|Warn1|Rdbl, paramTxt, initialType, NULL);
              indir();
              initialType = cExp.type;
              goto correctL;}}
          errExp(IlgLftType, initialType, NULL);
          finalPtrId = NULL;}
        initialType = allocTypeEltID(VFct, NoQualif);  /* just to simplify
		     coming life ('nextTE' field = 'paramList' field = NULL). */
        ((ModifType)initialType)->noOwner = True;
correctL:
        if (cExp.macLvl==0 && macLvl!=0) err0(LParOutsideMac|Warn1|Rdbl);
	      /* case "exit EXIT_SUCCESS", with EXIT_SUCCESS defined as "(1)" */
        savCEinfo._eInfo = cExp.Einfo;
        formParList = initialType->paramList;
        if (NxtTok() != RPAR) {
          bool resulPtrSeen = False;
          TpcTypeElt retType = NoResulTyp;
          int formatFl = 0;

          do {
            if (formParList!=NULL && formParList->SizeofBlFl) {
              if (locAllocType == NULL) sizeofOpndType = XAllocSeen;
              else if (locAllocType != XAllocSeen) {FreeExpType2(locAllocType)
						  ; locAllocType = XAllocSeen;}}
            asgnExpr();  /* actual parameter */
            {
              TpcTypeElt eType = cExp.type;

/*              if (loopLvl!=0 && cExp.ptrId!=NULL) cExp.ptrId->forceUsed = True;
/ case "a=f(a)" inside loop; but seems to denote bad coding, so warning left */
              paramTxt = "()";  /* paramTxt used in managePointers() */
              if (formParList == NULL) {  /* variadic part */
                CheckNumCstNamed(cExp, eType);
                if (formatFl>0 && !folwngSpec(eType, (macLvl == pLCMacLvl)?
						      preLastCastType : NULL)) {
                  err0(FmtExhstd|Warn2|PossErr);
                  formatFl = -1;}  /* formatFl stays non-zero */
                freePrevCast();
                managePointers((ScanfFl)? &voidPtrTypeElt /* NOTALLCONST type,
		    to prevent xscanf parameters from being asked 'const'. */ :
									  NULL);
                /* xscanf will not change its parameters in case of input or
                   matching failure, so do not mark parameters 'not used'. */
                exhstdParList = True;}
              else {  /* non exhausted formal parameters list */
                TpcTypeElt formType = formParList->type;

                if (formParList->parQal == ResulTypV) {freePrevCast()
							; heedRootType = False;}
                managePointers(formType);
                CheckNumCstNamed(cExp, formType);
                if (eType != NULL) {  /* correct actual parameter */
                  errQalTyp1 = NULL;
                  if (formParList->parQal==UtilityV && eType->NxtIsTypId ||
			!CompatType(formType, eType, FctCall) && (lExp.type =
						  formType, !compatNumType())) {
                    /* Skip over bad manners of some system header files */
                    if (!(eType->typeSort==Enum && eType->intPoss && IsTypeSort(
							      formType, Who))) {
                      errId3(warnOrErr(IncptblPar|CWarn|PossErr), &slExp,
					 typeToS1(eType), typeToS2(formType));}}
                  else {
                    if (formType!=NULL && IsArr(formType) && cExp.
			PointingOnObj) errWSTT(ActParNotArray|Warn1|Rdbl,
							 NULL, formType, eType);
                    heedRootType = True;
                    if (IsStrun(eType) && formParList->MayModifFl) {
                      TsemanElt *ptrId = cExp.ptrId;

                      if (ptrId != NULL) {
                        if (ptrId->kind==Param && !ptrId->MayModif && (!ptrId->
					      Dmodfd || allErrFl) && askConstFl)
                          errId2(MayModify|Warn1|Rdbl, ptrId, nameToS(
						     curFctName), errTxt[MayM]);
                        ptrId->Dmodfd = True;}}
                    if (errQalTyp1 != NULL) errWSTT(ConstQalNotHeeded2|
			ConstWarn|PossErr, (errQalTyp1 == formType)? NULL :
					errTxt[SubPre], errQalTyp1, errQalTyp2);
                    if (IsArr(eType) && !cExp.lValFl) err0(NotLValP);
/*                    if (cExp.ptrId!=NULL && eType->qualif&VolatQal) errId1(
			      CopyVolat | Warn2, cExp.ptrId, typeToS1(eType));*/
                    if (formParList->SizeofBlFl) {
                      if ((locAllocType = sizeofOpndType)==XAllocSeen && cExp.
					  rEvlbl) err0(ShdUseSizeof|Warn2|Rdbl);
                      sizeofOpndType = NULL;}
                    if (formParList->parQal == ResulTypV) {
                      if (IsTypeSort(eType, Num) && cExp.rEvlbl && !eType->
								   NxtIsTypId) {
                        if (retType == NoResulTyp) retType = NxtTypElt(
								   initialType);
                        if (retType != NULL) {
                          FreeExpType2(eType);
                          eType = allocTypeEltID(computeCstType((cExp.errEvl)?
				      0 : cExp.sVal, eType->typeSort, retType->
							   typeSort), NoQualif);
                          ((ModifType)eType)->noOwner = True;}}
                      if (resulType == NoResulTyp) resulType = arrToPtr(eType);
				 /* because array parameter passed by address */
                      else {
                        TpcTypeElt curRType, newRType = NULL;
                        TpTypeElt lastEltRType;

                        paramTxt = NULL;
                        if (CompatType(resulType, eType, FctCall) /* 'FctCall'
				       because of "strcpy(array, array/ptr)". */
                            || (lExp.type = resulType, compatNumType()))
                          if (formParList->ResulPtrFl && !CompatType(eType,
							  resulType, FctCall)) {
                            errWSTT(ResulPtrNotHghsTyp|Warn2|PossErr, dpName(
						   RESULTYP), eType, resulType);
                            curRType = arrToPtr(eType);}
                          else goto noChangeL;
                        else if (compatType(eType, resulType, FctCall)
                                 || (lExp.type = eType, cExp.type = resulType,
							     compatNumType())) {
                          if (resulPtrSeen) {
                            errWSTT(ResulPtrNotHghsTyp|Warn2|PossErr, dpName(
						   RESULPTR), eType, resulType);
                            goto noChangeL;}
                          curRType = arrToPtr(eType);}
                        else {
                          TpcTypeElt curEType = eType;

                          curRType = resulType;
                          /* Create a copy of possible type modifiers */
                          while (! curRType->NxtIsTypId) {
                            TpTypeElt w = allocTypeEltIC(curRType, NoQualif);

                            if (newRType == NULL) {newRType = w; w->noOwner =
									  True;}
                            else {lastEltRType->stopFreeing = False
						    ; lastEltRType->nextTE = w;}
                            lastEltRType = w;
                            curEType = curEType->nextTE;
                            if (curRType->nextTE == NULL) break;
                            curRType = curRType->nextTE;}
                          while (curRType->NxtIsTypId && !curRType->rootTyp) {
                            curRType = Parent(curRType);
                            if (compatType(curRType, curEType, FctCall)) goto
							  foundCommonAncestorL;}
                          errWSTT(NoHghrTyp|Warn2|PossErr, NULL, resulType,
									 eType);
                          curRType = NULL;
                          if (newRType != NULL) {FreeExpType2(newRType)
							    ; newRType = NULL;}}
foundCommonAncestorL:
                        FreeExpType2(resulType);
                        resulType = (newRType == NULL)? curRType :
				    (lastEltRType->nextTE = curRType, newRType);
noChangeL:;}
                      if (formParList->ResulPtrFl) {
                        finalPtrId = cExp.ptrId;
                        resulPtrSeen = True;}}}}
                heedRootType = True;
                if ((formParList = formParList->cdr)==NULL && ioFctNb!=0) {
                  if (eType!=NULL && IsArr(eType) && eType->generic && !cExp.
				  errEvl) {  /* correct literal format string */
                    initFlwgSpec();
                    formatFl = 1;}}}
              if (eType != resulType) FreeExpType1(eType);}
          } while (Found(COMMA));
          if (curTok.tok != RPAR) err0(RParExptd);  /* here to be before 
						   'BadActParListLgth' error. */
          if (formatFl != 0) {  /* 'initFlwgSpec()' called */
            if (formatFl>0 && folwngSpec(NULL, NULL)) err0(TooManyFmtSpe|Warn2|
								       PossErr);
            resetFlwgSpec();}
          cExp.Einfo = 0;  /* reset all flags */
          cExp.FctCallSeen1 = resulPtrSeen ^ True;}
        if (formParList!=NULL || (exhstdParList && initialType->typeSort!=VFct)
				) errId3(BadActParListLgth, &slExp, NULL, NULL);
        ioFctNb = savIoFctNb;
        cExp.hist = H_EMPTY;
        cExp.notPureBool = savCEinfo.s21._lclAdr /* no _notPureBool field... */;
        if (cExp.SjVal = savCEinfo.s21._sjVal) setjmpSeen = True;
        cExp.FctCallNoResTyp = initialType->ResTypPoss;
        {
          bool pvNrFl = initialType->pvNr;  /* PseudoVoid/NeverReturns */

          cExp.type = advInTypeChain(initialType);
          if (resulType != NoResulTyp) {
            if (cExp.type!=NULL && (!IsTypeSort(cExp.type, Flt) || resulType==
					  NULL || IsTypeSort(resulType, Flt))) {
              if (resulType != NULL) {
                TpcTypeElt rType, eType;

                rType = (resulType->typeSort == Ptr)? (eType = NxtTypElt(cExp.
		  type), NxtTypElt(resulType)) : (eType = cExp.type, resulType);
                if (rType!=NULL && eType!=NULL && rType->typeSort!=eType->
					       typeSort) cExp.ArtifType = True;}
              FreeExpType2(cExp.type);
              cExp.type = resulType;}
            else FreeExpType1(resulType);}
          cExp.topOper = (cExp.type != NULL)
                           ? (cExp.type->typeSort == Void)
                             ? (nxtStmtRchbl = (pvNrFl)? NonRchbl_Jmp : Rchbl,
								VFCTC | PRIMARY)
                             : (pvNrFl)
                               ? VFCTC | PRIMARY
                               : FCTC | PRIMARY
                           : VFCTC | PRIMARY;}
        (void)Found(RPAR);  /* here for good error position (also for good
						management of 'usrLvlParFl'). */
        cExp.ptrId = finalPtrId;
        cExp.FctCallSeen = True;
        lastCalledFct = slExp.ptrId;  /* for 'NotPureSideEffect1' error */
        allocType = locAllocType;
        sizeofOpndType = saveSizeofOpndType;
        break;}
    case LSBR: {		/* indexation */
        TresulExp slExp;
        TpcTypeElt lType;
        size_t ptdSize;
        bool savAO = apsndOpnd;

        apsndOpnd = False;
        if (initialType != NULL) {
          if (! IsPtrArr(initialType)) {
            paramTxt = "[]";
            errExp(IlgLftType, initialType, NULL);
            ptdSize = 0;}
          else {
            ptdSize = sizeOfTypeI(initialType, True, (IsArr(initialType))?
						   IncplArray : IncplPtr, NULL);
            if (IsPtr(initialType)) checkInit();}}  /* pointer represents
				       itself; array represents its elements. */
        slExp = cExp;
        GetNxtTok();
        commaExpr();
        checkInit();
        lType = slExp.type;
        CheckNumCstNamed(cExp, (lType==NULL || lType->indexType==NULL)? cExp.
						       type : lType->indexType);
        cleanExprThings();
        apsndOpnd = savAO;
        cExp.pseudoAttrib = slExp.pseudoAttrib;
        cExp.FctCallSeen = False;
        if (lType != NULL) {
          const TpcTypeElt eType = cExp.type;
          Tqualif qual = NoQualif;  /* qualifier to be propagated */

          lExp.type = lType->indexType;
          if (eType != NULL) {
            if (! IsTypeSort(eType, WhoEnumBool)) errWNT(BadIndexType1,
						  decoratedName(&slExp), eType);
            else {
              if (lType->indexType != NULL) {  /* array with bound type
						   specified (without error). */
                if ((slExp.ptrId==NULL || !slExp.ptrId->noErrTypInd) &&
		    !(cExp.sVal==0 && InsideInterval(NakedTok(cExp.topOper),
		       CSTNU, CSTNU1) && eType==&intCstTypeElt /* plain 0 */)) {
                  if (paramTxt = NULL, !compatNumType()) errId3(BadIndexType|
			Warn1|PossErr, &slExp, (lType->indexType ==
			   &defaultIndexTypeElt)? errTxt[Arithm] :
			     typeToS2NoQual(lType->indexType), typeToS1(eType));
                  else if (moreIndexTypeChk && eType->paralTyp && isRepreType(
			lType->indexType)) errId3((IsPtr(lType))?
			UseIndexTypForPtr | Warn1 : BndShdBeOfNamedType | Warn1,
			&slExp, (lType->indexType == &defaultIndexTypeElt)?
			errTxt[Arithm] : typeToS2NoQual(lType->indexType),
							       typeToS1(eType));
                  else goto noErrL;
                  if (!allErrFl && slExp.ptrId!=NULL) slExp.ptrId->noErrTypInd
									 = True;
noErrL:;}}
              if (IsPtr(lType)) indirindex(&slExp);
              else {
                if (lType->lim + 1U > 1U) {  /* array with size
						   specified (without error). */
                  TcalcS valBound = (TcalcS)lType->lim;

                  if (cExp.rEvlbl) {
                    if (   !cExp.errEvl
                        && (IsTypeSort(eType, (SigAri | Enum)) && cExp.sVal>
									valBound
                         || IsTypeSort(eType, UnsigWho) && cExp.uVal>lType->lim
                         || !apsndOpnd && cExp.sVal==valBound)) {
                      TnbBuf w;

                      bufLongToS(valBound, w);
                      errWSS(IndexValTooBig|Warn3|PossErr, longToS(cExp.sVal),
									   w);}}
                  else if (eType->typeSort < computeLstType(valBound - 1)
				) errId3(IndexTypeTooSmall | Warn2, &slExp,
					   typeToS1(eType), longToS(valBound));}
                if (cExp.rEvlbl && !cExp.errEvl && cExp.sVal<0 && IsTypeSort(
		       eType, (SigAri | Enum))) err0(NegIndexVal|Warn3|PossErr);
                cExp.notPureBool = slExp.notPureBool;  /* also .lclAdr */
                cExp.PointedByObj = (slExp.ptrId!=NULL && slExp.ptrId->kind==
			Param && slExp.ptrId->type!=NULL && IsArr(slExp.ptrId->
					      type))? True : slExp.PointedByObj;
                if (cExp.FctCallSeen1 = slExp.FctCallSeen1)
                  if (slExp.FctCallSeen) cExp.FctCallSeen = True;
                qual = lType->qualif;}}
            FreeExpType2(eType);}
          cExp.type = advInTypeChain(lType);
          if (qual!=NoQualif && cExp.type!=NULL && qual & ~cExp.type->qualif) {
            /* Propagate qualifier */
            TpTypeElt w = copyTypeEltNoOwn(cExp.type);

            w->qualif |= qual;
            cExp.type = w;}}
        else {FreeExpType(cExp); cExp.type = NULL;}
        cExp.lEvlbl = slExp.lEvlbl & cExp.rEvlbl;
        if (cExp.lEvlbl && !cExp.errEvl) cExp.pVal = slExp.pVal +
						      cExp.sVal*(TcalcS)ptdSize;
        cExp.oldUsed = slExp.oldUsed;
        cExp.hist = slExp.hist;
        if (! slExp.PointingOnObj) PushHist(H_ARRAY);
        cExp.ptrId = slExp.ptrId;
        if (! Found(RSBR)) err0(RSBrExptd);
        cExp.lValFl = ! cExp.FctCallSeen;  /* case "&fct().tab[0]" */
        cExp.cstImpsd = False;
        cExp.rEvlbl = False;
        cExp.unsigDiff = False;
        cExp.PointingOnObj = False;
        cExp.FctCallNoResTyp = False;
        cExp.topOper = LSBR | PRIMARY;
        break;}  /* cExp.ptrId not reset, for example to be able to take
				  notice of possible initialization of array. */
    default:
      return;}}
}

static void resulIncOp(TkInc oper, TmacParCtr ctrMP)
{
  TpcTypeElt eType;

  TstAlwdInCstExp();
  paramTxt = txtIncTok[oper];
  manageUsedForIncOp(); /* here because of 'usrLvlParFl' */
  if (ctrMP == lastPrimMacParCtrIM) err1(SideEffInMacPar|Warn3|PossErr);
  if ((eType = cExp.type) != NULL) {
    if (! cExp.lValFl) {errWSS(NotLVal, paramTxt, NULL); cExp.ptrId = NULL;}
    else {
      if (IsPtr(eType)) (void)sizeOfTypeI(eType, True, UndefPtdSize, paramTxt);
      else if (! IsTypeSort(eType, NumEnum)) errExp(IlgOpndType, eType, NULL);
      if (eType->qualif & ConstQal) errCompoOf(True);
      else if (cExp.PointedByObj) modifPtdVal(WillM);}}
  cExp.lValFl = False;
}

static void specialCaseOp(TkAdd oper)
/* If 'AddSubAsgn': does not change either cExp.ptrId or lExp.ptrId,
   else if 'pointer +/- nb' sets cExp.ptrId to lExp.ptrId (done in fact by
								   resulExp() ),
   else sets cExp.ptrId to NULL. */
{
  const TpcTypeElt lType = lExp.type, eType = cExp.type;
  const TtypeSort tsl = lType->typeSort;

  if (tsl==Enum /* enum +/- distance */
      || tsl & NumEnum && lType->rootTyp && lExp.rEvlbl &&
			       cExp.rEvlbl /* so that "(RootType)3 + 1" OK */) {
    /* Heterogeneous operands possible */
    if (eType != NULL) {
      if (!eType->paralTyp && eType->typeSort & (Int | Short | Byte)) {
        if (eType->sysTpdf && !cExp.rEvlbl && chkPortbl) errWSTT(NonPortOpnd |
						CWarn2, paramTxt, eType, lType);
        if (oper != AddSubAsgn) {
          FreeExpType2(eType);  /* in order to get left operand result type */
          cExp.type = lType;
          cExp.ptrId = NULL;
          lExp.macLvl = cExp.macLvl;  /* to prevent additional warnings */
          resulExp(NumEnum, False, (oper == Add)? &computeAdd : &computeSub,
							   cExp.macLvl, ADDOP);}
        goto exitL;}}}
  else if (IsPtrArrSort(tsl)) {
    size_t ptdSize;

    {
      TresulExp w = cExp;

      cExp = lExp;
      ptdSize = sizeOfTypeI(lType, True, UndefPtdSize, paramTxt);
      cExp = w;}
    if (eType != NULL) {
      if (oper==Sub && IsPtr(eType)) {
        if (!CompatType(lType, eType, NoCheck) || !CompatType(lType->indexType,
	      eType->indexType, VerifCast)) errWSTT(warnOrErr(DiffIncptblPtr|
						  PossErr), NULL, lType, eType);
        else if (lExp.lclAdr!=cExp.lclAdr && (loopLvl==0 || loopLvl>0 &&
	      condStmtLvl==initialLoopCondLvl || lExp.PointingOnObj && cExp.
				PointingOnObj)) err0(MnlsPtrDiff|Warn3|PossErr);
        FreeExpType2(eType);
        cExp.type = managePredefTypes(PTRDIFF_T);
        if (cExp.rEvlbl) {
          if (ptdSize!=0 && !cExp.errEvl) cExp.sVal = (TcalcS)((lExp.pVal -
						 cExp.pVal)/(ptrdiff_t)ptdSize);
          ((ModifType)(cExp.type = copyTypeEltNoOwn(cExp.type)))->generic =
									  True;}
        cExp.PointingOnObj = False;
        goto freeLTypeL;}
      if (! IsTypeSort(eType, WhoEnumBool)) errWSTT(IlgRhtType, paramTxt,
								   eType, NULL);
      else {
        TsemanElt *ptrLId;

        lExp.type = (lType->indexType != NULL)? lType->indexType :
							   &defaultIndexTypeElt;
        if (((ptrLId = lExp.ptrId)==NULL || !ptrLId->noErrTypInd) &&
		  !(cExp.uVal<=1 && InsideInterval(NakedTok(cExp.topOper),
		     CSTNU, CSTNU1) && eType==&intCstTypeElt /* plain 0/1 */)) {
          Tstring savParamTxt = paramTxt;

          if (paramTxt = NULL, !compatNumType()) errId3(BadIndexType|Warn1|
		PossErr, &lExp, (lExp.type == &defaultIndexTypeElt)? errTxt[
			  Arithm] : typeToS2NoQual(lExp.type), typeToS1(eType));
          else if (moreIndexTypeChk && eType->paralTyp && isRepreType(lExp.
		  type)) errId3(UseIndexTypForPtr | Warn1, &lExp, (lExp.type
		    == &defaultIndexTypeElt)? errTxt[Arithm] : typeToS2NoQual(
						   lExp.type), typeToS1(eType));
          else goto noErrL;
          if (!allErrFl && ptrLId!=NULL) ptrLId->noErrTypInd = True;
noErrL:
          paramTxt = savParamTxt;}}}
    if (oper != AddSubAsgn) {
      if (cExp.rEvlbl) cExp.pVal = (oper == Add)? lExp.pVal + cExp.sVal*
			(TcalcS)ptdSize : lExp.pVal - cExp.sVal*(TcalcS)ptdSize;
      if (compatType(preLastCastType, &voidPtrTypeElt, VerifCastF)
		   ) freePrevCast();  /* case "void *a;...;a = (int *)a + 1;" */
      FreeExpType1(eType);
      if (tsl == Array) {  /* "tab + i" */
        errWSTT(IlgLftType|Warn1|Rdbl, paramTxt, lType, NULL);
						       /* not string constant */
        ((ModifType)(cExp.type = copyTypeEltNoOwn(lType)))->typeSort = Ptr;}
      else cExp.type = lType;
      cExp.hist = lExp.hist;}
    cExp.lclAdr = lExp.lclAdr;
    cExp.FctCallNoResTyp = lExp.FctCallNoResTyp;
    cExp.pseudoAttrib = lExp.pseudoAttrib;
    goto exitL;}
  if (oper==Add && eType!=NULL &&
       (!lType->paralTyp
         && (eType->typeSort==Enum || tsl & NumEnum && lType->rootTyp && lExp.
							  rEvlbl && cExp.rEvlbl)
         && tsl & (Int | Short | Byte)
        || (IsPtr(eType) || IsArr(eType) && eType->generic)
         && IsWhoEnumNotChar(lType)))
    errExp(TryPermut|Warn2|Rdbl, lType, typeToS2(eType));
  else if (oper == AddSubAsgn) errAsgn = True;
  else errWrngType(NumEnum | PtrPoss);  /* 'PtrPoss' because Array<=>Ptr */
freeLTypeL:
  cExp.lclAdr = False;
  if (oper != AddSubAsgn) {FreeExpType2(lType); cExp.ptrId = NULL;}
exitL:
  cExp.cstImpsd = False;  /* well-defined type anyway */
  cExp.unsigDiff = False;
}

/******************************************************************************/
/*                                 UTILITIES                                  */
/******************************************************************************/

static TpcTypeElt advInTypeChain(TpcTypeElt x)
{
  TpcTypeElt nxtType = NxtTypElt(x);

  if (x->noOwner) {
    if (nxtType!=NULL && !nxtType->shared && !x->stopFreeing) ((ModifType)
			    nxtType)->noOwner = True;  /* propagate attribute */
    (void)freeTypeElt(x);}
  return nxtType;
}

static AllocXElt(allocNotInitVarElt, TnotInitVar, ctrNI, ;)

static TpcTypeElt arrToPtr(TpcTypeElt type)
{
  if (! IsArr(type)) return type;
  {
    TpTypeElt nType = copyTypeEltNoOwn(type);

    nType->typeSort = Ptr;
    nType->size = PtrSiz;
    nType->nextTE = NxtTypElt(nType);
    nType->generic = False;
    nType->paralTyp = False;
    nType->NxtIsTypId = False;
    if (nType->qualif&ConstQal && nType->nextTE!=NULL && !(nType->nextTE->
			qualif & ConstQal)) {  /* propagate 'const' qualifier */
      TpTypeElt nNxtType = copyTypeEltNoOwn(nType->nextTE);

      nNxtType->qualif |= ConstQal;
      nType->nextTE = nNxtType;
      nType->stopFreeing = False;}
    return nType;}
}

static bool authzdType(TpcTypeElt type, TtypeSort msk, bool *pErrFl, Terr x)
{
  TtypeSort msk1, ts;

  if (type==NULL || (((ts = type->typeSort) < DelType)
                       ? ts
                       : (ts==Ptr || ts==Array && type->generic)
                         ? PtrPoss
                         : (IsStrunSort(ts))
                           ? StrunPoss
                           : Void) & msk) return True;  /* type authorized
								      by dcc. */
  msk1 = (msk & WhoEnumBool)? WhoEnumBool : Void;  /* 'real' C integral types */
  if (msk & (Flt | BoolOpnd)) msk1 |= Flt;
  errWSTT(x | (((IsPtrArrSort(ts))? msk&(PtrPoss | BoolOpnd) : ts&msk1)? Warn2 :
				  (*pErrFl = True, Err)), paramTxt, type, NULL);
  return False;
}

static void castValue(TtypeSort ts)
/* Truncate value (making no assumption as to internal representation of
   numbers). */
{
  if (ts & UnsigWho) ts &= UnsigWho;
  switch (ts) {	/* *doIt* float/crossCompil */
#if defined(LONGLONG) || ULONG_MAXC>UINT_MAXC
    case Long:	cExp.sVal = (TcalcS)(long)cExp.sVal; break;
    case ULong:	cExp.uVal = (TcalcU)(ulong)cExp.uVal; break;
#endif
    case Int:	cExp.sVal = (TcalcS)(int)cExp.sVal; break;
    case UInt:	cExp.uVal = (TcalcU)(uint)cExp.uVal; break;
    case Short:	cExp.sVal = (TcalcS)(short)cExp.sVal; break;
    case UShort:cExp.uVal = (TcalcU)(ushort)cExp.uVal; break;
    case Byte:	cExp.sVal = (TcalcS)(byte)cExp.sVal; break;
    case UByte:	cExp.uVal = (TcalcU)(ubyte)cExp.uVal; break;
    /*~ NoDefault */}
}

static void checkIncldFiles(const TsemanElt *ptrId)
{
  if (!headerFile && !ptrId->defnd && (!ReallyInsideMacro || curMacDFName()==
	curFileName) && chkInclPos && ptrId->declaringFile!=nonFileName &&
	   !isBodyHdrFile(ptrId->declaringFile) && addLvl0InclFName(ptrId->
	     declaringFile)) errWNSS(BadlyIncldHdrFile|Warn1|Rdbl, ptrId->nameb,
		ptrId->declaringFile, NULL);  /* message only once for each
									file. */
}

static void checkInfoLoss(TpcTypeElt x)
/* Check for loss of information (constant expression too big for 'x' type) */
{
  if (!cExp.errEvl && x!=NULL) {
    TtypeSort ts = x->typeSort;

    if (ts == Bool) ts = UInt;
    else if (ts == Enum) ts = (x->tagId == NULL)?
#if SignedChar
						  Byte
#else
						  UByte
#endif
							: Int; /* 'real' enum */
    if (cExp.type!=NULL && computeTypeSort(cExp.sVal, cExp.type->typeSort, ts)>
					       ts) {errOvfl(x); castValue(ts);}}
}

void checkInit(void)
{
  register TsemanElt *ptrId;

  if ((ptrId = cExp.ptrId)!=NULL  && evaluateFl) {
    ptrId->MsngConstQM = False;
    if (!ptrId->initlz && ptrId->kind==Obj && (ptrId->attribb>=Auto || ptrId->
	attribb==StatiL) && !cExp.PointingOnObj && (!ScanfFl || cExp.type!=NULL
							 && IsPtr(cExp.type))) {
      if (loopLvl==0 || loopLvl>0 && condStmtLvl==initialLoopCondLvl) errInit(
			   ptrId, 0, NULL, initDPFl);  /* must be initialized */
      else {
        /* Might be initialized later, so add to list to be checked at end of
           loop. */
        register TnotInitVar *w = notInitVarList;

        while (w != NULL) {
          if (ptrId == w->ptrId) return;  /* already in list */
          w = w->prev;}
        w = allocNotInitVarElt();
        w->ptrId = ptrId;
        w->lineNb = lineNb;
        w->fileName = curFileName;
        w->initDPFl = initDPFl;
        w->prev = notInitVarList;
        notInitVarList = w;}}}
}

void checkNumCstNamed(TresulExp *pExp, TpcTypeElt sinkType)
{
  if ((pExp->type==NULL || !pExp->type->litCsta) && !CheckSink(pExp, sinkType)){
    if (!chkNumCst1 || !goodPrgmg) return;
    err0((pExp->LitCstOutsMac)? NumCstShdBeNamed|Warn1|Rdbl :
						 NumCstShdBeNamed1|Warn1|Rdbl);}
  pExp->litCst = False;
  pExp->LitCstOutsMac = False;
}

static void checkPureBool(void)
{
  if (lExp.type!=NULL && lExp.type->typeSort==Bool || cExp.type!=NULL &&
						    cExp.type->typeSort==Bool) {
    warnNotPureBool(&lExp, errTxt[Left]);
    warnNotPureBool(&cExp, errTxt[Right]);}
}

void checkSideEffect(void)
/* Done that way so that warns even if bad expression type */
{
  const TpcTypeElt eType = cExp.type;

  CheckNumCstNamed(cExp, eType);
  if (! IsSideEffect(cExp)) {
    if (NakedTok(cExp.topOper) == FCTC) {
      TfctInfo fctInf = fctInfo(lastCalledFct);

      if (goodPrgmg || fctInf>=NOINFO) {
        cExp.ptrId = lastCalledFct;
        errWNSS(NotPureSideEffect1|CWarn2|PossErr, decoratedName(&cExp),
		(lastCalledFct == NULL)
		   ? NULL
		   : errTxt[(fctInf < NOINFO)? CastToVoid : UsePsdVoidDP],
									NULL);}}
    else {
      if (eType!=NULL && eType->typeSort!=Void) err0((IsFct(eType))
			? MsngFctParen|CWarn3|PossErr
			: NotPureSideEffect|CWarn2|PossErr);}
    cExp.ptrId = NULL;}
  else {
    if (NakedTok(cExp.topOper) == VFCTC) cExp.ptrId = NULL;}  /* for ~PseudoVoid
						  functions with ~ResultType. */
  valueNotUsed();  /* so that, for example, "a++;" => NotUsed */
  FreeExpType1(eType);
}

void cleanExprThings(void)
/* cleanExprThings (or managePointers) should be called at end of each expression,
   be it correct or not. */
{
  if (preLastCastType != NULL) freePrevCast();
  if (allocType != NULL) freeAlloc();
  if (setjmpSeen) {err0(ChkSetjmpDsbld|Warn1|PossErr); setjmpSeen = False;}
}

static TpcTypeElt commonType(TtypeSort msk)
/* Returns NULL if type incompatibility between lExp.type, cExp.type and 'msk';
   else resulting type.
   To be kept coherent with 'compatType()' ("dcdecl.c") */
{
  TpcTypeElt lType = lExp.type, rType = cExp.type;
  TtypeSort tsl = lType->typeSort, tsr, resTS;
  bool rhtHghrParal, retRepreType;

  convToUnsgnd = NoErrMsg;
  if (lType==rType && (tsl & msk & NumEnumBool)) return lType;
  tsr = rType->typeSort;
  resTS = tsl & tsr & msk & NumEnumBool;
  rhtHghrParal = retRepreType = False;
  {
    TpcTypeElt lTyp1, rTyp1;

    if (lType->NxtIsTypId) {
      lTyp1 = lType; rTyp1 = rType;}
    else {
      if (! rType->NxtIsTypId) goto mayBeOkL;  /* none parallel type */
      lTyp1 = rType; rTyp1 = lType;}
    if (! rTyp1->NxtIsTypId) {  /* only one is parallel type */
      /* Is it visible from the other one ? */
      do {
        if (lTyp1->rootTyp && heedRootType) {rhtHghrParal = True; goto
						tstBoolViaInsertBool;}  /* no */
        lTyp1 = Parent(lTyp1);
      } while (lTyp1->NxtIsTypId);
      if (rType->sysTpdf && !rType->paralTyp && !rType->generic) goto
								    rHiMayBeOkL;
      /* Is one typeSort subset of the other? */
      if (resTS == Void) {   /* no */
        if (rTyp1->generic) {
          if (lType->generic) {if (tsr & Flt) tsl = tsr;}
          else {if (tsl & Flt) tsr = tsl;}
          goto mayBeOkL;}
        retRepreType = True;
        goto rHiMayBeOkL;}  /* so as to get new typeElt (because "wider repre-
					     sentation type is higher type"). */
      if (lType->paralTyp) {
        if (rTyp1->generic) goto mayBeOkL;
        goto rHiMayBeOkL;}
      if (! rTyp1->generic) goto mayBeOkL;
      goto rHiMayBeOkL;}
    /* Both parallel type: find if one is higher and, if so, which one */
    if (lTyp1->typeId == rTyp1->typeId) goto mayBeOkL;  /* 'typeId' checked
		     (and not lTyp1 == rTyp1) because of possible qualifiers. */
    for (;; lTyp1 = rType, rTyp1 = lType, rhtHghrParal = True) {
      /* Row up hierarchy */
      while (!rTyp1->rootTyp || !heedRootType) {
        rTyp1 = Parent(rTyp1);
        if (! rTyp1->NxtIsTypId) {
          if (lTyp1->sysTpdf && !lTyp1->paralTyp) goto mayBeOkL;
          break;}
        if (rTyp1->typeId == lTyp1->typeId) {  /* lTyp1 higher than rTyp1 */
          rhtHghrParal = (lTyp1->generic != rhtHghrParal);
          goto mayBeOkL;}}
      if (rhtHghrParal) break;}  /* exit loop */
    /* no higher type */
tstBoolViaInsertBool:
    if (!(resTS & Bool) || tsl==Bool && tsr==Bool) return NULL;  /* if not
				  case "'bool' inserted" (via insertBool() ). */
rHiMayBeOkL:
    rhtHghrParal ^= True;
mayBeOkL: ;}
  if (!(resTS & Enum) || lType->tagId!=rType->tagId) {  /* not enums or not
								  same enums. */
    /* First, take care of 'bool' case (beware of 'insertBool()') */
    resTS &= Bool;
    if ((tsl &= msk & Num)==Void || (tsr &= msk & Num)==Void) {
      if (resTS == Void) return NULL;}
    else {
      /* Mixing variable and constant (expression) ? */
      if (cExp.rEvlbl) {
        if (lExp.rEvlbl) {
          /* Parallel type constant op generic constant => parallel type */
          if (! lType->paralTyp) {
            if (rType->paralTyp) goto computeRepreTslL;
            goto noChangeL;}}
        else if (!cExp.cstImpsd /* not 'multi-typed' constant */ || tsl>=tsr /*
		   then, computation of real typeSort useless*/) goto noChangeL;
        tsr = computeCstType(cExp.sVal, tsr, tsl);
noChangeL:;}
      else if (lExp.rEvlbl && lExp.cstImpsd && tsl>tsr)
computeRepreTslL:
        tsl = computeCstType(lExp.sVal, tsl, tsr);
      /* 'Usual arithmetic conversions': find greater type */
      {
        TtypeSort gtTS;

        if (tsl == tsr) {
          if (! lExp.cstImpsd) cExp.cstImpsd = False;
          if (! lExp.FctCallNoResTyp) cExp.FctCallNoResTyp = False;
          gtTS =  tsl;}
        else if (tsl > tsr) {
          cExp.cstImpsd  = lExp.cstImpsd;
          cExp.FctCallNoResTyp = lExp.FctCallNoResTyp;
          gtTS = tsl;}
        else gtTS = tsr;
#if UINT_MAXC == ULONG_MAXC
        if (gtTS==Long && (tsl==UInt || tsr==UInt)) gtTS = ULong;
#endif
        if (gtTS & UnsigWho) {
          if (!(lType->typeSort & UnsigWho) && !(lExp.rEvlbl && (lExp.errEvl ||
					    lExp.sVal>=0))) convToUnsgnd = Left;
          if (!(rType->typeSort & UnsigWho) && !(lType->typeSort & Enum) && !(
	   cExp.rEvlbl && (cExp.errEvl || cExp.sVal>=0))) convToUnsgnd = Right;}
        resTS |= gtTS;}}}
  if (!rhtHghrParal && resTS==lType->typeSort && (!lType->generic || rType->
							 generic)) return lType;
  if (!retRepreType && resTS==rType->typeSort && (!rType->generic || lType->
							 generic)) return rType;
  /* Parallel type op generic => original parallel type (because of
							       insertBool()). */
  if (rType->generic && lType->NxtIsTypId && resTS==lType->typeId->namedType->
				      typeSort) return lType->typeId->namedType;
  if (lType->generic && rType->NxtIsTypId && resTS==rType->typeId->namedType->
				      typeSort) return rType->typeId->namedType;
  {  /* New type element needed for result */
    TpTypeElt newElt = allocTypeEltID(resTS, NoQualif);

    newElt->noOwner = True;
    newElt->size = (resTS & lType->typeSort)? lType->size : rType->size;
    newElt->tagId = lType->tagId;  /* == rType->tagId */
    if (lType->generic && rType->generic) newElt->generic = True;
    return newElt;}
}

static bool compatNumType(void)
{
  TpcTypeElt resType, lType = lExp.type, eType = cExp.type;
  bool resul;

  lExp.cstImpsd = cExp.cstImpsd; lExp.rEvlbl = False;
  if ((resType = commonType(mskCmpat | (TtypeSort)SIGN_BIT)) == NULL) return
									  False;
  resul = True;
  if (lType->sysTpdf!=eType->sysTpdf && lType->typeSort>=eType->typeSort &&
				  !cExp.rEvlbl && paramTxt!=NULL && chkPortbl &&
		(lType->sysTpdf && InsideInterval(eType->typeSort, Long, Num) ||
		 eType->sysTpdf && !InsideInterval(lType->typeSort, Long, Num)))
    errWSTT(NonPortCmbn | CWarn1, paramTxt, lType, eType);
  else if (   resType!=lType
           && (   lType->paralTyp
               || (resType->typeSort & lType->typeSort)==Void  && !(lType->
				typeSort==Float & resType->typeSort==Double))) {
    if (paramTxt == NULL) resul = False;
    else {
      if (cExp.cstImpsd && !(IsTypeSort(resType, Flt) && IsTypeSort(lType,
									Who))) {
        if (! (cExp.rEvlbl && (cExp.errEvl || computeTypeSort(cExp.sVal,
	    eType->typeSort, lType->typeSort)<=lType->typeSort))) errOvfl1(
							      lType, paramTxt);}
      else if (convToUnsgnd != NoErrMsg) {
        if (! (cExp.rEvlbl && (cExp.errEvl || cExp.sVal>=0 && computeLstType(
		cExp.sVal)<=lType->typeSort))) errWSTT((convToUnsgnd == Left)?
		 PossOvfl|Warn2|PossErr : ConvToUnsig1|Warn2|PossErr,
						       paramTxt, lType, eType);}
      else resul = False;}}
  else if (convToUnsgnd!=NoErrMsg && paramTxt!=NULL)
    errWSTT(ConvToUnsig1|Warn2|PossErr, paramTxt, lType, eType);
  if (resType!=lType && resType!=eType) FreeExpType2(resType);
  return resul;
}

static TtypeSort computeCstType(TcalcS value, TtypeSort tsCst, TtypeSort tsTgt)
/* Returns the smallest type (compatible with 'tsTgt') in which {'value', 'ts-
   Cst'} can be represented. */
{
  TtypeSort resTS;

#if defined(LONGLONG) || ULONG_MAX /* not _MAXC ! */>UINT_MAXC
  if (value > 0) {
#  if defined(LONGLONG)
    if ((TcalcU)value & ~(ulong)LONG_MAXC && tsCst&ULong) value = (TcalcS)
				    ((TcalcU)value ^ (~(TcalcU)0 - ULONG_MAXC));
    else if
#  else
    if
#  endif
            ((TcalcU)value & ~(uint)INT_MAXC && tsCst&UInt) value = (TcalcS)
		 ((TcalcU)value ^ (~(TcalcU)0 - UINT_MAXC));}  /* sign-extend
							for 'computeLstType'. */
#endif
  tsTgt = (tsTgt & (SigAri | Enum))? SigAri : UnsigWho;
  if (tsCst & (SigAri | Enum)) tsCst = SigAri;
  else {
    if (tsTgt == SigAri) return tsCst;  /* do not loose fact that -1u >
								     INT_MAX. */
    tsCst = UnsigWho;}
  if ((resTS = computeLstType(value)) == Bool) resTS = Byte;
  if (! (resTS & tsCst & tsTgt)) {  /* keep 'signed'/'unsigned' property;
						  beware of case "i = -250u". */
    TtypeSort msk = (value < 0)? tsCst : resTS;

    for (;;) {
      if (! (resTS & msk)) resTS = 
#if USHRT_MAXC == UINT_MAXC
				    (resTS == UShort)
				      ? Long :  /* because 40000=>UShort=>Long
						(not Int), if 'int' is defined
						to be equivalent to 'short'. */
#elif UINT_MAXC == ULONG_MAXC
				    (resTS == UInt)
				      ? ULong :
#endif
				    resTS << 1;
      if (msk == tsTgt) break;
      msk = tsTgt;}}
  return resTS;
}

static TtypeSort computeTypeSort(TcalcS value, TtypeSort tsCst, TtypeSort tsTgt)
/* Returns the smallest type (compatible with 'tsTgt') in which {'value', 'ts-
   Cst'} can be represented. */
{
  TtypeSort resTS;

#if defined(LONGLONG) || ULONG_MAX /* not _MAXC ! */>UINT_MAXC
  if (value > 0) {
#  if defined(LONGLONG)
    if ((TcalcU)value & ~(ulong)LONG_MAXC && tsCst&ULong) value = (TcalcS)
				    ((TcalcU)value ^ (~(TcalcU)0 - ULONG_MAXC));
    else if
#  else
    if
#  endif
            ((TcalcU)value & ~(uint)INT_MAXC && tsCst&UInt) value = (TcalcS)
		 ((TcalcU)value ^ (~(TcalcU)0 - UINT_MAXC));}  /* sign-extend
							for 'computeLstType'. */
#endif
  if (value>=0 || tsCst & (SigAri | Enum) || !(tsTgt & (SigAri | Enum))) {
    if ((resTS = computeLstType(value)) == Bool) resTS = Byte;
    return resTS;}
#if USHRT_MAXC  == UINT_MAXC
  if (tsCst == UShort) return UInt;
#endif
#if UINT_MAXC == ULONG_MAXC
  if (tsCst == UInt)   return ULong;
#endif
  return tsCst;
}

static TtypeSort computeLstType(TcalcS value)
/* Gives back first type large enough for value 'value' */
{
  /* *doIt* float */
  if ((TcalcU)value <= 1) return Bool;
  if ((TcalcU)(value - SCHAR_MINC) <= (TcalcU)(SCHAR_MAXC-SCHAR_MINC)) return
									   Byte;
  if ((TcalcU)value <= UCHAR_MAXC) return UByte;
  if ((TcalcU)(value - SHRT_MINC) <= (TcalcU)(SHRT_MAXC - SHRT_MINC)) return
									  Short;
  if ((TcalcU)value <= USHRT_MAXC) return UShort;
#if defined(LONGLONG) || ULONG_MAX /* not _MAXC ! */>UINT_MAXC
  if ((TcalcU)(value - INT_MINC) <= (TcalcU)((TcalcS)INT_MAXC - INT_MINC)
								   ) return Int;
  if ((TcalcU)value <= UINT_MAXC) return UInt;
#  ifdef LONGLONG
  if ((TcalcU)(value - LONG_MINC) <= (TcalcU)((TcalcS)LONG_MAXC - LONG_MINC)
								  ) return Long;
  if ((TcalcU)value <= ULONG_MAXC) return ULong;
  return LLong;
#  else
  return Long;
#  endif
#else
  return Int;
#endif
}

bool computeSigAdd(TcalcS x, TcalcS y, TcalcS *pRes)
{
  register TcalcS w = x + y;

  *pRes = w;
  return ! (x>0 && y>0 && w<0 || x<0 && y<0 && w>=0
#if LONG_MINC + LONG_MAXC == 0
						    || w-y!=x
#endif
							     );
}

static TpTypeElt copyTypeEltNoOwn(TpcTypeElt x /*~MayModify*/)
{
  if (x->noOwner) return (ModifType)x;
  {
    TpTypeElt res = allocTypeEltIC(x, NoQualif);

    res->noOwner = True;
    return res;}
}

static void createBoolResult(void)
{
  FreeExpType(cExp);
  cExp.type = (sysHdrFile && ifDirExp)? &intCstTypeElt : (cExp.rEvlbl)?
						 &boolCstTypeElt : &boolTypeElt;
  cExp.notPureBool = False;
  cExp.unsigDiff = False;
  cExp.cstImpsd = False;
}

static void errCompoOf(bool notStrun)
{
  Tmember w = isMember(&cExp);
  Tstring compoOf = (w == NotMember)? NULL : errTxt[(w > NotMember)? ComponOf
								    : ComposOf];
  bool dotPopd = False;

  if ((cExp.hist & MskHistElt) == H_DOT) {dotPopd = True; PopHist(cExp.hist);}
  errId3((notStrun)? NotModfbl : ConstStrun, &cExp, (notStrun)? paramTxt :
						  typeToS1(cExp.type), compoOf);
  if (dotPopd) PushHist(H_DOT);
}

static void errExp(Terr x, TpcTypeElt t, Tstring str)
{
  errWSSSS(x, paramTxt, typeToS1(t), str, NULL);
  FreeExpType(cExp);
  cExp.type = NULL;
  if (! (x & WarnMsk)) cExp.errEvl = True;
}

static void errOvfl(TpcTypeElt type)
{
  errOvfl1(type, paramTxt);
}

static void errOvfl1(TpcTypeElt type, Tstring x)
{
  if (! cExp.errEvl) {
    errWSTT(((type->typeSort & SigWhoEnum) != Void)? Overflow|Warn2|PossErr :
					Overflow2|Warn2|PossErr, x, type, NULL);
    cExp.errEvl = True;}
}

static bool errSinkType(Terr msgNb, Tstring x) /*~PseudoVoid*/
{
  bool resul;
  TfctInfo fctInf = fctInfo(cExp.ptrId);

  msgNb = warnOrErr(msgNb);
  errWSTSNS(msgNb, x, cExp.type, paramTxt, decoratedName(&cExp),
            ((resul = (bool /*~OddCast*/)(msgNb & WarnMsk)) && !(fctInf &
							  (RESTYPFCT | SYSFCT)))
            ? (compatType(cExp.type, lExp.type, Asgn))
              ? (cExp.FctCallNoResTyp)
                ? errTxt[UseResTypOrGeneDP]
                : (cExp.FctCallSeen1)
                  ? (fctInf & MALLOCLIKEFCT)
                    ? errTxt[UseGeneAndSOMBlDP]
                    : errTxt[UseGenericDP]
                  : NULL
              : (cExp.FctCallNoResTyp)
                ? errTxt[UseResTypDP]
                : NULL
            : NULL);
  return resul;
}

static void errUdfl(void)
{
  if (! cExp.errEvl) {
    err1(Underflow|Warn2|PossErr);
    cExp.errEvl = True;
    cExp.sVal = 0;}
}

static bool errWrngType(TtypeSort msk) /*~PseudoVoid*/
/* Returns True if 'real' error (that is, error for "regular C") or either type
   is NULL (type error occurred earlier), else False. */
{
  const TpcTypeElt lType = lExp.type, eType = cExp.type;
  bool resul = False, errMsg = False;

  if (! authzdType(lType, msk, &resul, IlgLftType|PossErr)) errMsg = True;
  if (! authzdType(eType, msk, &resul, IlgRhtType|PossErr)) errMsg = True;
  if (eType==NULL || lType==NULL) resul = True;
  if (!errMsg && !resul && (chkBool || !(msk & BoolOpnd))) {
    Terr n = warnOrErr((compatType(lType, eType, IlgIcp))? IlgTypes | PossErr :
						    IncptblTypes|PossErr|CWarn);

    if ((n & WarnMsk) == Err) resul = True;
    errWSTTS(n, paramTxt, lType, eType, (!resul && lType->paralTyp && eType->
				       paralTyp)? errTxt[UseTypCmbnDP] : NULL);}
  errExp(NoErrMsg, NULL, NULL);  /* cExp.type can be freed now */
  return resul;
}

static void freeAlloc(void)
{
  if (allocType != XAllocSeen) FreeExpType2(allocType);
  allocType = NULL;
}

static bool frstMemberCompat(TpcTypeElt type, TtypeSort castTSort)
{
  const TdeclElt *member;

  if ((member = BaseStrunType(type)->memberList) == NULL) return True;
  do {
    if (member->type==NULL || member->type->typeSort==castTSort || IsStrun(
	member->type) && frstMemberCompat(member->type, castTSort)) return True;
  } while (type->typeSort==Union && (member = member->cdr)!=NULL);
  return False;
}

static void freePrevCast(void)
{
  if (preLastCastType != NULL) {
    FreeExpType2(preLastCastType);
    preLastCastType = NULL;}
}

static bool ignorableDP(TmacParCtr x)
{
  bool resul = !InsideMacPar && macParCtr!=x;

  GetNxtTok();
  return !dpHereOrAloneInMac() && resul;
}

static void indir(void)
{
  TpcTypeElt eType = cExp.type;

  if (eType != NULL) {
    if (! (IsPtr(eType) || IsArr(eType) && eType->generic)) {
      errExp(((paramTxt[0] == '-')? IlgLftType : IlgRhtType) |
			       ((IsArr(eType))? Warn1|Rdbl : Err), eType, NULL);
      goto noCheckInit;}
    lExp.type = eType->indexType;  /* for possible '&' operator applied on *x */
    cExp.type = (cExp.ArtifType)? (FreeExpType2(eType), &natTyp[VoidDpl]) :
							 advInTypeChain(eType);}
  checkInit();
noCheckInit:
  cExp.lEvlbl = cExp.rEvlbl;
  cExp.cstImpsd = False;
  cExp.unsigDiff = False;
  cExp.lValFl = True;
  cExp.FctCallSeen = False;
  cExp.FctCallNoResTyp = False;
  indirindex(&cExp);
  if (! cExp.PointingOnObj) PushHist(H_PTR);
  else cExp.PointingOnObj = False;
}

static void indirindex(const TresulExp *x /*~MayModify*/)
{
  cExp.pseudoAttrib = (x->pseudoAttrib == NoAttrib)
			? NoAttrib
			: (x->lclAdr)
			  ? Auto
			  : Stati;
  cExp.rEvlbl = False;
  cExp.lclAdr = False;
  if (x->PointingOnObj) {if (x->ptrId != NULL) x->ptrId->used = True;}
  else cExp.PointedByObj = True;
}

void initExp(void)
{
  stddefIncldFl = False;
}

static void insertBool(TtypeSort rExpTypeSort)
{
  if (cExp.type != NULL) {
    if (lExp.type==NULL || lExp.type->typeSort!=Bool || rExpTypeSort!=Bool) {
      cExp.type = copyTypeEltNoOwn(cExp.type);
      ((ModifType)cExp.type)->typeSort |= Bool;
      if (!cExp.rEvlbl || cExp.uVal>1) cExp.notPureBool = True;}
    else if (lExp.notPureBool) cExp.notPureBool = True;
    if (lExp.inhibWaNPB) cExp.inhibWaNPB = True;}
}

static Tmember isMember(const TresulExp *x)
/* Returns positive non-nul if *x describes a strun member (usually 'Member';
   'SingleMember' if sole member of struct, or member of union with no composed
   member). */
{
  if (x->ptrId==NULL || x->PointingOnObj) return NotMember;
  {
    TpcTypeElt w = x->ptrId->type;
    Thistory history = x->hist;

    if (history != H_EMPTY) {
      /* Explore history searching a 'dot' (access to a strun) */
      while ((history & (MskHistElt << (sizeof(history)*CHAR_BIT - SizeHistElt)
					 )) == H_EMPTY) history <<= SizeHistElt;
      while (history & ((H_PTR & H_ARRAY) << (sizeof(history)*CHAR_BIT -
	 SizeHistElt)) && w!=NULL) {w = NxtTypElt(w); history <<= SizeHistElt;}}
    if (x->type == w) return NotMember;
    if (history >> (sizeof(history)*CHAR_BIT - SizeHistElt) != H_DOT) return
								      Composite;
    {
      const TdeclElt *w1;

      if (w==NULL || (w1 = w->memberList)==NULL || w->typeSort==Struc && w1->
						       cdr!=NULL) return Member;
      do {
        if (w1->type!=NULL && IsCmpsdObj(w1)) return Member;
      } while ((w1 = w1->cdr) != NULL);}}
  return SingleMember;
}

static bool isType(void)
{
  return IsDecl1(BDecl) || curTok.tok==IDENT && curTok.ptrSem!=NULL &&
						      curTok.ptrSem->kind==Type;
}

static bool manageInitlzUsed(void) /*~PseudoVoid*/
/* Answers True if current object has to be marked 'not used' */
{
  bool resul = False;
  register TsemanElt *rPtrId;

  if (!cExp.PointedByObj && (rPtrId = cExp.ptrId)!=NULL && !zifExp) {
    if (rPtrId->initBefUsd && rPtrId->attribb!=Extrn) {
      if (!cExp.oldUsed || !rPtrId->defnd /* because of ~NotUsed */) {
        errWN(UslInitBU|Warn1|Rdbl, rPtrId->nameb);
        rPtrId->initBefUsd = False;}}  /* to prevent further error */
    if (rPtrId->attribb>=Auto || rPtrId->attribb==StatiL) {
      if (   !rPtrId->used && rPtrId->initlz && condStmtLvl==0
          && (   rPtrId->type==cExp.type
              || rPtrId->type==NULL
              || !(   IsArr(rPtrId->type)
                   || IsStrun(rPtrId->type) && isMember(&cExp)==Member))
	) errWNSS(UnusedVar1|Warn2|PossErr, rPtrId->nameb, NULL,
			      (rPtrId->MsngConstQM)? errTxt[MsngConstQ] : NULL);
      resul = (loopLvl==0 && rPtrId->attribb>=Auto);}
    rPtrId->initlz = True;}
  return resul;
}

#if defined(LONGLONG) || ULONG_MAX /* not _MAXC ! */>UINT_MAXC
static void manageLeftBits(void)
/* For no wrong overflow error detection */
{
  if (cExp.sVal < 0) cExp.uVal = ~cExp.uVal;
  else if (lExp.type != NULL) {
    if (lExp.type->typeSort == UShort) cExp.uVal ^= UINT_MAXC ^ USHRT_MAXC;
    else if (lExp.type->typeSort == UByte) cExp.uVal ^= UINT_MAXC ^ UCHAR_MAXC;}
}
#endif

static void manageLogOper(void (*pf)(void), Ttok x, bool y, Tstring z)
{
  TresulExp slExp;  /* left operand saving */
  TmacLvl operMacLvl = macLvl;
  bool savEvalFl = evaluateFl;

  if (cExp.ValMltplDef) cExp.rEvlbl = False;
  slExp = cExp;
  if (slExp.rEvlbl && (slExp.uVal != 0)==y) evaluateFl = False;
  condStmtLvl++;
  GetNxtTok();
  (*pf)();
  if (cExp.ValMltplDef) cExp.rEvlbl = False;
  evaluateFl = savEvalFl;
  /* Short-circuit evaluation */
  if (slExp.rEvlbl)
    if ((slExp.uVal != 0) == y) transfOpnd(&slExp, &cExp);
    else {if (! cExp.rEvlbl) warnCstBool(errTxt[SubPre]);}
  else if (cExp.rEvlbl)
    if ((cExp.uVal != 0) == y) transfOpnd(&cExp, &slExp);
    else warnCstBool(errTxt[SubPre]);
  checkInit();
  cExp.ptrId = NULL;  /* to prevent 2nd call to checkInit (in resulExp) */
  condStmtLvl--;
  lExp = slExp;
  paramTxt = z;
  {
    Ttok topOper = x | (cExp.topOper | lExp.topOper) & SETJMPUSED;

    if (! resulExp(mskBool, False, &computeShortCircuit, operMacLvl, x)) {
      /* Pointer(s) used as boolean */
      errWrngType(mskBool);
      FreeExpType(slExp);
      cExp.ptrId = NULL;}
    createBoolResult();
    cExp.topOper = topOper;}
}

static void managePointers(TpcTypeElt sinkType)
/* managePointers()/cleanExprThings() should be called at end of each
   expression, be it correct or not. */
{
  {
    register TsemanElt *rPtrId = cExp.ptrId;
    bool flg = False;
    TpcTypeElt eType;

    if (rPtrId != NULL) {
      /* Mark possible pointed object initialized */
      if ((eType = cExp.type)!=NULL && IsPtrArr(eType)) {
        switch (tstPtd((sinkType == NULL)? eType : sinkType, True)) {
          case ALLCONST:
            if (cExp.PointingOnObj) {  /* pointer produced via '&' */
              TpcTypeElt w;

              rPtrId->used = True;
              if (paramTxt == txtAsgnTok[SimplAsgn]) rPtrId->forceUsed = True;
				/* if assignment to pointer, cannot trace usage
				   of pointed object's value any more. */
              if (paramTxt!=txtAsgnTok[SimplAsgn] || (w = NxtTypElt(eType))!=
						   NULL && w->qualif&ConstQal) {
                if (rPtrId->initBefUsd) rPtrId->initlz = True;
                else {
                  cExp.PointingOnObj = False;  /* since receiving pointer/array
					is 'const', pointed object should be
					initialized (see next checkInit() ). */
                  initDPFl = True;}}}
            break;
          case NOTALLCONST:
            if (   cExp.PointingOnObj /* produced via '&' */
                && (rPtrId->used = True,
                       paramTxt[0]=='r' && cExp.lclAdr
                    || manageInitlzUsed())) {
              if (paramTxt == txtAsgnTok[SimplAsgn] /* assignment */) rPtrId->
							       forceUsed = True;
              else if (sinkType != NULL) {  /* not variadic part */
                /* Pointed object supposed to be initialized/modified via recei-
	 	   ving pointer, except if 'return' and auto object; functions
		   may change value; objects can be chosen to be manipulated
		   only via pointers.
		   BEWARE: manageInitlzUsed causes side-effect. */
                if (paramTxt[0] == '(') {
                  rPtrId->used = False;
                  if (!ScanfFl) flg = True;}
                else rPtrId->used = cExp.oldUsed;}}
            else if (sinkType!=NULL && paramTxt[0]=='(' && IsArr(cExp.type)) {
              if (ioFctNb < 0) rPtrId->used = cExp.oldUsed;  /* xprintf() */
              if (manageInitlzUsed()) rPtrId->used = False;}  /* array
						     represents its elements. */
            if (tstPtd(sinkType, False) & NOTALLCONST && !(rPtrId==lExp.ptrId
		&& paramTxt==txtAsgnTok[SimplAsgn]) /* not case "x = x->..." */
							    ) modifPtdVal(MayM);
            break;
          default:;}}
      checkInit();  /* must be here (because of earlier manageInitlzUsed) */
      initDPFl = False;
      if (flg) rPtrId->MsngConstQM = True;}}
  if (preLastCastType!=NULL && pLCMacLvl==macLvl) {
    if ((errQalTyp1 = NULL, compatType(sinkType, preLastCastType, Asgn)) &&
	   errQalTyp1==NULL && sinkType!=NULL) errWSTT(PrevCastUsl|Warn1|Rdbl,
					      NULL, preLastCastType, cExp.type);
    freePrevCast();}
  if (allocType != NULL) {
    if (allocType != XAllocSeen) {
      if (sinkType!=NULL && IsPtrArr(sinkType)) {
        TpcTypeElt nxtType = NxtTypElt(sinkType), w = allocType;

        for (;; w = NxtTypElt(w)) {
          if (CompatType(w, nxtType, CStrictChk)) break;
          if (! IsArr(w)) {
            if (nxtType->typeSort != Void) errWSSSS(WrngSizeof|Warn3|PossErr,
			      NULL, typeToS1(w), typeToS2NoQual(nxtType), NULL);
            break;}}}}
    freeAlloc();}
  if (setjmpSeen) {err0(ChkSetjmpDsbld|Warn1|PossErr); setjmpSeen = False;}
}

static TpcTypeElt managePredefTypes(TpredefTypes typeNb)
{
  static struct _typesDes {Tname typeName; ThCode typeHCode; TpcTypeElt
       pDescType;}predefTypesDes[/*~IndexType TpredefTypes*/] =
    {{ConvTname(WcharTName), WcharTHCode, &wcharCstTypeElt},
     {ConvTname(SizeTName), SizeTHCode, &sizeofTypeElt},
     {ConvTname(PtrdiffTName), PtrdiffTHCode, &ptrdiffTypeElt}};
  /*~zif NbElt(predefTypesDes) != __extent(TpredefTypes)+1 "Bad size for array "
							   "'predefTypesDes'" */
  const struct _typesDes *const pTypeDesc= &predefTypesDes[typeNb];
  const TsemanElt *ptrId;

  if ((ptrId = searchSymTabHC(pTypeDesc->typeName, pTypeDesc->typeHCode))==NULL
							 || ptrId->type==NULL) {
    if (! stddefIncldFl) {
      err0(StddefNotIncl|Warn2|Rdbl|PossErr);
      stddefIncldFl = True;}
    return pTypeDesc->pDescType;}
  {
    TpcTypeElt resulTyp = copyTypeEltNoOwn(ptrId->namedType);

    ((ModifType)resulTyp)->generic = True;
    return resulTyp;}
}

void manageRetValue(TpcTypeElt fctRetType)
{
  TpcTypeElt eType;
  
  commaExpr();
  paramTxt = "return";  /* paramTxt used in managePointers() */
  CheckNumCstNamed(cExp, fctRetType);
  managePointers(fctRetType);
  if ((eType = cExp.type) != NULL) {
    errQalTyp1 = NULL;
    if (!CompatType(fctRetType, eType, Asgn) && (lExp.type = fctRetType,
							      !compatNumType()))
      errSinkType(BadRetType | PossErr, typeToS2(fctRetType));
    else {
      if (errQalTyp1 != NULL) errWSTTS(ConstQalNotHeeded1|ConstWarn|PossErr,
		    paramTxt, errQalTyp1, errQalTyp2, (errQalTyp1 == fctRetType)
						       ? NULL : errTxt[SubPre]);
      if (cExp.lclAdr && InsideInterval(eType->typeSort, Ptr, Union) &&
			  !FoundDP(LOCALADR)) err0(RetPtrOnLclAd|Warn3|PossErr);
      else if (fctRetType!=NULL && fctRetType->typeSort==Bool) warnNotPureBool(
		   &cExp, NULL);}  /* for function should behave as constant. */
    FreeExpType2(eType);}
}

static void manageSetjmp(void)
{
  if (! cExp.PointedByObj) {
    register TsemanElt *ptrId = cExp.ptrId;

    if (ptrId->attribb>=Auto && ptrId->type!=NULL && ptrId->type->qualif!=
	   VolatQal && ((void)searchSymTab(ptrId->nameb), pSrchdId->nstLvl<=
			  ((setjmpBlkLvl >= 0)? setjmpBlkLvl : -setjmpBlkLvl))
						       ) ptrId->modifSJ = True;}
}

static bool manageTypCmbn(TkOpTC oper) /*~PseudoVoid*/
{
  TpcTypeElt resulTC = searchTC(oper);

  if (resulTC == QuasiNULLval(TpcTypeElt)) return False;
  if (lExp.type->litCsta != cExp.type->litCsta) {
    CheckNumCstNamed(lExp, lExp.type);
    CheckNumCstNamed(cExp, cExp.type);}
  FreeExpType2(lExp.type);
  FreeExpType2(cExp.type);
  lExp.type = cExp.type = resulTC;
  return True;
}

static void manageUsedForIncOp(void)
{
  TsemanElt *rPtrId;

  checkInit();
  if (!cExp.PointedByObj && (rPtrId = cExp.ptrId)!=NULL) {
    if (loopLvl==0 && rPtrId->attribb>=Auto && !zifExp) {
      /* Not inside loop: mark variable 'notUsed' (=> to be used after) */
      cExp.oldUsed = False;
      rPtrId->used = False;}
    if (setjmpBlkLvl != 0) manageSetjmp();}
  cExp.topOper = INCOP;
}

static void modifPtdVal(Terr n)
{
  TsemanElt *ptrId = cExp.ptrId;
  Tmember cExpS;

  if (ptrId!=NULL && !cExp.FctCallSeen1) {
    if ((cExpS = isMember(&cExp))!=NotMember && ptrId->kind==Param && !ptrId->
       MayModif && (!ptrId->Dmodfd || allErrFl) && tstPtd(ptrId->type, False) &
					       (ALLCONST | STRUN) && askConstFl)
      errId2(MayModify|Warn1|Rdbl, ptrId, nameToS(curFctName), errTxt[n]);
    if (   n==MayM && paramTxt==txtAsgnTok[SimplAsgn]
           && (ptrId->kind==Param || ptrId->CheckConst)
           && !cExp.PointingOnObj && cExpS<Member
           && lExp.ptrId!=NULL && lExp.ptrId->kind==Obj && !lExp.ptrId->Dmodfd
           && isMember(&lExp)==NotMember) lExp.ptrId->CheckConst = True;  /*
		   turn on receiving pointer missing 'const' qualifier check. */
    ptrId->Dmodfd = True;}
}

void procSameType(void)
{
  TpcTypeElt lType;
  bool savEvalFl = evaluateFl;

  evaluateFl = False;
  lType = (isType())? declType() : (asgnExpr(), valueNotUsed(), cExp.type);
  if (!Found(COMMA)) err0(CommaExptd);
  if (isType()) cExp.type = declType();
  else asgnExpr(), valueNotUsed();
  evaluateFl = savEvalFl;
  errQalTyp1 = NULL;
  cExp.uVal = (TcalcU)(compatType(lType, cExp.type, FctCall) && errQalTyp1 ==
		 NULL || (paramTxt = NULL, lExp.type = lType, compatNumType()));
  FreeExpType1(lType);
  FreeExpType(cExp);
  cExp.type = &boolCstTypeElt;
  cExp.Einfo = 0;  /* reset all flags */
}

static bool resulExp(TtypeSort msk, bool cstOnRight, void (*ptrComputeResul)
	       (TpcTypeElt), TmacLvl operMacLvl, Ttok baseClass) /*~PseudoVoid*/
/* Returns False (without freeing operand types) if lExp.type is non NULL, but
   not compatible with cExp.type nor with 'msk', and there exist a "xPoss" bit
   in 'msk'. */
{
  const TpcTypeElt lType = lExp.type, eType = cExp.type;
  TpcTypeElt resType;

  if (lType!=NULL && eType!=NULL) resType = commonType(msk);
  else if (baseClass == MULOP) resType = NULL;
  else {  /* if one operand type NULL, assume result type is type of other */
    if (eType == NULL) {
      if (lType == NULL) resType = NULL;
      else {
        cExp.type = lType;
        resType = commonType(msk);
        cExp.type = NULL;}}
    else {
      lExp.type = eType;
      resType = commonType(msk);
      lExp.type = NULL;}}
  if (convToUnsgnd != NoErrMsg) errWSTTS(ConvToUnsig|Warn2|PossErr, paramTxt,
					    lType, eType, errTxt[convToUnsgnd]);
  if (lExp.macLvl<operMacLvl && !(lExp.topOper & PRIMARY) && NakedTok(
	       lExp.topOper)!=baseClass /* NONASSOC (non-associativity) check */
    || cExp.macLvl<operMacLvl && !(cExp.topOper & PRIMARY) && NakedTok(
		    cExp.topOper)!=baseClass) err1(IllParenMacro|Warn3|PossErr);
  checkInit();
  cExp.PointingOnObj = lExp.PointingOnObj;
  if ((cExp.ptrId = lExp.ptrId) != NULL) checkInit();
  cExp.macLvl = operMacLvl;
  cExp.lValFl = False;
  if (cExp.litCst) {
    if (CheckSink(&cExp, lType)) {cExp.litCst = False; cExp.LitCstOutsMac 
							    = False; goto okL;}}
  else {
    if (!lExp.litCst || CheckSink(&lExp, eType)) goto okL;
    cExp.litCst = True;}
  if (lExp.LitCstOutsMac) cExp.LitCstOutsMac = True;
okL:
  if (lExp.unsigDiff) cExp.unsigDiff = True;
  if (lExp.ValMltplDef) cExp.ValMltplDef = True;
  if (! lExp.rEvlbl) cExp.rEvlbl = False;
  else if (lExp.errEvl) cExp.errEvl = True;
  if (resType == NULL) {
    if (lType!=NULL && msk>=PtrPoss) return False;
    if (errWrngType(msk) || !cExp.rEvlbl || !ifDirExp) goto exitL;
    resType = &longCstTypeElt;}  /* needed because of the poor coding of many
							 system header files. */
  if (cExp.rEvlbl) {
    if (eType==NULL || lType==NULL) cExp.errEvl = True;
    (*ptrComputeResul)(resType);
    checkInfoLoss(resType);}
  else if (cstOnRight && lExp.rEvlbl && lExp.topOper&PRIMARY) err1(
						       CstOnLftSide|Warn1|Rdbl);
exitL:
  if (lType != resType) FreeExpType1(lType);
  if (eType != resType) FreeExpType(cExp);  /* cExp.type may have been changed
						  by errWrngType => != eType. */
  cExp.type = resType;
  cExp.topOper = baseClass;
  cExp.ptrId = NULL;
  if (preLastCastType != NULL) freePrevCast();
  return True;
}

static void resulUnOp(TtypeSort msk, Tstring operTxt)
{
  bool err = False;

  checkInit();
  paramTxt = operTxt;
  if (! authzdType(cExp.type, msk, &err, IlgRhtType | PossErr))
    if (ifDirExp && !err && cExp.rEvlbl) {FreeExpType(cExp); cExp.type =
							       &longCstTypeElt;}
    else errExp(NoErrMsg, NULL, NULL);
  else if (cExp.type != NULL) {  /* compute result type (in case !(Bool | x),
								for example). */
    TpcTypeElt resType;

    lExp.type = cExp.type;
    lExp.Einfo = cExp.Einfo;
    resType = commonType(msk);
    if (resType != cExp.type) {FreeExpType(cExp); cExp.type = resType;}}
  cExp.lValFl = False;
  cExp.ptrId = NULL;
}

static size_t sizeOfTypeI(TpcTypeElt type, bool deref, Terr err, Tstring y)
{
  TpcTypeElt tr = (deref)? NxtTypElt(type) : type, t1 = tr;

  if (tr == NULL) return 0;
  if (cExp.ArtifType) {
    errId3(err, &cExp, typeToS1(&natTyp[VoidDpl]), y);
    return (&natTyp[VoidDpl])->size;}
  else {
    if (IsStrun(tr)) tr = BaseStrunType(tr);
    if (tr->size==0 && !tr->errSiz) {
      errId3(err, &cExp, typeToS1(t1), y);
      if (deref && tr==&natTyp[VoidDpl]) ((ModifType)represType(type))->nextTE =
					      tr = allocTypeEltIC(tr, NoQualif);
      if (tr != &natTyp[VoidDpl]) ((ModifType)tr)->errSiz = True;}
    return tr->size;}
}

static void transfOpnd(const TresulExp *x /*~MayModify*/, TresulExp *y)
{
  TREInfo savCEinfo;

  savCEinfo._eInfo = y->Einfo;
  y->Einfo = x->Einfo;
  y->hist = x->hist;
  if (savCEinfo.s21._litCst && (!ifDirExp || x==&cExp)) {
    y->litCst = True;
    if (savCEinfo.s21._litCstOutsMac) y->LitCstOutsMac = True;}
  y->unsigDiff = savCEinfo.s21._unsigDiff;
#if PtrGtLong
  y->pVal = x->pVal;
#else
  y->uVal = x->uVal;
#endif
  y->ptrId = x->ptrId;
  if (y->type == NULL) y->type = x->type;
}

static Tstring typeToS2NoQual(TpcTypeElt x)
{
  Tstring result;
  TpTypeElt x1;

  if (x == NULL) return NULL;
  x1 = allocTypeEltIC(x, NoQualif);
  x1->qualif = NoQualif;
  result = typeToS2(x1);
  (void)freeTypeElt(x1);
  return result;
}

static void valueNotUsed(void)
{
  register TsemanElt *rPtrId;

  if (!cExp.PointedByObj && (rPtrId = cExp.ptrId)!=NULL && !(rPtrId->kind==
	Param && (rPtrId->type==NULL || IsArr(rPtrId->type))) && !zifExp) rPtrId
	->used = cExp.oldUsed; /* side-effect is not use (except for externals,
				       global statics, and array parameters). */
  cleanExprThings();
}

static void verifCstOvfl(void)
{
  if (lExp.rEvlbl) {
    TcalcS savCexpVal = cExp.sVal;
    ulong savCexpFlg = cExp.Einfo;

    cExp.sVal = lExp.sVal;
    cExp.Einfo = lExp.Einfo;
    checkInfoLoss(lExp.type);
    cExp.sVal = savCexpVal;
    cExp.Einfo = savCexpFlg;}
  if (cExp.rEvlbl) checkInfoLoss(cExp.type);
}

static void warnCstBool(Tstring x)
{
  if (chkBool && !cstExpAsked && !ReallyInsideMacro) errWS(CstBoolExp | CWarn2,
									     x);
}

static void warnNotPureBool(TresulExp *x, Tstring y)
{
  if (x->notPureBool && (allErrFl || !x->inhibWaNPB && (x->ptrId==NULL ||
	!x->ptrId->pureBoolAskd /* to minimize nb of warnings */))) {errWSS(
		 Outside01|Warn2|PossErr, paramTxt, y); cExp.inhibWaNPB = True;}
  if (x->ptrId != NULL) x->ptrId->pureBoolAskd = True;  /* limits also nb of
							      error messages. */
}

static Terr warnOrErr(Terr n)
{
  return (compatType(lExp.type, cExp.type, CCheck) || lExp.type->typeSort==Ptr
       && IsTypeSort(cExp.type, WhoEnumBool) && cExp.rEvlbl && !cExp.errEvl &&
						   cExp.sVal==0)? n | Warn2 : n;
}

/* End DCEXP.C */
                                                                                                                                                                                                                                                                                                                                                                                                                                                     