//======================================================================
// 
//  Filemon.h
//
//  Copyright (C) 1996-1997 Mark Russinovich and Bryce Cogswell
//
//======================================================================

// 
// NT Final Build number
//
#define NT4FINAL        1381

//
// Maximum amount of memory grabbed 
//
#define MAXMEMORY       1000000

//
// Maximum path length of pathname. This is larger than Win32 maxpath
// because network drives have leading paths
//
#define MAXPATHLEN      1024

//
// Length of process name (rounded up to next DWORD)
//
#define PROCNAMELEN     20

//
// Maximum length of NT process name
//
#define NT_PROCNAMELEN  16

//
// Maximum seperate filter components 
//
#define MAXFILTERS      64

//
// Length of buffer for error string
//
#define ERRORLEN        64


//
// Structure for device specific data that keeps track of what
// drive and what filesystem device are hooked 
//
typedef struct {
   FILE_SYSTEM_TYPE Type;
   PDEVICE_OBJECT   FileSystem;
   unsigned         LogicalDrive;
} HOOK_EXTENSION, *PHOOK_EXTENSION;         


//
// Structure for the fileobject/name hash table
//
typedef struct _nameentry {
   PFILE_OBJECT		FileObject;
   PCHAR		FullPathName;
   struct _nameentry 	*Next;
} HASH_ENTRY, *PHASH_ENTRY;

//
// Structure for a completion routine work item
//
typedef struct _filemonwork {
    WORK_QUEUE_ITEM WorkItem;
    ULONG          Sequence;
    LARGE_INTEGER  TimeResult;
    CHAR           ErrString[ERRORLEN];
} FILEMON_WORK, *PFILEMON_WORK;


//
// Number of hash buckets in the hash table
//
#define NUMHASH		0x100

//
// Hash function. Basically chops the low few bits of the file object
//
#define HASHOBJECT(_fileobject)		(((ULONG)_fileobject)>>5)%NUMHASH


//
// Structure for keeping linked lists of output buffers
//
typedef struct _log {
    ULONG           Len;
    struct _log   * Next;
    CHAR            Data[ LOGBUFSIZE ];
} LOG_BUF, *PLOG_BUF;


//
// A check to see if a fastio table extends to a specific entry
//
#define FASTIOPRESENT( _hookExt, _call )                                                      \
    ((((ULONG)&_hookExt->FileSystem->DriverObject->FastIoDispatch->_call -                    \
       (ULONG) &_hookExt->FileSystem->DriverObject->FastIoDispatch->SizeOfFastIoDispatch <    \
       (ULONG) _hookExt->FileSystem->DriverObject->FastIoDispatch->SizeOfFastIoDispatch )) && \
      hookExt->FileSystem->DriverObject->FastIoDispatch->_call )

//
// Time stamp start macro
//
#define TIMESTAMPSTART()                                                       \
        if( TimeIsDuration ) timeStampStart = KeQueryPerformanceCounter(NULL); \
        else                 KeQuerySystemTime( &timeResult )

#define TIMESTAMPSTOP()                                                        \
        if( TimeIsDuration ) {                                                 \
            timeStampComplete = KeQueryPerformanceCounter(NULL);               \
            timeResult.QuadPart = timeStampComplete.QuadPart - timeStampStart.QuadPart; \
        }

//
// Macro for getting the path name
//
#define GETPATHNAME(_IsCreate)                                                  \
        fullPathName = ExAllocatePool( NonPagedPool, MAXPATHLEN );              \
        if( fullPathName ) {                                                    \
            FilemonGetFullPath( _IsCreate, FileObject, hookExt, fullPathName ); \
        }   

#define FREEPATHNAME()                                   \
        if ( fullPathName ) ExFreePool( fullPathName )

//
// Undocumented ntoskrnl variable
//
extern PSHORT           NtBuildNumber;

//
// Undocumented ntoskrnl function
//
VOID NTAPI ProbeForWrite(PVOID Address, 
                         ULONG Length, 
                         ULONG Alignment );

//
// For the definitions in Winioctl.h
//
#undef DEVICE_TYPE
typedef UCHAR  BYTE;
typedef USHORT WORD;
typedef ULONGLONG DWORDLONG;
typedef ULONG  DWORD;
typedef PVOID SID;

//
// So that we can pick up NT 5.0 IOCTLs in WINIOCTL.h
//
#undef _WIN32_WINNT
#define _WIN32_WINNT 0x0500

//
// Totally undocumented named pipe file system control codes
//
#define FSCTL_PIPE_ASSIGN_EVENT          0x110000
#define FSCTL_PIPE_DISCONNECT            0x110004
#define FSCTL_PIPE_QUERY_EVENT           0x110010
#define FSCTL_PIPE_LISTEN                0x110008
#define FSCTL_PIPE_IMPERSONATE           0x11001C
#define FSCTL_PIPE_WAIT                  0x110018
#define FSCTL_PIPE_QUERY_CLIENT_PROCESS  0x110024
#define FSCTL_PIPE_SET_CLIENT_PROCESS    0x110020
#define FSCTL_PIPE_PEEK                  0x11400C
#define FSCTL_PIPE_INTERNAL_READ         0x116000
#define FSCTL_PIPE_INTERNAL_WRITE        0x119FF8
#define FSCTL_PIPE_TRANSCEIVE            0x11C017
#define FSCTL_PIPE_INTERNAL_TRANSCEIVE   0x11DFFF

//
// Undocumented mail slot file system controls
//
#define FSCTL_MAILSLOT_PEEK              0xC4003

//
// Named pipe and mail slot prefix names
//
#define NAMED_PIPE_PREFIX                "\\\\.\\Pipe"
#define NAMED_PIPE_PREFIX_LENGTH         (sizeof(NAMED_PIPE_PREFIX)-1)

#define MAIL_SLOT_PREFIX                "\\\\.\\MailSlot"
#define MAIL_SLOT_PREFIX_LENGTH         (sizeof(MAIL_SLOT_PREFIX)-1)
