#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

extern int code_mt;

int 
num(char *cod)
{
  int  n1, n2, n3;

  n1 = n2 = n3 = 0;
  if (cod[0] == 'C') n1 = 1;
  if (cod[1] == 'C') n2 = 1;
  if (cod[2] == 'C') n3 = 1;
  if (cod[0] == 'G') n1 = 2;
  if (cod[1] == 'G') n2 = 2;
  if (cod[2] == 'G') n3 = 2;
  if (cod[0] == 'T') n1 = 3;
  if (cod[1] == 'T') n2 = 3;
  if (cod[2] == 'T') n3 = 3;

  return 16 * n1 + 4 * n2 + n3;
}





int catsite (char c1, char c2, char c3, int i) {

	/* renvoie 0 si le site i du codon c1c2c3 est non degenere */
	/* 1                                  2-fold degenerate */
	/* 2                                  4-fold degenerate */

	if (i == 3) {
		if ((c1 == 'A') && (c2 == 'T') && (c3 == 'G'))
			return 0;
		if ((c1 == 'T') && (c2 == 'G') && (c3 == 'A'))
			return 0;
		if ((c1 == 'T') && (c2 == 'G') && (c3 == 'G'))
			return 0;
		if (c2 == 'C')
			return 2;
		if ((c1 == 'C') && (c2 == 'T'))
			return 2;
		if ((c1 == 'G') && (c2 == 'T'))
			return 2;
		if ((c1 == 'G') && (c2 == 'G'))
			return 2;
		if ((c1 == 'C') && (c2 == 'G'))
			return 2;
		return 1;
	}
	if (i == 1) {
		if ((c1 == 'C') && (c2 == 'T') && (c3 == 'A'))
			return 1;
		if ((c1 == 'C') && (c2 == 'T') && (c3 == 'G'))
			return 1;
		if ((c1 == 'T') && (c2 == 'T') && (c3 == 'A'))
			return 1;
		if ((c1 == 'T') && (c2 == 'T') && (c3 == 'G'))
			return 1;
		if ((c1 == 'A') && (c2 == 'G') && (c3 == 'A'))
			return 1;
		if ((c1 == 'A') && (c2 == 'G') && (c3 == 'G'))
			return 1;
		if ((c1 == 'C') && (c2 == 'G') && (c3 == 'A'))
			return 1;
		if ((c1 == 'C') && (c2 == 'G') && (c3 == 'G'))
			return 1;
		return 0;
	}
	return 0;
}


char
transf(char nt1, char nt2)
{
char toret;
        toret = '-';
	if (nt1 == nt2) {
		toret =  'S';
	}
	if         (nt1 == 'A'){
           if      (nt2 == 'C')	toret =  'v';
	   else if (nt2 == 'G')	toret =  'i';
	   else if (nt2 == 'T')	toret =  'v';
        }
        else if    (nt1 == 'G'){
	   if      (nt2 == 'A')	toret =  'i';
	   else if (nt2 == 'C')	toret =  'v';
	   else if (nt2 == 'T')	toret =  'v';
        }
	else if    (nt1 == 'C'){
	   if      (nt2 == 'A')	toret =  'v';
	   else if (nt2 == 'T')	toret =  'i';
	   else if (nt2 == 'G')	toret =  'v';
        }
	else if    (nt1 == 'T'){
	   if      (nt2 == 'A')	toret =  'v';
	   else if (nt2 == 'G') toret =  'v';
	   else if (nt2 == 'C') toret =  'i';
	}
	if (toret == '-'){
	   (void) printf("Erreur\n%c, %c\n", nt1, nt2);
           exit(0);
	}
	return toret;
}



void
titv1(char *cod1, char *cod2, double poids, double *ti, double *tv, double* l)
{
	int             i;
	char            a, b, ci1, ci2, ci3, cj1, cj2, cj3;
	char            transf(char, char);


	ci1 = cod1[0];
	ci2 = cod1[1];
	ci3 = cod1[2];
	cj1 = cod2[0];
	cj2 = cod2[1];
	cj3 = cod2[2];




	
	for (i = 0; i <= 2; i++)
		if (cod1[i] != cod2[i]) {

			l[catsite(ci1, ci2, ci3, i + 1)]+=0.5 * poids;
			l[catsite(cj1, cj2, cj3, i + 1)]+=0.5 * poids;

			a = cod1[i];
			b = cod2[i];
			if (transf(a, b) == 'i') {
				ti[catsite(ci1, ci2, ci3, i + 1)] += 0.5 * poids;
				ti[catsite(cj1, cj2, cj3, i + 1)] += 0.5 * poids;
			} else {
				tv[catsite(ci1, ci2, ci3, i + 1)] += 0.5 * poids;
				tv[catsite(cj1, cj2, cj3, i + 1)] += 0.5 * poids;
			}

			if( code_mt ) continue;  /* il n'y a plus les pb de TI non-syno et de TV syno avec code_mt ! */
		
	if (((ci2 == 'T') && (cj2 == 'T')) || ((ci2 == 'G') && (cj2 == 'G'))) { /* T ou G ensemble en pos 2 des 2 codons */


if (i==0){ /* pos 1 */	
		/* tous ces cas sont des transitions en un site 2-fold non-syno pour le code universel:
il faut les enlever du comptage des TI 2-fold (ti[1]) et les ajouter au comptage des TV 2-fold (tv[1])
pour le code_mt ce sont des sites non dege qui ont ete traites simplement comme il faut */
		if ((ci1 == 'C') && (ci2 == 'G') && (ci3 == 'A') && (cj1 == 'T') && (cj2 == 'G') && (cj3 == 'A')) {
			ti[1] -= 0.5 * poids; /* CGA / TGA */
			tv[1] += 0.5 * poids;  
		}
		if ((ci1 == 'C') && (ci2 == 'G') && (ci3 == 'G') && (cj1 == 'T') && (cj2 == 'G') && (cj3 == 'G')) {
			ti[1] -= 0.5 * poids; /* CGG / TGG */
			tv[1] += 0.5 * poids;  
		}
		if ((ci1 == 'A') && (ci2 == 'G') && (ci3 == 'G') && (cj1 == 'G') && (cj2 == 'G') && (cj3 == 'G')) {
			ti[1] -= 0.5 * poids; /* AGG / GGG */
			tv[1] += 0.5 * poids;  
		}
		if ((ci1 == 'A') && (ci2 == 'G') && (ci3 == 'A') && (cj1 == 'G') && (cj2 == 'G') && (cj3 == 'A')) {
			ti[1] -= 0.5 * poids; /* AGA / GGA */
			tv[1] += 0.5 * poids;  
		}
		if ((ci1 == 'T') && (ci2 == 'G') && (ci3 == 'A') && (cj1 == 'C') && (cj2 == 'G') && (cj3 == 'A')) {
			ti[1] -= 0.5 * poids; /* TGA / CGA */
			tv[1] += 0.5 * poids;  
		}
		if ((ci1 == 'T') && (ci2 == 'G') && (ci3 == 'G') && (cj1 == 'C') && (cj2 == 'G') && (cj3 == 'G')) {
			ti[1] -= 0.5 * poids; /* TGG / CGG */
			tv[1] += 0.5 * poids;  
		}
		if ((ci1 == 'G') && (ci2 == 'G') && (ci3 == 'G') && (cj1 == 'A') && (cj2 == 'G') && (cj3 == 'G')) {
			ti[1] -= 0.5 * poids; /* GGG / AGG */
			tv[1] += 0.5 * poids;
		}
		if ((ci1 == 'G') && (ci2 == 'G') && (ci3 == 'A') && (cj1 == 'A') && (cj2 == 'G') && (cj3 == 'A')) {
			ti[1] -= 0.5 * poids; /* GGA / AGA */
			tv[1] += 0.5 * poids;  
		}


/* tous ces cas sont 
code universel: TV syno en sites 2-fold il faut les enlever du comptage des TV 2-fold (tv[1]) et les ajouter au comptage des TI 2-fold (ti[1])
code_mt: TV non syno en site non dege qui ont ete correctement comptes
*/
		if ((ci1 == 'C') && (ci2 == 'G') && (ci3 == 'A') && (cj1 == 'A') && (cj2 == 'G') && (cj3 == 'A')) {
			tv[1] -= poids; /* CGA / AGA : TV syno code univ, non code mt */
			ti[1] += poids;  
		}
		if ((ci1 == 'A') && (ci2 == 'G') && (ci3 == 'A') && (cj1 == 'C') && (cj2 == 'G') && (cj3 == 'A')) {
			tv[1] -= poids; /* AGA / CGA : TV syno code univ, non code mt */
			ti[1] += poids;  
		}
		if ((ci1 == 'C') && (ci2 == 'G') && (ci3 == 'G') && (cj1 == 'A') && (cj2 == 'G') && (cj3 == 'G')) {
			tv[1] -= poids; /* CGG / AGG : TV syno code univ, non code mt */
			ti[1] += poids;  
		}
		if ((ci1 == 'A') && (ci2 == 'G') && (ci3 == 'G') && (cj1 == 'C') && (cj2 == 'G') && (cj3 == 'G')) {
			tv[1] -= poids; /* AGG / CGG : TV syno code univ, non code mt */
			ti[1] += poids;  
		}
}

if (i==2){ /* pos 3 */	
/* tous ces cas sont
code universel: des TV syno en site 2-fold il faut les enlever des TV 2-fold (iv[1]) et ajouter aux TI 2-fold (ti[1])
code_mt: ce sont des TV non syno en site 2-fold qui int ete comptees normalement
*/
		if ((ci1 == 'A') && (ci2 == 'T') && (ci3 == 'A') && (cj1 == 'A') && (cj2 == 'T') && (cj3 == 'T')) {
			tv[1] -= poids; /* TV ATA / ATT : syno code univ, non code mt */
			ti[1] += poids;  
		}
		if ((ci1 == 'A') && (ci2 == 'T') && (ci3 == 'T') && (cj1 == 'A') && (cj2 == 'T') && (cj3 == 'A')) {
			tv[1] -= poids; /* TV ATT / ATA : syno code univ, non code mt */
			ti[1] += poids;  
		}
		if ((ci1 == 'A') && (ci2 == 'T') && (ci3 == 'A') && (cj1 == 'A') && (cj2 == 'T') && (cj3 == 'C')) {
			tv[1] -= poids; /* TV ATA / ATC : syno code univ, non code mt */
			ti[1] += poids;  
		}
		if ((ci1 == 'A') && (ci2 == 'T') && (ci3 == 'C') && (cj1 == 'A') && (cj2 == 'T') && (cj3 == 'A')) {
			tv[1] -= poids; /* TV ATC / ATA : syno code univ, non code mt */
			ti[1] += poids;  
		}



/* ces 2 cas sont
code universel: des TI non syno en site 2-fold il faut les enlever des TI 2-fold (ti[1]) et les ajouter aux TV 2-fold (tv[1])
code_mt: des TI syno en site 2-fold qui ont ete comptees normalement
*/
		if ((ci1 == 'A') && (ci2 == 'T') && (ci3 == 'A') && (cj1 == 'A') && (cj2 == 'T') && (cj3 == 'G')) {
			ti[1] -= 0.5 * poids; /* TI ATA / ATG : non syno code univ, syno code mt */
			tv[1] += 0.5 * poids;  
		}
		if ((ci1 == 'A') && (ci2 == 'T') && (ci3 == 'G') && (cj1 == 'A') && (cj2 == 'T') && (cj3 == 'A')) {
			ti[1] -= 0.5 * poids; /* TI ATG / ATA : non syno code univ, syno code mt */
			tv[1] += 0.5 * poids;  
		}
}
		}

	}
}




void
titv2(char *cod1, char *cod2, double *ti, double *tv, double* l, int *aa, double **rl, int* pos)
{

	char            codint1[4], codint2[4];
	int             i, j, n, aa1, aa2, aaint1, aaint2;
	double          l1, l2, p1, p2;
	void            titv1(char *, char *, double, double *, double *,double*);


        (void) memcpy(codint1, cod1, 3);
        (void) memcpy(codint2, cod1, 3); /* codint_2_ <-- cod_1_ : no problem */
	for (i = 0; i < 2; i++) {
		if (cod1[i] != cod2[i]){
			codint1[i] = cod2[i];
			break;
		}
	}
	for (j = i + 1; j <= 2; j++) {
		if (cod1[j] != cod2[j]){
			codint2[j] = cod2[j];
			break;
		}
	}


	aa1=aa[num(cod1)]; aa2=aa[num(cod2)];
	aaint1=aa[num(codint1)]; aaint2=aa[num(codint2)];
	
	l1 = *(rl[aa1] + aaint1) * *(rl[aaint1] + aa2);
	l2 = *(rl[aa1] + aaint2) * *(rl[aaint2] + aa2);
	p1 = (l1+l2)? l1 / (l1 + l2) : 0.;
	p2 = (l1+l2)? 1.-p1 : 0.;
	for (i=0;i<3;i++) if (pos[i]==0) n=i+1;
	l[catsite(cod1[0], cod1[1] ,cod1[2], n)]+=0.333333;
	l[catsite(cod2[0], cod2[1] ,cod2[2], n)]+=0.333333;
	l[catsite(codint1[0], codint1[1] ,codint1[2], n)]+=0.333333*p1;
	l[catsite(codint2[0], codint2[1] ,codint2[2], n)]+=0.333333*p2;



	titv1(cod1, codint1, p1, ti, tv,l);
	titv1(cod2, codint1, p1, ti, tv,l);
	titv1(cod1, codint2, p2, ti, tv,l);
	titv1(cod2, codint2, p2, ti, tv,l);

}

void
titv3(char *cod1, char *cod2, double *ti, double *tv, double* l, int *aa, double **rl)
{

	char           *codint1[6], *codint2[6];
	int             i, j, ii,a,b,c,d,aaa,aab,aac,aad;
	double           like[6], p[6], somli, rlab, rlbc, rlcd;
	void            titv1(char *, char *, double, double *, double *, double*);
	int             num(char *);

	for (i = 0; i < 6; i++) {
		if ((codint1[i] = (char *) malloc(4 * sizeof(char))) == NULL) {
			(void) printf("Erreur d'allocation\n");
			exit(1);
		}
		if ((codint2[i] = (char *) malloc(4 * sizeof(char))) == NULL) {
			(void) printf("Erreur d'allocation\n");
			exit(1);
		}
	}
	for (i = 0; i < 3; i++) {
		for (j = 0; j < 3 ; j++)
			if (j != i) {
				if ((i == 0) || ((i == 1) && (j == 0))) {
					ii = 3 * i + j - 1;
				} else {
					ii = 3 * i + j - 2;
				}
				/*sprintf(codint1[ii], "%s", cod1);*/
				(void) memcpy(codint1[ii], cod1, 3);
				*(codint1[ii] + i) = cod2[i];
				/*sprintf(codint2[ii], "%s", codint1[ii]);*/
				(void) memcpy(codint2[ii], codint1[ii], 3);
				*(codint2[ii] + j) = cod2[j];
				a=num(cod1);
				b=num(codint1[ii]);
				c=num(codint2[ii]);
				d=num(cod2);
				aaa=aa[a];
				aab=aa[b];
				aac=aa[c];
				aad=aa[d];
				rlab=*(rl[aaa]+aab);
				rlbc=*(rl[aab]+aac);
				rlcd=*(rl[aac]+aad);
				like[ii] = rlab*rlbc*rlcd;
			}
	}

	somli = 0;
	for (i = 0; i < 6; i++)
		somli += like[i];
	for (i = 0; i < 6; i++) {
		p[i] = like[i] / somli;
		titv1(cod1, codint1[i], p[i], ti, tv,l);
		titv1(codint1[i], codint2[i], p[i], ti, tv,l);
		titv1(codint2[i], cod2, p[i], ti, tv,l);
	}


}



void prefastlwl(double **rl, double **tl0, double **tl1, double **tl2, double **tti0, double **tti1,
                double **tti2, double **ttv0, double **ttv1, double **ttv2)
{

	double           l[3], ti[3], tv[3];
	char             cod1[3], cod2[3];
	int             i, j, ii, jj, nbdiff, pos[3], aa[64], n1, n2, n3;
	void            titv2(char *, char *, double *, double *, double *, int *, double **, int *pos);
	void            titv3(char *, char *, double *, double *, double *, int *, double **);
	void            titv1(char *, char *, double, double *, double *, double *);
	double		 minrl;

/* code des acides amines:
1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20    0
F W Y H M L I V P  C  A  G  T  S  Q  N  K  R  E  Q  stop
*/

	aa[0] = 17;/* aaa K */
	aa[1] = 16;/* aac N */
	aa[2] = 17;/* aag K */
	aa[3] = 16;/* aat N */
	aa[4] = 13;/* aca T */
	aa[5] = 13;/* acc T */
	aa[6] = 13;/* acg T */
	aa[7] = 13;/* act T */
if(code_mt)
	aa[8] = 0;/* aga * */
else
	aa[8] = 18;/* aga R */
	aa[9] = 14;/* agc S */
if(code_mt)
	aa[10] = 0;/* agg * */
else
	aa[10] = 18;/* agg R */
	aa[11] = 14;/* agt S */
if(code_mt)
	aa[12] = 5;/* ata M */
else
	aa[12] = 7;/* ata I */
	aa[13] = 7;/* atc I */
	aa[14] = 5;/* atg M */
	aa[15] = 7;/* att I */
	aa[16] = 15;
	aa[17] = 4;
	aa[18] = 15;
	aa[19] = 4;
	aa[20] = 9;
	aa[21] = 9;
	aa[22] = 9;
	aa[23] = 9;
	aa[24] = 18;
	aa[25] = 18;
	aa[26] = 18;
	aa[27] = 18;
	aa[28] = 6;
	aa[29] = 6;
	aa[30] = 6;
	aa[31] = 6;
	aa[32] = 19;
	aa[33] = 20;
	aa[34] = 19;
	aa[35] = 20;
	aa[36] = 11;
	aa[37] = 11;
	aa[38] = 11;
	aa[39] = 11;
	aa[40] = 12;
	aa[41] = 12;
	aa[42] = 12;
	aa[43] = 12;
	aa[44] = 8;
	aa[45] = 8;
	aa[46] = 8;
	aa[47] = 8;
	aa[48] = 0;/* taa * */
	aa[49] = 3;/* tac Y */
	aa[50] = 0;/* tag * */
	aa[51] = 3;/* tat Y */
	aa[52] = 14;/* tca S */
	aa[53] = 14;/* tcc S */
	aa[54] = 14;/* tcg S */
	aa[55] = 14;/* tct S */
if(code_mt)
	aa[56] = 2;/* tga W */
else
	aa[56] = 0;/* tga * */
	aa[57] = 10;/* tgc */
	aa[58] = 2;/* tgg W */
	aa[59] = 10;/* tgt */
	aa[60] = 6;/* tta */
	aa[61] = 1;/* ttc */
	aa[62] = 6;/* ttg */
	aa[63] = 1;/* ttt */


/* ajoute par M. Gouy */
/* calcul minrl = val minimale du tableau rl */
minrl=rl[1][1];
for(i=1; i<=20; i++)
	for(j=i+1; j<=20; j++)
		if(rl[i][j] < minrl ) minrl=rl[i][j];
/* chargement rl[0][i] et rl[i][0] avec minrl correspond a aa = stop */
	for(i= 0; i<=20; i++) rl[0][i] = rl[i][0] = minrl;

	for (i = 0; i < 63; i++) {

		for (j = i; j < 64; j++) {

			for(ii=0;ii<3;ii++){
				l[ii]=ti[ii]=tv[ii]=0;
			}


			n1 = i / 16;
			n2 = (i - 16 * n1) / 4;
			n3 = i - 16 * n1 - 4 * n2;
			cod1[0] = 'A';
			if (n1 == 1)
				cod1[0] = 'C';
			if (n1 == 2)
				cod1[0] = 'G';
			if (n1 == 3)
				cod1[0] = 'T';
			cod1[1] = 'A';
			if (n2 == 1)
				cod1[1] = 'C';
			if (n2 == 2)
				cod1[1] = 'G';
			if (n2 == 3)
				cod1[1] = 'T';
			cod1[2] = 'A';
			if (n3 == 1)
				cod1[2] = 'C';
			if (n3 == 2)
				cod1[2] = 'G';
			if (n3 == 3)
				cod1[2] = 'T';

			n1 = j / 16;
			n2 = (j - 16 * n1) / 4;
			n3 = j - 16 * n1 - 4 * n2;
			cod2[0] = 'A';
			if (n1 == 1)
				cod2[0] = 'C';
			if (n1 == 2)
				cod2[0] = 'G';
			if (n1 == 3)
				cod2[0] = 'T';
			cod2[1] = 'A';
			if (n2 == 1)
				cod2[1] = 'C';
			if (n2 == 2)
				cod2[1] = 'G';
			if (n2 == 3)
				cod2[1] = 'T';
			cod2[2] = 'A';
			if (n3 == 1)
				cod2[2] = 'C';
			if (n3 == 2)
				cod2[2] = 'G';
			if (n3 == 3)
				cod2[2] = 'T';


			nbdiff = 0;
			pos[0] = pos[1] = pos[2] = 0;
			if (cod1[0] != cod2[0]) {
				nbdiff++;
				pos[0] = 1;
			}
			if (cod1[1] != cod2[1]) {
				nbdiff++;
				pos[1] = 1;
			}
			if (cod1[2] != cod2[2]) {
				nbdiff++;
				pos[2] = 1;
			}

			if (nbdiff != 2)
				for (jj = 0; jj < 3; jj++)
					if (pos[jj] == 0) {
						l[catsite(cod1[0], cod1[1], cod1[2], jj + 1)] += 0.5;
						l[catsite(cod2[0], cod2[1], cod2[2], jj + 1)] += 0.5;
					}
			if (nbdiff == 1)
				titv1(cod1, cod2, 1.0, ti, tv, l);
			if (nbdiff == 2)
				titv2(cod1, cod2, ti, tv, l, aa, rl, pos);
			if (nbdiff == 3)
				titv3(cod1, cod2, ti, tv, l, aa, rl);

			
			*(tl0[i]+j)=*(tl0[j]+i)=l[0];
			*(tl1[i]+j)=*(tl1[j]+i)=l[1];
			*(tl2[i]+j)=*(tl2[j]+i)=l[2];
			*(tti0[i]+j)=*(tti0[j]+i)=ti[0];
			*(tti1[i]+j)=*(tti1[j]+i)=ti[1];
			*(tti2[i]+j)=*(tti2[j]+i)=ti[2];
			*(ttv0[i]+j)=*(ttv0[j]+i)=tv[0];
			*(ttv1[i]+j)=*(ttv1[j]+i)=tv[1];
			*(ttv2[i]+j)=*(ttv2[j]+i)=tv[2];

		}
	}


return;	

}



int 
fastlwl(char **seq, int nbseq, int lgseq, double **ka, double **ks, double **tti0, double **tti1, double **tti2,
        double **ttv0, double **ttv1, double **ttv2, double **tl0, double **tl1, double **tl2, double **vka, 
        double **vks, int* sat1, int* sat2)
{

	double           l[3], a[3], b[3], p[3], q[3], ti[3], tv[3],
	                aaa[3], bb[3];
	char            cod1[3], cod2[3];
	int             i, j, ii, num1, num2;

	*sat1=-1; *sat2=-1;


        if (lgseq%3!=0) {
		(void) printf("Nombre de nt non multiple de trois.\n");
		return 0;
	}

	for (i = 0; i < nbseq - 1; i++) {
		for (j = i + 1; j < nbseq; j++) {
			l[0] = l[1] = l[2] = 0.;
			ti[0] = ti[1] = ti[2] = tv[0] = tv[1] = tv[2] = 0.;

			for (ii = 0; ii < lgseq / 3; ii++) {
				cod1[0] = *(seq[i] + 3 * ii);
				cod1[1] = *(seq[i] + 3 * ii + 1);
				cod1[2] = *(seq[i] + 3 * ii + 2);
				cod2[0] = *(seq[j] + 3 * ii);
				cod2[1] = *(seq[j] + 3 * ii + 1);
				cod2[2] = *(seq[j] + 3 * ii + 2);
				num1 = num(cod1);
				num2 = num(cod2);
				l[0] += *(tl0[num1] + num2);
				l[1] += *(tl1[num1] + num2);
				l[2] += *(tl2[num1] + num2);
				ti[0] += *(tti0[num1] + num2);
				ti[1] += *(tti1[num1] + num2);
				ti[2] += *(tti2[num1] + num2);
				tv[0] += *(ttv0[num1] + num2);
				tv[1] += *(ttv1[num1] + num2);
				tv[2] += *(ttv2[num1] + num2);
			}


			for (ii = 0; ii < 3; ii++) {
				if (l[ii]==0.) { a[ii]=0.; b[ii]=0.; } 
				else{
					p[ii] = ti[ii] / l[ii];
					q[ii] = tv[ii] / l[ii];
					
					aaa[ii] = 1 - 2 * p[ii] - q[ii];
					bb[ii] = 1 - 2 * q[ii];
				/*	cc[ii] = (aaa[ii] + bb[ii]) / 2;   */

					if (bb[ii] <= 0.) {
						b[ii] = -10001.;
					} else
						b[ii] = 0.5 * (double) log(1./bb[ii]);
	
					if ((aaa[ii] <= 0.) || (bb[ii] <= 0.)) {
						a[ii] = -10001.;
					} else
						a[ii] = 0.5 * (double) log(1./aaa[ii]) - 0.25 * log(1./bb[ii]);
				}

			}


			if ((a[1] > -10000.) && (a[2] > -10000.) && (b[2] > -10000.) && ks){
				if(l[1]+l[2]==0.) ks[i][j]=0.;
				else ks[i][j] = (l[1] * a[1] + l[2] * a[2]) / (l[2] + l[1]) + b[2];
			}
			else {
				if (ks){
				  *sat1=i; *sat2=j; return(0);
				}

			}

			if ((a[0] > -10000.) && (b[0]> -10000.) && (b[1]> -10000.) && ka){
				if(l[0]+l[1]==0.) ka[i][j]=0.;
				else ka[i][j] = a[0] + (l[0] * b[0] + l[1] * b[1]) / (l[0] + l[1]);
			}

			else {
				if (ka) {
				  *sat1=i;
				  *sat2=j;
				  return(0);
				}
			}

			finboucle: ;
		}
	}
	return 0;
}

