#include "phylo_win.h"

#ifdef MOTIF
/* a cause de routines inutiles appellees par libXm sur solaris et sgi */
void regex(void)
{
}
void regcmp(void)
{
}
#endif



		/********* VARIABLES *********/

/** global non-vibrant variables **/

double screenwratio, screenhratio; /* to scale according to screen size */

    /* data */  

char *seq[MAXNSP];		/* sequences */
char *cname[MAXNSP];		/* species names */
char *comments[MAXNSP];		/* comments */
int nbseq, lgseq; 		/* number of species, length of sequences */

int nbspecsets, nbsitesets;	/* number of species/sites sets */
char *specsetname[MAXSPSET];    /* names of species sets */
char *sitesetname[MAXSITESET];  /* names of sites sets */
int *specset[MAXSPSET];		/* species sets */
int *siteset[MAXSITESET];	/* sites sets */

	/* nb1=specset[i][0] is the number of species in species set i. */
	/* specset[i][1] -> specset[i][nb1] are the nb1 species numbers. */
	/* nb2=siteset[i][0] is the number of regions in sites set i. */
	/* (specset[i][1],specset[i][2]) -> (specset[i][2*nb2-1],specset[i][2*nb2]) */
	/* are the nb2 couples of region bounds. */

int nbtree;			/* number of stored trees */
char *memtree[MAXTREE];		/* stored trees */
char *memtreename[MAXTREE];	/* names of stored trees */
char *nucseq[MAXNSP];		/* nucleotidic seq of proteic genes, for Ka/Ks computing */
double *gc;			/* gc[i]=GC% of sequence i (for nucleotidic sequences) */
int aagroup[30], nbaagroup;
char aalist[30];

	
    /* memory data for cancelling previous changings */

char	*oldname[MAXNSP], *oldnameligne[MAXNSP], *oldseq[MAXNSP], *oldcomments[MAXNSP];
int 	*oldspecset[MAXSPSET], oldsel[MAXNSP];
double 	*oldgc;


    /* input/output variables */ 

char infile[100], outfile[100];
char treefile[100], distfile[100], infofile[100],  helpfname[100];
char format;				/* currently used file format */
char currentdir[500];			/* current directory */
double *outdist[MAXNSP];		/* output distances */


    /* tree handling variables */

noeud root[MAXTREEW], memroot[MAXTREEW], parent[MAXTREEW];				
int memnb[MAXTREEW], nbtreew=-1, curtreew=0, curnb;
Boolean openedtreew[MAXTREEW], DONOTSHOWTREE=FALSE, TREEFILEB;
char *curname[MAXNSP], *provhead;


    /* branch combinig variables */

branche brcomb[MAXNSP];
int nbcomb=-1;
Boolean COMBALLOWED=FALSE, COMBB=FALSE, NOSELECTION, PERIPHSEL;


    /* bootstrap variables */

int defnbrep=500, **listbbranche, *listbval;
Boolean JUMBBOOT=TRUE, CONSENSE=FALSE;
double boot_threshold=50.;


    /* Ka/Ks computing variables */

Boolean KA;	/* Ka (not Ks) to be computed */
Boolean NUCSEQLOADED=FALSE, GAPWARNED, STOPWARNED;
double *rl[21];
double *tl0[64], *tl1[64], *tl2[64], *tti0[64], *tti1[64],*tti2[64], *ttv0[64], *ttv1[64], *ttv2[64];


    /* tree making variables */

int  option=0, method=0;
int Gafter=1;
int Gduring=1;
#ifdef WIN_MAC
int maxtrees=1;
#else
int maxtrees=10;
#endif
double ttrat=2.0;
Boolean interrompu;
int *kkill, *clusters[3], *arbre[MAXNSP], *arbreprov[MAXNSP], *brmem[MAXNSP];
double  *av, *s[MAXNSP], lgbp_nj[MAXNSP], lgbi_nj[MAXNSP], *branchl[3];


    /* graphic variable */

Boolean SMALLSCREEN, HIDDENSEQ=FALSE, TRANSVONLY=FALSE;
int maxlines, minlines;
int nbstring; char *topaint[20];
int hblock=0, vblock=0, *hbound=NULL, *vbound=NULL, vrab=6;
int nextgroup, nextset, nameclickrk=0, seqclickrk=0,  fromscroll=0, thresh1=18, numsave;


   /* miscellaneous non-vibrant variables */

Boolean PROTB;				/* proteic/nucleotidic sequences */
int code_mt=0;				/* nuclear/mitochondrial genetic code */
Boolean NOMAINWIN=TRUE, CHANGESDONE=FALSE, YES_NO=FALSE;
double speed;



/** global vibrant variables **/

      /* main window */

  /* top */

WindoW w=NULL;
MenU filem, editm, helpm, codem, distm, utim, optm, generm, formm, algm;
ChoicE dist;
IteM loadi, savei, savai, quiti, movei, removei, renamei;
IteM nucli, miti, po1i, po2i, po3i, outi, auti, smti, trai;
IteM geni, nogi, toni, bopi, mppi, mlpi, b[10];
IteM abpwi, intri, inoui, spsei, sisei, dispi, trdii;
IteM miopi, mapli, proti, dimei, mapai, malii, booti, jumbi, gaopi, trevi;
TexT selsp_text, selsi_text;
GrouP panels;
PaneL pname, pseq;
BaR vert, horiz;
FonT titlefont, gras, maigre;
ButtoN hiseb;
Nlm_Uint4 fondsel_col, fonduns_col;
Nlm_Uint4 cola, colc, colg, colt, coln, col1, col2, col3, col4, col5;
 
  /* species selection box */

GrouP species;
GrouP spbuttons;
ButtoN sp_sel, sp_unsel, sp_add, sp_del;
GrouP spgrname;
TexT sp_text;
PaneL pspecies;

  /* sites selection box */

GrouP sitesgr;
GrouP sibuttons;
ButtoN si_sel, si_unsel, si_add, si_del;
GrouP sigrname;
TexT si_text;
PaneL psites;

  /* tree building box */

GrouP tbuild, tbuild1, tbuild2, tbuild3;
GrouP meth, options, choosemeth, dnadist, protdist, gdt, repg;
ButtoN bboot, bjumb, bmult, bnj, bml, bmp, bdt, bdeltree, evaltree, inputtree;
TexT rep_text;
PaneL pbuild;


      /* first window */

WindoW firstw;
ButtoN  firstloadb, firsthelpb, firstquitb;
GrouP  firstg;

      /* load window */

WindoW loadw;
GrouP loadgr;
TexT loadtext, loaddir;
PaneL loadmenu;
ButtoN load_ok, load_can;

      /* save window */

WindoW savew=NULL;
GrouP savegr;
TexT savetext;
ButtoN save_ok, save_can;

      /* message window */

WindoW messw=NULL;
TexT messtext;
ButtoN mess_ok, mess_can;

      /* rename window */

WindoW renw;
GrouP rengr;
TexT rentext;
ButtoN ren_ok, ren_can;

      /* tree window */

WindoW treew[MAXTREEW];
PaneL ptree[MAXTREEW];
GrouP treegr[MAXTREEW], treemodgr[MAXTREEW], treerightgr[MAXTREEW], treequitgr[MAXTREEW];
ButtoN blvalue[MAXTREEW], bsvalue[MAXTREEW], comb[MAXTREEW];
ButtoN createbut[MAXTREEW], prfile[MAXTREEW], savetree[MAXTREEW], quittree[MAXTREEW];

      /* bootstrap option window */

WindoW bopw;
ButtoN jbob, abcb, conb;
TexT defnbrep_text;

      /* ML parameters window */

WindoW mlpw;
TexT ttrat_text, gd_text, ga_text;

	/* miscellaneous */

WindoW helpw[100], genw;
char infotext[10000];
int numhelp=0;
FonT gros, petit;





		/***********************************/
		/*****  FUNCTION  DEFINITIONS  *****/
		/***********************************/


#ifdef MOTIF

/* test for availability of an X event, timer and other events excluded */
extern XtAppContext Nlm_appContext;
Nlm_Boolean myeventavail(void)
{
XtInputMask mask;
mask=XtAppPending(Nlm_appContext);
return (mask & XtIMXEvent) != 0 ;
}

#ifndef __VMS /*intrinsic.h picks it up*/
#include <X11/Xlib.h>
#endif /* __VMS */

/* get_avail_sizes */
/* returns an int array containing all available sizes for font fontname */
/* (e.g., "courier") with/without bold or italic */
/* *totsizes is returned with the # of such sizes (from 1) */

int *get_avail_sizes(char *fontname, Boolean bold, Boolean italic, int *totsizes){
  char **list_found, pattern[100], *p;
  int totavail, maxnames=50, i, j, k, taille, *ret_list;

  (void) sprintf(pattern,"-*-%s-%s-%c-*",fontname,
	(bold ? "bold" : "medium"),
	(italic ? 'o' : 'r') );
  list_found=XListFonts(Nlm_currentXDisplay,pattern,maxnames,&totavail);
  *totsizes=0;
  ret_list=(int *)malloc(totavail*sizeof(int));
  if(ret_list==NULL) {
    return NULL;
  }
  for(i=0; i<totavail; i++) {
    p=strstr(list_found[i],"--");
    if(p==NULL) continue;
    taille=0;
    (void) sscanf(p+2,"%d",&taille);
    if(taille==0) continue;
    j=0;
    while( j< *totsizes && taille > ret_list[j] ) j++;
    if( j< *totsizes && taille == ret_list[j] ) continue;
    for(k= *totsizes-1; k>=j; k--) ret_list[k+1] = ret_list[k];
    ret_list[j] = taille;
    ++(*totsizes);
  }
  (void) XFreeFontNames(list_found);
  return ret_list;
}



/* get_approx_size */
/* to be called after having called get_avail_sizes with */
/*	avail_sizes = array returned by get_avail_sizes */
/*	totavail = size of this array also returned by previous call */
/*	desired = size in point of desired font */
/* returned value = smallest available size larger than desired value */

int get_approx_size(int *avail_sizes, int desired, int totavail){
  int i;
  if(totavail==0) return 0;
  if(avail_sizes[0]>=desired) return avail_sizes[0]; 
  for(i=1; i<totavail; i++) {
    if(avail_sizes[i] == desired ) return avail_sizes[i];
    if(avail_sizes[i] > desired ) return avail_sizes[i-1];
  }
  return avail_sizes[totavail - 1];
}

#endif


	/** MISC NON-VIBRANT FUNCTIONS **/


/* check_alloc */
/* Return a pointer with needed allocated memory or leave program */
/* if not enough memory. */

void *check_alloc(int nbrelt, int sizelt)
{
void *retval; 

if( (retval=(char*)calloc(nbrelt,sizelt)) == NULL ) {
   (void) printf("Not enough memory\n");
   exit(0);
}
return retval; 
}



/* check_ralloc */
/* Return a pointer with needed allocated memory or leave program */
/* if not enough memory. */

char *check_ralloc(void* ptr, int nbelt, int sizelt)
{
char *retval;
if( (retval=(char*)realloc(ptr, nbelt*sizelt)) == NULL ){
  (void) printf("Not enough memory\n");
  exit(0);
}
return retval;
}


/* expby5sec */
/*
double expby5sec(void){

  double i=0, a=0.123456789, b;
  time_t debut, fin;

  debut=fin=time(NULL);

  while(difftime(fin, debut)<5.0){
    b=exp(a);
    fin=time(NULL);
    i++;
  }
  return i;
}
*/


/* mini */

int mini(int a, int b){
if (a<b) return(a);
return(b);
}


/* maxi */

int maxi(int a, int b){
if (a>b) return(a);
return(b);
}


/* mind */

double mind(double a, double b){
if (a<b) return(a);
return(b);
}


/* maxd */

double maxd(double a, double b){
if (a>b) return(a); 
return(b);
}



/* fact */

int fact(int n){
  if (n<=1) return 1;
  return (n*fact(n-1));
}



/* has1_n */
/* Return a random int between 1 and n */

#ifdef SUNOS
#define RAND_MAX 2147483647.
#endif

#if defined(WIN_MAC) || defined(SUNOS) || defined(HP) || defined(__VMS)

int has1_n(int n){
  int p;
#ifdef __VMS
/*  RAND_MAX is the same as INT_MAX, so you can't add one to it without
    an integer overflow.  Probably true on other platforms too, but the
    compilers may handle that differently, as it occurs in the compiler.
*/
  p=(int)((double)rand()*n/(RAND_MAX)) + 1;
#else /*__VMS*/
  p=(int)((double)rand()*n/(RAND_MAX+1)) + 1;
#endif /*__VMS*/
  return p;
}

#else 

int has1_n(int n){
  double d;
  d=drand48();
  return((int)(d*n)+1);
}

#endif


/* vector */
/* from Numerical Recipes in C */
/* Allocation function for ludcmp and lubksb functions */

double *vector(long nl, long nh){
	double *v;

	v=(double *)malloc((size_t) ((nh-nl+1+1)*sizeof(double)));
	if (!v) (void) printf("allocation failure in vector()");
	return v-nl+1;
}


/* free_vector */
/* from Numerical Recipes in C */
/* Memory freeing function for ludcmp and lubksb functions */

void free_vector(double *v, long nl, long nh){
	free((char*) (v+nl-1));
}


/* ludcmp */
/* from Numerical Recipes in C */
/* Replace matrix a by a rowwise permutation of its LU decomposition. */

int ludcmp(double **a, int n, int *indx, double *d){
	int i,imax,j,k;
	double big,dum,sum,temp;
	double *vv;

	vv=vector(1,n);
	*d=1.0;
	for (i=1;i<=n;i++) {
		big=0.0;
		for (j=1;j<=n;j++)
			if ((temp=fabs(a[i][j])) > big) big=temp;
		if (big == 0.0) return 0;
		vv[i]=1.0/big;
	}
	for (j=1;j<=n;j++) {
		for (i=1;i<j;i++) {
			sum=a[i][j];
			for (k=1;k<i;k++) sum -= a[i][k]*a[k][j];
			a[i][j]=sum;
		}
		big=0.0;
		for (i=j;i<=n;i++) {
			sum=a[i][j];
			for (k=1;k<j;k++)
				sum -= a[i][k]*a[k][j];
			a[i][j]=sum;
			if ( (dum=vv[i]*fabs(sum)) >= big) {
				big=dum;
				imax=i;
			}
		}
		if (j != imax) {
			for (k=1;k<=n;k++) {
				dum=a[imax][k];
				a[imax][k]=a[j][k];
				a[j][k]=dum;
			}
			*d = -(*d);
			vv[imax]=vv[j];
		}
		indx[j]=imax;
		if (a[j][j] == 0.0) a[j][j]=1.0e-20;
		if (j != n) {
			dum=1.0/(a[j][j]);
			for (i=j+1;i<=n;i++) a[i][j] *= dum;
		}
	}
	free_vector(vv,1,n);
	return 1;
}



/* lubksb */
/* from Numerical Recipes in C */

void lubksb(double **a, int n, int *indx, double b[]){
	int i,ii=0,ip,j;
	double sum;

	for (i=1;i<=n;i++) {
		ip=indx[i];
		sum=b[ip];
		b[ip]=b[i];
		if (ii)
			for (j=ii;j<=i-1;j++) sum -= a[i][j]*b[j];
		else if (sum) ii=i;
		b[i]=sum;
	}
	for (i=n;i>=1;i--) {
		sum=b[i];
		for (j=i+1;j<=n;j++) sum -= a[i][j]*b[j];
		b[i]=sum/a[i][i];
	}
}



/* matmat */
/* Product of matrices. */
/* Matrices m1(nbl1, nbc1) and m2(nbl2, nbc2) are multiplicated. */
/* Product is written into prod(nbl1, nbc2). */
/* prod allocation is not performed. */

int matmat(double** m1, int nbl1, int nbc1, double** m2, int nbl2, int nbc2, double** prod){

  int i, j, k;

  if(nbc1!=nbl2)  return 0;
  
  for(i=0;i<nbl1;i++){
    for(j=0;j<nbc2;j++){
      prod[i][j]=0.;
      for(k=0;k<nbc1;k++)
	prod[i][j]+=m1[i][k]*m2[k][j];
    }
  }
  return 1;
}



/* matvect */
/* Return the product vector of matrix m1(nbl1, nbc1) by column vector v2. */

double* matvect(double** m1, int nbl1, int nbc1, double* v2, int nbl2){

  int i, k;
  double* vprod;

  if(nbc1!=nbl2) return 0;  
  vprod=(double*)check_alloc(nbl1+1, sizeof(double));

  for(i=0;i<nbl1;i++){
    vprod[i]=0;
    for(k=0;k<nbc1;k++) vprod[i]+=m1[i][k]*v2[k];
  }
  return vprod;
}



/* vectmat */
/* Return the product vector of row vector v1 by matrix m2(nbl1, nbc1). */

double* vectmat(double* v1, int nbc1, double** m2, int nbl2, int nbc2){
  
  int j, k;
  double* vprod;

  if(nbc1!=nbl2) return 0;
  vprod=(double*)check_alloc(nbc2+1, sizeof(double));
  for(j=0;j<nbc2;j++){
    vprod[j]=0;
    for(k=0;k<nbc1;k++) vprod[j]+=v1[k]*m2[k][j];
  }
  return vprod;
}



/* invmat */
/* Invert square matrix mat(n,n). Result in invmat.*/
/* If mat is singular, 0 is returned (1 otherwise) */

int invmat(double** mat, int n, double** invmat){

  int i, j, *indx;
  double *lu[2*MAXNSP-3], d, *col;


  for(i=0;i<n;i++) invmat[i]=(double*)check_alloc(n, sizeof(double));

  for(i=1;i<n+1;i++){
    lu[i]=(double*)check_alloc(n+1, sizeof(double));
    for(j=1;j<n+1;j++) lu[i][j]=mat[i-1][j-1];
  }
  indx=(int*)check_alloc(n+1, sizeof(int));
  col=(double*)check_alloc(n+1, sizeof(double));

  if(!ludcmp(lu, n, indx, &d)) return 0;
  
  for(j=1;j<=n;j++){
    for(i=1;i<=n;i++) col[i]=0.;
    col[j]=1.;
    lubksb(lu, n, indx, col);
    for(i=1;i<=n;i++) invmat[i-1][j-1]=col[i];
  }
  for(i=1; i<n+1;i++) free(lu[i]);
  return 1;
}



/* det */
/* Return the determinant of matrix mat(n, n) */

double det(double** mat, int n){

  int i, j, *indx;
  double *lu[2*MAXNSP-3], d;

  for(i=1;i<n+1;i++){
    lu[i]=(double*)check_alloc(n+1, sizeof(double));
    for(j=1;j<n+1;j++) lu[i][j]=mat[i-1][j-1];
  }
  indx=(int*)check_alloc(n+1, sizeof(int));

  if(!ludcmp(lu, n, indx, &d)) return 0.;
  
  for(i=1;i<n+1;i++) d*=lu[i][i];
  for(i=1;i<n+1;i++)
    free(lu[i]);
  return d;
}




/* lslgbr */
/* Compute the least-square estimates of branch lengths of tree btree */
/* according to effective distances dist. Branch length are returned */
/* via a double table, ordered as in btree. sce returned value is the sum */
/* of squares of residuals between patristic and effective distances. */
/* totallength returned value is the sum of all branch lengths. */
/* Negative branch lengths are forced to 0 in sce and tot computing. */

double* lslgbr(int** btree, int n, double** dist, double* sce, double* totallength){
  int i, j, k, ii, nbdist, nbbr, *ind1, *ind2, b1, b2;
  double *ta[2*MAXNSP-3], *B[2*MAXNSP-3], *invB[2*MAXNSP-3];
  double *prod1[2*MAXNSP-3], *lgbr, *cdist, *pdist;

  nbdist=n*(n-1)/2; nbbr=2*n-3;

  /* move double** dist to double* cdist */

  cdist=(double*)check_alloc(nbdist, sizeof(double));
  ind1=(int*)check_alloc(nbdist, sizeof(int));
  ind2=(int*)check_alloc(nbdist, sizeof(int));

  ii=0;
  for(i=0;i<n-1;i++){
    for(j=i+1;j<n;j++){
      cdist[ii]=dist[i][j];
      ind1[ii]=i; ind2[ii]=j;
      ii++;
    }
  }

  /* build ta */

  for(i=0;i<nbbr;i++) ta[i]=(double*)check_alloc(nbdist, sizeof(double));

  for(i=0;i<n;i++) {
    for(j=0;j<nbdist;j++){
      if(ind1[j]==i || ind2[j]==i) ta[i][j]=1.; else ta[i][j]=0.;
    }
  }
  for(i=n;i<nbbr;i++){
    for(j=0;j<nbdist;j++){
      b1=testbit(btree[i-n],ind1[j]+1); b2=testbit(btree[i-n],ind2[j]+1);
      if((b1 && !b2) || (b2 && !b1)) ta[i][j]=1.; else ta[i][j]=0.;
    }
  }

  /* compute B */

  for(i=0;i<nbbr;i++) B[i]=(double*)check_alloc(nbbr, sizeof(double));
  for(i=0;i<nbbr;i++) invB[i]=(double*)check_alloc(nbbr, sizeof(double));

  for(i=0;i<nbbr;i++) {
    for(j=0;j<nbbr;j++){
      B[i][j]=0.;
      for(k=0;k<nbdist;k++) B[i][j]+=ta[i][k]*ta[j][k];
    }
  }

  /* compute lgbr and pdist */

  for(i=0;i<nbbr;i++) prod1[i]=(double*)check_alloc(nbdist, sizeof(double));

  if(!invmat(B, nbbr, invB)) return NULL;
  (void) matmat(invB, nbbr, nbbr, ta, nbbr, nbdist, prod1);
  lgbr=matvect(prod1, nbbr, nbdist, cdist, nbdist);
  pdist=vectmat(lgbr, nbbr, ta, nbbr, nbdist);

  /* compute sce and total length */
 
  *sce=0.;
  for(i=0;i<nbdist;i++) 
    if(pdist[i]>0.) *sce+=(pdist[i]-cdist[i])*(pdist[i]-cdist[i]);
    else *sce+=cdist[i]*cdist[i];
  *totallength=0.;
  for(i=0;i<nbbr;i++) if(lgbr[i]>0.) *totallength+=lgbr[i];

  free(cdist); free(ind1); free(ind2);
  for(i=0;i<nbbr;i++){
    free(ta[i]);
    free(B[i]);
    free(invB[i]);
    free(prod1[i]);
  }
  return lgbr;
}


/* insertint */

void insertint(char* chaine, long n){
  long i, max=10;
  char* local, num[2];

  local=chaine;
  while (n<(long)pow(10., (double)max)) max--; 
  max=(long)pow(10., (double)max);
  while(max){
    i=n/max;
    (void) sprintf(num,"%d",i);
    *(local++)=num[0];
    n%=max;
    max/=10;
  }
}


void completeaalist(void){
  int l;
  l=(int)strlen(aalist);
  
  if(!strchr(aalist, 'A')) (void) strcat(aalist, "A");
  if(!strchr(aalist, 'C')) (void) strcat(aalist, "C");
  if(!strchr(aalist, 'D')) (void) strcat(aalist, "D");
  if(!strchr(aalist, 'E')) (void) strcat(aalist, "E");
  if(!strchr(aalist, 'F')) (void) strcat(aalist, "F");
  if(!strchr(aalist, 'G')) (void) strcat(aalist, "G");
  if(!strchr(aalist, 'H')) (void) strcat(aalist, "H");
  if(!strchr(aalist, 'I')) (void) strcat(aalist, "I");
  if(!strchr(aalist, 'K')) (void) strcat(aalist, "K");
  if(!strchr(aalist, 'L')) (void) strcat(aalist, "L");
  if(!strchr(aalist, 'M')) (void) strcat(aalist, "M");
  if(!strchr(aalist, 'N')) (void) strcat(aalist, "N");
  if(!strchr(aalist, 'P')) (void) strcat(aalist, "P");
  if(!strchr(aalist, 'Q')) (void) strcat(aalist, "Q");
  if(!strchr(aalist, 'R')) (void) strcat(aalist, "R");
  if(!strchr(aalist, 'S')) (void) strcat(aalist, "S");
  if(!strchr(aalist, 'T')) (void) strcat(aalist, "T");
  if(!strchr(aalist, 'V')) (void) strcat(aalist, "V");
  if(!strchr(aalist, 'W')) (void) strcat(aalist, "W");
  if(!strchr(aalist, 'Y')) (void) strcat(aalist, "Y");
}



/* aaclass */
/* Return the class of aminoacid aa */

int aaclass(char aa){

  int i=0;

  while(aalist[i]!=aa && aagroup[i]!=-1) i++;
  if(aagroup[i]==-1) return 5;
  return(aagroup[i]);
}


/* pur_pyr */

char pur_pyr(char c){

  if(c=='A' || c=='G' || c=='R') return 'R';
  if(c=='C' || c=='T' || c=='U' || c=='Y') return 'Y';
  return '-';
}



/* alphalength */
/* Return the number of alphanumeric characters in string seq */

int alphalength(char* seq){
  int al=0;
  while(*seq) if(isalpha(*seq++)) al++;
  return al;
}


/* nextalpha */
/* Switch char pointer *seqptr to next alphanumeric character address. */
/* Return this alphanumeric char (or \0) */

char nextalpha(char** seqptr){
  while(!isalpha(*(*seqptr)++) && **seqptr);
  return *(*seqptr-1);
}

  
/* invtradseq */
/* Return nucleotidic sequence with gaps from proteic sequence with gaps (seqprot) */
/* and nucleotidic sequence without gaps (seqdna). Gaps in seqdna, if any, are ignored. */

char * invtradseq (char* seqprot, char* seqdna){
  int i;
  char * seqANaln, **prov;

  if (alphalength(seqdna)<3*alphalength(seqprot)) return NULL;
  prov=(char**)check_alloc(1, sizeof(char*));
  *prov=seqdna;
  seqANaln = (char*)check_alloc(3*lgseq+1, sizeof(char));
  for(i=0;i<lgseq;i++){
    if (seqprot[i]=='-') {
      seqANaln[3*i]=seqANaln[3*i+1]=seqANaln[3*i+2]='-';
    }
    else {
      seqANaln[3*i]=nextalpha(prov);
      seqANaln[3*i+1]=nextalpha(prov);
      seqANaln[3*i+2]=nextalpha(prov);
    }
  }
  return seqANaln;
}




/* refresh */
/* Remove all sites with gaps only from sequence alignment seq. */
/* If option==0, all sites with at least one gap are removed. */

void refresh(char** seq, int nbseq, int option, int prot){

  int lgseq, l=-1, drapeau, i, j, k;
  char *seqref[MAXNSP] ;

  lgseq=(int)strlen(seq[0]);
  for(i=0;i<nbseq;i++)
     seqref[i]=(char*)check_alloc(lgseq+1, sizeof(char));

  if (option==0){ /* no site with at least one gap */
    for(i=0;i<lgseq;i++){
      drapeau=0;
      for(j=0;j<nbseq;j++){
	if (!prot  && seq[j][i]!='A' && seq[j][i]!='C' && seq[j][i]!='G' && seq[j][i]!='T'
          && (!TRANSVONLY || (seq[j][i]!='R' && seq[j][i]!='Y'))) drapeau=1;
	if (prot && (seq[j][i]=='X' || seq[j][i]=='-')) drapeau=1;
      }
      if (drapeau==0){
	l++;
	for(k=0;k<nbseq;k++) *(seqref[k]+l)=*(seq[k]+i);
      }	
    }
    for(i=0;i<nbseq;i++)
      for (j=l+1;j<lgseq;j++) 
        *(seqref[i]+j)='\0';
  }
  else{ /* no site with only gaps */
    for(i=0;i<lgseq;i++){
      drapeau=0;
      for(j=0;j<nbseq;j++){
	if (!prot && (*(seq[j]+i)=='A' || *(seq[j]+i)=='C' 
	    || *(seq[j]+i)=='T' || *(seq[j]+i)=='G') 
	    || (TRANSVONLY && (*(seq[j]+i)=='R' || *(seq[j]+i)=='Y'))) { 
	  drapeau=1;
	  break;
	}
	if (prot && (*(seq[j]+i)!='X' || *(seq[j]+i)!='-')) { 
	  drapeau=1;
	  break;
	}
      }
      if (drapeau==1){
	l++;
	for(k=0;k<nbseq;k++){
	  *(seqref[k]+l)=*(seq[k]+i);
	  *(seqref[k]+l+1)=0;
        }
      }		
    }
  }
  for (i=0;i<nbseq;i++) 
    for (j=0;j<lgseq;j++)
      *(seq[i]+j)=*(seqref[i]+j);
      
  for(i=0;i<nbseq;i++) free(seqref[i]);
}




/* treeend */
/* TRUE if string line ends with ';', FALSE otherwise. */

Boolean treeend(char* line) {
  char* l;
  
  l=line+(int)strlen(line)-1;
  while(*l=='\0' || *l=='\n' || *l==' ' || *l=='\t') l--;
  return (*l==';')? TRUE:FALSE;
}

  

/* samename */
/* TRUE if names name1 and name2 are equal, FALSE otherwise */

Boolean samename(char* name1, char* name2){
 
  int i=0;
  char c1, c2;
  
  while(i<20){
    c1=name1[i]; c2=name2[i];
    if((c1==' ' || c1=='\n' || c1=='\t' || c1==0) && 
      (c2==' ' || c2=='\n' || c2=='\t' || c2==0)) return TRUE;
    if(c1!=c2) return FALSE;
    i++;
  }
  return TRUE;
}


/* basecomp */
/* Write in comp the composition (percent of 4 bases) of sequence seq */

int basecomp(char* seq, double* comp){
  int i, lg=0;
  
  for(i=0;i<4;i++) comp[i]=0.;
  for(i=0;seq[i];i++){
   if(seq[i]=='A') comp[0]++;
   else if(seq[i]=='C') comp[1]++;
   else if(seq[i]=='G') comp[2]++;
   else if(seq[i]=='T') comp[3]++;
   else lg--;
   lg++;
  }
  if(lg<=0) return 0;
  for(i=0;i<4;i++) comp[i]=comp[i]*100/lg;
  return lg;
}



/* aacomp */
/* Compute aminoacid composition of proteic sequence seq. */
/* The whole composition (percent of 20 aminoacid) is written in comp, */
/* ordered as in aalist. */
/* Percent of each aminoacid group are written in compgroup. */

int aacomp(char* seq, double* comp, double* compgroup){
  int i, j, lg=0, nbaa;
  int c;

  nbaa=(int)strlen(aalist);
  for(i=0;i<nbaa;i++) comp[i]=0.;
  for(i=0;i<nbaagroup;i++) compgroup[i]=0.;
  for(i=0;seq[i];i++){
    for(j=0;j<nbaa;j++){
      if(seq[i]==aalist[j]) { comp[j]++; break; }
    }
    if(j==nbaa) lg--;
    c=aaclass(seq[i]);
    if(c!=-1) compgroup[c]++;
    lg++;
  } 
  if(lg<=0) return 0;
  for(i=0;i<nbaa;i++) comp[i]=comp[i]*100/lg; 
  for(i=0;i<nbaagroup;i++) compgroup[i]=compgroup[i]*100/lg;
  return lg;
}



/* variable */
/* Returns the number of variable sites in sequences sequ */

int variable(char** sequ, int nb){
  int i, j, var;

  var=strlen(sequ[0]);
  for(i=0;sequ[0][i];i++){
    for(j=1;j<nb;j++){
      if(sequ[j][i]!=sequ[0][i]) break;
    }
    if(j==nb) var--;
  }
  return var;
}



/* informative */
/* Returns the number of informative sites in sequences sequ */

int informative(char** sequ, int nb){

  int i, j, k, info=0, siteok=0;
  char firstpair;

  
  for(i=0;sequ[0][i];i++){
    firstpair=0;
    siteok=0;
    for(j=0;j<nb-1;j++){
      for(k=j+1;k<nb;k++){
	if(sequ[j][i]==sequ[k][i]){
 	  if(firstpair){
	    if(sequ[j][i]!=firstpair) { info++; siteok=1; break; }
	  }
	  else
	    firstpair=sequ[j][i];
        }
      }
      if (siteok) break;
    }
  }
  
  return info;
}
	


/* checknames */
/* Make sure sequence names seqname are suitable : */
/* no '(' ')' ',' ':' ';' , ending '_' */
/* no pair of identical names */


int checknames(int nb, char** seqname, char* err_mess){

  int i, j;

  for(i=0;i<nb;i++){
    if(strchr(seqname[i], '(') || strchr(seqname[i], ')')){
      (void) sprintf(err_mess, "(names should not include parenthesis)");
      return 0 ;
    }
    if(strchr(seqname[i], ',')){
      (void) sprintf(err_mess, "(names should not include commas ',')");
      return 0;
    }
    if(strchr(seqname[i], ':')){
      (void) sprintf(err_mess, "(names should not include colons ':')");
      return 0;
    }
    if(strchr(seqname[i], ';')){
      (void) sprintf(err_mess, "(names should not include semicolons ';')");
      return 0;
    }
    if(seqname[i][(int)strlen(seqname[i])-1]=='_'){
      (void) sprintf(err_mess, "(sequence names last character should not be an underscore _ )");
      return 0;
    }
    for(j=i+1;j<nb;j++){
      if(samename(seqname[i], seqname[j])){
        (void) sprintf(err_mess, "(identical name %s for sequence %d and %d)", seqname[i], i+1, j+1);
        return 0;
      }
    }   
  }
  return 1;

}




/* fileread */

int fileread(FILE* input, char** seq, char** seqname, char** comments,
 int*  nb_site_set, int** site_set, char** site_set_name,
 int* nb_spec_set, int** spec_set, char** spec_set_name,
 int* nbtree, char** treenom, char** tree, char* format, char* err_mess){

  char line[MAXLLINE];
  int i, j, ret;

  line[0]='\n';
  while(line[0]=='\n') (void) fgets(line, MAXLLINE, input);
  err_mess[0]='\0';

  if(strncmp(line, ";;", 2)==0){  /* MASE format */
    rewind(input); 
    if(format) *format='M';
    ret=maseread(input, seq, seqname, comments, nb_site_set,
      site_set,site_set_name, nb_spec_set, spec_set, spec_set_name,
      nbtree, treenom, tree, err_mess);
  }

  if(strncmp(line,"CLUSTAL",7) == 0){  /* CLUSTAL format */
    rewind(input);
    *nb_site_set=*nb_spec_set=*nbtree=0;
    if(comments) comments[0]=NULL;
    if(format) *format='C';
    ret=clustread(input, seq, seqname, err_mess);
  }    

  if(line[0]=='>'){  /* FASTA format */
    rewind(input);
    *nb_site_set=*nb_spec_set=*nbtree=0;
    if(comments) comments[0]=NULL;
    if(format) *format='F';
    ret=fastaread(input, seq, seqname, err_mess);
  }
  

  if(sscanf(line, "%d%d", &i, &j)==2){ /* PHYLIP format */
    rewind(input);
    *nb_site_set=*nb_spec_set=*nbtree=0;
    if(comments) comments[0]=NULL;
    if(format) *format='P';
    ret=phylipread(input, seq, seqname, err_mess);
  }

  if(strncmp(line, "#NEXUS", 6)==0){ /* NEXUS = PAUP format */
    rewind(input);
    *nb_site_set=*nb_spec_set=*nbtree=0;
    if(comments) comments[0]=NULL;
    if(format) *format='N';
    ret=paupread(input, seq, seqname, nbtree, treenom, tree);
  }  

  if(ret==0) return ret;

  if(checknames(ret, seqname, err_mess)==FALSE) return 0;


  return ret;
}




int paupread(FILE* input, char** seq, char** seqname,
   int* nbtree, char** treenom, char** tree){

  int nb, lg, i, ii, j, blen;
  char line[MAXLLINE], *block, *prov, *prov2, **sprov, c, missing, match;
  Boolean inter;

  while(fgets(line, MAXLLINE, input)){ 
    if((prov=strstr(line, "begin"))!=NULL && strstr(prov, "data")){
      block=(char*)check_alloc(MAXLLINE, sizeof(char));
      (void) strcat(block, prov); 
      blen=(int)strlen(block);
      while(1){
	prov=strstr(line, "end");
	if(prov) break; 
	if(!fgets(line, MAXLLINE, input)) return 0;
	j=(int)strlen(line);
	block=(char*)check_ralloc(block, j, sizeof(char));
	blen+=j;
	(void) strcat(block, line);
      }
      /* block=data block */
      i=0;
      prov=strstr(block+blen-j-1, "end"); if(!prov) return 0;
      *prov='\0';
      while(block[i]){ /* remove [] comments */
	if(block[i]=='[') { 
	  while(block[i]!=']'){ block[i]=' '; i++; }
	  block[i]=' ';
	}
	i++;
      }
      prov=strstr(block, "ntax"); if(!prov) return 0;
      prov2=strchr(prov, '='); if(!prov2) return 0;
      (void) sscanf(prov2+1, "%d", &nb);
      prov=strstr(block, "nchar"); if(!prov) return 0;
      prov2=strchr(prov, '='); if(!prov2) return 0;
      (void) sscanf(prov2+1, "%d", &lg);
      sprov=(char**)check_alloc(nb, sizeof(char*));
      for(i=0;i<nb;i++){
	seq[i]=(char*)check_alloc(lg+5, sizeof(char));
	sprov[i]=seq[i];
	seqname[i]=(char*)check_alloc(MAXLNAME+1, sizeof(char));
      }
      prov=strstr(block, "missing");
      if(prov){
	prov=strchr(prov, '=')+1;
	while(*prov==' ' || *prov=='\t') prov++;
	if(*prov=='\'') prov++;
	missing=*prov;
      }
      prov=strstr(block, "matchchar");
      if(prov){
	prov=strchr(prov, '=')+1;
	while(*prov==' ' || *prov=='\t') prov++;
	if(*prov=='\'') prov++;
	match=*prov;
      }

      if(strstr(block, "interleave")) inter=TRUE; else inter=FALSE;
      prov=strstr(block, "matrix"); if(!prov) { return 0;} prov+=6;
      if(inter){
	ii=0;
	while(1){
	  prov2=strtok(prov, "\n"); if(!prov2)  break; 
	  i=ii%nb; while(*prov2 && *prov2==' ' || *prov2=='\t') prov2++;
	  if(*prov2==0) goto finboucle;
	  if(ii<nb){ /* name input */
	    j=0;
	    while(*prov2 && *prov2!=' ' && *prov2!='\t' && j<=20) { seqname[i][j]=*prov2++; j++; }
	    if(*prov2==0) {return 0;}
	    seqname[i][j]=0;
	  }
	  else{
	    j=0;
	    while(*prov2!=' ' && *prov2!='\t') if(*prov2++ != seqname[i][j++]) goto finboucle;
	  }
	  j=0;
	  while(prov2[j]){ /* seq input */
	      if(prov2[j]!=' ' && prov2[j]!='\t') { *(sprov[i])=prov2[j]; sprov[i]++; }
	      j++;
	  }
	  ii++;
	  finboucle : prov=NULL;
        }
      }
      else{
	for(i=0;i<nb;i++){
	  while(*prov==' ' || *prov=='\t' || *prov=='\n') prov++; j=0;
	  while(*prov!=' ' && *prov!='\t' && *prov!='\n') seqname[i][j++]=*prov++; j=0;
	  for(ii=0;j<lg;ii++){
	    c=*prov++; if(c!=' ' && c!='\n' && c!='\t') seq[i][j++]=c;
	  }
	  seq[i][j]=0;
	}
      }
      for(i=0;i<nb;i++){
	for(j=0;j<lg;j++){
	  if(seq[i][j]==missing) seq[i][j]='-';
	  if(seq[i][j]==match) seq[i][j]=seq[0][j];
	  if(islower(seq[i][j])) seq[i][j]=toupper(seq[i][j]);
	}
      }
      return nb;
    }
  }
  (void) printf("Coding error in paupread or data error in PAUP file\n");
  (void) printf("Returning 0 status to program - it may blow up!!\n");
  return 0;
}




int clustread(FILE* in, char **seq, char **seqname, char* err_mess){
  char line[2000], *p;
  int i, l, curr_spec, first=TRUE, curr_len, next_len, tot_spec;
  int pos, clu_maxlname=10;


  if(in==NULL) return 0;
	
  (void) fgets(line,sizeof(line),in);
  if(strncmp(line,"CLUSTAL",7) != 0) {
    tot_spec = -1; goto fini;
  }

  *line='\n';
  while(*line=='\n'){
    pos=ftell(in);
    (void) fgets(line, sizeof(line), in);
  }
  (void) fseek(in, pos, SEEK_SET);


  tot_spec = curr_spec = -1; curr_len = next_len = 0;
  while( fgets(line, sizeof(line), in) != NULL ) {
    if(*line == '\n' || *line == ' ') {
      curr_spec = -1;
      curr_len = next_len;
      first = FALSE;
      continue;
    }
    else {
      curr_spec++;
      if(curr_spec >= MAXNSP) { 
	tot_spec = -1;
	goto fini; 
      }
    }
    if(first) {
      seqname[curr_spec] = (char*)malloc(MAXLNAME+1);
      if(seqname[curr_spec]==NULL) {
	goto nomem;
      }
      (void) memcpy(seqname[curr_spec], line, clu_maxlname);
      p = seqname[curr_spec] + clu_maxlname - 1;
      while(*p==' ') p--; *(p+1)=0;
      if(curr_spec > tot_spec) tot_spec = curr_spec;
      seq[curr_spec] = (char*)malloc(MAXLSEQ+1);
      if(seq[curr_spec]==NULL) {
	goto nomem;
      }
    }
    if(curr_spec == 0) {
      l = (int)strlen(line) - 1;
      p = line + l - 1; while(*p==' ') { p--; l--; }
      l -= clu_maxlname;
      if(curr_len + l > MAXLSEQ) {
	tot_spec = -1;
	goto fini;
      }
      next_len = curr_len + l;
    }
    (void) memcpy(seq[curr_spec]+curr_len, line + clu_maxlname, l);
  }

  for(i=0; i<=tot_spec; i++) seq[i][next_len] = 0;

  fini:
  return tot_spec + 1;

/* original 

  nomem:
  tot_spec = -1;
  goto fini;

kind of silly to subtract one, then do a goto, then add one, then return, eh?

*/
  nomem:
  return tot_spec;
}



int fastaread(FILE* input, char** seq, char** seqname, char* err_mess){
  int i, j, lseq=0, maxlseq=0, flag;
  char* line, *s, *prov[MAXNSP];
 
  line=(char*)check_alloc(MAXLLINE, sizeof(char));

	/* 1st reading : max seq length estimation */

  while(fgets(line, MAXLLINE, input)){
    if(*line=='>') {
      if(maxlseq<lseq) maxlseq=lseq;
      lseq=0;
    }
    else lseq+=(int)strlen(line);
  }
  if(maxlseq<lseq) maxlseq=lseq;
  

  rewind(input);

  (void) fgets(line, MAXLLINE, input);
  i=flag=0;
  while(1){
    seqname[i]=(char*)check_alloc(MAXLNAME+1, sizeof(char));
    seq[i]=(char*)check_alloc(maxlseq+1, sizeof(char));
    prov[i]=seq[i];
    s=strtok(line, "> \n\t");
    if(s) (void) sprintf(seqname[i], "%s", s);
    line[i]=0;
    while(1){
      if(!fgets(line, MAXLLINE, input)) {flag=1; break;}
      if(line[0]=='>') break;
      (void) sprintf(prov[i], "%s", line);
      while(*(prov[i]) && isascii(*(prov[i])) && *(prov[i])!='\n') prov[i]++;
      *prov[i]=0;
    }
    i++;
    if(flag) break;
  }

  return i;
}



int phylipread(FILE* input, char** seq, char** seqname, char* err_mess){
  int i=0, nb, lg, max, len, l;
  char line[MAXLLINE], *prov[MAXNSP];
  Boolean firstblock=TRUE, OK=TRUE;
  int PHY_MAX_NAME_LEN=10;
  
  (void) fgets(line, MAXLLINE, input);
  (void) sscanf(line, "%d,%d", &nb, &lg);

  while(fgets(line, MAXLLINE, input)) { if (i==0) len=(int)strlen(line); i++; }
  max=i*len;
  if(max<lg) max=lg;
  rewind(input);
  (void) fgets(line, MAXLLINE, input);

  for(i=0;i<nb;i++){
    seqname[i]=(char*)check_alloc(MAXLNAME+1, sizeof(char));
    seq[i]=(char*)check_alloc(max, sizeof(char));
    prov[i]=seq[i];
  }

  while(OK){
    for(i=0;i<nb;i++){
      if(!fgets(line, MAXLLINE, input)){OK=FALSE; break;}
      if(firstblock){
        (void) strncpy(seqname[i], line, PHY_MAX_NAME_LEN);
	seqname[i][PHY_MAX_NAME_LEN]=0;
        l=PHY_MAX_NAME_LEN-1;
	while(seqname[i][l]==' ') {seqname[i][l]='\0'; l--;}
	(void) sprintf(prov[i], "%s", line+PHY_MAX_NAME_LEN);
	while(*(prov[i]) && *(prov[i])!='\n') prov[i]++;
      }
      else{
	(void) sprintf(prov[i], "%s", line);
	while(*(prov[i]) && *(prov[i])!='\n') prov[i]++;
      }
    }
    (void) fgets(line, MAXLLINE, input);
    if(firstblock) firstblock=FALSE;
  }
  for(i=0;i<nb;i++) *prov[i]=0;
  return nb;
}
  



/* maseread */
/* Read input MASE file. Return number of read sequences. */

int maseread(FILE* input, char** seq, char** seqname, char** comments,
   int*  nb_site_set, int** site_set, char** site_set_name,
   int* nb_spec_set, int** spec_set, char** spec_set_name,
   int* nbtree, char** treenom, char** tree, char* err_mess){

  int  i=0, j, k, lseq=0, bound, notu=0, nb, cptsite=-1, cptspec=-1,
       read, flagsite=0, flagspec=0, maxlseq=0, l, lgc ;
  char *line, *c, *c1, *c2;
  Boolean debut, fin=FALSE;

  line = (char *) check_alloc(MAXLLINE, sizeof(char));
  if (nbtree) *nbtree=-1;

	/* 1st reading : max seq length estimation */

  while(fgets(line, MAXLLINE, input)){
    if(*line==';') {
      if(maxlseq<lseq) maxlseq=lseq;
      lseq=0;
    }
    else lseq+=(int)strlen(line);
  }

  rewind(input);


	/* 2nd reading */

	/* regions and species sets */

  if (nb_site_set==NULL && nb_spec_set==NULL && nbtree==NULL)
    do (void) fgets(line, MAXLLINE, input); while(strncmp(line, ";;", 2) == 0);
	
  else do {
    if (flagsite) free(site_set[cptsite--]);
    if (flagspec) free(spec_set[cptspec--]);

    if (fgets(line, MAXLLINE, input) == NULL) return (notu);
    if (strncmp(line, ";;#", 3) == 0 || strncmp(line, ";; #", 4) == 0) {
      read = flagsite = 0;
      c = strchr(line, '=');
      (void) sscanf(c + 1, "%d", &nb);
      site_set[++cptsite] = (int *) check_alloc(2 * nb + 1, sizeof(int));
      site_set[cptsite][0] = nb;

      c1 = strtok(c + 1, "\t\n:,.- ");
      c2 = strtok(NULL, "\n");
      if(c2) k = (int)strlen(c2); else k=0;
      if (k > 0) {
	site_set_name[cptsite] = (char *) check_alloc(k + 1, sizeof(char));
	(void) sprintf(site_set_name[cptsite], "%s", c2);
	while(site_set_name[cptsite][0] && 
	  (site_set_name[cptsite][0]==' ' || site_set_name[cptsite][0]=='\t'))
	  site_set_name[cptsite]++;
	if(site_set_name[cptsite][0]==0){
	  site_set_name[cptsite] = (char *) check_alloc(7, sizeof(char));
	  (void) sprintf(site_set_name[cptsite], "set%d", cptsite+1);
	}
	c=site_set_name[cptsite]+(int)strlen(site_set_name[cptsite])-1;
	while(*c==' ') *c--=0;
      } else {
	site_set_name[cptsite] = (char *) check_alloc(7, sizeof(char));
	(void) sprintf(site_set_name[cptsite], "set%d", cptsite+1);
      }
      while (read < 2 * nb) {
	char *clocal;
	(void) fgets(line, MAXLLINE, input);
	clocal = line;
	while ((c = strtok(clocal, ";, \n\t:./")) != NULL) {
	  (void) sscanf(c, "%d", &bound);
	  if (read > 0 && bound < site_set[cptsite][read]) {
	    flagsite = 1;
	    break;
	  } 
	  else site_set[cptsite][++read] = bound-1;
	  clocal = NULL;
	}
	if (flagsite) break;
      }
    }

    if (strncmp(line, ";;@", 3) == 0 || strncmp(line, ";; @", 4) == 0) {
      read = flagspec = 0;
      c = strchr(line, '=');
      (void) sscanf(c + 1, "%d", &nb);
      spec_set[++cptspec] = (int *) check_alloc(2 * nb + 1, sizeof(int));
      spec_set[cptspec][0] = nb;

      c1 = strtok(c + 1, "\t\n:,.- ");
      c2 = strtok(NULL, "\n");
      if(c2) k = (int)strlen(c2); else k=0;

      if (k > 0) {
	spec_set_name[cptspec] = (char *) check_alloc(k + 1, sizeof(char));
	(void) sprintf(spec_set_name[cptspec], "%s", c2);
	while(spec_set_name[cptspec][0] && 
	  (spec_set_name[cptspec][0]==' ' || spec_set_name[cptspec][0]=='\t'))
	  spec_set_name[cptspec]++;
	if(spec_set_name[cptspec][0]==0){
	  spec_set_name[cptspec] = (char *) check_alloc(7, sizeof(char));
	  (void) sprintf(spec_set_name[cptspec], "set%d", cptspec+1);
	}
	c=spec_set_name[cptspec]+(int)strlen(spec_set_name[cptspec])-1;
	while(*c==' ') *c--=0;
      } 
      else {
	spec_set_name[cptspec] = (char *) check_alloc(7, sizeof(char));
	(void) sprintf(spec_set_name[cptspec], "set%d", cptspec+1);
      }
      while (read < nb) {
	char *clocal;
	(void) fgets(line, MAXLLINE, input);
	clocal = line;
	while ((c = strtok(clocal, ";, \n\t:./")) != NULL) {
	  (void) sscanf(c, "%d", &bound);
	  /*if (read > 0 && bound < spec_set[cptspec][read]) {
	    flagspec = 1;
	    break;
	  } 
	  else*/
	  spec_set[cptspec][++read] = bound-1;
	  clocal = NULL;
	}
	if (flagspec) break;
      }

    }

    if (strncmp(line, ";;$", 3)==0 || strncmp(line, ";; $", 4) == 0) {
      (*nbtree)++;
      treenom[*nbtree]=(char*)check_alloc(30, sizeof(char));
      (void) sscanf(strtok(line+3," $\t:,.\n"), "%s", treenom[*nbtree]);
      while((c=strpbrk(line,"[("))==NULL) (void) fgets(line, MAXLLINE, input);
      tree[*nbtree]=(char*)check_alloc(20+(lgc=(int)strlen(c)), sizeof(char));
      tree[*nbtree][0]=0;
      debut=TRUE;
      while(debut || !fin) {
        fin=treeend(line);
        i=(int)strlen(debut?c:line+2);
	if(debut && *c=='(') (void) sprintf(tree[*nbtree], "[no header\\]");
        (void) strncat(tree[*nbtree], debut?c:line+2, i-1); 
        if (debut) debut=FALSE;
        if (!fin) {
	  (void) fgets(line, MAXLLINE, input);
	  tree[*nbtree]=(char*)realloc(tree[*nbtree], lgc=lgc+(int)strlen(line));
        }
      }
      c=strchr(tree[*nbtree],'[');
      if (c)
        while(*c++!=']') if(*c=='\\') *c='\n';

    }
  }

  while (strncmp(line, ";;", 2) == 0);


  if (nb_site_set) *nb_site_set = cptsite + 1;
  if (nb_spec_set) *nb_spec_set = cptspec + 1;
  if (nbtree) (*nbtree)++;



	/* sequences, names and comments */

  while (1) {
    if(comments) comments[notu]=(char*)check_alloc(MAXLCOM, sizeof(char));
    lgc=0;
    while (*line == ';'){
      if (comments && (lgc=lgc+(int)strlen(line))<MAXLCOM) (void) strcat(comments[notu], line);
      if (fgets(line, MAXLLINE, input) == NULL) goto end;
    }
    i = (int)strlen(strtok(line, " \n"));
    seqname[notu] = (char *) check_alloc(MAXLNAME+1, sizeof(char));
    (void) strncpy(seqname[notu], line, MAXLNAME);
    seq[notu] = (char *) check_alloc(maxlseq+1, sizeof(char));

    while (*line != ';') {
      if (fgets(line, MAXLLINE, input) == NULL) goto end;
      i = (int)strlen(line);
      if(*line!=';') (void) strncat(seq[notu], line, i-1);
    }
    notu++;

  }


end :

	/* to uppercase, T becomes U,  */
	/* and anything non-alpha becomes '-' */

  for(i=0;i<notu+1;i++){
    l=(int)strlen(seq[i]);  
    for(j=0;j<l;j++){
      if(isalpha(seq[i][j])){
	if(islower(seq[i][j])) seq[i][j]=toupper(seq[i][j]);
	if(seq[i][j]=='U') seq[i][j]='T';
      }
      else seq[i][j]='-';
    }
  }
  return (notu+1);
}




/* maseprint */
/* Write output MASE file. Return number of written sequences. */

int maseprint(FILE* output, char** seq,
    char** seqname, char** comments, int notu,
    int nb_site_set, int** site_set, char** site_set_name,
    int nb_spec_set, int** spec_set, char** spec_set_name,
    int nbtree, char** treenom, char** tree){

  int i, j, k, l;
  char c, newline='\\', *ch;


  (void) fprintf(output, ";;Mase format\n");
  for(i=0;i<nb_site_set;i++){
    (void) fprintf(output, ";;# of regions = %d    %s\n;;", site_set[i][0], site_set_name[i]);
    for(j=1;j<=site_set[i][0];j++){
      (void) fprintf(output, " %d,%d ", site_set[i][2*j-1]+1, site_set[i][2*j]+1);
      if((j+1)%10==0) (void) fprintf(output, "\n;;");
    }
    (void) fprintf(output, "\n");
  }
  for(i=0;i<nb_spec_set;i++){
    (void) fprintf(output, ";;@ of species = %d    %s\n;;", spec_set[i][0], spec_set_name[i]);
    for(j=1;j<spec_set[i][0];j++){
      (void) fprintf(output, " %d,", spec_set[i][j]+1);
      if((j+1)%20==0) (void) fprintf(output, "\n;;");
    }
    (void) fprintf(output, " %d\n", spec_set[i][spec_set[i][0]]+1);
  }
  for(i=0;i<nbtree;i++){
    ch=strchr(treenom[i], '(');
    if(ch){
      k=ch-treenom[i];
      (void) fprintf(output, ";;$ ");
      for(j=0;j<k;j++) (void) fprintf(output,"%c", treenom[i][j]);
      (void) fprintf(output, "\n;;");
    }
    else
      (void) fprintf(output, ";;$ %s\n;;", treenom[i]);
    j=0; c=tree[i][0];
    if(c=='['){
      while(c!=']') (void) fprintf(output,"%c", (c=tree[i][j++])=='\n'?newline:c);
      (void) fprintf(output, "\n;;");
    }
    else (void) fprintf(output, "[no header]\n;;");
    while(tree[i][j]!='(') j++;
    l=(int)strlen(tree[i]+j);
    for(k=0;k<l;k++){
      (void) fprintf(output, "%c",tree[i][j+k]);
      if ((k+1)%60==0) (void) fprintf(output, "\n;;");
    }
    (void) fprintf(output,"\n");
      
  } 
  for(i=0;i<notu;i++){
    if (comments[0]) (void) fprintf(output, "%s", comments[i]); 
    else (void) fprintf(output, ";comments line for sequence : %s\n", seqname[i]); 
    (void) fprintf(output, "%s\n", seqname[i]);
    l=(int)strlen(seq[i]);
    for(j=0;j<l;j++){
      (void) fprintf(output,"%c",seq[i][j]);
      if ((j+1)%60==0) (void) fprintf(output,"\n");
    }
    (void) fprintf(output, "\n");
  }
  return (notu);
}



	/** TREE  USING  FUNCTIONS **/


/* create_node */
/* Return a node (part of a s_tree) whose "parent", "childs" and values are */
/* v1, v2, v3, l1, l2, l3, nom, order. */

noeud create_node(noeud v1, noeud v2, noeud v3, double l1,
   double l2, double l3, double b1, double b2, double b3, char* nom) {

  noeud nd;

  nd = (struct noeud2*) check_alloc(1, sizeof(struct noeud2));
  nd->nom = (char*) check_alloc(MAXLNAME+1, sizeof(char));
  if (nd==NULL) {
    (void) printf("Not enough memory.\n");
    return NULL;
  }
  nd->v1 = v1; nd->v2 = v2; nd->v3 = v3;
  nd->ml1= nd->l1 = l1; nd->ml2= nd->l2 = l2; nd->ml3 = nd->l3 = l3;
  nd->b1 = b1; nd->b2 = b2; nd->b3 = b3;
  if (nom!=NULL) { (void) sprintf(nd->nom, "%s", nom); nd->nom[20]=0; }
  return nd;
}



/* bottomnode */
/* Return the root node of rooted s_tree including node nd. */
/*    !!BEWARE!!    */
/* If the s_tree including node nd is unrooted, program will bug */
/* (infinite loop). */

noeud bottomnode(noeud nd){
  if(nd->v3 == NULL) return nd;
  return (bottomnode(nd->v3));
}



/* tree_ttos */
/* TableTOStruct. Create s_tree arbre_s from : t_tree arbre_t, leaves number notu, */
/* branch lengths lgbi (internal branches) , lgbp (terminal branches). */
/* If tree has no branch length, arguments 3 and 4 must be NULL. */


int tree_ttos(int** arbre_t, int notu, double* lgbi, double* lgbp,
    double* bootval, char** nom, noeud* arbre_s){

  noeud   	p1, p2;
  int           notuv, i, j, k, sommebi, tax1, tax2, n1, n2, n3, cpt1=-1;
  int           *kill_tax, *kill_bi;
  double	arg6, arg9;

  kill_tax = (int *)check_alloc(notu, sizeof(int));
  kill_bi = (int *)check_alloc(notu, sizeof(int));

  notuv = notu;
  for (i = 0; i <notu; i++){
    kill_tax[i] = 0;
    kill_bi[i] = 0;
  }

	/* terminal nodes */

  for (i = 0; i < notu; i++){
    if(lgbp==NULL) arg6=-1.0; else arg6=lgbp[i];
    arbre_s[i] = create_node(NULL, NULL, NULL, 0., 0., arg6, -1., -1., -1., nom[i]);
  }


	/* internal nodes */

  for (i = 0; i < notu - 3; i++) {
	/* determination de la bi a creer */
    for (j = 0; j < notu - 3 ; j++) {
      if (kill_bi[j] == 0) {
	sommebi = 0;
	for (k = 0; k < notu; k++)
	  if (kill_tax[k] == 0) {
	    sommebi += arbre_t[k][j];
	  }
	if (sommebi == 2 || notuv - sommebi == 2)
	  break;
      }
    }

	/* determination des 2 otus/noeuds fils */
    if (sommebi == 2) {
      for (k = 0; k < notu; k++)
	if (arbre_t[k][j] == 1 && kill_tax[k] == 0) {
	  tax1 = k;
	  break;
	}
      for (k = tax1 + 1; k < notu; k++)
	if (arbre_t[k][j] == 1 && kill_tax[k] == 0) {
	  tax2 = k;
	  break;
	}
    } else {
      for (k = 0; k < notu; k++)
	if (arbre_t[k][j] == 0 && kill_tax[k] == 0) {
	  tax1 = k;
	  break;
	}
      for (k = tax1 + 1; k < notu; k++)
	if (arbre_t[k][j] == 0 && kill_tax[k] == 0) {
	  tax2 = k;
	  break;
	}
    }

    p1 = bottomnode(arbre_s[tax1]);
    p2 = bottomnode(arbre_s[tax2]);

    if (lgbp) arg6=lgbi[j]; else arg6=0.;
    if (bootval) arg9=bootval[j]; else arg9=-1;
    arbre_s[notu + (++cpt1)] = create_node(p1, p2, NULL,
       p1->l3, p2->l3, arg6, p1->b3, p2->b3, arg9, NULL);

    p1->v3 = arbre_s[notu + cpt1];
    p2->v3 = arbre_s[notu + cpt1];

    kill_tax[tax1] = kill_bi[j] = 1;
    notuv--;
  }


	/* last node */


  for (i = 0; i < 2 * notu - 3; i++) 
    if (arbre_s[i]->v3 == NULL) {
      n1 = i;
      break;
    }

  for (i = n1 + 1; i < 2 * notu - 3; i++) 
    if (arbre_s[i]->v3 == NULL) {
      n2 = i;
      break;
    }
  
  for (i = n2 + 1; i < 2 * notu - 3; i++) 
    if (arbre_s[i]->v3 == NULL) {
      n3 = i;
      break;
    }
  

  arbre_s[2 * notu - 3] = create_node(arbre_s[n1], arbre_s[n2],
                          arbre_s[n3], arbre_s[n1]->l3, arbre_s[n2]->l3,
                          arbre_s[n3]->l3, arbre_s[n1]->b3, arbre_s[n2]->b3,
                          arbre_s[n3]->b3, NULL);
  arbre_s[n1]->v3 = arbre_s[2 * notu - 3];
  arbre_s[n2]->v3 = arbre_s[2 * notu - 3];
  arbre_s[n3]->v3 = arbre_s[2 * notu - 3];

  free(kill_tax); free(kill_bi);
  return 0;
}


/* tree_btos */
/* BitTOStruct. Create s_tree arbre_s from : b_tree arbre_b, leaves number notu, */
/* branch lengths lgbi (internal branches) , lgbp (terminal branches). */
/* If tree has no branch length, arguments 3 and 4 must be NULL. */


int tree_btos(int** arbre_b, int notu, double* lgbi, double* lgbp,
     double* bootval, char** nom, noeud* arbre_s){

  noeud   	p1, p2;
  int           notuv, i, j, k, sommebi, tax1, tax2, n1, n2, n3, cpt1=-1;
  int           *kill_tax, *kill_bi;
  double	arg6, arg9;

  kill_tax = (int *)check_alloc(notu, sizeof(int));
  kill_bi = (int *)check_alloc(notu, sizeof(int));

  notuv = notu;
  for (i = 0; i <notu; i++){
    kill_tax[i] = 0;
    kill_bi[i] = 0;
  }


	/* terminal nodes */

  for (i = 0; i < notu; i++){
    if(lgbp==NULL) arg6=-1.0; else arg6=lgbp[i];
    arbre_s[i] = create_node(NULL, NULL, NULL, 0., 0., arg6, -1., -1., -1., nom[i]);
  }


	/* internal nodes */

  for (i = 0; i < notu - 3; i++) {
	/* determination de la bi a creer */
    for (j = 0; j < notu - 3 ; j++) {
      if (kill_bi[j] == 0) {
	sommebi = 0;
	for (k = 0; k < notu; k++)
	  if (kill_tax[k] == 0) {
	    if(testbit(arbre_b[j], k+1)) sommebi++;
	  }
	if (sommebi == 2 || notuv - sommebi == 2)
	  break;
      }
    }

	/* determination des 2 otus/noeuds fils */
    if (sommebi == 2) {
      for (k = 0; k < notu; k++)
	if (testbit(arbre_b[j], k+1) && kill_tax[k] == 0) {
	  tax1 = k;
	  break;
	}
      for (k = tax1 + 1; k < notu; k++)
	if (testbit(arbre_b[j], k+1) && kill_tax[k] == 0) {
	  tax2 = k;
	  break;
	}
    } else {
      for (k = 0; k < notu; k++)
	if (!testbit(arbre_b[j], k+1) && kill_tax[k] == 0) {
	  tax1 = k;
	  break;
	}
      for (k = tax1 + 1; k < notu; k++)
	if (!testbit(arbre_b[j], k+1) && kill_tax[k] == 0) {
	  tax2 = k;
	  break;
	}
    }

    p1 = bottomnode(arbre_s[tax1]);
    p2 = bottomnode(arbre_s[tax2]);

    if (lgbp) arg6=lgbi[j]; else arg6=0.;
    if (bootval) arg9=bootval[j]; else arg9=-1;
    arbre_s[notu + (++cpt1)] = create_node(p1, p2, NULL, p1->l3,
          p2->l3, arg6, p1->b3, p2->b3, arg9, NULL);

    p1->v3 = arbre_s[notu + cpt1];
    p2->v3 = arbre_s[notu + cpt1];

    kill_tax[tax1] = kill_bi[j] = 1;
    notuv--;
  }


	/* last node */


  for (i = 0; i < 2 * notu - 3; i++) 
    if (arbre_s[i]->v3 == NULL) {
      n1 = i;
      break;
    }

  for (i = n1 + 1; i < 2 * notu - 3; i++) 
    if (arbre_s[i]->v3 == NULL) {
      n2 = i;
      break;
    }
  
  for (i = n2 + 1; i < 2 * notu - 3; i++) 
    if (arbre_s[i]->v3 == NULL) {
      n3 = i;
      break;
    }
  

  arbre_s[2 * notu - 3] = create_node(arbre_s[n1],
                          arbre_s[n2], arbre_s[n3], arbre_s[n1]->l3,
                          arbre_s[n2]->l3, arbre_s[n3]->l3, arbre_s[n1]->b3,
                          arbre_s[n2]->b3, arbre_s[n3]->b3, NULL);
  arbre_s[n1]->v3 = arbre_s[2 * notu - 3];
  arbre_s[n2]->v3 = arbre_s[2 * notu - 3];
  arbre_s[n3]->v3 = arbre_s[2 * notu - 3];
  
  free(kill_tax); free(kill_bi);
  return 0;
}



/* equallist */
/* Check the list of taxa down a branch. */

Boolean equallist(noeud from, noeud nd, int nb, char** list){
  noeud n1, n2;
  int i, flag;
  

  if(from==nd->v1) { n1=nd->v2; n2=nd->v3; }
  else if(from==nd->v2) { n1=nd->v1; n2=nd->v3; }
  else if(from==nd->v3) { n1=nd->v1; n2=nd->v2; }
  else { (void) printf("Erreur\n"); }

  if(!n1){
    for(i=0;i<nb;i++){
      flag=0; 
      if(samename(nd->nom, list[i])) {flag=1; break; }
    }
    return flag;
  }
  
  return(equallist(nd, n1, nb, list) && equallist(nd, n2, nb, list));
}



/* ctreewrite */
/* Write string describing the s_tree underlying to noeud node at address ctree. */

char* ctreewrite(noeud comesfrom, noeud node, char* ctree){
  noeud vd, vg;
  double l, b;

  if(comesfrom==node->v1) { vg=node->v2; vd=node->v3; l=node->l1; b=node->b1; }
  else if(comesfrom==node->v2) { vg=node->v1; vd=node->v3; l=node->l2; b=node->b2; }
  else { vg=node->v1; vd=node->v2; l=node->l3; b=node->b3; }

  if (vg==NULL){
    (void) sprintf(ctree,"%s", node->nom);
    while(*ctree) ctree++;
    if (l>-0.5) (void) sprintf(ctree,":%.4f",l);
    while(*ctree) ctree++;
    return ctree;
  }
  else{
    *(ctree++)='(';
    ctree=ctreewrite(node, vg, ctree);
  }
  (void) sprintf(ctree,", ");
  ctree+=2;
  ctree=ctreewrite(node, vd, ctree);
  *(ctree++)=')';
  if (b>-0.1 && !(comesfrom==root[curtreew] && 
     node==root[curtreew]->v1)) (void) sprintf(ctree,"%d",(int)(b+0.5));
  while(*ctree) ctree++;
  if (l>-0.9) (void) sprintf(ctree,":%.4f", l);
  while(*ctree) ctree++;
  return ctree;
}



/* tree_stoc */
/* StructTOChaine. Write string describing s_tree arbre_s at address ctree */
/* racine = unrooted/rooted (0/other) , notu = number of leaves. */

void tree_stoc(noeud* arbre_s, int racine, int notu, char* ctree){
  char* tring, *prov;

  tring=(char*)check_alloc(50*notu,sizeof(char));

  if (racine) {
    tring=ctreewrite(NULL, root[curtreew], ctree);
    prov=ctree+(int)strlen(ctree)-1;
    while(*prov!=')') *(prov--)='\0';
    (void) strcat(ctree,";");
  }
  else{
    tring=ctreewrite(arbre_s[2*notu-3]->v3, arbre_s[2*notu-3], ctree);
    prov=ctree+(int)strlen(ctree)-1;
    while(*prov!=')') *(prov--)='\0';
    *(prov++)=',';
    *(prov++)=' ';
    tring=ctreewrite(arbre_s[2*notu-3], arbre_s[2*notu-3]->v3, prov);
    (void) strcat(ctree,");");
  }
}


int retder(int *liste){
  int i=0, j;
  while (liste[i] != 0) i++;
  j = *(liste + i - 1);
  *(liste + i - 1) = 0;
  return j;
}

void aj(int *liste, int nb) {
  int  i=0;
  while (liste[i] != 0) i++;
  *(liste + i) = nb;
  return;
}


/* tree_ctot */
/* ChaineTOTable. Read c_tree input (string) and write t_tree arbre (int**), */
/* branch length lgbi (internal) and lgbp (terminal), bootstrap values, */
/* species names (nom) and rooted/unrooted (racine-> r (rooted) or n (not)). */

int tree_ctot(char *input, int **arbre, double *lgbi, double *lgbp,
    double* bootstrap, char **nom, char *racine){


  int   i=0, j, k, fin=0, nbpo=0,
	nbpf = 0, cptv1 = 0, nbotu, br_ouverte, *listecour,
	otu = -1, pomoinspf, cpttree=0, t=1;
  char  c, cc, cas, dejalu = '\0';
  double  f;


  (void) sscanf(input+(cpttree++), "%c", &c);
  if (c == '[') {
    while ((c != ']') && c) (void) sscanf(input+(cpttree++), "%c", &c);
    if (c != ']'){
      (void) printf("Unmatched '[' ']'\n");
      return -1;
    }
  } 
  else
    if (c == '(') cpttree=0;
    else{
      (void) printf("Tree 1st character must be '(' or '['\n");
      return -1;
    }
  while ((c != ';') && c) {
    (void) sscanf(input+(cpttree++), "%c", &c);
    if (c == '(') nbpo++;
    if (c == ')') nbpf++;
    if ((nbpo == nbpf + 1) && (c == ',')) cptv1++;
  }
  if (c != ';'){
    (void) printf("';' missing at end of tree\n");
    return -1;
  }

  if (nbpo != nbpf){
    (void) printf("Unmatched parenthesis\n");
    return -1;
  }

  if (cptv1 == 1) cas = 'c';
  if (cptv1 == 2) cas = 'a';

  if ((cptv1!=1) && (cptv1!=2)){
    (void) printf("Bad number of ',' in tree\n");
    return -1;
  }

  nbotu = nbpo + 2;
  if(racine)
    if (cas == 'a') *racine='n'; else *racine='r';


  if(arbre==NULL && lgbi==NULL && lgbp==NULL && bootstrap==NULL && nom==NULL) goto end;

  if (cas=='c'){
    if (lgbp) lgbp[0] = 0.;
    if (nom) (void) sprintf(nom[0],"ROOT");
    if (arbre) for(i=0;i<nbotu-3;i++) arbre[0][i]=0;
    otu++;
  }

  listecour=(int*) check_alloc(nbotu, sizeof(int));


  cpttree=0;
  (void) sscanf(input+(cpttree++), "%c", &c);
  if (c == '['){
    while (c != ']') (void) sscanf(input+(cpttree++), "%c", &c);
    while((c==']') || (c==' ') || (c=='\n') || (c=='\t')) (void) sscanf(input+(cpttree++), "%c", &c);
    if (c!='(') return -1;
  }
  else
    while(c!='(') (void) sscanf(input+(cpttree++), "%c", &c);

  pomoinspf=1;
  for (i = 0; i < nbotu; i++) listecour[i] = 0;
  br_ouverte = 0;

  for (k = 0; t==1; k++) {
    if (dejalu == '\0') (void) sscanf(input+(cpttree++), "%c", &c);
    else {
      c = dejalu;
      dejalu = '\0';
    }

    switch (c) {
    case ';': fin = 1; break;
    case ',': case '\n': case '\t': case '\'': case ' ': break;
    case '(':
      pomoinspf ++;
      br_ouverte++;
      aj(listecour, br_ouverte); break;
    case ')':
      pomoinspf--;
      (void) sscanf(input+(cpttree++), "%c", &cc);
      if (cc == ';' || pomoinspf==0) {
	fin = 1; break;
      }
      j = retder(listecour);
      while (cc=='\n' || cc==' ' || cc=='\t') 
             (void) sscanf(input+(cpttree++),"%c",&cc);
      if (strpbrk(input+cpttree-1, "0123456789.")==input+cpttree-1){
        if(bootstrap) (void) sscanf(input+cpttree-1, "%le", bootstrap+j-1);
        cpttree+=strspn(input+cpttree-1,".0123456789");
        cc=*(input+cpttree-1);
        while (cc=='\n' || cc==' ' || cc=='\t') 
            (void) sscanf(input+(cpttree++),"%c",&cc);
      }
      if (cc == ':') {
	while(input[cpttree]==' ') cpttree++;
	(void) sscanf(input+cpttree, "%le", &f);
	cpttree+=strspn(input+cpttree,"-0123456789.");
	if(lgbi) lgbi[j - 1] = f;
      }
      else dejalu=cc;
      break;
    default:
      otu++; cc = c; i = 0;
      while ((cc != ':') && (cc != ',') && (cc != ')') && (cc != '\n') && (cc != ' ')) {
	if (nom && cc != '\'') { nom[otu][i++] = cc; nom[otu][i]='\0'; }
	(void) sscanf(input+(cpttree++), "%c", &cc);
      }
      while(input[cpttree-1]==' ') cpttree++;
      cc=input[cpttree-1];
      if (cc == ':') {
	while(input[cpttree]==' ') cpttree++; 
	(void) sscanf(input+(cpttree), "%le", &f);
	cpttree+=strspn(input+cpttree,"-0123456789.e");
	if(lgbp)lgbp[otu] = f;
      } 
      else dejalu = cc;
      for (i = 0; i < nbotu - 3; i++) if (arbre) arbre[otu][i] = 0;
      for (i = 0; i < nbotu; i++)
	if (arbre && (listecour[i]!=0))
	  arbre[otu][listecour[i] - 1] = 1;
    }
    if (fin == 1) break;
  }

  free(listecour);
  end:
  if (cas=='a') return nbotu;
  return (nbotu-1);
}



/* tree_tton */
/* TableTONumbers. Read t_tree tarbre and write n_tree ntree. */

void tree_tton(int** tarbre, int notu, double* ntree){
  int min, i, j;
  min=mini(50, notu);
  for(i=0;i<notu-3;i++){
    ntree[2*i]=ntree[2*i+1]=0.;
    for(j=0;j<min;j++)
      if (tarbre[j][i]!=tarbre[0][i]) ntree[2*i]+=pow(2., (double)(min-j-1));
    if (notu>50){
      for(j=50;j<notu;j++)
        if (tarbre[j][i]!=tarbre[0][i]) ntree[2*i+1]+=pow(2., (double)(notu-j-1));
    }
  }
}



/* tree_ctob */
/* ChaineTOBits. Read c_tree carbre and write b_tree barbre. */

int tree_ctob(char *carbre, char *nom[], int *barbre[]){


  int   i=0, j, k, fin=0, nbpo=0,
	nbpf = 0, cptv1 = 0, nbotu, br_ouverte, *listecour, 
	otu = -1, pomoinspf, cpttree=0, t=1;
  char  c, cc, dejalu = '\0', readname[30];


  (void) sscanf(carbre+(cpttree++), "%c", &c);
  if (c == '[') {
    while ((c != ']') && c) (void) sscanf(carbre+(cpttree++), "%c", &c);
    if (c != ']'){
      (void) printf("Unmatched '[' ']'\n");
      return -1;
    }
  } 
  else
    if (c == '(') cpttree=0;
    else{
      (void) printf("Tree file 1st character must be '(' or '['\n");
      return -1;
    }
  while ((c != ';') && c ) {
    (void) sscanf(carbre+(cpttree++), "%c", &c);
    if (c == '(') nbpo++;
    if (c == ')') nbpf++;
    if ((nbpo == nbpf + 1) && (c == ',')) cptv1++;
  }

  if (c != ';'){
    (void) printf("';' missing at end of tree\n");
    return -1;
  }

  if (nbpo != nbpf){
    (void) printf("Unmatched parenthesis\n");
    return -1;
  }

  if (cptv1 == 2) /* unrooted : ok */;
  else 
    if (cptv1 == 1){ /* rooted : problem */ 
      (void) printf("Unexpected rooted tree.\n"); 
      return -1; 
    }
    else{ /* bad tree string */
      (void) printf("Bad number of ',' in tree\n");
      return -1;
    }

  nbotu=nbpo+2;


  listecour=(int*) check_alloc(nbotu, sizeof(int));

  cpttree=0;
  (void) sscanf(carbre+(cpttree++), "%c", &c);
  if (c == '['){
    while (c != ']') (void) sscanf(carbre+(cpttree++), "%c", &c);
    while((c==']') || (c==' ') || (c=='\n') || (c=='\t')) 
        (void) sscanf(carbre+(cpttree++), "%c", &c);
    if (c!='(') return -1;
  }
  else
    while(c!='(') (void) sscanf(carbre+(cpttree++), "%c", &c);

  pomoinspf=1;
  for (i = 0; i < nbotu; i++) listecour[i] = 0;
  br_ouverte = 0;


  for (k = 0; t==1; k++) {
    if (dejalu == '\0') (void) sscanf(carbre+(cpttree++), "%c", &c);
    else {
      c = dejalu;
      dejalu = '\0';
    }
    switch (c) {
    case ';': fin = 1; break;
    case ',': case '\n': case '\t': case '\'': case ' ': break;
    case '(':
      pomoinspf ++;
      br_ouverte++;
      aj(listecour, br_ouverte); break;
    case ')':
      pomoinspf--;
      if (*(carbre+cpttree+1) == ';' || pomoinspf==0) {
	fin = 1; break;
      }
      j = retder(listecour);
      while(carbre[cpttree]!=',' && carbre[cpttree]!=')') cpttree++;
      break;
    default:
      otu=-1; cc = c; i = 0;
      while ((cc != ':') && (cc != ',') && (cc != ')') &&
             (cc != '\n') && (cc != ' ')) {
	if (cc != '\'') { readname[i++] = cc; readname[i]='\0'; }
	(void) sscanf(carbre+(cpttree++), "%c", &cc);
      }
      for(j=0;j<nbotu;j++) if(samename(readname, nom[j])) { otu=j; break; }
      if (otu==-1) {(void) printf("Unknown name : %s\n", readname); return -1; }
      for(i=0;i<nbotu-3;i++) bit0(barbre[i], otu+1);
      for (i = 0; i < nbotu-3; i++)
	if (listecour[i] != 0)
	  bit1(barbre[listecour[i]-1], otu+1);
      cpttree--;
      while(carbre[cpttree]!=',' && carbre[cpttree]!=')') cpttree++; 
    }
    if (fin == 1) break;
  }

  free(listecour);
  return nbotu; 
}


/* ctree_nobl */
/* Copy c_tree in into c_tree out without branch length. */

void ctree_nobl(char* in, char* out, int lgin){
  int i=-1, ii=0;
  char c;
  while(i++<lgin){
    c=in[i];
    if (c!=':') out[ii++]=c;
    if (c==':') i+=strspn(in+i+1,"0123456789.-e \n\t");
    if (in[i]==';') break;
  }
}



/* ctree_noblbs */
/* Copy c_tree in into c_tree out without branch length. */

void ctree_noblbs(char* in, char* out, int lgin){
  int i=-1, ii=0;
  char c;
  while(i++<lgin){
    c=in[i];
    if (c!=':') out[ii++]=c;
    if (c==')' || c==':') i+=strspn(in+i+1,"0123456789.-e \n\t");
    if (in[i]==';') break;
  }
}



/* ctree_root */
/* Arbitrarily root c_tree ctree. */

void ctree_root(char* ctree){
  int i=0, place, diffp=0, drapeau=0;
  while(ctree[i]){
    if (ctree[i]=='(') { diffp++; }
    if (ctree[i]==')') { diffp--; }
    if (diffp==1 && ctree[i]==',') drapeau++;
    if (drapeau==2) { place=i; break; }
    i++;
  }
  for(i=(int)strlen(ctree);i>=place;i--)
    ctree[i+2]=ctree[i];
  ctree[place+1]=')';
  for(i=place-1;i>=0;i--)
    ctree[i+1]=ctree[i];
}



/* addquotes */
/* Add quotes (' ') to species names in c_tree pointed by ctree_ptr. */
/* Necessary for fastDNAml interfacing. */

void addquotes(char** ctree_ptr){

  char *local, *debut, *ctree;

  ctree=*ctree_ptr;
  local=(char*)check_alloc(50*nbseq, sizeof(char));
  debut=local;
  
  while(TRUE){
    switch(*ctree){
      case ' ': case '\n': case '\t': case ',': case ':': case '(': case ')':
      case '0': case '1': case '2': case '3': case '4': case '5': case '6': 
      case '7': case '8': case '9': case '.': case '-': 
        *local++=*ctree++; break;
      case ';': *local++=';'; *local=0; free(*ctree_ptr); *ctree_ptr=debut; return;
      default : 
        *local++='\'';
	while(*ctree!=':' && *ctree!=')' && *ctree!=',')
	  *local++=*ctree++;
        *local++='\'';
    }
  }
}



/* ctre_changename */

int ctree_changename(char* ctree, char* oldname, char* newname){

  int i, L, l1, l2, diff;
  char* place, *endbracket;

  endbracket=strchr(ctree, ']');
  if(endbracket==NULL) endbracket=ctree;
  place=strstr(endbracket, oldname);
  if(place==NULL) return 0;
  l1=(int)strlen(oldname); l2=(int)strlen(newname);
  diff=l2-l1;
  if(diff<=0){
    for(i=0;i<l2;i++) place[i]=newname[i];
    while(place[i-1]!='\0'){
      place[i]=place[i-diff];
      i++;
    }
  }
  else{
    L=(int)strlen(ctree);
    for(i=L; ctree+i!=place-1; i--)
      ctree[i+diff]=ctree[i];
    for(i=0;i<l2;i++) place[i]=newname[i];
  }
  return 1;

}



/* ttree_egal */
/* Return 1 if t_tree tree1 has the same topology than tree2, */
/* 0 otherwise. */

int ttree_egal(int** tree1, int** tree2, int notu, char* nature){
  int i, j1, j2, drapeau, id, somme1=0, somme2=0, *tree1nr[MAXNSP], *tree2nr[MAXNSP], diff;


  for(i=0;i<notu;i++){
    tree1nr[i]=(int*)check_alloc(notu-3,sizeof(int));
    tree2nr[i]=(int*)check_alloc(notu-3,sizeof(int));
  }

	/* DERACINAGE EVENTUEL */


  if (nature[0]=='r' || nature[0]=='R'){
    if(unroot(tree1, notu, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)!=0){
      (void) printf("Erreur.\n");
      exit(0);
    }
  }


  if (nature[1]=='r' || nature[1]=='R'){
    if(unroot(tree2, notu, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)!=0){
      (void) printf("Erreur.\n");
      exit(0);
    }	
  }			

	
	/* COMPARAISON DES TOPOLOGIES NON-RACINEES */
	
  for(j1=0;j1<notu-3;j1++){
    somme1=0;
    for(i=0;i<notu;i++) somme1+= tree1[i][j1];
    id=0;
    for(j2=0;j2<notu-3;j2++){
      somme2=0;
      for(i=0;i<notu;i++) somme2+=tree2[i][j2];
      if (somme1==somme2 || somme1==notu-somme2){
	diff=abs(tree1[0][j1]-tree2[0][j2]);
	drapeau=0;
	for(i=1;i<notu;i++)
	  if(abs(tree1[i][j1]-tree2[i][j2])!=diff) drapeau=1;
	if (drapeau==0) id=1;
      }
    }
    if (id==0) return 0;
  }

  for(i=0;i<notu;i++){
    free(tree1nr[i]);
    free(tree2nr[i]);
  }
  return 1;
}



/* rooted */
/* Return 1 if c_tree carbre is rooted, 0 if unrooted, -1 if problem */

int rooted(char* carbre){
  int i=0, cpt=0, cptv=0;

  while((carbre[i]==' ' || carbre[i]=='\n' || carbre[i]=='\t') && carbre[i]) i++;
  if(carbre[i]!='[' && carbre[i]!='(') {
    (void) printf("Tree first char must be ( or [\n"); 
    return -1; 
  }

  if(carbre[i]=='[') while(carbre[i]!=']' && carbre[i]) i++;
  if(!carbre[i]){ (void) printf("Unmatched '[' ']'\n"); return -1; }
  while(carbre[i]!='(' && carbre[i]) i++;
  if(!carbre[i]) {(void) printf("No initial parenthesis\n"); return -1; }

  while(carbre[i]!=';' && carbre[i]){
    if (carbre[i]=='(') cpt++;
    if (carbre[i]==')') cpt--;
    if (carbre[i]==',' && cpt==1) cptv++;
    i++;
  }
 
  if (cptv==2) return 0;
  if (cptv==1) return 1;
  return -1;
}
  


/* unroot_c */
/* Remove root from rooted c_tree carbre. */

int unroot_c(char* carbre){
  int i=0, diff, deb;
  
  while((carbre[i]==' ' || carbre[i]=='\n' || carbre[i]=='\t') && carbre[i]) i++;
  if(carbre[i]!='[' && carbre[i]!='(') {
    (void) printf("Tree first char must be ( or [\n"); 
    return -1; 
  }

  if(carbre[i]=='[') while(carbre[i]!=']' && carbre[i]) i++;
  if(!carbre[i]){ (void) printf("Unmatched '[' ']'\n"); return -1; }
  while(carbre[i]!='(' && carbre[i]) i++;
  if(!carbre[i]) {(void) printf("No initial parenthesis\n"); return -1; }
 
  i++;
  while(carbre[i]!='(' && carbre[i] && carbre[i]!=';') i++;
  if(!carbre[i] || carbre[i]==';') return 0;
  carbre[i]=' ';
  diff=0; 
  while(diff!=-1 && carbre[i] && carbre[i]!=';'){
    if(carbre[i]=='(')  diff++; 
    if(carbre[i]==')')  diff--; 
    i++;
  }

  if(!carbre[i] || carbre[i]==';') return 0;
  carbre[i-1]=' ';
  while(carbre[i]!=',' && carbre[i]!=')') {
    carbre[i]=' ';
    i++;
  }

  return 1;
}  
  



/* ctree_egal */
/* Return 1 if c_tree ctree1 has the same topology than ctree2, */
/* 0 otherwise. */ 

int ctree_egal(char* ctree1, char* ctree2, int nb){
  int* ttree1[MAXNSP], *ttree2prov[MAXNSP], *ttree2[MAXNSP], i, j, retour;
  char chaine[2], *nom1[MAXNSP], *nom2[MAXNSP];

  for(i=0;i<=nb;i++){
    ttree1[i]=(int*)check_alloc(nb-2, sizeof(int));
    ttree2prov[i]=(int*)check_alloc(nb-2, sizeof(int));
    nom1[i]=(char*)check_alloc(MAXLNAME+1, sizeof(char));
    nom2[i]=(char*)check_alloc(MAXLNAME+1, sizeof(char));
  }
  
  (void) tree_ctot(ctree1, ttree1, NULL, NULL, NULL, nom1, chaine);
  (void) tree_ctot(ctree2, ttree2prov, NULL, NULL, NULL, nom2, chaine+1);

  for(i=0;i<=nb;i++){
    for(j=0;j<=nb;j++){
      if(samename(nom2[i],nom1[j])){
	ttree2[j]=ttree2prov[i];
	break;
      } 
    }
  }
  
  retour=ttree_egal(ttree1, ttree2, nb, chaine);
  for(i=0;i<nb;i++){
    free(ttree1[i]); free(ttree2[i]);
    free(nom1[i]); free(nom2[i]);
  }
  return(retour);
}



/* addexaequo */

/* Add to list old those c_trees from list toadd not currently */
/* in list old. Return the number of added trees. */

int addexaequo(char* old, char* toadd, int nb){
  char** oldtrees, **toaddtrees, *prov, *copy1, *copy2;
  int i=-1, j,  l1, l2, nbold, nbtoadd, drapeau, nbadded=0;

  oldtrees=(char**)check_alloc(100, sizeof(char*));
  toaddtrees=(char**)check_alloc(100, sizeof(char*));
  l1=(int)strlen(old);
  copy1=(char*)check_alloc(l1+1, sizeof(char));

  l2=(int)strlen(toadd);
  copy2=(char*)check_alloc(l2+1, sizeof(char));

  (void) sprintf(copy1, "%s", old);
  prov=copy1;
  
/* original
  while(oldtrees[++i]=strtok(prov,"\n")
    prov=NULL;
*/
  oldtrees[++i]=strtok(prov,"\n");
  while(oldtrees[i])
    oldtrees[++i]=strtok(NULL,"\n");
  nbold=i;

  i=-1;
  (void) sprintf(copy2, "%s", toadd);
  prov=copy2;
/* original
  while(toaddtrees[++i]=strtok(prov,"\n"))
    prov=NULL;
*/
  toaddtrees[++i]=strtok(prov,"\n");
  while(toaddtrees[i])
    toaddtrees[++i]=strtok(NULL,"\n");
  nbtoadd=i;


  for(i=0;i<nbtoadd;i++){
    drapeau=0;
    for(j=0;j<nbold;j++)
      if(ctree_egal(toaddtrees[i], oldtrees[j], nb)){ drapeau=1; break; }
    if (!drapeau){
      (void) strcat(old, toaddtrees[i]);
      (void) strcat(old, "\n");
      nbadded++;
    }
  }
  
  free(oldtrees); free(toaddtrees); free(copy1); free(copy2);
  return nbadded;
}


/* nj */
/* Neighbor Joining method. (C version of Saitou's Fortran routine). */
/* Atypical tree format : clusters + branchl. */


int nj( double** d, int** clusters, double** branchl, int notu){

  double     sumd, fotu, dio, djo, bi, bj, diq, djq,
	     dij, d2r, dr, fotu2, total, da, tmin, dmin, lastbl;
  int        i, ii, j, jj, j1, cpt, mini, minj, nc, typei, typej, remain;


        /* First initialization */

  mini = minj = 0;
  fotu=(double)notu;
  for (i = 1; i <= notu; i++) {
    d[i][i] = 0.;
    kkill[i] = 0;
    av[i] = -101.;
  }

	/* Enter the main cycle */
	/* Last cycle used to compute 2 more branch lengths */


  for (nc = 1; nc <= notu - 2; nc++) {  
    sumd = 0.;
    for (j = 2; j <= notu; j++) {
      j1 = j - 1;
      for (i = 1; i <= j1; i++) {
	d[j][i] = d[i][j];
	sumd = sumd + d[i][j];
	s[i][j] = s[j][i] = 0.;
      }
    }

    tmin = 99999.0;

	/* Compute Sij's and select the smallest  */

    for (jj = 2; jj <= notu; jj++) {
      if (kkill[jj] != 1) {
	j1 = jj - 1;
	for (ii = 1; ii <= j1; ii++) {
	  if (kkill[ii] != 1) {
	    diq = djq = 0;
	    for (i = 1; i <= notu; i++) {
	      diq = diq + d[i][ii];
	      djq = djq + d[i][jj];
	    }
	    dij = d[ii][jj];
	    d2r = diq + djq - 2 * dij;
	    dr = sumd - dij - d2r;
	    fotu2 = fotu - 2.0;
	    total = d2r + fotu2 * dij + 2 * dr;
	    total = total / (2 * fotu2);
	    s[ii][jj] = total;
	    if (total < tmin) {
	      tmin = total;
	      mini = ii;
	      minj = jj;
	   }
	  }
	}
      }
    }


	/* Compute branch lengths */

    dio = djo = 0;
    for (i = 1; i <= notu; i++) {
      dio += d[i][mini];
      djo += d[i][minj];
    }
    dmin = d[mini][minj];
    dio = (dio - dmin) / fotu2;
    djo = (djo - dmin) / fotu2;
    bi = (dmin + dio - djo) * 0.5;
    bj = dmin - bi;
    if(av[mini]>-100.) bi -= av[mini];
    if(av[minj]>-100.) bj -= av[minj];
    if (av[mini] > -100.) typei=14; else typei=15;
    if (av[minj] > -100.) typej=14; else typej=15;

    clusters[1][nc] = mini;
    if (typei==14) clusters[1][nc] = -mini;
    clusters[2][nc] = minj;
    if (typej==14) clusters[2][nc] = -minj;

    branchl[1][nc]=bi;
    branchl[2][nc]=bj;

    av[mini] = dmin * 0.5;

    if(nc==notu-2) break;

	/* Re-initialization */

    fotu = fotu - 1;
    kkill[minj] = 1;
    for (j = 1; j <= notu; j++) {
      if (kkill[j] != 1) {
	da = (d[mini][j] + d[minj][j]) * 0.5;
	if (mini - j > 0) d[j][mini] = da;
	if (mini - j < 0) d[mini][j] = da;
      }
    }
    for (j = 1; j <= notu; j++) d[minj][j] = d[j][minj] = 0.;
  }

	/* last branch length */

  cpt=0;
  for(i=1;i<=notu;i++){
    if(kkill[i]==0 && i!=mini && i!=minj){
      cpt++;
      remain=i;
    }
  }
  if (cpt!=1) { 
/*    (void) printf("nj, last branch ; erreur : %d\n",cpt); 
    for(i=1;i<=notu-1;i++){
      for(j=i+1;j<=notu;j++) (void) printf("%.4f  ", d[i][j]);
      (void) printf("\n");
    }*/
    return -1; 
  }
  lastbl=(d[remain][mini]+d[remain][minj]-d[mini][minj])/2;
  if(av[remain]>-100.) lastbl-=av[remain]; 
  branchl[1][nc+1]=lastbl;


  return 0;
}




/* nj_in_out */
/* Prepare distance data for the nj algorithm, call function nj */
/* and write ctree (if !=NULL) and ntree (if !=NULL) */

int nj_in_out(double** d, char** nomotu, int notu, char* ctree, double* ntree){

  int             i, j, k, l, a, b, cpt=0, min;
  noeud * arbre_s;
	

  for (i = 0; i <= notu - 1; i++) {
    k = notu - 1 - i;
    for (j = 0; j <= notu - 1; j++) {
      l = notu - 1 - j;
      d[k + 1][l + 1] = d[k][l];
    }
  }
  for(i=0;i<=notu;i++) d[i][i]=0.;
  for(i=0;i<notu;i++) lgbp_nj[i]=-2.;
  for(i=0;i<notu-3;i++) lgbi_nj[i]=-2.;


  for(i=0;i<notu;i++){
    arbre[i]=(int*)check_alloc(notu, sizeof(int));
    arbreprov[i]=(int*)check_alloc(notu, sizeof(int));
  }

  for(i=0;i<notu;i++){
    for(j=0;j<notu;j++){
      arbre[i][j]=0;
      arbreprov[i][j]=0;
    }
  }


  if (nj(d, clusters, branchl, notu)==-1) {
	return 0;
  }

	/*  clusters --> t_tree */
 

  for(i=0;i<notu-2;i++){
    a=clusters[1][i+1]; b=clusters[2][i+1];
    if(a>0){
      arbreprov[i][a-1]++;
      lgbp_nj[a-1]=branchl[1][i+1];
    }
    else{
      for(j=0;j<notu;j++) arbreprov[i][j]+=brmem[abs(a)][j];
      for(j=0;j<notu-3;j++) if (brmem[abs(a)]==arbreprov[j]) lgbi_nj[j]=branchl[1][i+1];
    }
    if(b>0){
      arbreprov[i][b-1]++;
      lgbp_nj[b-1]=branchl[2][i+1];
    }
    else{
      for(j=0;j<notu;j++) arbreprov[i][j]+=brmem[abs(b)][j];
      for(j=0;j<notu-3;j++) if (brmem[abs(b)]==arbreprov[j]) lgbi_nj[j]=branchl[2][i+1];
    }
    brmem[abs(a)]=arbreprov[i];
  }

  if (ntree){
    min=mini(50, notu);
    for(i=0;i<notu-3;i++){
      ntree[2*i]=ntree[2*i+1]=0.;
      for(j=0;j<min;j++)
        if (arbreprov[i][j]!=arbreprov[i][0]) ntree[2*i]+=pow(2., (double)(min-j-1));
      if (notu>50){
	for(j=50;j<notu;j++)
          if (arbreprov[i][j]!=arbreprov[i][0]) ntree[2*i+1]+=pow(2., (double)(notu-j-1));
      }
    }
  }


  if (ctree){   	
  
    for(i=0;i<notu;i++) if(lgbp_nj[i]<-1.) { lgbp_nj[i]=branchl[1][notu-1]; cpt++; }
    for(i=0;i<notu-3;i++) if(lgbi_nj[i]<-1.) { lgbi_nj[i]=branchl[1][notu-1]; cpt++; }

    if (cpt!=1) {
       return(0);
    }

    for(i=0;i<notu;i++){
      for(j=0;j<notu;j++){
        arbre[i][j]=arbreprov[j][i];
      }
    }
    arbre_s = (noeud *)check_alloc(2*notu+1, sizeof(noeud));
    i=tree_ttos(arbre, notu, lgbi_nj, lgbp_nj, NULL, nomotu, arbre_s);

    tree_stoc(arbre_s, 0, notu, ctree);
    for(i=0;i<2*notu-3;i++)
      free(arbre_s[i]);
    free(arbre_s);
  }

  for(i=0;i<notu;i++) { free(arbre[i]); free(arbreprov[i]); } 
  return 1;
}


	/** DISTANCE  COMPUTING  FUNCTIONS **/


/* od */
/* Observed divergence */

double od(char* seq1, char* seq2){
  double p=0.;
  int i=0, lgvraie=0;

  while(seq1[i] && seq2[i]){
    if(seq1[i]!='-' && seq2[i]!='-'){
      lgvraie++;
      if(seq1[i]!=seq2[i]) p++;
    }
    i++;
  }
  if(lgvraie==0) return -1.;
  return(p/lgvraie);
}
  

/* jc */
/* Jukes & Cantor distance */

double jc(char* seq1, char* seq2){
  double p=0., k;
  int i=0, lgvraie=0;

  while(seq1[i] && seq2[i]){
    if(seq1[i]!='-' && seq2[i]!='-'){
      lgvraie++;
      if(seq1[i]!=seq2[i]) p++;
    }
    i++;
  }
  if(lgvraie==0) return -1.;
  p/=lgvraie;
  if (1-4*p/3<=0) return -1.;
  k=log(1-4*p/3)*(-0.75);

  return k;
 
}
  

/* kim2p */
/* Kimura 2-parameter distance */

double kim2p(char* seq1, char* seq2){
  double p=0., q=0., k;
  int i=0, lgvraie=0;

  while(seq1[i] && seq2[i]){
    if(seq1[i]!='-' && seq2[i]!='-'){
      lgvraie++;
      if (seq1[i]!=seq2[i]){
        if ( ((seq1[i]=='A') && (seq2[i]=='G')) || 
             ((seq1[i]=='G') && (seq2[i]=='A')) || 
             ((seq1[i]=='C') && (seq2[i]=='T')) || 
             ((seq1[i]=='T') && (seq2[i]=='C')) ) p++;
        else q++;
      }
    }
    i++;
  }

  if(lgvraie==0) return -1.;

  p/=lgvraie;
  q/=lgvraie;

  if ((1-2*q<=0.) || (1-2*p-q<=0.)) return -1.;
	
  k=(double)log((1-2*p-q)*sqrt(1-2*q))*-0.5;

  return k;
}
  


/* tn */
/* Tajima & Nei distance */


double tn(char* seq1, char* seq2){
  double pi, b, freq[16], h, q[4], x[4][4];
  int i, j;

  if(!freq_obs(seq1, seq2, freq)) return -1.;
  x[0][1]=freq[1]+freq[4];
  x[0][2]=freq[2]+freq[8];
  x[0][3]=freq[3]+freq[12];
  x[1][2]=freq[6]+freq[9];
  x[1][3]=freq[7]+freq[13];
  x[2][3]=freq[11]+freq[14];
  q[0]=freq[0]+(x[0][1]+x[0][2]+x[0][3])/2;
  q[1]=freq[5]+(x[0][1]+x[1][2]+x[1][3])/2;
  q[2]=freq[10]+(x[0][2]+x[1][2]+x[2][3])/2;
  q[3]=freq[15]+(x[0][3]+x[1][3]+x[2][3])/2;
  pi=1-freq[0]-freq[5]-freq[10]-freq[15];
  h=0.;
  for(i=0;i<3;i++)
    for(j=i+1;j<4;j++)
      h+=(x[i][j]*x[i][j]*0.5/(q[i]*q[j]));
  if (h==0.) { return -0.; }
  b=0.5*(1-q[0]*q[0]-q[1]*q[1]-q[2]*q[2]-q[3]*q[3]+pi*pi/h);
  if(pi/b>1 || b==0.) return -1.;
  return(-1.*b*log(1-pi/b));
}



/* hky */
/* Distance for Hasegawa, Kishino and Yano model */

double hky(char* seq1, char* seq2){
  int lg;
  double d, freq[16], a, c, g, t, r, y, P, P1, P2, Q;
  double A1, A2, A3, alpha, beta, gamma, cc, ee;
  double va1, va2, cova1a2, cova1a3, cova2a3;
  double delta, epsilon, ksi, eta, nu, ff;
  double larg1, larg2, larg3;

  lg=(int)strlen(seq1);

  (void) freq_obs(seq1, seq2, freq);

  P1=freq[2]+freq[8]; 
  P2=freq[7]+freq[13];
  P=P1+P2;
  Q=freq[1]+freq[3]+freq[4]+freq[6]+freq[9]+freq[11]+freq[12]+freq[14];

  a=freq[0]+(freq[1]+freq[2]+freq[3]+freq[4]+freq[8]+freq[12])/2; 
  c=freq[5]+(freq[1]+freq[4]+freq[6]+freq[7]+freq[9]+freq[13])/2; 
  g=freq[10]+(freq[2]+freq[6]+freq[8]+freq[9]+freq[11]+freq[14])/2;
  t=1.-a-c-g;
  r=a+g; 
  y=c+t;
  
  larg1=1-Q/(2*r*y);
  larg2=1-Q/(2*r)-(r*P1)/(2*a*g);
  larg3=1-Q/(2*y)-(y*P2)/(2*c*t);

  if(larg1<=0. || larg2<=0. || larg3<=0.)
    return -1.;

  A1=(y/r)*log(larg1)-log(larg2)/r;
  A2=(r/y)*log(larg1)-log(larg3)/y;
  A3=-log(larg1);

  cc=1-Q/(2*r*y);
  ee=1-(r*P1)/(2*a*g)-Q/(2*r);
  ff=1-(y*P2)/(2*c*t)-Q/(2*y);

  delta=1/(2*ee*r*r)-1/(2*cc*r*r);
  epsilon=1/(2*ee*a*g);
  ksi=1/(2*y*y*ff)-1/(2*y*y*cc);
  eta=1/(2*c*t*ff);
  nu=1/(2*r*y*cc);
  
  va1=((delta*delta*Q+epsilon*epsilon*P1)-(delta*Q+epsilon*P1)*(delta*Q+epsilon*P1))/lg;
  va2=((ksi  *ksi  *Q+eta    *eta    *P2)-(ksi  *Q+eta    *P2)*(ksi  *Q+eta    *P2))/lg;
  cova1a2=(delta*ksi*Q*(1-Q)-delta*eta*Q*P2-epsilon*eta*P1*P2)/lg;
  cova1a3=nu*Q*(delta*(1-Q)-epsilon*P1)/lg;
  cova2a3=nu*Q*(ksi  *(1-Q)-eta    *P2)/lg;

  gamma=(va2-cova1a2)/(va1+va2-2*cova1a2) + 
     ((r*y)/(a*g+c*t)) * ((cova1a3-cova2a3)/(va1+va2-2*cova1a2));

  d=2*(a*g+c*t)*(gamma*A1+(1-gamma)*A2)+2*r*y*A3;

  return(d);
}
  




/* lQ */
/* Corrected transversions distance */

double lQ(char* seq1, char* seq2){

  double freq[16], Q;

  if(!freq_obs(seq1, seq2, freq)) return -1.;
  Q=freq[1]+freq[3]+freq[4]+freq[6]+freq[9]+freq[11]+freq[12]+freq[14];
  if(2*Q>1.) return -1.;
  return (-0.5*log(1.-2.*Q));
}



/* lQ_ry */
/* Corrected transversions distance when sequences are made of R and Y. */

double lQ_ry(char* seq1, char* seq2){
  double p=0., k;
  int i=0, lgvraie=0;

  while(seq1[i] && seq2[i]){
    if(seq1[i]!='-' && seq2[i]!='-'){
      lgvraie++;
      if(seq1[i]!=seq2[i]) p++;
    }
    i++;
  }
  if(lgvraie==0) return -1.;
  p/=lgvraie;
  if (1-2*p<=0) return -1.;
  k=log(1-2*p)*(-0.5);

  return k;
}



/* logdet */
/* logdet distance */

double logdet(char* seq1, char* seq2, double** matxy){

  double freq[16], d, a1, c1, g1, t1, a2, c2, g2, t2;

  if(!freq_obs(seq1, seq2, freq)) return -1.;

  matxy[0][0]=freq[0]; matxy[0][1]=freq[1]; matxy[0][2]=freq[2]; matxy[0][3]=freq[3];
  matxy[1][0]=freq[4]; matxy[1][1]=freq[5]; matxy[1][2]=freq[6]; matxy[1][3]=freq[7];
  matxy[2][0]=freq[8]; matxy[2][1]=freq[9]; matxy[2][2]=freq[10]; matxy[2][3]=freq[11];
  matxy[3][0]=freq[12]; matxy[3][1]=freq[13]; matxy[3][2]=freq[14]; matxy[3][3]=freq[15];

  a1=matxy[0][0]+matxy[0][1]+matxy[0][2]+matxy[0][3];
  c1=matxy[1][0]+matxy[1][1]+matxy[1][2]+matxy[1][3];
  g1=matxy[2][0]+matxy[2][1]+matxy[2][2]+matxy[2][3];
  t1=matxy[3][0]+matxy[3][1]+matxy[3][2]+matxy[3][3];
  a2=matxy[0][0]+matxy[1][0]+matxy[2][0]+matxy[3][0];
  c2=matxy[0][1]+matxy[1][1]+matxy[2][1]+matxy[3][1];
  g2=matxy[0][2]+matxy[1][2]+matxy[2][2]+matxy[3][2];
  t2=matxy[0][3]+matxy[1][3]+matxy[2][3]+matxy[3][3];
  

  d=det(matxy, 4);
  if(d<=0.) return -1.;
  return (-log(d)+log(a1*c1*g1*t1*a2*c2*g2*t2)/2)/4;
}




/* gg95 */
/* Galtier & Gouy distance */

double gg95(char* seq1, char* seq2, double a){

  double k11, k12, k21, k22, t0, rt, freq[16], Q, t1, t2, e;
  int i;


  if(!freq_obs(seq1, seq2, freq)) return -1.;

  Q=freq[1]+freq[3]+freq[4]+freq[6]+freq[9]+freq[11]+freq[12]+freq[14];
  t1=0.;
  for(i=4;i<=11;i++) t1+=freq[i];
  t2=freq[1]+freq[2]+freq[5]+freq[6]+freq[9]+freq[10]+freq[13]+freq[14];
			
  if(2*Q>1.) return -1.;
  rt=-0.5*log(1-Q*2);
	
  t0=(t1+t2)/2;

  e=1-exp(-rt*(a+1.)/2);
  k11=(0.5+a*t1*(1-t1))*rt ; 
  k12=(a/(a+1.)) * ((t0-t1)*(1-2*t1)) * e;	
  k21=(0.5+a*t2*(1-t2))*rt;
  k22=(a/(a+1.)) * ((t0-t2)*(1-2*t2)) * e;

  return(k11+k12+k21+k22);

}



/* alsurbet_kim */
/* Return the quotient between transition substitution rate (alpha) and */
/* transversion substitution rate (beta) according to Kimura 1980 */
/* 2-parameter model between sequence seq1 and seq2. */

double alsurbet_kim(char* seq1, char* seq2){

  double freq[16], alphakim, betakim, P, Q;

  if(!freq_obs(seq1, seq2, freq)) return -1.;

  Q=freq[1]+freq[3]+freq[4]+freq[6]+freq[9]+freq[11]+freq[12]+freq[14];
  P=1-Q-freq[0]-freq[5]-freq[10]-freq[15];

  if (2*Q>=1.) return -1.;
  if (2*P+Q>=1.) return -1.;

  betakim=-0.125*log(1.-2*Q);
  alphakim=-0.25*log(1.-2*P-Q)+0.125*log(1.-2*Q);

  if (betakim==0.) return -1.;
 	
  return(alphakim/betakim);
}


/* freq_obs */
/* Write at address freq observed frequencies of 16 di-nucleotides XY */
/* (X= A,C,G,T  ,  Y=A,C,G,T) X and Y being homologous nucleotides of sequences */
/* seq1 and seq2. Alphabetic order is used : freq[0]=AA frequency, freq[1]=AC, */
/* ..., freq[15]=TT. */

int freq_obs(char* seq1, char* seq2, double* freq){

  int i, lgseq, lgseqvrai;
  int toret;

  if ((int)strlen(seq1)!=(int)strlen(seq2)){
    (void) printf ("Longueurs inegales.\n");
    toret = -1;
  }
  else {

    for(i=0;i<16;i++) freq[i]=0;
    lgseq=(int)strlen(seq1);
    lgseqvrai=lgseq;
    for(i=0;i<lgseq;i++){
      switch(seq1[i]){
      case 'A':
        switch(seq2[i]){
        case 'A' : freq[0]++; break;
        case 'C' : freq[1]++; break;
        case 'G' : freq[2]++; break;
        case 'T' : freq[3]++; break;
        default : lgseqvrai --; break;
        }
        break;
      case 'C':
        switch(seq2[i]){
        case 'A' : freq[4]++; break;
        case 'C' : freq[5]++; break;
        case 'G' : freq[6]++; break;
        case 'T' : freq[7]++; break;
        default : lgseqvrai --; break;
        }
        break;
      case 'G':
        switch(seq2[i]){
        case 'A' : freq[8]++; break;
        case 'C' : freq[9]++; break;
        case 'G' : freq[10]++; break;
        case 'T' : freq[11]++; break;
        default : lgseqvrai --; break;
        }
        break;
      case 'T':
        switch(seq2[i]){
        case 'A' : freq[12]++; break;
        case 'C' : freq[13]++; break;
        case 'G' : freq[14]++; break;
        case 'T' : freq[15]++; break;
        default : lgseqvrai --; break;
        }
        break;
      default :
        lgseqvrai --;
      }
    }
    if(lgseqvrai!=0){
      for(i=0;i<16;i++) freq[i]/=lgseqvrai;
      toret = 1;
    }
    else toret = 0;
  }
  return toret;
}


/* po */
/* Poisson correction for proteic divergence */

double po(char* seq1, char* seq2){
  double p=0., k;
  int i=0, lgvraie=0;

  while(seq1[i] && seq2[i]){
    if(seq1[i]!='-' && seq2[i]!='-'){
      lgvraie++;
      if(seq1[i]!=seq2[i]) p++;
    }
    i++;
  }
  p/=lgvraie;
  if (1-20.*p/19.<=0) return -1.;
  k=log(1-20.*p/19.)*(-19./20.);
  return k;
}


/* computekaks */
/* Call fastlw and check for saturation */

int computekaks(char** seq, int nb, int lg, double** d){
  int i=0, j;
  int sat1, sat2, seqsat1, seqsat2;
  printdata dataname;

  GetPanelExtra(pname, &dataname);

  if (KA) 
    (void) fastlwl(seq, nb, lg, d, NULL, tti0, tti1, tti2,
        ttv0, ttv1, ttv2, tl0, tl1, tl2, NULL, NULL, &sat1, &sat2);
  else{
    (void) fastlwl(seq, nb, lg, NULL, d, tti0, tti1, tti2,
        ttv0, ttv1, ttv2, tl0, tl1, tl2, NULL, NULL, &sat1, &sat2);
  }

  if (sat1!=-1) {
    char texte[100], ckli[3];
    if (option==1) return 0;
    for(j=0;j<nbseq;j++){
      if (dataname.selected[j]){
	if (i==sat1) seqsat1=j;
        if (i==sat2) {seqsat2=j; break; }
        i++;
      }
    }
    if(KA) (void) sprintf(ckli,"Ka"); else (void) sprintf(ckli,"Ks"); 
    (void) sprintf(texte, "Cannot compute %s for pair %s-%s: saturation",
          ckli, cname[seqsat1], cname[seqsat2]);
    createmessbox(texte, FALSE, quitwin, NULL);
    return 0;
  }
return 1;
}



/* compute_dist */
/* Read chosen distance and call the computing routine. */
/* Return 1 if all dist computed, 0 if problem. */

int compute_dist(char** treeseq, int nb, int lg, double** d, char* header){

  int dopt, i, j;

    dopt=GetValue(dist);
    if (dopt==1 && !PROTB){
      if (header) (void) sprintf(header, "Observed divergence\n");
      for(i=0;i<nb-1;i++)
        for(j=i+1;j<nb;j++)
          d[j][i]=d[i][j]=od(treeseq[i], treeseq[j]);
    }
    if (dopt==2 && !PROTB){
      if(!TRANSVONLY){
        if (header) (void) sprintf(header, "Jukes and Cantor distance\n");
        for(i=0;i<nb-1;i++){
          for(j=i+1;j<nb;j++){
            d[j][i]=d[i][j]=jc(treeseq[i], treeseq[j]);
	    if (d[i][j]<-0.5) return 0;
	  }
        }
      }
      else{
	if (header) (void) sprintf(header, "Corrected transversions\n");
        for(i=0;i<nb-1;i++){
          for(j=i+1;j<nb;j++){
            d[j][i]=d[i][j]=lQ_ry(treeseq[i], treeseq[j]);
	    if (d[i][j]<-0.5) return 0;
	  }
        }

      }
    }
    if (dopt==3 && !PROTB){
      if (header) (void) sprintf(header, "Kimura distance\n");
      for(i=0;i<nb-1;i++)
        for(j=i+1;j<nb;j++){
          d[j][i]=d[i][j]=kim2p(treeseq[i], treeseq[j]);
	  if (d[i][j]<-0.5) return 0;
	}
    }
    if (dopt==4 && !PROTB){
      if (header) (void) sprintf(header, "Tajima and Nei distance\n");
      for(i=0;i<nb-1;i++)
        for(j=i+1;j<nb;j++){
          d[j][i]=d[i][j]=tn(treeseq[i], treeseq[j]);
	  if (d[i][j]<-0.5) return 0;
	}
    }
    if (dopt==5 && !PROTB){
      if (header) (void) sprintf(header, "HKY distance\n");
      for(i=0;i<nb-1;i++)
        for(j=i+1;j<nb;j++){
          d[j][i]=d[i][j]=hky(treeseq[i], treeseq[j]);
	  if (d[i][j]<-0.5) return 0;
	}
    }
    if (dopt==6 && !PROTB){
      double alpha=0., prov;
      int vrai;
      if (header) (void) sprintf(header, "Galtier and Gouy distance\n");
      vrai=nb*(nb-1)/2;
      for(i=0;i<nb-1;i++){
        for(j=i+1;j<nb;j++){
          prov=alsurbet_kim(treeseq[i], treeseq[j]);
	  if (prov<-0.5) vrai--; else alpha+=prov;
	}
      }
      alpha/=vrai;
      if(alpha==0.) return 0;
      for(i=0;i<nb-1;i++)
        for(j=i+1;j<nb;j++){
	  d[j][i]=d[i][j]=gg95(treeseq[i], treeseq[j], alpha);
	  if (d[i][j]<-0.5) return 0;
	}
    }
    if(dopt==7 && !PROTB){
      double* mat[4];
      if (header) (void) sprintf(header, "LogDet distance\n");
      for(i=0;i<4;i++) mat[i]=(double*)check_alloc(4, sizeof(double));
      for(i=0;i<nb-1;i++)
	for(j=i+1;j<nb;j++){
	  d[j][i]=d[i][j]=logdet(treeseq[i], treeseq[j], mat);
	  if (d[i][j]<-0.5) return 0;
	}
    }      
    if (dopt==1 && PROTB){
      if (header) (void) sprintf(header, "Observed divergence\n");
      for(i=0;i<nb-1;i++)
	for(j=i+1;j<nb;j++)
          d[j][i]=d[i][j]=od(treeseq[i], treeseq[j]);
    }
    if (dopt==2 && PROTB){
      if (header) (void) sprintf(header, "Poisson correction\n");
      for(i=0;i<nb-1;i++)
	for(j=i+1;j<nb;j++){
          d[j][i]=d[i][j]=po(treeseq[i], treeseq[j]);
	  if (d[i][j]<-0.5) return 0;
	}
    }    
    if ((dopt==3 && PROTB) || (dopt==8 && !PROTB)){
      if (header) (void) sprintf(header, "Non-synonymous rate\n");
      KA=TRUE;
      if (!computekaks(treeseq, nb, lg, d)) return 0;
    }

    if ((dopt==4 && PROTB) || (dopt==9 && !PROTB)){
      KA=FALSE;
      if (header) (void) sprintf(header, "Synonymous rate\n");
      if (!computekaks(treeseq, nb, lg, d)) return 0;
    }
return 1;
}



/* jumble_fct */
/* Randomly order sequences (and names). */

void jumble_fct(char** seq, char** name, int notu){
  int i, j, rando, *dejatire, *neworder;
  char **new2;
  

  dejatire=(int*)check_alloc(notu, sizeof(int));
  for(i=0;i<notu;i++) dejatire[i]=0;
  neworder=(int*)check_alloc(notu, sizeof(int));
  new2=(char**)check_alloc(notu, sizeof(char*));

  for(i=j=0;i<notu;i++){
    do {
      rando=has1_n(notu)-1;
    }  while(dejatire[rando]);
    neworder[j++]=rando;
    dejatire[rando]=1;
  }
  for(i=0;i<notu;i++)
    new2[i]=seq[neworder[i]];
  for(i=0;i<notu;i++) seq[i]=new2[i];
  for(i=0;i<notu;i++)
    new2[i]=name[neworder[i]];
  for(i=0;i<notu;i++) name[i]=new2[i];
  free(dejatire); 
  free(neworder);
  free(new2);
  return;
 
}



	/** MISC  VIBRANT  FUNCTIONS  **/


/* shift */
/* Shift position for next object drawing */

void shift(Handle a, int dx, int dy){

  PoinT pt;

  GetNextPosition (a, &pt);
  pt.x+=(int)dx*screenwratio;
  pt.y+=(int)dy*screenhratio;
  SetNextPosition(a, pt);
}


/* mySetGroupSpacing */

void mySetGroupSpacing(GrouP gr, int x, int y){
 
  SetGroupSpacing(gr, x*screenwratio, y*screenhratio);
}


/* mySetGroupMargins */

void mySetGroupMargins(GrouP gr, int x, int y){

  SetGroupMargins(gr, x*screenwratio, y*screenhratio);
}


/* setgc */
/* Set gc values in memory (double* gc) and screen (panel pname) */

void setgc(void){
  int i, j, lgsel, *selected;
  printdata dataname, dataseq;

  GetPanelExtra(pname, &dataname);
  GetPanelExtra(pseq, &dataseq);

  selected=(int*)check_alloc(lgseq, sizeof(int));
  reg_and_pos(selected, dataseq.selected);

  for(i=0;i<nbseq;i++){
    lgsel=0;
    gc[i]=0.;
    for(j=0;j<lgseq;j++){
      if (selected[j]){
	if(seq[i][j]=='C' || seq[i][j]=='G') gc[i]++;
	if(seq[i][j]=='C' || seq[i][j]=='G' || seq[i][j]=='A' || seq[i][j]=='T') lgsel++;
      }
    }
    gc[i]/=lgsel; gc[i]*=100;
    (void) sprintf(dataname.lignes[i]+12,"%.1f",gc[i]);
  }
  SetPanelExtra(pname, &dataname);
  draw(pname);
}


	
/* draw */
/* Call drawing function for panel p */

 void draw(PaneL p){

  if (p==pname) drawnamepanel(p);
  else if (p==pseq) drawseqpanel(p);
  else drawpanel(p);
}
  

/* sitesetlength */
/* Return the number of sites selected in site set siteset. */

int sitesetlength(int* siteset){
int i, length=0;
  for(i=1;i<=siteset[0];i++)
    length+=siteset[2*i]-siteset[2*i-1]+1;

  return(length);
}


/* setreptext */
/* Set title of dialogtext rep_text = by-default number of replicates */
/* to perform for bootstrap, jumble or multi options. */

void  setreptext(int nbsel){
  char rep[5];
  
  if (nbsel<=0) {SetTitle(rep_text,""); return;}
  if (nbsel<=6  && nbsel>0) (void) sprintf(rep, "%d", fact(nbsel));
  else (void) sprintf(rep, "%d", defnbrep);
  SetTitle(rep_text, rep);
}


/* setnbsel */
/* Set number of selected lines (columns) in panel p, both in memory */
/* (extra data nbsel) and at screen (dialogtexts selsp_text and selsi_text). */

void setnbsel(PaneL p, int totsel, int nbsel){
  int i, nbpos=0;
  printdata data;
  char title[5];

  GetPanelExtra(p, &data);
  if(nbsel<0){
    data.nbsel=0;
    for(i=0;i<totsel;i++)
      data.nbsel+=data.selected[i];
  }
  else data.nbsel=nbsel;
  SetPanelExtra(p, &data);
  if (option==2 && p==pname) setreptext(data.nbsel);
  if (p==pname){
    (void) sprintf(title,"%d", data.nbsel);
    SetTitle(selsp_text, title);
    if (data.nbsel==0 || data.nbsel==nbseq) Disable(removei); else Enable(removei);
  }
  if (p==pseq){
    if(!PROTB){
      if(GetStatus(po1i)) nbpos++;
      if(GetStatus(po2i)) nbpos++;
      if(GetStatus(po3i)) nbpos++;
      if(nbpos==0) data.nbsel=0;
      else data.nbsel=data.nbsel*nbpos/3;
    }
    (void) sprintf(title,"%d", data.nbsel);
    SetTitle(selsi_text, title);
  }
  SetPanelExtra(p, &data);
}


/* setbdt */
/* Enable/disable draw tree button bdt */

void setbdt(void){
  printdata dataname, dataseq;

  GetPanelExtra(pname, &dataname);
  GetPanelExtra(pseq, &dataseq);
 
  if (dataname.nbsel<4){ Disable(bdt); return; }
  if (dataseq.nbsel==0){ Disable(bdt); return; }
  if (method==0){ Disable(bdt); return; }
  if (method==1 && GetValue(dist)==0) { Disable(bdt); return; }
  Enable(bdt);
}


/* sp_sel_act */
/* Callback procedure for button sp_sel : selects all species */

void sp_sel_act(ButtoN but){
  printdata data;
  int i;
  
  GetPanelExtra(pname, &data);
  for(i=0;i<data.tot_lignes;i++) data.selected[i]=1;
  SetPanelExtra(pname, &data);
  if (option==2) setreptext(nbseq);
  Select(pname);
  draw(pname);
  
  GetPanelExtra(pspecies, &data);
  for(i=0;i<data.tot_lignes;i++) data.selected[i]=0;
  SetPanelExtra(pspecies, &data);
  Select(pspecies);
  drawpanel(pspecies);
  Enable(sp_add);
  Enable(spgrname);
  Disable(sp_del);
  SetTitle(sp_text, "All");
  setbdt();
  setnbsel(pname, nbseq, nbseq);
  drawseqpanel(pseq);

  return;
}



/* si_sel_act */
/* Callback procedure for button si_sel : selects all sites */

void si_sel_act(ButtoN but){
  printdata data;
  int i;
  
  GetPanelExtra(pseq, &data);
  for(i=0;i<data.tot_cols;i++) data.selected[i]=1;
  SetPanelExtra(pseq, &data);
  Select(pseq);
  draw(pseq);
  setnbsel(pseq, lgseq, lgseq);
  GetPanelExtra(psites, &data);
  for(i=0;i<data.tot_lignes;i++) data.selected[i]=0;
  SetPanelExtra(psites, &data);
  Select(psites);
  draw(psites);
  Enable(si_add);
  Enable(sigrname);
  Disable(si_del);
  setbdt();
  SetTitle(si_text, "All");
  if (!PROTB) setgc();
  return;
}


/* sp_unsel_act */
/* Callback procedure for button sp_unsel : de-select all species */

void sp_unsel_act(ButtoN but){
  printdata data;
  int i;
  
  GetPanelExtra(pname, &data);
  for(i=0;i<data.tot_lignes;i++) data.selected[i]=0;
  setnbsel(pname, nbseq, 0);
  SetPanelExtra(pname, &data);
  Select(pname);
  draw(pname);
  
  GetPanelExtra(pspecies, &data);
  for(i=0;i<data.tot_lignes;i++) data.selected[i]=0;
  SetPanelExtra(pspecies, &data);
  Select(pspecies);
  draw(pspecies);
  Disable(sp_add);
  SetTitle(sp_text,"");
  Disable(spgrname);
  Disable(sp_del);
  draw(pseq);
  Disable(bdt);
}


/* si_unsel_act */
/* Callback procedure for button si_unsel : de-select all sites */

void si_unsel_act(ButtoN but){
  printdata data;
  int i;
  
  GetPanelExtra(pseq, &data);
  for(i=0;i<data.tot_cols;i++) data.selected[i]=0;
  SetPanelExtra(pseq, &data);
  setnbsel(pseq, lgseq, 0);
  Select(pseq);
  draw(pseq);
  
  GetPanelExtra(psites, &data);
  for(i=0;i<data.tot_lignes;i++) data.selected[i]=0;
  SetPanelExtra(psites, &data);
  Select(psites);
  draw(psites);
  Disable(si_add);
  SetTitle(si_text,"");
  Disable(sigrname);
  Disable(si_del);
  Disable(bdt);
}


/* sp_del_act */
/* Callback procedure for button sp_del : remove selected species set. */

void sp_del_act(ButtoN but){
  printdata data, data2;
  int i, todel;

  GetPanelExtra(pspecies, &data);
  for(i=0;i<data.tot_lignes;i++) if (data.selected[i]==1) {todel=i; break;}
  free(specset[todel]);
  free(specsetname[todel]);
  for(i=todel;i<nbspecsets-1;i++){ 
    specset[i]=specset[i+1]; 
    specsetname[i]=specsetname[i+1];
  }
  if (todel==nbspecsets-1) todel--;
  initpanel(pspecies, specsetname, nbspecsets-1, 1, &todel);
  settotlignes(pspecies, nbspecsets-1);
  GetPanelExtra(pname, &data2);
  for(i=0;i<data2.tot_lignes;i++)
    data2.selected[i]=0;
  if(todel>=0){
    for(i=1;i<=specset[todel][0];i++)
      data2.selected[specset[todel][i]]=1;
  }
  if (option==2) setreptext(data2.nbsel);
  SetPanelExtra(pname, &data2);
  nbspecsets--;
  if (nbspecsets==0) Disable(sp_del);
  setbdt();
  setnbsel(pname, nbseq, (todel>=0)?specset[todel][0]:0);
  draw(pname);
  draw(pseq); 
  CHANGESDONE=TRUE;
}


/* si_del_act */
/* Callback procedure for button si_del : remove selected site set. */

void si_del_act(ButtoN but){
  printdata data, data2;
  int i, j, todel;

  GetPanelExtra(psites, &data);
  for(i=0;i<data.tot_lignes;i++) if (data.selected[i]==1) {todel=i; break;}
  free(siteset[todel]);
  free(sitesetname[todel]);
  for(i=todel;i<nbsitesets-1;i++){ 
    siteset[i]=siteset[i+1]; 
    sitesetname[i]=sitesetname[i+1];
  }
  if (todel==nbsitesets-1) todel--;
  initpanel(psites, sitesetname, nbsitesets-1, 1, &todel);
  settotlignes(psites, nbsitesets-1);
  GetPanelExtra(pseq, &data2);
  for(i=0;i<data2.tot_cols;i++)
    data2.selected[i]=0;
  if(todel>=0)
    for(i=1;i<=siteset[todel][0];i++)
      for(j=siteset[todel][2*i-1]; j<=siteset[todel][2*i];j++)
        data2.selected[j]=1;
  SetPanelExtra(pseq, &data2);
  nbsitesets--;
  if (nbsitesets==0) Disable(si_del);
  draw(pseq);
  setnbsel(pseq, lgseq, -1); 
  setbdt();
  CHANGESDONE=TRUE;
  }



/* bdeltree_act */
/* Callback procedure for button bdeltree : remove selected tree. */

void bdeltree_act(ButtoN but){
  printdata data;
  int i, todel;

  GetPanelExtra(pbuild, &data);
  for(i=0;i<data.tot_lignes;i++) if (data.selected[i]) { todel=i; break; }
  memtree[todel]=NULL; 
  free(memtreename[todel]); 
  free(data.lignes[todel]);
  for(i=todel;i<nbtree-1;i++){
    memtree[i]=memtree[i+1];
    memtreename[i]=memtreename[i+1]; data.lignes[i]=data.lignes[i+1];
  }
  if (todel==nbtree-1) todel--;
  for(i=0;i<nbtree;i++) data.selected[i]=0;
  data.selected[todel]=1;
  SetPanelExtra(pbuild, &data);
  /*initpanel(pbuild, data.lignes, nbtree-1, 1, &todel);*/
  settotlignes(pbuild, nbtree-1);
  nbtree--;
  draw(pbuild);
  if (nbtree==0) 
    enablebuttons();
  CHANGESDONE=TRUE;
}



/* treeload */
/* input new tree from file */

void treeload(ButtoN but){
  
  printdata data;
  int i=0, j, brack, parenth, nb, flag, nbintrees=0, cpttrees=0;
  char treefname[100], *treefend, line[5000], *input,  *name[MAXNSP], rac, c, *prov;
  Boolean ok;
  FILE* treefile;


  ok=GetInputFileName(treefname, 100, "", NULL);
  if (!ok) return;
  treefend=strrchr(treefname, '/')+1;

  treefile=fopen(treefname, "r");
  GetPanelExtra(pbuild, &data);

  while(fscanf(treefile, "%c", &c)!=EOF) {if(c==';') nbintrees++;}
  if(nbintrees==0) goto badfile;
  rewind(treefile);
  input=(char*)check_alloc(nbintrees*(40*nbseq+MAXLHEAD), sizeof(char));
  j=0;
  while(fgets(line, 5000, treefile)) {
    (void) sprintf(input+j, "%s", line);
    j=(int)strlen(input);
    input[j]=0;
  }
  (void) fclose(treefile);
  
  j=0;
  while(input[j]==' ' || input[j]=='\t' || input[j]=='\n') j++;
  if(input[j]!='[' && input[j]!='(') goto badfile;

  j=brack=parenth=0;
  while(input[j]){
    if(input[j]=='[') brack++;
    else if(input[j]==']') brack--;
    else if(input[j]=='(') parenth++;
    else if(input[j]==')') parenth--;
    j++;
  }
  if(brack!=0 || parenth!=0) goto badfile;
    

  prov=input;
  while((!cpttrees && (memtree[nbtree]=prov)) || (cpttrees && (memtree[nbtree]=strchr(prov, ';')+1))){
    if(memtree[nbtree][0]==0) break;
    if(cpttrees){ 
      if(memtree[nbtree][0]!=' ' && memtree[nbtree][0]!='\n' && memtree[nbtree][0]!='\t'){
        createmessbox("Trees must be separated by blanks, tabs or new lines",
            FALSE, quiterr, NULL); 
        return; 
      }
      *(memtree[nbtree])=0; memtree[nbtree]++; 
    }
    flag=0;
    while(*memtree[nbtree]) 
      if(*memtree[nbtree]=='[' || *memtree[nbtree]=='(') { flag=1; break; }
      else memtree[nbtree]++;
      
    if (!flag) break;

    if(memtree[nbtree][0]=='['){
      i=0;
      while(TRUE){
        if(memtree[nbtree][i]==']') break;
        if(memtree[nbtree][i]=='\\') memtree[nbtree][i]='\n';
        i++;
      }
    }
    
  
    for(i=0;i<=nbseq;i++) name[i]=(char*)check_alloc(MAXLNAME+1, sizeof(char));
    nb=tree_ctot(memtree[nbtree], NULL, NULL, NULL, NULL, name, &rac);
    if(rac=='r') for(i=0;i<nb;i++) name[i]=name[i+1];
    for(i=0;i<nb;i++){
      flag=0;
      for(j=0;j<nbseq;j++){
        if(samename(name[i], cname[j])) {flag=1; break; }
      }
      if (!flag) {
        char text[50];
        (void) sprintf(text,"Unknown species : %s", name[i]);
        createmessbox(text, FALSE, quiterr, NULL);
        return;
      }
    }
      

    i=0;
    memtreename[nbtree]=(char*)check_alloc(30, sizeof(char));
    (void) sprintf(memtreename[nbtree], "%.17s", treefend);
    while(memtreename[nbtree][i] && i<thresh1) i++;
    (void) sprintf(memtreename[nbtree]+i, "%d", ++cpttrees);
    i+=1+cpttrees/10;
    (void) sprintf(memtreename[nbtree]+i, "(%d)", nb);
    i=0;

    data.lignes[nbtree]=(char*)check_alloc(30, sizeof(char));
    (void) sprintf(data.lignes[nbtree], "%s", memtreename[nbtree]);

    for(i=0;i<=nbtree;i++) data.selected[i]=0;
    data.tot_lignes++;
    prov=memtree[nbtree];
    nbtree++;
    if (nbtree==MAXTREE) {createmessbox("Too many stored trees", FALSE, quiterr, NULL); return; }
  }


  SetPanelExtra(pbuild, &data);
  settotlignes(pbuild, nbtree);
  draw(pbuild);
  CHANGESDONE=TRUE;

  return;
  
  badfile : 
  (void) sprintf(line, "Bad tree file : %s", treefname);
  createmessbox(line, FALSE, quitwin, NULL);
}

  


/* sp_add_act */
/* Callback procedure for button sp_add : add new specie set. */

void sp_add_act(ButtoN but)
{
  printdata data, data2;
  int i, lgname, cpt=0;
  char* grname;

  if (nbspecsets==MAXSPSET) return;
  specset[nbspecsets]=(int*)check_alloc(nbseq+1, sizeof(int));
  GetPanelExtra(pname, &data);
  for(i=0;i<nbseq;i++)
    if (data.selected[i]==1)
      specset[nbspecsets][++cpt]=i;
  specset[nbspecsets][0]=cpt;    
  lgname=TextLength(sp_text);
  if (lgname<=0) return;
  lgname=mini(lgname, 20);
  grname=(char*)check_alloc(lgname+1, sizeof(char));
  GetTitle(sp_text, grname, lgname);
  specsetname[nbspecsets]=(char*)check_alloc(lgname+5, sizeof(char));
  (void) sprintf(specsetname[nbspecsets],"%s(%d)",grname,specset[nbspecsets][0]);
  initpanel(pspecies, specsetname, nbspecsets+1, 1, &nbspecsets);
  settotlignes(pspecies, nbspecsets+1);
  if (nbspecsets+1>6){
    GetPanelExtra(pspecies, &data2);
    SetValue(GetSlateVScrollBar((SlatE)pspecies), data2.tot_lignes - data2.nbr_lignes);
  }
  nbspecsets++;
  nextgroup++;
  SetTitle(sp_text,"");
  Disable(spgrname);
  Disable(sp_add);
  Enable(sp_del);
  setbdt();
  draw(pname);
  draw(pseq);
  CHANGESDONE=TRUE;
  free(grname);
}


/* si_add_act */
/* Callback procedure for button si_add : add new site set. */

void si_add_act(ButtoN but)
{
  printdata data, data2;
  int i, lgname, cpt=0;
  char* setname;

  if (nbsitesets==MAXSITESET) return;
  siteset[nbsitesets]=(int*)check_alloc(2*MAXREG+1, sizeof(int));
  GetPanelExtra(pseq, &data);
  if(data.selected[0]==1) siteset[nbsitesets][++cpt]=0;
  for(i=1;i<lgseq;i++)
    if (data.selected[i]!=data.selected[i-1])
      siteset[nbsitesets][++cpt]=data.selected[i]? i : i-1;
  if(data.selected[lgseq-1]==1) siteset[nbsitesets][++cpt]=lgseq-1;
  if (cpt%2!=0) (void) printf("Erreur-\n");
  siteset[nbsitesets][0]=cpt/2;  
  lgname=TextLength(si_text);
  if (lgname<=0) return;
  lgname=mini(lgname, 20);
  setname=(char*)check_alloc(lgname+1, sizeof(char));
  GetTitle(si_text, setname, lgname);
  sitesetname[nbsitesets]=(char*)check_alloc(lgname+7, sizeof(char));
  (void) sprintf(sitesetname[nbsitesets],"%s(%d)",setname,sitesetlength(siteset[nbsitesets]));
  initpanel(psites, sitesetname, nbsitesets+1, 1, &nbsitesets);
  settotlignes(psites, nbsitesets+1);
  if (nbsitesets+1>6){
    GetPanelExtra(psites, &data2);
    SetValue(GetSlateVScrollBar((SlatE)psites), data2.tot_lignes - data2.nbr_lignes);
  }
  nbsitesets++;
  nextset++;
  SetTitle(si_text,"");
  Disable(sigrname);
  Disable(si_add);
  Enable(si_del);
  setbdt();
  draw(pseq);
  CHANGESDONE=TRUE;
  free(setname);
}




/* nj_act */

void nj_act(ButtoN b){
  printdata databd;
  int i=0, treesel=-1;
  ButtoN but;

  GetPanelExtra(pbuild, &databd);
  while(i<databd.tot_lignes) if(databd.selected[i++]) { treesel=i-1; break; }
  if (treesel!=-1) but=evaltree; else but=bdt;

  SetStatus(bmp, FALSE);
  SetStatus(bml, FALSE);
  if(GetStatus(b)){
    method=1; 
    if (GetValue(dist)) Enable(but);
  }
  else{
    method=0;
    Disable(but);
  }
  if (treesel!=-1) return;
  setbdt();
  if (Enabled(bjumb)) Disable(bjumb);
}


/* mp_act */

void mp_act(ButtoN b){
  printdata databd;
  int i=0, treesel=-1;
  ButtoN but;

  GetPanelExtra(pbuild, &databd);
  while(i<databd.tot_lignes) if(databd.selected[i++]) { treesel=i-1; break; }
  if (treesel!=-1) but=evaltree; else but=bdt;
  
  SetStatus(bnj, FALSE);
  SetStatus(bml, FALSE);
  if(GetStatus(b)){
    method=2;
    Enable(but);
  }
  else{
    method=0;
    Disable(but);
  }
  if (treesel!=-1) return;
  setbdt();
  if (!Enabled(bjumb)) Enable(bjumb);
}


/* ml_act */

void ml_act(ButtoN b){
  printdata databd;
  int i=0, treesel=-1;
  ButtoN but;

  GetPanelExtra(pbuild, &databd);
  while(i<databd.tot_lignes) if(databd.selected[i++]) { treesel=i-1; break; }
  if (treesel!=-1) but=evaltree; else but=bdt;

  SetStatus(bmp, FALSE);
  SetStatus(bnj, FALSE);
  if(GetStatus(b)){
    method=3;
    Enable(but);
  }
  else{
    method=0;
    Disable(but);
  }
  if (treesel!=-1) return;
  setbdt();
  if (!Enabled(bjumb)) Enable(bjumb);
}


/* boot_act */

void boot_act(ButtoN b){
  char text[10];
  SetStatus(bjumb, FALSE);
  SetStatus(bmult, FALSE);
  if (GetStatus(b)){
    Enable(repg);
    (void) sprintf(text, "%d", defnbrep);
    SetTitle(rep_text,  text);
    option=1;
  }
  else{
    SetTitle(rep_text,"");
    Disable(repg);
    option=0;
  }
}


/* jumb_act */

void jumb_act(ButtoN b){

printdata data;
  SetStatus(bboot, FALSE);
  SetStatus(bmult, FALSE);
  if (GetStatus(b)){
    Enable(repg);
    GetPanelExtra(pname, &data);
    setreptext(data.nbsel);
    option=2;
  }
  else{
    SetTitle(rep_text,"");
    Disable(repg);
    option=0;
  }
}


/* mult_act */

void mult_act(ButtoN b){
  SetStatus(bjumb, FALSE);
  SetStatus(bboot, FALSE);
  SetTitle(rep_text,"");
  Disable(repg);
  if (GetStatus(b)) option=3; else option=0;
}



/* loadrl */
/* Load rl's values = weights of aminoacids substitutions for Ka/Ks computing. */

void loadrl(void){

  int i, j;

  for(i=0;i<64;i++){
    tl0[i]=(double*)check_alloc(64, sizeof(double));
    tl1[i]=(double*)check_alloc(64, sizeof(double));
    tl2[i]=(double*)check_alloc(64, sizeof(double));
    tti0[i]=(double*)check_alloc(64, sizeof(double));
    tti1[i]=(double*)check_alloc(64, sizeof(double));
    tti2[i]=(double*)check_alloc(64, sizeof(double));
    ttv0[i]=(double*)check_alloc(64, sizeof(double));
    ttv1[i]=(double*)check_alloc(64, sizeof(double));
    ttv2[i]=(double*)check_alloc(64, sizeof(double));
  }

  for(i=0;i<=20;i++){
    rl[i]=(double*)check_alloc(21, sizeof(double));
    rl[0][i]=rl[i][0]=0.;
  }

  rl[2][1]=rl[3][1]=rl[3][2]=rl[5][1]=rl[5][3]=rl[6][1]=rl[6][3]=rl[6][5]=0.382;
  rl[7][1]=rl[7][3]=rl[7][5]=rl[7][6]=rl[8][1]=rl[8][5]=rl[8][6]=rl[8][7]=0.382;
  rl[11][9]=rl[12][9]=rl[13][4]=rl[13][9]=rl[15][4]=rl[15][13]=rl[16][14]=rl[16][15]=0.382;
  rl[17][4]=rl[18][4]=rl[18][15]=rl[18][17]=rl[19][4]=rl[19][15]=rl[19][16]=rl[20][16]=0.382;
  rl[20][19]=0.382;

  rl[4][1]=rl[4][3]=rl[5][2]=rl[5][4]=rl[6][2]=rl[6][4]=rl[7][2]=rl[7][4]=0.343;
  rl[8][2]=rl[8][3]=rl[8][4]=rl[9][4]=rl[9][5]=rl[9][6]=rl[9][7]=rl[9][8]=0.343;
  rl[11][4]=rl[11][5]=rl[11][6]=rl[11][7]=rl[11][8]=rl[12][4]=rl[12][11]=rl[13][3]=0.343;
  rl[13][5]=rl[13][6]=rl[13][7]=rl[13][8]=rl[13][11]=rl[13][12]=rl[14][4]=rl[14][9]=0.343;
  rl[14][11]=rl[14][12]=rl[14][13]=rl[15][3]=rl[15][8]=rl[15][9]=rl[15][11]=rl[15][12]=0.343;
  rl[15][14]=rl[16][4]=rl[16][9]=rl[16][12]=rl[16][13]=rl[17][3]=rl[17][5]=rl[17][8]=0.343;
  rl[17][13]=rl[17][15]=rl[17][16]=rl[18][1]=rl[18][3]=rl[18][5]=rl[18][7]=rl[18][8]=0.343;
  rl[18][13]=rl[18][16]=rl[19][9]=rl[19][12]=rl[19][13]=rl[19][14]=rl[19][17]=rl[19][18]=0.343;
  rl[20][4]=rl[20][12]=rl[20][13]=rl[20][14]=rl[20][15]=rl[20][18]=0.343;

  rl[4][2]=rl[9][1]=rl[9][2]=rl[9][3]=rl[11][1]=rl[11][2]=rl[11][3]=rl[12][5]=0.128;
  rl[12][6]=rl[12][7]=rl[12][8]=rl[13][1]=rl[13][2]=rl[13][10]=rl[14][3]=rl[14][5]=0.128;
  rl[14][6]=rl[14][7]=rl[14][8]=rl[14][10]=rl[15][1]=rl[15][2]=rl[15][5]=rl[15][6]=0.128;
  rl[15][7]=rl[16][3]=rl[16][5]=rl[16][7]=rl[16][8]=rl[16][10]=rl[16][11]=rl[17][1]=0.128;
  rl[17][2]=rl[17][6]=rl[17][7]=rl[17][9]=rl[17][11]=rl[17][12]=rl[17][14]=rl[18][2]=0.128;
  rl[18][6]=rl[18][9]=rl[18][11]=rl[18][12]=rl[18][14]=rl[19][1]=rl[19][3]=rl[19][5]=0.128;
  rl[19][6]=rl[19][7]=rl[19][8]=rl[19][11]=rl[20][9]=rl[20][11]=rl[20][17]=rl[12][3]=0.128;

  rl[10][1]=rl[10][2]=rl[10][3]=rl[10][4]=rl[10][5]=rl[10][6]=rl[10][7]=rl[10][8]=0.040;
  rl[10][9]=rl[11][10]=rl[12][1]=rl[12][2]=rl[12][10]=rl[14][1]=rl[14][2]=rl[15][10]=0.040;
  rl[16][1]=rl[16][2]=rl[16][6]=rl[17][10]=rl[18][10]=rl[19][2]=rl[19][10]=rl[20][1]=0.040;
  rl[20][2]=rl[20][3]=rl[20][5]=rl[20][6]=rl[20][7]=rl[20][8]=rl[20][10]=0.040;

  

  for (i = 1; i <= 20; i++) {
    *(rl[i] + i) = 1.0;
    for (j = i + 1; j <= 20; j++)
      *(rl[i] + j) = *(rl[j] + i);
  }

}



/* nucseqload */
/* Ka/Ks computing first step : */
/* Read input nucleotidic file name in dialogtext messtext. Open, check and read */
/* that file. Set char** nucseq. Prepare Ka/Ks computing (loadrl + prefastlwl). */

void nucseqload(ButtoN but){

int nbnuc, i, j, flag;
char* nucname[MAXNSP], nucfile[100], *prov[MAXNSP], texte[100], err_mess[200];
FILE* nuc;


  Disable(mess_ok);
  GetTitle(messtext, nucfile, sizeof(nucfile));
  if (nucfile==NULL) return;
  if ((nuc=fopen(nucfile,"r"))==NULL){
    char *c;
    (void) Remove(messw); messw=NULL;
    (void) sprintf(texte,"Bad input file : %s", (c=strrchr(nucfile,'/'))?c:nucfile);
    createmessbox(texte, FALSE, quitwin, NULL);
    return;
  }
  nbnuc=fileread(nuc, prov, nucname, NULL, NULL, NULL, NULL, NULL, NULL,
       NULL, NULL, NULL, NULL, NULL, err_mess);


  if(nbnuc==0){
    (void) Remove(messw); messw=NULL;
    (void) sprintf(texte, "Bad sequence file : %s", nucfile);
    createmessbox(texte, FALSE, quitwin, NULL);
    return;    
  }

  if (nbnuc<nbseq){
    (void) Remove(messw); messw=NULL;
    (void) sprintf(texte, "There are missing sequences");
    createmessbox(texte, FALSE, quitwin, NULL);
    return;
  }
  

  for(i=0;i<nbseq;i++){
    for(j=0;j<nbnuc;j++){
      flag=0;
      if(samename(cname[i], nucname[j])){
	flag=1;
	break;
      }
    }
    if (flag==0){
      (void) Remove(messw); messw=NULL;
      (void) sprintf(texte, "Sequence %s is missing", cname[i]);
      createmessbox(texte, FALSE, quitwin, NULL);
      return;
    }
    if ((nucseq[i]=invtradseq(seq[i],prov[j]))==NULL){
      (void) sprintf(texte,"Bad nucleotidic sequence : %s", cname[i]);
      (void) Remove(messw); messw=NULL;
      createmessbox(texte, FALSE, quitwin, NULL);
      return;
    }
    free(prov[j]);
  }
  loadrl();
  prefastlwl(rl, tl0, tl1, tl2, tti0, tti1, tti2, ttv0, ttv1, ttv2);

  (void) Remove(messw); messw=NULL;
  setbdt();
  NUCSEQLOADED=TRUE;
}



/* dist_act */

void dist_act(ChoicE c){
char* texte;
int d, i=0, treesel=-1;
printdata databd;

  texte=(char*)check_alloc(50, sizeof(char));
  GetPanelExtra(pbuild, &databd);
  while(i<databd.tot_lignes) { if(databd.selected[i]) { treesel=i; break; } i++;}
  if (treesel!=-1 && GetStatus(bnj))  Enable(evaltree); 

  d=GetValue(dist);
  if (PROTB && d>2  && !NUCSEQLOADED){
    (void) sprintf(texte, "Nucleotidic sequences file name ?");
    createmessbox(texte, TRUE, nucseqload, quitwin);
  }
  else if(!PROTB && (d==8 || d==9) && !NUCSEQLOADED) {
    for(i=0;i<nbseq;i++) nucseq[i]=seq[i];
    loadrl();
    prefastlwl(rl, tl0, tl1, tl2, tti0, tti1, tti2, ttv0, ttv1, ttv2);
    NUCSEQLOADED=TRUE;
  }
  setbdt();
  return;
}



/** PANEL  CALLBACK  PROCEDURES  **/

/* pname_callback */

void pname_callback(PaneL p){
  printdata data, dataname;
  int i, flag=0;
  char grname[7];

  GetPanelExtra(pspecies, &data);
  for(i=0;i<data.tot_lignes;i++) {
    if (data.selected[i]==1) {
      data.selected[i]=0;
      flag=1;
      break;
    }
  }
  if (flag){
    SetPanelExtra(pspecies, &data);
    Select(pspecies);
    drawpanel(pspecies);
  }
  setnbsel(pname, nbseq, -1);
  (void) sprintf(grname,"Group%d",nextgroup);
  Enable(spgrname);
  SetTitle(sp_text,grname);
  Enable(sp_add);
  Disable(sp_del);
  setbdt();
  GetPanelExtra(pname, &dataname);
  if (dataname.nbsel==nbseq || dataname.nbsel==0) Disable(removei); else Enable(removei);
  enablebuttons();
  return;
}



/* pseq_callback */

void pseq_callback(PaneL p){
  printdata data;
  int i, flag=0;
  char setname[5];

  GetPanelExtra(psites, &data);
  for(i=0;i<data.tot_lignes;i++) {
    if (data.selected[i]==1) {
      data.selected[i]=0;
      flag=1;
      break;
    }
  }
  if (flag){
    SetPanelExtra(psites, &data);
    Select(psites);
    draw(psites);
  }

  setnbsel(pseq, lgseq, -1);
  (void) sprintf(setname,"Set%d",nextset);
  if (!PROTB) setgc();  
  else draw(pname);
  Enable(sigrname);
  SetTitle(si_text,setname);
  Enable(si_add);
  Disable(si_del);
  enablebuttons();
  return;
}



void pspecies_callback(PaneL p){
  printdata datasp, dataname;
  int i, ii, nb=0;
  GetPanelExtra(pname, &dataname);
  GetPanelExtra(pspecies, &datasp);
  
  for(ii=0;ii<dataname.tot_lignes;ii++) dataname.selected[ii]=0;
  for(i=0;i<datasp.tot_lignes;i++) if(datasp.selected[i]){
    nb++;
    for(ii=1;ii<=specset[i][0];ii++)
      dataname.selected[specset[i][ii]]=1;
    dataname.nbsel+=specset[i][0];
  }
  SetPanelExtra(pname, &dataname);
  Select(pname);
  draw(pname);
  if (option==2) setreptext(dataname.nbsel);

  if (nb==1 && nbspecsets>0) Enable(sp_del);
  else Disable(sp_del);
  Disable(sp_add);
  SetTitle(sp_text,"");
  Disable(spgrname);
  setbdt();
  setnbsel(pname, nbseq, -1);

  draw(pseq);
}



void psites_callback(PaneL p){
  printdata datasi, dataseq;
  int i, ii, j, nb=0;
  GetPanelExtra(pseq, &dataseq);
  GetPanelExtra(psites, &datasi);
  
  for(ii=0;ii<dataseq.tot_cols;ii++) dataseq.selected[ii]=0;
  for(i=0;i<datasi.tot_lignes;i++) if(datasi.selected[i]){
    nb++;
    for(ii=1;ii<=siteset[i][0];ii++)
      for(j=siteset[i][2*ii-1]; j<=siteset[i][2*ii];j++)
        dataseq.selected[j]=1;
  }
  SetPanelExtra(pseq, &dataseq);
  Select(pseq);
  draw(pseq);

  if (nb==1 && nbsitesets>0) Enable(si_del);
  else Disable(si_del);
  Disable(si_add);
  SetTitle(si_text,"");
  Disable(sigrname);
  setbdt();
  setnbsel(pseq, lgseq, -1);
  if (!PROTB) setgc();
}


void pbuild_callback(PaneL p){
  int sel=-1, i;
  printdata data;

  GetPanelExtra(pbuild, &data);
  for(i=0;i<data.tot_lignes;i++) if (data.selected[i]) { sel=i; break; }
  if (sel==-1){
    Disable(bdeltree);
    enablebuttons();
    SetTitle(bdt, SMALLSCREEN?"BUILD":"MAKE TREE");
    return;
  }
  Disable(bboot); Disable(bmult); Disable(bjumb);
  Disable(inputtree);
  SetStatus(bmp, FALSE); SetStatus(bml, FALSE); SetStatus(bnj, FALSE); SetStatus(evaltree, FALSE);
  if(SMALLSCREEN){
    SetTitle(bnj, "M.E."); 
  }
  else{
    SetTitle(bnj, " BRANCH LENGTHS "); 
    SetTitle(bmp, "   PARSIMONY   "); 
    SetTitle(bml,"   LIKELIHOOD   "); 
  }
  Enable(bdeltree);
  SetTitle(bdt, SMALLSCREEN?"DRAW":"DRAW TREE");
  Enable(bdt);
}  



/* load_callback */

void load_callback(PaneL p){
  int sel=-1, i;
  printdata data;
  
  GetPanelExtra(p, &data);
  for(i=0;i<data.tot_lignes;i++) if (data.selected[i]==1) {sel=i; break;}
  if (sel!=-1) SetTitle(loadtext, data.lignes[sel]);
  Enable(load_ok);
}



/* unroot */
/* Unroot t_tree treer. All parameters are modified (branch lengths, names, ...). */
/* Root info may be kept in list1-list2 l1-l2 */

int unroot(int** treer, int notu, double* lgbi, double* lgbp,
  double* bootvals, char** nom, char** list1, char** list2, int* l1, int* l2){
  int i, j, j1, j2, br_a_virer=-1, bp_a_modifier=-1, bi_a_modifier=-1;
  int somme1, somme2, drapeau;
  double l;

  for(j=0;j<notu-2;j++) if(treer[0][j]!=0) return 1;
  for(j1=0;j1<notu-3;j1++){
    somme1=0;
    for(i=0;i<notu+1;i++) somme1 += treer[i][j1];
    if (somme1==notu-1){ 
      br_a_virer=j1; 
      if(lgbp){
        l=lgbi[j1]; 
        for(i=1;i<notu+1;i++) if(treer[i][j1]==0) {bp_a_modifier=i; break;} 
      }
      break;
    }
    for(j2=j1+1;j2<notu-2;j2++){
      somme2=0;
      for(i=0;i<notu+1;i++) somme2+=treer[i][j2];
      if (somme1==notu-somme2){
	drapeau=0;
	for(i=1;i<notu;i++) if(abs(treer[i][j1]-treer[i][j2])!=1) drapeau=1;
	if (drapeau==0){ 
          br_a_virer=j1; 
          if(lgbi) { bi_a_modifier=j2; l=lgbi[j1]; }
	  break; 
	}
      }

      if (br_a_virer!=-1) break;
    }
    if (br_a_virer!=-1) break;
  }


  if(l1){
    j1=j2=0;
    for(i=1;i<=notu;i++){
      if(treer[i][br_a_virer]==0) list1[j1++]=nom[i];
      else list2[j2++]=nom[i];
    }
    if(j1<1 || j2<1) (void) printf("probleme\n");
    *l1=j1; *l2=j2;
  }
  

  if (bp_a_modifier!=-1) lgbp[bp_a_modifier]+=l;
  if (bi_a_modifier!=-1) lgbi[bi_a_modifier]+=l;
  for(i=br_a_virer;i<notu-3;i++){
    if (lgbi) lgbi[i]=lgbi[i+1];
    if (bootvals) bootvals[i]=bootvals[i+1];
  }
  for(i=0;i<notu;i++) { if(lgbp) lgbp[i]=lgbp[i+1]; if(nom) nom[i]=nom[i+1]; }
		
  for(i=1;i<notu+1;i++)
    for(j=0;j<notu-2;j++)
      treer[i-1][j]=treer[i][j];

  for(j=br_a_virer+1;j<notu-2;j++)
    for(i=0;i<notu;i++)
      treer[i][j-1]=treer[i][j];

  return 0;
}




/* compatible */
/* Return TRUE if internal branches b1 and b2 (bits) may belong to a single tree, */
/* FALSE otherwise. */

Boolean compatible(int* b1, int* b2, int nb){

  int i, kkill[4];
  int bitb1, bitb2;

  kkill[0]=kkill[1]=kkill[2]=kkill[3]=0;
  
  for(i=0;i<nb;i++){

    bitb1=testbit(b1, i+1);
    bitb2=testbit(b2, i+1);

    if(!kkill[0] && !bitb1 && !bitb2) kkill[0]=1;
    if(!kkill[1] && !bitb1 && bitb2) kkill[1]=1;
    if(!kkill[2] && bitb1 && !bitb2) kkill[2]=1;
    if(!kkill[3] && bitb1 && bitb2) kkill[3]=1;

    if (kkill[0] && kkill[1] && kkill[2] && kkill[3]) return FALSE;
  }
  return TRUE;
}



/* bilist_sort */
/* Sort nb-3 n-branches given by b according to bootstrap values bootval. */
/* Result is returned via a pointer to the sorted ranks of input branches. */
/* Only compatible branches are allowed : first branch is that one with higher */
/* bootstrap value, second branch is that one with next bootstrap value if */
/* compatible with first one, etc... */

int* bilist_sort(int** b, int* bootval, int nb, int total){

  int *nieme;
  int i, j, k, *kkill, max, drapeau;

  nieme=(int*)check_alloc(nb-3,sizeof(int));
  kkill=(int*)check_alloc(total,sizeof(int));
  for(i=0;i<total;i++) kkill[i]=0;
  i=0;
  while(i<nb-3){
    max=0;
    while(kkill[max]) max++;
    for(j=max+1;j<total;j++) if (!kkill[j] && bootval[j]>bootval[max]) max=j;
    kkill[max]=1; 
    drapeau=0;
    for(k=0;k<i;k++){
      if (!compatible(b[nieme[k]], b[max], nb)) { 
        drapeau=1; 
	break; 
      }
    }
    if (!drapeau) nieme[i++]=max;
  }
free(kkill);
return nieme;
}



/* max_length_down */
/* Compute the maximum root<->leaf length. */

double max_length_down(noeud comesfrom, noeud node){
  noeud gauche, droit;
  double lgfrom;
  if( node->v1 == comesfrom ) {
    gauche =node->v2; droit = node->v3; lgfrom=node->l1;
  }
  else if( node->v2 == comesfrom ) {
    gauche =node->v1; droit = node->v3; lgfrom=node->l2;
  }
  else {
    gauche =node->v1; droit = node->v2; lgfrom=node->l3;
  }  
  if (lgfrom<0.) lgfrom*=-1.;
  if (gauche==NULL) return lgfrom;
  return (lgfrom+maxd(max_length_down(node, gauche), max_length_down(node, droit)));
}



/* av_length_down */
/* Compute the average length of the tree down a node */

  double av_length_down(noeud pere, noeud racine){

  struct noeud2 *gauche, *droite;
  double bg,bd,lg,ld;
  double toret;

  if(racine == NULL) toret = 0.0;
  else {
    if( racine->v1 == pere ) {
      gauche =racine->v2; droite = racine->v3;
      bg = (racine->l2); bd = (racine->l3);
    }
    else if( racine->v2 == pere ) {
      gauche =racine->v1; droite = racine->v3;
      bg = (racine->l1); bd = (racine->l3);
    }
    else {
      gauche =racine->v1; droite = racine->v2;
      bg = (racine->l1); bd = (racine->l2);
    }
    lg = av_length_down(racine,gauche) + bg;
    ld = av_length_down(racine,droite) + bd;
    toret =  ((lg+ld)/2);
    }
    return toret;
}



/* nb_leaves_down */
/* Return the number of leaves down a node. */

int nb_leaves_down(noeud comesfrom, noeud node){
  noeud droit, gauche;

  if (node->v1 == comesfrom) { gauche=node->v2; droit=node->v3; }
  else if (node->v2 == comesfrom) { gauche=node->v1; droit=node->v3; }
  else { gauche=node->v1; droit=node->v2; } 

  if (gauche==NULL && droit==NULL) return 1;
  return nb_leaves_down(node, droit)+nb_leaves_down(node, gauche);
} 




/* untilsup */
/* needed by central_branch. */

branche untilsup(noeud comesfrom, noeud centre, double lg){
  branche branch;
  double d, g, dd, gg, l, bo, nextlg;
  noeud droit, gauche, togo;

  if (comesfrom==centre->v1) { 
    l=centre->l1; bo=centre->b1; 
    gauche=centre->v2; 
    gg=centre->l2; 
    droit=centre->v3; 
    dd=centre->l3;
  }
  else if (comesfrom==centre->v2) { 
    l=centre->l2; bo=centre->b2; 
    gauche=centre->v1; 
    gg=centre->l1; 
    droit=centre->v3; 
    dd=centre->l3;
  }
  else{ 
    l=centre->l3; bo=centre->b3;
    gauche=centre->v1; 
    gg=centre->l1; 
    droit=centre->v2; 
    dd=centre->l2;
  }

  d=av_length_down(centre, droit)+dd;
  g=av_length_down(centre, gauche)+gg;
  if (d>g){ togo=droit; nextlg=(lg+l+g)/2; }  else { togo=gauche; nextlg=(lg+l+d)/2; }
  
  if (lg+l<(d+g)/2.) return untilsup(centre, togo, nextlg);
/*  else  */
    branch=(branche)check_alloc(1, sizeof(struct sbranche));
    branch->bout1=comesfrom;
    branch->bout2=centre;
    branch->length=l; branch->bootstrap=bo;
    return(branch);
}




/* central_branch */
/* Return central branch of s_tree arbre_s. */

branche central_branch(noeud* arbre_s, int notu){
  double l1, l2, l3, lgmoy;
  noeud debut, togo;

  debut=arbre_s[2*notu-3];
  l1=av_length_down(debut, debut->v1)+debut->l1;
  l2=av_length_down(debut, debut->v2)+debut->l2;
  l3=av_length_down(debut, debut->v3)+debut->l3;
  if (l1>l2 && l1>l3) { togo=debut->v1; lgmoy=(l2+l3)/2.; }
  else if (l2>l1 && l2>l3) { togo=debut->v2; lgmoy=(l1+l3)/2.; }
  else { togo=debut->v3; lgmoy=(l2+l1)/2.; }

  return untilsup(debut, togo, lgmoy);
}



/* depth */
/* Set node's depth in a rooted tree. */
/* depth(terminal node) = 0 */
/* depth(internal node) = number of branches between node and farest terminal node */
/* node comesfrom (one of node's neighbors) is root. */

int depth (noeud comesfrom, noeud node){
  noeud droit, gauche;

  if (node->v1==NULL) { node->depth=0; return 0; }
  if (node->v2==NULL) { node->depth=0; return 0; }
  
  if (comesfrom==node->v1) { 
    gauche=node->v2; 
    droit=node->v3; 
  }
  else if (comesfrom==node->v2) { 
    gauche=node->v1; 
    droit=node->v3; 
  }
  else { 
    gauche=node->v1; 
    droit=node->v2; 
  }

  node->depth=maxi(depth(node, gauche), depth(node, droit))+1;
  return node->depth;
}



/* pseudo */
/* Compute and set pseudo branch length in tree */
/* (parsimony trees), to allow drawing. */

void pseudo(noeud comesfrom, noeud node, double d){
  noeud droit, gauche;
  
  if (comesfrom==node->v1) { 
    node->l1=abs(node->depth-node->v1->depth)/d;
    gauche=node->v2; 
    if (gauche==NULL) return;
    droit=node->v3; 
    node->l2=abs(node->depth-gauche->depth)/d;
    node->l3=abs(node->depth-droit->depth)/d;
  }
  else if (comesfrom==node->v2) { 
    node->l2=abs(node->depth-node->v2->depth)/d;
    gauche=node->v1; 
    if (gauche==NULL) return;
    droit=node->v3; 
    node->l1=abs(node->depth-gauche->depth)/d;
    node->l3=abs(node->depth-droit->depth)/d;
  }
  else { 
    if (node!=root[curtreew]) node->l3=abs(node->depth-node->v3->depth)/d;
    gauche=node->v1; 
    if (gauche==NULL) return;
    droit=node->v2; 
    node->l1=abs(node->depth-gauche->depth)/d;
    node->l2=abs(node->depth-droit->depth)/d;
  }

  pseudo(node, gauche, d);
  pseudo(node, droit, d);
}
  


/* Set the lengths of branches with bootstrap support less than 
/* threshold to zero, to create multifurcating trees. */

void rateau(noeud comesfrom, noeud node, double threshold){


  if(node->v1==NULL && node->v2==NULL) return;

  if(node->b1 <= threshold && node->v1 && node->v1->v1 && node->v1->v2)
     { node->ml1=0.; node->v1->depth++; }
  if(node->b2 <= threshold && node->v2 && node->v2->v1 && node->v2->v2) 
     { node->ml2=0.; node->v2->depth++; }
  if(node->b3 <= threshold && node->v3 && node->v3->v1 && node->v3->v2) 
     { node->ml3=0.; }

  if(comesfrom==node->v1){
    rateau(node, node->v2, threshold);
    rateau(node, node->v3, threshold);
  }
  if(comesfrom==node->v2){
    rateau(node, node->v1, threshold);
    rateau(node, node->v3, threshold);
  }
  if(comesfrom==node->v3){
    rateau(node, node->v2, threshold);
    rateau(node, node->v1, threshold);
  }

}



/* abs_ord */
/* Return node whose coordinates in panel ptree are x (+/-5) */
/* and y (+/-5) if any, NULL otherwise. */

noeud abs_ord(noeud comesfrom, noeud node, int x, int y){
  noeud droit, gauche, nd1;

  if (abs(node->absc-x)<=5 && abs(node->ord-y)<=5) return node;

  if (comesfrom==node->v1) { 
    gauche=node->v2; 
    droit=node->v3; 
  }
  else if (comesfrom==node->v2) { 
    gauche=node->v1; 
    droit=node->v3; 
  }
  else { 
    gauche=node->v1; 
    droit=node->v2; 
  }
  
  if (gauche==NULL) return NULL;
  nd1=abs_ord(node, gauche, x, y);
  if (nd1) return nd1;
  return abs_ord(node, droit, x, y);
}  



/* abs_ord_br */
/* Return branch whose coordinates in panel ptree are x (+/-5) */
/* and y (+/-5) if any, NULL otherwise. */

branche abs_ord_br(noeud comesfrom, noeud node, int x, int y, int scale){
  noeud droit, gauche;
  branche br;
  double l, bo;

  if (comesfrom==node->v1) { l=node->l1; bo=node->b1; gauche=node->v2; droit=node->v3; }
  if (comesfrom==node->v2) { l=node->l2; bo=node->b2; gauche=node->v1; droit=node->v3; }
  if (comesfrom==node->v3) { l=node->l3; bo=node->b3; gauche=node->v1; droit=node->v2; }
  
  if (fabs(node->absc-x-l*scale/2)<5. && abs(node->ord-y)<=5){
    br=(branche)check_alloc(1, sizeof(struct sbranche));
    br->bout1=comesfrom;
    br->bout2=node;
    br->length=l; br->bootstrap=bo;
    return br;
  }
  if (gauche==NULL) return NULL;
  br=abs_ord_br(node, gauche, x, y, scale);
  if (br) return br;
  return abs_ord_br(node, droit, x, y, scale);
}



/* abs_ord_name */
/* Return species name whose coordinates in panel ptree include x */
/* and y if any, NULL otherwise. */

noeud abs_ord_name(noeud comesfrom, noeud node, int x, int y, int scale){
  noeud toret;
  if(!node->v1 && !node->v2){  /* periph node */
    int xinf, xsup, nbchar=0;

    xinf=node->absc+5;
    while(node->nom[nbchar++]);
    xsup=xinf+nbchar*9;
    if(x>=xinf && x<=xsup && y>=node->ord-12 && y<=node->ord+7) toret = node;
    else toret = NULL;
  }
  else{
    noeud gauche, droit;
    noeud selpnode;
    if (comesfrom==node->v1) { gauche=node->v2; droit=node->v3; }
    if (comesfrom==node->v2) { gauche=node->v1; droit=node->v3; }
    if (comesfrom==node->v3) { gauche=node->v1; droit=node->v2; }
    selpnode=abs_ord_name(node, gauche, x, y, scale);
    if(selpnode) toret = selpnode;
    else toret = abs_ord_name(node, droit, x, y, scale);
  }
  return toret;
}



/* stree_root */
/* Root s_tree stree at branch br. */

void stree_root(noeud* stree, branche br, int bl){

  noeud n1, n2, oldn1, oldn2;
  double l, bo, frac;


	/* restore old root neighbors */
  oldn1=root[curtreew]->v1; 
  if (oldn1) {
    oldn2=root[curtreew]->v2;
    if (oldn1->v1==root[curtreew])
       { oldn1->v1=root[curtreew]->v2;
         oldn1->l1=root[curtreew]->l1+root[curtreew]->l2;
         oldn1->b1=root[curtreew]->b1+root[curtreew]->b2+1; }
    if (oldn1->v2==root[curtreew]) 
       { oldn1->v2=root[curtreew]->v2;
         oldn1->l2=root[curtreew]->l1+root[curtreew]->l2;
         oldn1->b2=root[curtreew]->b1+root[curtreew]->b2+1; }
    if (oldn1->v3==root[curtreew])
       { oldn1->v3=root[curtreew]->v2;
         oldn1->l3=root[curtreew]->l1+root[curtreew]->l2;
         oldn1->b3=root[curtreew]->b1+root[curtreew]->b2+1; }
    if (oldn2->v1==root[curtreew])
       { oldn2->v1=root[curtreew]->v1;
         oldn2->l1=root[curtreew]->l1+root[curtreew]->l2;
         oldn2->b1=root[curtreew]->b1+root[curtreew]->b2+1; }
    if (oldn2->v2==root[curtreew])
       { oldn2->v2=root[curtreew]->v1;
         oldn2->l2=root[curtreew]->l1+root[curtreew]->l2;
         oldn2->b2=root[curtreew]->b1+root[curtreew]->b2+1; }
    if (oldn2->v3==root[curtreew])
      { oldn2->v3=root[curtreew]->v1;
        oldn2->l3=root[curtreew]->l1+root[curtreew]->l2;
        oldn2->b3=root[curtreew]->b1+root[curtreew]->b2+1; }
  }
   
	/* set new root, new root neighbors */

  n2=br->bout1; n1=br->bout2; l=br->length; bo=br->bootstrap;

  root[curtreew]->v1=n1; root[curtreew]->v2=n2; 

  if (n2->v1==n1)  n2->v1=root[curtreew]; 
  else if (n2->v2==n1)  n2->v2=root[curtreew]; 
  else  n2->v3=root[curtreew]; 
  if (n1->v1==n2)  n1->v1=root[curtreew]; 
  else if (n1->v2==n2)  n1->v2=root[curtreew]; 
  else  n1->v3=root[curtreew];  
 
  if(!bl){
    root[curtreew]->l1=-1.;
    root[curtreew]->l2=-1.;
    root[curtreew]->b1=bo; 
    root[curtreew]->b2=-1.;
    return;
  }

  frac=0.5+(av_length_down(root[curtreew], n2) - av_length_down(root[curtreew], n1))/(2*l);
  if (frac<0.1) frac=0.1;
  if (frac>0.9) frac=0.9;
  root[curtreew]->l1 = l*frac;
  root[curtreew]->l2 = l*(1.-frac);
  if (frac>0.5) {
      root[curtreew]->b1=bo;
      root[curtreew]->b2=-1.; }
  else {
      root[curtreew]->b2=bo;
      root[curtreew]->b1=-1.;}
  
  if (n2->v1==root[curtreew])  n2->l1=l*(1.-frac); 
  else if (n2->v2==root[curtreew])  n2->l2=l*(1.-frac); 
  else  n2->l3=l*(1.-frac); 
  if (n1->v1==root[curtreew])  n1->l1=l*frac; 
  else if (n1->v2==root[curtreew])  n1->l2=l*frac; 
  else  n1->l3=l*frac; 

}



/* parent_node */ 
/* TRUE if node neighbor (one of nd neighbors') is   */
/* between root and nd, FALSE otherwise. */

Boolean parent_node(noeud nd, noeud neighbor, int i){
  noeud nd1, nd2;
  
  if (neighbor==NULL) return FALSE;
  if (neighbor==root[i]) return TRUE;
  if (neighbor->v1==nd) { nd1=neighbor->v2; nd2=neighbor->v3; }
  if (neighbor->v2==nd) { nd1=neighbor->v1; nd2=neighbor->v3; }
  if (neighbor->v3==nd) { nd1=neighbor->v1; nd2=neighbor->v2; }

  if (nd1==root[i] || nd2==root[i]) return TRUE;
  if (nd1==NULL && nd2==NULL) return FALSE;
  return (parent_node(neighbor, nd1, i) || parent_node(neighbor, nd2, i));
}



/* vert_coord */
/* Set vertical coordinate node->ord to all nodes in tree. */

int vert_coord(noeud comesfrom, noeud node, int nb, int top, int height){
  noeud droite, gauche;
  static int periphnode=0;

  if (comesfrom==node->v1) { gauche=node->v2; droite=node->v3; }
  else if (comesfrom==node->v2) { gauche=node->v1; droite=node->v3; }
  else { gauche=node->v1; droite=node->v2; }

  if (!gauche) {
    node->ord=top+80+(++periphnode*(height-80)/(nb+1));
    return node->ord;
  }
  
  node->ord=0.5*(vert_coord(node, gauche, nb, top, height)+
                 vert_coord(node, droite, nb, top, height));
  if (node==root[curtreew]) periphnode=0;
  return node->ord;
}



/* change_blbutton */

void change_blbutton(int i){
  char* titre;
  titre=(char*)check_alloc(100, sizeof(char));
  GetTitle(blvalue[i], titre, 100);
  if (strncmp(titre, "No", 2)==0) SetTitle(blvalue[i], " Branch Lengths ");
  else SetTitle(blvalue[i], "No Branch Length");
  free(titre);
  return;
}



/* change_bsbutton */

void change_bsbutton(int i){
  char titre[100];
  
  GetTitle(bsvalue[i], titre, 100);
  if (strncmp(titre, "No", 2)==0) SetTitle(bsvalue[i], "Bootstrap");
  else SetTitle(bsvalue[i], "No Bootstrap");
}



/* bl_act */

void bl_act(ButtoN but){
  drawtreedata data;  int i=-1;

  while(i<=MAXTREEW) if (but==blvalue[++i]) break;

  GetPanelExtra(ptree[i], &data);
  data.branchlength=!data.branchlength;
  data.squarenode=data.squarebranch=data.squareintbranch=FALSE;
  SetPanelExtra(ptree[i], &data);
  change_blbutton(i);
  if(GetValue(treemodgr[curtreew])<4) SetValue(treemodgr[curtreew], 0);
  ptreedraw(ptree[i]);
}



/* bs_act */

void bs_act(ButtoN but){
  drawtreedata data;
  int i=-1;

  while(i<=MAXTREEW) if (but==bsvalue[++i]) break;
  
  GetPanelExtra(ptree[i], &data);
  data.bootstrap=!data.bootstrap;
  data.squarenode=data.squarebranch=data.squareintbranch=FALSE;
  SetPanelExtra(ptree[i], &data);
  change_bsbutton(i);
  if(GetValue(treemodgr[curtreew])<4) SetValue(treemodgr[curtreew], 0);
  ptreedraw(ptree[i]);
}



/* organize */
/* Organize rooted stree so that for any node nd->v3=parent */

void organize(noeud from, noeud nd){
  noeud prov;
  double lprov, bprov;

  if(!nd->v1) return;
  if(from==nd->v1) {
    prov=nd->v3; nd->v3=nd->v1; nd->v1=prov;
    lprov=nd->l3; nd->l3=nd->l1; nd->l1=lprov;
    bprov=nd->b3; nd->b3=nd->b1; nd->b1=bprov;
  }
  if(from==nd->v2) {
    prov=nd->v3; nd->v3=nd->v2; nd->v2=prov;
    lprov=nd->l3; nd->l3=nd->l2; nd->l2=lprov;
    bprov=nd->b3; nd->b3=nd->b2; nd->b2=bprov;
  }
  organize(nd, nd->v1);
  organize(nd, nd->v2);
}




/* combcan */
/* Cancel branche combining */

void combcan(void){
  
  int i, nb;
  drawtreedata data;

  GetPanelExtra(ptree[curtreew], &data);
  nb=data.nb;

  for(i=0;i<2*nb-2;i++){
    data.s_tree[i]->selected=0;
    data.s_tree[i]->color=0;
  }
  root[curtreew]->color=0;
  
  free(data.header);
  data.header=provhead;
  data.squareintbranch=FALSE;  
  data.squarebranch=FALSE;  
  data.squarenode=FALSE;  
  SetPanelExtra(ptree[curtreew], &data);
  ptreedraw(ptree[curtreew]);

  Enable(comb[curtreew]);
  Enable(bsvalue[curtreew]);
  if(blvalue[curtreew]) Enable(blvalue[curtreew]);
  Enable(savetree[curtreew]);
  Enable(createbut[curtreew]);
  Enable(prfile[curtreew]);
  Enable(treemodgr[curtreew]);
  SetTitle(comb[curtreew], "Combine");
}




/* compute_comb */

void compute_comb(void){

  int i, j, nb, lbranche;
  int *combbranche, *mask, *listet1, *listet2, *listnon, bootval;
  drawtreedata data;
  double combboot=0.;

  GetPanelExtra(ptree[curtreew], &data);
  nb=data.nb;  
  lbranche=(nb+lmot-1)/lmot;
  combbranche=(int*)check_alloc(lbranche, sizeof(int));
  mask=(int*)check_alloc(lbranche, sizeof(int));
  listet1=(int*)check_alloc(lbranche, sizeof(int));
  listet2=(int*)check_alloc(lbranche, sizeof(int));
  listnon=(int*)check_alloc(lbranche, sizeof(int));
  for(i=0;i<lbranche;i++) combbranche[i]=mask[i]=0;

  for(i=0;i<data.llist1;i++) {
    for(j=0;j<nb;j++){
      if(samename(data.list1[i], data.treename[j])){
        bit1(combbranche, j+1);
        bit1(mask, j+1);
        break;
      }
    }
  }

  for(i=0;i<data.llist2;i++) {
    for(j=0;j<nb;j++){
      if(samename(data.list2[i], data.treename[j])){
        bit1(mask, j+1);
        break;
      }
    }
  }

  j=(nb-3)*data.nbrep;
  for(i=0;i<j;i++){
    et(listet1, data.bootptr[i], mask, lbranche); 
    non(listnon, data.bootptr[i], lbranche);
    et(listet2, listnon, mask, lbranche); 
    if(memebranche(combbranche, listet1, lbranche, nb) ||
       memebranche(combbranche, listet2, lbranche, nb)){
      combboot++; 
      i=(1+i/(nb-3))*(nb-3)-1;
    }
  }

  combboot/=data.nbrep;
  bootval=(int)(combboot*100+0.5);
  (void) sprintf(data.header,"\n            Bootstrap support : %d%%\n\n",bootval);
  (void) strcat(data.header,"      Click on a branch to combine\n");
  (void) strcat(data.header,"      Click on a coloured name to remove it");
  SetPanelExtra(ptree[curtreew], &data);
  free(combbranche);
  free(mask);
  free(listet1);
  free(listet2);
  free(listnon);
}




/* listdown */
/* Write names of tips down to nd in list */

void listdown(noeud from, noeud nd, char** list, int* llist, int color){
  noeud nd1, nd2;

  nd->color=color;
  if(!nd->v1){
    (*llist) ++;
    list[*llist-1]=(char*)check_alloc(MAXLNAME+1, sizeof(char));
    (void) sprintf(list[*llist-1], "%s", nd->nom);
    return;
  }

  if(from==nd->v1) { nd1=nd->v2; nd2=nd->v3; }
  if(from==nd->v2) { nd1=nd->v1; nd2=nd->v3; }
  if(from==nd->v3) { nd1=nd->v1; nd2=nd->v2; }

  if(nd1) listdown(nd, nd1, list, llist, color);
  if(nd2) listdown(nd, nd2, list, llist, color);
}



/* makelist */
/* Make 2 lists of names from one list of adjacent branches */

void makelist(branche* listbr, int nbbr, int* llist1, char** list1, int* llist2, char** list2){
  
  int i, j, flag1,flag2;
  branche br1=NULL, br2=NULL;
  noeud nd1in, nd1out, nd2in, nd2out;


  for(i=0;i<nbbr;i++){
    flag1=flag2=0;
    for(j=0;j<nbbr;j++){
      if(j!=i){
        if(listbr[i]->bout1==listbr[j]->bout1) flag1=1;
        if(listbr[i]->bout1==listbr[j]->bout2) flag1=1; 
        if(listbr[i]->bout2==listbr[j]->bout1) flag2=1; 
        if(listbr[i]->bout2==listbr[j]->bout2) flag2=1; 
        if(flag1 && flag2) break;
      }
    }
    if(!flag1){
      if(!br1) {br1=listbr[i]; nd1in=br1->bout2; nd1out=br1->bout1;}
      else if(!br2) {br2=listbr[i]; nd2in=br2->bout2; nd2out=br2->bout1;}
    }
    if(!flag2){
      if(!br1) {br1=listbr[i]; nd1in=br1->bout1; nd1out=br1->bout2;}
      else if(!br2) {br2=listbr[i]; nd2in=br2->bout1; nd2out=br2->bout2;}
    }
    if(br1 && br2) break;
  }

  listdown(nd1in, nd1out, list1, llist1, 1);
  listdown(nd2in, nd2out, list2, llist2, 2);
  
}


/* internal_nd */
/* TRUE if node nd is internal, FALSE otherwise. */

Boolean internal_nd(noeud nd){
 
  if(!nd) return FALSE;
  if(!nd->v1) return FALSE;
  if(!nd->v2) return FALSE;
  if(nd==root[curtreew]) return (internal_nd(nd->v1) && internal_nd(nd->v2));
  return TRUE;
}


/* internal_br */
/* TRUE if parent branch of node nd is internal, FALSE otherwise. */

Boolean internal_br(noeud nd){
 
  if(!nd) return FALSE;
  if(!nd->v1) return FALSE;
  if(!nd->v2) return FALSE;
  if(nd==root[curtreew]) return FALSE;
  if(nd->v3==root[curtreew]){
    if(!root[curtreew]->v1->v1) return FALSE;
    if(!root[curtreew]->v2->v1) return FALSE;
  }
  return TRUE;
}



/* smoothtreecol */

int smoothtreecol(noeud from, noeud nd){
  noeud nd1, nd2;
  int col1, col2;

  if(from==nd->v1) { nd1=nd->v2; nd2=nd->v3; }
  if(from==nd->v2) { nd1=nd->v1; nd2=nd->v3; }
  if(from==nd->v3) { nd1=nd->v1; nd2=nd->v2; }
  
  if(!nd1) return nd->color;
  
  col1=smoothtreecol(nd, nd1);
  col2=smoothtreecol(nd, nd2);
  if(!col1 && !col2) nd->color=0;
  return nd->color;
}



/* smoothtreesel */

int smoothtreesel(noeud from, noeud nd){
  noeud nd1, nd2;
  int sel1, sel2;

  if(from==nd->v1) { nd1=nd->v2; nd2=nd->v3; }
  if(from==nd->v2) { nd1=nd->v1; nd2=nd->v3; }
  if(from==nd->v3) { nd1=nd->v1; nd2=nd->v2; }
  
  if(!nd1) return nd->color;
  
  sel1=smoothtreesel(nd, nd1);
  sel2=smoothtreesel(nd, nd2);
  if(!sel1 && !sel2) nd->selected=0;
  return nd->selected;
}



/* ptreecomb */

void ptreecomb(PaneL p, PoinT pt){
  drawtreedata data;
  int x, y, i=-1, j, nb;
  noeud nd1, nd2, prov;
  Boolean ROOTSEL=FALSE;
  noeud selpnode;

  
  while(i<=MAXTREEW) if(p==ptree[++i]) break;
  curtreew=i;

  GetPanelExtra(ptree[curtreew], &data);
  nb=data.nb;
  x=pt.x; y=pt.y;
  selpnode=abs_ord_name(NULL, root[curtreew], x, y, data.scale);
  if(selpnode){
    int flag;
    if(selpnode->color==0) return;
    flag=0;
    for(i=0;i<data.llist1;i++){
      if(samename(selpnode->nom, data.list1[i])){
        for(j=i;j<data.llist1-1;j++) data.list1[j]=data.list1[j+1];
	data.list1[data.llist1-1]=NULL;
	data.llist1--; flag=1;
        break;
      }
    }
    if(!flag){
      for(i=0;i<data.llist2;i++){
        if(samename(selpnode->nom, data.list2[i])){
          for(j=i;j<data.llist2-1;j++) data.list2[j]=data.list2[j+1];
	  data.list2[data.llist2-1]=NULL;
	  data.llist2--;
          break;
        }
      }
    }
    /*selpnode->selected=0;*/
    selpnode->color=0;
    (void) smoothtreecol(NULL, root[curtreew]);
    /* smoothtreesel(NULL, root[curtreew]); */
    SetPanelExtra(ptree[curtreew], &data);
    compute_comb();
    ptreedraw(ptree[curtreew]);
    return;
  }
  if (!(brcomb[++nbcomb]=abs_ord_br(NULL, root[curtreew], x, y, data.scale))) {nbcomb--; return;}
  nd1=brcomb[nbcomb]->bout1; nd2=brcomb[nbcomb]->bout2;
  if(nd1->v3==nd2) { prov=nd1; nd1=nd2; nd2=prov; }
  if(nd2->selected!=1) {nbcomb--; return;}
  if (NOSELECTION)
    for(i=0;i<2*nb-2;i++) data.s_tree[i]->selected=0;
  if((!PERIPHSEL || internal_br(nd1)) && !nd1->selected) nd1->selected=1;
  if(nd1==root[curtreew]){
    ROOTSEL=TRUE;
    nbcomb++;
    brcomb[nbcomb]=(branche)check_alloc(1, sizeof(struct sbranche));
    brcomb[nbcomb]->bout1=nd1;
    nd1->selected=2;
    if(nd1->v1==nd2) nd1=nd1->v2;
    else nd1=nd1->v1;
    nd1->selected=2;
    brcomb[nbcomb]->bout2=nd1;
  }
  for(i=0;i<data.llist1;i++) free(data.list1[i]);
  for(i=0;i<data.llist2;i++) free(data.list2[i]);
  data.llist1=data.llist2=0;
  for(i=0;i<2*nb-2;i++) data.s_tree[i]->color=0;
  root[curtreew]->color=0;
  makelist(brcomb, nbcomb+1, &(data.llist1), data.list1, &(data.llist2), data.list2);
  if(nd1->v1 && (!PERIPHSEL || internal_br(nd1->v1)) && !nd1->v1->selected) nd1->v1->selected=1;
  if(nd1->v2 && (!PERIPHSEL || internal_br(nd1->v2)) && !nd1->v2->selected) nd1->v2->selected=1;
  if(nd2->v1 && (!PERIPHSEL || internal_br(nd2->v1)) && !nd2->v1->selected) nd2->v1->selected=1;
  if(nd2->v2 && (!PERIPHSEL || internal_br(nd2->v2)) && !nd2->v2->selected) nd2->v2->selected=1;
  nd2->selected=2;
  if(nd1->v1 && nd1->v1->selected==2 && nd1->v2->selected==2 && nd1->selected==1) nd1->selected=0;
  if(nd1->v1 && nd1->selected==2 && !ROOTSEL) if(nd1->v1==nd2) 
      nd1->v2->selected=0; else nd1->v1->selected=0;
  if(nd2->v1 && nd2->v1->selected==2) nd2->v2->selected=0;
  if(nd2->v2 && nd2->v2->selected==2) nd2->v1->selected=0;
  if(PERIPHSEL) for(i=0;i<nb;i++) if(data.s_tree[i]->selected==1) data.s_tree[i]->selected=0;
  SetPanelExtra(ptree[curtreew], &data);
  NOSELECTION=FALSE;
  compute_comb();
  ptreedraw(ptree[curtreew]);
}




/* comb_act */

 void comb_act(ButtoN but){
  drawtreedata data;
  int i=-1, nb;

  while(i<=MAXTREEW) if(but==comb[++i]) break;
  curtreew=i;
  if(COMBB) { combcan(); COMBB=FALSE; return; }
  COMBB=TRUE;
  SetTitle(comb[curtreew], "CANCEL");
  GetPanelExtra(ptree[curtreew], &data);
  provhead=data.header;
  data.header=(char*)check_alloc(500, sizeof(char));
  (void) sprintf(data.header, "\n\n            Select   adjacent   branches\n\n");
  data.squarenode=FALSE;
  data.squarebranch=TRUE;
  data.squareintbranch=TRUE;
  if (data.branchlength) { data.branchlength=FALSE; change_blbutton(curtreew); }      
  if (data.bootstrap) { data.bootstrap=FALSE; change_bsbutton(curtreew); }         
  SetPanelExtra(ptree[curtreew], &data);
  nb=data.nb;

  for(i=0;i<2*nb-2;i++) data.s_tree[i]->selected=1;
  if(root[curtreew]->v1->selected && root[curtreew]->v2->selected) 
    root[curtreew]->v1->selected=0;
  PERIPHSEL=FALSE;
  ptreedraw(ptree[curtreew]);

  Disable(treemodgr[curtreew]);
  Disable(bsvalue[curtreew]);
  if(Enabled(blvalue[curtreew])) Disable(blvalue[curtreew]);
  Disable(savetree[curtreew]);
  Disable(createbut[curtreew]);
  Disable(prfile[curtreew]);
  nbcomb=-1;
  SetPanelClick(ptree[curtreew], ptreecomb, NULL, NULL, NULL);
  NOSELECTION=TRUE;

}



/* ptreeswap */
/* Swap node procedure */

void ptreeswap(PaneL p, PoinT pt){
  int x, y, i=-1;
  noeud nd, provnd;
  double prov;
  drawtreedata data;

  while(i<=MAXTREEW) if (p==ptree[++i]) break;

  GetPanelExtra(ptree[i], &data);
  x=pt.x; y=pt.y; 

  if (!(nd=abs_ord(NULL, root[i], x, y))) return;
  if (nd==NULL) return;
  if (nd==root[i]) {
    if (!root[i]->v1) {
      provnd=root[i]->v2; root[i]->v2=root[i]->v3; root[i]->v3=provnd; 
      prov=root[i]->l2; nd->l2=nd->l3; nd->l3=prov;
      prov=root[i]->b2; nd->b2=nd->b3; nd->b3=prov;
    } 
    else if (!root[i]->v2) {
      provnd=root[i]->v1; root[i]->v1=root[i]->v3; root[i]->v3=provnd; 
      prov=root[i]->l1; nd->l1=nd->l3; nd->l3=prov;
      prov=root[i]->b1; nd->b1=nd->b3; nd->b3=prov;
    }
    else {
      provnd=root[i]->v1; root[i]->v1=root[i]->v2; root[i]->v2=provnd; 
      prov=root[i]->l1; nd->l1=nd->l2; nd->l2=prov;
      prov=root[i]->b1; nd->b1=nd->b2; nd->b2=prov;
    }
  }

  else if (parent_node(nd, nd->v1, i)) {
    provnd=nd->v2; nd->v2=nd->v3; nd->v3=provnd; 
    prov=nd->l2; nd->l2=nd->l3; nd->l3=prov;
    prov=nd->b2; nd->b2=nd->b3; nd->b3=prov;
  }
  else if (parent_node(nd, nd->v2, i)) {
    provnd=nd->v1; nd->v1=nd->v3; nd->v3=provnd; 
    prov=nd->l1; nd->l1=nd->l3; nd->l3=prov;
    prov=nd->b1; nd->b1=nd->b3; nd->b3=prov;
  }
  else {
    provnd=nd->v1; nd->v1=nd->v2;nd->v2=provnd; 
    prov=nd->l1; nd->l1=nd->l2; nd->l2=prov;
    prov=nd->b1; nd->b1=nd->b2; nd->b2=prov;
  }
  
  SetPanelExtra(ptree[i], &data);
  ptreedraw(ptree[i]);
}



/* ptreesub */
/* Subtree procedure */

void ptreesub(PaneL p, PoinT pt){
  int i=-1, x, y;
  noeud nd;
  drawtreedata data;

  while(i<=MAXTREEW) if (p==ptree[++i]) break;

  GetPanelExtra(ptree[i], &data);
  x=pt.x; y=pt.y; 

  if (!(nd=abs_ord(NULL, root[i], x, y))) return;
  if (nd==root[i]) return;
  if (root[i]!=memroot[i]) {
    if (root[i]->v1==NULL) root[i]->v1=parent[i];
    if (root[i]->v2==NULL) root[i]->v2=parent[i];
    if (root[i]->v3==NULL) root[i]->v3=parent[i];
  }     

  if (parent_node(nd, nd->v1, i)) {
      parent[i]=nd->v1; data.nb=nb_leaves_down(parent[i], nd); nd->v1=NULL; }
  else if (parent_node(nd, nd->v2, i)) {
      parent[i]=nd->v2; data.nb=nb_leaves_down(parent[i], nd); nd->v2=NULL; }
  else { 
      parent[i]=nd->v3; data.nb=nb_leaves_down(parent[i], nd); nd->v3=NULL; }
  root[i]=nd;

  SetPanelExtra(ptree[i], &data);
  ptreedraw(ptree[i]);

}
  


/* ptreenew */
/* New Outgroup procedure */

void ptreenew(PaneL p, PoinT pt){
  int i=-1, x, y;
  branche br;
  drawtreedata data;

  while(i<=MAXTREEW) if (p==ptree[++i]) break;

  GetPanelExtra(ptree[i], &data);
  x=pt.x; y=pt.y; 

  if (!(br=abs_ord_br(NULL, root[i], x, y, data.scale))) return;
  curtreew=i;
  stree_root(data.s_tree, br, 1);
  organize(NULL, root[i]);
  memroot[i]=root[i];
  ptreedraw(ptree[i]);
}
  


/* treemod_act */
/* Callback procedure for radio buttons treemod. */

void treemod_act(GrouP gr){
  int i, j=-1;
  drawtreedata data;

  while (j<=MAXTREEW) if (gr==treemodgr[++j]) break;

  GetPanelExtra(ptree[j], &data);

  i=GetValue(gr);
  switch(i){
    case 0 : 
    case 1 : 
      data.squarenode=FALSE;
      data.squarebranch=FALSE;
      data.squareintbranch=FALSE;
      if (root[j]!=memroot[j]) {
	if (root[j]->v1==NULL) root[j]->v1=parent[j];
	if (root[j]->v2==NULL) root[j]->v2=parent[j];
	if (root[j]->v3==NULL) root[j]->v3=parent[j];
        root[j]=memroot[j];
      }
      data.nb=memnb[j];
      SetPanelClick(ptree[j], NULL, NULL, NULL, NULL);
      Enable(createbut[curtreew]); Enable(savetree[curtreew]); Enable(prfile[curtreew]);
      break;
    case 2 :
      if (root[j]!=memroot[j]) {
	if (root[j]->v1==NULL) root[j]->v1=parent[j];
	if (root[j]->v2==NULL) root[j]->v2=parent[j];
	if (root[j]->v3==NULL) root[j]->v3=parent[j];
      }      
      data.squarenode=TRUE; 
      data.squarebranch=FALSE;
      data.squareintbranch=FALSE;
      if (data.branchlength) { data.branchlength=FALSE; change_blbutton(j); }      
      if (data.bootstrap) { data.bootstrap=FALSE; change_bsbutton(j); }      
      SetPanelClick(ptree[j], ptreeswap, NULL, NULL, NULL);
      break;
    case 3 :
      if (root[j]!=memroot[j]) {
	if (root[j]->v1==NULL) root[j]->v1=parent[j];
	if (root[j]->v2==NULL) root[j]->v2=parent[j];
	if (root[j]->v3==NULL) root[j]->v3=parent[j];
        root[j]=memroot[j];
      }      
      data.nb=memnb[j];
      data.squarenode=FALSE;
      data.squarebranch=TRUE;
      data.squareintbranch=FALSE;
      if (data.branchlength) { data.branchlength=FALSE; change_blbutton(j); }
      if (data.bootstrap) { data.bootstrap=FALSE; change_bsbutton(j); }
      SetPanelClick(ptree[j], ptreenew, NULL, NULL, NULL);
      break;      
    case 4 : 
      data.squarenode=TRUE; 
      data.squarebranch=FALSE;
      data.squareintbranch=FALSE;
      if (data.branchlength) { data.branchlength=FALSE; change_blbutton(j); }
      if (data.bootstrap) { data.bootstrap=FALSE; change_bsbutton(j); }
      SetPanelClick(ptree[j], ptreesub, NULL, NULL, NULL);
      Disable(createbut[curtreew]); Disable(savetree[curtreew]); Disable(prfile[curtreew]);
  }
  SetPanelExtra(ptree[j], &data);
  ptreedraw(ptree[j]);
}



/* inv_droite_gauche */

void inv_droite_gauche(noeud* droite, noeud* gauche,
  double* ld, double* lg, double* bd, double* bg){
  
  noeud nprov;
  double dprov;

  nprov=*droite; 
  *droite=*gauche; 
  *gauche=nprov;
  dprov=*ld; *ld=*lg; *lg=dprov;
  dprov=*bd; *bd=*bg; *bg=dprov;
}



/* drawsubtree */

void drawsubtree(noeud comesfrom, noeud node, PoinT pt,
    int width, int scale, Boolean bl, Boolean bs,
    Boolean sn, Boolean sb, Boolean sib, Boolean noneg){
  noeud droite, gauche;
  double ld, lg, bd, bg;
  int x, ild, ilg, ibd, ibg;
  char length[10];
  PoinT ptd, ptg;
  Boolean ROOTOK=FALSE, ALLPETIT;


  ALLPETIT=GetStatus(smti);

  if (comesfrom==node->v1) {
    droite=node->v2; gauche=node->v3; ld=node->l2; lg=node->l3; bd=node->b2; bg=node->b3;}
  else if (comesfrom==node->v2) {
    droite=node->v1; gauche=node->v3; ld=node->l1; lg=node->l3; bd=node->b1; bg=node->b3; }
  else {
    droite=node->v1; gauche=node->v2; ld=node->l1; lg=node->l2;  bd=node->b1; bg=node->b2;}

  if(droite && droite->ord>gauche->ord)
    inv_droite_gauche(&droite, &gauche, &ld, &lg, &bd, &bg); 

  if(sib){
    if(node->color==1) Blue();
    else if(node->color==2) Red();
    else Gray();
  }

  if (gauche==NULL) {
    pt.x+=5;
    pt.y+=5;
    SetPen(pt);
    PaintString(node->nom);
    return;
  }

  x=pt.x;
  ilg=(int)(lg*scale);
  ild=(int)(ld*scale);
  if(noneg && ilg<0) ilg=5;
  if(noneg && ild<0) ild=5;
  gauche->absc=x+ilg;
  droite->absc=x+ild;
  
  Black();

  if (sn){  /* square nodes */
    RecT rect;
    rect.top=pt.y-5; rect.bottom=pt.y+5;
    rect.left=x-5; rect.right=x+5;
    PaintRect(&rect);
  }  

  if(sib){
    if(node->color==1) Blue();
    else if(node->color==2) Red();
    else Gray();
  }

    /* vertical line */
  ptg.x=ptd.x=pt.x;
  ptg.y=gauche->ord;
  ptd.y=droite->ord;
  pt.y=0.5*(ptd.y+ptg.y);
  if(sib){
    if(droite->color==1) Blue();
    else if(droite->color==2) Red();
    else Gray();
  }
  DrawLine(ptd, pt); 
  if(sib){
    if(gauche->color==1) Blue();
    else if(gauche->color==2) Red();
    else Gray();
  }
  DrawLine(ptg, pt);
  if(sib && gauche->selected==2 && (node->selected==2 || droite->selected==2)){
    Black();
    DrawLine(ptg, pt);
    pt.x++; ptg.x++; DrawLine(ptg, pt); 
    pt.x-=2; ptg.x-=2; DrawLine(ptg, pt);
    ptg.x++; pt.x++;
  }
  if(sib && droite->selected==2 && (node->selected==2 || gauche->selected==2)){
    Black();
    DrawLine(ptd, pt); 
    pt.x++; ptd.x++; DrawLine(ptd, pt); 
    pt.x-=2; ptd.x-=2; DrawLine(ptd, pt);
    ptd.x++; pt.x++;
  }

  if(sib){
    if(node->color==1) Blue();
    else if(node->color==2) Red();
    else Gray();
  }

    /* horizontal left line */ 
  ptg.x+=ilg;
  pt.y=ptg.y; 
  if(sib){
    if(gauche->color==1) Blue();
    else if(gauche->color==2) Red();
    else Gray();
  }
  DrawLine(pt, ptg); 
  if(sib && gauche->selected==2){
    Black();
    DrawLine(ptg, pt);
    pt.y++; ptg.y++; DrawLine(pt, ptg);
    pt.y-=2; ptg.y-=2; DrawLine(pt, ptg);
    ptg.y++;
  }

  if(sib){
    if(node->color==1) Blue();
    else if(node->color==2) Red();
    else Gray();
  }

    /* horizontal right line */  
  if(sib){
    if(droite->color==1) Blue();
    else if(droite->color==2) Red();
    else Gray();
  }
  ptd.x+=ild;
  pt.y=ptd.y; 
  DrawLine(pt, ptd); 
  if(sib && droite->selected==2){
    Black();
    DrawLine(ptd, pt); 
    pt.y++; ptd.y++; DrawLine(pt, ptd);
    pt.y-=2; ptd.y-=2; DrawLine(pt, ptd);
    ptd.y++;
  }

  Black();

  if ((sb && node!=root[curtreew]) || sib ){  /* square branches */
    RecT rect;
    rect.top=ptd.y-5; rect.bottom=ptd.y+5;
    rect.left=x+ild/2-5; rect.right=rect.left+10;
    if(!sib ||(sib && droite->selected==1)) { 
      PaintRect(&rect); 
      if(node==root[curtreew]) ROOTOK=TRUE;
    }
    rect.top=ptg.y-5; rect.bottom=ptg.y+5;
    rect.left=x+ilg/2-5; rect.right=rect.left+10;
    if(!sib || (sib && gauche->selected==1 && !ROOTOK)) PaintRect(&rect);
  }


    /* branch lengths */
  if (bl) {
    Boolean GROS=TRUE;

    Blue();
    SelectFont(gros);
    if (abs(ild)<width/10 || ALLPETIT){
      SelectFont(petit);
      GROS=FALSE;
    }
    if (ild>25 || ld<0.){
      pt.x=(droite->absc+x)/2-14; pt.y=ptd.y-3; SetPen(pt);
      if(ld<0.) Red();
      (void) sprintf(length, "%.3f", ld); 
      PaintString(length);
      if(ld<0.) Blue();
    }

    if (ilg>25 || lg<0.) {
      if (!GROS && ilg>width/10 && !ALLPETIT)
        SelectFont(gros); 
      else if (GROS && ilg<width/10 || ALLPETIT)
        SelectFont(petit); 
      pt.x=(gauche->absc+x)/2-14; pt.y=ptg.y-3; SetPen(pt);
      if(lg<0.) Red();
      (void) sprintf(length, "%.3f", lg);
      PaintString(length);
      if(lg<0.) Black();
    }
    SelectFont(gras);
    if (!bs) Black();
  }


	/* bootstrap circled values */
  if (bs) {
    RecT rect;
    Boolean GROS=TRUE;

    Red();
    SelectFont(gros);
    if (ild<width/10 || ALLPETIT){
      SelectFont(petit);
      GROS=FALSE;
    }
    if (bd>=0.){
      if(bd-(int)bd<0.5) ibd=(int)bd; else ibd=(int)bd+1;
      pt.x=droite->absc-16; 
      if(bl && ild>25) pt.y=ptd.y+16; else pt.y=ptd.y-6; if (ibd==100) pt.x-=8; 
      if (GROS) { pt.x-=5; if(bl && ild>25) pt.y++; else pt.y--; } 
      SetPen(pt);
      (void) sprintf(length, "%d", ibd); 
      PaintString(length);
      rect.left=pt.x-4; rect.right=pt.x+16; 
      if (GROS && !SMALLSCREEN) {rect.left-=1; rect.right+=5;} if (ibd==100) rect.right+=8;
      rect.bottom=pt.y+5; rect.top=pt.y-14;
      if (GROS && !SMALLSCREEN) {rect.top-=2; rect.bottom++;}
      FrameOval(&rect); 
    }
    if (bg>=0.){
      if(bg-(int)bg<0.5) ibg=(int)bg; else ibg=(int)bg+1;
      if (!GROS && ilg>width/10 && !ALLPETIT){
        SelectFont(gros); GROS=TRUE; }
      else if (GROS && ilg<width/10 || ALLPETIT){
        SelectFont(petit); GROS=FALSE; }
      pt.x=gauche->absc-16; pt.y=ptg.y+16; if (bg==100) pt.x-=8; 
      if (GROS) { pt.x-=5; pt.y+=1; } 
      SetPen(pt);
      (void) sprintf(length, "%d", ibg); 
      PaintString(length);
      rect.left=pt.x-4; rect.right=pt.x+16;
      if (GROS && !SMALLSCREEN) {rect.left-=1; rect.right+=5;} if (ibg==100) rect.right+=8;
      rect.bottom=pt.y+5; rect.top=pt.y-14;
      if (GROS && !SMALLSCREEN) {rect.top-=2; rect.bottom++;}
      FrameOval(&rect);
    }
    Black();
    SelectFont(gras);
  }

  drawsubtree(node, gauche, ptg, width, scale, bl, bs, sn, sb, sib, noneg);
  drawsubtree(node, droite, ptd, width, scale, bl, bs, sn, sb, sib, noneg);
}



/* ptreedraw */
/* Drawing procedure for panels ptree */

void ptreedraw(PaneL p){
  RecT r;
  PoinT pt, pt2;
  char *c, lg_string[10], *prov;
  double lgbar;
  int i=-1, ii, l, nb, maxlname;
  drawtreedata data;

  c=(char*)check_alloc(200, sizeof(char));

  White(); InvertColors(); Black();
  GetPanelExtra(p, &data);
  i=data.indice;
  curtreew=i;
  nb=data.nb;
  SelectFont(data.font);
  Select(p);
  ObjectRect(p, &r);
  EraseRect(&r);
  FrameRect(&r);

  pt.y=r.top+15; pt.x=r.left+10;
  SetPen(pt);
  
  prov=data.header;
  if(data.squareintbranch) SelectFont(titlefont);
  while(*(prov+1)){
    ii=0;
    while(prov[ii]!='\n' && ii<198){
      c[ii]=prov[ii];
      ii++;
    }
    c[ii]='\0';
    PaintString(c);
    pt.y+=LineHeight();
    SetPen(pt);
    prov+=ii+1;
  }
  if(data.squareintbranch) SelectFont(data.font);

  if(data.sce>-0.5){
    pt.x=r.left+15;
    pt.y=r.bottom-10;
    SetPen(pt);
    
    (void) sprintf(c, "SSR : %f      total length : %.4f", data.sce, data.tot);
    PaintString(c);
  }

  if  (data.pseudo){
    double d;
    d=(double)depth(NULL, root[i]);
    pseudo(NULL, root[i], d);
  }



  maxlname=0;
  for(ii=0;ii<nb;ii++){ l=(int)strlen(data.s_tree[ii]->nom); if(l>maxlname) maxlname=l; }
  data.scale=(int)((data.width-12.*maxlname)/max_length_down(NULL, root[i]));

  if (!data.pseudo){
    pt.x=r.right-130; pt2.x=r.right-30;
    pt.y=pt2.y=r.top+50;
    DrawLine(pt, pt2);
    pt.x+=100; pt.y+=5; pt2.y-=5;
    DrawLine(pt, pt2);
    pt.x-=100; pt2.x-=100;
    DrawLine(pt, pt2);
    lgbar=100./data.scale;
    (void) sprintf(lg_string, "%.3f",lgbar);
    pt.y-=10; pt.x+=27; SetPen(pt);
    PaintString(lg_string);
  }

  (void) vert_coord(NULL, root[i], nb, r.top, data.height);
  root[i]->absc=pt.x=r.left+10;
  pt.y=root[i]->ord;

  SetPanelExtra(p, &data);
  drawsubtree(NULL, root[i], pt, data.width, data.scale,
     data.branchlength, data.bootstrap, data.squarenode,
     data.squarebranch, data.squareintbranch, data.nonegativebranch);
  free(c);
  return;
}




/* storetree */
/* Store drawn tree */

void storetree(ButtoN but){
  drawtreedata data;
  printdata databuild;
  char* prov1, *milieu;
  char *pbuildlines[MAXTREE];
  int i, nb;

  GetPanelExtra(ptree[curtreew], &data);
  GetPanelExtra(pbuild, &databuild);
  for(i=0;i<nbtree;i++) pbuildlines[i]=databuild.lignes[i];

  pbuildlines[nbtree]=(char*)check_alloc(24, sizeof(char));
  nb=data.nb;
  prov1=(char*)check_alloc(50*(1+nb), sizeof(char));

  memtreename[nbtree]=(char*)check_alloc(30, sizeof(char));
  memtree[nbtree]=(char*)check_alloc(50*nb+(int)strlen(data.header), sizeof(char));

  GetTitle(messtext, memtreename[nbtree], 30);
  (void) sprintf(memtreename[nbtree]+(int)strlen(memtreename[nbtree]), "(%d)", data.nb);
  (void) sprintf(pbuildlines[nbtree], "%.24s", memtreename[nbtree]);

  (void) sprintf(memtree[nbtree], "[%s]", data.header);
  milieu=memtree[nbtree]+(int)strlen(memtree[nbtree]);
  tree_stoc(data.s_tree, 1, nb, prov1);
  if (data.pseudo) ctree_nobl(prov1, milieu, (int)strlen(prov1));
  else (void) sprintf(milieu, "%s", prov1);
  nbtree++;
  initpanel(pbuild, pbuildlines, nbtree, 0, NULL);
  settotlignes(pbuild, nbtree);
  draw(pbuild);
  Enable(savetree[curtreew]); Enable(quittree[curtreew]);
  (void) Remove(messw); messw=NULL;
  CHANGESDONE=TRUE;
  free(prov1);
}



/* quitstorewin */

void quitstorewin(ButtoN but){
  (void) Remove(messw); messw=NULL;
  Enable(savetree[curtreew]); Enable(quittree[curtreew]);
}



/* store_act */
/* Callback procedure for STORE button in tree window. */

void store_act(ButtoN but){
  char text[12];
  int i=-1;

  while(i<=MAXTREEW) if(but==savetree[++i]) break;
  curtreew=i;

  Disable(savetree[i]); Disable(quittree[i]);
  (void) sprintf(text, "Tree name ?");
  createmessbox(text, TRUE, storetree, quitstorewin);
}



/* quittreewin */

void quittreewin(ButtoN but){
  int i=-1;
  drawtreedata data;

  while(i<=MAXTREEW) if(but==quittree[++i]) break;
  curtreew=i;
  openedtreew[curtreew]=FALSE;
  GetPanelExtra(ptree[curtreew], &data);
  if(data.bootptr)
    if(!--*(data.bootptr[data.nbrep*(data.nb-3)]))
      for(i=0;i<data.nbrep*(data.nb-3);i++) free(data.bootptr[i]);
  nbtreew--;
  SetTitle(bdt, SMALLSCREEN?"BUILD":"MAKE TREE");
  (void) Remove(ParentWindow(but)); 
}



/* quitwin_w */

void quitwin_w(WindoW win){
  (void) Remove(win);
}



/* writeouttree */
/* Write drawn tree into file treefile. */

void writeouttree(ButtoN but){
  int nb, i, l;
  char *ctreeprov, *ctree, c;
  FILE *ftree;
  drawtreedata data;

  if((ftree=fopen(treefile, "w"))==NULL){
    (void) printf("Sorry : cannot write file %d\n",treefile);
    goto fini;
  }

  GetPanelExtra(ptree[curtreew], &data);
  nb=data.nb;
  ctreeprov=(char*)check_alloc(100*nb, sizeof(char));
  ctree=(char*)check_alloc(100*nb, sizeof(char));

  tree_stoc(data.s_tree, 1, nb, ctreeprov);
  if(data.pseudo) ctree_nobl(ctreeprov, ctree, (int)strlen(ctreeprov));

  l=(int)strlen(data.header);
  (void) fprintf(ftree, "[");

  for(i=0;i<l;i++){
    c=data.header[i];
    if(c=='\n') (void) fprintf(ftree, "\\");
    else (void) fprintf(ftree, "%c",c);
  }

  (void) fprintf(ftree, "]\n");
  (void) fprintf(ftree, "%s", data.pseudo?ctree:ctreeprov);
  (void) fclose(ftree);

  free(ctreeprov);
  free(ctree);

fini:
  if (Visible(messw)) { (void) Remove(messw); messw=NULL; }
  if (Visible(savew)) { (void) Remove(savew); savew=NULL; }
}



/* writeoutdist */
/* Write computed distances into file distfile. */

void writeoutdist(ButtoN but){
  int i, j, l, dopt;
  char option[2];
  FILE* fdist;
 
  if((fdist=fopen(distfile, "w"))==NULL){
    (void) printf("Sorry : cannot write file %d\n", distfile);
    return;
  }
  dopt=GetValue(dist);

  (void) sprintf(option, (dopt==1)?"OD":
                  (dopt==2 && !PROTB)?"JC":
                  (dopt==3 && !PROTB)?"K2":
                  (dopt==4 && !PROTB)?"TN":
                  (dopt==5 && !PROTB)?"HK":
                  (dopt==6 && !PROTB)?"GG":
                  (dopt==7 && !PROTB)?"LD":
                  (dopt==2 && PROTB)?"PO":
                  ((dopt==3 && PROTB)||(dopt==8 && !PROTB))?"KA":
                  "KS");

  (void) fprintf(fdist, "%d\n", curnb);
 
  for(i=0;i<curnb-1;i++){
    for(j=i+1;j<curnb;j++){
      (void) fprintf(fdist, "%f ", outdist[i][j]);
    }
  (void) fprintf(fdist, "\n");
  }
  (void) fprintf(fdist, "Option : %s\n",option); 

  for(i=0;i<curnb;i++){
    (void) fprintf(fdist, "%s", curname[i]);
    l=20-(int)strlen(curname[i]);
    for(j=0;j<l;j++) (void) fprintf(fdist, " ");
  }
  (void) fprintf(fdist, "\n");
  (void) fclose(fdist);
  if (Visible(messw)) { (void) Remove(messw); messw=NULL; }
  if (Visible(savew)) { (void) Remove(savew); savew=NULL; }
  DONOTSHOWTREE=FALSE;
  Show(treew[curtreew]);
#ifdef MOTIF
  ajout_icone_tree();
#endif
}



/* pstreeprint */
/* Write tree on post script file ftree */

void pstreeprint(FILE* ftree, noeud from, noeud node,
   double wscale, double hscale, int hmax, Boolean bl, Boolean bs, Boolean noneg){
  noeud vd, vg;
  int ab, abg, abd, or, org, ord, ild, ilg, ibd, ibg;
  double ld, lg, bd, bg;
  
  if(from==node->v1) { vg=node->v2; vd=node->v3; lg=node->l2;
                       ld=node->l3; bg=node->b2; bd=node->b3;}
  if(from==node->v2) { vg=node->v1; vd=node->v3; lg=node->l1;
                       ld=node->l3; bg=node->b1; bd=node->b3;}
  if(from==node->v3) { vg=node->v1; vd=node->v2; lg=node->l1;
                       ld=node->l2; bg=node->b1; bd=node->b2;}


  ab=(int)(node->absc*wscale); 
  if(vd) abd=(int)(vd->absc*wscale); 
  if(vg) abg=(int)(vg->absc*wscale);
  or=(int)((hmax-node->ord)*hscale); 
  if(vd) ord=(int)((hmax-vd->ord)*hscale); 
  if(vg) org=(int)((hmax-vg->ord)*hscale);

  if(vd==NULL){
    (void) fprintf(ftree, "gras setfont  ");
    (void) fprintf(ftree, "%d %d moveto\n(%s) show\n", ab+5, or-4, node->nom);
    return;
  }

  (void) fprintf(ftree, "%d %d moveto\n%d %d lineto stroke\n", ab, org, ab, ord);
  (void) fprintf(ftree, "%d %d moveto\n%d %d lineto stroke\n", ab, ord, abd, ord);
  (void) fprintf(ftree, "%d %d moveto\n%d %d lineto stroke\n", ab, org, abg, org);

  ild=abd-ab; ilg=abg-ab;
  if(noneg && ilg<0) ilg=5;
  if(noneg && ild<0) ild=5;
  
  if(bl){
    if(ild>25 || ld<0.){
      if(ild>(int)(50./wscale)) (void) fprintf(ftree, "gros setfont  ");
      else (void) fprintf(ftree, "petit setfont  ");
      (void) fprintf(ftree, "%d %d moveto  (%.3f) show\n", ab+(abd-ab)/2-14, ord+3, ld);
    }
    if(ilg>25 || lg<0.){
      if(ilg>(int)(50./wscale)) (void) fprintf(ftree, "gros setfont  ");
      else (void) fprintf(ftree, "petit setfont  ");
      (void) fprintf(ftree, "%d %d moveto  (%.3f) show\n", ab+(abg-ab)/2-14, org+3, lg);
    }
  } 


  if (bs) {
    ibd=(int)(bd+0.5);
    ibg=(int)(bg+0.5);

    if(bd>-1){
      int bord, babd;
      if(ild>(int)(50./wscale)){
	if(bl && ild>25) bord=ord-17; else bord=ord+6;
	if(ibd==100) babd=abd-26; else babd=abd-17;
        (void) fprintf(ftree, "gros setfont  "); 
        (void) fprintf(ftree, "%d %d moveto  (%d) show\n", babd, bord, ibd);
	if (ibd==100){
	  (void) fprintf(ftree, "%d %d moveto\n", babd+7, bord-5);
	  (void) fprintf(ftree, "%d %d 10 -90 90 arc\n", babd+14, bord+5);
	  (void) fprintf(ftree, "%d %d 10 90 -90 arc\n", babd+7, bord+5);
	}
	else
          (void) fprintf(ftree, "%d %d moveto  %d %d 10 0 360 arc\n", babd+17, bord+5, babd+7, bord+5);
      }
      else {
	if(bl && ild>25) bord=ord-15; else bord=ord+6;
	if(ibd==100) babd=abd-26; else babd=abd-18;
        (void) fprintf(ftree, "petit setfont  ");
        (void) fprintf(ftree, "%d %d moveto  (%d) show\n", babd, bord, ibd);
	if (ibd==100){
	  (void) fprintf(ftree, "%d %d moveto\n", babd+7, bord-5);
	  (void) fprintf(ftree, "%d %d 9 -90 90 arc\n", babd+14, bord+5);
	  (void) fprintf(ftree, "%d %d 9 90 -90 arc\n", babd+7, bord+5);
	}
	else 
          (void) fprintf(ftree, "%d %d moveto  %d %d 9 0 360 arc\n", babd+15, bord+4, babd+6, bord+4);
      }
    }

    if(bg>-1){
      int borg, babg;
      if(ilg>(int)(50./wscale)){
	borg=org-17;
	if(ibg==100) babg=abg-26; else babg=abg-17;
        (void) fprintf(ftree, "gros setfont  "); 
        (void) fprintf(ftree, "%d %d moveto  (%d) show\n", babg, borg, ibg);
	if (ibg==100){
	  (void) fprintf(ftree, "%d %d moveto\n", babg+7, borg-5);
	  (void) fprintf(ftree, "%d %d 10 -90 90 arc\n", babg+14, borg+5);
	  (void) fprintf(ftree, "%d %d 10 90 -90 arc\n", babg+7, borg+5);
	}
	else
          (void) fprintf(ftree, "%d %d moveto  %d %d 10 0 360 arc\n", babg+17, borg+5, babg+7, borg+5);
      }
      else {
	borg=org-15;
	if(ibg==100) babg=abg-26; else babg=abg-18;
        (void) fprintf(ftree, "petit setfont  ");
        (void) fprintf(ftree, "%d %d moveto  (%d) show\n", babg, borg, ibg);
	if (ibg==100){
	  (void) fprintf(ftree, "%d %d moveto\n", babg+7, borg-5);
	  (void) fprintf(ftree, "%d %d 9 -90 90 arc\n", babg+14, borg+5);
	  (void) fprintf(ftree, "%d %d 9 90 -90 arc\n", babg+7, borg+5);
	}
	else
          (void) fprintf(ftree, "%d %d moveto  %d %d 9 0 360 arc\n", babg+15, borg+4, babg+6, borg+4);
      }
      
    }      
  }
  pstreeprint(ftree, node, vg, wscale, hscale, hmax, bl, bs, noneg);
  pstreeprint(ftree, node, vd, wscale, hscale, hmax, bl, bs, noneg);
}

  


/* writeoutps */
/* Write drawn tree in Post Script file treefile */

void writeoutps(ButtoN but){

  int height, width, hmax, i, ii;
  double wscale, hscale;
  char *texte, *prov;
  FILE* ftree;
  drawtreedata data;

  texte=(char*)check_alloc(1000, sizeof(char));

  GetPanelExtra(ptree[curtreew], &data);

  height=680.; width=500.;
  hmax=data.height+40; hscale=(double)height/data.height;
  wscale=(double)width/data.width;
  
   
  if((ftree=fopen(treefile, "w"))==NULL){
    (void) printf("Sorry : cannot write\n");
    goto fini;
  }

  (void) fprintf(ftree, "%%!\n1 setlinecap 1 setlinejoin 1 setlinewidth 0 setgray\n");
  if(data.nb<=10) (void) fprintf(ftree, "/gros /Times-Roman findfont 14 scalefont def\n");
  else (void) fprintf(ftree, "/gros /Times-Roman findfont 12 scalefont def\n");
  (void) fprintf(ftree, "/gras /Times-Bold findfont 14 scalefont def\n");
  (void) fprintf(ftree, "/title /Times-Bold findfont 16 scalefont def\n");
  (void) fprintf(ftree, "/petit /Times-Roman findfont 12 scalefont def\n");
  (void) fprintf(ftree, "title setfont\n50 50 translate\n");
  (void) sprintf(texte, "-10 -10 moveto 510 -10 lineto 510 750 lineto -10 750 lineto -10 -10 lineto");
  (void) fprintf(ftree, "%s\nstroke\n", texte);

  prov=data.header;
  i=0;
  while(*(prov+1)){
    ii=0;
    while(prov[ii]!='\n' && ii<198){ texte[ii]=prov[ii]; ii++; }
    texte[ii]=0; i++;
    (void) fprintf(ftree, "10 %d moveto  (%s) show\n", 740-20*i, texte);
    prov+=ii+1;
  }
    

  if(!data.pseudo){
    int rendbar;
    rendbar=380+(int)(100*wscale); 
    (void) fprintf(ftree, "gras setfont\n380 700 moveto  ");
    (void) fprintf(ftree, "%d 700 lineto  stroke\n", rendbar);
    (void) fprintf(ftree, "380 698 moveto  380 702 lineto stroke\n");
    (void) fprintf(ftree, "%d 698 moveto  %d 702 lineto stroke\n", rendbar, rendbar);
    (void) fprintf(ftree, "%d 705 moveto  ", 365+(rendbar-380)/2);
    (void) fprintf(ftree, "(%.3f) show\n", 100./data.scale);
  }
  
  pstreeprint(ftree, NULL, root[curtreew], wscale, hscale, hmax,
              data.branchlength, data.bootstrap, data.nonegativebranch);

  if(data.sce>-0.5){ 
    (void) sprintf(texte, "SSR : %f      total length : %.3f", data.sce, data.tot);
    (void) fprintf(ftree, "10 10 moveto  (%s) show\n", texte);
  }
  
  (void) fprintf(ftree, "showpage\n");

  (void) fclose(ftree);

fini:
  if (Visible(messw)) { (void) Remove(messw); messw=NULL; }
  if (Visible(savew)) { (void) Remove(savew); savew=NULL; }

#ifdef __VMS
    (void) sprintf(texte, "Tree plot written in PostScript file %s", treefile);
    createmessbox(texte, FALSE, quiterr, NULL);
#endif
#ifdef UNDEFINED /*UNIX*/
  if((printfile=fopen("/var/spool/lp/admins/lp/default", "r"))==NULL){
    (void) sprintf(texte, "Tree plot written in PostScript file %s", treefile);
    createmessbox(texte, FALSE, quiterr, NULL);
  }
  else {
    printer=(char*)check_alloc(50, sizeof(char));
    fscanf(printfile, "%s", printer);
    (void) fclose(printfile);
    (void) sprintf(texte, "lpr -P %s %s", printer, treefile);
    system(texte); 
    /*(void) sprintf(texte, "rm -f %s", treefile);
    system(texte); */
    remove(treefile);
    (void) sprintf(texte, "Tree plot printed on printer %s", printer); 
    createmessbox(texte, FALSE, quiterr, NULL);
    free(printer); free(texte); 
  }
#endif
  
}



/* savetreeok_act */
/* Callback procedure for OK button in savetree window. */
/* Read output file name and create a message box to check for overwriting. */

void savetreeok_act(ButtoN but){
char *texte, *prov;
FILE* local;

  texte=(char*)check_alloc(500, sizeof(char));
  prov=(char*)check_alloc(100, sizeof(char));
  GetTitle(savetext, prov, 100);
#ifdef UNIX
  (void) sprintf(treefile, "%s/%s", currentdir, prov);
#else
  (void) sprintf(treefile, "%s", prov);
#endif
  (void) sprintf(texte, "Overwrite %s ?", treefile);
  if ((local=fopen(treefile, "r"))!=NULL) {
    (void) fclose(local); 
    if(TREEFILEB) createmessbox(texte, FALSE,  writeouttree, quitwin);
    else createmessbox(texte, FALSE,  writeoutps, quitwin);
  }
  else {(void) fclose(local);  if(TREEFILEB) writeouttree(NULL); else writeoutps(NULL);}
  Enable(prfile[curtreew]); Enable(createbut[curtreew]); Enable(savetree[curtreew]);
  ArrowCursor();
  free(texte); free(prov);
  return;
}
 


/* create_act */
/* Callback procedure for TREE (PRINT) FILE button in tree window. */
/* Create save tree window. */

void create_act(ButtoN but){


  TREEFILEB=FALSE;
  if(but==createbut[curtreew]) TREEFILEB=TRUE;

  Disable(prfile[curtreew]); 
  Disable(createbut[curtreew]); 
  Disable(savetree[curtreew]);


  savew=FixedWindow(-50, -33, -10, -10, "SAVE", quitwin_w);
  shift(savew, 0, 20);
  if(TREEFILEB)
    (void) StaticPrompt(savew, "TREE FILE  :", 0, /*14*/ dialogTextHeight, ParseFont("times,14"), 'l');
  else
    (void) StaticPrompt(savew, "POST SCRIPT  FILE  :", 0, /*14*/ dialogTextHeight,
       ParseFont("times,14"), 'l');
  Advance(savew);
  /*shift(savew, 0, -10);*/
  stdLineHeight=18;
  savetext=DialogText(savew, "", 40, NULL);
  stdLineHeight=15;
  Break(savew);
  savegr=HiddenGroup(savew, 2, 0, NULL);
  shift(savegr, 140, 20);
  save_ok=PushButton(savegr, "  OK  ", savetreeok_act);
  shift(savegr, 20, 0);
  save_can=PushButton(savegr, "CANCEL", quitsavetwin); 

  Show(savew);
}



/* savedistok_act */
/* Callback procedure for OK button in savedist window. */
/* Read output file name and create a message box to check for overwriting. */

void savedistok_act(ButtoN but){
char *texte, *prov;
FILE* local;
  texte=(char*)check_alloc(500, sizeof(char));
  prov=(char*)check_alloc(100, sizeof(char));
  GetTitle(savetext, prov, 100);
#ifdef UNIX
  (void) sprintf(distfile, "%s/%s", currentdir, prov);
#else
  (void) sprintf(distfile, "%s", prov);
#endif
  (void) sprintf(texte, "Overwrite %s ?", distfile);
  if ((local=fopen(distfile, "r"))!=NULL) {
    (void) fclose(local); 
    createmessbox(texte, FALSE,  writeoutdist, quitwin);
  }
  else {(void) fclose(local);  writeoutdist(NULL);}
  free(texte); free(prov);
}



/* createdistsavebox */
/* Create save dist window. */

void createdistsavebox(void){
  savew=FixedWindow(-50, -33, -10, -10, "SAVE", quitwin_w);
  shift(savew, 0, 20);
  (void)StaticPrompt(savew, "DISTANCE FILE  :", 0, 14,
         ParseFont("times,14"), 'l');
  Advance(savew);
  shift(savew, 0, -10);
  stdLineHeight=18;
  savetext=DialogText(savew, "", 35, NULL);
  stdLineHeight=15;
  Break(savew);
  savegr=HiddenGroup(savew, 2, 0, NULL);
  shift(savegr, 140, 20);
  save_ok=PushButton(savegr, "  OK  ", savedistok_act);
  shift(savegr, 20, 0);
  save_can=PushButton(savegr, "CANCEL", quitwin);

  Show(savew);
}



/* drawtree */
/* Create tree window. Call tree drawing pocedure. */

void drawtree(noeud* s_arbre, int nb, char* header,
    Boolean bl, Boolean bs, Boolean combbut, Boolean noneg,
    double sce, double tot, int** bootptr, int bootok,
    int nbrep, char** treename, char* name){

  drawtreedata drawdata;
  int i, cur, k;
  int treewinwidth, treewinheight;
  double ratio;  
  Boolean GRAND=FALSE;
  char *realname, *s;
  static int numappel=-1;

  numappel++; if (numappel==10) numappel=0;
  cur=curtreew;
  k=25+numappel*5;
  realname=check_alloc(25, sizeof(char));
  (void) sprintf(realname, "%s", name);
  s=strchr(realname, '(');
  if(s) *s=0; 
  treew[cur]=DocumentWindow(-k, -k, -5, -5, realname, quitwin_w, NULL);

  if(SMALLSCREEN){
    treewinwidth=450;
    treewinheight=325;
    ratio=1.;
  }
  else{
    GRAND=(nb>=16) && !GetStatus(smti);
    treewinwidth=50*nb*screenwratio;
    if(treewinwidth<530*screenwratio) treewinwidth=530*screenwratio;
    if(treewinwidth>800*screenwratio) treewinwidth=800*screenwratio;
    if(GetStatus(smti)) treewinwidth=530*screenwratio;
    treewinheight=7*treewinwidth/8;
    if(sce>-0.5 || tot>-0.5) treewinheight+=50*screenwratio;
    ratio=(double)treewinwidth/(700*screenwratio);
    if(!GRAND && treewinwidth>530*screenwratio) ratio*=1+(nb-10)/6.;
  }
  ptree[cur]=AutonomousPanel(treew[cur], treewinwidth, treewinheight,
      ptreedraw, NULL, NULL, sizeof(drawtreedata), NULL, NULL);
  if(!SMALLSCREEN) shift(treew[cur], 30*ratio, 0);
  treegr[cur]=HiddenGroup(treew[cur], 3, 0, NULL);
  mySetGroupMargins(treegr[cur], (int)(10*ratio), 10);
  mySetGroupSpacing(treegr[cur], (int)(60*ratio), 0);
  if(!bl) blvalue[cur]=NULL;
  if (bl && !bs){
    shift(treegr[cur], 0, 10);
    blvalue[cur]=PushButton(treegr[cur], " Branch Lengths ", bl_act);
    shift(treegr[cur], 0, -10);
  }
  else if (bs && !bl && !combbut){
    shift(treegr[cur], 0, 10);
    bsvalue[cur]=PushButton(treegr[cur], "Bootstrap", bs_act);
    shift(treegr[cur], 0, -10);
  }
  else if (bl && bs && !combbut){
    GrouP localgr;
    localgr=HiddenGroup(treegr[cur], 0, 2, NULL);
    mySetGroupSpacing(localgr, 0, 10);
    blvalue[cur]=PushButton(localgr, "Branch Lengths", bl_act);
    bsvalue[cur]=PushButton(localgr, "Bootstrap", bs_act);
  }
  else if(!bl && bs && combbut){
    GrouP localgr;
    localgr=HiddenGroup(treegr[cur], 0, 2, NULL);
    mySetGroupSpacing(localgr, 0, 10);
    bsvalue[cur]=PushButton(localgr, "Bootstrap", bs_act);
    comb[cur]=PushButton(localgr, "Combine", comb_act);
  }
  else if (bl && bs && combbut){
    GrouP localgr;
    shift(treegr[cur], 0, -5);
    localgr=HiddenGroup(treegr[cur], 0, 3, NULL);
    mySetGroupSpacing(localgr, 0, 5);
    blvalue[cur]=PushButton(localgr, "Branch Lengths", bl_act);
    bsvalue[cur]=PushButton(localgr, "Bootstrap", bs_act);
    comb[cur]=PushButton(localgr, "Combine", comb_act);
  }
  else shift(treegr[cur], (int)(100*ratio), 0);

  if (GRAND && !SMALLSCREEN){
    treemodgr[cur]=HiddenGroup(treegr[cur], 2, 2, treemod_act);
    mySetGroupSpacing(treemodgr[cur], (int)(10*ratio), (int)(10*ratio));
  }
  else{
    treemodgr[cur]=HiddenGroup(treegr[cur], 0, 4, treemod_act);
    mySetGroupSpacing(treemodgr[cur], 0, (int)(10*ratio));
  }
  (void) RadioButton(treemodgr[cur], "show tree");
  (void) RadioButton(treemodgr[cur], "swap nodes");
  (void) RadioButton(treemodgr[cur], "new outgroup");
  (void) RadioButton(treemodgr[cur], "subtree");
  if(!GRAND || SMALLSCREEN){
    treerightgr[cur]=HiddenGroup(treegr[cur], 0, 3, NULL);
    mySetGroupSpacing(treerightgr[cur], (int)(8*ratio), 8);
    createbut[cur]=PushButton(treerightgr[cur], "TREE  FILE", create_act);
    prfile[cur]=PushButton(treerightgr[cur], "PRINT  PLOT", create_act);
    treequitgr[cur]=HiddenGroup(treerightgr[cur], 2, 0, NULL);
    mySetGroupSpacing(treequitgr[cur], (int)(10*ratio), 0);
    savetree[cur]=PushButton(treequitgr[cur], "STORE", store_act);
    quittree[cur]=PushButton(treequitgr[cur], "QUIT", quittreewin);
  }
  else{
    treerightgr[cur]=HiddenGroup(treegr[cur], 2, 2, NULL);
    mySetGroupSpacing(treerightgr[cur], (int)(15*ratio), 8);
    createbut[cur]=PushButton(treerightgr[cur], "TREE  FILE", create_act);
    savetree[cur]=PushButton(treerightgr[cur], "STORE", store_act);
    prfile[cur]=PushButton(treerightgr[cur], "PRINT  PLOT", create_act);
    quittree[cur]=PushButton(treerightgr[cur], "QUIT", quittreewin);
  }
  drawdata.width=treewinwidth;
  drawdata.height=treewinheight;
  drawdata.s_tree=s_arbre;
  drawdata.nb=nb;
  drawdata.header=(char*)check_alloc(MAXLHEAD+1, sizeof(char));
  (void) sprintf(drawdata.header, "%s", header);
  drawdata.branchlength=FALSE;
  drawdata.bootstrap=FALSE;
  drawdata.font=gras;
  drawdata.pseudo=!bl; 
  drawdata.squarenode=FALSE; 
  drawdata.squarebranch=FALSE; 
  drawdata.squareintbranch=FALSE; 
  drawdata.indice=cur;
  drawdata.llist1=drawdata.llist2=0;
  drawdata.nonegativebranch=noneg;
  drawdata.sce=sce; 
  drawdata.tot=tot;
  drawdata.bootptr=bootptr;
  drawdata.nbrep=nbrep;
  drawdata.bootok=bootok;
  if(combbut) {
    for(i=0;i<nb;i++){
      drawdata.treename[i]=(char*)check_alloc(MAXLNAME+1, sizeof(char));
      (void) sprintf(drawdata.treename[i], "%s", treename[i]);
    }
  }

  SetPanelExtra(ptree[cur], &drawdata);
  if(!DONOTSHOWTREE) {
    Show(treew[cur]);
#ifdef MOTIF
    ajout_icone_tree();
#endif
  }
}


void bit1(int *plist, int num){
  num--;
  plist+=(num/lmot);
  *plist |= (1<<(num%lmot));
}

void bit0(int *plist, int num){
num--;
plist+=(num/lmot);
*plist &=  ~(1<<(num%lmot));
}


void et(int *listet, int *list1, int *list2, int len){
int i;
for(i=0; i< len; i++)
	listet[i]= list1[i] & list2[i];
}


void ou(int *listou, int *list1, int *list2, int len){
  int i;
  for(i=0; i< len; i++)
    listou[i]= list1[i] | list2[i];
}


void non(int *listnon, int *list, int len){
int i;
for(i=0; i< len; i++)
	listnon[i]= ~list[i];
}


int testbit(int *plist, int num){
  num--;
  plist += (num/lmot);
  return (*plist) & (1<<(num%lmot));
}


int memebranche(int* list1, int* list2, int nbints, int nbbits){
  int mask, i, flag1=0, flag2=0, toshow;

	/* comparaison des nbints-1 premiers entiers */
  for(i=0;i<nbints-1;i++){
    if(!flag1 && list1[i]!=list2[i]) flag1=1;
    if(!flag2 && list1[i]!=~(list2[i])) flag2=1;
    if(flag1 && flag2) return 0; 
  }
  mask=~0;
  toshow=nbbits%lmot; 
  if(toshow!=0)
    mask=~(mask<<toshow);
  if ((list1[nbints-1] & mask)!=(list2[nbints-1] & mask)) flag1=1;
  if ((list1[nbints-1] & mask)!=((~(list2[nbints-1])) & mask)) flag2=1;
  if(flag1 && flag2) return 0;

  return 1;
}

 
void reg_and_pos(int *selected, int* regions){ 

  int sel1=0, sel2=0, sel3=0, i, j, cur_reg_deb=0;

  if(PROTB){
    sel1=sel2=sel3=1;
  }
  else{
    if(GetStatus(po1i)) sel1=1;
    if(GetStatus(po2i)) sel2=1;
    if(GetStatus(po3i)) sel3=1;
  }

  if(sel1 && sel2 && sel3){
    for(i=0;i<lgseq;i++) selected[i]=regions[i];
  }
  else{
    if(sel1 && sel2 && !sel3){
      for(i=0;i<lgseq;i++){
        if(regions[i] && !regions[i-1]) cur_reg_deb=i;
	j=i-cur_reg_deb;
        if(regions[i] && (j%3==0 || j%3==1)) selected[i]=1; else selected[i]=0;
      }
    }
    if(sel1 && !sel2 && sel3){
      for(i=0;i<lgseq;i++){
        if(regions[i] && !regions[i-1]) cur_reg_deb=i;
	j=i-cur_reg_deb;
	if(regions[i] && (j%3==0 || j%3==2)) selected[i]=1; else selected[i]=0;
      }
    }
    if(!sel1 && sel2 && sel3){
      for(i=0;i<lgseq;i++){
        if(regions[i] && !regions[i-1]) cur_reg_deb=i;
	j=i-cur_reg_deb;
	if(regions[i] && (j%3==1 || j%3==2)) selected[i]=1; else selected[i]=0;
      }
    }
    if(sel1 && !sel2 && !sel3){
      for(i=0;i<lgseq;i++){
        if(regions[i] && !regions[i-1]) cur_reg_deb=i;
	j=i-cur_reg_deb;
	if(regions[i] && (j%3==0)) selected[i]=1; else selected[i]=0;
      }
    }
    if(!sel1 && sel2 && !sel3){
      for(i=0;i<lgseq;i++){
        if(regions[i] && !regions[i-1]) cur_reg_deb=i;
	j=i-cur_reg_deb;
	if(regions[i] && (j%3==1)) selected[i]=1; else selected[i]=0;
      }
    }
    if(!sel1 && !sel2 && sel3){
      for(i=0;i<lgseq;i++){
        if(regions[i] && !regions[i-1]) cur_reg_deb=i;
	j=i-cur_reg_deb;
 	if(regions[i] && (j%3==2)) selected[i]=1; else selected[i]=0;
      }
    }
    if(!sel1 && !sel2 && !sel3){
      for(i=0;i<lgseq;i++) selected[i]=0;
    }
  }
  return;
}
  

/* bdt_act */
/* Callback procedure for DRAW TREE button bdt. */
/* Checks selected species and sites, selected method and option */
/* and calls tree-building procedures. */

void bdt_act(ButtoN but){
  printdata dataseq, dataname, datasite, datasp, databd;
  int i=0, ibis, j, k, l, ii, lg=0, nb=0, treesel=-1, ran, **tarbre, 
	**tarbre_cons, n, nbex=-1, **barbre, lliste, dd, flag, 
	nbbranche, **bootbranche, nbrep=0, *selected=NULL;
  char **treeseq, **bootseq, *carbre, *carbre_boot, *prov, *carbreprov,
        *carbre_jumb, *carbre_pars, *carbre_cons, *texte, tnbrep[10], c, rac, **treeresname, 
	**treename, header[MAXLHEAD], header_cons[MAXLHEAD], ch[10], titre[21], err_mess[100],
	*carbre_jumb_init;
  double *lgbi=NULL, *lgbp=NULL, **d, *binb[MAXTREEW], *bootvals=NULL, steps, like, 
	beststeps, bestlike;
  Boolean LI, bl=FALSE, bs=FALSE, WARN, STOPCODON;
  noeud* sarbre[MAXTREEW];
  branche br;
  time_t debut, fin;
  double exp_run_time;

  texte=(char*)check_alloc(100, sizeof(char));

		/**** INTERRUPT RUNNING ROUTINE ****/


#ifdef MOTIF
  GetTitle(bdt, titre, 20);
  if(strcmp(titre, "INTERRUPT")==0){
    interrompu=TRUE;
    return;
  }
#endif

  Disable(bdt);
  WatchCursor();

 /* if (numappel++==0){
    speed=expby5sec(); 
    speed/=acnucspeed;
  }

  debut=time(NULL);*/


  DONOTSHOWTREE=FALSE;
  GetPanelExtra(pseq, &dataseq);
  GetPanelExtra(pname, &dataname);
  GetPanelExtra(psites, &datasite);
  GetPanelExtra(pspecies, &datasp);
  GetPanelExtra(pbuild, &databd);
  


  while(i<databd.tot_lignes) if(databd.selected[i++]) { treesel=i-1; break; }
  


		/**** DRAW SELECTED STORED TREE ****/

  if (treesel!=-1){
    char* list1[MAXNSP], *list2[MAXNSP];
    int l1, l2, flag=0, bootok=0;
    noeud nd;
    br=(branche)check_alloc(1, sizeof(struct sbranche));

    if(!sscanf(memtree[treesel], "[%d", &nb))
      nb=-1;
    carbre=strchr(memtree[treesel], ']');
    if(carbre==NULL){
      carbre=memtree[treesel];
      (void) sprintf(header, "No header\n");
    }
    else{
      n=carbre-memtree[treesel]-1;
      for(i=0;i<n;i++) header[i]=memtree[treesel][i+1];
      header[n]=0;
    }
    while(*carbre!='(') {carbre++; if(*carbre==0) {
        (void) printf("Tree reading error\n"); ArrowCursor(); return; }}
    if(nb==-1) nb=tree_ctot(carbre, NULL, NULL, NULL, NULL, NULL, &rac);
    lgbi=(double*)check_alloc(nb, sizeof(double));
    lgbp=(double*)check_alloc(nb+1, sizeof(double));
    bootvals=(double*)check_alloc(nb, sizeof(double));
    for(i=0;i<nb;i++) lgbp[i]=lgbi[i]=bootvals[i]=-1.; 
    treeresname=(char**)check_alloc(nb+1, sizeof(char*));
    for(i=0;i<=nb;i++) treeresname[i]=(char*)check_alloc(MAXLNAME+1,sizeof(char));
    tarbre=(int**)check_alloc(nb+1, sizeof(int*));
    for(i=0;i<nb+1;i++) tarbre[i]=(int*)check_alloc(nb-2, sizeof(int));

    (void) tree_ctot(carbre, tarbre, lgbi, lgbp, bootvals, treeresname, &rac);
    for(i=0;i<nb;i++) if(bootvals[i]>-0.5) {flag=1; break;}
    if (!flag) { free(bootvals); bootvals=NULL; bootok=1; } else bs=TRUE;
    if (lgbi[0]>-0.5) bl=TRUE; else { free(lgbi); free(lgbp); lgbi=NULL; lgbp=NULL; }
    sarbre[0]=(noeud*)check_alloc(2*nb, sizeof(noeud));

    if (rac=='r'){
      (void) unroot(tarbre, nb, lgbi, lgbp, bootvals, treeresname, list1, list2, &l1, &l2);
    }

    (void) tree_ttos(tarbre, nb, lgbi, lgbp, bootvals, treeresname, sarbre[0]);

    nbtreew++;
    for(i=0;i<MAXTREEW;i++) if (!openedtreew[i]) {curtreew=i; openedtreew[i]=TRUE; break; }
    if(nbtreew<MAXTREEW){
      root[curtreew]=create_node(NULL, NULL, NULL, 0., 0., 0., -1., -1., -1., NULL);
      if(rac=='r'){
        br->bout1=NULL;
        for(i=0;i<2*nb-2;i++) {
          nd=sarbre[0][i];
          if(nd->v1 && equallist(nd, nd->v1, l1, list1) && equallist(nd->v1, nd, l2, list2)){
	    if(l1<l2) {br->bout1=nd; br->bout2=nd->v1;} else {br->bout1=nd->v1; br->bout2=nd;}
	    br->length=nd->l1; br->bootstrap=nd->b1; break; 
	  }
          if(nd->v1 && equallist(nd, nd->v1, l2, list2) && equallist(nd->v1, nd, l1, list1)){
	    if(l1>=l2) {br->bout1=nd; br->bout2=nd->v1;} else {br->bout1=nd->v1; br->bout2=nd;}
	    br->length=nd->l1; br->bootstrap=nd->b1; break; 
	  }
          if(nd->v2 && equallist(nd, nd->v2, l1, list1) && equallist(nd->v2, nd, l2, list2)){
	    if(l1<l2) {br->bout1=nd; br->bout2=nd->v2;} else {br->bout1=nd->v2; br->bout2=nd;}
	    br->length=nd->l2; br->bootstrap=nd->b2; break; 
	  }
          if(nd->v2 && equallist(nd, nd->v2, l2, list2) && equallist(nd->v2, nd, l1, list1)){
	    if(l1>=l2) {br->bout1=nd; br->bout2=nd->v2;} else {br->bout1=nd->v2; br->bout2=nd;}
	    br->length=nd->l2; br->bootstrap=nd->b2; break; 
	  }
          if(nd->v3 && equallist(nd, nd->v3, l1, list1) && equallist(nd->v3, nd, l2, list2)){
	    if(l1<l2) {br->bout1=nd; br->bout2=nd->v3;} else {br->bout1=nd->v3; br->bout2=nd;}
	    br->length=nd->l3; br->bootstrap=nd->b3; break; 
	  }
          if(nd->v3 && equallist(nd, nd->v3, l2, list2) && equallist(nd->v3, nd, l1, list1)){
	    if(l1>=l2) {br->bout1=nd; br->bout2=nd->v3;} else {br->bout1=nd->v3; br->bout2=nd;}
	    br->length=nd->l3; br->bootstrap=nd->b3; break; 
	  }
        }
        if(br->bout1==NULL) { br=central_branch(sarbre[0], nb); }
      }
      else
	br=central_branch(sarbre[0], nb);

      stree_root(sarbre[0], br, bl);
      organize(NULL, root[curtreew]);
      memroot[curtreew]=root[curtreew];
      memnb[curtreew]=nb;
      for(i=0;i<2*nb-2;i++) sarbre[0][i]->color=0; 
      root[curtreew]->color=0;

      drawtree(sarbre[0], nb, header, bl, bs, FALSE, 0, -1., -1., NULL,
        bootok, -1, NULL, memtreename[treesel]);
    }
    else {
      (void) sprintf(texte, "Too many opened tree windows.\n"); 
      createmessbox(texte, FALSE, quiterr, NULL); 
      nbtreew=MAXTREEW-1; 
    }
    ArrowCursor();
    enablebuttons();
   for(i=0;i<nb;i++) free(treeresname[i]);
    free(treeresname);
    free(br);
    if(lgbi) free(lgbi); if(lgbp) free(lgbp); if(bootvals) free(bootvals);
    return;
  }

		/**** MAKE NEW TREE THEN DRAW ****/
 

	/** REFRESH  SEQUENCES **/

  selected=(int*)check_alloc(lgseq, sizeof(int));
  reg_and_pos(selected, dataseq.selected);

  for(i=0;i<lgseq;i++) if (selected[i]) lg++;
  for(i=0;i<nbseq;i++) if (dataname.selected[i]) nb++;
  treeseq=(char**)check_alloc(nb, sizeof(char*));
  treename=(char**)check_alloc(nb, sizeof(char*));
  dd=GetValue(dist);

  if (!( LI=(method==1) && ((PROTB && (dd==3 || dd==4)) || (!PROTB && (dd==8 || dd==9))) )){
    for(i=0;i<nb;i++)
      treeseq[i]=(char*)check_alloc(lg+1, sizeof(char));

  
    for(i=j=0;j<nbseq;j++) {
      if (dataname.selected[j]==1) {
        ii=0;
        treename[i]=cname[j];
        for(k=0;k<lgseq;k++) 
	  if(selected[k]){
	    treeseq[i][ii]=seq[j][k];
	    if(TRANSVONLY) treeseq[i][ii]=pur_pyr(seq[j][k]);
	    ii++;
	  }
        treeseq[i][ii]='\0';
        i++;
      }
    } 

    for(i=0;i<nb;i++) for(j=0;j<lg;j++) {
      c=treeseq[i][j];
      if (!PROTB && c!='A' && c!='C' && c!='G' && c!='T' && c!='U' && 
          (!TRANSVONLY || (c!='R' && c!='Y')))
        treeseq[i][j]='-';
      if (!PROTB && c=='U') treeseq[i][j]='T';
      if (PROTB && (c=='X' || !isalpha(c)) ) treeseq[i][j]='-';
    }
    if (method==1 && GetStatus(nogi)) 
      refresh(treeseq, nb, 1, PROTB); else refresh(treeseq, nb, 0, PROTB);

    if(!GetStatus(nogi)){
      lg=(int)strlen(treeseq[0]);
      (void) sprintf(header, "%d species , %d sites", nb, lg);
    }
    else{
      lg=0; l=(int)strlen(treeseq[0]);
      for(i=0;i<nb-1;i++){
        for(j=i+1;j<nb;j++){
	  for(k=0;k<l;k++){
	    if(treeseq[i][k]!='-' && treeseq[j][k]!='-') lg++;
	  }
	}
      }
      lg/=(nb*(nb-1)/2);
      (void) sprintf(header, "%d species, mean length : %d", nb, lg);
      lg=l;
    }      

  }

  else{
    if(PROTB) lg=3*lg;
    for(i=0;i<nb;i++){
      treeseq[i]=(char*)check_alloc(lg+4, sizeof(char));
    }
    for(i=j=0;j<nbseq;j++) {
      if (dataname.selected[j]) {
        ii=0;
        treename[i]=cname[j];
	if (PROTB){
          for(k=0;k<lgseq;k++) if(selected[k]) {
	    treeseq[i][ii++]=nucseq[j][3*k];
	    treeseq[i][ii++]=nucseq[j][3*k+1];
	    treeseq[i][ii++]=nucseq[j][3*k+2];
	  }
	}
	else {
	  char warntext[100];
	  int first, second, third;
          ii=0;
          for(k=0;k<lgseq;k++) if(selected[k]) {
	    treeseq[i][ii]=nucseq[j][k];
	    if(nucseq[j][k]=='-'){
	      if(ii%3==0){ first=k; second=k+1; third=k+2; }
	      if(ii%3==1){ first=k-1; second=k; third=k+1; }
	      if(ii%3==2){ first=k-2; second=k-1; third=k; }
	      WARN=((nucseq[j][first]!='-') ||
                    (nucseq[j][second]!='-') ||
                    (nucseq[j][third]!='-'));
	      if (WARN && !GAPWARNED) {
		(void) sprintf(warntext,
                        "WARNING : gap-containing codon %c%c%c (site %d) in sequence %s", 
			nucseq[j][first], nucseq[j][second], nucseq[j][third],
                        first+1, treename[i]);
		createmessbox(warntext, FALSE, quiterr, canceldt);
		ArrowCursor();
		while(messw) ProcessAnEvent();
		GAPWARNED=TRUE;
		WatchCursor();
	      }
	    }

 	    STOPCODON= 
	        !STOPWARNED
		&&
		(k%3==0)
		&&
		(
		  (
		    !code_mt 
		    && 
		    nucseq[j][k]=='T' 
		    && 
		    (
		      (nucseq[j][k+1]=='A' && nucseq[j][k+2]=='A') 
		      || 
		      (nucseq[j][k+1]=='A' && nucseq[j][k+2]=='G') 
		      || 
		      (nucseq[j][k+1]=='G' && nucseq[j][k+2]=='A')
    		    )
		  )
 		  ||
		  (
		    code_mt
	            &&
		    nucseq[j][k]=='A' 
		    &&
		    nucseq[j][k+1]=='G' 
		    &&
		    (nucseq[j][k+2]=='A' || nucseq[j][k+2]=='G')	    
		  )
		);

	    if(STOPCODON){
	      (void) sprintf(warntext, "WARNING : stop codon %c%c%c (site %d) in sequence %s",
                 nucseq[j][k], nucseq[j][k+1], nucseq[j][k+2], k+1, treename[i]);
	      createmessbox(warntext, FALSE, quiterr, canceldt);
	      ArrowCursor();
	      while(messw) ProcessAnEvent();
	      STOPWARNED=TRUE;
	      WatchCursor();
	      }
	    ii++;
	  }
	}
        treeseq[i][ii]='\0';
	if(ii%3>=1) treeseq[i][ii-1]='\0';
	if(ii%3>=2) treeseq[i][ii-2]='\0';
        i++;
      }
    } 
    GAPWARNED=STOPWARNED=FALSE;
    for(i=0;i<nb;i++) for(j=0;j<lg;j++) {
      c=treeseq[i][j];
      if (c!='A' && c!='C' && c!='G' && c!='T' && c!='U'){ 
        treeseq[i][j]='-';
        if (j%3==0) { treeseq[i][j+1]='-'; treeseq[i][j+2]='-'; }
        if (j%3==1) { treeseq[i][j+1]='-'; treeseq[i][j-1]='-'; }
        if (j%3==2) { treeseq[i][j-1]='-'; treeseq[i][j-2]='-'; }
      }
      if (c=='U') treeseq[i][j]='T';
    }
    if (method==1 && GetStatus(nogi)) refresh(treeseq, nb, 1, 0); else refresh(treeseq, nb, 0, 0);
    if(!GetStatus(nogi)) {
      lg=(int)strlen(treeseq[0]);
      (void) sprintf(header, "%d species , %d codons", nb, lg/3);
    }
    else{
      lg=0; l=(int)strlen(treeseq[0]);
      for(i=0;i<nb-1;i++){
        for(j=i+1;j<nb;j++){
	  for(k=0;k<l/3;k++){
	    if(treeseq[i][3*k]!='-' && treeseq[j][3*k]!='-') lg++;
	  }
	}
      }
      lg/=(nb*(nb-1)/2);
      (void) sprintf(header, "%d species, mean length : %d codons", nb, lg);
      lg=l;
    }
  }

  if(lg==0){
    createmessbox("No selected sites", FALSE, quiterr, NULL);
    ArrowCursor();
    return;
  }
  l=(int)strlen(header);
  if(method==1 && GetStatus(nogi)) (void) sprintf(header+l, " (pairwise gap removal)\n");
  else if(method==1) (void) sprintf(header+l, " (global gap removal)\n");
  else if(method==3) (void) sprintf(header+l, "\n");
  l=(int)strlen(header);




  if (DONOTSHOWTREE) {ArrowCursor(); Enable(bdt); DONOTSHOWTREE=FALSE; return;}

  carbre=(char*)check_alloc(100*nb, sizeof(char));
  carbre_boot=(char*)check_alloc(100*maxtrees*nb, sizeof(char));
  carbre_jumb=(char*)check_alloc(100*maxtrees*nb, sizeof(char));
  carbre_jumb_init=carbre_jumb;
  carbre_pars=(char*)check_alloc(100*maxtrees*2*nb, sizeof(char));
  tarbre=(int**)check_alloc(nb+1, sizeof(int*));
  for(i=0;i<=nb;i++) tarbre[i]=(int*)check_alloc(nb-2, sizeof(int));
  if (option==1 && CONSENSE){
    tarbre_cons=(int**)check_alloc(nb+1, sizeof(int*));
    for(i=0;i<=nb;i++) 
      tarbre_cons[i]=(int*)check_alloc(nb-2, sizeof(int));
    carbreprov=(char*)check_alloc(100*maxtrees*nb, sizeof(char));
    carbre_cons=(char*)check_alloc(100*maxtrees*nb, sizeof(char));
  }
  lgbi=(double*)check_alloc(nb, sizeof(double));
  lgbp=(double*)check_alloc(nb, sizeof(double));
  treeresname=(char**)check_alloc(nb+1, sizeof(char*));
  for(i=0;i<=nb;i++) treeresname[i]=(char*)check_alloc(MAXLNAME+1,sizeof(char));

/*  if(method==2) exp_run_time=3.475e-6*lg*pow((double)nb, 2.68);
  exp_run_time/=speed;

  if(option) {    
    GetTitle(rep_text, tnbrep, 10);
    (void) sscanf(tnbrep, "%d", &nbrep);
    exp_run_time*=nbrep;
  }
*/
		/**  BUILD  TREE  **/

  /* NJ */

  if (method==1){
    (void) sprintf(header+l, "Neighbor Joining Method\n");
    l=(int)strlen(header);
    if(TRANSVONLY && dd==1) (void) sprintf(header+l, "Transversions only\n");
    l=(int)strlen(header);

    d=(double**)check_alloc(nb+2, sizeof(double));
    for(i=0;i<nb+2;i++) d[i]=(double*)check_alloc(nb+2, sizeof(double));
    if(!compute_dist(treeseq, nb, lg, d, header+l)){
      if(!LI) createmessbox("Cannot compute distances", FALSE, quiterr, NULL);
      ArrowCursor();
      return;
    }
    if(GetStatus(outi)){ /* output distance matrix */
      for(i=0;i<nb;i++) outdist[i]=(double*)check_alloc(nb, sizeof(double));
      for(i=0;i<nb;i++)
	for(j=0;j<nb;j++)
	  outdist[i][j]=d[i][j];
      curnb=nb;
      for(i=0;i<nb;i++) curname[i]=treename[i];
      DONOTSHOWTREE=TRUE;
      createdistsavebox();
    }

    if (!nj_in_out(d, treename, nb, carbre, NULL)) {
       (void) printf("Tree making error\n");
       ArrowCursor();
       return;}
    bl=TRUE;
  }


  /* MP */

  else if (method==2){
    if (PROTB) 
      prot(treeseq, treename, nb, carbre_pars, &steps, NULL); 
    else 
      pars(treeseq, treename, nb, carbre_pars, &steps, NULL);
    lgbp=NULL; lgbi=NULL;
    beststeps=steps;
    if (option==2){  /* jumble */
      GetTitle(rep_text, tnbrep, 10);
      (void) sscanf(tnbrep, "%d", &nbrep);
#ifdef MOTIF
      Enable(bdt); SetTitle(bdt, "INTERRUPT");
      interrompu=FALSE;
#endif
      Disable(choosemeth); 
      for(i=0;i<nbrep-1;i++){
        (void) sprintf(ch, "%d", nbrep-i);
        SetTitle(rep_text, ch);
	jumble_fct(treeseq, treename, nb);
	ii=0;
        while(carbre_jumb[ii]) carbre_jumb[ii++]=0;
        if (PROTB) 
	  prot(treeseq, treename, nb, carbre_jumb, &steps, NULL); 
	else 
          pars(treeseq, treename, nb, carbre_jumb, &steps, NULL);
	if((int)steps<(int)beststeps){
	  beststeps=steps;
	  (void) sprintf(carbre_pars, "%s", carbre_jumb);
	  nbex=-1;
	}
	else if((int)steps==(int)beststeps && nbex<maxtrees)
	  nbex+=addexaequo(carbre_pars, carbre_jumb, nb);
#ifdef MOTIF
        while((!interrompu) && myeventavail()) ProcessAnEvent();
        if (interrompu) { nbrep=i+1; SetTitle(rep_text, "");
             SetTitle(bdt, SMALLSCREEN?"BUILD":"MAKE TREE"); break; }
#endif
      }
    }
    interrompu=FALSE;
    Enable(choosemeth); 
    (void) sprintf(header+l,
        " (%d informative)\nMaximum Parsimony (%d steps required)\n",
        informative(treeseq, nb), (int)beststeps);
    l=(int)strlen(header);
    if(TRANSVONLY) (void) sprintf(header+l, "Transversions only\n");

    if(option==2){
      l=(int)strlen(header);
      (void) sprintf(header+l, "Best from %d jumble replicates\n", nbrep);
    }

    prov=carbre_pars; 
  }

  /* ML */

  else if (method==3){ 
    if (PROTB) { ArrowCursor(); return; }
    if(Gduring>nb-3) Gduring=nb-3;
    if(Gafter>nb-3) Gafter=nb-3;
    err_mess[0]='\0';
    (void) ml(treeseq, treename, nb, carbre, &like, NULL, err_mess);
    if(carbre[0]==0) {
      if(err_mess[0]=='\0')
        createmessbox("Erreur building tree", FALSE, quiterr, NULL);
      else
        createmessbox(err_mess, FALSE, quiterr, NULL);
      ArrowCursor();
      return;
    }
    if (*carbre=='[') { while(*carbre!=']') carbre++; while(*carbre!='(') carbre++; }
    bestlike=like;
    if (option==2){  /* jumble */
      GetTitle(rep_text, tnbrep, 10);
      (void) sscanf(tnbrep, "%d", &nbrep);
#ifdef MOTIF
      Enable(bdt); SetTitle(bdt, "INTERRUPT");
      interrompu=FALSE;
#endif
      Disable(choosemeth); 
      for(i=0;i<nbrep-1;i++){
        (void) sprintf(ch, "%d", nbrep-i);
        SetTitle(rep_text, ch);
	jumble_fct(treeseq, treename, nb);
	ii=0;
        while(carbre_jumb[ii]) carbre_jumb[ii++]=0;
        (void) ml(treeseq, treename, nb, carbre_jumb, &like, NULL, err_mess);
        if(carbre_jumb[0]){
          if (*carbre_jumb=='[') { 
	    while(*carbre_jumb!=']') carbre_jumb++; 
	    while(*carbre_jumb!='(') carbre_jumb++; 
	  }
	  if(like>bestlike){
	    bestlike=like;
	    (void) sprintf(carbre, "%s", carbre_jumb);
	  }
	}
#ifdef MOTIF
        while((!interrompu) && myeventavail()) ProcessAnEvent();
        if (interrompu) { nbrep=i+1; SetTitle(rep_text, "");
          SetTitle(bdt, SMALLSCREEN?"BUILD":"MAKE TREE"); break; }
#endif
      }
    }
    interrompu=FALSE;
    
    Enable(choosemeth); 
    (void) sprintf(header+l,"Maximum Likelihood (ln(L)=%.3f)\n", bestlike);
    if(option==2){
      l=(int)strlen(header);
      (void) sprintf(header+l, "Best from %d jumble replicates\n", nbrep);
    }
    bl=TRUE;
  }
  
  /* here carbre=built tree for nj and ml, prov=built tree(s) for mp */

	/** BOOTSTRAP **/


  if (option==1) {	
    Boolean echec=FALSE;
    int sat=0;
    char* jumbname[MAXNSP];

    for(i=0;i<nb;i++) jumbname[i]=treename[i];
    bs=TRUE; 
    nbbranche=0;
#ifdef MOTIF
    interrompu=FALSE;
    Enable(bdt); SetTitle(bdt, "INTERRUPT");
#endif
    Disable(choosemeth); 
    bootseq=(char**)check_alloc(nb, sizeof(char*));
    for(i=0;i<nb;i++) bootseq[i]=(char*)check_alloc(lg+1, sizeof(char));
    GetTitle(rep_text, tnbrep, 10);
    (void) sscanf(tnbrep, "%d", &nbrep);
    lliste=(nb+lmot-1)/lmot;

    bootbranche=(int**)check_alloc(nbrep*(nb-3)+1, sizeof(int*));
    for(i=0;i<nbrep*(nb-3);i++) bootbranche[i]=(int*)check_alloc(lliste, sizeof(int));
    bootbranche[nbrep*(nb-3)]=(int*)check_alloc(1, sizeof(int));
    listbbranche=(int**)check_alloc(nbrep*(nb-3), sizeof(int*));
    listbval=(int*)check_alloc(nbrep*(nb-3), sizeof(int));


    for(i=ibis=0;i<nbrep;i++){
      (void) sprintf(ch, "%d", nbrep-i);
      SetTitle(rep_text, ch);

 	/* resampling */

      if (JUMBBOOT) jumble_fct(treeseq, jumbname, nb);
      if (!LI)
        for(j=0;j<lg;j++){
	  ran=has1_n(lg)-1;
	  for(k=0;k<nb;k++) bootseq[k][j]=treeseq[k][ran];
        } 
      else
	for(j=0;j<lg/3;j++){
	  ran=has1_n(lg/3)-1;
	  for(k=0;k<nb;k++){
	    bootseq[k][3*j]=treeseq[k][3*ran];
	    bootseq[k][3*j+1]=treeseq[k][3*ran+1];
	    bootseq[k][3*j+2]=treeseq[k][3*ran+2];
	  }
	}
      for(k=0;k<nb;k++) bootseq[k][lg]='\0';


	/* c_tree computing */

      ii=0;
      while(carbre_boot[ii]) carbre_boot[ii++]=0;
      if (method==1){
	if (!compute_dist(bootseq, nb, lg, d, NULL)) { sat++; i--; goto endloop;}
        if (!nj_in_out(d, jumbname, nb, carbre_boot, NULL)) { sat++; i--; goto endloop;}
      }
      if (method==2) {
        if (PROTB) 
          prot(bootseq, jumbname, nb, carbre_boot, NULL, NULL); 
	else 
	  pars(bootseq, jumbname, nb, carbre_boot, NULL, NULL); 
      }
      if (method==3) {
        if(Gduring>nb-3) Gduring=nb-3;
        if(Gafter>nb-3) Gafter=nb-3;
        err_mess[0]='\0';
        (void) ml(bootseq, jumbname, nb, carbre_boot, NULL, NULL, err_mess);
	if (err_mess[0] || strstr(carbre_boot, "   NaN,")) { sat++; i--; goto endloop; }
      }

	/* c_tree to b_tree */

      if (rooted(carbre_boot)) (void) unroot_c(carbre_boot);
      (void) tree_ctob(carbre_boot, treename, bootbranche+i*(nb-3));

        /* store new branches */
      
      for(ii=0;ii<nb-3;ii++){
	flag=0;
        for(j=0;j<nbbranche;j++){
	  if(memebranche(bootbranche[i*(nb-3)+ii], listbbranche[j], lliste, nb)){
	    listbval[j]++;
	    flag=1;
	    break;
	  }
	}
	if (!flag){
	  listbbranche[nbbranche]=bootbranche[i*(nb-3)+ii];
	  listbval[nbbranche]=1;
	  nbbranche++;
	}
      }

	/* end of loop */

#ifdef MOTIF
      while((!interrompu) && myeventavail()) ProcessAnEvent();
      if (interrompu) { nbrep=i+1; break; }
#endif

      endloop:      
      if (ibis>25 && (double)sat>=nbrep/3.  ) {echec=TRUE; break; }
      ibis++;
    }

    interrompu=FALSE;
    Enable(choosemeth); 
    SetTitle(rep_text, "");
    SetTitle(bdt, SMALLSCREEN?"BUILD":"MAKE TREE");

    if (echec) { 
      (void) sprintf(texte, "Cannot perform bootstrap : too many tree building errors (saturation?)");
      createmessbox(texte, FALSE, quiterr, NULL); 
      ArrowCursor();
      return;
    }

    l=(int)strlen(header);
    (void) sprintf(header+l, "%d bootstrap replicates\n",nbrep);
    *(bootbranche[nbrep*(nb-3)])=0;
  }

		/** FOR ALL EQUALLY BEST TREES : **/

  nbex=-1;
  while((method==2 && (carbre=strtok(prov, "\n"))&& nbex<MAXTREEW-1) || (method!=2 && nbex==-1)){

    if(*carbre!='(' && *carbre!='[') break;
    nbex++; binb[nbex]=NULL;
    if(rooted(carbre)) (void) unroot_c(carbre);


	/* COMPUTE BOOTSTRAP SUPPORT AT EACH NODE */

    if (option==1){ 

      binb[nbex]=(double*)check_alloc(nb-3, sizeof(double));
      barbre=(int**)check_alloc(nb-3, sizeof(int*));
      for(i=0;i<nb-3;i++) barbre[i]=(int*)check_alloc(lliste, sizeof(int));
      (void) tree_ctob(carbre, treename, barbre);

      for(i=0;i<nb-3;i++){	
	binb[nbex][i]=0.;
	for(j=0;j<nbbranche;j++){
	  if(memebranche(barbre[i], listbbranche[j], lliste, nb)){
	    binb[nbex][i]=listbval[j];
	    break;
	  }
	}
        binb[nbex][i]/=(nbrep/100.); 
      }
    }


	/* CREATE S_TREE AND DRAW */

    (void) tree_ctot(carbre, tarbre, lgbi, lgbp, NULL, treeresname, &rac);
    sarbre[nbex]=(noeud*)check_alloc(2*nb, sizeof(noeud));
    (void) tree_ttos(tarbre, nb, lgbi, lgbp, binb[nbex], treeresname, sarbre[nbex]);

/*
fin=time(NULL);
if(method==2){
  (void) printf("expected running time : %f\n", exp_run_time);
  (void) printf("actual running time :  %f\n", difftime(fin, debut));
  (void) printf("\n");
}

if(method==1) 
  (void) printf("meth NJ%d : %d sp, %d sites, %d replicates. RT=%f\n",
          dd+PROTB?10:0, nb, lg, nbrep, difftime(fin, debut));
else if(method==2) 
  (void) printf("meth MP : %d sp, %d sites, %d replicates. RT=%f\n",
          nb, lg, nbrep, difftime(fin, debut));
else if(method==3) 
  (void) printf("meth ML : %d sp, %d sites, %d replicates. RT=%f\n", nb, lg, nbrep, difftime(fin, debut));
*/

    ArrowCursor();
    nbtreew ++;
    for(i=0;i<MAXTREEW;i++) if (!openedtreew[i]) {curtreew=i; openedtreew[i]=TRUE; break; }
    if(nbtreew<MAXTREEW){
      root[curtreew]=create_node(NULL, NULL, NULL, 0., 0., 0., -1., -1., -1., NULL);
      stree_root(sarbre[nbex], central_branch(sarbre[nbex], nb), bl);
      organize(NULL, root[curtreew]);
      memroot[curtreew]=root[curtreew];
      memnb[curtreew]=nb;
      for(i=0;i<2*nb-2;i++) sarbre[nbex][i]->color=0;
      root[curtreew]->color=0;
      if(option==1){
        (*(bootbranche[nbrep*(nb-3)]))++;
        drawtree(sarbre[nbex], nb, header, bl, bs, bs&&COMBALLOWED, 0,
           -1., -1., bootbranche, 1, nbrep, treename, "new tree");
      }
      else drawtree(sarbre[nbex], nb, header, bl, bs, bs&&COMBALLOWED,
         0, -1., -1., NULL, 0,  -1, NULL, "new tree");
    }
    else { 
      (void) sprintf(texte, "Too many opened tree windows.\n");
      createmessbox(texte, FALSE, quiterr, NULL); 
      nbtreew=MAXTREEW-1; 
      return;
    }
    prov=NULL;
  }


	/* BOOTSTRAP CONSENSUS TREE */

  if(option==1 && CONSENSE){ 
    int* bestcomp;
    binb[nbex+1]=(double*)check_alloc(nb-3, sizeof(double));
    bestcomp=bilist_sort(listbbranche, listbval, nb, nbbranche);

    for(i=0;i<nb-3;i++){
      for(j=0;j<nb;j++){
        if(testbit(listbbranche[bestcomp[i]], j+1)) tarbre_cons[j][i]=1;
	else tarbre_cons[j][i]=0;
      }
      binb[nbex+1][i]=listbval[bestcomp[i]]/(nbrep/100.);
    }

    sarbre[nbex+1]=(noeud*)check_alloc(2*nb, sizeof(noeud));
    (void) tree_ttos(tarbre_cons, nb, NULL, NULL, binb[nbex+1], treename, sarbre[nbex+1]);
    
/*
if(method==2){
tree_stoc(sarbre[nbex+1], 1, nb, carbreprov);
ctree_noblbs(carbreprov, carbre_cons, (int)strlen(carbreprov));
if (PROTB)
  prot(treeseq, treename, nb, NULL, &steps, carbre_cons);
else
  pars(treeseq, treename, nb, NULL, &steps, carbre_cons);
printf("steps : %d\n", (int)steps);
}
*/
    (void) sprintf(header_cons, "%s", header);
    prov=strstr(header_cons, "bootstrap");
    prov-=10;
    prov=strchr(prov, '\n')+1;
    (void) sprintf(prov, "Consensus tree from %d bootstrap replicates\n", nbrep);
    ArrowCursor();
    nbtreew ++;
    for(i=0;i<MAXTREEW;i++) if (!openedtreew[i]) {curtreew=i; openedtreew[i]=TRUE; break; }
    if(nbtreew<MAXTREEW){
      root[curtreew]=create_node(NULL, NULL, NULL, 0., 0., 0., -1., -1., -1., NULL);
      stree_root(sarbre[nbex+1], central_branch(sarbre[nbex+1], nb), 0);
      organize(NULL, root[curtreew]);
      memroot[curtreew]=root[curtreew];
      memnb[curtreew]=nb;
      for(i=0;i<2*nb-2;i++) sarbre[nbex+1][i]->color=0;
      root[curtreew]->color=0;
      if(option==1){
        (*(bootbranche[nbrep*(nb-3)]))++;
        drawtree(sarbre[nbex+1], nb, header_cons, 0, 1, COMBALLOWED,
            0, -1., -1., bootbranche, 1, nbrep, treename, "new tree");
      }
      else
	drawtree(sarbre[nbex+1], nb, header_cons, 0, 1, COMBALLOWED,
            0, -1., -1., NULL, 0, -1, NULL, "new tree"); 
    }
    else { 
      (void) sprintf(texte, "Too many opened tree windows.\n");
      createmessbox(texte, FALSE, quiterr, NULL); 
      nbtreew=MAXTREEW-1; 
      return;
    }
  }


  for(i=0;i<nb;i++){
    free(tarbre[i]);
    free(treeseq[i]);
    free(treeresname[i]);
    if (option==1){
      free(bootseq[i]);
      if(i<nb-3) free(barbre[i]);
      if(CONSENSE) free(tarbre_cons[i]);
    }
  }
  if(method==1){
    for(i=0;i<nb+2;i++) free(d[i]);
    free(d);
  }
  free(treeseq); free(treename); 
  free(treeresname);free(tarbre); 
  if(lgbi) free(lgbi); if(lgbp) free(lgbp); if(bootvals) free(bootvals);
  free(carbre_boot); 

  free(carbre_jumb_init); 
  free(carbre_pars);
  free(texte);

  if(selected) free(selected);
  if(option==1){
    for(i=0;i<nbex;i++) free(binb[i]);
    free(bootseq);
    free(barbre); 
    if(CONSENSE){
      free(tarbre_cons); 
      free(carbreprov);
      free(carbre_cons);
    }
  }

  SetStatus(bboot, FALSE);
  SetStatus(bmult, FALSE);
  SetStatus(bjumb, FALSE);
  SetTitle(rep_text, "");
  option=0;
  Enable(bdt);
  return;
}


int samebranch(int** tree1, int br1, int** tree2, int br2, int notu){

  int i, diff=0, equal=0;

  for(i=0;i<notu;i++){
    if(tree1[i][br1]==tree2[i][br2]) equal=1; else diff=1;
    if(equal && diff) return 0;
  }
  return 1;

}




void sorttreevalues(int notu, int** sortedtree, char** sortedname,
       int** tree, char** name, double* value, double* sortedvalue){

  int i, j, **provtree;

  provtree=(int**)check_alloc(notu, sizeof(int*));

  for(i=0;i<notu;i++){
    for(j=0;j<notu;j++){
      if(samename(sortedname[i], name[j])){
	provtree[i]=tree[j];
	break;
      }
    }
  }


  for(i=0;i<notu-3;i++){
    for(j=0;j<notu-3;j++){
      if(samebranch(sortedtree, i, provtree, j, notu)){
	sortedvalue[i]=value[j];
	break;
      }
    }
  }
}


/* evaltree_act */
/* Evaluate selected tree according to parsimony or max. likelihood,  */
/* or evaluate branch length according to selected distance. */

void evaltree_act(ButtoN but){
  printdata dataseq, databd, datasite;
  char **evalseq, **evalname, *carbreprov, *carbre, rac, *texte;
  char c, header[MAXLHEAD], err_mess[100],*newbltree, **provname;
  int i, ii, j, l, lg=0, nb, sel=-1, memsel, **barbre, **tarbre;
  int  lliste, *selected, **provtree, bs;
  double steps, like, **d, *newbl, sce, tot, *lgbp, *lgbi, *bootstrap, *sortedbootstrap; 
  noeud* sarbre;
  
 
  WatchCursor();
  texte=(char*)check_alloc(1000, sizeof(char));
  GetPanelExtra(pbuild, &databd);
  for(i=0;i<nbtree;i++) if (databd.selected[i]) { sel=i; break; }
  if (sel==-1) { createmessbox("No selected tree", FALSE, quiterr, NULL); ArrowCursor(); return; }
  memsel=sel;
  carbreprov=strchr(memtree[sel], ']');
  if(carbreprov==NULL) carbreprov=memtree[sel];
  else carbreprov=strchr(carbreprov, '(');
  carbre=(char*)check_alloc(nbseq*50, sizeof(char));
  evalname=(char**)check_alloc(nbseq+1, sizeof(char*));
  for(i=0;i<=nbseq;i++) 
    evalname[i]=(char*)check_alloc(MAXLNAME+1, sizeof(char));
  nb=tree_ctot(carbreprov, NULL, NULL, NULL, NULL, evalname, &rac);
  if(rac=='r'){
    for(i=0;i<nb;i++) evalname[i]=evalname[i+1];
  }

  GetPanelExtra(psites, &datasite);
  GetPanelExtra(pseq, &dataseq);
  i=0; sel=-1;
  while(i<nbsitesets) if (datasite.selected[i++]) {sel=i-1; break;}
  selected=(int*)check_alloc(lgseq, sizeof(int));
  reg_and_pos(selected, dataseq.selected);
  for(i=0;i<lgseq;i++) if (selected[i]) lg++;
  evalseq=(char**)check_alloc(nb, sizeof(char*));
  for(i=0;i<nb;i++)
    evalseq[i]=(char*)check_alloc(lg+1, sizeof(char));
  for(i=0;i<nbseq;i++){
    sel=-1;
    for(j=0;j<nb;j++) 
      if (samename(cname[i], evalname[j])){ sel=j; break; }
    if (sel!=-1){
      ii=0;
      for(j=0;j<lgseq;j++){
	if (selected[j]){
          evalseq[sel][ii]=seq[i][j]; 
	  if(TRANSVONLY) evalseq[sel][ii]=pur_pyr(seq[i][j]);
          ii++;
	}
      }
    }
  }
  for(i=0;i<nb;i++) evalseq[i][lg]=0;
  for(i=0;i<nb;i++) for(j=0;j<lg;j++) {
    c=evalseq[i][j];
    if (!PROTB && 
        c!='A' && c!='C' && c!='G' && c!='T' && c!='U' &&
        (!TRANSVONLY || (c!='R' && c!='Y'))) evalseq[i][j]='-';
    if (c=='U') evalseq[i][j]='T';
    if (PROTB && (c=='X' || !isalpha(c)) ) evalseq[i][j]='-';
  }
  refresh(evalseq, nb, 0, PROTB);
  lg=(int)strlen(evalseq[0]);
  if(method==1){

    (void) sprintf(header, "%d species, %d sites\ntopology of tree %s", nb, lg, memtreename[memsel]);
    (void) sprintf(strchr(header,'('),"\nleast square estimates of branch lengths\naccording to ");
    l=(int)strlen(header);
    lliste=(nb+lmot-1)/lmot;
    barbre=(int**)check_alloc(nb, sizeof(int*));
    for(i=0;i<nb;i++) 
      barbre[i]=(int*)check_alloc(lliste, sizeof(int));
    if (rooted(carbreprov)) (void) unroot_c(carbreprov);
    (void) tree_ctob(carbreprov, evalname, barbre);
    d=(double**)check_alloc(nb+2, sizeof(double*));
    for(i=0;i<nb+2;i++)
      d[i]=(double*)check_alloc(nb+2, sizeof(double));
    if(!compute_dist(evalseq, nb, lg, d, header+l)){
      createmessbox("Cannot compute distances", FALSE, quiterr, NULL);
      ArrowCursor();
      return;
    }
    newbl=lslgbr(barbre, nb, d, &sce, &tot);
    lgbp=newbl; lgbi=newbl+nb;    
    sarbre=(noeud*)check_alloc(2*nb, sizeof(noeud));
    (void) tree_btos(barbre, nb, lgbi, lgbp, NULL, evalname, sarbre);
    nbtreew ++;
    for(i=0;i<MAXTREEW;i++) if (!openedtreew[i]) {curtreew=i; openedtreew[i]=TRUE; break; }
    if(nbtreew<MAXTREEW){
      root[curtreew]=create_node(NULL, NULL, NULL, 0., 0., 0., -1., -1., -1., NULL);
      stree_root(sarbre, central_branch(sarbre, nb), 1);
      organize(NULL, root[curtreew]);
      memroot[curtreew]=root[curtreew];
      memnb[curtreew]=nb;
      for(i=0;i<2*nb-2;i++) sarbre[i]->color=0;
      root[curtreew]->color=0;
      drawtree(sarbre, nb, header, 1, 0, 0, 1, sce, tot, NULL, 0, -1, NULL, memtreename[memsel]);
   }
    else { 
      (void) sprintf(texte, "Too many opened tree windows.\n");
      createmessbox(texte, FALSE, quiterr, NULL); 
      nbtreew=MAXTREEW-1; 
      return;
    }
  }
  if (method==2){
    ctree_noblbs(carbreprov, carbre, (int)strlen(carbreprov));
    if (rac=='n') ctree_root(carbre);
    if (PROTB)
      prot(evalseq, evalname, nb, NULL, &steps, carbre);
    else
      pars(evalseq, evalname, nb, NULL, &steps, carbre);
    (void) sprintf(texte, "%s", memtreename[memsel]);
    (void) sprintf(strchr(texte, '('),
         " (%d species, %d sites). Min. number of steps : %d", nb, lg, (long)steps);
    createmessbox(texte, FALSE, quiterr, NULL);
  }
  if (method==3){
    int showtreebut=TRUE;
    bootstrap=(double*)check_alloc(nbseq+1, sizeof(double));
    for(i=0;i<nbseq;i++) bootstrap[i]=-1.;
    sortedbootstrap=(double*)check_alloc(nbseq+1, sizeof(double));
    provname=(char**)check_alloc(nbseq+1, sizeof(char*));
    for(i=0;i<nbseq+1;i++) 
      provname[i]=(char*)check_alloc(MAXLNAME+1, sizeof(char));
    provtree=(int**)check_alloc(nbseq+1, sizeof(int*));
    for(i=0;i<nbseq+1;i++) 
      provtree[i]=(int*)check_alloc(nbseq+1, sizeof(int));
    nb=tree_ctot(carbreprov, provtree, NULL, NULL, bootstrap, provname, &rac);
    if(rac=='r') (void) unroot(provtree, nb, NULL, NULL, bootstrap, provname, NULL, NULL, NULL, NULL);
    if(bootstrap[0]>-0.5) bs=TRUE; else bs=FALSE;
    ctree_noblbs(carbreprov, carbre, strlen(carbreprov));
    addquotes(&carbre); 
    if(Gduring>nb-3) Gduring=nb-3;
    if(Gafter>nb-3) Gafter=nb-3;
    err_mess[0]='\0';
    newbltree=ml(evalseq, evalname, nb, NULL, &like, carbre, err_mess);
    (void) sprintf(texte, "%s", memtreename[memsel]);
    (void) sprintf(strchr(texte, '('),"(%d species, %d sites). Likelihood : %f ", nb, lg, like); 
    (void) sprintf(header, 
    "%d species, %d sites\ntopology of tree %s\nmaximum likelihood branch lengths\nlikelihood : %f",
       nb, lg, memtreename[memsel], like);
    tarbre=(int**)check_alloc(nb+1, sizeof(int*));
    for(i=0;i<nb+1;i++) 
      tarbre[i]=(int*)check_alloc(nb+1, sizeof(int));
    if (rooted(newbltree)) (void) unroot_c(newbltree);
    lgbi=(double*)check_alloc(nb, sizeof(double));
    lgbp=(double*)check_alloc(nb, sizeof(double));
    (void) tree_ctot(newbltree, tarbre, lgbi, lgbp, NULL, evalname, &rac);
    sorttreevalues(nb, tarbre, evalname, provtree, provname, bootstrap, sortedbootstrap);
    sarbre=(noeud*)check_alloc(2*nb, sizeof(noeud));
    (void) tree_ttos(tarbre, nb, lgbi, lgbp, sortedbootstrap, evalname, sarbre);
    nbtreew++;
    for(i=0;i<MAXTREEW;i++) if (!openedtreew[i]) {curtreew=i; openedtreew[i]=TRUE; break; }
    if(nbtreew<MAXTREEW){
      root[curtreew]=create_node(NULL, NULL, NULL, 0., 0., 0., -1., -1., -1., NULL);
      stree_root(sarbre, central_branch(sarbre, nb), 1);
      organize(NULL, root[curtreew]);
      memroot[curtreew]=root[curtreew];
      memnb[curtreew]=nb;
      for(i=0;i<2*nb-2;i++) sarbre[i]->color=0;
      root[curtreew]->color=0;
      DONOTSHOWTREE=TRUE;
      drawtree(sarbre, nb, header, 1, bs, 0, 1, -1., -1., NULL, bs, -1, NULL, memtreename[memsel]);
      free(lgbi); free(lgbp); free(bootstrap);
    }
    else{
      (void) sprintf(texte+strlen(texte), "(too many opened tree windows to draw tree)");
      nbtreew=MAXTREEW-1;
      showtreebut=FALSE;
    }
    if(err_mess[0]=='\0')
      createmlmessbox(texte, showtreebut);
    else
      createmessbox(err_mess, FALSE, quiterr, NULL);
  }
  SetTitle(bdt, SMALLSCREEN?"BUILD":"MAKE TREE");
  enablebuttons();
  SetPanelExtra(pbuild, &databd);
  draw(pbuild);
  ArrowCursor();  

  free(carbre);
  for(i=0;i<=nbseq;i++) free(evalname[i]);
  free(evalname);
  for(i=0;i<nb;i++) free(evalseq[i]);
  free(evalseq);
  if(method==1){
    for(i=0;i<nb-3;i++) free(barbre[i]);
    free(barbre);
    for(i=0;i<nb+2;i++) free(d[i]);
    free(d);
  }
  free(texte);
  free(selected); 
}




/* dnacolpaint */
/* Paint column num of nucleotidic alignment seq at rectangle rect. */
/* Useful for scrolling without calling the time-consuming drawing procedure. */

void dnacolpaint (int num, RecT rect){

  int i, x, y, deb, fin;
  char c;
  printdata dataseq, dataname;

  GetPanelExtra(pseq, &dataseq);
  GetPanelExtra(pname, &dataname);
  x=rect.left;
  y=rect.top+dataseq.lineheight;
  deb=dataname.prem_ligne+2;
  fin=deb+dataname.nbr_lignes-2;
  if (fin>dataseq.tot_lignes) fin=dataseq.tot_lignes;
  SetColor(cola);
  for(i=deb;i<fin;i++){
    if(dataseq.lignes[i][num]=='A'){
      MoveTo(x, y+(i-deb)*dataseq.lineheight);
      if(TRANSVONLY) PaintChar('R'); else PaintChar('A');
    }
    if(TRANSVONLY && dataseq.lignes[i][num]=='R'){
      MoveTo(x, y+(i-deb)*dataseq.lineheight);
      PaintChar('R');
    }
  }
  SetColor(colc);
  for(i=deb;i<fin;i++){
    if(dataseq.lignes[i][num]=='C'){
      MoveTo(x, y+(i-deb)*dataseq.lineheight);
      if(TRANSVONLY) PaintChar('Y'); else PaintChar('C');
    }
    if(TRANSVONLY && dataseq.lignes[i][num]=='Y'){
      MoveTo(x, y+(i-deb)*dataseq.lineheight);
      PaintChar('Y');
    }
  }
  SetColor(colg);
  for(i=deb;i<fin;i++){
    if(dataseq.lignes[i][num]=='G'){
      MoveTo(x, y+(i-deb)*dataseq.lineheight);
      if(TRANSVONLY) PaintChar('R'); else PaintChar('G');
    }
  }	
  SetColor(colt);
  for(i=deb;i<fin;i++){
    if(dataseq.lignes[i][num]=='T'){
      MoveTo(x, y+(i-deb)*dataseq.lineheight);
      if(TRANSVONLY) PaintChar('Y'); else PaintChar('T');
    }
  }	
  SetColor(coln);
  for(i=deb;i<fin;i++){
    c=dataseq.lignes[i][num];
    if(c!='A' && c!='C' && c!='G' && c!='T' && (!TRANSVONLY || (c!='R' && c!='Y'))){
      MoveTo(x, y+(i-deb)*dataseq.lineheight);
      PaintChar(c);
    }
  }

  Black();
}


/* protcolpaint */
/* Paint column num of proteic alignment seq at rectangle rect. */
/* Useful for scrolling without calling time-consuming drawing procedure. */

void protcolpaint (int num, RecT rect){
  int i, x, y, deb, fin;
  printdata dataseq, dataname;


  GetPanelExtra(pseq, &dataseq);
  GetPanelExtra(pname, &dataname);
  x=rect.left;
  y=rect.top+dataseq.lineheight;
  deb=dataname.prem_ligne+2;
  fin=deb+dataname.nbr_lignes-2;
  if (fin>dataseq.tot_lignes) fin=dataseq.tot_lignes;
  SetColor(col1);
  for(i=deb;i<fin;i++){
    if(aaclass(dataseq.lignes[i][num])==0){
      MoveTo(x, y+(i-deb)*dataseq.lineheight);
      PaintChar(dataseq.lignes[i][num]);
    }
  }
  SetColor(col2);
  for(i=deb;i<fin;i++){
    if(aaclass(dataseq.lignes[i][num])==1){
      MoveTo(x, y+(i-deb)*dataseq.lineheight);
      PaintChar(dataseq.lignes[i][num]);
    }
  }
  SetColor(col3);
  for(i=deb;i<fin;i++){
    if(aaclass(dataseq.lignes[i][num])==2){
      MoveTo(x, y+(i-deb)*dataseq.lineheight);
      PaintChar(dataseq.lignes[i][num]);
    }
  }
  SetColor(col4);
  for(i=deb;i<fin;i++){
    if(aaclass(dataseq.lignes[i][num])==3){
      MoveTo(x, y+(i-deb)*dataseq.lineheight);
      PaintChar(dataseq.lignes[i][num]);
    }
  }
  SetColor(col5);
  for(i=deb;i<fin;i++){
    if(aaclass(dataseq.lignes[i][num])==4){
      MoveTo(x, y+(i-deb)*dataseq.lineheight);
      PaintChar(dataseq.lignes[i][num]);
    }
  }
  SetColor(coln);
  for(i=deb;i<fin;i++){
    if(aaclass(dataseq.lignes[i][num])==5){
      MoveTo(x, y+(i-deb)*dataseq.lineheight);
      PaintChar(dataseq.lignes[i][num]);
    }
  }

  Black();
}


/* monolineclick */
/* Select clicked line and de-select others. */
/* Click procedure for panel loadmenu. */

void monolineclick(PaneL panel, PoinT pt){
printdata data;
RecT rect;
int num, old, i;

GetPanelExtra(panel,&data);
Select(panel);
ObjectRect(panel,&rect);
num = (pt.y - rect.top-data.lineheight/2)/data.lineheight + data.prem_ligne;
if (num >= data.tot_lignes) return;
old=-1;
for(i=0; i<data.tot_lignes; i++)
  if(data.selected[i]) { old=i; break; }
if(old>=0)
	data.selected[old]= 0;
if(num>=0 && num!=old)
	data.selected[num]=1;
SetPanelExtra(panel,&data);
draw(panel);
if (data.callback) (*data.callback)(panel); 
}



/* shiftlineclick */
/* Select clicked line. */
/* Click procedure for panels pspecies, psites. */

void shiftlineclick(PaneL panel, PoinT pt){
printdata data;
RecT rect;
int num, i;

GetPanelExtra(panel,&data);
Select(panel);
ObjectRect(panel,&rect);
num = (pt.y - rect.top-data.lineheight/2)/data.lineheight + data.prem_ligne;
if (num >= data.tot_lignes) return;
for(i=0; i<data.tot_lignes; i++){
  if(!shftKey && i!=num) data.selected[i]=0;
  if(i==num) data.selected[i]=1-data.selected[i]; 
}
SetPanelExtra(panel,&data);
draw(panel);
if (data.callback) (*data.callback)(panel); 
}


/* pnameclick */
/* Set nameclickrk = rank of clicked specie name. */
/* Click procedure for panel pname. */

void pnameclick(PaneL panel, PoinT pt){
printdata data;
RecT rect;
  if (!shftKey){
    GetPanelExtra(panel,&data);
    Select(panel);
    ObjectRect(panel,&rect);
    nameclickrk = (pt.y - rect.top-data.lineheight/2)/data.lineheight + data.prem_ligne - 2;
  }
}



/* pnamerelease */
/* Select/unselect species between last click- and last release- points. */
/* No changes to others. */
/* Release procedure for panel pname. */

void pnamerelease(PaneL panel, PoinT pt){
printdata data, dataseq;
RecT rect, linerect;
int i, j, num1, num2, a, inv=0, lg, deb, fin;
PoinT pt2;

GetPanelExtra(panel,&data);
Select(panel);
ObjectRect(panel,&rect);
num2 = (pt.y - rect.top-data.lineheight/2)/data.lineheight + data.prem_ligne - 2;
a=mini(nameclickrk, num2);
if(a==num2){ num2=nameclickrk; num1=a; inv=1;}
else num1=nameclickrk;
if (num1 >=data.tot_lignes  || num1>data.prem_ligne+data.nbr_lignes || num2<0) return;
if (num1<0) num1=0;
if (num2>=data.tot_lignes) num2=data.tot_lignes-1;
a=inv? data.selected[num2]:data.selected[num1];
if (shftKey) a=1-a;
for(i=num1;i<=num2;i++)
  data.selected[i]=1-a;
draw(pname);
SetPanelExtra(panel,&data);
if(HIDDENSEQ) {if (data.callback) (*data.callback)(panel); return;}
Select(pseq);
GetPanelExtra(pseq, &dataseq);
ObjectRect(pseq, &rect);
rect.right--;
rect.left++;
rect.top+=dataseq.lineheight*(2+maxi(num1-dataseq.prem_ligne, 0))+2;
rect.bottom=rect.top+dataseq.lineheight;
pt2.x=rect.left+dataseq.charwidth;
lg=mini(dataseq.nbr_cols, lgseq-dataseq.prem_ligne);
deb=maxi(num1, dataseq.prem_ligne);
fin=mini(num2, dataseq.prem_ligne+dataseq.nbr_lignes-3);
setblockbounds();
SelectFont(gras);
for (i=deb; i<=fin; i++){
  SetColor(fonduns_col); InvertColors();
  linerect.top=rect.top+3; linerect.bottom=rect.bottom+4;
  linerect.left=rect.left; linerect.right=rect.right;
  EraseRect(&linerect);
  if(data.selected[i]){ 
    SetColor(fondsel_col); InvertColors();
    for(j=0;j<hblock;j++){
      linerect.left=hbound[2*j];
      linerect.right=hbound[2*j+1];
      EraseRect(&linerect);
    }
  }
  pt2.y=rect.bottom+1;
  linepaint(dataseq.lignes[i+2]+dataseq.prem_col, pt2, lg);
  rect.top+=dataseq.lineheight;
  rect.bottom+=dataseq.lineheight;
}
if (data.callback) (*data.callback)(panel); 
}


/* movelines */
/* Move specie num1 to place num2. */
/* screen : panel pname and pseq are changed. */
/* memory : names, sequences, comments, selected species, species sets */
/* and GC contents are changed. */
 
void movelines(int num1, int num2){

  char* seqprov, *nameprov, *nameligneprov, *commprov;
  int i, j, selprov, sens, mi, ma;
  double gcprov;
  printdata dataname, dataseq;
 
  if (num1==num2) return;
  sens=(num1<num2)?1:-1;
  mi=mini(num1, num2);
  ma=maxi(num1, num2);

  GetPanelExtra(pname, &dataname);
  GetPanelExtra(pseq, &dataseq);
  
  seqprov=seq[num1];
  nameprov=cname[num1];
  nameligneprov=dataname.lignes[num1];
  commprov=comments[num1];
  selprov=dataname.selected[num1];
  if (!PROTB) gcprov=gc[num1];
  
  for(j=mi;j<ma;j++){
    if (sens==1) i=j; else i=num1-(j-num2);
    seq[i]=seq[i+sens];
    dataseq.lignes[i+2]=dataseq.lignes[i+2+sens];
    cname[i]=cname[i+sens];
    dataname.lignes[i]=dataname.lignes[i+sens];
    comments[i]=comments[i+sens];
    dataname.selected[i]=dataname.selected[i+sens];
    if(!PROTB) gc[i]=gc[i+sens];
  }
  
  seq[num2]=seqprov;
  dataseq.lignes[num2+2]=seqprov;
  cname[num2]=nameprov;
  dataname.lignes[num2]=nameligneprov;
  comments[num2]=commprov;
  dataname.selected[num2]=selprov;
  if (!PROTB) gc[num2]=gcprov;

  for(i=0;i<nbspecsets;i++){
    for(j=1;j<=specset[i][0];j++){
      if ((specset[i][j]>mi && specset[i][j]<ma) || specset[i][j]==num2)
        specset[i][j]-=sens;
      else if (specset[i][j]==num1) specset[i][j]=num2;
    }
  }

  SetPanelExtra(pname, &dataname);
  SetPanelExtra(pseq, &dataseq);
}



/* pnamemove */
/* Release procedure for panel pname when command "Move" is called. */
  
void pnamemove(PaneL panel, PoinT pt){
printdata data;
RecT rect;
int num1, num2;

GetPanelExtra(panel,&data);
Select(panel);
ObjectRect(panel,&rect);
num2 = (pt.y - rect.top-data.lineheight/2)/data.lineheight + data.prem_ligne - 2;
num1=nameclickrk;
if (num1<0) num1=0;
if (num2<0) num2=0;
if (num2>=data.tot_lignes) num2=data.tot_lignes-1;
if (num1>=data.tot_lignes) num1=data.tot_lignes-1;
movelines(num1, num2);
Enable(mess_ok);
draw(pname);
draw(pseq);
}


/* pseqclick */
/* Set seqclickrk = rank of clicked site */
/* Click procedure for panel pseq. */

void pseqclick(PaneL panel, PoinT pt){
printdata data;
RecT rect;
  if (!shftKey){
    GetPanelExtra(panel,&data);
    Select(panel);
    ObjectRect(panel,&rect);
    seqclickrk = (pt.x - rect.left)/data.charwidth + data.prem_col - 1;
  }
}


/* pseqrelease */
/* Select/unselect sites between last click- and last release- points. */
/* No changes to others. */
/* Release procedure for panel pseq. */

void pseqrelease(PaneL panel, PoinT pt)
{
printdata data;
RecT rect, colblock;
int i, j, num2, a, inv=0, deb, fin;

if(!PROTB && !(GetStatus(po1i) && GetStatus(po2i) && GetStatus(po3i))){
  createmessbox("Please select all codon positions to change site selection", FALSE, quiterr, NULL);
  return;
}

GetPanelExtra(panel, &data);
Select(panel);
ObjectRect(panel, &rect);
num2=(pt.x-rect.left)/data.charwidth+data.prem_col-1;
a=mini(seqclickrk, num2);
if (a==num2) { num2=seqclickrk; seqclickrk=a; inv=1;}
if (seqclickrk >=data.tot_cols  || seqclickrk>data.prem_col+data.nbr_cols || num2<0) return;
if (seqclickrk<0) seqclickrk=0;
if (num2>=data.tot_cols) num2=data.tot_cols-1;
a=inv? data.selected[num2]:data.selected[seqclickrk];
if (shftKey) a=1-a;
/*deb=maxi(seqclickrk, data.prem_col+1);*/
deb=maxi(seqclickrk, data.prem_col);
fin=mini(num2, data.prem_col+data.nbr_cols-1);
for(i=seqclickrk; i<=num2;i++) data.selected[i]=1-a;

SetPanelExtra(panel, &data);
rect.top+=2*data.lineheight+2;
rect.bottom--;
if (seqclickrk>data.prem_col) rect.left+=data.charwidth*(seqclickrk-data.prem_col+1);
else rect.left+=data.charwidth;
/*if(deb==data.prem_col+1 && seqclickrk==data.prem_col) {
  data.selected[data.prem_col]=1-a;
  deb--;
}*/
rect.left++;
rect.right=rect.left+data.charwidth;
rect.top++;
SelectFont(gras);
for(i=deb;i<=fin;i++){
  colblock.left=rect.left-1;
  colblock.right=rect.right;
  colblock.top=rect.top;
  colblock.bottom=rect.bottom;
  SetColor(fonduns_col); InvertColors(); EraseRect(&colblock);
  if(data.selected[i]){
    SetColor(fondsel_col); InvertColors();
    for(j=0;j<vblock;j++){
      colblock.top=vbound[2*j];
      colblock.bottom=vbound[2*j+1];
      EraseRect(&colblock);
    }
  }
  if (PROTB) protcolpaint(i, rect); else dnacolpaint(i, rect);
  rect.left+=data.charwidth;
  rect.right+=data.charwidth;
}
if (data.callback) (*data.callback)(panel); 
}


/* hscroll */
/* Horizontal scrolling function. */

void hscroll(BaR bar, SlatE slate, int newval, int oldval){
	printdata        data;
	int             j, x, y, toinval=1, end, deb, deb0, deb0prov, *selected;
	RecT            rect, colblock;


	GetPanelExtra((PaneL) slate, &data);
	data.prem_col = newval;
	SetPanelExtra((PaneL) slate, &data);
	Select(slate);
        SelectFont(gras);

	selected=(int*)check_alloc(lgseq, sizeof(int));
	reg_and_pos(selected, data.selected);

	if (newval == oldval + 1) {
		end=data.prem_col+data.nbr_cols;
		fromscroll=toinval;
		ObjectRect(slate, &rect);
		y = rect.top;
		x = rect.right;
		rect.left += data.charwidth;
		rect.bottom--;
		rect.right--;
		rect.top++;
		ScrollRect(&rect, -data.charwidth, 0);
		LoadRect(&rect, x-2*data.charwidth, y+2*data.lineheight+2 ,
                      x-data.charwidth, y+data.nbr_lignes*data.lineheight);

  		SetColor(fonduns_col); InvertColors(); EraseRect(&rect);
  		if(selected[end-1]){
  		  colblock.left=rect.left-1;
   		  colblock.right=rect.right+1;
   		  SetColor(fondsel_col); InvertColors();
		  for(j=0;j<vblock;j++){
		    colblock.top=vbound[2*j];
		    colblock.bottom=vbound[2*j+1];
		    EraseRect(&colblock);
		  }
		}
rect.top+=1;
		if (PROTB) protcolpaint(end-1, rect); else dnacolpaint(end-1, rect);
		if (end%10==0){
		  char nb[6];
		  (void) sprintf(nb, "%d",end);
	 	  while(end/10!=0){ end/=10; toinval++;}		
		  MoveTo(x-2*data.charwidth,y+2*data.lineheight+2);
		  PaintChar('|');
		  MoveTo(x-(1+toinval)*data.charwidth, y+data.lineheight+2);
		  PaintString(nb);
		}
	} else if (newval == oldval - 1) { 
		fromscroll=-1;
		deb=data.prem_col+1;
		ObjectRect(slate, &rect);
		y = rect.top;
		x = rect.left;
		rect.bottom --;
		rect.top++;
		rect.left++;
		rect.right-=(data.charwidth+1);
		ScrollRect(&rect, data.charwidth, 0);
		LoadRect(&rect, x+data.charwidth+1, y+2*data.lineheight+2 ,
                   x+2*data.charwidth, y+data.nbr_lignes*data.lineheight);

  		SetColor(fonduns_col); InvertColors(); EraseRect(&rect);
  		if(selected[deb-1]){
  		  colblock.left=rect.left-1;
  		  colblock.right=rect.right+1;
  		  SetColor(fondsel_col); InvertColors();
  		  for(j=0;j<vblock;j++){
    		    colblock.top=vbound[2*j];
    		    colblock.bottom=vbound[2*j+1];
   		    EraseRect(&colblock);
   		  }
 		}
rect.top+=1;
		if (PROTB) protcolpaint(deb-1, rect); else dnacolpaint(deb-1, rect);
		if (deb%10==0){
		  MoveTo(x+data.charwidth+1, y+2*data.lineheight+2);
		  PaintChar('|');
		}
		deb0prov=deb0=10*((int)(deb/10.)+1);
		while(deb0prov/10!=0){ deb0prov/=10; toinval++;}
		if (deb+toinval-1==deb0){
		  char nb[6];
		  (void) sprintf(nb, "%d", deb0);
		  MoveTo(x+data.charwidth+1, y+data.lineheight+2);
		  PaintString(nb);
		}
	} else {
		fromscroll=0;
		draw((PaneL) slate);
	}

	free(selected);
}

void hscrollpseq(BaR bar, SlatE useless, int newval, int oldval){
  hscroll(bar, (SlatE) pseq, newval, oldval);
}



/* vscroll */
/* Vertical scrolling function. */

void vscroll(BaR bar, SlatE slate, int newval, int oldval)
{
	printdata        data;
	int            x, y;
	RecT            rect;

	GetPanelExtra((PaneL) slate, &data);
	data.prem_ligne = newval;
	SetPanelExtra((PaneL) slate, &data);
	Select(slate);

	if (newval == oldval + 1) {
		ObjectRect(slate, &rect);
		y = rect.top + data.nbr_lignes * data.lineheight;
		x = rect.left + data.charwidth;
		rect.top += (data.lineheight - data.ascent - 1);
		rect.bottom--;
		rect.left++;
		rect.right--;
		ScrollRect(&rect, 0, -data.lineheight);
		LoadRect(&rect, x, y - data.lineheight + 2,
			 x + data.nbr_cols * data.charwidth, y + 2);
		InvalRect(&rect);
	} else if (newval == oldval - 1) {
		ObjectRect(slate, &rect);
		y = rect.top + data.lineheight;
		x = rect.left + data.charwidth;
		rect.bottom = y + data.nbr_lignes * data.lineheight - data.ascent - 1;
		rect.top++;
		rect.left++;
		rect.right--;
		ScrollRect(&rect, 0, data.lineheight);
		LoadRect(&rect, x, y - data.lineheight + 2,
			 x + data.nbr_cols * data.charwidth, y + 2);
		InvalRect(&rect);
	} else {
		draw((PaneL) slate);
	}
}



/* Vertical scrolling function for panels with non-scrolling header */
/* (2 top lines) : pname and pseq. */ 

void vscroll_head2(BaR bar, SlatE slate, int newval, int oldval)
{
	printdata        data;
	int            x, y;
	RecT            rect;

	GetPanelExtra((PaneL) slate, &data);
	data.prem_ligne = newval;
	SetPanelExtra((PaneL) slate, &data);
	Select(slate);

	if (newval == oldval + 1) {
		ObjectRect(slate, &rect);
		y = rect.top + data.nbr_lignes * data.lineheight;
		x = rect.left + data.charwidth;
		rect.top += 2 * data.lineheight+6;
		rect.bottom--;
		rect.left++;
		rect.right--;
		ScrollRect(&rect, 0, -data.lineheight);
		LoadRect(&rect, x, y - data.lineheight + 2,
			 x + data.nbr_cols * data.charwidth, y + 2);
		InvalRect(&rect);
	} else if (newval == oldval - 1) {
		ObjectRect(slate, &rect);
		y = rect.top + 3 * data.lineheight ;
		x = rect.left + data.charwidth;
		rect.bottom = y + (data.nbr_lignes - 2) * data.lineheight - data.ascent - 1;
		rect.top += 2 + 2 * data.lineheight;
		rect.left++;
		rect.right--;
		ScrollRect(&rect, 0, data.lineheight);
		LoadRect(&rect, x, y-6,
			 x + data.nbr_cols * data.charwidth, y + data.lineheight-6);
		InvalRect(&rect);
	} else {
		draw((PaneL) slate);
	}
}

void vscrollpname(BaR bar, SlatE useless, int newval, int oldval)
{
  vscroll_head2(bar, (SlatE)pname, newval, oldval);
  vscroll_head2(bar, (SlatE)pseq, newval, oldval);
}


/* settotlignes */
/* Set extra value tot_lignes (total) and vertical scroll bar parameters of panel panel. */

void settotlignes(PaneL panel,int total){
BaR bar;
printdata data;
int page, max, oldmax;

GetPanelExtra(panel,&data);
oldmax=data.tot_lignes - data.nbr_lignes + 1;
if(oldmax<0) oldmax=0;
data.tot_lignes=total;
bar=GetSlateVScrollBar((SlatE)panel);
if (bar==NULL) bar=data.vertical;
page=data.nbr_lignes-1;
max=data.tot_lignes - data.nbr_lignes + 1;
if(max<0) max=0;
if(data.prem_ligne > max) data.prem_ligne=max;
if(data.prem_ligne < 0) data.prem_ligne=0;
if(data.prem_ligne>oldmax) {
	CorrectBarMax(bar,max);
	CorrectBarValue(bar,data.prem_ligne);
	}
else	{
	CorrectBarValue(bar,data.prem_ligne);
	CorrectBarMax(bar,max);
	}
CorrectBarPage(bar,page,page);
SetPanelExtra(panel,&data);
Select(panel);
draw(panel);
return;
}


/* settotcols */
/* Set extra value tot_cols (total) and horizontal scroll bar */
/* parameters of panel panel */

void settotcols(PaneL panel,int total){
BaR bar;
printdata data;
int page, max, oldmax;

GetPanelExtra(panel,&data);
oldmax=data.tot_cols - data.nbr_cols /*+ 1*/;
if(oldmax<0) oldmax=0;
data.tot_cols=total;
bar=GetSlateHScrollBar((SlatE)panel);
if (bar==NULL) bar=data.horizontal;
page=data.nbr_cols-1;
max=data.tot_cols - data.nbr_cols /*+1*/;
if(max<0) max=0;
if(data.prem_col > max) data.prem_col=max;
if(data.prem_col < 0) data.prem_col=0;
if(data.prem_col>oldmax) {
	CorrectBarMax(bar,max);
	CorrectBarValue(bar,data.prem_col);
	}
else	{
	CorrectBarValue(bar,data.prem_col);
	CorrectBarMax(bar,max);
	}
CorrectBarPage(bar,page,page);
SetPanelExtra(panel,&data);
return;
}


/* settotlignes_head2 */
/* Same as settotlignes for panels with non-scrolling header */
/* (2 top lines) : pname and pseq. */

void settotlignes_head2(PaneL panel,int total)
{
BaR bar;
printdata data;
int page, max, oldmax;

GetPanelExtra(panel,&data);
oldmax=data.tot_lignes - data.nbr_lignes + 1;
if(oldmax<0) oldmax=0;
data.tot_lignes=total;
bar=GetSlateVScrollBar((SlatE)panel);
if (bar==NULL) bar=data.vertical;
page=data.nbr_lignes-1;
max=data.tot_lignes - data.nbr_lignes + 1 +2;
if(max<0) max=0;
if(data.prem_ligne > max) data.prem_ligne=max;
if(data.prem_ligne < 0) data.prem_ligne=0;
if(data.prem_ligne>oldmax) {
	CorrectBarMax(bar,max);
	CorrectBarValue(bar,data.prem_ligne);
	}
else	{
	CorrectBarValue(bar,data.prem_ligne);
	CorrectBarMax(bar,max);
	}
CorrectBarPage(bar,page,page);
SetPanelExtra(panel,&data);
Select(panel);
draw(panel);
return;
}



/* boldstring */
/* Paint string texte at point pt. */
/* Font (bold/not bold) is given by boolean bold. */

void boldstring(PoinT pt, char* texte, Boolean bold){
LtGray(); InvertColors(); Black();
if (bold) SelectFont(gras); else SelectFont(maigre);
SetPen(pt);
PaintString(texte);
}


/* drawpanel */
/* Drawing procedure for panel pspecies, psites and pbuild */

void drawpanel(PaneL p)
{
  RecT  r;
  int i, x, y;
  printdata data;
  PoinT pt;

  LtGray(); InvertColors(); Black();
  Select(p);
  GetPanelExtra(p, &data);
  SelectFont(data.font);
  ObjectRect (p, &r);
  FrameRect(&r);
  if(data.tot_lignes== -1) return;
  x=r.left+data.charwidth;
  y=r.top+data.lineheight;
  InsetRect(&r,1,1);
  EraseRect(&r); 
  for(i=data.prem_ligne;i<data.prem_ligne+data.nbr_lignes && i<data.tot_lignes;i++){
    LoadPt(&pt, x, y+2);
    boldstring(pt, data.lignes[i], data.selected[i]);
    y+=data.lineheight;
  }
}



/* drawnamepanel */
/* Drawing procedure for panel pname. */

void drawnamepanel (PaneL p)
{
  RecT  r, r2;
  PoinT pt;
  int i, x, y;
  int width;
  printdata data;


  Select(p);
  LtGray(); InvertColors(); Black();
  GetPanelExtra(p, &data);
  ObjectRect (p, &r);
  FrameRect(&r);
  if(data.tot_lignes== -1) return;
  x=r.left+data.charwidth;
  y=r.top+(3*data.lineheight);
  InsetRect(&r,1,1);
  EraseRect(&r); 
  for(i=data.prem_ligne;i<data.prem_ligne+data.nbr_lignes-2 && i<data.tot_lignes;i++){
    width=mini((int)strlen(data.lignes[i]), data.nbr_cols);
    LoadRect(&r2, x, y-data.lineheight+2, x+width*data.charwidth, y+2);
    LoadPt(&pt, x, y+2);
    boldstring(pt, data.lignes[i], data.selected[i]);
    y+=data.lineheight;
  }
}


/* linepaint */ 
/* Paint lg characters of string ligne at point pt. */
 
void linepaint(char* ligne, PoinT pt, int lg){

  int i,j;

  if (!PROTB){
    for(j=0;j<lg;j++){
      for(i=0;i<nbstring;i++) topaint[i][j]=' ';
      switch(toupper(ligne[j])){
        case 'A' : topaint[0][j]=TRANSVONLY?'R':'A'; break; 
        case 'C' : topaint[1][j]=TRANSVONLY?'Y':'C'; break; 
        case 'G' : topaint[2][j]=TRANSVONLY?'R':'G'; break; 
        case 'T' : 
        case 'U' : topaint[3][j]=TRANSVONLY?'Y':'T'; break; 
        case 'R' : if(TRANSVONLY) topaint[0][j]='R'; break;
        case 'Y' : if(TRANSVONLY) topaint[1][j]='Y'; break;
        default : topaint[4][j]=ligne[j]; 
    }
    for(i=0;i<nbstring;i++) topaint[i][j+1]=0;
    }
    SetColor(cola);
    SetPen(pt); PaintString(topaint[0]);
    SetColor(colg);
    SetPen(pt); PaintString(topaint[2]);
    SetColor(colt);
    SetPen(pt); PaintString(topaint[3]);
    SetColor(colc);
    SetPen(pt); PaintString(topaint[1]);
    SetColor(coln);
    SetPen(pt); PaintString(topaint[4]);
    Black();
  }

  else {
    for(j=0;j<lg;j++){
      for(i=0;i<nbstring;i++) topaint[i][j]=' ';
      topaint[aaclass(ligne[j])][j]=ligne[j]; 
    }
    for(i=0;i<nbstring;i++) topaint[i][j+1]=0;
    SetColor(col1);
    SetPen(pt); PaintString(topaint[0]);
    SetColor(col2);
    SetPen(pt); PaintString(topaint[1]);
    SetColor(col3);
    SetPen(pt); PaintString(topaint[2]);
    SetColor(col4);
    SetPen(pt); PaintString(topaint[3]);
    SetColor(col5);
    SetPen(pt); PaintString(topaint[4]);
    SetColor(coln);
    SetPen(pt); PaintString(topaint[5]);
    Black();
  }
}




/* setblockbounds */

/* Set vertical and horizontal limits of selected nucleotide blocks at screen */

void setblockbounds(void){

  int i, vboundlim, hboundlim;
  int *selected;
  printdata data, data2;
  RecT r;

  ObjectRect(pseq, &r);

  GetPanelExtra(pseq, &data);
  GetPanelExtra(pname, &data2);

  hblock=vblock=0;


		/* horizontal bounds */

  selected=(int*)check_alloc(lgseq, sizeof(int));
  reg_and_pos(selected, data.selected); 

  if(selected[data.prem_col]) {hblock++; hbound[0]=r.left+data.charwidth;}
  hboundlim=mini(data.nbr_cols, lgseq);
  for(i=1;i<hboundlim;i++){
    if(selected[data.prem_col+i] && !selected[data.prem_col+i-1]){
      hbound[2*hblock]=r.left+(i+1)*data.charwidth;
      hblock++;
    }
    if(!selected[data.prem_col+i] && selected[data.prem_col+i-1]){
      hbound[2*hblock-1]=r.left+(i+1)*data.charwidth;
    }
  }
  if(selected[data.prem_col+hboundlim-1]) 
    hbound[2*hblock-1]=r.left+(hboundlim+1)*data.charwidth;

      
		/* vertical bounds */

  if(data2.selected[data.prem_ligne]) {vblock++; vbound[0]=r.top+2*data.lineheight+vrab;}
  vboundlim=mini(data2.nbr_lignes-2, nbseq);
  for(i=1;i<vboundlim;i++){
    if(data2.selected[data.prem_ligne+i] && !data2.selected[data.prem_ligne+i-1]){
      vbound[2*vblock]=r.top+(i+2)*data.lineheight+vrab;
      vblock++;
    }
    if(!data2.selected[data.prem_ligne+i] && data2.selected[data.prem_ligne+i-1]){
      vbound[2*vblock-1]=r.top+(i+2)*data.lineheight+vrab;
    }
  }
  if(data2.selected[data2.prem_ligne+vboundlim-1]) {
    vbound[2*vblock-1]=r.top+(vboundlim+2)*data.lineheight+vrab;
  }
  free(selected);
}  


/* drawseqpanel */
/* Drawing procedure for panel pseq. */
/* If drawseqpanel is called by horizontal scrolling function hscroll */
/* (fromscroll!=0), only invalid areas are redrawn, i.e. right or left column. */

void drawseqpanel (PaneL p)
{
  int i, j, x, y, lg, deb, deb0, deb0prov, nbchiffres=1;
  static int numappel=0;
  static char *prov;
  RecT  r, block;
  PoinT pt;
  printdata data, data2;

  Select(p);
  GetPanelExtra(p, &data);
  if (numappel++ ==0)
    prov=(char*)check_alloc(data.nbr_cols+1, sizeof(char));
  GetPanelExtra(pname, &data2);
  ObjectRect (p, &r);
  FrameRect(&r);
  if(data.tot_lignes== -1) return;

  setblockbounds();

  if(HIDDENSEQ){
    InsetRect(&r, 1, 1);
    EraseRect(&r);
    White(); InvertColors(); White();
    PaintRect(&r);
    Black();
    return;
  }

  if (fromscroll>0){
    r.left=r.right-data.charwidth-1;
    r.top++;
    r.bottom--;
    SetColor(fonduns_col);
    PaintRect(&r);
    Black();
    fromscroll=0;
    return;
  }

  if (fromscroll<0){
    r.right=r.left+data.charwidth+1;
    r.top++;
    r.bottom--;
    SetColor(fonduns_col);
    PaintRect(&r);
    Black();
    fromscroll=0;
    return;
  }
  SetColor(fonduns_col); InvertColors();   
  InsetRect(&r,1,1);
  EraseRect(&r);

  SetColor(fondsel_col); InvertColors();
  for(i=0;i<hblock;i++){
    for(j=0;j<vblock;j++){
      block.left=hbound[2*i]; block.right=hbound[2*i+1];
      block.top=vbound[2*j]; block.bottom=vbound[2*j+1];
      EraseRect(&block);
    }
  }
  

  Black(); 
  SelectFont(gras);
  x=r.left+data.charwidth;
  y=r.top+data.lineheight+2;
  LoadPt(&pt, x, y);
  SetPen(pt);
  (void) strncpy(prov, data.lignes[0]+data.prem_col, data.nbr_cols);
  i=1;
  while(prov[data.nbr_cols-i]!=' ' && data.lignes[1][data.prem_col+data.nbr_cols-i]==' ')
    prov[data.nbr_cols-(i++)]=' ';
  deb=data.prem_col;
  deb0prov=deb0=10*((int)(deb/10.)+1);
  while(deb0prov/10!=0){ deb0prov/=10; nbchiffres++;}
  if(deb0-deb<nbchiffres){
    i=0;
    while(prov[i]!=' ') prov[i++]=' ';
  }
  PaintString(prov);
  y+=data.lineheight;
  LoadPt(&pt, x, y);
  SetPen(pt);
  (void) strncpy(prov, data.lignes[1]+data.prem_col, data.nbr_cols);

  PaintString(prov);
  y+=data.lineheight;
  lg=mini(data.nbr_cols, lgseq-data.prem_col);

  for(i=data.prem_ligne+2;i<data.prem_ligne+data.nbr_lignes && i<data.tot_lignes;i++){
    LoadPt(&pt, x, y);
    linepaint(data.lignes[i]+data.prem_col, pt, lg);
    y+=data.lineheight;
  }

  fromscroll=0;
}




/* createpanel */
/* Return a panel whose extra values are given by the arguments. */

PaneL createpanel(GrouP group, int larg, int haut, FonT fonte,
     PnlActnProc drawfct, BarScrlProc vscrollfct,  BarScrlProc hscrollfct,
     PnlActnProc callback, int rabl)
{
PaneL p;
printdata data;

data.nbr_lignes=haut;
data.nbr_cols=larg;
data.font=fonte;
SelectFont(data.font);
data.prem_ligne=0;
data.tot_lignes=-1;
data.lineheight=LineHeight();
data.charwidth=MaxCharWidth();
#ifdef WIN_MAC
data.charwidth=CharWidth('A');
#endif
data.ascent=Ascent();
data.callback=callback;
data.prem_col=0;
data.tot_cols=-1;
data.nbsel=-1;


p=AutonomousPanel(group, (larg+2)*data.charwidth,
       (rabl+haut)*data.lineheight, drawfct,
       (SltScrlProc)vscrollfct, (SltScrlProc)hscrollfct, sizeof(printdata), NULL, NULL);
SetPanelExtra(p, &data);
return p;
}


/* initpanel */
/* Assign extra value lignes (= main text) and selected (lines) to panel p. */
/* For all panels excepted pseq. */

void initpanel(PaneL p, char** text, int nblignes, int nbsel, int* sel){

  printdata data;
  int i;

  GetPanelExtra(p, &data);
  if (nbsel<0){
    data.nbsel=nbseq;
    for(i=0;i<nblignes;i++) data.selected[i]=1;
  }
  else {
    data.nbsel=nbsel;
    for(i=0;i<nblignes;i++) data.selected[i]=0;
    for(i=0;i<nbsel;i++) data.selected[sel[i]]=1;
  }
  for(i=0;i<nblignes;i++) data.lignes[i]=text[i];
  SetPanelExtra(p, &data);
  return;
}



/* initseqpanel */
/* Assign extra values lignes (= main text) and selected (columns) to panel p. */
/* For panel pseq only. */

void initseqpanel(PaneL p, char** text, int nblignes, int nbcol, int nbsel, int* sel){

  printdata data;
  int i, j, deb, fin;

  GetPanelExtra(p, &data);
  data.selected=(int*)check_alloc(nbcol,sizeof(int));
  if (nbsel<0){
    data.nbsel=lgseq;
    for(i=0;i<nbcol;i++) data.selected[i]=1;
  }
  else{
    data.nbsel=sitesetlength(sel-1);
    for(i=0;i<nbcol;i++) data.selected[i]=0;
    for(i=0;i<nbsel;i++){
      deb=sel[2*i];
      fin=sel[2*i+1];
      for(j=deb;j<=fin;j++) data.selected[j]=1;
    }
  }
  data.lignes=(char**)check_alloc(nblignes, sizeof(char*));
  for(i=0;i<nblignes;i++) data.lignes[i]=text[i];
  SetPanelExtra(p, &data);
  return;
}


/* quitwin */

void quitwin (ButtoN but){
  (void) Remove(ParentWindow(but));
}


/* quitsavetwin */

void quitsavetwin (ButtoN but){
  Enable(createbut[curtreew]);
  Enable(savetree[curtreew]);
  Enable(prfile[curtreew]);
  (void) Remove(ParentWindow(but)); 
}


/* quiterr */

void quiterr (ButtoN but){
  if (Visible(loadw)) Enable(load_ok); 
  if (NOMAINWIN && !Visible(firstw)) firstwindow(); 
  (void) Remove(messw); messw=NULL;
}



/* canceldt */

void canceldt (ButtoN but){
  DONOTSHOWTREE=TRUE;
  if(Visible(messw)) { (void) Remove(messw); messw=NULL; }
}

/* nextversionname */
/* use these odd names to avoid infile,outfile,numsave, which are GLOBAL*/
void nextversionname(char *next_out, char *in_for_next, int num_for_next){
char * semicolon;
#ifdef __VMS
    semicolon = strchr(in_for_next,';');
    if(semicolon != NULL)*semicolon = '\0';
    (void) strcpy(next_out, in_for_next);
#else
    (void) sprintf(next_out, "%s~%d~", in_for_next, num_for_next);
    num_for_next++;
#endif
}

/* loadproc */

void loadproc(ButtoN but){
  Boolean ok;
  char infile_old[100];

  (void) sprintf(infile_old, "%s", infile);
  ok=GetInputFileName(infile, 100, "", NULL);
  if(!ok) return; 
  WatchCursor();
  if (CHANGESDONE && GetStatus(auti)){
    nextversionname(outfile, infile_old, numsave);
    writeout(NULL);
  }
  loadpanels();
  ArrowCursor();

}


/* loadpanels */
/* Read input file, initialize data and draw panels. */

void loadpanels(void)
{
  int i, j, l, lg, k=0, nbl, nb;
  double d, acgt=0., alpha=0.;
  char  *silines[MAXNSP+2], *splines[MAXNSP+2], *seqlines[MAXNSP+2];
  char *namelines[MAXNSP], *pbuildlines[MAXTREE], *sitesetnameprov[MAXSITESET];
  char *specsetnameprov[MAXSPSET], *texte, *c, *err_mess;
  printdata data;
  Boolean SPECWARNED=FALSE, SITEWARNED=FALSE;
  FILE *input;


  texte=(char*)check_alloc(1000, sizeof(char));

  nbspecsets=nbsitesets=0;
  
  if ((input=fopen(infile,"r"))==NULL){     
    (void) sprintf(texte, "Bad input file : %s", (c=strrchr(infile,'/'))?c:infile); 
    createmessbox(texte, FALSE, quiterr, NULL); 
    return; 
  }

  err_mess=(char*)check_alloc(200, sizeof(char));

  nbseq=fileread(input, seq, cname, comments, &nbsitesets, siteset,
     sitesetnameprov, &nbspecsets, specset, specsetnameprov, &nbtree,
     memtreename, memtree, &format, err_mess);

  (void) fclose(input);

  numsave=1;

/* strange logic in the Unix version, it opens a zillion consecutive
   files until one fails.  Unfortunately, it never CLOSES any of them,
   so when that code runs on OpenVMS (and probably some Unixes) it fails
   when too many files are open.  The OpenVMS version knows that the most
   recent version is name.whatever, so it just uses that name - no 
   searching*/
#ifdef __VMS
    nextversionname(texte, infile, numsave);
#else
  while(TRUE){
    nextversionname(texte, infile, numsave);
    if(!fopen(texte, "r")) break;
  }
#endif
  

  if (nbseq<=0) {
    (void) sprintf(texte, "Bad input file : %s %s", (c=strrchr(infile,'/'))?c+1:infile, err_mess); 
    createmessbox(texte, FALSE, quiterr, NULL); 
    return; 
  }
  if (nbseq>=maxlines) nbl=maxlines+2; else nbl=nbseq+2;
  if (nbl<minlines) nbl=minlines;

  for(i=0;i<nbseq+2;i++){
    if(s[i]) free(s[i]);
    s[i]=(double*)check_alloc(nbseq+2, sizeof(double));
  }
  if(av) free(av); av=(double*)check_alloc(nbseq+2, sizeof(double));
  if(kkill) free(kkill); kkill=(int*)check_alloc(nbseq+2, sizeof(int));
  if(vbound) free(vbound); vbound=(int*)check_alloc(nbseq+1, sizeof(int));


  lgseq=(int)strlen(seq[0]);

  if(hbound) free(hbound); hbound=(int*)check_alloc(lgseq+1, sizeof(int));

  for(i=1;i<nbseq;i++) {lg=(int)strlen(seq[i]); if (lg>lgseq) lgseq=lg; }
  for(i=0;i<nbseq;i++)
    if ((lg=(int)strlen(seq[i]))<lgseq)
      for(j=lg;j<lgseq;j++) seq[i][j]='-';
  PROTB=FALSE;
  for(i=0;i<nbseq;i++){
    for(j=0;j<lgseq;j++){
      if (isalpha(seq[i][j])){
	alpha++;
	if (seq[i][j]=='A' || seq[i][j]=='C' || seq[i][j]=='G' ||
            seq[i][j]=='T' || seq[i][j]=='U') acgt++;
      }
    }
  }
  if (acgt/alpha<0.7) PROTB=TRUE;

  code_mt=0; nameclickrk=0; seqclickrk=0; fromscroll=0;
  option=0; method=0; curtreew=0; 
  NOMAINWIN=TRUE; NUCSEQLOADED=FALSE; CHANGESDONE=FALSE;
  COMBB=FALSE;
  GAPWARNED=STOPWARNED=FALSE;
  HIDDENSEQ=FALSE;
  Gafter=1; Gduring=1; numhelp=0;


  putobjects(nbl);

  if(!PROTB){
    SetStatus(po1i, TRUE);
    SetStatus(po2i, TRUE);
    SetStatus(po3i, TRUE);
  }

  JUMBBOOT=TRUE;
  COMBALLOWED=FALSE;
  CONSENSE=FALSE;

  nextgroup=nbspecsets+1;
  nextset=nbsitesets+1;
 
  if (PROTB) nbstring=12; else nbstring=10;
  for(j=0;j<nbstring;j++){
    if(topaint[j]) free(topaint[j]);
    topaint[j]=(char*)check_alloc(lgseq+1, sizeof(char));
  }


  if (nbspecsets!=0) Enable(sp_del);
  Enable(sp_sel);
  Enable(sp_unsel);

  for(i=0;i<nbspecsets;i++){
    for(j=1;j<=specset[i][0];j++){
      if(specset[i][j]>nbseq){
	if(!SPECWARNED){
	  createmessbox("Warning : irrelevant species groups ", FALSE, quiterr, NULL);
	  while(messw) ProcessAnEvent();
	}
	free(specset[i]);
	for(k=i;k<nbspecsets-1;k++) specset[k]=specset[k+1];
	nbspecsets--;
	i--;
	SPECWARNED=FALSE;
	break;
      }
    }
  }


  for(i=0;i<nbspecsets;i++){
    if(specsetname[i]) free(specsetname[i]); 
    specsetname[i]=(char*)check_alloc(100, sizeof(char));
    (void) sprintf(specsetname[i],"%s(%d)",specsetnameprov[i], specset[i][0]);
    splines[i]=(char*)check_alloc(100, sizeof(char));
    (void) sprintf(splines[i],"%.16s(%d)",specsetnameprov[i], specset[i][0]);
  }

  GetPanelExtra(pspecies, &data);
  data.selected=(int*)check_alloc(MAXSPSET, sizeof(int));
  data.lignes=(char**)check_alloc(MAXSPSET, sizeof(char*));
  SetPanelExtra(pspecies, &data);
  initpanel(pspecies, splines, nbspecsets, 1, &k);
  settotlignes(pspecies, nbspecsets);


  if (nbsitesets!=0) Enable(si_del);
  Enable(si_sel);
  Enable(si_unsel);

  for(i=0;i<nbsitesets;i++){
    for(j=1;j<=2*siteset[i][0];j++){
      if(siteset[i][j]>lgseq){
	if(!SITEWARNED){
	  createmessbox("Warning : irrelevant site sets ", FALSE, quiterr, NULL);
	  while(messw) ProcessAnEvent();
	}
	free(siteset[i]);
	for(k=i;k<nbsitesets-1;k++) siteset[k]=siteset[k+1];
	nbsitesets--;
	i--;
	SITEWARNED=TRUE;
	break;
      }
    }
  }

  for(i=0;i<nbsitesets;i++){
    if(sitesetname[i]) free(sitesetname[i]); 
    sitesetname[i]=(char*)check_alloc(100, sizeof(char));
    j=sitesetlength(siteset[i]);
    (void) sprintf(sitesetname[i],"%s(%d)", sitesetnameprov[i], j);
    silines[i]=(char*)check_alloc(100, sizeof(char));
    (void) sprintf(silines[i],"%.16s(%d)", sitesetnameprov[i], j);
  }
  GetPanelExtra(psites, &data);
  data.selected=(int*)check_alloc(MAXSITESET, sizeof(int));
  data.lignes=(char**)check_alloc(MAXSITESET, sizeof(char*));
  SetPanelExtra(psites, &data);
  initpanel(psites, silines, nbsitesets, 1, &k);
  settotlignes(psites, nbsitesets);


  for(i=0;i<MAXTREE;i++){
    pbuildlines[i]=(char*)check_alloc(30,sizeof(char));
  }
  for(i=0;i<nbtree;i++){
    c=strchr(memtreename[i], '(');
    if(c) *c=0;
    nb=tree_ctot(memtree[i], NULL, NULL, NULL, NULL, NULL, NULL);
    l=(int)strlen(memtreename[i]);
    (void) sprintf(memtreename[i]+l, "(%d)", nb);
    (void) sprintf(pbuildlines[i], "%.25s", memtreename[i]);
  }
  GetPanelExtra(pbuild, &data);
  data.selected=(int*)check_alloc(MAXTREE, sizeof(int));
  data.lignes=(char**)check_alloc(MAXTREE, sizeof(char*));
  SetPanelExtra(pbuild, &data);
  initpanel(pbuild, pbuildlines, nbtree, 0, NULL);
  settotlignes(pbuild, nbtree);


  for(i=0;i<nbseq;i++){
    namelines[i]=(char*)check_alloc(17, sizeof(char));
  }
  if (!PROTB){
    if(gc) {free(gc); free(oldgc);}
    gc=(double*)check_alloc(nbseq, sizeof(double));
    oldgc=(double*)check_alloc(nbseq, sizeof(double));
    for(i=0;i<nbseq;i++){
      (void) strncat(namelines[i], cname[i], 10);
      l=(int)strlen(namelines[i]);
      for(j=l;j<16;j++) namelines[i][j]=' ';
    }
  }
  else 
    for(i=0;i<nbseq;i++) (void) strncat(namelines[i],cname[i], 16);
  GetPanelExtra(pname, &data);
  data.selected=(int*)check_alloc(nbseq, sizeof(int));
  data.lignes=(char**)check_alloc(nbseq+2, sizeof(char*));
  SetPanelExtra(pname, &data);
  if (nbspecsets!=0) initpanel(pname, namelines, nbseq, specset[0][0], specset[0]+1);
  else initpanel(pname, namelines, nbseq, -1, NULL);
  settotlignes_head2(pname, nbseq);

  seqlines[0]=(char*)check_alloc(lgseq+1, sizeof(char));
  seqlines[1]=(char*)check_alloc(lgseq+1, sizeof(char));
  for(i=0;i<lgseq;i++){
    if((i+1)%10==0){
      d=(double)(i+1); l=0;
      while((int)d!=0){
	d/=10.;
	l++;
       }
      (void) sprintf(seqlines[0]+i-l+1,"%d",i+1);
    }
    else seqlines[0][i]=' ';
  }
  for(i=0;i<lgseq;i++)
    if ((i+1)%10==0) seqlines[1][i]='|'; else seqlines[1][i]=' ';
  for(i=2;i<nbseq+2;i++) seqlines[i]=seq[i-2];

  if (nbsitesets!=0)initseqpanel(pseq, seqlines, nbseq+2, lgseq, siteset[0][0], siteset[0]+1);
  else initseqpanel(pseq, seqlines, nbseq+2, lgseq, -1, NULL);
  settotcols(pseq, lgseq);
  GetPanelExtra(pseq, &data);
  data.tot_lignes=nbseq+2;
  SetPanelExtra(pseq, &data);
  Select(pseq);


  setnbsel(pname, nbseq, -1);
  setnbsel(pseq, lgseq, -1);
  if (!PROTB) setgc();
  draw(pseq);
  Enable(choosemeth);
  if (PROTB) Disable(bml);
  free(texte);
  return;
}


/* createmessbox */
/* Create message window, including a prompt with string texte, */
/* an empty dialogtext if dialog==TRUE, an OK button with callback okfct */
/* and a CANCEL button with callback canfct if canfct!=NULL. */

void createmessbox(char* texte, Boolean dialog, BtnActnProc okfct, BtnActnProc canfct){
  
  FonT localfont;
  GrouP messgr;

  localfont=titlefont;
  SelectFont(localfont);
  messw=FixedWindow(-50, -33, -10, -10, "", quitwin_w);
  (void) StaticPrompt(messw, texte, 0, 20, localfont, 'l');
  Break(messw);
  localfont=petit;
  SelectFont(localfont);
  if (dialog) {
    shift(messw, 40, 0);
    messtext=DialogText(messw, "", 15, NULL);
  }
  messgr=HiddenGroup(messw, 2, 0, NULL);
  shift(messgr, 40, 30);
  mess_ok=PushButton(messgr, YES_NO?" YES ":"  OK  ", okfct);
  if (canfct){
    shift(messgr, 40, 0);
    mess_can=PushButton(messgr, YES_NO?"  NO  ":"CANCEL", canfct);
  }
  Show(messw);
  YES_NO=FALSE;
}


void quitml(ButtoN but){

  DONOTSHOWTREE=FALSE;
  openedtreew[curtreew]=0;
  (void) Remove(messw);
}


void mlshowtree(ButtoN but){

  Show(treew[curtreew]);
  (void) Remove(messw);
  DONOTSHOWTREE=FALSE;
}



void createmlmessbox(char* texte, int showtreebut){
  
  FonT localfont;
  GrouP messgr;

  localfont=titlefont;
  SelectFont(localfont);
  messw=FixedWindow(-50, -33, -10, -10, "", quitwin_w);
  (void) StaticPrompt(messw, texte, 0, 20, localfont, 'l');
  Break(messw);
  localfont=petit;
  SelectFont(localfont);
  messgr=HiddenGroup(messw, 2, 0, NULL);
  shift(messgr, 40, 30);
  mess_ok=PushButton(messgr, "  QUIT  ", quitml);
  if (showtreebut){
    shift(messgr, 40, 0);
    mess_can=PushButton(messgr, "SHOW TREE", mlshowtree);
  }
  Show(messw);
#ifdef MOTIF
  ajout_icone_tree();
#endif
}



/* writeout */
/* Write data into outfile. */

void writeout(ButtoN but){
int i;
char** sitesetname_out, **specsetname_out, **memtreename_out, *parenth;
FILE* output;

output=fopen(outfile,"w");
if (output==NULL)
  (void) printf("Sorry : cannot write file:%s\n", outfile);
else{
  WatchCursor();
  sitesetname_out=(char**)check_alloc(nbsitesets, sizeof(char*));
  for(i=0;i<nbsitesets;i++) {
    sitesetname_out[i]=(char*)check_alloc((int)strlen(sitesetname[i])+1, sizeof(char));
    (void) sprintf(sitesetname_out[i], "%s", sitesetname[i]);
    parenth=strchr(sitesetname_out[i],'(');
    if (parenth) *parenth='\0';
  }
  specsetname_out=(char**)check_alloc(nbspecsets, sizeof(char*));
  for(i=0;i<nbspecsets;i++){
    specsetname_out[i]=(char*)check_alloc((int)strlen(specsetname[i])+1, sizeof(char));
    (void) sprintf(specsetname_out[i], "%s", specsetname[i]);
    parenth=strchr(specsetname_out[i],'(');
    if (parenth) *parenth='\0';
  }
  memtreename_out=(char**)check_alloc(nbtree, sizeof(char*));
  for(i=0;i<nbtree;i++){
    memtreename_out[i]=(char*)check_alloc((int)strlen(memtreename[i])+1, sizeof(char));
    (void) sprintf(memtreename_out[i], "%s", memtreename[i]);
    parenth=strchr(memtreename_out[i],'(');
    if (parenth) *parenth='\0';
  }

  (void) maseprint(output, seq, cname, comments, nbseq, nbsitesets, siteset,
    sitesetname_out, nbspecsets, specset, specsetname_out, nbtree, memtreename_out, memtree);
  (void) fclose(output);
  format='M';
  for(i=0;i<nbsitesets;i++) free(sitesetname_out[i]);
  for(i=0;i<nbspecsets;i++) free(specsetname_out[i]);
  for(i=0;i<nbtree;i++) free(memtreename_out[i]);
  free(sitesetname_out); free(specsetname_out); free(memtreename_out);
  CHANGESDONE=FALSE;
}
if (Visible(messw)) { (void) Remove(messw); messw=NULL; }
if (Visible(savew)) { (void) Remove(savew); savew=NULL; }
ArrowCursor();
}


/* saveok_act */
/* Callback procedure for button OK in save window. */
/* Read output file name and create a message box to check for overwriting. */

void saveok_act(ButtoN but){
char *texte;
FILE* local;
  texte=(char*)check_alloc(120, sizeof(char));
  GetTitle(savetext, outfile, 100);
  (void) sprintf(texte, "Overwrite %s ?", outfile);
  if ((local=fopen(outfile, "r"))!=NULL) {
    (void) fclose(local); 
    if(Visible(messw)) {(void) Remove(messw); messw=NULL;}
    createmessbox(texte, FALSE,  writeout, quitwin);
  }
  else {(void) fclose(local);  writeout(NULL);}
  free(texte);
}
 
  

/* savaproc */
/* Create save window. */

void savaproc(ButtoN but){
  savew=FixedWindow(-50, -33, -10, -10, "SAVE", quitwin_w);
  shift(savew, 0, 20);
  (void) StaticPrompt(savew, "OUTPUT FILE  :", 0, 14, gros, 'l');
  Advance(savew);
  shift(savew, 0, -10);
  stdLineHeight=18;
  savetext=DialogText(savew, "", 35, NULL);
  stdLineHeight=15;
  Break(savew);
  savegr=HiddenGroup(savew, 2, 0, NULL);
  shift(savegr, 140, 20);
  save_ok=PushButton(savegr, "  OK  ", saveok_act);
  shift(savegr, 20, 0);
  save_can=PushButton(savegr, "CANCEL", quitwin);

  SetTitle(savetext, infile); 
  Show(savew);
}



/* saveproc */
/* Overwrite infile. */

void saveproc(ButtoN but){
  char *texte;
  texte=(char*)check_alloc(150, sizeof(char));
  (void) sprintf(outfile, "%s", infile);
  if(format!='M'){
    switch(format){
      case 'C': (void) sprintf(texte, "Replace CLUSTAL file %s by a MASE+ file?", infile); break;
      case 'F': (void) sprintf(texte, "Replace FASTA file %s by a MASE+ file?", infile); break;
      case 'P': (void) sprintf(texte, "Replace PHYLIP file %s by a MASE+ file?", infile); break;
      case 'N': (void) sprintf(texte, "Replace NEXUS file %s by a MASE+ file?", infile); break;
    }
    createmessbox(texte, FALSE, writeout, quitwin);
    return;
  }
  writeout(NULL);
  free(texte);
}



/* quitmain */

void quitmain(ButtoN but)
{
  if (CHANGESDONE){
    if(GetStatus(auti)){
      nextversionname(outfile, infile, numsave);
      writeout(NULL);
    }
    else{
      YES_NO=TRUE;
      createmessbox("Save changes before leaving ?", FALSE, savaproc, quitwin);
      while(Visible(messw)){
        ProcessAnEvent();
      }
    }
  }
  
  exit(0);
}



/* quitmain_w */

void quitmain_w (WindoW win)
{
  if (CHANGESDONE && GetStatus(auti)){
    nextversionname(outfile, infile, numsave);
    writeout(NULL);
  }
  exit(0);
}


 
  
/* removeseq */
/* Remove all selected species from data and screen. */

void removeseq(ButtoN but){

int i, j, k, l, nbseqold, oldsetsize;
printdata data, dataseq, datasp, databd;
char* endbracket;

  GetPanelExtra(pname, &data);
  GetPanelExtra(pseq, &dataseq);
  GetPanelExtra(pspecies, &datasp);
  GetPanelExtra(pbuild, &databd);
  nbseqold=nbseq;
  for(i=0;i<nbseqold;i++){
    if(data.selected[i]){
      for(j=0;j<nbtree;j++){
	endbracket=strchr(memtree[j], ']');
	if(endbracket==NULL) endbracket=memtree[j];
	if(strstr(endbracket, cname[i])){
	  free(memtree[j]); free(memtreename[j]); free(databd.lignes[j]);
	  for(k=j;k<nbtree-1;k++){
	    memtree[k]=memtree[k+1];
	    memtreename[k]=memtreename[k+1];	
	    databd.lignes[k]=databd.lignes[k+1];
	  }
  	  nbtree--;
	  j--;
	}
      }
    }
  }
  SetPanelExtra(pbuild, &databd);
  for(i=0;i<nbseqold;i++){  
    if(data.selected[i]==1){  
      nbseq--;
      data.tot_lignes--;
      dataseq.tot_lignes--;
      for(j=i;j<nbseq;j++){
        dataseq.lignes[j+2]=dataseq.lignes[j+3];
        data.lignes[j]=data.lignes[j+1];
        seq[j]=seq[j+1];
        comments[j]=comments[j+1];
        cname[j]=cname[j+1];
        if (!PROTB) gc[j]=gc[j+1];
        data.selected[j]=data.selected[j+1];
      }
      for(j=0;j<nbspecsets;j++){
        oldsetsize=specset[j][0];
	for(k=1;k<=oldsetsize;k++){
	  if(specset[j][k]==i){
	    specset[j][0]--;
	    for(l=k;l<=specset[j][0];l++)
	      specset[j][l]=specset[j][l+1];
            specset[j][specset[j][0]+1]=-1;
	  }
	}
	for(k=1;k<=oldsetsize;k++) 
          if(specset[j][k]>i)
	    specset[j][k]--;
      }
      data.selected[nbseq]=0;
      i--;
    }
  }

  SetPanelExtra(pname, &data);
  SetPanelExtra(pseq, &dataseq);
  for(i=0;i<nbspecsets;i++){
    (void) sprintf(strchr(specsetname[i],'(')+1,"%d)",specset[i][0]);
    datasp.lignes[i]=specsetname[i];
  }
  SetPanelExtra(pspecies, &datasp);
  draw(pspecies);
  draw(pname);
  draw(pseq);
  settotlignes(pbuild, nbtree);
  draw(pbuild);
  setnbsel(pname, nbseq, -1);
  CHANGESDONE=TRUE;
  (void) Remove(messw); messw=NULL;
}
  


/* remove_act */
/* Callback procedure for item remove. */

void remove_act(IteM it){
char *texte, *endbracket;
printdata data, dataname;
int i=-1, j, k, cpttree=0, *alive;


  alive=(int*)check_alloc(nbtree, sizeof(int));
  for(j=0;j<nbtree;j++) alive[j]=1;
  texte=(char*)check_alloc(100, sizeof(char));
  GetPanelExtra(pname, &data);
  for(k=0;k<nbseq;k++){
    if(data.selected[k]){
      for(j=0;j<nbtree && alive[j];j++){
        endbracket=strchr(memtree[j], ']');
        if(endbracket==NULL) endbracket=memtree[j];
        if(strstr(endbracket, cname[k])){
  	  cpttree++;
	  alive[j]=0;
        }
      }
    }
  }
  if (data.nbsel==1){
    while(!data.selected[++i]);
    if(cpttree)
      (void) sprintf(texte,"Really delete sequence %s and %d trees ?", cname[i], cpttree);
    else
      (void) sprintf(texte,"Really delete sequence %s ?", cname[i]);
  }
  else{
    if(cpttree)
      (void) sprintf(texte, "Really delete %d sequences and %d trees ?", data.nbsel, cpttree);
    else
      (void) sprintf(texte, "Really delete %d sequences ?", data.nbsel);
  }
  createmessbox(texte, FALSE, (BtnActnProc)removeseq, quitwin);
  free(texte); free(alive);
}



/* renquit */

void renquit(ButtoN but){
  (void) Remove(messw); messw=NULL;
  (void) Remove(renw); renw=NULL;
}


/* renok_act */
/* Callback function for button ok in rename window renw. */
/* Read new species names in ScrollText rentext, set data and redraw pname. */

void renok_act(ButtoN but){
  char* prov, *prov2, *inputname, *inputtext, *inputtextcpy, **cnameprov;
  static char mess[30], err_mess[200];
  printdata data;
  int i=-1, j, l;

  GetPanelExtra(pname, &data);
  inputtext=(char*)check_alloc(30*nbseq, sizeof(char));
  inputtextcpy=(char*)check_alloc(30*nbseq, sizeof(char));
  GetTitle(rentext, inputtext, 30*nbseq);
  (void) sprintf(inputtextcpy, "%s", inputtext);
  prov=prov2=inputtextcpy;
  while(prov2!=NULL){
    prov2=strtok(prov, "\n");
    i++;
    if (prov) prov=NULL;
  }
  if (i!=nbseq) {
    (void) sprintf(mess, "There are missing names");
    createmessbox(mess, FALSE, renquit, NULL);
    return;
  }
  cnameprov=(char**)check_alloc(nbseq, sizeof(char*));
  for(i=0;i<nbseq;i++) cnameprov[i]=check_alloc(20, sizeof(char));

  prov=inputtext;
  for(i=0;i<nbseq;i++){
    inputname=strtok(prov,"\n");
    if ((int)strlen(inputname)>=20) inputname[20]='\0';
    (void) sprintf(cnameprov[i],"%s",inputname);
    if (prov) prov=NULL;
  }

  if(checknames(nbseq, cnameprov, err_mess)==FALSE){
    *strrchr(err_mess, ')')='\0';
    createmessbox(err_mess+1, FALSE, renquit, NULL);
    return;
  }

  for(i=0;i<nbseq;i++){
    if(!samename(cname[i], cnameprov[i]))
      for(j=0;j<nbtree;j++) (void) ctree_changename(memtree[j], cname[i], cnameprov[i]);
  }

  for(i=0;i<nbseq;i++){
    (void) sprintf(cname[i], "%s", cnameprov[i]);
    (void) sprintf(data.lignes[i],"%s",cnameprov[i]);
  } 
  
  if (!PROTB) {
    for(i=0;i<nbseq;i++){
      l=(int)strlen(data.lignes[i]);
      if (l<10) for(j=l;j<10;j++) data.lignes[i][j]=' ';
      (void) sprintf(data.lignes[i]+10,"  %.1f",gc[i]);
    }
  }

  for(i=0;i<nbseq;i++) free(cnameprov[i]);
  free(cnameprov);

  SetPanelExtra(pname, &data);
  (void) Remove(renw); renw=NULL;
  draw(pname); 
  CHANGESDONE=TRUE;
  free(inputtext);
  free(inputtextcpy);
}


/* rename_act */
/* Callback procedure for item rename */

void rename_act(IteM it){

  static char* namelist, *cursor;
  int i;
  static int firstcall=1;

  if(!firstcall) free(namelist);
  namelist=(char*)check_alloc(25*nbseq, sizeof(char));
  cursor=namelist;
  namelist[0]=0;
  for(i=0;i<nbseq;i++){
    while(*cursor) cursor++;
    (void) sprintf(cursor,"%s\n", cname[i]);
  }
  renw=FixedWindow(-50, -33, -10, -10, "RENAME", quitwin_w);
  (void) StaticPrompt(renw, "Edit names : ", 0, 20, titlefont, 'l');
  rentext=ScrollText(renw, 30, (nbseq>20)?22:nbseq+2, gras, TRUE, NULL);
  SetTitle(rentext,namelist);
  rengr=HiddenGroup(renw, 2, 0, NULL);
  shift(rengr, 40, 20);
  ren_ok=PushButton(rengr, "  OK  ", renok_act);
  shift(rengr, 40, 0);
  ren_can=PushButton(rengr,"CANCEL", quitwin);
  Show(renw);  
  if(firstcall) firstcall=0;
 }



/* moveok_act */

void moveok_act(ButtoN but){

  SetPanelClick(pname, pnameclick, NULL, NULL, pnamerelease);
  
  CHANGESDONE=TRUE;
  (void) Remove(messw); messw=NULL;
}



/* movecan_act */
/* Callback procedure for button cancel in move message window. */
/* Set back data to old values, cancelling previous moves. */

void movecan_act(ButtoN but){

printdata dataname, dataseq;
int i,j;

  GetPanelExtra(pname, &dataname);
  GetPanelExtra(pseq, &dataseq);
  for(i=0;i<nbseq;i++){
    dataseq.lignes[i+2]=seq[i]=oldseq[i];
    dataname.lignes[i]=oldnameligne[i];
    cname[i]=oldname[i];
    comments[i]=oldcomments[i];
    dataname.selected[i]=oldsel[i];
    if (!PROTB) gc[i]=oldgc[i];
  }
  for(i=0;i<nbspecsets;i++){
    for(j=1;j<=specset[i][0];j++)
      specset[i][j]=oldspecset[i][j];
    free(oldspecset[i]);
  }
  for(i=0;i<nbspecsets;i++) 
  SetPanelExtra(pname, &dataname);
  SetPanelExtra(pseq, &dataseq);
  SetPanelClick(pname, pnameclick, NULL, NULL, pnamerelease);
  (void) Remove(messw); messw=NULL;
  draw(pname);
  draw(pseq);
} 


/* move_act */
/* Callback procedure for item move. */

void move_act(IteM it){
  static char texte[50];
  int i, j;
  printdata dataname;

  GetPanelExtra(pname, &dataname);
  for(i=0;i<nbseq;i++){
    oldseq[i]=seq[i];
    oldname[i]=cname[i];
    oldcomments[i]=comments[i];
    oldnameligne[i]=dataname.lignes[i];
    oldsel[i]=dataname.selected[i];
    if (!PROTB) oldgc[i]=gc[i];
  }
  for(i=0;i<nbspecsets;i++){
    if(oldspecset[i]) free(oldspecset[i]);
    oldspecset[i]=(int*)check_alloc(specset[i][0]+1, sizeof(int));
    for(j=0;j<=specset[i][0];j++)
      oldspecset[i][j]=specset[i][j];
  }
  
  (void) sprintf(texte,"Click and drag names of sequences to be moved");
  createmessbox(texte, FALSE, moveok_act, movecan_act);
  Disable(mess_ok);
  SetPanelClick(pname, pnameclick, NULL, NULL, pnamemove);
}




/* ncode_act */

void ncode_act(IteM it){

  SetStatus(miti, FALSE);
  code_mt=0;; 
  if (NUCSEQLOADED) prefastlwl(rl, tl0, tl1, tl2, tti0, tti1, tti2, ttv0, ttv1, ttv2);
}




/* mcode_act */

void mcode_act(IteM it){

  SetStatus(nucli, FALSE);
  code_mt=1;
  if (NUCSEQLOADED) prefastlwl(rl, tl0, tl1, tl2, tti0, tti1, tti2, ttv0, ttv1, ttv2);
}



/* pos_act */

void pos_act(IteM it){
  
  if(!PROTB && !(GetStatus(po1i) && GetStatus(po2i) && GetStatus(po3i))){
    if(GetValue(dist)==8 || GetValue(dist)==9) Disable(bdt);
    Disable(b[7]);
    Disable(b[8]);
  }
  else{
    Enable(b[7]);
    Enable(b[8]);
  }
  setnbsel(pseq, lgseq, -1);
  setgc();
  draw(pseq);

}




/* quitbopw */

void quitbopw(ButtoN but){
  
  static char text[10];

  GetTitle(defnbrep_text, text, 10);
  (void) sscanf(text, "%d", &defnbrep);
  COMBALLOWED=GetStatus(abcb);
  JUMBBOOT=GetStatus(jbob);
  CONSENSE=GetStatus(conb);
  if(CONSENSE) maxtrees=9;
  
  (void) Remove(bopw); bopw=NULL;
}



/* writeoutinfo */
/* Write information into file infofile. */

void writeoutinfo(ButtoN but){
  FILE* fdist;
 
  if((fdist=fopen(infofile, "w"))==NULL){
    (void) printf("Sorry : cannot write file %d\n", distfile);
    return;
  }
  (void) fprintf(fdist, "%s", infotext);
  (void) fclose(fdist);
  if (Visible(messw)) { (void) Remove(messw); messw=NULL; }
  if (Visible(savew)) { (void) Remove(savew); savew=NULL; }
}



/* saveinfook_act */
/* Callback procedure for OK button in saveinfo window. */
/* Read output file name and create a message box to check for overwriting. */

void saveinfook_act(ButtoN but){
char *texte, *prov;
FILE* local;
  texte=(char*)check_alloc(500, sizeof(char));
  prov=(char*)check_alloc(100, sizeof(char));
  GetTitle(savetext, prov, 100);
#ifdef UNIX
  (void) sprintf(infofile, "%s/%s", currentdir, prov);
#else
  (void) sprintf(infofile, "%s", prov);
#endif
  (void) sprintf(texte, "Overwrite %s ?", infofile);
  if ((local=fopen(infofile, "r"))!=NULL) {
    (void) fclose(local); 
    createmessbox(texte, FALSE,  writeoutinfo, quitwin);
  }
  else {(void) fclose(local);  writeoutinfo(NULL);}
  free(texte); free(prov);
}



/* createinfosavebox */
/* Create saveinfo window. */

void createinfosavebox(ButtoN but){
  savew=FixedWindow(-50, -33, -10, -10, "SAVE", quitwin_w);
  shift(savew, 0, 20);
  (void) StaticPrompt(savew, "INFORMATION FILE  :", 0, 14, ParseFont("times,14"), 'l');
  Advance(savew);
  shift(savew, 0, -10);
  stdLineHeight=18;
  savetext=DialogText(savew, "", 35, NULL);
  stdLineHeight=15;
  Break(savew);
  savegr=HiddenGroup(savew, 2, 0, NULL);
  shift(savegr, 140, 20);
  save_ok=PushButton(savegr, "  OK  ", saveinfook_act);
  shift(savegr, 20, 0);
  save_can=PushButton(savegr, "CANCEL", quitwin);

  Show(savew);
}




/* geni_act */

void geni_act(IteM it){
  int i, j, k, l, ii, nb, lgtot, lg, lgvar, lginfo, *lgcomp, totlgcomp;
  int selgroup=-1, selset=-1, nc=0;
  int *selected, nbaa, nbcp;
  double **comp, *compall, compcomp[4], **compgroup, *compgroupall, min[4], max[4];
  double P, Psum=0., Q, Qsum=0., Pmin, Pmax, Qmin, Qmax;
  double titvratio, titvmin, titvmax, freq[16], mat_obs[16], *ti, *tv;
  char **genseq, **genname, *text, *minname[4], *maxname[4], nt[4]={'A', 'C', 'G', 'T'};
  char *titvminname1, *titvminname2, *titvmaxname1, *titvmaxname2;
  char groupname[50], setname[50], *c1, *c2;
  printdata dataseq, dataname, datasp, datasi;

  text=(char*)check_alloc(1000, sizeof(char));
  GetPanelExtra(pseq, &dataseq);
  GetPanelExtra(pname, &dataname);
  GetPanelExtra(pspecies, &datasp);
  GetPanelExtra(psites, &datasi);
  for(i=0;i<datasp.tot_lignes;i++) if(datasp.selected[i]){ selgroup=i; break; }
  for(i=0;i<datasi.tot_lignes;i++) if(datasi.selected[i]){ selset=i; break; }

  nb=lgtot=0;
  selected=(int*)check_alloc(lgseq, sizeof(int));
  reg_and_pos(selected, dataseq.selected);
  nbaa=(int)strlen(aalist);

/* SET UP DATA */

  for(i=0;i<lgseq;i++) if (selected[i]) lgtot++;
  if(lgtot==0){
    createmessbox("No selected sites", FALSE, quiterr, NULL);
    free(selected); free(text);
    return;
  }
  for(i=0;i<nbseq;i++) if (dataname.selected[i]) nb++;
  genseq=(char**)check_alloc(nb, sizeof(char*));
  genname=(char**)check_alloc(nb, sizeof(char*));
  for(i=0;i<nb;i++)
    genseq[i]=(char*)check_alloc(lgtot+1, sizeof(char));
  j=0;
  for(i=0;i<nbseq;i++){
    if(dataname.selected[i]){
      genname[j]=cname[i];
      l=0;
      for(k=0;k<lgseq;k++)
	if(selected[k]) genseq[j][l++]=seq[i][k];
      j++;
    }
  }

/*
ti=(double*)check_alloc(nb*(nb-1)/2, sizeof(double));
tv=(double*)check_alloc(nb*(nb-1)/2, sizeof(double));
*/

/* ALL SITES : COMPOSITION */

  lgcomp=(int*)check_alloc(nb, sizeof(int));
  comp=(double**)check_alloc(nb, sizeof(double*));
  for(i=0;i<nb;i++) 
    comp[i]=(double*)check_alloc(PROTB?nbaa:4, sizeof(double));
  compall=(double*)check_alloc(PROTB?nbaa:4, sizeof(double));

  if(PROTB){
    compgroup=(double**)check_alloc(nb, sizeof(double*));
    for(i=0;i<nb;i++) 
      compgroup[i]=(double*)check_alloc(nbaagroup, sizeof(double));
    compgroupall=(double*)check_alloc(nbaagroup, sizeof(double));
 
    totlgcomp=0;
    for(i=0;i<nb;i++){
      lgcomp[i]=aacomp(genseq[i], comp[i], compgroup[i]);
      totlgcomp+=lgcomp[i];
    }
    for(i=0;i<nbaa;i++){
      compall[i]=0.;
      for(j=0;j<nb;j++)
	compall[i]+=comp[j][i]*lgcomp[j];
      compall[i]/=totlgcomp;
    }
    for(i=0;i<nbaagroup;i++){
      compgroupall[i]=0.;
      for(j=0;j<nb;j++)
	compgroupall[i]+=compgroup[j][i]*lgcomp[j];
      compgroupall[i]/=totlgcomp;
    }
  }
  else{  
    totlgcomp=0;
    for(i=0;i<nb;i++){
      lgcomp[i]=basecomp(genseq[i], comp[i]);
      totlgcomp+=lgcomp[i];
    }
    for(i=0;i<4;i++){
      compall[i]=0.;
      for(j=0;j<nb;j++)
	compall[i]+=comp[j][i]*lgcomp[j];
      compall[i]/=totlgcomp;
      
    }
  }  


	/* COMPLETE SITES ONLY */

  refresh(genseq, nb, 0, PROTB);
  lg=(int)strlen(genseq[0]);
  lgvar=variable(genseq, nb);
  lginfo=informative(genseq, nb);

		/* COMPOSITION */

  if(!PROTB && lg!=0){
    for(i=0;i<nb;i++)
      lgcomp[i]=basecomp(genseq[i], comp[i]);
    for(i=0;i<4;i++){
      compcomp[i]=0;
      for(j=0;j<nb;j++) compcomp[i]+=comp[j][i];
      compcomp[i]/=nb;
      min[i]=max[i]=comp[0][i]; minname[i]=maxname[i]=genname[0];
      for(j=0;j<nb;j++){
	if(comp[j][i]<min[i]){ min[i]=comp[j][i]; minname[i]=genname[j]; }
	if(comp[j][i]>max[i]){ max[i]=comp[j][i]; maxname[i]=genname[j]; }
      }
    }
  }

		/* CHANGES */

  if(!PROTB && lg!=0){
/*
FILE* titvf;
*/
    for(ii=0;ii<16;ii++) mat_obs[ii]=0.;
    k=0; nbcp=0;
    titvmin=100000.; titvmax=0.;
    for(i=0;i<nb-1;i++){
      for(j=i+1;j<nb;j++){
        (void) freq_obs(genseq[i], genseq[j], freq);
        P=(freq[2]+freq[7]+freq[8]+freq[13])*lg;
        Q=(freq[1]+freq[3]+freq[4]+freq[6]+freq[9]+freq[11]+freq[12]+freq[14])*lg;
        for(ii=0;ii<16;ii++) mat_obs[ii]+=freq[ii];
/*
ti[nc]=P;
tv[nc]=Q;
nc++;
*/

	Psum+=P;
	Qsum+=Q;
        if(Q>0.1){
	  titvratio=P/Q;
          if(titvratio<titvmin){ 
	    titvmin=titvratio; 
	    titvminname1=genname[i];
	    titvminname2=genname[j];
	    Pmin=P; Qmin=Q;
	  }
      	  if(titvratio>titvmax){ 
	    titvmax=titvratio; 
	    titvmaxname1=genname[i];
	    titvmaxname2=genname[j];
	    Pmax=P; Qmax=Q;
	  }
	  nbcp++;
        }
        k++;
      }
    }

    for(ii=0;ii<16;ii++) mat_obs[ii]/=(nb*(nb-1)/(2*100.));

/*
printf("observed matrix :\n");
printf("AA : %.1f  CC : %.1f  GG : %.1f  TT : %.1f\n",
    mat_obs[0], mat_obs[5], mat_obs[10], mat_obs[15]);
printf("AG : %.1f  CT : %.1f\n",
    mat_obs[2]+mat_obs[8], mat_obs[7]+mat_obs[13]);
printf("AC : %.1f  AT : %.1f  CG : %.1f  GT : %.1f\n",
    mat_obs[1]+mat_obs[4], mat_obs[3]+mat_obs[12],
    mat_obs[6]+mat_obs[9], mat_obs[11]+mat_obs[14]);
*/

/*
titvf=fopen("TITV", "w");
(void) fprintf(titvf, "Ti\tTv\n");
for(i=0;i<nc;i++) (void) fprintf(titvf, "%f\t%f\n", ti[i], tv[i]);
(void) fclose(titvf);
*/
  }


		/* PAIRWISE SUBSTITUTION MATRIX */

  if(!PROTB && nb==2 && lg!=0)
    (void) freq_obs(genseq[0], genseq[1], freq);

	
	/* DISPLAY INTO NEW WINDOW */
  
  genw=FixedWindow(-50, -50, -10, -10, "GENERAL INFORMATIONS", quitwin_w);
  (void) sprintf(text, "%d", nb);
  (void) StaticPrompt(genw, text, 0, 14, gras, 'l');
  Advance(genw);
  if(selgroup==-1) (void) sprintf(text, "selected species");
  else {
    (void) sprintf(groupname, "%s", specsetname[selgroup]);
    c1=strchr(groupname, '('); if(c1)*c1=0;
    (void) sprintf(text, "selected species   (group : %s)", groupname);
  }
  (void) StaticPrompt(genw, text, 0, 14, gros, 'l');
  Break(genw);
  if(nb<=20){
    for(i=0;i<nb;i++){
      (void) sprintf(text, "%s,", genname[i]);
      (void) StaticPrompt(genw, text, 0, 14, gros, 'l');
      if((i+1)%4==0 || i==nb-1) Break(genw); else Advance(genw);
    }
  }
  shift(genw, 0, 15);
  (void) sprintf(text, "%d", lgtot);
  (void) StaticPrompt(genw, text, 0, 14, gras, 'l');
  Advance(genw);
  if(selset==-1) (void) sprintf(text, "selected sites");
  else{
    (void) sprintf(setname, "%s", sitesetname[selset]);
    c2=strchr(setname, '('); if(c2) *c2=0;
    (void) sprintf(text, "selected sites   (set : %s)", setname);
  }
  (void) StaticPrompt(genw, text, 0, 14, gros, 'l');
  Break(genw);
  if(PROTB)
    (void) sprintf(text, "    including    %d complete (no gaps, no X)", lg);
  else
    (void) sprintf(text, "    including    %d complete (no gaps, no N)", lg);
  if(nb>=2 && lg!=0){
    (void) StaticPrompt(genw, text, 0, 14, gros, 'l');
    Break(genw);
    (void) sprintf(text, "    including    %d variable (%.1f%% of complete)",
        lgvar, (double)lgvar*100/lg);
    (void) StaticPrompt(genw, text, 0, 14, gros, 'l');
    Break(genw);
    if(nb>=4){
      (void) sprintf(text, "    including    %d informative (%.1f%% of complete)",
        lginfo, (double)lginfo*100/lg);
      (void) StaticPrompt(genw, text, 0, 14, gros, 'l');
      Break(genw);
    }
  }

  shift(genw, 0, 20);

  if(PROTB){
    (void) StaticPrompt(genw, "AMINOACID COMPOSITION (all sites) :", 0, 14, gros, 'l');
    Break(genw);
    j=0;
    for(i=0;i<nbaagroup;i++){
      (void) sprintf(text, "Group %d : %.1f%%", i+1, compgroupall[i]);
      (void) StaticPrompt(genw, text, 0, 14, gros, 'l');
      Break(genw);
      while(aagroup[j]==i){
	(void) sprintf(text, "%c : %.1f", aalist[j], compall[j]);
	shift(genw, 25, 0);
 	(void) StaticPrompt(genw, text, 0, 14, gros, 'l');
   	Break(genw);
	j++;
      }
    }
    if(j!=nbaa){
      (void) sprintf(text, "Others : ");
      (void) StaticPrompt(genw, text, 0, 14, gros, 'l');
      Break(genw);
      while(aalist[j]){
	(void) sprintf(text, "%c : %.1f", aalist[j], compall[j]);
	shift(genw, 25, 0);
 	(void) StaticPrompt(genw, text, 0, 14, gros, 'l');
   	Break(genw);
	j++;
      }
    }
  }
  else{
    GrouP compgr;
    (void) StaticPrompt(genw, "BASE COMPOSITION :", 0, 14, gros, 'l');
    Break(genw);
    shift(genw, 20, 0);
    (void) sprintf(text, "All sites  :\t %.1f%% A   %.1f%% C   %.1f%% G   %.1f%% T",
         compall[0], compall[1], compall[2], compall[3]);
    (void) StaticPrompt(genw, text, 0, 14, gros, 'l');
    Break(genw);
    if(nb>1 && lg!=0){
      shift(genw, 20, 0);
      (void) StaticPrompt(genw, "Complete sites only :", 0, 14, gros, 'l');
      Break(genw);
      shift(genw, 10, 10);
      compgr=HiddenGroup(genw, 4, 5, NULL);
      mySetGroupSpacing(compgr, 15, 15);
      (void) StaticPrompt(compgr, "", 0, 14, gros, 'c');
      (void) StaticPrompt(compgr, "", 0, 14, gros, 'c');
      (void) StaticPrompt(compgr, "Minimum", 0, 14, gros, 'c');
      (void) StaticPrompt(compgr, "Maximum", 0, 14, gros, 'c');
      for(i=0;i<4;i++){
        (void) sprintf(text, "%c : ", nt[i]);
        (void) StaticPrompt(compgr, text, 0, 14, gras, 'c');
        (void) sprintf(text, "%.1f %%", compcomp[i]);
        (void) StaticPrompt(compgr, text, 0, 14, gras, 'c');
        (void) sprintf(text, "%.1f%% (%s)", min[i], minname[i]);
        (void) StaticPrompt(compgr, text, 0, 14, gros, 'c');
        (void) sprintf(text, "%.1f%% (%s)", max[i], maxname[i]);
        (void) StaticPrompt(compgr, text, 0, 14, gros, 'c');
      }
      Break(genw);
    }
  }

  shift(genw, 0, 20);

  if(!PROTB && nb>1 && lg!=0){
    (void) StaticPrompt(genw, "OBSERVED CHANGES (complete sites)", 0, 14, gros, 'l');
    Break(genw);
    shift(genw, 20, 0);
    if(nb>2)
      (void) sprintf(text, "Transition/transversion ratio : %.3f (mean over all sequence pairs)",
      (double)Psum/Qsum);
    else
      (void) sprintf(text, "Transition/transversion ratio : %.3f", (double)Psum/Qsum);
    (void) StaticPrompt(genw, text, 0, 14, gros, 'c');
    Break(genw);
    if(nb>2){
      shift(genw, 20, 0);
      (void) sprintf(text, "Minimum : %.3f (%s - %s, %d transitions, %d transversions)",
            titvmin, titvminname1, titvminname2, (int)Pmin, (int)Qmin);
      (void) StaticPrompt(genw, text, 0, 14, gros, 'c');
      Break(genw);
      shift(genw, 20, 0);
      (void) sprintf(text, "Maximum : %.3f (%s - %s, %d transitions, %d transversions)",
         titvmax, titvmaxname1, titvmaxname2, (int)Pmax, (int)Qmax);
      (void) StaticPrompt(genw, text, 0, 14, gros, 'c');
      Break(genw);
    }
    else{
      GrouP chgr;
      shift(genw, 20, 0);
      (void) StaticPrompt(genw, "Observed nucleotide pairs :", 0, 14, gros, 'l');
      Break(genw);
      shift(genw, 60, 0);
      (void) StaticPrompt(genw, genname[1], 0, 14, gros, 'l');
      Break(genw);
      chgr=HiddenGroup(genw, 6, 5, NULL);
      mySetGroupSpacing(chgr, 8, 8);
      (void) StaticPrompt(chgr, "",  0, 14, gros, 'c');
      (void) StaticPrompt(chgr, "",  0, 14, gros, 'c');
      for(i=0;i<4;i++){
        (void) sprintf(text, "%c", nt[i]);
        (void) StaticPrompt(chgr, text, 0, 14, gras, 'c');
      }
      for(i=0;i<4;i++){
 	if(i==1) (void) StaticPrompt(chgr, genname[0], 0, 14, gros, 'c');
        else (void) StaticPrompt(chgr, "", 0, 14, gros, 'c');
	(void) sprintf(text, "%c", nt[i]);
        (void) StaticPrompt(chgr, text, 0, 14, gras, 'c');
  	for(j=0;j<4;j++){
	  (void) sprintf(text, "%d", (int)(freq[4*i+j]*lgtot));
	  (void) StaticPrompt(chgr, text, 0, 14, gros, 'c');
	}
      }
    }
  }

  Break(genw);
  shift(genw, 20, 20);
  (void) PushButton(genw, "SAVE", createinfosavebox); 
  Advance(genw);
  shift(genw, 20, 0);
  (void) PushButton(genw, "QUIT", quitwin);


	/* WRITE INFO INTO CHAR* INFOTEXT FOR SAVING */

  for(i=0;i<10000;i++) infotext[i]=0;
  (void) sprintf(infotext, "File : %s\n\n", infile);

  if(!PROTB && !(GetStatus(po1i) && GetStatus(po2i) && GetStatus(po3i))){
    int first=0, second=0;
    (void) strcat(infotext, "Codon positions : ");
    if(GetStatus(po1i)) {(void) strcat(infotext, "1"); first=1; }
    else if(GetStatus(po2i)) {(void) strcat(infotext, "2"); second=1; }
    else if(GetStatus(po3i)) (void) strcat(infotext, "3");
    if(first){
      if(GetStatus(po2i)) (void) strcat(infotext, " + 2");
      if(GetStatus(po3i)) (void) strcat(infotext, " + 3");
    }
    else if(second){
      if(GetStatus(po3i)) (void) strcat(infotext, " + 3");
    }
    (void) strcat(infotext, "\n\n");
  }

  (void) sprintf(text, "%d selected species", nb);
  (void) strcat(infotext, text);
  if(selgroup!=-1)
    (void) sprintf(text, " (group : %s)\n", groupname);
  else
    (void) sprintf(text, "\n");
  (void) strcat(infotext, text);
  if(nb<=20){
    for(i=0;i<nb;i++) {
      if((i+1)%4==0 || i==nb-1) 
	(void) sprintf(text, "%s\n", genname[i]);
      else
	(void) sprintf(text, "%s, ", genname[i]);
      (void) strcat(infotext, text);
    }
  }
  if(selset!=-1)
    (void) sprintf(text, "\n%d selected sites (set : %s)\nincluding %d complete (no gaps, no %c)\n",
       lgtot, setname, lg, PROTB?'X':'N');
  else
    (void) sprintf(text, "\n%d selected sites\nincluding %d complete (no gaps, no %c)\n",
       lgtot, lg, PROTB?'X':'N'); 
  (void) strcat(infotext, text);
  if(nb>=2 && lg!=0){
    (void) sprintf(text,"including %d variable (%.1f%% of complete)\n", lgvar, (float)lgvar*100/lg);
    (void) strcat(infotext, text);
  }
  if(nb>=4 && lg!=0){
    (void) sprintf(text,"including %d informative (%.1f%% of complete)\n", lginfo, (float)lginfo*100/lg);
    (void) strcat(infotext, text);
  }

  if(PROTB){
    (void) strcat(infotext, "\nAMINOACID COMPOSITION (all sites)\n");
    j=0;
    for(i=0;i<nbaagroup;i++){
      (void) sprintf(text, "Group %d : %.1f%%\n", i+1, compgroupall[i]);
      (void) strcat(infotext, text);;
      while(aagroup[j]==i){
	(void) sprintf(text, "\t%c : %.1f\n", aalist[j], compall[j]);
	(void) strcat(infotext, text);
	j++;
      }
    }
    if(j!=nbaa){
      (void) sprintf(text, "Others : \n");
      (void) strcat(infotext, text);
      while(aalist[j]){
	(void) sprintf(text, "\t%c : %.1f\n", aalist[j], compall[j]);
 	(void) strcat(infotext, text);
	j++;
      }
    }    
  } 
  else{
    (void) strcat(infotext, "\nBASE COMPOSITION\n");
    (void) sprintf(text, "\tAll sites  :\t %.1f%% A    %.1f%% C   %.1f%% G   %.1f%% T\n",
      compall[0], compall[1], compall[2], compall[3]);
    (void) strcat(infotext, text);
    if(nb>1 && lg!=0){
      (void) strcat(infotext, "\tComplete sites only :\n\t\t\tMinimum\t\t\tMaximum\n");
      for(i=0;i<4;i++){
        (void) sprintf(text, "\t%c :\t%.1f %%\t%.1f%% (%s)\t%.1f%% (%s)\n",
           nt[i], compcomp[i], min[i], minname[i], max[i], maxname[i]);
        (void) strcat(infotext, text);
      }
    }
  }

  if(!PROTB && nb>1 && lg!=0){
    (void) strcat(infotext, "\nOBSERVED CHANGES (complete sites)\n");
    if(nb>2)
      (void) sprintf(text, "\tTransition/transversion ratio : %.3f (mean over all sequence pairs)\n",
      Psum/Qsum);
    else
      (void) sprintf(text, "\tTransition/transversion ratio : %.3f\n", Psum/Qsum);
    (void) strcat(infotext, text);
    if(nb>2){
      (void) sprintf(text, "\tMinimum : %.3f (%s - %s , %d transitions, %d transversions)\n",
         titvmin, titvminname1, titvminname2, (int)Pmin, (int)Qmin);
      (void) strcat(infotext, text);
      (void) sprintf(text, "\tMaximum : %.3f (%s - %s , %d transitions, %d transversions)\n",
         titvmax, titvmaxname1, titvmaxname2, (int)Pmax, (int)Qmax);
      (void) strcat(infotext, text);
    }
    else{
      (void) sprintf(text, "\nObserved nucleotide pairs :\n\n\t\t\t\t%s\n\n\t\t\tA\tC\tG\tT\n\n",
         genname[0]);
      (void) strcat(infotext, text);
      for(i=0;i<4;i++){
        (void) sprintf(text, "\t\t%c\t%d\t%d\t%d\t%d\n",
          nt[i], (int)(freq[4*i]*lgtot), (int)(freq[4*i+1]*lgtot),
         (int)(freq[4*i+2]*lgtot), (int)(freq[4*i+3]*lgtot));
	(void) strcat(infotext, text);
      }
    }
  }


  Show(genw);


  free(selected); free(text);
  for(i=0;i<nb;i++) {free(genseq[i]); free(comp[i]);}
  free(genseq); free(genname); free(comp);
  free(lgcomp); free(compall); 
  if(PROTB){
    /*for(i=0;i<nb;i++) free(compgroup[i]);*/
    free(compgroup);
    free(compgroupall);
  }
} 



/* bopi_act */

void bopi_act(IteM it){
  static char text[10];
  GrouP group1, group2, group3, group4;

  (void) sprintf(text, "%d", defnbrep);
  bopw=FixedWindow(-50, -50, -10, -10, "BOOTSTRAP OPTIONS", quitwin_w);
  
  shift(bopw, 20, 20);
  group1=HiddenGroup(bopw, 2, 0, NULL);
  (void) StaticPrompt(group1, "By default nb replicates :", 156, 14, gros, 'l');
  shift(group1, 0, -8);
  defnbrep_text=DialogText(group1, text, 4, NULL);
  Break(bopw);
  shift(bopw, 20, 20);
  group2=HiddenGroup(bopw, 2, 0, NULL);
  (void) StaticPrompt(group2, "Jumble for each replicate", 150, 14, gros, 'l');
  jbob=CheckBox(group2, "", NULL);
  SetStatus(jbob, JUMBBOOT);
  Break(bopw);
  shift(bopw, 20, 20);
  group3=HiddenGroup(bopw, 2, 0, NULL);
  (void) StaticPrompt(group3, "Allow branch combining", 150, 14, gros, 'l');
  abcb=CheckBox(group3, "", NULL);
  SetStatus(abcb, COMBALLOWED);
  Break(bopw);
  shift(bopw, 20, 20);
  group4=HiddenGroup(bopw, 2, 0, NULL);
  (void) StaticPrompt(group4, "   Consensus tree   ", 150, 14, gros, 'l');
  conb=CheckBox(group4, "", NULL);
  SetStatus(conb, CONSENSE);
  Break(bopw);
  shift(bopw, 80, 30);
  (void) PushButton(bopw, "OK", quitbopw);
  Show(bopw);
}


/* toni_act */

void toni_act(IteM it){
  int i;
  
  if(TRANSVONLY){
  Yellow(); colg=GetColor(); 
  Blue(); colt=GetColor(); 
  TRANSVONLY=FALSE; 
  Enable(bml);
  for(i=2;i<=8;i++)
    Enable(b[i]);
  SetTitle(b[1], "Jukes & Cantor");
   
  }
  else{
  Red(); colg=GetColor();
  Green(); colt=GetColor();
  TRANSVONLY=TRUE;
  Disable(bml); 
  i=GetValue(dist);
  if(i>2){
    SetValue(dist, 0);
    if(GetStatus(bnj)) Disable(bdt);
    SetStatus(bnj, FALSE);
  }
  for(i=2;i<=8;i++)
    Disable(b[i]);
  SetTitle(b[1], "Corrected transversions");
  }
  Black();
  draw(pseq);
}



/* quitmlpw */

void quitmlpw(ButtoN but){

  static char text[10];

  GetTitle(ttrat_text, text, 10);
  (void) sscanf(text, "%le", &ttrat);

  GetTitle(gd_text, text, 10);
  (void) sscanf(text, "%d", &Gduring);
  GetTitle(ga_text, text, 10);
  (void) sscanf(text, "%d", &Gafter);

  (void) Remove(mlpw); mlpw=NULL;
}




/* mlpi_act */

void mlpi_act(IteM it){
  static char text[10];
  GrouP group1, group2, group21, group22;

  mlpw=FixedWindow(-50, -50, -10, -10, "ML PARAMETERS", quitwin_w);

  shift(mlpw, 20, 20);
  group1=HiddenGroup(mlpw, 2, 0, NULL);
  (void) StaticPrompt(group1, "transition/transversion ratio :", 186, 14, gros, 'l');
  shift(group1, 0, -8);
  (void) sprintf(text, "%.2f", ttrat);
  ttrat_text=DialogText(group1, text, 4, NULL);
  Break(bopw);
  shift(bopw, 20, 20);

  group2=HiddenGroup(mlpw, 0, 3, NULL);
  mySetGroupMargins(group2, 10, 10);
  mySetGroupSpacing(group2, 0, 15);
  (void) StaticPrompt(group2, "Tree rearrangement : nb of branches crossed by subtree",
     324, 14, gros, 'l');
  group21=HiddenGroup(group2, 2, 0, NULL);
  (void) StaticPrompt(group21, "        - during species addition : ", 216, 14, gros, 'l');
  shift(group21, 0, -8);
  (void) sprintf(text, "%d", Gduring);
  gd_text=DialogText(group21, text, 2, NULL);
  group22=HiddenGroup(group2, 2, 0, NULL);
  (void) StaticPrompt(group22, "        - after species addition : ", 216, 14, gros, 'l');
  shift(group22, 0, -8);
  (void) sprintf(text, "%d", Gafter);
  ga_text=DialogText(group22, text, 2, NULL);

  Break(mlpw);
  shift(mlpw, 80, 30);
  (void) PushButton(mlpw, "OK", quitmlpw);
  Show(mlpw);
}


/* hiseb_act */

void hiseb_act(ButtoN but){
  static char titre[20];
  printdata data;

  GetPanelExtra(pseq, &data);
  HIDDENSEQ=!HIDDENSEQ;
  GetTitle(but, titre, 50);
  if(strncmp(titre, "HIDE", 4)==0){
    SetTitle(but, "SHOW SEQUENCES");
    SetPanelClick(pseq, NULL, NULL, NULL, NULL);
  }
  else{
    SetTitle(but, "HIDE SEQUENCES");
    SetPanelClick(pseq, pseqclick, NULL, NULL, pseqrelease);
  }
  drawseqpanel(pseq);
}
  



/* enablebuttons */
/* Back to tree-building mode */

void enablebuttons(void){
  printdata data;
  int i;

  GetPanelExtra(pbuild, &data);
  Enable(bnj);  
  if(SMALLSCREEN){
    SetTitle(bnj, "N.J."); 
    SetTitle(bmp, "M.P."); 
    SetTitle(bml, "M.L.");
    }
  else{
    SetTitle(bnj, "NEIGHBOR  JOINING"); 
    SetTitle(bmp, "MAX. PARSIMONY"); 
    SetTitle(bml, "MAX. LIKELIHOOD");
  }
  Enable(bboot);
  /*Enable(bmult); */
  if (method!=1) Enable(bjumb);
  Enable(inputtree);
  SetStatus(bboot, FALSE); SetStatus(bmult, FALSE); SetStatus(bjumb, FALSE);
  option=0;
  if (Enabled(bdeltree)) Disable(bdeltree);
  if (Enabled(evaltree)) Disable(evaltree);
  for(i=0;i<nbtree;i++) data.selected[i]=0;
  SetPanelExtra(pbuild, &data);
  draw(pbuild);
  SetStatus(bnj, FALSE);
  SetStatus(bmp, FALSE);
  SetStatus(bml, FALSE);
  method=0;
  Disable(bdt);
}


void quithelp(ButtoN but){
  
  (void) Remove(ParentWindow(but));
  numhelp--;
}


void quithelp_w(WindoW w){
  
  (void) Remove(w);
  numhelp--;
}





void help_act(IteM i){
  int maxlhline=2000, ok=0;
  char topic[5], hline[MAXHELP], *line;
  FILE* helpf;
  TexT htext;
  
  hline[0]=0;

  
  helpf=fopen(helpfname, "r");
  if(helpf==NULL){
    createmessbox("Cannot open help file", FALSE, quiterr, NULL);
    return;
  }

  if(i==abpwi) (void) sprintf(topic, ">>>abpw");
  if(i==intri || i==(IteM)firsthelpb) (void) sprintf(topic, ">>>intr");
  if(i==inoui) (void) sprintf(topic, ">>>inou");
  if(i==spsei) (void) sprintf(topic, ">>>spse");
  if(i==sisei) (void) sprintf(topic, ">>>sise");
  if(i==dispi) (void) sprintf(topic, ">>>disp");
  if(i==trdii) (void) sprintf(topic, ">>>trdi");
  if(i==miopi) (void) sprintf(topic, ">>>miop");
  if(i==dimei) (void) sprintf(topic, ">>>dime");
  if(i==mapai) (void) sprintf(topic, ">>>mapa");
  if(i==malii) (void) sprintf(topic, ">>>mali");
  if(i==booti) (void) sprintf(topic, ">>>boot");
  if(i==jumbi) (void) sprintf(topic, ">>>jumb");
  if(i==gaopi) (void) sprintf(topic, ">>>gaop");
  if(i==trevi) (void) sprintf(topic, ">>>trev");
  if(i==mapli) (void) sprintf(topic, ">>>mapl");
  if(i==proti) (void) sprintf(topic, ">>>prot");

  line=(char*)check_alloc(maxlhline, sizeof(char));
  while(fgets(line, maxlhline, helpf)){
    if (strncmp(line, topic, 7)==0) { ok=1; break; }
  }
  if(!ok) { (void) printf("Can't find topic %s\n", topic); return; }
  
  while(fgets(line, maxlhline, helpf)){
    if(strncmp(line, ">>>", 3)==0) break;
    (void) strcat(hline, line);
  }

  (void) fclose(helpf);

  numhelp++;
  if(numhelp>MAXHELPW){ 
    createmessbox("Too many opened help windows", FALSE, quiterr, NULL);
    return;
  }

  helpw[numhelp]=FixedWindow(-50, -33, -10, -10, "", quithelp_w);
  htext=ScrollText(helpw[numhelp], 60, 40, petit, TRUE, NULL);
  Break(helpw[numhelp]);
  (void) PushButton(helpw[numhelp], "OK", quithelp);
  SetTitle(htext, hline);
  Show(helpw[numhelp]);
}

  
  
  

/* putobjects */
/* Create main window w and child objects. */

void putobjects(int nbl){

printdata data;
WindoW w2;
PoinT pt;
RecT rect;


  w2 = FixedWindow (-50, -33, -10, -10, infile, quitmain_w);

  filem=PulldownMenu(w2, "   FILE   ");
  savei=CommandItem(filem, "Save", (ItmActnProc)saveproc);
  savai=CommandItem(filem, "Save as", (ItmActnProc)savaproc);
  loadi=CommandItem(filem, "Open", (ItmActnProc)loadproc);
  quiti=CommandItem(filem, "Quit", (ItmActnProc)quitmain);
  editm=PulldownMenu(w2, "  DISPLAY ");
  movei=CommandItem(editm, "Move", move_act);
  removei=CommandItem(editm, "Remove", remove_act);
  renamei=CommandItem(editm, "Rename", rename_act);
  utim=PulldownMenu(w2, " MISC ");
  geni=CommandItem(utim, "General informations", geni_act);
  outi=StatusItem(utim, "Output Distance Matrix ", NULL);
  auti=StatusItem(utim, "Auto Save ", NULL);
  if(!SMALLSCREEN)
    smti=StatusItem(utim, "Small tree windows ", NULL);
  helpm=PulldownMenu(w2, "   HELP   ");
  generm=SubMenu(helpm, "General");
  abpwi=CommandItem(generm, "About PHYLO_WIN", help_act);
  intri=CommandItem(generm, "Introduction", help_act);
  inoui=CommandItem(generm, "Input-Output", help_act);
  spsei=CommandItem(generm, "Species selection", help_act);
  sisei=CommandItem(generm, "Sites selection", help_act);
  dispi=CommandItem(generm, "Seq. display", help_act);
  trdii=CommandItem(generm, "Tree display", help_act);
  miopi=CommandItem(generm, "Misc options", help_act);
  algm=SubMenu(helpm, "Algorithms");
  dimei=CommandItem(algm, "Distance based method", help_act);
  mapai=CommandItem(algm, "Maximum Parsimony", help_act);
  malii=CommandItem(algm, "Maximum likelihood", help_act);
  booti=CommandItem(algm, "Bootstrap", help_act);
  jumbi=CommandItem(algm, "Jumble", help_act);
  gaopi=CommandItem(algm, "Gap options", help_act);
  trevi=CommandItem(algm, "Tree evaluation", help_act);
  formm=SubMenu(helpm, "Format");
  mapli=CommandItem(formm, "MASE+", help_act);
  proti=CommandItem(formm, "Prototype", help_act);
  if(!SMALLSCREEN)
    (void) PulldownMenu(w2, "                          ");
  
  optm=PulldownMenu(w2, "  OPTIONS  ");
  nogi=StatusItem(optm, "Pairwise gap removal", NULL);
  if(!PROTB) toni=StatusItem(optm, "Transversions only", toni_act);
  bopi=CommandItem(optm, "Bootstrap options  ", bopi_act);
  mlpi=CommandItem(optm, "ML parameters", mlpi_act);
  codem=PulldownMenu(w2, "   CODING   ");
  nucli=StatusItem(codem, "Nuclear code", ncode_act);
  miti=StatusItem(codem, "mt code", mcode_act);
  if(!PROTB){
    po1i=StatusItem(codem, "1st positions", pos_act);
    po2i=StatusItem(codem, "2nd positions", pos_act);
    po3i=StatusItem(codem, "3rd positions", pos_act);
  }
  SetStatus(nucli, TRUE);
  distm=PulldownMenu(w2, " DISTANCE ");
  dist=ChoiceGroup(distm, dist_act);

  if (!PROTB){
    b[0]=ChoiceItem(dist, "Obs. Divergence");
    b[1]=ChoiceItem(dist, "Jukes & Cantor");
    b[2]=ChoiceItem(dist, "Kimura 2 param.");
    b[3]=ChoiceItem(dist, "Tajima & Nei");
    b[5]=ChoiceItem(dist, "HKY");
    b[4]=ChoiceItem(dist, "Galtier & Gouy");
    b[6]=ChoiceItem(dist, "Log Det");
    b[7]=ChoiceItem(dist, "Ka");
    b[8]=ChoiceItem(dist, "Ks");
  }
  else{
    b[0]=ChoiceItem(dist, "Obs. Divergence");
    b[1]=ChoiceItem(dist, "Poisson");
    b[2]=ChoiceItem(dist, "  Ka  ");
    b[3]=ChoiceItem(dist, "  Ks  ");
  }


  shift(w2, 120, 7);
  (void) StaticPrompt(w2, "Selected species :", 0, dialogTextHeight, gros, 'l'); 
  Advance(w2);
  selsp_text=DialogText(w2, "", 3, NULL); 
  Advance(w2);
  shift(w2, 30, 0);
  (void) StaticPrompt(w2, "Selected sites :", 0, dialogTextHeight, gros, 'l'); 
  Advance(w2);
  selsi_text=DialogText(w2, "", 5, NULL);  
  Advance(w2);
  
  shift(w2, SMALLSCREEN?250:450, /*5*/0);
  hiseb=PushButton(w2, "HIDE SEQUENCES", hiseb_act);

  
  Break(w2);
  shift(w2, 0, -10);
  panels=HiddenGroup(w2, 3, 0, NULL);
  mySetGroupSpacing(panels, 0, 0);
  vert=ScrollBar(panels, -1, /*36*/ nbl+1, (BarScrlProc)vscrollpname);

  pname=createpanel(panels, 16, /*35*/ nbl, gras, drawnamepanel, NULL, NULL, pname_callback, 1); 
  SetPanelClick(pname,pnameclick, NULL, NULL, pnamerelease);

  pseq=createpanel(panels, SMALLSCREEN?60:100, /*35*/ nbl, gras, drawseqpanel,
                 NULL, NULL, pseq_callback, 1);
  SetPanelClick(pseq, pseqclick, NULL, NULL, pseqrelease);
  Break(w2);


  ObjectRect(pseq, &rect);
  pt.x=rect.left;
  pt.y=rect.bottom;
  SetNextPosition(w2, pt);
  horiz=ScrollBar(w2, SMALLSCREEN?61:102, -1, (BarScrlProc)hscrollpseq);

  GetPanelExtra(pname, &data);
  data.vertical=vert;
  data.horizontal=NULL;
  SetPanelExtra(pname, &data);

  GetPanelExtra(pseq, &data);
  data.vertical=NULL;
  data.horizontal=horiz;
  SetPanelExtra(pseq, &data);

  Break(w2);
  shift(w2, 5, 0);

  species=NormalGroup(w2, 0, 3, SMALLSCREEN?"SPECIES":"SPECIES  SELECTION", titlefont, NULL);
  mySetGroupSpacing(species, 8, 0);
  spbuttons=HiddenGroup(species, 0, 2, NULL);
  mySetGroupMargins(spbuttons, 0, 4);
  mySetGroupSpacing(spbuttons, 8, 4);
  shift(spbuttons, 10, 5);
  if(SMALLSCREEN){
  sp_sel=PushButton(spbuttons, "all", sp_sel_act);
  sp_unsel=PushButton(spbuttons, "none", sp_unsel_act);
  sp_add=PushButton(spbuttons, "add", sp_add_act);
  sp_del=PushButton(spbuttons, "del", sp_del_act);
  }
  else{
  sp_sel=PushButton(spbuttons, "select  all", sp_sel_act);
  sp_unsel=PushButton(spbuttons, "select  none", sp_unsel_act);
  sp_add=PushButton(spbuttons, "add  group", sp_add_act);
  sp_del=PushButton(spbuttons, "del.  group", sp_del_act);
  }
  spgrname=HiddenGroup(species, 2, 0, NULL);
  shift(spgrname, 15, 2);
  (void) StaticPrompt(spgrname, "Group  :", 0, /*14*/dialogTextHeight, gros, 'l');
/*shift(spgrname, 0, -12);*/
  sp_text=DialogText(spgrname, "", 10, NULL);
/*shift(species, 0, -5);*/
  pspecies=createpanel(species, SMALLSCREEN?8:15, SMALLSCREEN?4:6, maigre,
         drawpanel, (BarScrlProc)vscroll, NULL, pspecies_callback, 0);
  Disable(sp_sel);
  Disable(sp_unsel);
  Disable(sp_add);
  Disable(sp_del);
  Disable(spgrname);
  SetPanelClick(pspecies,shiftlineclick,NULL,NULL,NULL);


  Advance(w2);
  shift(w2, 10, 0);

  sitesgr=NormalGroup(w2, 0, 3, SMALLSCREEN?"SITES":"SITES  SELECTION", titlefont, NULL);
  mySetGroupSpacing(sitesgr, 8, 0);
  sibuttons=HiddenGroup(sitesgr, 0, 2, NULL);
  mySetGroupMargins(sibuttons, 0, 4);
  mySetGroupSpacing(sibuttons, 8, 4);
  shift(sibuttons, 10, 5);
  if(SMALLSCREEN){
  si_sel=PushButton(sibuttons, "all", si_sel_act);
  si_unsel=PushButton(sibuttons, "none", si_unsel_act);
  si_add=PushButton(sibuttons, "add", si_add_act);
  si_del=PushButton(sibuttons, "del", si_del_act);
  }
  else{
  si_sel=PushButton(sibuttons, "select  all", si_sel_act);
  si_unsel=PushButton(sibuttons, "select  none", si_unsel_act);
  si_add=PushButton(sibuttons, "add  set", si_add_act);
  si_del=PushButton(sibuttons, "delete set", si_del_act);
  }
  sigrname=HiddenGroup(sitesgr, 2, 0, NULL);
  shift(sigrname, 20, 2);
  (void) StaticPrompt(sigrname, "Set  :", 0, /*14*/ dialogTextHeight, gros, 'l');
/*shift(sigrname, 0, -12);*/
  si_text=DialogText(sigrname, "", 10, NULL);
/*shift(sitesgr, 0, -5);*/
  psites=createpanel(sitesgr, SMALLSCREEN?8:15,SMALLSCREEN?4:6,
        maigre, drawpanel, (BarScrlProc)vscroll, NULL, psites_callback, 0);
  Disable(si_sel);
  Disable(si_unsel);
  Disable(si_add);
  Disable(si_del);
  Disable(sigrname);
  SetPanelClick(psites,shiftlineclick,NULL,NULL,NULL);

  Advance(w2);
  shift(w2, 10, 0);

  tbuild=NormalGroup(w2, 2, -1, "TREE  BUILDING", titlefont, NULL);
  mySetGroupMargins(tbuild, 10, 0);
  if(SMALLSCREEN){
    tbuild1=HiddenGroup(tbuild, 2, 4, NULL);
    mySetGroupSpacing(tbuild1, 20, 20);
    mySetGroupMargins(tbuild1, 20, 30);
    bnj=CheckBox(tbuild1, "N.J.", nj_act);
    bboot=CheckBox(tbuild1, "Boot.", boot_act);
    bmp=CheckBox(tbuild1, "M.P.", mp_act);
    bjumb=CheckBox(tbuild1, "Jumb.", jumb_act);
    bml=CheckBox(tbuild1, "M.L.", ml_act);
    repg=HiddenGroup(tbuild1, 2, 0, NULL);
    (void) StaticPrompt(repg, "nb. rep.", 0, dialogTextHeight, gros, 'l');
    rep_text=DialogText(repg, "", 4, NULL);
    shift(tbuild1, 20, 0);
    bdt=PushButton(tbuild1, "BUILD", bdt_act);
  }
  else{
    tbuild1=HiddenGroup(tbuild, -1, 3, NULL);
    mySetGroupSpacing(tbuild1, 20, 10);
    mySetGroupMargins(tbuild1, 20, 7);
    meth=HiddenGroup(tbuild1, 3, 0, NULL);
    mySetGroupSpacing(meth, 20, 0);
    choosemeth=HiddenGroup(meth, 0, 3, NULL);
    mySetGroupSpacing(choosemeth, 10, 10);

    shift(choosemeth, 30, 10);
    bnj=CheckBox(choosemeth, "NEIGHBOR  JOINING", nj_act);
    bmp=CheckBox(choosemeth, "MAX. PARSIMONY", mp_act);
    shift(choosemeth, 0, 2);
    bml=CheckBox(choosemeth, "MAX. LIKELIHOOD", ml_act);
    shift(meth, 0, -10);

    options=HiddenGroup(tbuild1, 3, 0, NULL);
    shift(options, 10, 10);
    bboot=CheckBox(options, "Bootstrap", boot_act);
    shift(options, 10, 0);
    bjumb=CheckBox(options, "Jumble", jumb_act);
    gdt=HiddenGroup(tbuild1, 2, -1, NULL);
    shift(gdt, 10, 28);
    bdt=PushButton(gdt, "MAKE  TREE", bdt_act);
    shift (gdt, 20, -20);
    repg=HiddenGroup(gdt, 2, -1, NULL);
    (void) StaticPrompt(repg, "replicates : ", 0, dialogTextHeight, gros, 'l');
    rep_text=DialogText(repg, "", 4, NULL);
  }

  shift(tbuild, 5, 10);
  tbuild2=HiddenGroup(tbuild, -1, 2, NULL);
  if(SMALLSCREEN){
    tbuild3=HiddenGroup(tbuild2, 2, 2, NULL);
    mySetGroupSpacing(tbuild3, 5, 5);
    shift(tbuild3, 40, 0);
  }
  else{
    tbuild3=HiddenGroup(tbuild2, 3, -1, NULL);
    mySetGroupSpacing(tbuild3, 5, 0);
  }
  inputtree=PushButton(tbuild3, SMALLSCREEN?"input":"input tree", treeload);
  if(SMALLSCREEN) (void) StaticPrompt(tbuild3, "", 0, dialogTextHeight, petit, 'l');
  evaltree=PushButton(tbuild3,  SMALLSCREEN?"eval.":"evaluate", evaltree_act);
  bdeltree=PushButton(tbuild3, SMALLSCREEN?" del.":"delete", bdeltree_act);
  shift(tbuild2, 0, 5);
  pbuild=createpanel(tbuild2, SMALLSCREEN?12:24, SMALLSCREEN?6:10,
        maigre, drawpanel, (BarScrlProc)vscroll, NULL, pbuild_callback, 0);
  SetPanelClick(pbuild, monolineclick, NULL, NULL, NULL);


  Disable(choosemeth);
  Disable(repg);
  Disable(bdt);
  Disable(bdeltree);
  Disable(evaltree);
  Disable(bmult);

  Show (w2);
#ifdef MOTIF
  /* ajout_icone_main(); */
  ajout_icone_tree();
#endif
  if (Visible(w))  { (void) Remove(w); w=NULL; }
  if (Visible(firstw))  { (void) Remove(firstw); firstw=NULL; }
  NOMAINWIN=FALSE;
  w=w2;

  w2=NULL;

}


/* firstwindow */
/* Create intro window firstw. */

void firstwindow(void){
  firstw=FixedWindow(-50, -33, (SMALLSCREEN?600:500)*screenwratio,
        400*screenhratio, "", quitmain_w);
  shift(firstw, SMALLSCREEN?75:155, 40);
  (void) StaticPrompt(firstw, " PHYLO_WIN ", 0, screenhratio*40, titlefont, 'c');
  shift(firstw, SMALLSCREEN?-10:-90, 20);
  (void) StaticPrompt(firstw, "A Graphic Tool for Phylogenetic Inference",
       0, screenhratio*20, titlefont, 'l');
  shift(firstw, SMALLSCREEN?45:115, 30);
  (void) StaticPrompt(firstw, "Version 1.1", 0, screenhratio*16, gros, 'c');
  shift(firstw, SMALLSCREEN?-25:-65, 20);
  (void) StaticPrompt(firstw, "Nicolas GALTIER and Manolo GOUY", 0, screenhratio*16, gros, 'c');
  shift(firstw, SMALLSCREEN?-30:-50, 0);
  (void) StaticPrompt(firstw, "Laboratoire de Biometrie, Genetique et Biologie des Populations",
        0, screenhratio*16, gros, 'c');
  shift(firstw, SMALLSCREEN?20:40, -10);
  (void) StaticPrompt(firstw, "UMR 5558 , Universite C. Bernard  LYON1", 0, screenhratio*16, gros, 'c');
  shift(firstw, SMALLSCREEN?-20:-50, 40);
  firstg=HiddenGroup(firstw, 3, 0, NULL);
  mySetGroupSpacing(firstg, 50, 0);
  mySetGroupMargins(firstg, 40, 0);
  firstloadb = PushButton(firstg, "Open", loadproc);
  firsthelpb = PushButton(firstg, "Help", (BtnActnProc)help_act);
  firstquitb = PushButton(firstg, "Quit", quitmain);
  Show(firstw);

#ifdef MOTIF
  /* ajout_icone_main(); */
  ajout_icone_tree();
#endif
}



/* controlc */

void controlc(void){
  if (currentKey=='c' && ctrlKey) exit(0);
}

#ifndef WIN_MAC
extern int argc;
extern char** argv;
#endif

#ifdef MOTIF
extern void *XmFontListCreate(XFontStruct * , char * );

static void Nlm_GetFontData (Nlm_FonT f, Nlm_FontData * fdata)

{
  Nlm_FntPtr  fp;

  if (f != NULL && fdata != NULL) {
    fp = (Nlm_FntPtr) Nlm_HandLock (f);
    *fdata = *fp;
    Nlm_HandUnlock (f);
  }
}
#endif


/* process_arguments */

void process_arguments(char* titlefont_s, int* titlefont_i,
   char* titlefont_c, char* gros_s, int* gros_i, char* gros_c,
   char* petit_s, int* petit_i, char* petit_c, char* gras_s,
   int* gras_i, char* gras_c, char* maigre_s, int* maigre_i,
   char* maigre_c, char* aagroupfname){
  
  int numarg=0;
  char* prov;
#ifdef MOTIF
  XFontStruct   *font;
  extern void *Nlm_XfontList;
  Nlm_FontData fontdata;
  void Nlm_GetFontData (Nlm_FonT f, Nlm_FontData * fdata);
#endif

 int DEFAULT_TITLEFONT_SIZE=12;
 char DEFAULT_TITLEFONT_POLICE='b';
 int DEFAULT_BIGFONT_SIZE=10;
 char DEFAULT_BIGFONT_POLICE='\0';
 int DEFAULT_SMALLFONT_SIZE=10;
 char  DEFAULT_SMALLFONT_POLICE='\0';
 int DEFAULT_SEQFONT_SIZE=10;

 if(!SMALLSCREEN){
 DEFAULT_TITLEFONT_SIZE=18;
 DEFAULT_TITLEFONT_POLICE='b';
 DEFAULT_BIGFONT_SIZE=14;
 DEFAULT_BIGFONT_POLICE='\0';
 DEFAULT_SMALLFONT_SIZE=12;
 DEFAULT_SMALLFONT_POLICE='\0';
 DEFAULT_SEQFONT_SIZE=14;
}

  if(SMALLSCREEN){
  /* default values */
  (void) sprintf(titlefont_s, "times");
      *titlefont_i=DEFAULT_TITLEFONT_SIZE;
      *titlefont_c=DEFAULT_TITLEFONT_POLICE;
  (void) sprintf(gros_s, "times"); *gros_i=DEFAULT_BIGFONT_SIZE; *gros_c=DEFAULT_BIGFONT_POLICE;
  (void) sprintf(petit_s, "times"); *petit_i=DEFAULT_SMALLFONT_SIZE; *petit_c=DEFAULT_SMALLFONT_POLICE;
  *gras_i=DEFAULT_SEQFONT_SIZE; *maigre_i=DEFAULT_SEQFONT_SIZE;

  /* constant values */
  (void) sprintf(gras_s, "courier"); *gras_c='b';
  (void) sprintf(maigre_s, "courier"); *maigre_c=0;
  }
  
  else{
  /* default values */
  (void) sprintf(titlefont_s, "times");
      *titlefont_i=DEFAULT_TITLEFONT_SIZE; *titlefont_c=DEFAULT_TITLEFONT_POLICE;
  (void) sprintf(gros_s, "times"); *gros_i=DEFAULT_BIGFONT_SIZE; *gros_c=DEFAULT_BIGFONT_POLICE;
  (void) sprintf(petit_s, "times"); *petit_i=DEFAULT_SMALLFONT_SIZE; *petit_c=DEFAULT_SMALLFONT_POLICE;
  *gras_i=DEFAULT_SEQFONT_SIZE; *maigre_i=DEFAULT_SEQFONT_SIZE;

  /* constant values */
  (void) sprintf(gras_s, "courier"); *gras_c='b';
  (void) sprintf(maigre_s, "courier"); *maigre_c=0;
  }
  
#ifdef WIN_MAC
return;
#endif

#if defined(UNIX) || defined(__VMS)

  while(++numarg<argc){
    if(strcmp(argv[numarg], "-systemfont")==0 ||
       strcmp(argv[numarg], "-SYSTEMFONT")==0){
      numarg++;
      if(numarg>=argc) goto error; 
      systemFont = ParseFont(argv[numarg]);
#ifdef MOTIF
      Nlm_GetFontData(Nlm_systemFont,&fontdata);
      font= (XFontStruct *)fontdata.handle;
      Nlm_XfontList = XmFontListCreate (font, "dummy");
#endif
      SelectFont(systemFont);
      stdCharWidth=MaxCharWidth();
      stdLineHeight=LineHeight();
      stdFontHeight=FontHeight();
      stdAscent=Ascent();
      stdDescent=Descent();
      stdLeading=Leading();
    }
    else if(strcmp(argv[numarg], "-titlefont")==0 ||
            strcmp(argv[numarg], "-TITLEFONT")==0){
      numarg++;
      if(numarg>=argc) goto error;
      (void) sprintf(titlefont_s, "%s", strtok(argv[numarg], ","));
      prov=strtok(NULL, ",");
      if(prov==NULL) goto error;
      (void) sscanf(prov, "%d", titlefont_i);
      prov=strtok(NULL, ",");
      if(prov) *titlefont_c=*prov;
   }
    else if(strcmp(argv[numarg], "-bigfont")==0 ||
            strcmp(argv[numarg], "-BIGFONT")==0){
      numarg++;
      if(numarg>=argc) goto error;
      (void) sprintf(gros_s, "%s", strtok(argv[numarg], ","));
      prov=strtok(NULL, ",");
      if(prov==NULL) goto error;
      (void) sscanf(prov, "%d", gros_i);
      prov=strtok(NULL, ",");
      if(prov) *gros_c=*prov;
    }
    else if(strcmp(argv[numarg], "-smallfont")==0 ||
            strcmp(argv[numarg], "-SMALLFONT")==0){
      numarg++;
      if(numarg>=argc) goto error;
      (void) sprintf(petit_s, "%s", strtok(argv[numarg], ","));
      prov=strtok(NULL, ",");
      if(prov==NULL) goto error;
      (void) sscanf(prov, "%d", petit_i);
      prov=strtok(NULL, ",");
      if(prov) *petit_c=*prov;
    }
    else if(strcmp(argv[numarg], "-seqfontsize")==0 ||
            strcmp(argv[numarg], "-SEQFONTSIZE")==0){
      numarg++;
      if(numarg>=argc) goto error;
      if(!isdigit(argv[numarg][0])) goto error;
      (void) sscanf(argv[numarg], "%d", gras_i);
      *maigre_i=*gras_i;
    }
    else if(strcmp(argv[numarg], "-aagroupfile")==0 ||
            strcmp(argv[numarg], "-aagroupfile")==0){
      numarg++;
      if(numarg>=argc) goto error;
      (void) sscanf(argv[numarg], "%s", aagroupfname);
    }
    else if(strcmp(argv[numarg], "-help")==0 ||
            strcmp(argv[numarg], "-HELP")==0 ||
            strcmp(argv[numarg], "-h")==0    ||
            strcmp(argv[numarg], "-H")==0  ) goto error;
    else{
      (void) sprintf(infile, "%s", argv[numarg]);
      return;
    }
  }
  return;

  error :
  (void) fprintf(stderr,"\nUsage of phylo_win arguments:\n\n");
  (void) fprintf(stderr,"phylo_win [-systemfont sysfontname] [-titlefont tfontname]\n");
  (void) fprintf(stderr,"[-bigfont bigfontname] [-smallfont smallfontname]\n");
  (void) fprintf(stderr,"[-seqfontsize fontsize] [-aagroupfile aagroupfilename]\n");
  (void) fprintf(stderr,"[filename] [-aagroupfile aagroupfilepath] [filename]\n\n");
  (void) fprintf(stderr,"Example of font names : times,12  helvetica,10,b (for 10-point bold)\n\n");
  (void) fprintf(stderr,"sysfontname is the font for buttons and menu items.\n");
  (void) fprintf(stderr,"tfontname is the font for box titles and introduction window.\n");
  (void) fprintf(stderr,"bigfontname and smallfontname are widely used : ");
  (void) fprintf(stderr,"tree display, messages, ...\n");
  (void) fprintf(stderr,"fontsize (integer) is the size of the courier font for sequences and names.\n\n");
  (void) fprintf(stderr,"aagroupfilename is the path leading to a file specifying aminoacid colors.\n\n");
  (void) fprintf(stderr,"filename is the name of the sequence file\n\n");
exit(0);

#endif
}




void bydefault_aagroups(void){
  int i;

  (void) sprintf(aalist, "EDQNHRKILMVAPSGTFYWC");
  for(i=0;i<7;i++) aagroup[i]=0;
  for(;i<11;i++) aagroup[i]=1;
  for(;i<16;i++) aagroup[i]=2;
  for(;i<18;i++) aagroup[i]=3;
  for(;i<20;i++) aagroup[i]=4;
}  





		/****************/
		/***** MAIN *****/
		/****************/


extern Nlm_Int2 Main(void){
int i, cpt, nb, *av_font, nbfont, titlefont_i, gros_i, petit_i, gras_i, maigre_i;
char titlefont_c, gros_c, petit_c, gras_c, maigre_c;
char font[30], titlefont_s[30], gros_s[30], petit_s[30], gras_s[30], maigre_s[30];
FILE *provf;
char aagroupfname[100], *line, *prov, *path;


#if defined(SOL) + defined(SGI) + defined(IBM) + defined(DEC)
  srand48(12345);
#endif


  infile[0]=0;
  helpfname[0]=0;
  aagroupfname[0]=0;

line=(char*)check_alloc(MAXLLINE, sizeof(char));

#ifdef WIN_MAC
  freopen("outfile", "w", stdout);
  freopen("errfile", "w", stderr);
#endif

  screenwratio=(double)(screenRect.right-screenRect.left)/(double)MYSCREENWIDTH;
  screenhratio=(double)(screenRect.bottom-screenRect.top)/(double)MYSCREENHEIGHT;

  if(screenwratio<0.95 || screenhratio<0.95)
    SMALLSCREEN=TRUE;
  else SMALLSCREEN=FALSE;
  
  if (SMALLSCREEN) {
    maxlines=12; minlines=8;
  }
  else {
    maxlines=32;
    minlines=12;
  }

	/* arguments */

  process_arguments(titlefont_s, &titlefont_i, &titlefont_c,
       gros_s, &gros_i, &gros_c, petit_s, &petit_i,
       &petit_c, gras_s, &gras_i, &gras_c, maigre_s,
       &maigre_i, &maigre_c, aagroupfname); 


	/* fonts */

#ifdef MOTIF

  av_font=get_avail_sizes(titlefont_s, TRUE, FALSE, &nbfont);
  (void) sprintf(font, "%s,%d,%c",
     titlefont_s, get_approx_size(av_font, titlefont_i, nbfont), titlefont_c);
  titlefont=ParseFont(font);

  av_font=get_avail_sizes(gros_s, FALSE, FALSE, &nbfont);
  (void) sprintf(font, "%s,%d,%c", gros_s, get_approx_size(av_font, gros_i, nbfont), gros_c);
  gros=ParseFont(font);

  av_font=get_avail_sizes(petit_s, FALSE, FALSE, &nbfont);
  (void) sprintf(font, "%s,%d,%c", petit_s, get_approx_size(av_font, petit_i, nbfont), petit_c);
  petit=ParseFont(font);

  av_font=get_avail_sizes(gras_s, TRUE, FALSE, &nbfont);
  (void) sprintf(font, "%s,%d,%c", gras_s, get_approx_size(av_font, gras_i, nbfont), gras_c);
  gras=ParseFont(font);

  av_font=get_avail_sizes(maigre_s, FALSE, FALSE, &nbfont);
  (void) sprintf(font, "%s,%d,%c", maigre_s, get_approx_size(av_font, maigre_i, nbfont), maigre_c);
  maigre=ParseFont(font);

#else
  
  (void) sprintf(font, "%s,%d,%c", titlefont_s, titlefont_i, titlefont_c);
  titlefont=ParseFont(font);

  (void) sprintf(font, "%s,%d,%c", gros_s, gros_i, gros_c);
  gros=ParseFont(font);

  (void) sprintf(font, "%s,%d,%c", petit_s, petit_i, petit_c);
  petit=ParseFont(font);

  (void) sprintf(font, "%s,%d,%c", gras_s, gras_i, gras_c);
  gras=ParseFont(font);

  (void) sprintf(font, "%s,%d,%c", maigre_s, maigre_i, maigre_c);
  maigre=ParseFont(font);
  
#endif

  SelectFont(maigre);
  SelectFont(gras);
  stdCharWidth=CharWidth('A');
  stdLineHeight=LineHeight();


	/* current directory */

#ifdef UNIX
  (void) sprintf(currentdir, "%s",getcwd(NULL, 1000*sizeof(char)));
#elseif defined(__VMS) /* force Unix style */
  (void) sprintf(currentdir, "%s",getcwd(NULL, 1000*sizeof(char)),0);
#else
  currentdir[0]=0;
#endif

  clusters[1] = (int *) check_alloc(MAXNSP, sizeof(int));
  clusters[2] = (int *) check_alloc(MAXNSP, sizeof(int));
  branchl[1] = (double *) check_alloc(MAXNSP, sizeof(double));
  branchl[2] = (double *) check_alloc(MAXNSP, sizeof(double));
  for(i=0;i<MAXNSP;i++) s[i]=NULL;
  av=NULL; kkill=NULL;
  gc=NULL;
  for(i=0;i<20;i++) topaint[i]=NULL;
  for(i=0;i<MAXSPSET;i++) oldspecset[i]=NULL;
  for(i=0;i<MAXSPSET;i++) specsetname[i]=NULL;
  for(i=0;i<MAXSITESET;i++) sitesetname[i]=NULL;
  
  for(i=0;i<MAXTREEW;i++) openedtreew[i]=FALSE;


	/* colors */

#ifdef WIN_MAC
  LtGray(); fonduns_col=GetColor(); 
  SelectColor(127, 128, 128); fondsel_col=GetColor(); 
#else
  SelectColor(190, 190, 190); fonduns_col=GetColor(); 
  SelectColor(160, 160, 160); fondsel_col=GetColor(); 
#endif

  Red(); cola=GetColor(); col1=GetColor(); 
  Green(); colc=GetColor(); col2=GetColor();
  Yellow(); colg=GetColor(); col3=GetColor();
  Blue(); colt=GetColor(); col4=GetColor();
  White(); coln=GetColor();
  Magenta(); col5=GetColor();

	/* aminoacid groups */

  for(i=0;i<30;i++){
    aalist[i]=0;
    aagroup[i]=-1;
  }

#ifdef UNIX
  if(aagroupfname[0]==0){
    char default_aafile[500];
    (void) sprintf(default_aafile, "%s/phylo_win.aacolors", getenv("HOME"));
    (void) sprintf(aagroupfname, "%s", default_aafile);
  }
#endif
#ifdef __VMS
  if(aagroupfname[0]==0){
    char default_aafile[500];
    (void) sprintf(default_aafile, "SYS$LOGIN:phylo_win.aacolors");
    (void) sprintf(aagroupfname, "%s", default_aafile);
  }
#endif


  provf=fopen(aagroupfname, "r");
  if(provf==NULL){  /* by defaults aminoacid colors */
    bydefault_aagroups();
    nbaagroup=5;
  }
  else{  /* aminoacid colors read in a file */
    while(fgets(line, MAXLLINE, provf)){
      while(*line==' ' || *line=='\n' || *line=='\t') line++;
      if(*line){
	cpt=-1; i=nb=0;
	prov=strtok(line, ",\n");
	while(prov){
	  if(++cpt>=MAXAAGROUP){ 
	    (void) printf(
 "Too many aminoacid groups in file %s (max : %d) : by-default colors used\n",
               MAXAAGROUP, aagroupfname); 
	    bydefault_aagroups();
	    break; 
	  }
	  (void) strcat(aalist, prov);
	  nb+=(int)strlen(prov);
	  for(;i<nb;i++) aagroup[i]=cpt;
	  line=NULL;

	  prov=strtok(line, ",\n");
	}
	nbaagroup=cpt+1;
      }
    }
    (void) fclose(provf);
    completeaalist();
  }


	/* help file */

#ifdef UNIX
  path=(char*)check_alloc(5000, sizeof(char));
  (void) sprintf(path,"%s", getenv("PATH"));
  
  while(prov=strtok(path, ":")){
    (void) sprintf(helpfname, "%s/phylo_win.help", prov);
    provf=fopen(helpfname, "r");
    if(provf){
      (void) fclose(provf);
      break;
    }
    helpfname[0]=0;
    path=NULL;
  }
#endif
#ifdef __VMS
    (void) sprintf(helpfname, "PHYLO_WIN_DIR:phylo_win.help");
    provf=fopen(helpfname, "r");
    if(provf){
      (void) fclose(provf);
    }
    else {
      helpfname[0]=0;
    }
#endif


  Black();

  if (infile[0]) {
    loadpanels();
  }
  else{
    firstwindow();
  }

  free(line);
  ProcessEvents ();
  return(0);

}

