
/* #define WIN_MAC */ 	/* must be uncommented for MacIntosh machines */


#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>

#include <vibrant.h>

#undef Boolean 
#ifdef MOTIF
#define WIN_X
#include <ncbiport.h>
#endif

#define Handle Nlm_Handle 
/* needed because ncbiport undefines all nlm types! */

#ifdef MOTIF
#ifdef __VMS
#pragma environment save
#include <X11/Intrinsic.h>
#pragma environment restore
#pragma __standard
#else /* __VMS */
#include <X11/Intrinsic.h>
#endif /* __VMS */
extern XtAppContext Nlm_appContext;
#endif

#define MAXLSEQ 10000  	/* max length of sequences */
#define MAXNSP 500   	/* max number of sequences */
#define MAXSITESET 50 	/* max number of site sets */
#define MAXSPSET 50   	/* max number of specie sets */
#define MAXREG 100      /* max number of regions in a site set */
#define MAXTREE 100    	/* max number of stored trees */
#define MAXTREEW 10	/* max number of opened tree windows */
#define MAXBOOT 200000  /* max number of stored bootstrap branches */
#define MAXLNAME 20	/* max length of species and tree names */
#define MAXLLINE 10000 	/* max length of lines in input file */
#define MAXLCOM 5000  	/* max length of comments in input file */
#define MAXLHEAD 1000	/* max length of tree header */
#define MAXHELP 5000	/* max number of characters in help topics */ 
#define MAXHELPW 20	/* max number of opened help windows */
#define MAXAAGROUP 5	/* max number of aminoacid distinct colors */

#define MYSCREENWIDTH 1152
#define MYSCREENHEIGHT 900

#define lmot (8*sizeof(int))
#define acnucspeed 7.6e5



			/**************************/
			/*****	DECLARATIONS  *****/
			/**************************/




		/********* STRUCTURES *********/


typedef struct noeud2{
	double l1, l2, l3;		/* actual branch lengths */
	double ml1, ml2, ml3;		/* modified branch lengths */
	double b1, b2, b3;		/* bootstrap values */
	char* nom;			/* name */
	int ord;			/* vertical coord. (pixels) */
	int absc;			/* horizontal coord. */
	int depth;
        int selected;
	int color;			
/*DRM, rearranged to avoid padding for proper alignment of data*/
	struct noeud2 *v1, *v2, *v3;	/* neighbors */
} *noeud;


typedef struct sbranche{
	noeud bout1;
	noeud bout2;
	double length;
	double bootstrap;
} *branche;


typedef struct printdata {
	char **lignes; /* tableau des lignes contenues */
	PnlActnProc callback;
	FonT font;
	int nbr_lignes; /* nbre lignes visibles from 1 */
	int nbr_cols;  /* nbre de col visibles from 1 */
	int tot_lignes; /* nbre de lignes contenues from 0 */
	int prem_ligne;  /* premiere ligne vue, from 0 */
	int* selected;  /* selected[i]=1 si ligne (colonne) i selectionnee, 
                        0 sinon */
	int lineheight, charwidth, ascent;
	BaR  vertical;
        BaR  horizontal;
	int prem_col; /* utile pour pseq seulement */
	int tot_cols; /* utile pour pseq seulement */
	int nbsel; /* nb of selected lines (cols) */
	} printdata;


typedef struct drawtreedata {
	noeud* s_tree; /* tree to draw */
	int nb;    /* number of species */
	int width;   /* pixels */
	int height;  /* pixels */
	int winwidth;
	int winheight;
	int scale; /* number of pixels for branch length 1 */
	char* header; /* tree comments */
	FonT font;  
	Boolean branchlength;  /* write branch length */ 
	Boolean bootstrap;  /* write bootstrap values */
	Boolean pseudo;  /* compute pseudo branch lengths (MP) */
	Boolean bootok;  /* this tree was reconstructed with bootstrap */
	Boolean squarenode;  /* draw full squares at each node */
	Boolean squarebranch;  /* draw full squares on each branch */
	Boolean squareintbranch;  /* square internal branches only */
	Boolean nonegativebranch; /* draw branches with length<0 left->right */
	int indice;
	int** bootptr;	/* pointer to bootstrap trees */
	int llist1, llist2;
	char *list1[MAXNSP], *list2[MAXNSP];
	int nbrep;
        char *treename[MAXNSP];
	double sce, tot;
	
} drawtreedata;



		/********* FUNCTIONS **********/


/* objects creating function */

void putobjects(int nbl);


/* panel display functions */

PaneL 	createpanel(GrouP group, int larg, int haut,
  FonT fonte, PnlActnProc drawfct, BarScrlProc vscrollfct,
    BarScrlProc hscrollfct, PnlActnProc callback, int rabl);
void 	settotlignes(PaneL panel,int total);
void 	settotlignes_head2(PaneL panel,int total);
void 	settotcols(PaneL panel,int total);
void 	initpanel(PaneL p, char** text, int nblignes, int nbsel, int* sel);
void 	initseqpanel(PaneL p, char** text, int nblignes,
    int nbcol, int nbsel, int* sel);


/* graphic functions */

void 	drawpanel (PaneL p);
void 	drawnamepanel (PaneL p);
void 	drawseqpanel (PaneL p);
void 	ptreedraw(PaneL p);
void 	drawsubtree(noeud comesfrom, noeud node, PoinT pt,
          int width, int scale, Boolean bl, Boolean bs,
          Boolean sn, Boolean sb, Boolean sib, Boolean noneg);
void drawtree(noeud* s_arbre, int nb, char* header,
          Boolean bl, Boolean bs, Boolean comb, Boolean noneg,
          double sce, double tot, int** bootptr, int bootok,
          int nbrep, char** treename, char* name);
void 	draw(PaneL p);
void 	boldstring(PoinT pt, char *texte, Boolean bold);
void 	linepaint(char* ligne, PoinT pt, int lg);
void 	dnacolpaint (int num, RecT rect);
void 	protcolpaint (int num, RecT rect);
void 	setblockbounds();


/* mouse functions */

void 	monolineclick(PaneL panel, PoinT pt);
void 	shiftlineclick(PaneL panel, PoinT pt);
void 	pnameclick(PaneL panel, PoinT pt);
void 	pnamerelease(PaneL panel, PoinT pt);
void 	pseqclick(PaneL panel, PoinT pt);
void 	pseqrelease(PaneL panel, PoinT pt);
void 	pnamemove(PaneL panel, PoinT pt);
void 	movelines(int num1, int num2);
void 	ptreeswap(PaneL p, PoinT pt);
void 	ptreesub(PaneL p, PoinT pt);
void 	ptreenew(PaneL p, PoinT pt);



/* scroll functions */

void 	hscroll(BaR bar, SlatE slate, int newval, int oldval);
void 	hscrollpseq(BaR bar, SlatE useless, int newval, int oldval);
void 	vscroll(BaR bar, SlatE slate, int newval, int oldval);
void 	vscroll_head2(BaR bar, SlatE slate, int newval, int oldval);
void 	vscrollpname(BaR bar, SlatE useless, int newval, int oldval);


/* input-output functions */

void 	process_arguments(char* titlefont_s, int* titlefont_i,
            char* titlefont_c, char* gros_s, int* gros_i, char* gros_c,
            char* petit_s, int* petit_i, char* petit_c, char* gras_s,
            int* gras_i, char* gras_c, char* maigre_s, int* maigre_i,
            char* maigre_c, char* aagroupfname);
void 	firstwindow();
void 	createloadbox();
void 	createsavebox();
void 	loadpanels();
void 	loadmenuload();
void 	writeout(ButtoN but);
void 	createmlmessbox(char* texte, int showtreebut);
void 	createmessbox(char* texte, Boolean dialog, BtnActnProc okfct,
                      BtnActnProc canfct);
int 	fileread(FILE* input, char** seq, char** seqname, char** comments,
                int*  nb_site_set, int** site_set, char** site_set_name,
                int* nb_spec_set, int** spec_set, char** spec_set_name,
                int* nbtree, char** treenom, char** tree, char* format,
                char* err_mess);
int 	paupread(FILE* input, char** seq, char** seqname, int* nbtree,
                 char** treenom, char** tree);
int 	clustread(FILE* in, char **seq, char **seqname, char* err_mess);
int 	fastaread(FILE* input, char** seq, char** seqname, char* err_mess);
int 	phylipread(FILE* input, char** seq, char** seqname, char* err_mess);
int 	maseread(FILE* input, char** seq, char** seqname, char** comments,
              int*  nb_site_set, int** site_set, char** site_set_name,
              int* nb_spec_set, int** spec_set, char** spec_set_name,
              int* nbtree, char** treename, char** tree, char* err_mess);
int 	checknames(int nb, char** seqname, char* err_mess);
int 	maseprint(FILE* output, char** seq, char** seqname, char** comments,
              int notu, int nb_site_set, int** site_set, char** site_set_name,
              int nb_spec_set, int** spec_set, char** spec_set_name, int nbtree,
              char** treename, char** tree);
void 	treeload(ButtoN but);


/* callbacks */

void 	pname_callback(PaneL p);
void 	pseq_callback(PaneL p);
void 	pspecies_callback(PaneL p);
void 	psites_callback(PaneL p);
void 	pbuild_callback(PaneL p);
void 	load_callback(PaneL p);

void 	dist_act(ChoicE c);
void 	treemod_act(GrouP gr);

void 	sp_sel_act(ButtoN but);
void 	si_sel_act(ButtoN but);
void 	sp_unsel_act(ButtoN but);
void 	si_unsel_act(ButtoN but);
void 	sp_add_act(ButtoN but);
void 	si_add_act(ButtoN but);
void 	sp_del_act(ButtoN but);
void 	si_del_act(ButtoN but);
void 	nj_act(ButtoN b);
void 	mp_act(ButtoN b);
void 	ml_act(ButtoN b);
void 	boot_act(ButtoN b);
void 	jumb_act(ButtoN b);
void 	mult_act(ButtoN b);
void 	bdt_act(ButtoN but);
void 	bdeltree_act(ButtoN but);
void 	evaltree_act(ButtoN but);
void 	store_act(ButtoN but);
void 	quiterr (ButtoN but);
void 	quitwin (ButtoN but);
void 	quitstorewin(ButtoN but);
void 	quitsavetwin (ButtoN but);
void 	renok_act(ButtoN but);
void 	renquit(ButtoN but);
void 	moveok_act(ButtoN but);
void 	movecan_act(ButtoN but);
void 	nucseqload(ButtoN but);
void 	loadok_act (ButtoN but);
void 	saveok_act(ButtoN but);
void 	loadproc(ButtoN but);
void 	saveproc(ButtoN but);
void 	quitmain (ButtoN but);
void 	canceldt (ButtoN but);
void 	bl_act(ButtoN but);
void 	bs_act(ButtoN but);
void 	storetree(ButtoN but);
void 	writeouttree(ButtoN but);
void 	create_act(ButtoN but);
void 	interrupt_act(ButtoN b);
void 	inputtree_act(ButtoN but);
void 	mlshowtree(ButtoN but);
void 	quitml(ButtoN but);

void 	rename_act(IteM it);
void 	remove_act(IteM it);
void 	move_act(IteM it);
void 	ncode_act(IteM it);
void 	mcode_act(IteM it);

void 	loadtext_act(TexT t);



/* misc vibrant functions */

int 	sitesetlength(int* siteset);
void 	setreptext(int nbsel);
void 	setnbsel(PaneL p, int totsel, int nbsel);
void 	change_blbutton(int i);
void 	change_bsbutton(int i);
void 	enablebuttons();
void 	setbdt();
void 	setgc();
void 	removeseq();
void 	controlc();
void 	shift(Handle a, int dx, int dy);
void 	mySetGroupSpacing(GrouP gr, int x, int y);
void 	mySetGroupMargins(GrouP gr, int x, int y);
int 	get_approx_size(int *avail_sizes, int desired, int totavail);
int*	get_avail_sizes(char *fontname, Boolean bold, Boolean italic,
            int *totsizes);


/* tree using functions */

void    bit1(int *plist, int num);
void    bit0(int *plist, int num);
void    ou(int *listou, int *list1, int *list2, int len);
void 	et(int *listet, int *list1, int *list2, int len);
void 	non(int *listnon, int *list, int len);
int 	testbit(int *plist, int num);
int     memebranche(int* list1, int* list2, int nbints, int nbbits);
noeud 	create_node(noeud v1, noeud v2, noeud v3, double l1, double l2,
            double l3, double b1, double b2, double b3, char* nom);
noeud 	bottomnode(noeud nd);
Boolean equallist(noeud from, noeud nd, int nb, char** list);
char*   ctreewrite(noeud comesfrom, noeud node, char* ctree);
int     tree_ttos(int** arbre_t, int notu, double* lgbi, double* lgbp,
             double* bootval, char** nom,  noeud* arbre_s);
int     tree_btos(int** arbre_t, int notu, double* lgbi, double* lgbp,
             double* bootval, char** nom,  noeud* arbre_s);
void 	tree_stoc(noeud* arbre_s, int racine, int notu, char* ctree);
int     tree_ctot(char *input, int **arbre, double *lgbi, double *lgbp,
             double* bootstrap, char **nom, char *racine);
void 	tree_tton(int** tarbre, int notu, double* ntree);
int 	tree_ctob(char *carbre, char *nom[], int *barbre[]);
int 	nj(double** d, int** clusters, double** branchl, int notu);
int 	nj_in_out(double** dist, char** nomotu, int notu, char* ctree,
             double* ntree);
void 	ctree_nobl(char* in, char* out, int lgin);
void 	ctree_noblbs(char* in, char* out, int lgin);
void 	ctree_root(char* ctree);
void 	addquotes(char** ctree_ptr);
int 	ttree_egal(int** tree1, int** tree2, int notu, char* nature);
int 	ctree_egal(char* ctree1, char* ctree2, int nb);
int 	rooted(char* carbre);
int 	unroot_c(char* carbre);
int 	addexaequo(char* old, char* toadd, int nb);
Boolean treeend(char* line);
int 	unroot(int** treer, int notu, double* lgbi, double* lgbp,
              double* bootvals, char** nom, char** list1,
              char** list2, int* l1, int* l2); 
double 	max_length_down(noeud comesfrom, noeud node);
double 	av_length_down(noeud pere, noeud racine);
int 	nb_leaves_down(noeud comesfrom, noeud node);
branche untilsup(noeud comesfrom, noeud centre, double lg);
branche central_branch(noeud* arbre_s, int notu);
int 	depth (noeud comesfrom, noeud node);
void 	pseudo(noeud comesfrom, noeud node, double d);
noeud 	abs_ord(noeud comesfrom, noeud node, int x, int y);
branche abs_ord_br(noeud comesfrom, noeud node, int x, int y, int scale);
noeud abs_ord_name(noeud comesfrom, noeud node, int x, int y, int scale);
void 	stree_root(noeud* stree, branche br, int bl);
Boolean parent_node(noeud nd, noeud neighbor, int i);
int 	vert_coord(noeud comesfrom, noeud node, int nb, int top, int height);
Boolean compatible(int* b1, int* b2, int nb);
int* 	bilist_sort(int** b, int* bootval, int nb, int total);


/* distance computing functions */

double 	od(char* seq1, char* seq2);
double 	jc(char* seq1, char* seq2);
double 	kim2p(char* seq1, char* seq2);
double 	tn(char* seq1, char* seq2);
double 	lQ(char* seq1, char* seq2);
double 	gg95(char* seq1, char* seq2, double a);
double 	logdet(char* seq1, char* seq2, double** mat);
double 	alsurbet_kim(char* seq1, char* seq2);
int 	freq_obs(char* seq1, char* seq2, double* freq);
double 	po(char* seq1, char* seq2);
void 	loadrl();
int 	computekaks();
int 	compute_dist(char** treeseq, int nb, int lg, double** d, char* header);


/* misc non-vibrant functions */

void*	check_alloc(int nbrelt, int sizelt);
char*	check_ralloc(void* ptr, int nbelt, int sizelt);
double 	expby5sec(void);
int 	mini(int a, int b);
int 	maxi(int a, int b);
double 	mind(double a, double b);
double 	maxd(double a, double b);
int 	fact(int n);
int 	has1_n(int n);
double*	vector(long nl, long nh);
void 	free_vector(double *v, long nl, long nh);
int 	ludcmp(double **a, int n, int *indx, double *d);
void 	lubksb(double **a, int n, int *indx, double b[]);
int 	matmat(double** m1, int nbl1, int nbc1, double** m2, int nbl2,
             int nbc2, double** prod);
double* matvect(double** m1, int nbl1, int nbc1, double* v2, int nbl2);
double* vectmat(double* v1, int nbc1, double** m2, int nbl2, int nbc2);
int 	invmat(double** mat, int n, double** invmat);
double*	lslgbr(int** btree, int n, double** dist, double* sce,
              double* totallength);
void 	insertint(char* chaine, long n);
int 	aaclass(char c);
int 	alphalength(char* seq);
char 	nextalpha(char** seqptr);
char*	invtradseq (char*seqprot, char* seqdna);
void 	refresh(char** seq, int nbseq, int option, int prot);
void 	jumble_fct(char** seq, char** name, int notu);
Boolean samename(char* name1, char* name2);
int 	basecomp(char* seq, double* comp);
int 	aacomp(char* seq, double* comp, double* compgroup);
int 	variable(char** seq, int nb);
int 	informative(char** seq, int nb);
void 	bydefault_aagroups();
void	reg_and_pos(int* selected, int* regions);


void 	pars(char** seq, char** seqname, int notu, char* treefile,
           double* steps, char* toevaluate);
void 	prot(char** seq, char** seqname, int notu, char* treefile,
           double* steps, char* toevaluate);
char* 	ml(char** seq, char** seqname, int notu, char* treestrnew,
           double* likel, char* toevaluate, char* err_mess);
void 	prefastlwl(double **rl, double **tl0, double **tl1,
           double **tl2, double **tti0, double **tti1, double **tti2,
           double **ttv0, double **ttv1, double **ttv2);
int 	fastlwl(char **seq, int nbseq, int lgseq, double **ka,
           double **ks, double **tti0, double **tti1, double **tti2,
           double **ttv0, double **ttv1, double **ttv2, double **tl0,
           double **tl1, double **tl2, double **vka, double **vks,
           int* sat1, int* sat2);

void ajout_icone(void);
void ajout_icone_tree(void);
