/*** analog 3.11 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

/*** alias.c; functions to cope with aliasing. ***/

#include "analhea2.h"

choice do_alias(char *name, Memman *mp, Alias *aliashead, 
		char *dirsuffix, unsigned int dirsufflength, choice type) {
  /* return ERR for corrupt/unwanted, else whether any alias done */
  extern char *workspace;
  logical rc = TRUE;
  size_t len;

  /* workspace has size BLOCKSIZE: we just assume that this is big enough.
     This is unsafe in principle, but a.s. good enough in practice. */
  (void)strcpy(workspace, name);

  if (type == ITEM_FILE)
    rc = do_aliasr(workspace, dirsuffix, dirsufflength);
  else if (type == ITEM_HOST)
    rc = do_aliasS(workspace);
  else if (type == ITEM_REFERRER)
    rc = do_aliasf(workspace);
  else if (type == ITEM_BROWSER)
    rc = do_aliasb(workspace);
  else if (type == ITEM_VHOST)
    rc = do_aliasv(workspace);
  /* USER currently doesn't have any fixed aliases */
  if (rc == FALSE)
    return(ERR);

  do_aliasx(workspace, aliashead);

  if (!STREQ(workspace, name)) {
    len = strlen(workspace);
    (void)memcpy((void *)submalloc(mp, len + 1), (void *)workspace, len);
    *((char *)(mp -> curr_pos) + len) = '\0';
    return(TRUE);
  }
  else
    return(FALSE);
}

void do_aliasx(char *name, Alias *aliashead) {
  Alias *ap;
  logical done = FALSE;

  for (ap = aliashead; ap != NULL && !done; TO_NEXT(ap)) {
    if (wildmatch(name, ap -> from)) {
      done = TRUE;
      wildalias(name, ap -> from, ap -> to);
    }
  }
}

logical do_aliasr(char *name,  char *dirsuffix, unsigned int dirsufflength) {
#ifdef EBCDIC
  extern unsigned char os_toebcdic[];
#endif
  char *c = name, *d, *e1, *e2;
  unsigned int tempint = 0;

  /* First, change %7E to ~, etc. */
  while((c = strchr(c, '%')) != NULL) {
    (void)sscanf(c + 1, "%2x", &tempint);
    if (tempint >= 0x20 && tempint < 0x7F) {
#ifdef EBCDIC
      tempint = os_toebcdic[tempint];
#endif
      *c = tempint;
      (void)memmove((void *)(c + 1), (void *)(c + 3), strlen(c + 3) + 1);
    }
    c++;
  }

  /* Secondly, if it ends with DIRSUFFIX (typically index.html), strip it */

  e1 = strchr(name, '\0');
  if ((e2 = strchr(name, '?')) != NULL)
    *e2 = '\0';
  else
    e2 = e1;
  if (dirsufflength > 0 && dirsufflength < (unsigned int)(e2 - name) &&
      *(e2 - dirsufflength - 1) == '/' &&
      STREQ(e2 - dirsufflength, dirsuffix)) {
    (void)memcpy((void *)(e2 - dirsufflength), (void *)e2,
		 (size_t)(e1 - e2) + 1);
    if (e2 != e1)
      e2 -= dirsufflength;
  }
  if (e2 != e1)
    *e2 = '?';

  /* Thirdly, // -> /  ;  /./ -> /  ;  /spam/../ -> /  */
  /* NB Used to use 3 strstr()s. But that is much slower. */

  c = name;
  while ((c = strchr(c, '/')) != NULL && c < e2) {
    if (*(c + 1) == '/') {
      if (*(c - 1) == ':' && c != name)
	c++;   /* Don't translate http:// ; just skip to next /  */
      else
	(void)memmove((void *)(c + 1), (void *)(c + 2), strlen(c + 2) + 1);
    }
    else if (*(c + 1) == '.') {
      if (*(c + 2) == '/')
	(void)memmove((void *)(c + 1), (void *)(c + 3), strlen(c + 3) + 1);
      else if (*(c + 2) == '.' && *(c + 3) == '/') {
	d = c + 4;
	/* go back to prev slash (but not past // or start of name) */
	if (c != name && *(c - 1) != '/') {
	  while (*(--c) != '/' && c != name)
	    ;
	}
	(void)memmove((void *)(c + 1), (void *)d, strlen(d) + 1);
	if (c == name)
	  *c = '/';
      }
      else
	c++;
    }
    else
      c++;
  }

  return(TRUE);
}

logical do_aliasS(char *name) {
#ifndef NODNS
  extern choice dnslevel;
#endif

  char *c;
  int len;

  len = (int)strlen(name) - 1;  /* NB offset by 1 */

  /* DNS lookup */

#ifndef NODNS
  if (dnslevel != DNS_NONE && isdigit(name[len])) {
    do_dns(name, NULL, dnslevel);
    len = (int)strlen(name) - 1;
  }
#endif

  /* remove trailing dot */

  if (name[len] == '.')
    name[len] = '\0';

  /* convert to lower case */

  for (c = name + len; c >= name; c--)
    *c = tolower(*c);

  return(TRUE);
}

logical do_aliasf(char *name) {
  int defaultport = UNSET;
  char *c, *d;
  unsigned int tempint = 0;

  /* First, strip off #'s */
  if ((c = strchr(name, '#')) != NULL)
    *c = '\0';

  /* Next, change %7E to ~, etc. */
  c = name;
  while((c = strchr(c, '%')) != NULL) {
    (void)sscanf(c + 1, "%2x", &tempint);
    if (tempint >= 0x20 && tempint < 0x7F) {
      *c = tempint;
      (void)memmove((void *)(c + 1), (void *)(c + 3), strlen(c + 3) + 1);
    }
    c++;
  }

  /* Coerce method to lower case */
  for (c = name; *c != ':' && *c != '\0'; c++)
    *c = tolower(*c);
  if (*c != ':')
    return(FALSE);

  /* find out what sort of URL it is */
  *c = '\0';  /* *c was already set to the first colon */

  if (STREQ(name, "http"))
    defaultport = 80;
  else if (STREQ(name, "ftp"))
    defaultport = 21;
  else if (STREQ(name, "file"))
    return(FALSE);  /* don't count file: URL's */
  else if (STREQ(name, "news"))
    defaultport = 0;
  else if (STREQ(name, "gopher"))
    defaultport = 70;
  else if (STREQ(name, "telnet"))
    defaultport = 23;
  else if (STREQ(name, "wais"))
    defaultport = 210;
  else if (STREQ(name, "nntp"))
    defaultport = 119;
  else if (STREQ(name, "prospero"))
    defaultport = 1525;
  else if (STREQ(name, "mailto"))
    defaultport = 0;
  *c = ':';

  /* If "news:" or "mailto:" or unknown, that's all we do.
     Otherwise, check it has the // next and coerce hostname to lower case */

  if (defaultport > 0) {
    if (*(c + 1) != '/' || *(c + 2) != '/')
      return(FALSE);
    else for (c += 3; *c != '/' && *c != ':' && *c != '\0'; c++)
      *c = tolower(*c);

    /* strip trailing .'s from hostname */

    for (d = c - 1; *d == '.'; d--)
      ;  /* run back to before any dots */
    if (d != c - 1) {
      (void)memmove((void *)(d + 1), (void *)c, strlen(c) + 1);
      c = d + 1;
    }

    /* strip leading 0s from port numbers and cross out default port numbers */

    if (*c == ':') {
      for (d = c + 1; *d == '0'; d++)
	;  /* run forward to after any 0's */
      if (d != c + 1)
	(void)memmove((void *)(c + 1), (void *)d, strlen(d) + 1);

      if (defaultport == atoi(c + 1)) {
	/* run forward to after all digits */
	for (d = c + 2; isdigit(*d); d++)
	  ;
	(void)memmove((void *)c, (void *)d, strlen(d) + 1);
      }
    }
    
    /* We don't want to change /./ -> / etc. even in http protocol, because we
       don't want to make assumptions about other people's file systems. */
    /* So finally, trailing slash if no directory name given */

    for ( ; *c != '/' && *c != '\0'; c++)
      ;   /* run to next slash or end of string */
    if (*c == '\0') {
      *c = '/';
      *(c + 1) = '\0';
    }
  }

  return(TRUE);
}

logical do_aliasb(char *name) {
  char *c;

  /* cut (illegal) "via"s (e.g., via certain proxy or cache) */
  if ((c = strstr(name, " via ")) != NULL)
    *c = '\0';

  /* cut trailing spaces */
  for (c = name + strlen(name) - 1; *c == ' ' && c > name; c--)
    *c = '\0';
  if (c == name)
    return(FALSE);

  return(TRUE);
}

logical do_aliasv(char *name) {

  for ( ; *name != '\0'; name++)
    *name = tolower(*name);

  return(TRUE);
}

#ifndef NODNS
logical dnsresolve(char *name, choice level) {
  logical done = FALSE;
#ifndef MAC
  unsigned long addr;
  const char *addrp;
  struct hostent *tempp;
#endif

  if (level < DNS_LOOKUP)
    return(FALSE);
  debug('D', "Looking up %s:", name);
#ifdef MAC
  done = IpAddr2Name(name);
#else
  addr = inet_addr(name);
  if (addr != INET_ADDR_ERR) {
    addrp = (char *) &addr;
    tempp = gethostbyaddr(addrp, sizeof(struct in_addr), AF_INET);
    if (tempp != NULL && tempp -> h_name[0] != '\0') {
      (void)strcpy(name, tempp -> h_name);
      done = TRUE;
    }
  }
#endif
  if (done)
    debug('D', "  resolved to %s", name);
  else
    debug('D', "  can't resolve");
  return(done);
}

void do_dns(char *name, char *alias, choice level) {
  /* This is simplified from hashfind(). Can change name if alias == NULL. */
  extern Hashtable *dnstable;
  extern timecode_t starttimec;
  extern FILE *dnsfilep;
  extern Memman *xmemman;

  Hashindex *lp, *lastlp;
  unsigned long magic;
  logical done = FALSE;

  if (TOO_FULL(dnstable -> n, dnstable -> size))
   dnstable = rehash(dnstable, NEW_SIZE(dnstable -> size), NULL);
  MAGICNO(magic, name, dnstable -> size);

  lp = dnstable -> head[magic];
  lastlp = NULL;

  while (!done) {
    if (lp == NULL) {  /* need a new index entry */
      lp = (Hashindex *)submalloc(xmemman, sizeof(Hashindex));
      if (lastlp == NULL)
	dnstable -> head[magic] = lp;
      else
	lastlp -> next = lp;
      lp -> name = (char *)submalloc(xmemman, strlen(name) + 1);
      (void)strcpy(lp -> name, name);   /* NB don't use lp -> own */
      if (alias != NULL) {   /* initial build */
	if (STREQ(alias, "*"))
	  lp -> other = NULL;
	else {
	  lp -> other = submalloc(xmemman, strlen(alias) + 1);
	  (void)strcpy((char *)(lp -> other), alias);
	}
      }
      else if (dnsresolve(name, level)) {  /* potentially changes name */
	lp -> other = submalloc(xmemman, strlen(name) + 1);
	(void)strcpy((char *)(lp -> other), name);
	if (dnsfilep != NULL) {
	  (void)fprintf(dnsfilep, "%ld %s %s\n", starttimec, lp -> name, name);
	  (void)fflush(dnsfilep);
	}
      }
      else {
	lp -> other = NULL;
	if (dnsfilep != NULL) {
	  (void)fprintf(dnsfilep, "%ld %s *\n", starttimec, lp -> name);
	  (void)fflush(dnsfilep);
	}
      }
      lp -> next = NULL;
      (dnstable -> n)++;
      done = TRUE;
    }
    else if (STREQ(lp -> name, name)) {
      if (alias != NULL) {   /* initial build: overwrite */
	if (STREQ(alias, "*"))
	  lp -> other = NULL;
	else {
	  lp -> other = submalloc(xmemman, strlen(alias) + 1);
	  (void)strcpy((char *)(lp -> other), alias);
	}
      }
      else if (lp -> other != NULL)
	(void)strcpy(name, (char *)(lp -> other));
      done = TRUE;
    }
    else {
      lastlp = lp;
      TO_NEXT(lp);
    }
  }
}
#endif

void wildalias(char *name, char *from, char *to) {
  char *s, *t, *u;
  unsigned int len;
  /* Assume that from contains at most one * unless to contains none, that
     name wildmatches from, and that name is big enough to contain the result
     AFTER the orig name.
     [strlen(name) + strlen(to) - strlen(from) + 2 extra is always enough] */
  if ((u = strchr(to, '*')) == NULL || strchr(from, '*') == NULL)
    (void)strcpy(name, to);
  else {
    s = name + strlen(name);  /* will put answer here */
    len = strchr(from, '*') - from;  /* length of bit before * */
    t = name + len;  /* so bit represented by * is here */
    len = (strlen(name) + 1) - strlen(from);  /* length of that bit */
    (void)memcpy((void *)s, (void *)to, (size_t)(u - to));
    (void)memcpy((void *)(s + (u - to)), (void *)t, len);
    (void)strcpy(s + (u - to) + len, u + 1);
    (void)memmove((void *)name, (void *)s, strlen(s) + 1);
  }
}

/* Now preliminary file/referrer aliasing, to add prefix & query string */
choice prealias(Memman *mm, Memman *mmv, Hashentry *vhost, Memman *mmq,
		logical case_insensitive, char *prefix, size_t prefixlen,
		int pvpos, Include *argshead) {
  extern Hashentry *blank_entry;
  size_t len, len2;
  char *curr, *next, *c;

  /* first, fold to lower case */
  if (case_insensitive) {
    for (c = mm -> curr_pos; *c != '\0' && *c != '?'; c++)
      *c = tolower(*c);
  }
  /* then add prefix */
  if (prefix != NULL) {
    len = prefixlen;
    if (pvpos >= 0) {
      if (ENTRY_BLANK(vhost))
	return(ERR); /* %v in prefix but no vhost => corrupt */
      else {
	len2 = strlen((char *)(mmv -> curr_pos));
	len += len2 - 2;
      /* NB vhost may be marked for deletion (next_pos == curr_pos), but has
	 not yet overwritten. */
      }
    }
    curr = (char *)(mm -> curr_pos);
    next = (char *)(mm -> next_pos);
    if ((char *)(mm -> block_end) - (char *)(mm -> next_pos) <
	(ptrdiff_t)len) {
      c = (char *)submalloc(mm, len);
      mm -> next_pos = (void *)((char *)(mm -> curr_pos) + (next - curr));
      if ((char *)(mm -> block_end) - (char *)(mm -> next_pos) <
	  (ptrdiff_t)len)
	return(ERR); /* filename + prefix too long => corrupt */
    }
    (void)memmove((void *)((char *)(mm -> curr_pos) + len), (void *)curr,
		  (size_t)(next - curr));
    if (pvpos < 0)
      (void)memmove(mm -> curr_pos, (void *)prefix, prefixlen);
    else {
      (void)memmove(mm -> curr_pos, (void *)prefix, (size_t)pvpos);
      (void)memmove((void *)((char *)(mm -> curr_pos) + pvpos),
		    mmv -> curr_pos, len2);
      (void)memmove((void *)((char *)(mm -> curr_pos) + pvpos + len2),
		    (void *)(prefix + pvpos + 2),
		    prefixlen - (size_t)pvpos - 2);
    }
    mm -> next_pos = (void *)((char *)(mm -> next_pos) + len);
  }
  /* finally, add or delete query string */
  if ((char *)(mmq -> next_pos) - (char *)(mmq -> curr_pos) > 1 &&
      (((char *)(mmq -> curr_pos))[0] != '-' ||
       ((char *)(mmq -> curr_pos))[1] != '\0')) {
    /* length >= 1 and not just "-" */
    if (included(mm -> curr_pos, FALSE, argshead)) {
      len = (size_t)((char *)(mmq -> next_pos) - (char *)(mmq -> curr_pos));
      if ((char *)(mm -> block_end) - (char *)(mm -> next_pos) <
	  (ptrdiff_t)len) {
	curr = (char *)(mm -> curr_pos);
	next = (char *)(mm -> next_pos);
	(void)memmove(submalloc(mm, len), (void *)curr, (size_t)(next - curr));
	mm -> next_pos = (void *)((char *)(mm -> curr_pos) + (next - curr));
	if ((char *)(mm -> block_end) - (char *)(mm -> next_pos) <
	    (ptrdiff_t)len)
	  return(ERR); /* filename + query string too long => corrupt */
      }
      *((char *)(mm -> next_pos) - 1) = '?';
      (void)memmove(mm -> next_pos, mmq -> curr_pos, len);
      mm -> next_pos = (void *)((char *)(mm -> next_pos) + len);
    }
    mmq -> next_pos = mmq -> curr_pos;
  }
  else if ((c = strchr((char *)(mm -> curr_pos), '?')) != NULL) {
    *c = '\0';
    if (included(mm -> curr_pos, FALSE, argshead))
      *c = '?';
    else
      mm -> next_pos = c + 1;
  }
  return(OK);
}

void reverseonename(Hashindex *p) {
  extern Memman *xmemman;
  static char *s = NULL;
  static size_t len = 0;
  char *t1, *t2, *t3;
  size_t l, m = 0;
  logical done;

  l = strlen(p -> name);                             /* numerical host */
  if (isdigit(*(p -> name + l - 1))  && isdigit(*(p -> name))) {
    t1 = p -> name;
    t2 = t1;
    t3 = t1;
    while (*t3 == '0')
      t3++;
    for (done = FALSE; !done; t2++) {
      if (*t2 == '.') {
	ENSURE_LEN(s, len, m + (t2 - t1) + 3);
	for (l = t2 - t1; l < 3; l++)
	  *(s + (m++)) = '0';
	(void)memcpy((void *)(s + m), (void *)t3, (size_t)(t2 - t3 + 1));
	m += t2 - t3 + 1;
	t2++;
	t1 = t2;
	t3 = t2;
	while (*t3 == '0')
	  t3++;
      }
      else if (*t2 == '\0') {
	ENSURE_LEN(s, len, m + (t2 - t1) + 3);
	for (l = t2 - t1; l < 3; l++)
	  *(s + (m++)) = '0';
	(void)memcpy((void *)(s + m), (void *)t3, (size_t)(t2 - t3 + 1));
	m += t2 - t3 + 1;
	if (strlen(p -> name) < (l = strlen(s)))
	  p -> name = (char *)submalloc(xmemman, l + 1);
	(void)memcpy((void *)(p -> name), (void *)s, m);
	done = TRUE;
      }
    }
  }
  else {
    ENSURE_LEN(s, len, l + 1);
    for (t1 = p -> name + l, t2 = t1, done = FALSE; !done;
	 t1--) {
      if (*t1 == '.') {
	(void)memcpy((void *)(s + m), (void *)(t1 + 1), (size_t)(t2 - t1 - 1));
	m += t2 - t1;  /* including the dot below */
	t2 = t1;
	*(s + m - 1) = '.';
      }
      if (t1 == p -> name) {
	(void)memcpy((void *)(s + m), (void *)t1, (size_t)(t2 - t1));
	m += t2 - t1 + 1;
	*(s + m - 1) = '\0';
	(void)memcpy((void *)(p -> name), (void *)s, m);
	done = TRUE;
      }
    }
  }
}

void reversenames(Hashindex *ans) {
  Hashindex *p;
  for (p = ans; p != NULL; TO_NEXT(p))
    reverseonename(p);
}
