/*** analhea2.h; header file for analog version 3.11 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/ */

/*** These things are not intended to be user definable;
     user definable headers are in analhead.h ***/

#ifndef ANALHEAD2
#define ANALHEAD2

/*** OS specific things ***/

#define VNUMBER "3.11"    /* the version number of this program */

#undef VERSION /* If no OS set, compilation will fail by not knowing VERSION */

#ifdef __MWERKS__
#undef MAC
#define MAC        /* So MWERKS compiler automatically switches to Mac */
#endif
#ifdef __BEOS__
#undef MAC
#define BEOS
#endif
#ifdef _WIN32
#undef WIN32
#define WIN32
#endif

#ifdef MAC
#define MAC_EVENTS
#define NOPIPES
#define MACDIRENT
#define LINE_PARSER
#define USE_ZLIB
#include <MacHeaders.h>
#include <sioux.h>
#define DIRSEP ':'
#define EXTSEP "."
#define VERSION VNUMBER"/Mac"
#endif

#ifdef DOS
#define NODNS
#define DIRSEP '\\'
#define EXTSEP "."
#define VERSION VNUMBER"/DOS"
#endif

#ifdef VMS
#define NOPIPES
#ifdef __VMS_VER
#ifdef __DECC_VER
#if ((__VMS_VER / 10000000) >= 7 && (__DECC_VER >= 50600000))
#undef NOPIPES
#endif
#endif
#endif
#define VMSDIRENT
#define DIRSEP '/'
#define EXTSEP "."
#define VERSION VNUMBER"/VMS"
#endif

#ifdef UNIX
#define DIRSEP '/'
#define EXTSEP "."
#define VERSION VNUMBER"/Unix"
#endif

#ifdef WIN32
#define popen _popen
#define pclose _pclose
extern void Win32Init(void);
extern void Win32Cleanup(void);
#define WIN32DIRENT  /* can comment out if POSIX dirent present, eg Borland */
#define DIRSEP '\\'
#define EXTSEP "."
#define VERSION VNUMBER"/Win32"
#endif

#ifdef OS2
#define VERSION VNUMBER"/OS2"
#define DIRSEP '\\'
#define EXTSEP "."
#endif

#ifdef RISCOS
#define NODNS
#define NOPIPES
#define NODIRENT
#define DIRSEP '.'
#define EXTSEP "/"
#define VERSION VNUMBER"/RISCOS"
#endif

#ifdef BEOS
#define DIRSEP '/'
#define EXTSEP "."
#define VERSION VNUMBER"/BeOS"
#endif

#ifdef BS2000
#define EBCDIC
#define DIRSEP '/'
#define EXTSEP "."
#define VERSION VNUMBER"/BS2000/OSD"
#endif

/*** ANSI header files ***/

#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <float.h>
#include <time.h>

/*** system dependent header files ***/

#ifdef WIN32
#include <windows.h>
#endif

#ifdef MAC
#ifdef LINE_PARSER
#ifndef REAL_STDIO
#define fopen(name,mode) mac_fopen((name),(mode))
#define fread(ptr,siz,num,file) mac_fread(ptr,siz,num,file)
#undef getc
#define getc(file) mac_getc(file)
#define fclose(file) mac_fclose((file))
#endif
extern FILE *mac_fopen(const char *name,const char *mode);
extern size_t mac_fread(void *ptr, size_t size, size_t num, FILE *file);
extern int mac_getc(FILE *file);
extern int mac_fclose(FILE *file);
#endif
#ifndef REAL_ALLOC
#define malloc(size) mac_malloc((size))
#define calloc(num,size) mac_calloc((num),(size))
#define realloc(ptr,size) mac_realloc((ptr),(size))
#define free(ptr) mac_free((ptr))
#endif
extern void *mac_malloc(size_t size);
extern void *mac_calloc(size_t num, size_t size);
extern void *mac_realloc(void *ptr, size_t size);
extern void mac_free(void *ptr);
#endif

#ifndef NODIRENT
#ifndef VMSDIRENT
#ifndef MACDIRENT
#ifndef WIN32DIRENT
#include <sys/types.h>       /* POSIX dirent */
#include <dirent.h>
#include <sys/stat.h>
#else
#include <io.h>              /* Win32 dirent */
#include <sys/types.h>
#include <sys/stat.h>
#endif
#else
#include "macdir.h"          /* Mac dirent */
#endif
#else
#define VMS_FSPEC_MAX 256    /* VMS dirent */
#include <descrip.h>
#endif
#endif

#ifndef NODNS
#ifdef MAC
#include <Gestalt.h>         /* Mac DNS */
#include <MacTCP.h>
#include <OpenTransport.h>
#include <OpenTptInternet.h>
#include <AddressXlation.h>
#else
#ifdef WIN32    /* Win32 DNS: windows.h above includes winsock.h */
#define INET_ADDR_ERR INADDR_NONE
#else
#include <sys/socket.h>      /* Normal DNS */
#include <netinet/in.h>
#include <netdb.h>
#ifndef BEOS
#include <arpa/inet.h>
#endif
#define INET_ADDR_ERR (-1)
#endif
#endif
#endif

/*** User-definable header file ***/

#include "analhead.h"

/*** definitions ***/

#undef TRUE
#define TRUE (1)
#undef FALSE
#define FALSE (0)
#undef OK
#define OK (0)
#undef ERR
#define ERR (-1)
#undef UNSET
#define UNSET (-1)
#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS (0)   /* ANSI, but some broken implementations lack it. */
#endif
#ifndef EXIT_FAILURE
#define EXIT_FAILURE (1)
#endif
#define REDIRECT (2)
#define NEWLOGFMT (2)
#define INFO (3)
#define BADLOGFMT (3)
#define BLOCK_EPSILON (30)
#define IGNORE_CODE (1000)
#define EPSILON (1e-8)
#define MINS_IN_WEEK (10080)
#define HASHSIZE (8)      /* initial size of hash table; a power of 2 */
#define TREEHASHSIZE (3)  /* a power of 2 plus 1 */
#define SIZEBINS (11)     /* in sizescore() */
#define ITEMFNS_NUMBER (ITEM_NUMBER + 3) /* in inpfns[] in init.c */
#define ANALOGURL "http://www.statslab.cam.ac.uk/~sret1/analog/"
#define FIRST_TIME (0)
#define LAST_TIME (ULONG_MAX)
#define WHITESPACE ((char)(-1))
#ifdef MAC_EVENTS
#define MAC_IDLE_FREQ (200)
#endif

/*** logfile line types ***/

#define LOG_COMMON1 "%S %j %u [%d/%M/%Y:%h:%n:%j] \"%j %r %j\" %c %b"
#define LOG_COMMON2 "%S %j %u [%d/%M/%Y:%h:%n:%j] \"%j %r\" %c %b"
#define LOG_COMMON3 "%S %j %u [%d/%M/%Y:%h:%n:%j] \"%r\" %c %b"
#define LOG_MS_COMMON1 "%S %j %u [%d/%M/%Y:%h:%n:%j] \"%j %r \"HTTP%j\" %c %b"
#define LOG_COMBINED1 \
  "%S %j %u [%d/%M/%Y:%h:%n:%j] \"%j %r %j\" %c %b \"%f\" \"%B\""
#define LOG_COMBINED2 \
  "%S %j %u [%d/%M/%Y:%h:%n:%j] \"%j %r\" %c %b \"%f\" \"%B\""
#define LOG_COMBINED3 \
  "%S %j %u [%d/%M/%Y:%h:%n:%j] \"%r\" %c %b \"%f\" \"%B\""
#define LOG_MS_INT1 \
  "%S, %u, %d/%m/%y, %h:%n:%j, W3SVC%j, %j, %v, %j, %j, %b, %c, %j, %j, %r, %q,"
#define LOG_MS_INT2 \
  "%*S, %*u, %d/%m/%y, %h:%n:%j, %j"
#define LOG_MS_NA1 \
  "%S, %u, %m/%d/%y, %h:%n:%j, W3SVC%j, %j, %v, %j, %j, %b, %c, %j, %j, %r, %q,"
#define LOG_MS_NA2 \
  "%*S, %*u, %m/%d/%y, %h:%n:%j, %j"
#define LOG_WEBSTAR1 "!!LOG_FORMAT%x2"
#define LOG_WEBSTAR2 "!!%j"
#define LOG_EXTENDED1 "#Fields:%x3"
#define LOG_EXTENDED2 "#%j"
#define LOG_MS_EXTENDED1 "#Fields:%x5"
#define LOG_NP_NA1 "%h:%n %aM\t%m/%d/%y\t%S\tHTTP\t\t%C\t%j\t\n%R\nReferer: %f"
#define LOG_NP_NA2 "%h:%n %aM\t%m/%d/%y\t%S\tHTTP\t\t%C\t%j\t\n%R"
#define LOG_NP_NA3 "%h:%n %aM\t%m/%d/%y\t%S\tHTTP\t\t%C\t%R"
#define LOG_NP_INT1 \
  "%h:%n %am\t%d/%m/%y\t%S\tHTTP\t\t%C\t%j\t\n%R\nReferer: %f"
#define LOG_NP_INT2 "%h:%n %am\t%d/%m/%y\t%S\tHTTP\t\t%C\t%j\t\n%R"
#define LOG_NP_INT3 "%h:%n %am\t%d/%m/%y\t%S\tHTTP\t\t%C\t%R"
#define LOG_NP_BOTH4 "%j"
#define LOG_NETSCAPE "format=%x4"
#define LOG_REFERRER1 "[%d/%M/%Y:%h:%n:%j] %F -> %*r"
#define LOG_REFERRER2 "%F -> %*r"
#define LOG_BROWSER1 "[%d/%M/%Y:%h:%n:%j] %B"
#define LOG_BROWSER2 "%B"

/*** enums ***/

/* Types of item and other inputs: must have ITEMs in process_data() order:
   then code, bytes, am and date in some order: then rest in some order. */
/* See also item_type in init.c; and anlgform.c */
enum {ITEM_VHOST, ITEM_FILE, ITEM_USER, ITEM_REFERRER, ITEM_BROWSER, ITEM_HOST,
      INP_CODE, INP_BYTES, INP_AM, INP_DATE, INP_YEAR, INP_MONTH, INP_HOUR,
      INP_MIN, INP_QUERY, INP_NUMBER};
#define ITEM_NUMBER (INP_CODE)
#define INPUT_NUMBER (INP_YEAR)

/* Types of report: must have date reports then GENSUM then other reports,
   finishing with SIZE and CODE in some order. */
/* See also repcodes and repname in init.c; and anlgform.c */
enum {REP_MONTH, REP_WEEK, REP_DAYREP, REP_DAYSUM, REP_HOURREP,	REP_HOURSUM,
      REP_QUARTER, REP_FIVE, REP_GENSUM, REP_REQ, REP_REDIR, REP_FAIL,
      REP_TYPE, REP_DIR, REP_HOST, REP_DOM, REP_REF, REP_REFSITE, REP_REDIRREF,
      REP_FAILREF, REP_BROWREP, REP_BROWSUM, REP_VHOST, REP_USER, REP_FAILUSER,
      REP_SIZE, REP_CODE, REP_NUMBER};
#define DATEREP_NUMBER (REP_GENSUM)
#define FIRST_GENREP (REP_GENSUM + 1)
#define GENREP_NUMBER (REP_NUMBER - FIRST_GENREP)
#define LAST_NORMALREP (REP_FAILUSER)

/* Counts then dates collected about each item, and then other floor/sort
   criteria: order otherwise insignificant. See also methodname in init.c */
enum {REQUESTS, PAGES, REDIR, FAIL, SUCCDATE, REDIRDATE, FAILDATE, BYTES,
	ALPHABETICAL, RANDOM, METHOD_NUMBER};
#define COUNT_NUMBER (SUCCDATE)
#define DATESORT (SUCCDATE)
#define DATA_NUMBER (BYTES)

/* Data collected about total requests etc. in each logfile */
enum {LOGDATA_UNWANTED, LOGDATA_UNKNOWN, LOGDATA_UNKNOWN7, LOGDATA_INFO,
      LOGDATA_INFO7, LOGDATA_SUCC, LOGDATA_SUCC7, LOGDATA_PAGES,
      LOGDATA_PAGES7, LOGDATA_REDIR, LOGDATA_REDIR7, LOGDATA_FAIL,
      LOGDATA_FAIL7, LOGDATA_CORRUPT, LOGDATA_NUMBER};

/* Possible columns: COL_TITLE must be first. */
enum {COL_TITLE, COL_REQS, COL_PAGES, COL_BYTES, COL_PREQS, COL_PPAGES,
	COL_PBYTES, COL_DATE, COL_NUMBER};

/* Levels of DNS lookup */
enum {DNS_NONE, DNS_READ, DNS_LOOKUP, DNS_WRITE};

/* Output types: start with HTML then ASCII */
enum {HTML, ASCII, COMPUTER, OUT_NONE};

/* days of the week */
enum {SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY};

/* languages */
enum {ENGLISH, US_ENGLISH, FRENCH, GERMAN, ITALIAN, SPANISH, DANISH,
      FLEMISH, CATALAN, SLOVENE, RUSSIAN, FINNISH, NORWEGIAN, NYNORSK,
      SWEDISH, PORTUGUESE, BR_PORTUGUESE, HUNGARIAN, CZECH, SLOVAK, POLISH,
      ROMANIAN, GREEK, TURKISH, CHINESE};

/* lngstrs; charset_ must be first */
enum {charset_, weekbeg_, month_, day_, days_, hr_, minute_, minutes_, second_,
      seconds_, byte_, bytes_, request_, requests_, date_, datetime_,
      lastdate_, lasttime_, file_, files_, host_, hosts_, vhost_, vhosts_,
      dir_, dirs_, dom_, doms_, ext_, exts_, url_, urls_, browser_, browsers_,
      size_, site_, sites_, user_, users_, code_, codes_, webstatsfor_,
      gensum_, monthrep_, busymonth_, weekrep_, busyweek_, daysum_, dayrep_,
      busyday_, hourrep_, hoursum_, busyhour_, quarter_, busyquarter_, five_,
      busyfive_, hostrep_, hostgs_, hostgp_, hostgen_, dirrep_, dirgs_, dirgp_,
      dirgen_, typerep_, extgs_, extgp_, extgen_, reqrep_, filegs_, filegp_,
      filegen_, redirrep_, redirgs_, redirgp_, redirgen_, failrep_, failgs_,
      failgp_, failgen_, refrep_, refgs_, refgp_, refgen_, refsiterep_,
      refsitegs_, refsitegp_, refsitegen_, redirrefrep_, redirrefgs_,
      redirrefgp_, redirrefgen_, failrefrep_, failrefgs_, failrefgp_,
      failrefgen_, vhostrep_, vhostgs_, vhostgp_, vhostgen_, userrep_, usergs_,
      usergp_, usergen_, failuserrep_, failusergs_, failusergp_, failusergen_,
      browsum_, browgs_, browgp_, browgen_, browrep_, browrepgs_, browrepgp_,
      browrepgen_, domrep_, domgs_, domgp_, domgen_, statrep_, codegs_,
      codegp_, codegen_, sizerep_, credit_, runtime_, lessone_, eachunit_,
      represents_, partof_, pagereq_, pagereqs_, notlistedm_, notlistedf_,
      notlistedn_, progstart_, reqstart_, to_, succreqs_, avereqs_, totpages_,
      avepages_, totunknown_, totfails_, totredirs_, inforeqs_, distfiles_,
      disthosts_, corrupt_, unwanted_, totdata_, avedata_, brackets_,
      sevendaysto_, lastsevendays_, goto_, top_, nreqs_, preqs_, npgs_, ppgs_,
      nbytes_, pbytes_, firstsm_, firstsf_, firstsn_, firstdsm_, firstdsf_,
      firstdsn_, allsm_, allsf_, allsn_, floorby_, atleast_, redirreq_,
      redirreqs_, failreq_, failreqs_, ptraffic_, pmtraffic_, btraffic_,
      sincedate_, sinceredirdate_, sincefaildate_, sortedm_, sortedf_,
      sortedn_, traffic_, prequests_, pmrequests_, nrequests_, ppages_,
      pmpages_, npages_, predirs_, pmredirs_, nredirs_, pfails_, pmfails_,
      nfails_, succdate_, redirdate_, faildate_, alphasortm_, alphasortf_,
      alphasortn_, numsortm_, numsortf_, numsortn_, unsortedm_, unsortedf_,
      unsortedn_, colon_, datefmt1_, datefmt2_, dayrepfmt_, hourrepfmt_,
      quarterfmt_, weekfmt_, monthfmt_, genrepfmt_, whatincfmt_,
      LNGSTR_NUMBER};

/* return codes from strtoinfmt() */
enum {FMT_OK, FMT_NOPC, FMT_DUP, FMT_BADCHAR, FMT_NOTERM, FMT_BADBUILTIN,
      FMT_BADPC, FMT_PARTTIME, FMT_QBUTNOR};

/*** typedefs ***/

typedef unsigned char logical;
typedef signed char choice;
typedef unsigned int datecode_t;
typedef unsigned long timecode_t;
typedef void (*cutfnp)(char **, char **, char *, logical);
typedef struct hashindex *(*mergefnp)(struct hashindex *, struct hashindex *,
				      unsigned long, unsigned long, choice);
typedef void (*conffnp)(void *, char *, char *, char *, int);
typedef choice (*inputfnp)(FILE *, void *, char);

/*** structs ***/

typedef struct {
  char *name;
  conffnp fn;
  void *opt;
} Configfns;

typedef struct {
  char code;
  choice type;
  inputfnp fn;
  void *opt;
} Inputfns;

typedef struct inputformat {
  Inputfns *inpfns;
  char sep;
  struct inputformat *next;
} Inputformat;

typedef struct inputformatlist {
  Inputformat *form;
  choice count[INPUT_NUMBER]; /* 0 = not present, 1 = starred, 2 = unstarred */
  logical used;
  struct inputformatlist *next;
} Inputformatlist;

typedef struct filelist {
  char *name;
  Inputformatlist *format;
  timecode_t from, to;
  unsigned long data[LOGDATA_NUMBER];
  double bytes, bytes7;
  char *prefix;
  size_t prefixlen;
  int pvpos, tz;
  logical ispipe;
  struct filelist *next;
} Filelist;

typedef struct mmlist {
  void *pos;
  struct mmlist *next;
} Mmlist;

typedef struct {
  void *block_end, *curr_pos, *next_pos;
  Mmlist *first, *last;
  choice alignment;
} Memman;

typedef struct daysdata {
  unsigned long *reqs, *pages;
  double *bytes;
  struct daysdata *prev, *next;
} Daysdata;

typedef struct {
  char *fromstr, *tostr;
  timecode_t from, to, last7, firsttime, lasttime;
  datecode_t firstdate, lastdate, currdate;
  /* perhaps bad name: currdate is date of current logfile entry */
  Daysdata *firstdp, *lastdp, *currdp;
} Dateman;

typedef struct {
  unsigned long reqs[SIZEBINS], pages[SIZEBINS];
  double bytes[SIZEBINS];
  timecode_t lastdate[SIZEBINS];
} Sizedata;

typedef struct timerep {
  unsigned long reqs, pages;
  double bytes;
  datecode_t date;
  struct timerep *prev, *next;
} Timerep;

typedef struct {
  unsigned int code;
  char *description;
  unsigned long n;
  timecode_t lastdate;
} Statuscodes;

typedef struct {
  unsigned long data[DATA_NUMBER];  /* some are really timecode_t */
  double bytes;
  choice ispage;
} Hashentry;

typedef struct hashindex {
  char *name;
  Hashentry *own;
  void *other;
  struct hashindex *next;
} Hashindex;

typedef struct {
  Hashindex **head;
  unsigned long size;
  unsigned long n;
} Hashtable;

typedef struct {
  Hashtable *tree;
  cutfnp cutfn;
  Memman *space;
} Tree;

typedef struct strlist {
  char *name;
  struct strlist *next;
} Strlist;

typedef struct alias {
  char *from, *to;
  struct alias *next;
} Alias;

typedef struct include {
  char *name;
  logical in;
  struct include *next;
} Include;

typedef struct {
  double min;
  char qual;
  choice floorby;
} Floor;

typedef struct {
  choice code;
  char *file;
} Lang;

typedef struct {
  char *outfile, *cacheoutfile, *domainsfile, *headerfile, *footerfile;
  choice outstyle;
  logical html;
  choice reporder[REP_NUMBER + 1];
  logical repq[REP_NUMBER], gotoq, last7;
  choice cols[REP_NUMBER][COL_NUMBER];
  unsigned int rows[DATEREP_NUMBER];
  char graph[DATEREP_NUMBER];
  logical back[DATEREP_NUMBER];
  choice sortby[GENREP_NUMBER], subsortby[GENREP_NUMBER];
  Floor floor[GENREP_NUMBER], subfloor[GENREP_NUMBER];
  Lang lang;
  char **dayname, **monthname, **lngstr;
  size_t daylen, plaindaylen, monthlen, plainmonthlen;
  char *hostname, *hosturl, *logo, *imagedir;
  char markchar;
  logical rawbytes;
  choice weekbeginson;
  unsigned int pagewidth, mingraphwidth;
  char sepchar, repsepchar, decpt;
  char *compsep;
  Tree *tree[GENREP_NUMBER];
  choice *alltrees;
  Include *wanthead[GENREP_NUMBER];
  Alias *aliashead[GENREP_NUMBER];
  Include *link, *reflink;
  char *baseurl;
} Outchoices;

typedef struct {
  Filelist *logfile;
  Filelist *cachefile;
  unsigned long data[LOGDATA_NUMBER];
  double bytes, bytes7;
  char *dirsuffix;
  unsigned int dirsufflength;
  choice lowmem[ITEM_NUMBER];
  logical case_insensitive;
  unsigned int granularity;
  logical form;
} Miscoptions;

typedef struct {
  Hashtable *hash[ITEM_NUMBER];
  Hashindex **gooditems, **baditems;
  Include *wanthead[ITEM_NUMBER], *ispagehead, *argshead, *refargshead;
  Alias *aliashead[ITEM_NUMBER];
  Dateman dman;
  Sizedata *sizes;
  Outchoices outopts;
  Miscoptions miscopts;
} Options;

/*** macros ***/

#undef MAX
#define MAX(a, b) (((a) > (b))?(a):(b))
#undef MIN
#define MIN(a, b) (((a) < (b))?(a):(b))
#ifdef NOSTRCMP
#define STRCMP my_strcmp
#else
#define STRCMP strcmp
#endif
#define STREQ(s, t) (STRCMP(s, t) == 0)
#define DAYOFWEEK(d) ((choice)(((d) + 3) % 7))   /* by defns. in dates.c */
#define STRINGCPY(s, t) (void)strncpy((s), (t), MAX_STRING_LENGTH); \
                        (s)[MAX_STRING_LENGTH - 1] = '\0';
#define IS_EMPTY_STRING(s) ((s)[0] == '\0')
#define IS_STDIN(s) (STREQ((s), "-") || STREQ((s), "stdin"))
#define TO_NEXT(x) (x) = (x) -> next
#define ENTRY_WANTED(e) ((e) != unwanted_entry)
#define ENTRY_BLANK(e) ((e) == blank_entry)
#define LEN3(n, c) ((unsigned int)((c == '\0')?(n):((n) + (((n) - 1) / 3))))
/* The length of an n digit number with seps; e.g. 56789 [5] -> 56,789 [6] */
#define DEFAULTSTR(s, n) {s = NULL; configstr(&(s), NULL, n, NULL, -1);}
#define TOO_FULL(n, z) ((n) > (z))   /* defn for hash table too full */
#define TOO_FULL_TREE TOO_FULL
#define NEW_SIZE(z) (2 * (z))        /* new size of the hash table */
#define NEW_SIZE_TREE(z) (2 * (z) - 1)
/* static char *s = NULL; static size_t len = 0; ENSURE_LEN(s, len, req_len) */
#define ENSURE_LEN(s, l, n) if ((n) > (l)) { \
                              s = (char *)xrealloc((void *)s, n); \
			      l = n;}
/* These PUT's are used in datesprintf() etc.: quicker than using sprintf() */
#define PUT02d(s, d) {*((s)++) = ((d) / 10) + '0'; \
			*((s)++) = ((d) % 10) + '0'; }
#define PUT04d(s, d) {*((s)++) = ((d) / 1000) + '0'; \
			*((s)++) = ((d) / 100) % 10 + '0'; \
			*((s)++) = ((d) / 10) % 10 + '0'; \
			*((s)++) = ((d) % 10) + '0'; }
#define PUT2d(s, d) {*((s)++) = ((d) < 10)?' ':(((d) / 10) + '0'); \
		       *((s)++) = ((d) % 10) + '0'; }
#define PUTc(s, c) {*((s)++) = (c); }
#define PUTs(s, t, n) {int z; size_t l = strlen(t); \
			  (void)memcpy((void *)s, (void *)t, l); s += l; \
                          for (z = n; z > 0; z--) *((s)++) = ' '; }
/* used in tree.c: see newtreedata() */
#define IS_REUSED(i) ((i) -> ispage > 8)
/* Some simple command line processing parts implemented as macros */
#define CLSHORTWARN(arg) warn('C', "No argument specified after %s command line option (or space wrongly left before argument)", arg)
#define CLLONGWARN(arg) warn('C', "Command line argument %s too long: ignoring end of it", arg)
#define CLSHORTCHECK(command) if (argv[i][2] == '\0') CLSHORTWARN(argv[i]); \
                              else command
#define CLLONGCHECK(command) if (argv[i][2] != '\0') CLLONGWARN(argv[i]); \
                            command
#define CLTOGGLE(f) CLLONGCHECK(f = (argv[i][0] == '+')?TRUE:FALSE)
#define CLREPTOGGLE(n) CLTOGGLE(op -> outopts.repq[n])
#define CLOUTSTYLE CLTOGGLE
/* this happens to work because ASCII == TRUE and HTML == FALSE */
/* abbreviations for output */
#define PRESTART() if (outstyle == HTML) (void)fputs("<pre><tt>\n", outf);\
                   else if (outstyle == ASCII) (void)fputc('\n', outf);
#define PREEND() if (outstyle == HTML) (void)fputs("</tt></pre>\n", outf);
/* an abbreviation for arrays with size GENREP_NUMBER */
#define G(r) ((r) - FIRST_GENREP)
/* magicno as macro not fn. for speed: x is unsigned long to contain answer,
   s is (char *) to be magicked,
   b is unsigned long base (no. of hash bins); power of 2 in practice.
   Formula is (\sum_i 9^i c_i) [mod (ULONG_MAX + 1)] mod b */
#define MAGICNO(x, s, b) {register unsigned char *r; \
		    for(x = 0, r = (unsigned char *)(s); *r != '\0'; r++) { \
		    x = (x << 3) + x + (long)(*r); } \
		    x %= b; }
/* for tree magic number, t is end of string, bins are power of 2 plus 1,
   and formula has 33 in place of 9 */
#define MAGICNOTREE(x, s, t, b) {register unsigned char *r; \
		    for(x = 0, r = (unsigned char *)(s); \
			r < (unsigned char *)(t); r++) { \
		    x = (x << 5) + x + (long)(*r); } \
		    x %= (b - 1); x++; }

/*** function declarations ***/

/* in alias.c */
extern choice do_alias(char *name, Memman *mp, Alias *aliashead,
  char *dirsuffix, unsigned int dirsufflength, choice type);
extern void do_aliasx(char *name, Alias *aliashead);
extern logical do_aliasr(char *name, char *dirsuffix,
  unsigned int dirsufflength);
extern logical do_aliasS(char *name);
extern logical do_aliasf(char *name);
extern logical do_aliasb(char *name);
extern logical do_aliasv(char *name);
#ifndef NODNS
extern logical dnsresolve(char *name, choice level);
void do_dns(char *name, char *alias, choice level);
#endif
extern void wildalias(char *name, char *from, char *to);
extern choice prealias(Memman *mm, Memman *mmv, Hashentry *vhost, Memman *mmq,
  logical case_insensitive, char *prefix, size_t prefixlen, int pvpos,
  Include *argshead);
extern void reverseonename(Hashindex *p);
extern void reversenames(Hashindex *ans);

/* in analog.c -- only main() */

/* in cache.c */
extern void outputcache(char *outfile, Hashindex **gooditems, Dateman *dman,
  Sizedata *sizes, unsigned long *data, double bys);
extern void hashbuild(unsigned int code, unsigned long *data, double bys,
  Memman *mm, Hashtable **hash, Include *wanthead, Include *ispagehead,
  Alias *aliashead, Tree **tree, choice *alltrees, choice lowmem,
  char *dirsuffix, unsigned int dirsufflength);
extern void corruptcacheline(char *line, choice *rc, choice type);
extern logical parsecacheline(char *linestart, char *parsestart,
  unsigned int *code, unsigned int maxcode, int no_items, unsigned long *data,
  double *bys, Memman *mm);
extern void readoldcache(Filelist *cachefilep, FILE *lf, Dateman *dman,
  choice type, unsigned int granularity);
extern void readcache(Filelist *cachefilep, FILE *lf, Hashtable **hash,
  Include **wanthead, Include *ispagehead, Alias **aliashead, Dateman *dman,
  Sizedata *sizes, Tree **tree, choice *alltrees, choice *lowmem,
  char *dirsuffix, unsigned int dirsufflength, unsigned int granularity);

/* in dates.c */
extern void code2date(datecode_t code, unsigned int *date, unsigned int *month,
  unsigned int *year);
extern void nextdate(unsigned int *date, unsigned int *month,
  unsigned int *year);
extern void prevdate(unsigned int *date, unsigned int *month,
  unsigned int *year);
extern time_t shifttime(time_t timer, int diff);
extern choice parsedate(time_t starttime, char *s, timecode_t *date,
  logical from);
extern choice wantdate(timecode_t *timecode, Dateman *dman, unsigned int hr,
  unsigned int min, unsigned int date, unsigned int month, unsigned int year,
  int tz);
extern Daysdata *newday(unsigned int granularity);
extern void dmaninit(Dateman *dman, datecode_t datecode,
  unsigned int granularity);
extern void datehash(timecode_t timecode, Dateman *dman, unsigned long reqs,
  unsigned long pages, double bytes, unsigned int granularity);

/* in hash.c */
extern Hashtable *rehash(Hashtable *old, unsigned long size,
  Memman *treespace);
extern Hashindex *hashfind(Memman *mp, Hashtable **table, Include *wanthead,
  choice ispage, Include *ispagehead, Alias *aliashead, char *dirsuffix,
  unsigned int dirsufflength, choice type, logical aliased);
extern Hashentry *newhashentry(logical ispage);
extern void hashscore(Hashentry *ep, choice outcome, logical ispage,
  timecode_t timecode, double bytes);
extern void unhash(Hashtable *hash, Hashindex **gooditems,
  Hashindex **baditems);
extern void unhashall(Hashtable **hash, Hashindex ***gooditems,
  Hashindex ***baditems);

/* in init.c */
extern void initialise(int argc, char *argv[], Options *op);
extern void globals(char *comnane);
extern void defaults(Options *op);
extern void confline(Options *op, char *cmd, char *arg1, char *arg2, int rc);
extern choice config(char *filename, Options *op);
extern void settings(Options *op, int argc, char *argv[]);
extern Inputformatlist *correctlogfmt(Filelist *lp, Include **wanthead,
  Dateman *dman);
extern void correct(Options *op);
extern void finalinit(Options *op);

/* in init2.c */
extern choice strtoinfmt(Inputformat **ans, char *s, choice *count);
extern void shortwarn(char *cmd, char *arg1, int rc);
extern void longwarn(char *cmd, char *arg1, char *arg2, int rc);
extern void badwarn(char *cmd, char *arg1, char *arg2, int rc);
extern void unknownwarn(char *cmd, char *arg1, char *arg2);
extern void configcall(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configcols(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configallcols(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configsortby(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configdebug(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configonoff(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configall(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configallback(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configcase(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configweekday(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configoutstyle(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
#ifndef NODNS
extern void configdns(void *opt, char *cmd, char *arg1, char *arg2, int rc);
#endif
extern void configlang(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configlogfmt(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configrepord(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configstr(void *opt, char *cmd, char *arg1, char *arg2, int rc);
#ifndef NODIRENT
extern void configwildlogs(void *opt, char *arg1, char *arg2, int rc);
#endif
extern void configlogfile(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configcachefile(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configchar(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configfrom(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configto(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configgraph(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configallgraph(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configfloor(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configtree(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configulong(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configuint(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configoffset(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configlowmem(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configalias(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configaliaslist(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configinex(void *opt, char *cmd, char *arg1, char *arg2, int rc,
  logical in);
extern void configinc(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configexc(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configincd(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configexcd(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configincs(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configexcs(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void clconfline(Options *op, char *s);
extern void clgenrep(Options *op, choice rep, char *arg);
extern void cldebug(char **s, char *arg);
extern void clargs(Options *op, int argc, char *argv[]);

/* in input.c */
extern FILE *my_lfopen(Filelist *p, char *logtype);
extern FILE *my_fopen(char *name, char *logtype);
extern int my_lfclose(FILE *f, Filelist *p, Filelist *allc, Filelist *allp,
  char *filetype, Dateman *dman, unsigned long *totdata, double *bys,
  double *bys7, char **monthname, unsigned int monthlen);
extern int my_fclose(FILE *f, char *name, char *filetype);
extern FILE *logfile_init(Filelist *logfilep);
extern choice getmoredata(FILE *f, char *start, size_t length);
extern choice getnextline(FILE *f, char *start);
extern void shunt_data(FILE *f);
extern int strtomonth(char *month);
extern choice parsemonth(FILE *f, void *arg, char c);
extern choice parseuint2(FILE *f, void *arg, char c);
extern choice parsenmonth(FILE *f, void *arg, char c);
extern choice parseuint2strict(FILE *f, void *arg, char c);
extern choice parseuint3strict(FILE *f, void *arg, char c);
extern choice parseuint4strict(FILE *f, void *arg, char c);
extern choice parseudint(FILE *f, void *arg, char c);
extern choice parseyear(FILE *f, void *arg, char c);
extern choice parseam(FILE *f, void *arg, char c);
extern choice parsecode(FILE *f, void *arg, char c);
extern choice parsejunk(FILE *f, void *arg, char c);
extern choice parsespace(FILE *f, void *arg, char c);
extern choice parseoptspace(FILE *f, void *arg, char c);
extern choice parsenewline(FILE *f, void *arg, char c);
extern void parsenonnewline(FILE *f);
extern choice parsestring(FILE *f, void *arg, char c);
extern choice parsemacfile(FILE *f, void *arg, char c);
extern choice parsemsbrow(FILE *f, void *arg, char c);
extern choice parseref(FILE *f, void *arg, char c);
extern choice checkchar(FILE *f, void *arg, char c);
extern choice parselogfmt(FILE *f, void *arg, char c);
extern choice parsenextrecord(FILE *f, Inputformat *format);
extern int parseconfline(char *s, char **cmd, char **arg1, char **arg2);
extern int nextconfline(FILE *f, char **cmd, char **arg1, char **arg2);
extern char *nextlngstr(FILE *f, char *name);
extern choice nextdnsline(FILE *f, timecode_t *timec, char **name,
  char **alias);
extern void process_domainsfile(FILE *f, Options *op);

/* in macstuff.c (See also macdir.h) */
#ifdef MAC_EVENTS
extern void MacInit(int *argc, char **argv[]);
extern void MacFini(void);
extern void MacIdle(void);
#endif
#ifdef MACDIRENT
extern void CToPCpy(unsigned char *pstr, const char *cstr);
#endif
#ifdef MAC
#ifndef NODNS
extern long OpenNetwork(void);
extern int IpAddr2Name(char *hostname);
extern void ResolverCleanup(void);
extern pascal void SvcNotifyProc(void *dataPtr, OTEventCode code,
  OTResult result, void *cookie);
extern pascal void MacTCPDNRResultProc(struct hostInfo *hInfoPtr,
  char *userDataPtr);
#endif
#endif

/* in output.c */
extern void output(Outchoices *od, Hashindex **gooditems, Hashindex **baditems,
  Dateman *dman, Sizedata *sizes, unsigned long *sumdata, double totbytes,
  double totbytes7, unsigned int granularity);

/* in output2.c */
extern void pagetop(FILE *outf, Outchoices *od, Dateman *dman);
extern void pagebot(FILE *outf, Outchoices *od);
extern void gotos(FILE *outf, int code, logical gotoq, logical *repq,
  char **lngstr, choice *reporder);
extern void report_title(FILE *outf, char *name, int code, logical gotoq,
  logical *repq, char **lngstr, choice *reporder, choice outstyle);
extern size_t htmlstrlen(char *s, choice outstyle);
extern void matchlength(FILE *outf, choice outstyle, char *s, char c);
extern void htmlfprintf(FILE *outf, choice outstyle, char *s, logical *html,
  logical userinput);
extern void myputc(FILE *outf, char c, choice outstyle);
extern void hrule(FILE *outf, choice outstyle, unsigned int pagewidth);
extern void include_file(FILE *outf, choice outstyle, char *name, char type,
  unsigned int pagewidth, logical *html);
extern unsigned int datefmtlen(char *fmt, unsigned int monthlen,
  unsigned int daylen, char *compsep);
extern char *datesprintf(char *ans, char *fmt, datecode_t date,
  unsigned int hr, unsigned int min, unsigned int newhr, unsigned int newmin,
  char **monthname, char **dayname, unsigned int monthlen, unsigned int daylen,
  char *compsep);
extern void f3printf(FILE *outf, choice outstyle, double x, unsigned int width,
  char sepchar);
extern void doublemprintf(FILE *outf, unsigned int pagewidth, double x,
  char decpt);
extern long findunit(double n, unsigned int pagewidth, unsigned int width[],
  unsigned int mingraphwidth, choice *cols);
extern void calcsizes(choice outstyle, unsigned int width[],
  unsigned int *bmult, long *unit, unsigned long maxr, unsigned long maxp,
  double maxb, unsigned int pagewidth, unsigned int mingraphwidth,
  char graphby, char repsepchar, logical rawbytes, choice *cols,
  unsigned int monthlen, unsigned int daylen, char **lngstr);
extern void declareunit(FILE *outf, choice outstyle, char graphby, long unit,
  unsigned int bmult, char markchar, char sepchar, char *imagedir,
  char **lngstr);
extern void whatincluded(FILE *outf, choice outstyle, unsigned long n,
  unsigned int pagewidth, Floor *floor, choice sortby, char decpt, char *gens,
  char *genp, char gender, choice requests, choice date, timecode_t firsttime,
  char **monthname, char **dayname, unsigned int monthlen, unsigned int daylen,
  char **lngstr);
extern void busyprintf(FILE *outf, choice outstyle, char *datefmt,
  unsigned long reqs, unsigned long pages, double bys, datecode_t date,
  unsigned int hr, unsigned int min, unsigned int newhr, unsigned int newmin,
  char graphby,	char sepchar, logical rawbytes, char **lngstr,
  char **monthname, char **dayname, unsigned int monthlen, unsigned int daylen,
  char *busystr);
extern void pccol(FILE *outf, choice outstyle, double n, double tot,
  unsigned int width, char decpt);
extern void barchart(FILE *outf, choice outstyle, char graphby,
  unsigned long reqs, unsigned long pages, double bys, long unit,
  char markchar, char *imagedir);
extern void colheads(FILE *outf, choice *cols, choice outstyle,
  unsigned int width[], unsigned int bmult, logical rawbytes, char *name,
  logical name1st, char **lngstr);
extern void printcols(FILE *outf, choice rep, choice *cols, choice outstyle,
  unsigned long reqs, unsigned long pages, double bys, unsigned long totr,
  unsigned long totp, double totb, unsigned int width[], unsigned int bmult,
  char graphby, long unit, char markchar, char repsepchar, char decpt,
  char *compsep, logical name1st, logical timegraph, char *imagedir,
  logical html, char *name, logical ispage, unsigned int spaces,
  Alias *aliashead, Include *linkhead, char *baseurl, char *datefmt,
  datecode_t date, unsigned int hr, unsigned int min, unsigned int newhr,
  unsigned int newmin, char **monthname, char **dayname, unsigned int monthlen,
  unsigned int daylen, unsigned int plainmonthlen, unsigned int plaindaylen);
extern void lastseven(FILE *outf, choice outstyle, timecode_t to,
  timecode_t last7, char *compsep, char **monthname, char **dayname,
  unsigned int monthlen, unsigned int daylen, char **lngstr);
extern void distcount(Hashindex *gooditems, Hashindex *baditems,
  unsigned long *tot, unsigned long *tot7, timecode_t last7time);
extern void gensumline(FILE *outf, choice outstyle, int namecode,
  unsigned long x, unsigned long x7, char sepchar, char *compsep, logical p,
  char **lngstr);
extern void gensumlineb(FILE *outf, choice outstyle, int namecode, double x,
  double x7, logical rawbytes, char sepchar, char *compsep, char **lngstr);
extern void gensum(FILE *outf, choice outstyle, logical last7,
  unsigned long *data, double bys, double bys7, Hashindex **gooditems,
  Hashindex **baditems, Dateman *dman, logical rawbytes, char sepchar,
  char *compsep, char **monthname, char **dayname, unsigned int monthlen,
  unsigned int daylen, char **lngstr);
extern void genrep(FILE *outf, choice rep, choice outstyle,
  Hashindex **gooditems, Hashindex **baditems, Alias *aliashead,
  Include *wanthead, choice requests, choice date, Floor *floor, choice sortby,
  logical alphaback, unsigned int pagewidth, char sepchar, char repsepchar,
  char decpt, char *compsep, logical rawbytes, choice *cols, char *colhead,
  char *colheadp, char *gens, char *genp, char gender, logical html,
  timecode_t firsttime, char **monthname, char **dayname,
  unsigned int monthlen, unsigned int daylen, unsigned int plainmonthlen,
  unsigned int plaindaylen, char **lngstr);
extern void subdayrep(FILE *outf, choice rep, Daysdata *firstdp,
  Daysdata *lastdp, datecode_t firstdate, datecode_t lastdate,
  choice outstyle, unsigned int granularity, unsigned int repgran,
  unsigned int pagewidth, unsigned int mingraphwidth, logical back,
  logical rawbytes, choice *cols, unsigned int rows, char graphby,
  char markchar, char sepchar, char repsepchar, char decpt, char *compsep,
  choice weekbeginson, char *imagedir, logical html, char **monthname,
  char **dayname, unsigned int monthlen, unsigned int daylen,
  unsigned int plainmonthlen, unsigned int plaindaylen, char **lngstr,
  char *datefmt, char *colhead, char *busystr);
extern void superdayrep(FILE *outf, choice rep, Daysdata *firstdp,
  Daysdata *lastdp, datecode_t firstdate, datecode_t lastdate,
  choice outstyle, unsigned int granularity, unsigned int pagewidth,
  unsigned int mingraphwidth, logical back, logical rawbytes, choice *cols,
  unsigned int rows, char graphby, char markchar, char sepchar,
  char repsepchar, char decpt, char *compsep, choice weekbeginson,
  char *imagedir, logical html, char **monthname, unsigned int monthlen,
  unsigned int plainmonthlen, char **lngstr, char *datefmt, char *colhead,
  char *busystr);
extern void daysum(FILE *outf, Daysdata *firstdp, datecode_t firstdate,
  datecode_t lastdate, choice outstyle, unsigned int granularity,
  choice weekbeginson, unsigned int pagewidth, unsigned int mingraphwidth,
  logical rawbytes, choice *cols, char graphby, char markchar, char sepchar,
  char repsepchar, char decpt, char *compsep, char *imagedir, logical html,
  char *colhead, char **dayname, unsigned int daylen, char **lngstr);
extern void hoursum(FILE *outf, Daysdata *firstdp, Daysdata *lastdp,
  choice outstyle, unsigned int granularity, unsigned int pagewidth,
  unsigned int mingraphwidth, logical rawbytes, choice *cols, char graphby,
  char markchar, char sepchar, char repsepchar, char decpt, char *compsep,
  char *imagedir, logical html, char *colhead, char **lngstr);
extern void printtree(FILE *outf, choice rep, choice outstyle, Hashtable *tree,
  choice requests, choice date, Hashentry *badp, unsigned long badn,
  unsigned int level, Strlist *partname, Alias *aliashead, Include *linkhead,
  char *baseurl, unsigned long totr, unsigned long totp, double totb,
  unsigned int width[], unsigned int bmult, long unit, char sepchar,
  char repsepchar, char decpt, char *compsep, logical rawbytes, choice *cols,
  char *colhead, char *colheadp, char gender, logical html, char **monthname,
  char **dayname, unsigned int monthlen, unsigned int daylen,
  unsigned int plainmonthlen, unsigned int plaindaylen, char **lngstr);
extern void treerep(FILE *outf, choice rep, choice outstyle, Tree *treex,
  Hashindex *gooditems, Hashindex *baditems, Alias *aliashead,
  Include *wanthead, Include *linkhead, char *baseurl, choice *alltrees,
  choice requests, choice date, Floor *floor, choice sortby, Floor *subfloor,
  choice subsortby, unsigned int pagewidth, char sepchar, char repsepchar,
  char decpt, char *compsep, logical rawbytes, choice *cols, char *colhead,
  char *colheadp, char *gens, char *genp, char gender, logical html,
  timecode_t firsttime, char **monthname, char **dayname,
  unsigned int monthlen, unsigned int daylen, unsigned int plainmonthlen,
  unsigned int plaindaylen, char **lngstr);
extern void sizerep(FILE *outf, choice outstyle, Sizedata *sizes,
  char repsepchar, char decpt, char *compsep, logical rawbytes, choice *cols,
  char *colhead, logical html, char **monthname, char **dayname,
  unsigned int monthlen, unsigned int daylen, unsigned int plainmonthlen,
  unsigned int plaindaylen, char **lngstr);
extern void coderep(FILE *outf, choice outstyle, Floor *floor, choice sortby,
  unsigned int pagewidth, char sepchar, char repsepchar, char decpt,
  char *compsep, choice *cols, char *colhead, char *colheadp, char *gens,
  char *genp, char gender, logical html, timecode_t firsttime,
  char **monthname, char **dayname, unsigned int monthlen, unsigned int daylen,
  unsigned int plainmonthlen, unsigned int plaindaylen, char **lngstr);
extern logical checkonerep(Hashindex *gp, choice requests);
extern void checkreps(logical *repq, Dateman *dman, choice *alltrees,
  Hashindex **gooditems, Sizedata *sizes);

/* in process.c */
extern void process_data(Filelist *logfilep, FILE *lf, Hashtable **hash,
  choice *count, Include **wanthead, Include *ispagehead, Alias **aliashead,
  Include *argshead, Include *refargshead, Dateman *dman, Sizedata *sizes,
  Tree **tree, choice *alltrees, choice *lowmem, logical case_insensitive,
  char *dirsuffix, unsigned int dirsufflength, unsigned int granularity);
extern void corrupt_line(FILE *lf, Filelist *logfilep);
extern void sizescore(Sizedata *sizes, double bytes, timecode_t timecode,
  logical ispage);
extern void codescore(unsigned int code, unsigned long reqs,
		      timecode_t timecode);

/* in settings.c */
extern void report_vbles(Options *op);
extern void report_compile(void);
extern void report_debug(char *type, char *arg);
extern void report_logfiles(Filelist *logfile, logical cache);
extern void report_logformat(FILE *outf, Inputformatlist *format,
  logical inwarn);
extern void report_fromto(Dateman *dman);
extern void report_want(Include *wanthead, char *type, char *indent);
extern void report_alias(Alias *aliashead, char *type, char *indent);
extern void report_lowmem(choice lowmem[ITEM_NUMBER]);
#ifndef NODNS
extern void report_dns(void);
#endif
extern void report_outopts(Outchoices *od);
extern void report_sep(char c, char *type);
extern void report_daterep(Outchoices *od, choice j);
extern void report_genrep(Outchoices *od, choice j);
extern void report_cols(choice *cols);
extern void report_sortby(choice sortby, logical sub);
extern void report_floor(Floor *floor, logical sub);
extern void check_file(char *name);

/* in sort.c */
extern void my_sort(Hashindex **gooditems, Hashindex **baditems,
  Floor *floor, choice sortby, logical alphaback, Include *wanthead,
  choice requests, choice date, unsigned long totr, unsigned long totp,
  double totb, unsigned long maxr, unsigned long maxp, double maxb);
extern Hashindex *my_mergesort(Hashindex *list, unsigned long length,
  choice sortby, mergefnp mergefn);
extern Hashindex *merge(Hashindex *list1, Hashindex *list2,
  unsigned long length1, unsigned long length2, choice sortby);
extern Hashindex *mergea(Hashindex *list1, Hashindex *list2,
  unsigned long length1, unsigned long length2, choice sortby);
extern Hashindex *mergeb(Hashindex *list1, Hashindex *list2,
  unsigned long length1, unsigned long length2, choice sortby);

/* in tree.c */
extern Hashindex *treefind(char *name, char *nameend, Hashtable **tree,
  Hashindex *item, cutfnp cutfn, logical build, logical transient,
  Memman *space);
extern void graft(Hashtable **new, Hashtable *old, Memman *space);
extern void allgraft(Hashtable *t, Memman *space);
extern Hashindex *newtreeentry(char *name, char *nameend, Hashindex *item,
  logical transient, Memman *space);
extern Hashentry *newtreedata(Hashentry *from, Memman *space);
extern void treescore(Hashentry *to, Hashentry *from);
extern Hashindex *sorttree(Hashtable *tree, Floor *floor, choice sortby,
  Floor *subfloor, choice subsortby, Include *wanthead, Alias *notcorrupt,
  choice requests, choice date, unsigned long totr, unsigned long totp,
  double totb, unsigned long maxr, unsigned long maxp, double maxb,
  Hashentry **badp, unsigned long *badn, Memman *space);
extern void maketree(Tree *treex, Hashindex *gooditems, Hashindex *baditems);
extern void maketreename(char *n, Strlist *s, char *c, logical start,
  logical end);
extern logical sublevels(Hashtable *tree);
extern logical genstreq(char *a, char *b, char *t);
extern void rnextname(char **name, char **nameend, char *whole, logical build);
extern void inextname(char **name, char **nameend, char *whole, logical build);
extern void onextname(char **name, char **nameend, char *whole, logical build);
extern void tnextname(char **name, char **nameend, char *whole, logical build);
extern void fnextname(char **name, char **nameend, char *whole, logical build);
extern void bnextname(char **name, char **nameend, char *whole, logical build);

/* in utils.c */
extern void my_exit(int status);
extern logical debug_inc(char c);
extern char *strtoupper(char *n);
extern void strtolowerx(char *n);
extern void toloweralias(Alias *ap, logical both);
extern void tolowerinc(Include *ip);
extern logical strcaseeq(char *s, char *t);
#ifdef NOSTRCMP
extern int my_strcmp(char *s, char *t);
#endif
extern unsigned int chrn(char *s, char c);
extern unsigned int log10i(unsigned int i);
extern unsigned int log10x(double d);
extern unsigned int findbmult(double d);
extern unsigned long arraymaxl(unsigned long *x, unsigned int size);
extern double arraymaxd(double *x, unsigned int size);
extern size_t arraymaxlen(char **s, unsigned int size, choice outstyle);
void prettyprintf(FILE *outf, unsigned int pagewidth, char *s, va_list ap);
extern void mprintf(FILE *outf, unsigned int pagewidth, char *s, ...);
extern void warn(char c, char *s, ...);
extern void error(char *s, ...);
extern void debug(char c, char *s, ...);
extern void *xmalloc(size_t size);
extern void *xrealloc(void *ptr, size_t size);
extern void *submalloc(Memman *m, size_t size);
extern void freemm(Memman *m);
extern logical wildmatch(char *s, char *p);
extern logical genwildmatch(char *s, char *s2, char *p);
extern logical included(char *name, logical ispage, Include *listhead);
extern logical pageq(char *name, Include *ispagehead, choice type);

/* in win32.c */
#ifdef WIN32
extern void Win32Init(void);
extern void Win32Cleanup(void);
#endif  /* WIN32 */
#endif  /* analhea2.h not previously included */
